# Cell broadcast daemon

cellbroadcastd provides a DBus daemon that manages cell broadcast
messages received via ModemManager. It provides a storage for them
and allows configuring channels for the modem to watch out for. It
offers a library (libcellbroadcast) and GObject introspection bindings
to ease using it from applications.

## License

cbd is licensed under the GPLv3+ while the libcellbroadcast library
is licensed under LGPL 2.1+.

## Dependencies

On a Debian based system run

```sh
sudo apt-get -y install build-essential
sudo apt-get -y build-dep .
```

For an explicit list of dependencies check the `Build-Depends` entry in the
[debian/control][] file.

## Building

We use the meson (and thereby Ninja) build system for cellbroadcastd.
The quickest way to get going is to do the following:

```sh
meson setup _build
meson compile -C _build
meson test -C _build
```

## Running

### Running from the source tree

To run the daemon use

```sh
_build/run
```

## Getting in Touch

- Issue tracker: <https://gitlab.freedesktop.org/devrtz/cellbroadcastd/-/issues>
- Matrix: <https://matrix.to/#/#phosh:sigxcpu.org>

## Code of Conduct

Note that as a project hosted on freedesktop.org, cellbroadcastd follows its
[Code of Conduct], based on the Contributor Covenant. Please conduct yourself
in a respectful and civilized manner when communicating with community members
on IRC and bug tracker.

[debian/control]: ./debian/control#L7
[Code of Conduct]: https://www.freedesktop.org/wiki/CodeOfConduct/
