//  ************************************************************************************************
//
//  BornAgain: simulate and fit reflection and scattering
//
//! @file      Fit/Kernel/MinimizerFactory.h
//! @brief     Defines class MinimizerFactory.
//!
//! @homepage  http://www.bornagainproject.org
//! @license   GNU General Public License v3 or higher (see COPYING)
//! @copyright Forschungszentrum Jülich GmbH 2018
//! @authors   Scientific Computing Group at MLZ (see CITATION, AUTHORS)
//
//  ************************************************************************************************

#ifndef BORNAGAIN_FIT_KERNEL_MINIMIZERFACTORY_H
#define BORNAGAIN_FIT_KERNEL_MINIMIZERFACTORY_H

#include <string>
#include <vector>

class IMinimizer;

//! Factory to create minimizers.

class MinimizerFactory {
public:
    static IMinimizer* createMinimizer(const std::string& minimizerName,
                                       const std::string& algorithmType = "",
                                       const std::string& optionString = "");

    static void printCatalog();

    static std::string catalogToString();

    static std::string catalogDetailsToString();

    static std::vector<std::string> algorithmNames(const std::string& minimizerName);

    static std::vector<std::string> algorithmDescriptions(const std::string& minimizerName);
};

#endif // BORNAGAIN_FIT_KERNEL_MINIMIZERFACTORY_H
