#! ../wafe --f
# small example script to demonstrate barplot and label Axis
# Gustaf Neumann  March 9, 1993

mergeResources topLevel {
    *font -b&h-lucida-bold-r-*-*-14-*-*-*-p-*-iso8859-* 
    *shadowWidth 3 
    *background gainsboro 
    *plotAreaColor gainsboro 
    *plot*background gray 
    *.left chainLeft *.top chainTop 
}

Form f topLevel

  Command command1 f { 
      label print callback {  
	  AtPlotterGeneratePostscript xniam.ps plotter1 "testing..." 50 50 350 210 false
      } right chainLeft bottom chainTop 
  }

  Command command2 f { 
      label exit 
      callback quit 
      fromVert command1 right chainLeft bottom chainTop
  }

  AtPlotter plot f {
      legendTitle Legende  legendTitleStyle bold 
      height 450 width 600 
      fromHoriz command1 
      right chainRight bottom chainBottom
  }

  AtAxis axis2 plot {
      label "Gesamtlaufzeit in Sekunden" 
      vertical true 
      drawSubgrid false  drawFrame true  numbersOutside true
  }

  AtLabelAxis axis3 plot {
      label NIAM-Beispiel
      drawGrid false  drawFrame false  ticsOutside false 
  }

  AtBarPlot barPlot1 plot {
      legendName DECstation  fillColor yellow 
      cellOffset -0.4 cellWidth 0.5 shading gray5
  }

  AtBarPlot barPlot2 plot {
      legendName 80486  fillColor green 
      cellOffset -0.15 cellWidth 0.5 shading gray3
  }

sV plot xAxis axis3 yAxis axis2
AtLabelAxisAttachData axis3 5.7-1 5.7-2 5.7-3 5.7-4 5.7-5
AtBarPlotAttachData barPlot1 0.246 0.398 0.192 0.261 0.261
AtBarPlotAttachData barPlot2 0.170 0.280 0.150 0.189 0.189
realize

