# ./mofe --f

set buildingBlocks {
    labeledField
    title
    personEntry
}


set labeledField {
    {glue 5}
    {widget mLabel label}
    {glue 5}
    {widget mText text stretch}
    {glue 5}
}

set title {
    {glue 5}
    {widget mLabel title}
    {glue 5 stretch}

}

set personEntry {
    {box title head}
    {glue 5}
    {box labeledField ssn}
    {glue 5}
    {box labeledField familyName}
    {glue 5}
}


proc makeLayout {
    layoutWidget
    buildingBlock 
    {prefix ""} 
    {direction "vertical"}
} {
    global nextDirection boxOrientation
    set layout ""
    set widgets {}
    set struct  {}
    foreach unit $buildingBlock {
	set type [lindex $unit 0]
	case $type in {
	    box {
		upvar #0 [lindex $unit 1] boxType
		set boxName $prefix[lindex $unit 2]_ 
		set boxParent [expr {$prefix=={} ? "layoutStructure":$prefix}]
		append struct "mRowColumn $boxName $boxParent $boxOrientation($direction) borderPixmap $direction.xbm\n"
		set result [makeLayout $layoutWidget $boxType $boxName \
			    $nextDirection($direction)]
		append layout "$direction{ [lindex $result 0] } "
		set w [lindex $result 1] 
		if {$w!={}} { 
		    set widgets [concat $widgets $w] 
		    append struct [lindex $result 2]
		}
	    }
	    glue {
		set glueValue [lindex $unit 1]
		append layout "$glueValue "
		appendStretch $type layout [lrange $unit 2 end]
		append struct "mPushButton glue $prefix labelString $glueValue\n"
	    }
	    widget {
		set widgetName $prefix[lindex $unit 2]
		set widgetClass [lindex $unit 1]
		append layout "$widgetName "
		appendStretch $type layout [lrange $unit 3 end]
		lappend widgets "$widgetName $widgetClass $layoutWidget"
		append struct "mPushButton widget $prefix labelString $widgetClass\n"
	    }
	}
    }
#    puts stderr $layout
    return [llist $layout $widgets $struct]
}


set stretchValue(glue,stretch)   "<+inf -100%>"
set stretchValue(widget,stretch) "<+inf -100% * +inf -100%>"

set nextDirection(vertical)      "horizontal"
set nextDirection(horizontal)    "vertical"

set boxOrientation(vertical)      "orientation VERTICAL"
set boxOrientation(horizontal)    "orientation HORIZONTAL"

proc appendStretch {type varName varList} {
    global stretchValue
    upvar $varName name
    if {$varList=={}} { return }
    append name "$stretchValue($type,$varList) "
}

proc doLayout {name} {
    global layout widgets struct
    set result [makeLayout $name "{box $name $name}" ]
    set layout  [lindex $result 0]
    set widgets [lindex $result 1]
    set struct  [lindex $result 2]
    puts stderr "layout  = $layout\n\n"
    puts stderr "widgets = $widgets\n\n"
    puts stderr "struct  = $struct\n\n"
}


if ![isWidget layoutStructure] {
    mergeResources topLevel "*XmRowColumn.borderWidth 9"
    mBulletinBoard layoutStructure topLevel
}
