proc Text-type {} { return {creationCommand Widget}}
set wafeHelp(Text) { The 'Text' widget class can be used to display and edit one or more
 lines of text. Options are provided to add Scrollbars, search for a
 specific string and to modify the text in the edit buffer.}

proc XawAsciiSave-type {} { return {function {Boolean} {in: XawTextGetSource(TextWidget)} ## {ascii text widget}}}
set wafeHelp(XawAsciiSave) { The command 'XawAsciiSave' saves the contents of the specified
 Athena Text widget into a file and returns on success 1 and on
 failure 0. This function only works, when the 'type' resource of
 the specified Text widget is set to 'file', as filename the value
 of the resource 'string' is taken. If the buffer has not been
 changed, no action will be taken.}

proc XawAsciiSaveAsFile-type {} { return {function {Boolean} {in: XawTextGetSource(TextWidget)} {in: String} ## {ascii text widget} {file name}}}
set wafeHelp(XawAsciiSaveAsFile) { The command 'XawAsciiSaveAsFile' saves the contents of the
 specified Athena Text widget into a file and returns on success 1
 and on failure 0. This function works, when the 'type' resource of
 the specified Text widget is either set to 'string' or to 'file'.}

proc XawAsciiSourceChanged-type {} { return {function {Boolean} {in: XawTextGetSource(TextWidget)} ## {ascii text widget}}}
set wafeHelp(XawAsciiSourceChanged) { The command 'XawAsciiSourceChanged' is used to figure out, whether
 the text buffer has changed since it was saved the last time with
 'XawAsciiSave' or has been queried using XawAsciiSourceChanged.
 The internal change flag is reset whenever the string is queried
 via 'getValue' or the buffer is saved via XawAsciiSave.}

proc XawAsciiSourceFreeString-type {} { return {function {void} {in: XawTextGetSource(TextWidget)} ## {ascii text widget}}}
set wafeHelp(XawAsciiSourceFreeString) { The command 'XawAsciiSourceFreeString' can be used to free the
 memory allocated by the Text widget explicitly during 'getValue'
 for the 'string' resource or whenever the widget is saved. Note,
 that this function is performed automatically whenever a next
 'getValue' for the 'string' resource is performed or when the
 widget is destroyed. This function should only be called when the
 resource 'useStringInPlace' is false.}

proc Box-type {} { return {creationCommand Widget}}
set wafeHelp(Box) { The 'Box' widget class is a geometry manager that packs its
 children as tight as possible in non-overlapping rows and
 columns. The children are rearranged when resizing events occur
 either on the Box or its children or when children are managed or
 unmanaged.}

proc Clock-type {} { return {creationCommand Widget}}
set wafeCmdNeeds(Clock) {!R6 }
set wafeHelp(Clock) { The 'Clock' widget class displays the current time either as analog
 clock or as time string depending on the value of the 'analog' resource.}

proc Command-type {} { return {creationCommand Widget}}
set wafeHelp(Command) { The 'Command' widget class is used for push buttons that, when
 selected, may cause a specific action to take place. This widget
 can display a multi-line string or a bitmap or pixmap image.}

proc Dialog-type {} { return {creationCommand Widget}}
set wafeHelp(Dialog) { The 'Dialog' widget class is a commonly used composite widget to
 prompt for auxiliary input from the user (such as a file name).}

proc XawDialogGetValueString-type {} { return {function {String} {in: DialogWidget} ## {dialog widget}}}
set wafeHelp(XawDialogGetValueString) { The function 'XawDialogGetValueString' returns the character string
 from the text input field of a Dialog widget.}

proc Form-type {} { return {creationCommand Widget}}
set wafeHelp(Form) { The 'Form' widget class is a more sophisticated geometry manager
 that allows its children to specify their positions relative to
 other children or to the edges of the form.}

proc XawFormDoLayout-type {} { return {function {void} {in: FormWidget} {in: Boolean} ## {form widget} {boolean}}}
set wafeHelp(XawFormDoLayout) { The command 'XawFormDoLayout' is used to force or defer a re-layout
 of the Form widget.}

proc Grip-type {} { return {creationCommand Widget}}
set wafeHelp(Grip) { The 'Grip' widget class provides a rectangle that, when selected,
 will cause an action to take place.}

proc Label-type {} { return {creationCommand Widget}}
set wafeHelp(Label) { The 'Label' widget class provides a rectangle that can display a
 multi-line string or a bitmap or pixmap image.}

proc List-type {} { return {creationCommand Widget}}
set wafeHelp(List) { The 'List' widget class is used to display a list of text strings
 in a row column format, where each text string can be individually
 selected. When an element is selected, an action may be provided to
 take place.
 Special percentcode subsititutions are performed for listed callbacks:
    %i: index
        callback
    %s: selection
        callback}

proc XawListAppend-type {} { return {function {void} {in: ListWidget} {in: [args]} ## {list widget} {items}}}
set wafeHelp(XawListAppend) { The command 'XawListAppend' can be used to append one or more
 list items to the elements already existing in a List widget.}

proc XawListChange-type {} { return {function {void} {in: ListWidget} {in: int} {in: int} {in: int} {in: [args]} ## {list widget} {number of items} {longest} {resize} {List list | Arg items | File filename}}}
set wafeHelp(XawListChange) { The command 'XawListChange' changes the items of list widget. If
 the number of items (2nd argument) or the length of the longest
 item (3rd argument) contain a value less than one, the actual
 values will be computed automatically. If the 4th argument is the
 string 'List', a Tcl list of items is expected as next argument. If
 it is 'Arg', following arguments are treated as list items. If the
 4th argument is 'File', the items are read from the file named by
 the 5th argument.}

proc XawListHighlight-type {} { return {function {void} {in: ListWidget} {in: int} ## {list widget} {item number}}}
set wafeHelp(XawListHighlight) { The command 'XawListHighlight' highlights (inverts) the nth list
 item indicated by the 2nd argument.}

proc XawListShowCurrent-type {} { return {function {XawListReturnStruct *} {in: ListWidget} ## {list widget}}}
set wafeHelp(XawListShowCurrent) { The function 'XawListShowCurrent' returns information about the
 currently selected list item. The command returns a filename of an
 associative array containing the element 'string' and 'list_index'.}

proc XawListUnhighlight-type {} { return {function {void} {in: ListWidget} ## {list widget}}}
set wafeHelp(XawListUnhighlight) { The command 'XawListUnhighlight' turns the highlight status of the
 current selected item off.}

proc Logo-type {} { return {creationCommand Widget}}
set wafeCmdNeeds(Logo) {!R6 }
set wafeHelp(Logo) { The 'Logo' widget class can be used to display an X logo in various
 sizes.}

proc Mailbox-type {} { return {creationCommand Widget}}
set wafeCmdNeeds(Mailbox) {!R6 }
set wafeHelp(Mailbox) { The 'Mailbox' widget class can be used to watch the status of a
 file (typically the mailbox) and to change a bitmap, when it is
 altered.}

proc MenuButton-type {} { return {creationCommand Widget}}
set wafeHelp(MenuButton) { The 'MenuButton' widget class is used for push buttons that, when
 selected, will pop up the menu named in the resource
 'menuName'. This widget can display a multi-line string or a bitmap
 or pixmap image.}

proc Paned-type {} { return {creationCommand Widget}}
set wafeHelp(Paned) { The 'Paned' widget class allows children to be tiled vertically or
 horizontally. Controls are also provided to allow the user to
 dynamically resize the individual parts.}

proc XawPanedAllowResize-type {} { return {function {void} {in: Widget} {in: Boolean} ## {child of paned widget} {boolean}}}
set wafeHelp(XawPanedAllowResize) { The command 'XawPanedAllowResize' is used to enable to disable a
 child's request for pane resizing. This command is equivalent to
 changing the 'allowResize' constraint resource for the child.}

proc XawPanedGetMinMax-type {} { return {function {void} {in: Widget} {out: int} {out: int} ## {child of paned widget} {min} {max}}}
set wafeHelp(XawPanedGetMinMax) { The command 'XawPanedGetMinMax' is used retrieve the minimum and
 maximum height settings for a child pane.  This command is
 equivalent to getting the 'min' and 'max' constraint resources for
 the child.}

proc XawPanedGetNumSub-type {} { return {function {int} {in: PanedWidget} ## {paned widget}}}
set wafeHelp(XawPanedGetNumSub) { The function 'XawPanedGetNumSub' returns the number of panes in a
 paned widget,}

proc XawPanedSetMinMax-type {} { return {function {void} {in: Widget} {in: int} {in: int} ## {child of a paned widget} {min} {max}}}
set wafeHelp(XawPanedSetMinMax) { The command 'XawPanedSetMinMax' is used set the minimum and maximum
 height settings for a child pane.  This command is equivalent to
 setting the 'min' and 'max' constraint resources for the child.}

proc XawPanedSetRefigureMode-type {} { return {function {void} {in: PanedWidget} {in: Boolean} ## {paned widget} {boolean}}}
set wafeHelp(XawPanedSetRefigureMode) { The command 'XawPanedSetRefigureMode' enables or disables the
 automatic calculation of pane sizes and pane positions (e.g., when
 multiple changes are expected for child panes)}

proc Scrollbar-type {} { return {creationCommand Widget}}
set wafeHelp(Scrollbar) { The 'Scrollbar' widget class provides a rectangular area containing
 a thumb that when slid among one dimension may cause a specific
 action to take place. The Scrollbar may be oriented horizontally or
 vertically.
 Special percentcode subsititutions are performed for listed callbacks:
    %p: position of thumb (in pixel)
        scrollProc
    %p: floating position (0.0-1.0)
        jumpProc}

proc XawScrollbarSetThumb-type {} { return {function {void} {in: ScrollbarWidget} {in: float} {in: float} ## {Scrollbar widget} {top} {shown}}}
set wafeHelp(XawScrollbarSetThumb) { The command 'XawScrollbarSetThumb' sets the position and length of
 a Scrollbar thumb. The 2nd ('top') and 3rd ('shown') arguments are
 floats in the range between 0.0 and 1.0 to change its
 values. Either 'top' or 'shown' can be specified as -1.0 in which
 case the current value is left unchanged.}

proc scSet-type {} { return {alias XawStripChartSet}}

proc Simple-type {} { return {creationCommand Widget}}
set wafeHelp(Simple) { The 'Simple' widget class provides a rectangular area with a
 set-able mouse cursor and a special border. It is the base class of
 most of the Athena simple widget classes.}

proc SimpleMenu-type {} { return {creationCommand Widget}}
set wafeHelp(SimpleMenu) { The 'SimpleMenu' widget class provides a container for menu
 entries. It is a direct subclass of Shell, is the only part of a
 menu associated with a window and serves as a glue to bind
 individual menu entries together.}

proc XawSimpleMenuAddGlobalActions-type {} { return {function {void} {const: wafeAppContext} ## {}}}
set wafeHelp(XawSimpleMenuAddGlobalActions) { The procedure 'XawSimpleMenuAddGlobalActions' registers the global
 action routine 'XawPositionSimpleMenu' which can be used to
 position a menu centered over the cursor. If the resource
 'popupOnEntry' of the SimpleMenuWidget is set, the menu will be
 placed so that the pointer is centered over the specified menu entry. 
 
    Example translation: 
        !Ctrl<Btn1Down>: XawPositionSimpleMenu(myMenu) MenuPopup(myMenu)}

proc XawSimpleMenuClearActiveEntry-type {} { return {function {void} {in: SimpleMenuWidget} ## {widget}}}
set wafeHelp(XawSimpleMenuClearActiveEntry) { The procedure 'XawSimpleMenuClearActiveEntry' is used to clear the
 SimpleMenu widget's internal information about the currently
 highlighted menu entry.}

proc XawSimpleMenuGetActiveEntry-type {} { return {function {WidgetID} {in: SimpleMenuWidget} ## {widget}}}
set wafeHelp(XawSimpleMenuGetActiveEntry) { The function 'XawSimpleMenuGetActiveEntry' returns the widget ID of
 the currently active menu entry (or 0, if none is active)}

proc Sme-type {} { return {creationCommand Object}}
set wafeHelp(Sme) { The object class 'Sme' is the base class of all menu entries. It
 can be used as a menu entry itself to provide a blank space in a
 menu. 'Sme' stands for 'Simple Menu Entry'.}

proc SmeBSB-type {} { return {creationCommand Object}}
set wafeHelp(SmeBSB) { The object class 'SmeBSB' provides a select-able menu entry
 containing a text string. A bitmap may also be placed in the left
 and right margins.  'SmeBSB' stands for 'Simple Menu Entry Bitmap
 String Bitmap'.}

proc SmeLine-type {} { return {creationCommand Object}}
set wafeHelp(SmeLine) { The object class 'SmeLine' provides a non select-able menu entry
 containing a separator line.}

proc StripChart-type {} { return {creationCommand Widget}}
set wafeHelp(StripChart) { The 'StripChart' widget class provides a real time data graph that
 will automatically update and scroll.}

proc XawStripChartSet-type {} { return {function {void} {in: StripChartWidget} {in: double} ## {strip chart widget} {value}}}
set wafeHelp(XawStripChartSet) { The command 'XawStripChartSet' is used to specify a StripChart
 widget's current value. The widget will plot a graph of this value
 every n seconds, where n is the value of the 'update' resource of
 the StripChart widget.}

proc XawTextDisableRedisplay-type {} { return {function {void} {in: TextWidget} ## {ascii text widget}}}
set wafeHelp(XawTextDisableRedisplay) { The command 'XawTextDisableRedisplay' causes all changes to be
 batched until either XawTextDisplay or XawTextEnableRedisplay is
 called.}

proc XawTextDisplay-type {} { return {function {void} {in: TextWidget} ## {ascii text widget}}}
set wafeHelp(XawTextDisplay) { The command 'XawTextDisplay' forces all accumulated updates to be
 displayed (see also: XawTextDisableRedisplay).}

proc XawTextDisplayCaret-type {} { return {function {void} {in: TextWidget} {in: Boolean} ## {ascii text widget} {boolean}}}
set wafeHelp(XawTextDisplayCaret) { The command 'XawTextDisplayCaret' is used to enable and disable the
 display of the insertion point marker. The same functionality can
 be achieved by setting the resource 'displayCaret' or by the action
 routine 'display-caret'.}

proc XawTextEnableRedisplay-type {} { return {function {void} {in: TextWidget} ## {ascii text widget}}}
set wafeHelp(XawTextEnableRedisplay) { The command 'XawTextEnableRedisplay' is used to enable display of
 changes in the specified Text widget.}

proc XawTextGetInsertionPoint-type {} { return {function {XawTextPosition} {in: TextWidget} ## {ascii text widget}}}
set wafeHelp(XawTextGetInsertionPoint) { The function 'XawTextGetInsertionPoint' returns the current
 position of the insertion point. The same functionality can be
 achieved by retrieving the resource value for 'insertPosition' via
 getValue.}

proc XawTextGetSelectionPos-type {} { return {function {void} {in: TextWidget} {out: XawTextPosition} {out: XawTextPosition} ## {ascii text widget} {variable name for start position} {variable name for end position}}}
set wafeHelp(XawTextGetSelectionPos) { The procedure 'XawTextGetSelectionPos' returns the start and end
 position of the current selection of the specified text widget in
 the variables given in the second and third argument. If the
 returned values are equal, no text is currently selected.}

proc XawTextInvalidate-type {} { return {function {void} {in: TextWidget} {in: XawTextPosition} {in: XawTextPosition} ## {ascii text widget} {start position} {end position}}}
set wafeHelp(XawTextInvalidate) { The procedure 'XawTextInvalidate' causes the text in the specified
 range to be redisplayed immediately (if redisplay is disabled,
 this will happen when redisplay is enabled again; see also:
 XawTextDisableRedisplay);}

proc XawTextSearch-type {} { return {function {XawTextPosition} {in: TextWidget} {in: XawTextScanDirection} {in: XawTextBlock} ## {ascii text widget} {scan direction ('left' or 'right')} {text block}}}
set wafeHelp(XawTextSearch) { The function 'XawTextSearch' searches from the position of the
 current insertion point for the text string passed in the text
 block (last argument) in the specified direction (2nd argument). If
 the search was successful, a value greater or equal 0 is
 returned. if the search was not successful, a negative value is returned.}

proc XawTextSetInsertionPoint-type {} { return {function {void} {in: TextWidget} {in: XawTextPosition} ## {ascii text widget} {position}}}
set wafeHelp(XawTextSetInsertionPoint) { The procedure 'XawTextSetInsertionPoint' moved the insertion point
 to the specified location.  The same functionality can be achieved
 by setting the resource 'insertPosition' via setValues.}

proc XawTextSetSelection-type {} { return {function {void} {in: TextWidget} {in: XawTextPosition} {in: XawTextPosition} ## {ascii text widget} {begin position} {end position}}}
set wafeHelp(XawTextSetSelection) { The procedure 'XawTextSetSelection' highlights the text between the
 specified positions and makes it as well the PRIMARY
 selection. This procedure has no effect on CUT_BUFFER0.}

proc XawTextSetSelectionArray-type {} { return {function {void} {in: TextWidget} {in: [XawTextSelectType]} ## {ascii text widget} {selection array}}}
set wafeHelp(XawTextSetSelectionArray) { The procedure 'XawTextSetSelectionArray' sets the selection array
 for the specified Text widget. The selection array determines the
 selection behavior on single, double, triple and so on clicks with
 the left mouse button in the text widget. The nth position in this
 array determines the behavior on the nth click. Possible values in
 this array are: 'selectAll', 'selectChar', 'selectLine',
 'selectParagraph', 'selectPosition', 'selectWord' and
 'selectNull'. The selection array is always terminated by
 selectNull. 
 
 Example:    XawTextSetSelectionArray $w selectLine selectPosition selectNull}

proc XawTextSinkFindDistance-type {} { return {function {void} {in: (Widget)TextSink} {in: XawTextPosition} {in: int} {in: XawTextPosition} {out: int} {out: XawTextPosition} {out: int} ## {ascii text widget} {from position} {reference location (in pixel)} {to position} {resulting width (in pixel)} {distance in positions} {resulting height (in pixel)}}}
set wafeHelp(XawTextSinkFindDistance) { The procedure 'XawTextSinkFindDistance' returns the position between
 text positions of the specified widget.}

proc XawTextSinkMaxHeight-type {} { return {function {int} {in: (Widget)TextSink} {in: int} ## {ascii text widget} {lines}}}
set wafeHelp(XawTextSinkMaxHeight) { The function 'XawTextSinkMaxHeight' returns the height in pixel
 that will be taken up by the specified number of lines (2nd
 argument)}

proc XawTextSinkMaxLines-type {} { return {function {int} {in: (Widget)TextSink} {in: Dimension} ## {ascii text widget} {height}}}
set wafeHelp(XawTextSinkMaxLines) { The function 'XawTextSinkMaxLines' returns the number of lines that
 will fit into the specified height.}

proc XawTextSinkSetTabs-type {} { return {function {void} {in: (Widget)TextSink} {const: argc-2} {in: [int]} ## {ascii text widget} {tabs}}}
set wafeHelp(XawTextSinkSetTabs) { The procedure 'XawTextSinkSetTabs' sets the tab stops of the
 specified widget.}

proc XawTextSourceRead-type {} { return {function {XawTextPosition} {in: XawTextGetSource(TextWidget)} {in: XawTextPosition} {out: XawTextBlock} {in: int} ## {ascii text widget} {position} {variable name for text block} {length}}}
set wafeHelp(XawTextSourceRead) { The function 'XawTextSourceRead' is used to retrieve a portion of
 the text displayed by a ascii text widget. The 2nd argument
 specified the start position, the 4th argument the desired length
 of the text portion. The function returns the actual number of
 characters retrieved (which might be less the desired length, in
 which case another XawTextSourceRead request must be issued). The
 third argument returns the retrieved text block (the fields 'ptr',
 'length' and 'firstPos' of the specified array name are filled
 out).}

proc XawTextSourceScan-type {} { return {function {XawTextPosition} {in: XawTextGetSource(TextWidget)} {in: XawTextPosition} {in: XawTextScanType} {in: XawTextScanDirection} {in: int} {in: Boolean} ## {ascii text widget} {position} {boundary type} {scan direction} {count} {include (boolean)}}}
set wafeHelp(XawTextSourceScan) { The function 'XawTextSourceScan' is used to search the text for
 boundary types ('position', 'whiteSpace', 'EOL', 'paragraph',
 'all') in the specified direction ('left' or 'right'). The 4th
 argument specified the number of boundaries to scan for, the 5th
 argument specifies, whether the boundary itself should be included
 in the scan. The function returns the text position of the desired
 boundary or the closest valid text position.}

proc XawTextTopPosition-type {} { return {function {XawTextPosition} {in: TextWidget} ## {ascii text widget}}}
set wafeHelp(XawTextTopPosition) { The function 'XawTextTopPosition' returns the character position of
 the left most character of the first line displayed in the
 specified widget. The same functionality can be achieved by
 retrieving the resource value for 'displayPosition' via getValue.}

proc XawTextReplace-type {} { return {function {int} {in: TextWidget} {in: XawTextPosition} {in: XawTextPosition} {in: XawTextBlock} ## {ascii text widget} {from position} {to position} {text block}}}
set wafeHelp(XawTextReplace) { The function 'XawTextReplace' is used to modify edit-able text. The
 text of the widget between the start and the end position (2nd and
 third argument) will be replaced by the text form the specified
 text block (4th argument). The function returns 'editDone' when it
 was successful, 'positionError' when the editMode is 'append' and
 the from position is not the last position of the text or
 'editError' on other errors.}

proc XawTextUnsetSelection-type {} { return {function {void} {in: TextWidget} ## {ascii text widget}}}
set wafeHelp(XawTextUnsetSelection) { The procedure 'XawTextUnsetSelection' un-highlights previously
 highlighted text in the specified widget.}

proc Toggle-type {} { return {creationCommand Widget}}
set wafeHelp(Toggle) { The 'Toggle' widget class is used for push buttons that,contain a
 state information (pressed or un-pressed). When a Toggle is
 selected a specific action may take place. Toggles may also be used
 as 'radio buttons' to implement 'one of many' or 'zero or one of
 many' groups of buttons. This widget can display a multi-line
 string or a bitmap or pixmap image.}

proc XawToggleChangeRadioGroup-type {} { return {function {void} {in: ToggleWidget} {in: NULL | ToggleWidget} ## {toggle widget} {NULL | any toggle widget of a radio group}}}
set wafeHelp(XawToggleChangeRadioGroup) { The procedure 'XawToggleChangeRadioGroup' can be used to change the
 radio group of a Toggle widget, to add a Toggle widget to a radio
 group or to remove a Toggle widget from a radio group (second
 argument NULL)}

proc XawToggleGetCurrent-type {} { return {function {XrmQuark} {in: ToggleWidget} ## {any toggle widget of a radio group}}}
set wafeHelp(XawToggleGetCurrent) { The function 'XawToggleGetCurrent' returns the radio data of the
 currently active widget of the specified radio group.}

proc XawToggleSetCurrent-type {} { return {function {void} {in: ToggleWidget} {in: (XtPointer)XrmQuark} ## {any toggle widget of a radio group} {radio data}}}
set wafeHelp(XawToggleSetCurrent) { The procedure 'XawToggleSetCurrent' locates the toggle widget to be
 set by matching the specified radio data for each toggle in the
 radio group. If more than one widget matches, one toggle widget
 will be chosen arbitrarily. If this procedure causes any toggle
 widget to change its state, the corresponding callback routines
 will be called. The callback routines for unset will be called
 before the routines for set.}

proc XawToggleSetRadioData-type {} { return {function {void} {in: ToggleWidget} {in: XrmQuark} ## {toggle widget} {radio data}}}
set wafeHelp(XawToggleSetRadioData) { The procedure 'XawToggleSetRadioData' sets the radio data for 
 the specified widget.}

proc XawToggleUnsetCurrent-type {} { return {function {void} {in: ToggleWidget} ## {any toggle widget of a radio group}}}
set wafeHelp(XawToggleUnsetCurrent) { The procedure 'XawToggleUnsetCurrent' unsets all toggles in a radio
 group. If this procedure causes any toggle widget to change its state,
 the corresponding callback routines will be called}

proc Viewport-type {} { return {creationCommand Widget}}
set wafeHelp(Viewport) { The 'Viewport' widget class provides means to view a larger window
 in a smaller area. It consists of a frame, one or two Scrollbars
 and an inner window. The inner window will be clipped by the frame
 with the Scrollbars controlling which section of the inner window
 is current visible.}

proc XawViewportSetCoordinates-type {} { return {function {void} {in: ViewportWidget} {in: Position} {in: Position} ## {Viewport Widget} {x position} {y position}}}
set wafeCmdNeeds(XawViewportSetCoordinates) {R5|XAW3D }
set wafeHelp(XawViewportSetCoordinates) { The procedure 'XawViewportSetCoordinates' is used to set the x and
 y position in a Viewport widget. argument two and three are pixel
 coordinate values.}

proc XawViewportSetLocation-type {} { return {function {void} {in: ViewportWidget} {in: double} {in: double} ## {Viewport Widget} {x offset} {y offset}}}
set wafeCmdNeeds(XawViewportSetLocation) {R5|XAW3D }
set wafeHelp(XawViewportSetLocation) { The procedure 'XawViewportSetLocation' is used to set Viewport
 location.  the specified values are in the range between 0.0 and
 1.0, where 0.0 is the minimum value (pixel value 0) and 1.0 is the
 maximum value (maximum pixel height or width).}

