proc XmArc-type {} { return {creationCommand Widget}}
set wafeHelp(XmArc) { The 'XmArc' widget class is to be used in cooperation with the
 XmGraph widget class. An arc may be undirected, directed or
 bidirected.
 Special percentcode subsititutions are performed for listed callbacks:
    %f: old from
        arcEditedCallback
    %t: old to
        arcEditedCallback
    %F: new from
        arcEditedCallback
    %T: new to
        arcEditedCallback}

proc XmArcGetPos-type {} { return {function {void} {in: ARC(XmArcWidget)} {out: Position} {out: Position} {out: Position} {out: Position} ## {name of arc Widget} {out: from x-coordiante} {out: from y-corrdinate} {out: to x-coordinate} {out: to y-coordinate}}}
set wafeHelp(XmArcGetPos) { The command 'XmArcGetPos' returns the coordinates of the specified
 widget in the variables given in argument 2 to 4.}

proc XmGraph-type {} { return {creationCommand Widget}}
set wafeHelp(XmGraph) { The 'XmGraph' widget class provides the application developer with
 the ability to display any group of widgets as a graph, with each
 widget representing a node. The graph can be disconnected, as well
 as contain cycles.  The arcs used to connect the nodes are
 instances of an XmArc widget, developed specifically for use with
 the XmGraph widget. An arc may be undirected, directed or
 bidirected. Note that the XmGraph widget does not understand the
 semantics of arc direction, ie. for layout and editing purposes, an
 arc will always have a parent and a child regardless of its
 direction.
 
 The XmGraph widget has the ability to arrange all nodes either
 horizontally or vertically according to an internal layout
 algorithm, and supports an edit mode in which arcs and nodes may be
 interactively repositioned as well as created, and a read-only mode
 in which all events are passed directly to the children of the
 Graph widget.  In edit mode, the XmGraph takes over all device
 events for editing commands.
 Special percentcode subsititutions are performed for listed callbacks:
    %N: selected Nodes
        newArcCallback, newNodeCallback, arcMovedCallback, nodeMovedCallback, defaultActionCallback, selectNodeCallback, selectArcCallback, deselectCallback, selectSubgraphCallback
    %A: selected Arcs
        newArcCallback, newNodeCallback, arcMovedCallback, nodeMovedCallback, defaultActionCallback, selectNodeCallback, selectArcCallback, deselectCallback, selectSubgraphCallback
    %I: child widgetID
        newArcCallback, newNodeCallback, arcMovedCallback, defaultActionCallback, selectNodeCallback, selectArcCallback, deselectCallback, selectSubgraphCallback
    %f: old from widgetID
        arcMovedCallback
    %t: 
        arcMovedCallback
    %F: new from widgetID
        arcMovedCallback
    %T: new to widgetID
        arcMovedCallback}

proc XmScrolledGraph-type {} { return {creationCommand XmGraph}}
set wafeHelp(XmScrolledGraph) { An 'XmScrolledGraph' widget is an 'XmGraph' wdiget contained in an
 'XmScrolledWindow'. The XmScrolledGraph uses uses the AUTOMATIC
 scrollbar mode of the XmScrolledWindow. The Graph widget does
 extensive optimizations based on the existence of the
 ScrolledWindow's clipWindow when created via XmScrolledGraph.}

proc XmGraphInsertRoots-type {} { return {function {void} {in: XmGraphWidget} {in: [Widget]} {const: argc-2} ## {XmGraphWidget} {nodes}}}
set wafeHelp(XmGraphInsertRoots) { The command 'XmGraphInsertRoots' adds to the user roots list of
 graph the specified nodes}

proc XmGraphDestroyAllArcs-type {} { return {function {void} {in: XmGraphWidget} ## {XmGraphWidget}}}
set wafeHelp(XmGraphDestroyAllArcs) { The command 'XmGraphDestroyAllArcs' destroys all arcs of the
 specified XmGraph widget.}

proc XmGraphDestroyAllNodes-type {} { return {function {void} {in: XmGraphWidget} ## {XmGraphWidget}}}
set wafeHelp(XmGraphDestroyAllNodes) { The command 'XmGraphDestroyAllNodes' destroys all arcs of the
 specified XmGraph widget.}

proc XmGraphRemoveArcBetweenNodes-type {} { return {function {void} {in: XmGraphWidget} {in: Widget} {in: Widget} ## {XmGraphWidget} {from node} {to node}}}
set wafeHelp(XmGraphRemoveArcBetweenNodes) { The command 'XmGraphRemoveArcBetweenNodes' destroys all arcs in the
 specified XmGraph widget between the nodes given in argument 2 and 3.}

proc XmGraphGetArcsBetweenNodes-type {} { return {function {String} {in: XmGraphWidget} {in: Widget} {in: Widget} ## {XmGraphWidget} {from node} {to node}}}
set wafeHelp(XmGraphGetArcsBetweenNodes) { The function 'XmGraphGetArcsBetweenNodes' returns a list of all
 XmArc widgets (in form of widget IDs) that extend from the widget
 given in the 2nd argument to the widget specified in the third
 argument. if no such arc exists, an empty list is returned.}

