#!../wafe --f
# This script demonstrates, 
#  
#   a) ... how to obtain help information on buttons in an 
#      application (here Command widgets) my moving the cursor 
#      into the button widget,
#   b) ... how to use widget-IDs to to place children in a
#      Form widget. Note that one can interchange all 'color' 
#      widgets without modifying the fromHoriz resource.
#   c) ... how to use default resources for callbacks,
#      translations and fromVert via mergeResources
#
#  Gustaf Neumann,      Mohegan Lake, Jan 25, 1994

mergeResources topLevel \
  *Label.shadowWidth 2 \
  *.background gainsboro \
  *Command.fromVert magicHelp \
  *Command.callback "sV magicHelp background %w" \
  *Command.translations {#override
    <Enter>:  exec(buttonHelp %w)
    <Leave>:  exec(leaveButtonHelp)
  }

proc buttonHelp {widget} { 
    global helpText lastInfo
    set lastInfo [gV magicHelp label]
    sV magicHelp label $helpText($widget)
}

proc leaveButtonHelp {} { 
    global lastInfo 
    sV magicHelp label $lastInfo
} 

 Form f topLevel
    Label magicHelp f width 450 borderWidth 0 label {}
    set w [Command quit f callback quit]
    set w [Command red f fromHoriz $w]
    set w [Command aquamarine f fromHoriz $w]
    set w [Command yellow f fromHoriz $w]
    set w [Command green f fromHoriz $w]
    set w [Command turquoise f fromHoriz $w]
 realize

set helpText(quit)  "This button terminates the program!"
foreach color {red yellow green turquoise aquamarine} {
  set helpText($color)   "Turn background of this text into $color"
}

