#
# file should be sourced 
# showRes lists the resources and its types for the given widget 
#
proc showRes {widget {filter ""}} {
  getResourceList $widget res

  if [string compare "" $filter] {
    puts stderr "Attributes of Widget $widget (Class [getClass $widget]) matching *$filter*:"
    foreach r [lsort $res] {
      set l  "    [format {%-30s %s} $r [getTypeOfAttribute $widget $r]]"
      if [string match *$filter* $l] {
	puts stderr $l
      }
    }
  } else {
    puts stderr "Attributes of Widget $widget (Class [getClass $widget]):"
    foreach r [lsort $res] {
      puts stderr "    [format {%-30s %s} $r [getTypeOfAttribute $widget $r]]"
    }
  }
}
