proc HTML-type {} { return {creationCommand Widget}}
set wafeHelp(HTML) { The 'HTML' widget class can be used to display HTML (HyperText
 Markup Language) documents (which may contain references to
 graphics in form of GIF or XPM). When needed scrollbars are added.}

proc HTMLGetText-type {} { return {function {String} {in: HTMLWidget} {in: int} ## {HTML Widget} {Pretty Code 0-5}}}
set wafeHelp(HTMLGetText) { The function 'HTMLGetText' is a convenience function to return the
 text of the HTML document as a plain ascii text string.  When the
 2nd argument is two or larger, Postscript is returned. The font
 used is encoded in the pretty parameter: 
   * pretty = 2: Times
   * pretty = 3: Helvetica
   * pretty = 4: New century schoolbook
   * pretty = 5: Lucida Bright}

proc HTMLGetTextAndSelection-type {} { return {function {String} {in: HTMLWidget} {out: String} {out: String} {out: String} ## {HTML Widget} {Selection starts} {Selection ends} {Insertion Points}}}
set wafeHelp(HTMLGetTextAndSelection) { The function 'HTMLGetText' is a convenience function to return the
 text of the HTML document as a single white space separated string,
 with pointers to the various start and end points of selections.}

proc HTMLGetHRefs-type {} { return {function {String} {in: HTMLWidget} ## {HTML Widget}}}
set wafeHelp(HTMLGetHRefs) { The function 'HTMLGetHRefs' returns the HREFs of all active anchors in
 the document. Function returns an array of strings and fills num_hrefs
 passed. If there are no HREFs an empty string is returned .}

proc HTMLPositionToId-type {} { return {function {int} {in: HTMLWidget} {in: int} {in: int} ## {HTML Widget} {x Coordinate} {y Coordinate}}}
set wafeHelp(HTMLPositionToId) { The function 'HTMLPositionToId' returns the element id of the element
 nearest to the x,y coordinates passed in.  If there is no element
 there, return the first element in the line we are on.  If there we
 are on no line, either return the beginning, or the end of the
 document.}

proc HTMLIdToPosition-type {} { return {function {int} {in: HTMLWidget} {in: int} {out: int} {out: int} ## {HTML Widget} {Element ID} {x Coordinate} {y Coordinate}}}
set wafeHelp(HTMLIdToPosition) { The function 'HTMLIdToPosition' returns the position of the element
 based on the element id passed in.  Function returns 1 on success
 and fills in x,y pixel values.  If there is no such element, x=0,
 y=0 and -1 is returned.}

proc HTMLAnchorToPosition-type {} { return {function {int} {in: HTMLWidget} {in: String} {out: int} {out: int} ## {HTML Widget} {Anchor's name} {x Coordinate} {y Coordinate}}}
set wafeHelp(HTMLAnchorToPosition) { The function 'HTMLAnchorToPosition' returns the position of the
 anchor based on the anchor NAME passed.  Function returns 1 on
 success and fills in x,y pixel values.  If there is no such
 element, x=0, y=0 and -1 is returned.}

proc HTMLClearSelection-type {} { return {function {void} {in: HTMLWidget} ## {HTML Widget}}}
set wafeHelp(HTMLClearSelection) { The procedure 'HTMLClearSelection' clears the current selection.}

proc HTMLSetSelection-type {} { return {function {void} {in: HTMLWidget} {in: ElementRef} {in: ElementRef} ## {HTML Widget} {start} {end}}}
set wafeHelp(HTMLSetSelection) { The procedure 'HTMLSetSelection' sets the current selection
 based on the ElementRefs passed in. Both refs must be valid (and contain
 the integers id and pos)}

proc HTMLSetText-type {} { return {function {void} {in: HTMLWidget} {in: String} {in: String} {in: String} {in: int} {in: String} {const: NULL} ## {HTML Widget} {Text} {Header Text} {Footer Text} {element_id} {target_anchor}}}
set wafeHelp(HTMLSetText) { The procedure 'HTMLSetText' sets the raw text into the widget and
 forces a reparse and a reformat.  If any pointer is passed in as
 NULL that text is unchanged, if a pointer points to an empty
 string, that text is set to NULL; Also pass an element ID to set
 the view area to that section of the new text.  Finally pass an
 anchor NAME to set position of the new text to that anchor.}

proc HTMLSearchText-type {} { return {function {int} {in: HTMLWidget} {in: String} {in: ElementRef} {out: ElementRef} {out: ElementRef} {in: int} {in: int} ## {HTML Widget} {Pattern} {Start} {Result: Start} {Result: End} {Backward} {Case Sensitive}}}
set wafeHelp(HTMLSearchText) { The function 'HTMLSearchText' is used to search the text of the
 HTML document as a single white space separated string. Linefeeds
 are converted into spaces.
 
 Takes a pattern, pointers to the start and end blocks to store the
 start and end of the match into.  Start is also used as the location to
 start the search from for incremental searching.  If start is an invalid
 position (id = 0).  Default start is the beginning of the document for
 forward searching, and the end of the document for backwards searching.
 The backward and caseless parameters I hope are self-explanatory.
 
 returns 1 on success
      (and the start and end positions of the match).
 returns -1 otherwise (and start and end are unchanged).}

proc HTMLGotoId-type {} { return {function {void} {in: HTMLWidget} {in: int} ## {HTML Widget} {Element ID}}}
set wafeHelp(HTMLGotoId) { The procedure 'HTMLGotoId' is used to position the element
 based on the element id passed at the top of the viewing area.
 A passed in id of 0 means goto the top.}

proc HTMLAnchorToId-type {} { return {function {int} {in: HTMLWidget} {in: String} ## {HTML Widget} {Anchor string}}}
set wafeHelp(HTMLAnchorToId) { The function 'HTMLAnchorToId' returns the element id of the anchor
 based on the anchor NAME passed.  Function returns id on success.
 If there is no such element, 0 is returned.}

proc HTMLIdToElement-type {} { return {function {Boolean} {in: HTMLWidget} {in: int} {out: HTMLElementRecord*} ## {HTML Widget} {Element ID} {Element Record}}}

proc HTMLsetElementBg-type {} { return {function {void} {in: HTMLWidget} {in: int} {in: String} ## {HTML Widget} {Element ID} {backgroundColor}}}

proc HTMLRetestAnchors-type {} { return {function {void} {in: HTMLWidget} {const: NULL} ## {HTML Widget}}}
set wafeHelp(HTMLRetestAnchors) { The procedure 'HTMLRetestAnchors' is used to redraw all active
 anchors in the document.}

