#define MM_C
#include "wafe.h"
#include <X11/Shell.h>

#undef WIDGETLISTTRACE
#define MMTRACE

#undef USECONTEXT

/* freeProcRec is used to record special freeProc for 
 * per-widget information, which cannot be freed via XtFree
 */
typedef struct _freeProcRec
     {
     XrmQuark              descriptor;
     freeProc              free;
     struct _freeProcRec  *next;
     } freeProcRec, *freeProcRecPtr;

static freeProcRecPtr freeProcs;
static WidgetListPtr  widgetListHead;

#ifdef USECONTEXT
static XContext wafeCtx = 0;
#endif

#ifdef MMTRACE
# define MMPRINT(proc,args) DBUG_PRINT(proc,args)
#else
# define MMPRINT(args,args)
#endif

#ifdef WIDGETLISTTRACE
void
printAttributeList(al)
MMattribListPtr al;
    {
    while(al)
	{
	fprintf(stderr,"    al = %p\n",al);
	fprintf(stderr,"       attribute = %s\n",
		XrmQuarkToString(al->attribute));
	fprintf(stderr,"       value     = %p\n",  al->value);
	fprintf(stderr,"       next      = %p\n",  al->next);
	al = al->next;
	}
    }

void
printWidgetList(wl)
WidgetListPtr   wl;
    {
   
    if (!wl) 
	wl = widgetListHead;

    while(wl)
	{
	fprintf(stderr,"  wl = %p\n",wl);
	fprintf(stderr,"     widget = %p %s\n",wl->widget,XtName(wl->widget));
	fprintf(stderr,"     info   = %p\n", 	wl->info);
	fprintf(stderr,"     next   = %p\n",	wl->next);
        printAttributeList(wl->info);
	wl = wl->next;
	fprintf(stderr,"\n");
	}
    }
#endif




void
wafeAddToEndOfWidgetList(wl,w,info)
WidgetListPtr *wl;
Widget         w;
XtPointer      info;
    {
    WidgetListPtr *ptr=wl;
    while (*ptr)
	ptr = &((*ptr)->next);
    *ptr = (WidgetListPtr)XtMalloc(sizeof(WidgetListItem));
    (*ptr)->widget = w;
    (*ptr)->info   = info;
    (*ptr)->next   = NULL;
/*
   fprintf(stderr,
           "add to end of widgetlist *ptr %p, widget= %p, tree=%p info <%s>\n",
	   *ptr, (*ptr)->widget, wafeWidgetTrees, (char*)((*ptr)->info));
*/
    }

/*
 * when a topLevel widget (typically on a different display) is 
 * deleted, it has to be removed from widgetTrees, which is 
 * used primarily by name2widget
 */
static void
deleteFromWidgetList(wl,w)
WidgetListPtr *wl;
Widget         w;
    {
    WidgetListPtr *ptr=wl;
    WidgetListPtr tmpPtr;
    while (*ptr && (*ptr)->widget != w)
	ptr = &((*ptr)->next);
    if (!*ptr) 
	return;

    XtFree((*ptr)->info);  /* let us assume, info is always mallocated */
    tmpPtr = (*ptr)->next;     

    XtFree((char *)(*ptr));
    *ptr = tmpPtr;
    }






MMattribListPtr *
wafeMMgetAttribList(w, add)
Widget w; 
Boolean add;
    {
    WidgetListPtr   *ptr = &widgetListHead;
    WidgetListPtr   ptrTmp;
#ifdef USECONTEXT
    MMattribListPtr al;
#endif    

    DBUG_ENTER ("MMgetAttribList");

#ifdef USECONTEXT
    if (wafeCurrentAttribList) 
	{
	DBUG_RETURN(wafeCurrentAttribList);
	}
    if (!wafeCtx) 
	wafeCtx = XUniqueContext();

    if(XFindContext(XtDisplay(w), (XID) w, wafeCtx, (XPointer *) &al)) {
          (void) fprintf(stderr, "mmget: cannot find context!\n");
	  DBUG_RETURN((MMattribListPtr *)NULL);
	  }
    
    DBUG_RETURN(&al);
#else
#ifdef WIDGETLISTTRACE
	{
	WidgetListPtr   *tmpPtr = &widgetListHead;
	while (*tmpPtr) 
	    {
	    fprintf(stderr,"  -> widget %s (%p) al= %p, next=%p\n",
		    XtName((*tmpPtr)->widget),
		    (*tmpPtr)->widget,
		    (*tmpPtr)->info,
		    (*tmpPtr)->next);
	    
	    tmpPtr = &(*tmpPtr)->next;
	    }
	printWidgetList(*ptr);
	}
#endif

    if (wafeCurrentAttribList) 
      {
      MMPRINT("MMgetAttribList",(
	     "returning current Attrib list %p for %p %s",
	     wafeCurrentAttribList, w, XtName(w)));
      DBUG_RETURN(wafeCurrentAttribList);
      }

    while (*ptr) 
	{
	if ((*ptr)->widget == w) 
	    {
	    MMPRINT("MMgetAttribList",("found al %p for widget %p",
		    (*ptr)->info,w));
	    DBUG_RETURN((MMattribListPtr*)&((*ptr)->info));
	    }
	ptr = &(*ptr)->next;
	}

    if (!add) 
	{
	DBUG_RETURN(NULL);
	}
    /* not found; add new widgets to the front fo the list */
    
    ptrTmp = widgetListHead;
    widgetListHead = (WidgetListPtr)XtMalloc(sizeof(WidgetListItem));
    MMPRINT("MMgetAttribList",("new widgetlist at %p, returning %p for %p",
	    widgetListHead,&(widgetListHead->info),w));
    widgetListHead->next = ptrTmp;
    widgetListHead->widget = w;
    widgetListHead->info = NULL;
    DBUG_RETURN((MMattribListPtr *)&(widgetListHead->info));
#endif
    }
    
void
wafeMMsetAttribList(w)
Widget w; 
    {
#ifdef USECONTEXT
    if (!wafeCtx) 
	wafeCtx = XUniqueContext();
    XSaveContext(XtDisplay(w), (XID) w, wafeCtx, 
		 (_Xconst char *)*wafeCurrentAttribList);
#else
    WidgetListPtr ptrTmp = widgetListHead;
    widgetListHead = (WidgetListPtr)XtMalloc(sizeof(WidgetListItem));
    widgetListHead->next = ptrTmp;
    widgetListHead->widget = w;
    widgetListHead->info = (XtPointer)*wafeCurrentAttribList;
    MMPRINT("MMset",("setting al %p for widget %p <%s>",
	    *wafeCurrentAttribList,w,XtName(w)));
#endif
    }


/* if the attribute list is available, use it, otherwise obtain it, if
   alPtr is a sensible pointer, return the attribute list in it as a
   context. */
char *
wafeMMgetValue(w, descriptor, alPtr, createAttribList)
Widget          w;
XrmQuark        descriptor;
MMattribListPtr **alPtr;
Boolean         createAttribList;
    {
    MMattribListPtr *ptr;

    if (!alPtr)   /* we do not want to return the attrib list as context */
	ptr = wafeMMgetAttribList(w,createAttribList);
    else
    if (!*alPtr)  /* we do have no attrib list */
	*alPtr = ptr = wafeMMgetAttribList(w,createAttribList);
    else          /* use the provided attrib list */
	ptr = *alPtr;

    if (ptr)
	{
	while(*ptr) 
	    {
	    /* fprintf(stderr,"MMgetValue: comparing %s with %s\n",
		    XrmQuarkToString(descriptor),
		    XrmQuarkToString((*ptr)->attribute));
	    */

	    if ((*ptr)->attribute == descriptor) 
		return (*ptr)->value;

	    ptr = &((*ptr)->next);
	    }
	}

    return NULL;
    }


static void
MMcheckFreeProc(descriptor,free)
XrmQuark  descriptor;
freeProc  free;
    {
    freeProcRecPtr p;

    if (free == NULL)
	return;
  
    for (p = freeProcs;  p != NULL; p = p->next)
	if (p->descriptor == descriptor)
	    return;
    p = (freeProcRecPtr)XtMalloc(sizeof(freeProcRec));
    p->descriptor = descriptor;
    p->free       = free;
    p->next       = freeProcs;
    freeProcs = p;
    }

freeProc
MMgetFreeProc(descriptor)
XrmQuark descriptor;
    {
     freeProcRecPtr p;
  
     for (p = freeProcs;  p != NULL; p = p->next)
	 if (p->descriptor == descriptor)
	     return p->free;

     return XtFree;
     }

/* if the attribute list is available, use it, 
   otherwise check for wafeCurrentAttribList and use it if available,
   otherwise get the attriblist for the specified widget if available
   otherwise use wafeCurrentWidget if available 
   otherwise complain
 */

void
wafeMMreplace(w, al,descriptor,value,free)
Widget           w;
MMattribListPtr *al;
XrmQuark         descriptor;
char            *value;
freeProc         free;
    {
    MMattribListPtr *ptr;
    DBUG_ENTER("MMreplace");
    
    MMPRINT("MMreplace",("al=%p wafeCurrentAttribList=%pm descriptor=%ld", 
	    al, wafeCurrentAttribList, descriptor));

    if (!descriptor)
	{
	/* it looks like we have been called due to resource values 
	   during initialization */
	DBUG_VOID_RETURN;
	}

    if (!al) 
	{
	if (wafeCurrentAttribList)
	    al = wafeCurrentAttribList;
	else
	if (w)
	    al = wafeMMgetAttribList(w,True);
	else 
	if (wafeCurrentWidget)
	    al = wafeMMgetAttribList(wafeCurrentWidget,True);    
	else 
	    {
	    wafeWarn("mm","cannot obtain widgetList for attribute '%s'",
		     XrmQuarkToString(descriptor),NULL,NULL);
	    DBUG_VOID_RETURN;
	    }
	}
    
    ptr = al;

    while(*ptr) 
	{
	MMPRINT("mmreplace",("comparing desc %d (%s) and att %d (%s)",
		descriptor,XrmQuarkToString(descriptor),
		(*ptr)->attribute,XrmQuarkToString((*ptr)->attribute)));

	if ((*ptr)->attribute == descriptor) 
	    {
	    MMPRINT("MMreplace",("freeing value %p for <%s> setting %p",
		    (*ptr)->value,XrmQuarkToString((*ptr)->attribute),value));

	    if (free && (*ptr)->value) (*free)((*ptr)->value);
	    (*ptr)->value = value;

	    DBUG_VOID_RETURN;
	    }
	ptr = &((*ptr)->next);
	}

    *ptr = (MMattribListPtr)XtMalloc(sizeof(MMattribList));
    (*ptr)->next = NULL;                    
    (*ptr)->attribute = descriptor;
    MMcheckFreeProc(descriptor,free);

    MMPRINT("MMreplace",("new attriblistelement %p for %s in al %p, value=%p",
	    *ptr,XrmQuarkToString((*ptr)->attribute),al,value));
    (*ptr)->value = value;

#ifdef WIDGETLISTTRACE
    printAttributeList(*ptr);
#endif
    DBUG_VOID_RETURN;
    }
     

/*
 * wafeMMfreeGarbage(widget)
 * frees grabage frames and data 
 * when a widget is deleted
 * gustaf Sat Jul 11 15:09:12 MET DST 1992
 */
Widget
wafeMMfreeGarbage(w)
Widget      w;
    {
    WidgetListPtr    *ptr = &widgetListHead;
    WidgetListPtr     ptrTmp;
    MMattribListPtr   al,alTmp;
    int               count = 0;
    freeProc          free;

    DBUG_ENTER("MMfreeGarbage");

    MMPRINT("garbage",("freeing garbage for widget <%s>(%p)",
	    XtName(w),w));

    if (XtIsComposite(w)) 
	{
	Cardinal numChildren;
	WidgetList children;

	XtVaGetValues(w, 
		      XtNnumChildren, &numChildren,
		      XtNchildren, &children, 
		      NULL);

	while(numChildren) 
	    {
	    MMPRINT("garbage",("clearing for %p <%s> child of %p <%s>",
			       *children,XtName(*children),w,XtName(w)));

	    wafeMMfreeGarbage(*children);
	    numChildren--;
	    children++;        
	    }

	if (XtIsApplicationShell(w))
	    deleteFromWidgetList(&wafeWidgetTrees, w);
	}

/*
    fprintf(stderr,"----------after recursion %p %p\n",widgetListHead,*ptr);
    printWidgetList(*ptr);
 */

#ifdef USECONTEXT
    if(XFindContext(XtDisplay(w), (XID) w, wafeCtx, (XPointer *) &al)) 
	{
	(void) fprintf(stderr, "free garbage: cannot find context!\n");
	}
    while(al) 
	{
        MMPRINT("garbage",("attribute=%s freeing value %p",
		XrmQuarkToString(al->attribute),al->value));
	MMPRINT("garbage",("string = <%s>", al->value));

	if ((free = MMGetFreeProc(al->attribute))) 
	    (free)(al->value);

	MMPRINT("garbage",("freeing attribute list %p\n",al));
	alTmp = al->next;
	XtFree((char*)al);
	al = alTmp;
	}
    XDeleteContext(XtDisplay(w), (XID) w, wafeCtx);
#else
    while (*ptr) 
	{
/*
   fprintf(stderr,"garbage: widget to delete %p <%s>, actual widget %p <%s>\n",
   (*ptr)->widget,XtName((*ptr)->widget),w,XtName(w));
*/
	if ((*ptr)->widget == w) 
	    {
	    al = (MMattribListPtr)(*ptr)->info;

	    while(al) 
		{
		MMPRINT("garbage",("attribute=%s freeing value %p",
			XrmQuarkToString(al->attribute),al->value));
		MMPRINT("garbage",("string = <%s>",	al->value));

		if ((free = MMgetFreeProc(al->attribute))) 
		    (free)(al->value);

		MMPRINT("garbage",("freeing attribute list %p",al));
		alTmp = al->next;
		XtFree((char*)al);
		al = alTmp;
		}

	    MMPRINT("garbage",("freeing widgetlist %p", *ptr));
	    ptrTmp = (*ptr)->next; 
	    XtFree((char*)*ptr);
	    *ptr = ptrTmp;
	    break;
	    }
	ptr = &(*ptr)->next;
	count++;
	}
#endif

    MMPRINT("garbage",("counting %d frames", count));
    DBUG_RETURN(w);
    }


