#> The Commands described in this section are available in versions for
#> Wafe compiled with Motif Version 1.1 or newer.

$PACKAGE = "MOTIF11";

~handles 
	MOTIF11

#include <X11/Shell.h>
#include <Xm/RowColumn.h>

~require
motif.inc
	conv XtRString        XmRXmString      None CvtStringToXmString
	conv XtRString        XmRXmStringTable None CvtStringToXmStrings
	conv XtRString        XmRWindow        None CvtStringToWidget
	conv XtRString        XmRMenuWidget    None CvtStringToWidget
	conv XmRXmString      XtRString        None CvtXmStringToString
	conv XmRXmStringTable XtRString        None CvtXmStringTableToString
	conv XtRString        XmRTextPosition  None CvtStringToLong
        conv XtRString        XmRProc          None CvtStringToFileSearchProc
	init  wafeMotifInit();
	quark XmRXmString
	quark XmRWindow
	quark XmRShort
	quark XmRMenuWidget
	quark XmRHorizontalDimension
	quark XmRVerticalDimension
	quark XmRShellHorizDim
	quark XmRShellVertDim
	quark XmRTextPosition
	quark XmRVerticalPosition
	quark XmRHorizontalPosition
	quark XmRBackgroundPixmap
	quark XmRGadgetPixmap
	quark XmRManBottomShadowPixmap
	quark XmRManForegroundPixmap
	quark XmRManHighlightPixmap
	quark XmRManTopShadowPixmap
	quark XmRPixmap
	quark XmRPrimBottomShadowPixmap
	quark XmRPrimForegroundPixmap
	quark XmRPrimHighlightPixmap
	quark XmRPrimTopShadowPixmap
	quark XmRXmBackgroundPixmap
	quark XmNsource
	privateQuark XmRXmStringTable
	privateQuark XmNitems
	privateQuark XmNselectedItems
	privateQuark XmNfileSearchProc
	privateQuark XmNdirSearchProc
	init XtAddConverter (XmRString, XmRUnitType, XmCvtStringToUnitType, NULL, 0);


void
XmAddTabGroup
	in: Widget     		# widget to be added

~widgetClass
XmArrowButton
	include <Xm/ArrowB.h>
	activateCallback c int: \
		((XmArrowButtonCallbackStruct *)callData)->click_count # click count


~gadgetClass
XmArrowButtonGadget
	include <Xm/ArrowBG.h>
	activateCallback c int: \
		((XmArrowButtonCallbackStruct *)callData)->click_count # click count


~widgetClass
XmBulletinBoard
	include <Xm/BulletinB.h>

~pseudoWidgetClass
XmBulletinBoardDialog
	className XmBulletinBoard
	createCmd XmCreateBulletinBoardDialog
	createsShell

~widgetClass
XmCascadeButton
	include <Xm/CascadeB.h>

~gadgetClass
XmCascadeButtonGadget
	include <Xm/CascadeBG.h>

void 
XmCascadeButtonGadgetHighlight
	in: XmCascadeButtonGadget   	# cascadeButtonGadget to be highlighted
	in: Boolean          	    	# highlight (bool)

void 
XmCascadeButtonHighlight
	in: XmCascadeButtonGadget   	# widget to be highlighted
	in: Boolean          	    	# highlight (bool)

~widgetClass
XmCommand
	include <Xm/Command.h>
	commandChanged|commandEntered s EscapedXmString: \
		((XmCommandCallbackStruct *)callData)->value # command string

void
XmCommandAppendValue
	in: XmCommandWidget          	# command widget 
	in: XmString         		# command string

void
XmCommandError
	in: XmCommandWidget           	# command widget 
	in: XmString         		# error message

WidgetID (WidgetID)
XmCommandGetChild
	in: XmCommandWidget	        # command widget
	in: (unsigned char)XmChild 	# child reference

~widgetClass
XmDialogShell
	include <Xm/DialogS.h>
	createsShell
	addRes XmNdeleteResponse XmRDeleteResponse

~widgetClass
XmDrawingArea
        include <Xm/DrawingA.h>
	expose|input|resize i Window: \
		(XtPointer)((XmDrawingAreaCallbackStruct *)callData)->window \
		# id of the window where event occured


~widgetClass
XmDrawnButton
        include <Xm/DrawnB.h>
	activate c int: \
		((XmDrawnButtonCallbackStruct *)callData)->click_count 	\
		# click count
	expose|resize i Window: \
		(XtPointer)((XmDrawnButtonCallbackStruct *)callData)->window \
		# id of the window where event occured

~pseudoWidgetClass
XmErrorDialog
	className XmMessageBox
	createCmd XmCreateErrorDialog
	createsShell

~widgetClass
XmFileSelectionBox
	include <Xm/FileSB.h>
	ok|noMatch|apply|fileSearchProc|dirSearchProc d EscapedXmString: \
		((XmFileSelectionBoxCallbackStruct *)callData)->dir \
			# base directory
	ok|noMatch|apply|fileSearchProc|dirSearchProc p EscapedXmString: \
		((XmFileSelectionBoxCallbackStruct *)callData)->pattern \
			# search pattern
	ok|noMatch|apply|fileSearchProc|dirSearchProc m EscapedXmString: \
		((XmFileSelectionBoxCallbackStruct *)callData)->mask \
			# value of dirMask
	ok|noMatch|apply|fileSearchProc|dirSearchProc s EscapedXmString: \
		((XmFileSelectionBoxCallbackStruct *)callData)->value \
			# value of dirSpec

WidgetID (WidgetID)
XmFileSelectionBoxGetChild
	in: XmFileSelectionBoxWidget		# file selection box widget
	in: (unsigned char)XmChild 		# child reference

~pseudoWidgetClass
XmFileSelectionDialog
	className XmFileSelectionBox
	createCmd XmCreateFileSelectionDialog
	createsShell

void
XmFileSelectionDoSearch
	in: XmFileSelectionBoxWidget		# file selection box
	in: XmString				# directory mask

~widgetClass
XmForm
	include <Xm/Form.h>

~pseudoWidgetClass 
XmFormDialog
	className XmForm
	createCmd XmCreateFormDialog
	createsShell

~widgetClass
XmFrame
        include <Xm/Frame.h>

#> The function 'XmGetDestination' returns the widget id of the widget
#> that would be acted on by various selection operations (paste and
#> Clipboard routines). The function returns 0 if there is no current
#> distination (when no edit operations have been performed on a widget).

WidgetID (WidgetID)
XmGetDestination
	in: XtDisplay(Widget)	        # any widget

~pseudoWidgetClass
XmInformationDialog
	className XmMessageBox
	createCmd XmCreateInformationDialog
	createsShell

~widgetClass 
XmLabel
	include <Xm/Label.h>

~gadgetClass 
XmLabelGadget
	include <Xm/LabelG.h>

# *******  XmList Widget Class und programmatic Interface *******

~widgetClass
XmList
	include <Xm/List.h>
	browseSelection|defaultAction|singleSelection s EscapedXmString: \
		((XmListCallbackStruct *)callData)->item \
			# selected item
	browseSelection|defaultAction|singleSelection p int: \
		((XmListCallbackStruct *)callData)->item_position \
			# item position
	extendedSelection|multipleSelection S XmStringTable: \
		((XmListCallbackStruct *)callData)->selected_item_count, \
		((XmListCallbackStruct *)callData)->selected_items \
			# selected items
	extendedSelection|multipleSelection P intArray: \
		((XmListCallbackStruct *)callData)->selected_item_count, \
		((XmListCallbackStruct *)callData)->selected_item_positions \
			# selected item positions
	extendedSelection|multipleSelection n int: \
		((XmListCallbackStruct *)callData)->selected_item_count \
			# number of selected items
	browseSelection|defaultAction|extendedSelection|multipleSelection|singleSelection t int: \
		((XmListCallbackStruct *)callData)->selection_type \
			# selection type

void
XmListAddItem
	in: XmListWidget	# List Widget
	in: XmString		# Item to add
	in: int			# Position

void
XmListAddItems
	in: XmListWidget	# List Widget
	in: XmStringTable	# items
	in: int			# number of items
	in: int			# position

void
XmListAddItemUnselected
	in: XmListWidget	# List Widget
	in: XmString		# Item to add
	in: int			# Position

void
XmListDeleteAllItems
	in: XmListWidget	# List Widget

void
XmListDeleteItem
	in: XmListWidget	# List Widget
	in: XmString		# Item to delete

void
XmListDeleteItems
	in: XmListWidget	# List Widget
	in: XmStringTable	# items
	in: int			# number of items

void
XmListDeleteItemsPos
	in: XmListWidget	# List Widget	
	in: int			# number of items
	in: int			# position of first item to be deleted

void
XmListDeletePos
	in: XmListWidget	# List Widget	
	in: int			# position of item

void
XmListDeselectAllItems
	in: XmListWidget	# List Widget	

void
XmListDeselectItem
	in: XmListWidget	# List Widget	
	in: XmString		# item

void
XmListDeselectPos
	in: XmListWidget	# List Widget	
	in: int			# position of item

Boolean                          
XmListGetMatchPos
	in: XmListWidget	# List Widget   
	in: XmString		# item
	out: list(int*,int)	# list of positions  

Boolean
XmListGetSelectedPos
	in: XmListWidget	# List Widget
	out: list(int*,int)     # list of highlighted items

Boolean
XmListItemExists
	in: XmListWidget	# List Widget
	in: XmString		# Item

int
XmListItemPos
	in: XmListWidget	# List Widget
	in: XmString		# Item

void
XmListReplaceItems
	in: XmListWidget	# List Widget
	in: XmStringTable	# Items to be replaced
	in: int			# number of items to be replaced
	in: XmStringTable	# new items

void
XmListReplaceItemsPos
	in: XmListWidget	# List Widget
	in: XmStringTable	# New items
	in: int			# number of items to be replaced
	in: int 		# first Pos of items to be replaced

void
XmListSelectItem
	in: XmListWidget	# List Widget
	in: XmString		# item to highlight
	in: Boolean		# Invoke callback yes/no

void
XmListSelectPos
	in: XmListWidget	# List Widget
	in: int			# Position of item 
	in: Boolean		# Invoke callback yes/no

void
XmListSetAddMode
	in: XmListWidget 	# List Widget
	in: Boolean		# Use Add Mode yes/no

void
XmListSetBottomItem	
	in: XmListWidget 	# List Widget
	in: XmString		# item to be displayed as last item

void
XmListSetBottomPos
	in: XmListWidget 	# List Widget
	in: int			# item to be displayed as last item

void
XmListSetHorizPos
	in: XmListWidget 	# List Widget
	in: int			# horizontal Position

void
XmListSetItem
	in: XmListWidget 	# List Widget
	in: XmString		# item

void
XmListSetPos
	in: XmListWidget 	# List Widget
	in: int			# Position

# ****** Main Window Class ******

~widgetClass 
XmMainWindow
	include <Xm/MainW.h>

void
XmMainWindowSetAreas
	in: NULL | Widget	# main window widget
	in: NULL | Widget	# menu bar widget
	in: NULL | Widget	# command window widget
	in: NULL | Widget	# horizontal scrollbar widget
	in: NULL | Widget	# vertical scrollbar widget
	in: NULL | Widget	# work region widget

~pseudoWidgetClass 
XmMenuBar
	className XmRowColumn
	createCmd XmCreateMenuBar


~widgetClass
XmMenuShell
        include <Xm/MenuShell.h>
	createsShell

void
XmMenuPosition
	in: Widget		# menu widget
	const: (XButtonPressedEvent *) wafeCurrentEvent 

~widgetClass 
XmMessageBox
	include <Xm/MessageB.h>

WidgetID (WidgetID)
XmMessageBoxGetChild
	in: XmMessageBoxWidget		# message box widget
	in: (unsigned char)XmChild 	# child reference

~pseudoWidgetClass 
XmMessageDialog
	className XmMessageBox
	createCmd XmCreateMessageDialog
	createsShell

~pseudoWidgetClass
XmOptionMenu
	className XmRowColumn
	createCmd XmCreateOptionMenu

~widgetClass
XmPanedWindow
        include <Xm/PanedW.h>

~pseudoWidgetClass 
XmPopupMenu
	className XmRowColumn
	createCmd XmCreatePopupMenu

Boolean
XmProcessTraversal
	in: Widget		# Widget for which to traverse hierarchy
	in: (int) XmTravDir	# direction in which to traverse widget hierarchy

~pseudoWidgetClass
XmPromptDialog
	className XmSelectionBox
	createCmd XmCreatePromptDialog
	createsShell

~pseudoWidgetClass 
XmPulldownMenu
	className XmRowColumn
	createCmd XmCreatePulldownMenu

~widgetClass
XmPushButton
	include <Xm/PushB.h>
	activate c int: \
		((XmPushButtonCallbackStruct*)callData)->click_count \
			# click count

~gadgetClass
XmPushButtonGadget
	include <Xm/PushBG.h>
	activateCallback c int: \
		((XmPushButtonCallbackStruct*)callData)->click_count \
			# click count

~pseudoWidgetClass
XmQuestionDialog
	className XmMessageBox
	createCmd XmCreateQuestionDialog
	createsShell

~pseudoWidgetClass 
XmRadioBox
	className XmRowColumn
	createCmd XmCreateRadioBox

~widgetClass 
XmRowColumn
	include <Xm/RowColumn.h>
	entry e WidgetID: \
		(WidgetID) ((XmRowColumnCallbackStruct *)callData)->widget \
			# widgetID where entry occured

~widgetClass
XmScale
        include <Xm/Scale.h>
	drag|valueChanged v int: \
		((XmScaleCallbackStruct *)callData)->value # value



~widgetClass
XmScrollBar
        include <Xm/ScrollBar.h>
        toBottom|toTop p int: \
                ((XmScrollBarCallbackStruct *)callData)->pixel # pixel
        decrement|drag|increment|pageDecrement|pageIncrement|toBottom|toTop|valueChanged v int: \
                ((XmScrollBarCallbackStruct *)callData)->value # value

void
XmScrollBarGetValues 
	in: XmScrollBarWidget		# scrollbar widget
	out: int	      		# value (slider position)
        out: int              		# slider size
	out: int              		# increment (smallest movement)
	out: int              		# page increment 

void
XmScrollBarSetValues 
	in: XmScrollBarWidget 		# scrollbar widget
	in: int	              		# value (slider position)
        in: int               		# slider size
	in: int               		# increment (smallest movement)
	in: int               		# page increment 
	in: Boolean           		# notify


~pseudoWidgetClass
XmScrolledList
	className XmList
	createCmd XmCreateScrolledList

~pseudoWidgetClass 
XmScrolledText
	className XmText
	createCmd XmCreateScrolledText

~widgetClass
XmScrolledWindow
        include <Xm/ScrolledW.h>

~widgetClass
XmSelectionBox
        include <Xm/SelectioB.h>
	apply|noMatch|ok s EscapedXmString: \
		((XmSelectionBoxCallbackStruct *)callData)->value # value

WidgetID (WidgetID)
XmSelectionBoxGetChild
	in: XmSelectionBoxWidget	# selection box widget
	in: (unsigned char)XmChild 	# child reference

~pseudoWidgetClass
XmSelectionDialog
	className XmSelectionBox
	createCmd XmCreateSelectionDialog
	createsShell

~widgetClass 
XmSeparator
	include <Xm/Separator.h>

~gadgetClass 
XmSeparatorGadget
	include <Xm/SeparatoG.h>

~pseudoWidgetClass
XmSimpleCheckBox
	className XmRowColumn
	createCmd XmCreateSimpleCheckBox

~pseudoWidgetClass
XmSimpleMenuBar
	className XmRowColumn
        createCmd XmCreateSimpleMenuBar

~pseudoWidgetClass
XmSimpleOptionMenu
        className XmRowColumn
        createCmd XmCreateSimpleOptionMenu

~pseudoWidgetClass
XmSimplePopupMenu
        className XmRowColumn
        createCmd XmCreateSimplePopupMenu

~pseudoWidgetClass
XmSimplePulldownMenu
        className XmRowColumn
        createCmd XmCreateSimplePulldownMenu

~pseudoWidgetClass
XmSimpleRadioBox
        className XmRowColumn
        createCmd XmCreateSimpleRadioBox


# Motif 1.2 would only need the following definition...
#~widgetClass 
#XmText
#	include <Xm/Text.h>
#        losingFocus|modifyVerify|motionVerify i XmTextPosition: \
#                ((XmTextVerifyCallbackStruct *)callData)->currInsert \
#			# position of insert cursor
#        losingFocus|modifyVerify|motionVerify n XmTextPosition: \
#                ((XmTextVerifyCallbackStruct *)callData)->newInsert \
#			# new position of insert cursor
#        losingFocus|modifyVerify f XmTextPosition: \
#                ((XmTextVerifyCallbackStruct *)callData)->startPos \
#			# startPos (from)
#        losingFocus|modifyVerify t XmTextPosition: \
#                ((XmTextVerifyCallbackStruct *)callData)-> endPos \
#			# endPos (to)
#        modifyVerify s EscapedString: \
#                ((XmTextVerifyCallbackStruct *)callData)->text->ptr \
#			# text


~widgetClass 
XmText
	include <Xm/Text.h>
        losingFocus|modifyVerify|motionVerify i XmTextPosition: \
                ((XmTextVerifyCallbackStruct *)callData)->currInsert \
			# position of insert cursor
        losingFocus|modifyVerify|motionVerify n XmTextPosition: \
                ((XmTextVerifyCallbackStruct *)callData)->newInsert \
			# new position of insert cursor
        losingFocus|modifyVerify f XmTextPosition: \
                ((XmTextVerifyCallbackStruct *)callData)->startPos \
			# startPos (from)
        losingFocus|modifyVerify t XmTextPosition: \
                ((XmTextVerifyCallbackStruct *)callData)-> endPos \
			# endPos (to)
        modifyVerify s EscapedStringN: \
                ((XmTextVerifyCallbackStruct *)callData)->text->ptr, \
                ((XmTextVerifyCallbackStruct *)callData)->text->length \
			# text
	addRes XmNpendingDelete         XmRBoolean
	addRes XmNselectionArray        XmRPointer
	addRes XmNselectionArrayCount   XmRInt
	addRes XmNselectThreshold       XmRInt
	addRes XmNblinkRate             XmRInt
	addRes XmNcolumns               XmRShort
	addRes XmNcursorPositionVisible XmRBoolean
	addRes XmNfontList              XmRFontList
	addRes XmNrows                  XmRShort
	addRes XmNresizeHeight          XmRBoolean
	addRes XmNresizeWidth           XmRBoolean
	addRes XmNwordWrap              XmRBoolean
	addRes XmNscrollHorizontal      XmRBoolean
	addRes XmNscrollLeftSide        XmRBoolean
	addRes XmNscrollTopSide         XmRBoolean
	addRes XmNscrollVertical        XmRBoolean

void
XmTextClearSelection
	in: XmTextWidget 	# Text widget
	const: time(NULL)

Boolean
XmTextCopy
	in: XmTextWidget 	# Text widget
	const: time(NULL)

Boolean
XmTextCut
	in: XmTextWidget 	# Text widget
	const: time(NULL)

~widgetClass 
XmTextField
	include <Xm/TextF.h>
        losingFocus|modifyVerify|motionVerify i XmTextPosition: \
                ((XmTextVerifyCallbackStruct *)callData)->currInsert \
			# position of insert cursor
        losingFocus|modifyVerify|motionVerify n XmTextPosition: \
                ((XmTextVerifyCallbackStruct *)callData)->newInsert \
			# new position of insert cursor
        losingFocus|modifyVerify f XmTextPosition: \
                ((XmTextVerifyCallbackStruct *)callData)->startPos \
			# startPos (from)
        losingFocus|modifyVerify t XmTextPosition: \
                ((XmTextVerifyCallbackStruct *)callData)-> endPos \
			# endPos (to)
        modifyVerify s EscapedString: \
                ((XmTextVerifyCallbackStruct *)callData)->text->ptr \
			# text


void
XmTextFieldClearSelection
	in: XmTextFieldWidget 	# Text field widget
	const: time(NULL)

Boolean
XmTextFieldCopy
	in: XmTextFieldWidget 		# Text field widget
	const: time(NULL)

Boolean
XmTextFieldCut
	in: XmTextFieldWidget 		# Text field widget
	const: time(NULL)

int
XmTextFieldGetBaseline
	in: XmTextFieldWidget 		# Text field widget

XmTextPosition
XmTextFieldGetLastPosition
	in: XmTextFieldWidget 		# Text field widget

(String) DString
XmTextFieldGetSelection
	in: XmTextFieldWidget 		# Text field widget

Boolean
XmTextFieldGetSelectionPosition
	in: XmTextFieldWidget 	# Text field widget
	out: XmTextPosition	# left boundary
	out: XmTextPosition     # right boundary

(String) DString
XmTextFieldGetString
	in: XmTextFieldWidget	# Text field widget

void
XmTextFieldInsert
	in: XmTextFieldWidget 	# Text field widget
	in: XmTextPosition	# character position
	in: String              # text string to be inserted

Boolean
XmTextFieldPaste
	in: XmTextFieldWidget 	# Text field widget

Boolean
XmTextFieldPosToXY
	in: XmTextFieldWidget 	# Text field widget
	in: XmTextPosition	# character position
	out: Position		# x coord relative to top left
	out: Position		# y coord relative to top left

Boolean
XmTextFieldRemove
	in: XmTextFieldWidget 	# Text field widget

void
XmTextFieldReplace
	in: XmTextFieldWidget 	# Text field widget
	in: XmTextPosition	# from character position
	in: XmTextPosition	# to character position
	in: String 		# insert string

void
XmTextFieldSetAddMode
	in: XmTextFieldWidget 	# Text field widget
	in: Boolean		# true | false

void
XmTextFieldSetHighlight
	in: XmTextFieldWidget 	# Text field widget
	in: XmTextPosition	# from character position
	in: XmTextPosition	# to character position
	in: XmHighlightMode	# HIGHLIGHT_NORMAL | HIGHLIGHT_SELECTED | HIGHLIGHT_SECONDARY_SELECTED

void
XmTextFieldSetSelection
	in: XmTextFieldWidget 	# Text field widget
	in: XmTextPosition	# from character position
	in: XmTextPosition	# to character position
	const: time(NULL)

void
XmTextFieldShowPosition
	in: XmTextFieldWidget 	# Text field widget
	in: XmTextPosition	# character position to display

void
XmTextFieldXYToPos
	in: XmTextFieldWidget 	# Text field widget
	in: Position		# x coord relative to top left
	in: Position		# y coord relative to top left

int
XmTextGetBaseline
	in: XmTextWidget 	# Text widget

XmTextPosition
XmTextGetLastPosition
	in: XmTextWidget 	# Text widget

(String) DString
XmTextGetSelection
	in: XmTextWidget 	# Text widget

Boolean
XmTextGetSelectionPosition
	in: XmTextWidget 	# Text widget
	out: XmTextPosition	# left boundary
	out: XmTextPosition     # right boundary

(String) DString
XmTextGetString
	in: XmTextWidget	# Text widget

void
XmTextInsert
	in: XmTextWidget 	# Text widget
	in: XmTextPosition	# character position
	in: String              # text string to be inserted

Boolean
XmTextPaste
	in: XmTextWidget 	# Text widget

Boolean
XmTextPosToXY
	in: XmTextWidget 	# Text widget
	in: XmTextPosition	# character position
	out: Position		# x coord relative to top left
	out: Position		# y coord relative to top left

Boolean
XmTextRemove
	in: XmTextWidget 	# Text widget

void
XmTextReplace
	in: XmTextWidget 	# Text widget
	in: XmTextPosition	# from character position
	in: XmTextPosition	# to character position
	in: String 		# insert string

void
XmTextScroll
	in: XmTextWidget 	# Text widget
	in: int			# number of lines to scroll

void
XmTextSetAddMode
	in: XmTextWidget 	# Text widget
	in: Boolean		# true | false

void
XmTextSetHighlight
	in: XmTextWidget 	# Text widget
	in: XmTextPosition	# from character position
	in: XmTextPosition	# to character position
	in: XmHighlightMode	# HIGHLIGHT_NORMAL | HIGHLIGHT_SELECTED | HIGHLIGHT_SECONDARY_SELECTED

void
XmTextSetSelection
	in: XmTextWidget 	# Text widget
	in: XmTextPosition	# from character position
	in: XmTextPosition	# to character position
	const: time(NULL)

void
XmTextShowPosition
	in: XmTextWidget 	# Text widget
	in: XmTextPosition	# character position to display

void
XmTextXYToPos
	in: XmTextWidget 	# Text widget
	in: Position		# x coord relative to top left
	in: Position		# y coord relative to top left



~widgetClass 
XmToggleButton
	include <Xm/ToggleB.h>
	valueChangedCallback s int: \
		((XmToggleButtonCallbackStruct *)callData)->set # state

Boolean
XmToggleButtonGetState
	in: XmToggleButtonWidget	# toggle button widget

void
XmToggleButtonSetState
	in: XmToggleButtonWidget	# toggle button widget
	in: Boolean			# state (bool)
	in: Boolean             	# notify (bool)

~gadgetClass 
XmToggleButtonGadget
	include <Xm/ToggleBG.h>
	valueChangedCallback s int: \
		((XmToggleButtonCallbackStruct *)callData)->set # state

Boolean
XmToggleButtonGadgetGetState
	in: XmToggleButtonGadget	# toggle button gadget

void
XmToggleButtonGadgetSetState
	in: XmToggleButtonGadget	# toggle button gadget
	in: Boolean			# state (bool)
	in: Boolean             	# notify (bool)

void
XmUpdateDisplay
	in: Widget			# widget to determine display

~pseudoWidgetClass
XmWarningDialog
        className XmMessageBox
        createCmd XmCreateWarningDialog
	createsShell

~pseudoWidgetClass
XmWorkingDialog
        className XmMessageBox
        createCmd XmCreateWorkingDialog
	createsShell

#include <Xm/Protocols.h>

#define name2AtomNdsp(s) wafeStringToAtom(localVar1,s)

void
wafeAddProtocol vulgo XmAddProtocol
	in: Widget			# widget associated with protocol
	in: name2AtomNdsp(String)	# property atom 
	in: name2AtomNdsp(String)	# protocol atom 

void
wafeAddProtocolCallback vulgo XmAddProtocolCallback
	in: Widget			# widget associated with protocol
	in: name2AtomNdsp(String)	# property atom 
	in: name2AtomNdsp(String)	# protocol atom 
	in: String			# command to be executed

void
XmActivateProtocol
	in: Widget			# widget associated with protocol
	in: name2AtomNdsp(String)	# property atom 
	in: name2AtomNdsp(String)	# protocol atom 

void
XmDeactivateProtocol
	in: Widget			# widget associated with protocol
	in: name2AtomNdsp(String)	# property atom 
	in: name2AtomNdsp(String)	# protocol atom 

#> The procedure 'XmTextSetSelectionArray' sets the selection array
#> for the specified XmText widget. The selection array determines the
#> selection behavior on single, double, triple and so on clicks with
#> the left mouse button in the text widget. The nth position in this
#> array determines the behavior on the nth click. Possible values in
#> this array are: SELECT_POSITION, SELECT_WHITESPACE, SELECT_WORD,
#> SELECT_LINE, SELECT_PARAGRAPH and SELECT_ALL.
#> 
#> Example:    XmTextSetSelectionArray $w SELECT_WORD SELECT_LINE 

#define wafeTextSetSelectionArray(w,argc,array) \
     XtVaSetValues(w, XmNselectionArray,array,XmNselectionArrayCount, argc)

void
wafeTextSetSelectionArray vulgo XmTextSetSelectionArray
	in: XmTextWidget		# motif text widget
        const: argc-2
	in: [XmTextScanType]		# selection array

#> The procedure 'XmTextFieldSetSelectionArray' sets the selection
#> array for the specified XmTextField widget. The selection array
#> determines the selection behavior on single, double, triple and so
#> on clicks with the left mouse button in the text widget. The nth
#> position in this array determines the behavior on the nth
#> click. Possible values in this array are: SELECT_POSITION,
#> SELECT_WHITESPACE, SELECT_WORD, SELECT_LINE, SELECT_PARAGRAPH and
#> SELECT_ALL.
#> 
#> Example:    XmTextFieldSetSelectionArray $w SELECT_WORD SELCT_LINE 

void
wafeTextSetSelectionArray vulgo XmTextFieldSetSelectionArray
	in: XmTextFieldWidget		# motif text field widget
        const: argc-2
	in: [XmTextScanType]		# selection array

TCL_RETURN_CODE
wafeModifyVerifyCBset vulgo XmModifyVerifyCBset
        in: Boolean     		# doit
        in: long        		# currInsert
        in: long        		# startPos
        in: long        		# endPos
        in: String        		# String

Boolean
wafeInstallImage vulgo XmInstallImage
	in: XtDisplay(Widget)           # widget to determine display
	in: String                      # filename or data
        in: String                      # short name
   	const: False

