/* Copyright (C) 1992 by Gustaf Neumann, Stefan Nusser

 *      Wirtschaftsuniversitaet Wien, 
 *      Abteilung fuer Wirtschaftsinformatik
 *      Augasse 2-6, 
 *      A-1090 Vienna, Austria
 *      neumann@wu-wien.ac.at, nusser@wu-wien.ac.at

 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided
 * that the above copyright notice appears in all copies and that both that
 * copyright notice and this permission notice appear in all supporting
 * documentation.  This software is provided "as is" without expressed or
 * implied warranty.

 * Creation: Sun Dec 18 22:08:43 EST 1994 on mohegan
 * Author: genc
 * Version: 1.0.6


 */
#define XT_C
#include <wafe.h>
#include <X11/Shell.h>
#include <X11/Xatom.h>

 extern XrmQuark qString;
 extern XrmQuark qCallback;
 extern XrmQuark qPointer;
 extern XrmQuark qcallback;
 static XrmQuark qbusyWindow;
 static XrmQuark qxpmList;
 static XrmQuark qiconPixmap;
 static XrmQuark qInt;
 static XrmQuark qDimension;
 static XrmQuark qCardinal;
 static XrmQuark qPosition;
 static XrmQuark qFloat;
 static XrmQuark qDouble;
 static XrmQuark qPixel;
 static XrmQuark qBoolean;
 static XrmQuark qWidgetList;
 static XrmQuark qWidget;
/* 
 * ******* begin required file <Xt.inc> *******
 */

/* das ist ein -*- C -*- Programm */
#include <X11/cursorfont.h>
#include "wafe_quarks.h"

#ifdef MOTIF
# include <Xm/Xm.h>
# include <Xm/Text.h>
# ifdef MOTIF20
#  include <Xm/CSText.h>
# endif
#endif

#ifdef RDD
extern Boolean rddDeliverMessageEvent(
#if NeedFunctionPrototypes
    XEvent
#endif
);
#endif

extern Boolean wafeOwnSelectionCmd(
#if NeedFunctionPrototypes
     Widget, String, String, String
#endif
);

extern void callback (
#if NeedFunctionPrototypes
     Widget, char *, XtCallbackProc, char *
#endif
);

extern Cardinal wafeGetResourcesOfClass(
#if NeedFunctionPrototypes
     WidgetClass, QTypeList *
#endif
);

extern Cardinal wafeGetConstraintsOfClass(
#if NeedFunctionPrototypes
     WidgetClass, QTypeList *
#endif
);

extern void wafeCallbackCmd(
#if NeedFunctionPrototypes
     int, char**, Widget, XtCallbackProc
#endif
);

#ifdef ATHENA
#include <X11/Xaw/List.h>
#include <X11/Xaw/Toggle.h>
#include <X11/Xaw/Text.h>
#include <X11/Xaw/AsciiText.h>
#endif


static void
action(w, TranslationModifier, translationTable)
Widget	w;
int	TranslationModifier;
XtTranslations translationTable;
    {
    switch (TranslationModifier) 
        {
	case 1: XtOverrideTranslations(w, translationTable);
		break;
	case 2: XtAugmentTranslations(w, translationTable);
		break;
	case 3: XtVaSetValues (w, XtNtranslations, translationTable, NULL);
		break;
        }
    }


static void
realizeWidgets()
    {
    WidgetListPtr ptr = wafeWidgetTrees;
    while(ptr) 
	{
	XtRealizeWidget(ptr->widget);
	ptr = ptr->next;
	}
    }

static void
callCallbacks(w, callback, argc,argv)
Widget   w;
String   callback;
int      argc;
char   **argv;
    {
    if (argc == 0) 
	{
#ifdef MOTIF
	XmAnyCallbackStruct callData;
	callData.reason = XmCR_NONE;
	callData.event  = wafeCurrentEvent;
	XtCallCallbacks(w, callback, (XtPointer)&callData);
#else
	XtCallCallbacks(w, callback, NULL);
#endif
	}
    else
    if (!strcmp(argv[0], "float"))
	{
	float   f;
	sscanf(argv[1], "%f", &f);
	XtCallCallbacks(w, callback, (XtPointer)&f);
	}
    else
	wafeWarn("callCallbacks","Wrong type: %s", argv[1], NULL,NULL);
    }


static void
callActionProc(w, eventType, action, argc, argv)
Widget         w;
String         eventType;
String         action;
int            argc;
char         **argv;
    {
    char          *token;
    XEvent         event;
    Display       *display = XtDisplay(wafeTopLevel);
    Window         win = XtWindow(w), root, child;
    int            x, y, xR, yR;
    unsigned int   state, button, keycode;
    char *procName = "callActionProc";

    if (!strcmp(eventType, ""))
	{
	event.type = 0;
	event.xany.display = display;
	event.xany.window = win;
	}
    else
	{
	token = strtok(eventType, " ");
	if (strcmp(token, "type"))
	    {
	    wafeWarn(procName,"Missing type; aborting command",
		      NULL,NULL,NULL);
	    return;
	    }

	XQueryPointer(display, win, &root, &child, &xR, &yR, &x, &y, &state);

	token = strtok(NULL, " ");
	if (!strcmp(token, "buttonEvent"))
	    {
	    token = strtok(NULL, " ");
	    if (!strcmp(token, "button"))
		{
		token = strtok(NULL, " ");
		if (!strcmp(token, "button1"))
		    button = Button1;
		else
                if (!strcmp(token, "button2"))
		    button = Button2;
                else
                if (!strcmp(token, "button3"))
		    button = Button3;
		else
                if (!strcmp(token, "button4"))
		    button = Button4;
		else
                if (!strcmp(token, "button5"))
		    button = Button5;
		else
		    {
		    wafeWarn(procName,"Unknown Button, %s", 
			     token,NULL,NULL);
		    return;
		    }
		}
	    else
		{
		wafeWarn(procName,
			 "This event field (%s) can't be specified\n", 
			 token,NULL,NULL);
		return;
		}

	    event.type = ButtonPress;
	    event.xbutton.display = display;
	    event.xbutton.window = win;
	    event.xbutton.root = root;
	    event.xbutton.subwindow = child;
	    event.xbutton.x = x;
	    event.xbutton.y = y;
	    event.xbutton.x_root = xR;
	    event.xbutton.y_root = yR;
	    event.xbutton.state = state;
	    event.xbutton.button = button;
	    }
	else if(!strcmp(token, "keyEvent"))
	    {
	    token = strtok(NULL, " ");
	    if (!strcmp(token, "key"))
		{                   
		token = strtok(NULL, " ");
		keycode = XKeysymToKeycode(display, XStringToKeysym(token));
		}
	    else
		{
		wafeWarn(procName,
			 "This event field (%s) can't be specified", 
			 token,NULL,NULL);
		return;
		}

	    event.type = KeyPress;
	    event.xkey.display = display;
	    event.xkey.window = win;
	    event.xkey.root = root;
	    event.xkey.subwindow = child;
	    event.xkey.x = x;
	    event.xkey.y = y;
	    event.xkey.x_root = xR;
	    event.xkey.y_root = yR;
	    event.xkey.state = state;
	    event.xkey.keycode = keycode;
	    }
	else
	    {
	    wafeWarn(procName,
		     "This event field (%s) can't be specified", 
		     token,NULL,NULL);
	    return;
	    }                    
	}

    XtCallActionProc(w, action, &event, argv, argc);
    return;
    }

/* used by addTimeOut */
static void
timerProc(command, junk)
XtPointer        command;
XtIntervalId     *junk;
    {
    DBUG_ENTER("timerProc");
    (void) wafeEval(wafeInterpreter, (char *)command, "timerProc");
    XtFree((char *)command);
    DBUG_VOID_RETURN;
    }

/* used by addTimeOut */
static Boolean
workProc(command)
XtPointer command;
    {
    char *r;
    int  rc;

    DBUG_ENTER("workProc");
    rc = wafeEval(wafeInterpreter, (char *)command, "workProc");
    r = wafeInterpreter->result;
    if ( rc || ( r && *r++ == '1' && *r == '\0' ) ) /* don't do it again */
	{
	XtFree((char *)command);
	DBUG_RETURN(True);
	}
    DBUG_RETURN(False);
    }


static char *
cvtToString(clientData, qType, freeProcPtr)
XtPointer     clientData;
XrmQuark      qType;
freeProc     *freeProcPtr;
    {
    XrmValue   input,output;
    
    DBUG_PRINT("conv", ("Converting to <%s>", 
			XrmQuarkToString(qType)));

    input.addr  =  clientData;        
    input.size  =  sizeof(XtPointer);     /* ??? */
    output.addr =  NULL;

    IFCONVERTANDSTORE(wafeTopLevel, 
		      XrmQuarkToString(qType),input, 
		      XtRString, output)
	{
#ifdef MOTIF
	if (qType == qXmString) 
	  XmStringFree((XmString)clientData);
#endif
	*freeProcPtr = XtFree;
	return output.addr;
	}
    else
	return NULL;
    }



static String
getValue(w, Qname, freeProcPtr)
Widget      w;
XrmQuark    Qname;
freeProc   *freeProcPtr;
    {
    char        *result;
    XrmQuark     Qtype;
    XtPointer    value;
    Arg          arg;
    WidgetClass  wClass   = XtClass(w);
    char        *procName = "getValue";
    char        *resName  = XrmQuarkToString(Qname);

    DBUG_PRINT(procName, ("widget is %p resource is <%s>", w, resName)); 

    if (!(Qtype = wafeGetQTypeOfAttribute(wClass,ParentWidget(w),Qname,NULL)))
	{
	wafeWarn(procName,"Unknown Attribute %s", resName,NULL,NULL);
	*freeProcPtr = TCL_STATIC;
	return NULL;
	}

    if (Qtype == qString)
	{
	String    valueString;
	*freeProcPtr = TCL_VOLATILE;
	XtVaGetValues(w, resName, &valueString, NULL);
	return valueString;
	}

    /* this is the Default value for the following types 
     * assuming that dense code is better than one instruction more
     */ 
    *freeProcPtr = XtFree;
	
    if (Qtype == qInt) 
	{
	int valueInt;
	result = XtMalloc(INT_AS_STRING);
	XtVaGetValues(w, resName, &valueInt, NULL);
	sprintf(result, "%d", (int)valueInt);
	return result;
	}

    if (Qtype == qPosition
#ifdef MOTIF
	|| Qtype == qVerticalPosition
	|| Qtype == qHorizontalPosition
	|| Qtype == qShort
#endif
       )
	{
	Position    valuePosition;
	result = XtMalloc(INT_AS_STRING);
	XtVaGetValues(w, resName, &valuePosition, NULL);
	sprintf(result, "%hd", valuePosition);
	return result;
        }
#ifdef MOTIF
    if (Qtype == qTextPosition) 
	{
	XmTextPosition    valuePosition;
	result = XtMalloc(INT_AS_STRING);
	XtVaGetValues(w, resName, &valuePosition, NULL);
	sprintf(result, "%ld", valuePosition);
	return result;
        }
#endif

    if (Qtype == qDimension
#ifdef MOTIF
	|| Qtype == qVerticalDimension
	|| Qtype == qHorizontalDimension
	|| Qtype == qShellHorizDim
	|| Qtype == qShellVertDim
#endif
	) 
	{
	Dimension    valueDimension;
	result = XtMalloc(INT_AS_STRING);
	XtVaGetValues(w, resName, &valueDimension, NULL);
	sprintf(result, "%hu", valueDimension);
	return result;
        }

    if (Qtype == qCardinal)
	{
	Cardinal    valueCardinal;
	result = XtMalloc(INT_AS_STRING);
	XtVaGetValues(w, resName, &valueCardinal, NULL);
	sprintf(result, "%u", valueCardinal);	
	return result;
	}

    if (Qtype == qBoolean)
	{
	Boolean    valueBoolean;
	*freeProcPtr = TCL_STATIC;
	XtVaGetValues(w, resName, &valueBoolean, NULL);
	return valueBoolean ? "1" : "0";   
	}

#ifdef MOTIF20
    if (Qtype == qSet) 
	{
	unsigned char valueSet;
	*freeProcPtr = TCL_STATIC;
	XtVaGetValues(w, resName, &valueSet, NULL);
	switch (valueSet) 
	    {
	case XmUNSET:         return "0";
	case XmSET:           return "1";
	case XmINDETERMINATE: return "indeterminate";
	    }
        }
#endif

    if (Qtype == qFloat) 
	{
	float    valueFloat;
	result = XtMalloc(FLOAT_AS_STRING);
	XtVaGetValues(w, resName, &valueFloat, NULL);
	sprintf(result, "%f", valueFloat);
	return result;
	}

    if (Qtype == qDouble) 
	{
	double    valueDouble;
	result = XtMalloc(FLOAT_AS_STRING);
	XtVaGetValues(w, resName, &valueDouble, NULL);
	sprintf(result, "%f", valueDouble);
	return result;
	}

    if (Qtype == qPixel) 
	{
	XColor  c;
	Display *dpy = XtDisplay(w);
	result = XtMalloc(8); /* "#RRGGBB" */
	XtVaGetValues(w, resName, &(c.pixel), NULL);
	XQueryColor(dpy,DefaultColormap(dpy, DefaultScreen(dpy)),&c);
	sprintf(result, "#%02X%02X%02X", 
		(int)(c.red>>8), (int)(c.green>>8), (int)(c.blue>>8));
	return result;
	}

     /* Callbacks sind ... anders: die String-Information 
	kommt aus wafe's privatem Memory-Management und nicht 
	ber getValues!
      */
    if (Qtype == qCallback) 
	{
	MMattribListPtr ptr = *wafeMMgetAttribList(w,True);
	
	*freeProcPtr = TCL_STATIC;
	result = NULL;
	/* try to get callback through memory management */
	while(ptr) 
	    {
	    if (ptr->attribute == Qname) 
		{
		result = ((char*)ptr->value) +
		    sizeof(XtCallbackList)*2 +
		    sizeof(XtCallbackRec[2]) +
		    sizeof(XrmQuark);
		break;
		}
	    ptr = ptr->next;
	    }
	/* try to get callback from callback list */
	if (!result) 
	    {
	    XtCallbackList cbl;
	    XtVaGetValues(w, resName, &cbl, NULL);
	    for (; cbl->callback; cbl++)
		{
		if ( cbl->callback == wafeExecCallbackProc ) 
		    {
		    result = ((char*)cbl->closure) + sizeof(XrmQuark);
		    break;
		    }
		}
	    }
	if (!result) 
	    result = "";
	return result;
	}

    if (Qtype == qWidget
#ifdef MOTIF
	|| Qtype == qWindow
	|| Qtype == qMenuWidget
	|| (Qtype == qPointer && 
	    (wClass == xmTextWidgetClass 
#ifdef MOTIF20
	    || wClass == xmCSTextWidgetClass
#endif
	    ) &&
	    Qname == qsource)
#endif
	)
	{
	Widget valueWidget;
	result = XtMalloc(INT_AS_STRING);
	XtVaGetValues(w, resName, &valueWidget, NULL);
	sprintf(result, "%ld", (long)valueWidget);
	return result;
	}

    if (Qtype == qWidgetList) 
        {
	WidgetList children;
        Cardinal   numChildren;
        XtVaGetValues(w, XtNnumChildren, &numChildren,
                         XtNchildren,    &children,    NULL);
	return wafeCvtWidgetListToList(NULL, numChildren, children);
        }


    if (Qtype == qPointer) 
	{
#ifdef ATHENA
	if (wClass == listWidgetClass && Qname == qlist)
	    {
	    char **argv;
	    int argc;
	    XtVaGetValues(w, XtNnumberStrings, &argc,
			  XtNlist,          &argv,    NULL);
	    return Tcl_Merge(argc, argv);
	    }
	else
	if (wClass == toggleWidgetClass && Qname == qradioData)
	    {
	    XtPointer p;
	    *freeProcPtr = TCL_STATIC;
	    XtVaGetValues(w, resName, &p, NULL);
	    return XrmQuarkToString((XrmQuark)p);
	    }
	else
#endif
	    {
	    XtPointer p;
	    *freeProcPtr = TCL_STATIC;
	    XtVaGetValues(w, resName, &p, NULL);
	    return (String)p;
	    }
	}
    else 
	{
	/*
	 * warning: cvtToString assumes, you can free the result 
	 * using XtFree
	 */
	XrmQuark oldAttrib = wafeCurrentAttrib;
	Widget   oldWidget = wafeCurrentWidget;

	XtSetArg(arg, resName, &value);
	XtGetValues(w, &arg, (Cardinal)1);

	wafeCurrentAttrib = Qname;
	wafeCurrentWidget = w;
	result = cvtToString(value, Qtype, freeProcPtr);
	wafeCurrentAttrib = oldAttrib;
	wafeCurrentWidget = oldWidget;

	if (!result)
	    {
	    wafeWarn(procName, "Couldn't convert value for %s to string",
		     resName,NULL,NULL);
	    return NULL;
	    }
	return result;
      }
    }

static int
getResourceList(w, resultPtr)
char    ***resultPtr; 
Widget   w;
    {
    int numTotal, count;
    char **result;
    int rNum = 0;
    int cNum = 0;
    QTypeList rList, cList;

    rNum = wafeGetResourcesOfClass(XtClass(w), &rList);

    if (XtIsConstraint(ParentWidget(w)))   /* If parentWidget is constrain widget => fetch constraints */
	cNum =  wafeGetConstraintsOfClass(XtClass(ParentWidget(w)), &cList);

    numTotal = rNum + cNum;

    *resultPtr = result = (char **)XtMalloc(numTotal *sizeof(char *));       

    for ( count = 0; count < rNum; count++)
	*result++ = XrmQuarkToString(rList[count].qName);

    for ( count = 0; count < cNum; count++)
	*result++ = XrmQuarkToString(cList[count].qName);

    return(numTotal);
    }



typedef struct _busyStruct
    {
    Window                busyWindow;
    Boolean               state;
    } busyStruct, *busyStructPtr;


static void
setBusy(w,sensitive)
Widget w;
Boolean sensitive;
    {
    unsigned long valuemask;
    XSetWindowAttributes attributes;
    MMattribListPtr *al = wafeMMgetAttribList(w,True);
    busyStructPtr bs = (busyStructPtr) wafeMMgetValue(al, qbusyWindow);
    Display *dpy = XtDisplay(w);

    if (sensitive)
	{
	if (!bs)
	    {
	    Screen *scr = XtScreen(w);
	    
	    bs = (busyStructPtr) XtMalloc(sizeof(busyStruct));
	    wafeMMreplace(al,qbusyWindow,(char*)bs,XtFree);
            bs->state = False;

	    /* Ignore device events while the busy cursor is displayed. */
	    valuemask = CWDontPropagate | CWCursor;
	    attributes.do_not_propagate_mask =  
		(KeyPressMask | KeyReleaseMask |
		 ButtonPressMask | ButtonReleaseMask | PointerMotionMask);
	    attributes.cursor = XCreateFontCursor(dpy, XC_watch);

	  /* The window will be as big as the display screen, and clipped by
	   * its own parent window, so we never have to worry about resizing
	   */

	    bs->busyWindow = 
		XCreateWindow(dpy, XtWindow(w), 0, 0,
			      HeightOfScreen(scr)*2, WidthOfScreen(scr)*2, 
			      0, 0, InputOnly, CopyFromParent, 
			      valuemask, &attributes);
	    }
	if (!bs->state) 
	     {
	     XMapRaised(dpy, bs->busyWindow);
	     bs->state = True;
	     }
        }
    else
	{
	if (bs && bs->state)
	    {
	    XUnmapWindow(dpy, bs->busyWindow);
	    bs->state = False;
	    }
	}
    }


static String
waitForVariable(varName)
String varName;
    {
    String result = NULL;
    Tcl_UnsetVar(wafeInterpreter,varName,TCL_GLOBAL_ONLY);
    wafeInnerEventLoop ++;
    while (!(result = Tcl_GetVar(wafeInterpreter,varName,TCL_GLOBAL_ONLY)))
	XtAppProcessEvent(wafeAppContext, XtIMAll);
    wafeInnerEventLoop --;
    return result;
    }


static void
processPendingEvents()
    {
    while (XtAppPending(wafeAppContext))
       {
       XEvent event;
       XtAppNextEvent(wafeAppContext,&event);
#ifdef RDD
       if (rddDeliverMessageEvent(event))
	   continue;
#endif
       wafeInnerEventLoop ++;
       XtDispatchEvent(&event);
       wafeInnerEventLoop --;
       }
    }

typedef int MapState;

static MapState
mapState(w)
Widget w;
    {
    XWindowAttributes wattr;
    Window win = XtWindow(w);
    
    if (!win) return 0;
    if (!XGetWindowAttributes(XtDisplay(w), win, &wattr)) return 0;
    return wattr.map_state;
    }

#ifndef PRER5
static Status
combineFileDatabase(fname,w,override)
String fname;
Widget w;
Bool override;
    {
    XrmDatabase dispDb = XtDatabase(XtDisplay(w)); 
    return XrmCombineFileDatabase(fname, &dispDb, override);
    }
#endif

static Boolean
motifWMRunning(shell)
Widget shell;
    {
#ifdef MOTIF
    return XmIsMotifWMRunning(shell);
#else
    Display  *dpy         = XtDisplay(shell);
    Window    root        = RootWindowOfScreen(XtScreen(shell));
    Atom      motifWmInfo = XInternAtom(dpy, "_MOTIF_WM_INFO", False);

    Atom      actual_type;
    int       actual_format;
    unsigned long nitems, bytes_after;
    unsigned char* prop;

    XGetWindowProperty(dpy, root, motifWmInfo, 0,0, FALSE,motifWmInfo,
		       &actual_type,&actual_format,&nitems,&bytes_after,
		       &prop);
    return (actual_type == motifWmInfo && actual_format == 32);
#endif
    }

static Boolean
wafeGetBool(string,boolPtr)
String string;
Bool *boolPtr;
    {
    int tclBool;
    if (TCL_OK == Tcl_GetBoolean(wafeInterpreter,string,&tclBool))
	{
	*boolPtr = (Bool)(tclBool);
	return True;
	}
    else 
	return False;
    }

#ifndef PRER5
static int
getActionList(wClass) 
WidgetClass wClass;
    {
    Cardinal num;
    XtActionList al,a;

#ifdef ATHENA
    /* only the textWidgetList has the action list :( */
    if (wClass == asciiTextWidgetClass) 
	wClass = textWidgetClass;
#endif    
    XtGetActionList(wClass, &al, &num);
    for(a=al; num; num--, a++) 
	Tcl_AppendElement(wafeInterpreter, a->string);

    if (al) XtFree((char *)al);
    return TCL_OK;
    }
#endif

/* convert string to pointer, ATHENA widget version, where Quark or lists
   are set; there is also another version which only sets strings...
 */
static Boolean
CvtStringToPointer(dpy, args, num_args, fromVal, toVal, converter_data)
Display *dpy;
XrmValue *args;
Cardinal *num_args;
XrmValue *fromVal;
XrmValue *toVal;
XtPointer *converter_data;
    {
    WidgetClass wClass = 
      wafeCurrentWidget ? XtClass(wafeCurrentWidget) : NULL;
    Boolean canDoClassSpecificConversion = 
	(wafeCurrentAttrib && wafeCurrentWidget);

    DBUG_ENTER("CvtStringToPointer");
#ifdef ATHENA
    if (canDoClassSpecificConversion == False)
	{
	/* delay conversion */
	wafePointerResourceValue = True;
	DBUG_RETURN(True);
	}

    if (wafeCurrentAttrib == qradioData && wClass == toggleWidgetClass)
	{
	static XrmQuark value;
	DBUG_PRINT("conv",("radioDdata of Toggle"));

	value = XrmStringToQuark((char *)fromVal->addr);
	if (toVal->addr) 
	    *(XtPointer *)(toVal->addr) = (XtPointer)value;
	else
	    toVal->addr = (caddr_t)&value;
	toVal->size = sizeof(XtPointer);
	} 
    else 
    if (wafeCurrentAttrib == qlist && wClass == listWidgetClass)
	{
	static int argc;
	static char ** argv;

	DBUG_PRINT("conv",("list of List"));
	Tcl_SplitList(wafeInterpreter,(char *)fromVal->addr, &argc,&argv);
	if (argc == 0) 
	    { 
	    char **p;
	    /* if the number of Elements is 0, the list widget 
	       tries to calculate the number of elements based on the
	       argv vector. We have to set the the 0-element list to
	       a one element list with a zero element
	     */
	    XtFree((char *)argv);
	    p = argv = (char **)XtMalloc(sizeof(char*)*2+sizeof(char));
	    *++p = NULL;
	    *argv = (char *)++p;
	    *(char *)p = '\0';
	    argc = 1;
	    }

	if (toVal->addr) 
	    {
	    if (toVal->size < sizeof(String *)) 
		{
		toVal->size = sizeof(String *);
		XtFree((char *)argv);
		return False;
		}
	    *(String **)(toVal->addr) = (String *)argv;
	    }
	else
	    {
	    toVal->addr = (caddr_t)&argv;
	    wafeMMreplace(wafeCurrentAttribList, wafeCurrentAttrib, 
			  (char *)argv, XtFree);
	    }
	toVal->size = sizeof(String *);

	if (wafeCurrentWidget) 
	    XtVaSetValues(wafeCurrentWidget,
			  XtNnumberStrings,argc,
			  NULL);
	}
    else
#endif
	{

#ifdef MOTIF	
	if ( wafeCurrentAttrib == qsource &&
	    (wClass == xmTextWidgetClass 
#ifdef MOTIF20
	     || wClass == xmCSTextWidgetClass
#endif
	     ))
	    {
	    char *end;
	    static Widget result;
	    
	    if (canDoClassSpecificConversion == False || toVal->addr) 
		result = NULL;
	    else
		result = (Widget)strtol((char *)fromVal->addr,&end,10);

	    if (result)
		{
		toVal->addr = (XtPointer)&result;
		toVal->size = sizeof(Widget);
		}
	    else
		{
		XtDisplayStringConversionWarning(dpy, (String)fromVal->addr, 
						 "XmTextSource");
		DBUG_RETURN(False);
		}
	    }
	else 
#endif
	    {
	    
	    DBUG_PRINT("conv",("default"));

	    if (toVal->addr) 
		{
		*(String *)(toVal->addr) = (String)fromVal->addr;
		}
	    else
		{
		static char* p;
		p = XtNewString(fromVal->addr);
		toVal->addr = (caddr_t)&p;
		wafeMMreplace(wafeCurrentAttribList, wafeCurrentAttrib, 
			      (char *)p, XtFree);
		}
	    toVal->size = sizeof(String);
	    }
	}

    DBUG_RETURN(True);
    }

/* 
 * ******* end required file <Xt.inc> *******
 */
/* 
 * XtIntervalId
 * XtAppAddTimeOut 
 * 	const: wafeAppContext 
 * 	in: unsigned long		# time interval in ms
 * 	const: timerProc
 * 	in: XtNewString(String)		# Tcl command
 */

static int 
cmd_addTimeOut(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     unsigned long localVar1;
     XtIntervalId returnVar;
     char conversionBuffer[100];

     DBUG_ENTER(argv[0]);  

     if (argc != 3) 
	 {
	 wafeArgcError(argc,argv,"",2);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(sscanf(argv[1], "%lu", &localVar1)))
         {
         wafeConvError(argc, argv, 2 ,NULL, "unsigned long");
         DBUG_RETURN (TCL_ERROR);
         }

    /* no need to assign  << localVar2 = argv[2] >>  */ 

     returnVar = XtAppAddTimeOut(wafeAppContext,localVar1,timerProc,XtNewString(argv[2]));

     sprintf(conversionBuffer, "%lu", returnVar);
     Tcl_SetResult(comInterpreter, conversionBuffer, TCL_VOLATILE);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * action
 * 	in: Widget			# widget
 * 	in: (int)TranslationModifier	# override | augment | replace
 *         in: XtTranslations		# translation table
 */

static int 
cmd_action(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     int localVar2;
     XtTranslations localVar3;

     DBUG_ENTER(argv[0]);  

     if (argc != 4) 
	 {
	 wafeArgcError(argc,argv,"",3);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 = (Widget) name2Widget(argv[1])))
         {
         wafeConvError(argc, argv, 1 ,NULL, "Widget");
         DBUG_RETURN (TCL_ERROR);
         }

     if (!strcmp(argv[2], "override")) 
         localVar2 = 1;
     else
     if (!strcmp(argv[2], "augment")) 
         localVar2 = 2;
     else
     if (!strcmp(argv[2], "replace")) 
         localVar2 = 3;
     else
         {
         wafeConvError(argc,argv, 2,NULL, "TranslationModifier");
         DBUG_RETURN (TCL_ERROR);
        }


     if (!(localVar3 = (XtTranslations) XtParseTranslationTable(argv[3])))
         {
         wafeConvError(argc, argv, 3 ,NULL, "XtTranslations");
         DBUG_RETURN (TCL_ERROR);
         }

     action(localVar1,localVar2,localVar3);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XBell
 * 	in: XtDisplay(Widget)		# widget to determine display
 * 	in: int				# percent (-100 = off, 0 .. 100)
 */

static int 
cmd_bell(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     int localVar2;

     DBUG_ENTER(argv[0]);  

     if (argc != 3) 
	 {
	 wafeArgcError(argc,argv,"",2);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 = (Widget) name2Widget(argv[1])))
         {
         wafeConvError(argc, argv, 1 ,NULL, "Widget");
         DBUG_RETURN (TCL_ERROR);
         }

     if (!(sscanf(argv[2], "%d", &localVar2)))
         {
         wafeConvError(argc, argv, 2 ,NULL, "int");
         DBUG_RETURN (TCL_ERROR);
         }

     XBell(XtDisplay(localVar1),localVar2);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * callActionProc
 * 	in: Widget			# widget
 * 	in: String			# event structure
 * 	in: String			# name of action procedure
 * 	in: [args opt]			# parameters of action procedure
 */

static int 
cmd_callActionProc(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;

     DBUG_ENTER(argv[0]);  

     if (argc < 4) 
	 {
	 wafeArgcError(argc,argv,"at least ",3);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 = (Widget) name2Widget(argv[1])))
         {
         wafeConvError(argc, argv, 1 ,NULL, "Widget");
         DBUG_RETURN (TCL_ERROR);
         }

    /* no need to assign  << localVar2 = argv[2] >>  */ 

    /* no need to assign  << localVar3 = argv[3] >>  */ 

     argc -= 4;
     callActionProc(localVar1,argv[2],argv[3],argc,&argv[4]);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * callCallbacks
 * 	in: Widget			# widget
 * 	in: String			# callback
 * 	in: [args opt]			# optional float and value
 */

static int 
cmd_callCallbacks(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;

     DBUG_ENTER(argv[0]);  

     if (argc < 3) 
	 {
	 wafeArgcError(argc,argv,"at least ",2);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 = (Widget) name2Widget(argv[1])))
         {
         wafeConvError(argc, argv, 1 ,NULL, "Widget");
         DBUG_RETURN (TCL_ERROR);
         }

    /* no need to assign  << localVar2 = argv[2] >>  */ 

     argc -= 3;
     callCallbacks(localVar1,argv[2],argc,&argv[3]);

     DBUG_RETURN (TCL_OK);
     }     


extern wafePositionCallbackProc();
extern wafePositionCursorCallbackProc();

#define wafeCallbackCmdArgs(w,res,type,arg) wafeCallbackCmd(argc,argv,w,type)

/* 
 * void
 * wafeCallbackCmdArgs vulgo callback
 * 	in: Widget			# widget
 * 	in: String			# callback resource
 *         in: XtCallbackProc		# none | exclusive | nonexclusive | popdown | position | positionCursor
 *         in: String			# string (depends on third argument, widget reference for none | exclusive | nonexclusive | popdown)
 */

static int 
cmd_callback(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     XtCallbackProc localVar3;

     DBUG_ENTER(argv[0]);  

     if (argc != 5) 
	 {
	 wafeArgcError(argc,argv,"",4);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 = (Widget) name2Widget(argv[1])))
         {
         wafeConvError(argc, argv, 1 ,NULL, "Widget");
         DBUG_RETURN (TCL_ERROR);
         }

    /* no need to assign  << localVar2 = argv[2] >>  */ 

     if (!strcmp(argv[3], "exec")) 
         localVar3 = (XtCallbackProc)wafeExecCallbackProc;
     else
     if (!strcmp(argv[3], "none")) 
         localVar3 = XtCallbackNone;
     else
     if (!strcmp(argv[3], "exclusive")) 
         localVar3 = XtCallbackExclusive;
     else
     if (!strcmp(argv[3], "nonexclusive")) 
         localVar3 = XtCallbackNonexclusive;
     else
     if (!strcmp(argv[3], "popdown")) 
         localVar3 = XtCallbackPopdown;
     else
     if (!strcmp(argv[3], "position")) 
         localVar3 = (XtCallbackProc)wafePositionCallbackProc;
     else
     if (!strcmp(argv[3], "positionCursor")) 
         localVar3 = (XtCallbackProc)wafePositionCursorCallbackProc;
     else
         {
         wafeConvError(argc,argv, 3,NULL, "XtCallbackProc");
         DBUG_RETURN (TCL_ERROR);
        }


    /* no need to assign  << localVar4 = argv[4] >>  */ 

     wafeCallbackCmdArgs(localVar1,argv[2],localVar3,argv[4]);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * hint: R5
 * Status
 * combineFileDatabase
 * 	in: String			# filename
 * 	in: Widget			# widget to determine database
 * 	in: Bool			# override
 */
#ifndef PRER5

static int 
cmd_combineFileDatabase(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar2;
     Bool localVar3;
     Status returnVar;
     char conversionBuffer[100];

     DBUG_ENTER(argv[0]);  

     if (argc != 4) 
	 {
	 wafeArgcError(argc,argv,"",3);
	 DBUG_RETURN (TCL_ERROR);
         }

    /* no need to assign  << localVar1 = argv[1] >>  */ 

     if (!(localVar2 = (Widget) name2Widget(argv[2])))
         {
         wafeConvError(argc, argv, 2 ,NULL, "Widget");
         DBUG_RETURN (TCL_ERROR);
         }

     if (!(wafeGetBool(argv[3],&localVar3)))
         {
         wafeConvError(argc, argv, 3 ,NULL, "Bool");
         DBUG_RETURN (TCL_ERROR);
         }

     returnVar = combineFileDatabase(argv[1],localVar2,localVar3);

     sprintf(conversionBuffer, "%d", returnVar);
     Tcl_SetResult(comInterpreter, conversionBuffer, TCL_VOLATILE);

     DBUG_RETURN (TCL_OK);
     }     

#endif

/* 
 * void
 * XtDestroyWidget
 * 	callmultiple
 * 		in: wafeMMfreeGarbage(Widget)	# widgets
 */

static int 
cmd_destroyWidget(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     int count;

     DBUG_ENTER(argv[0]);  

     if (argc < 2) 
	 {
	 wafeArgcError(argc,argv,"at least ",1);
	 DBUG_RETURN (TCL_ERROR);
         }

     for (count = 1; count < argc; count++)
          {
         if (!(localVar1 = (Widget) name2Widget(argv[count])))
             {
             wafeConvError(argc, argv, count ,NULL, "Widget");
             DBUG_RETURN (TCL_ERROR);
             }

         XtDestroyWidget(wafeMMfreeGarbage(localVar1));
          }

     DBUG_RETURN (TCL_OK);
     }     


#define fallbackResources(localVar1,argc,argv) { XrmDatabase    dispDb, newDb = NULL; int            i; char         **v = argv; dispDb = XtDatabase(XtDisplay(localVar1)); for (i = 0; i < argc; i+=2)  XrmPutStringResource(&newDb, v[i], v[i+1]); XrmCombineDatabase(newDb, &dispDb, False);}

/* 
 * hint: R5
 * void 
 * fallbackResources
 * 	in: Widget			# widget to determine database
 * 	in: [args avp] 			# resource-specification  value pairs
 */
#ifndef PRER5

static int 
cmd_fallbackResources(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     Boolean freeArgv = False;
     char **argvArg;

     DBUG_ENTER(argv[0]);  

     if (argc < 3) 
	 {
	 wafeArgcError(argc,argv,"at least ",2);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 = (Widget) name2Widget(argv[1])))
         {
         wafeConvError(argc, argv, 1 ,NULL, "Widget");
         DBUG_RETURN (TCL_ERROR);
         }

     argc -= 2;
     argvArg = &argv[2];
     if (argc == 1)
        {
        if (wafeMergeArguments(argv[2],argv[0],&argc,&argvArg))
           freeArgv = True;
        else 
           DBUG_RETURN (TCL_ERROR);
        }
     if (argc%2)
        {
        wafeArgcError(argc+2, argv,"even number of attribute value pairs such as 2 or ",4);
        if (freeArgv) XtFree((char*)argvArg);
        DBUG_RETURN (TCL_ERROR);
        }

     fallbackResources(localVar1,argc,argvArg);
     if (freeArgv) XtFree((char *)argvArg);

     DBUG_RETURN (TCL_OK);
     }     

#endif

#define fontHeight(w,resource) (font->max_bounds.ascent + font->max_bounds.descent)

/* 
 * int
 * fontHeight
 * 	pre: {XFontStruct *font; XtVaGetValues(localVar1, argv[2], &font, NULL);
 * 	in: Widget			# Widget
 * 	in: String			# fontResource
 *         post: }
 */

static int 
cmd_fontHeight(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     int returnVar;
     char conversionBuffer[100];

     DBUG_ENTER(argv[0]);  

     if (argc != 3) 
	 {
	 wafeArgcError(argc,argv,"",2);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 = (Widget) name2Widget(argv[1])))
         {
         wafeConvError(argc, argv, 1 ,NULL, "Widget");
         DBUG_RETURN (TCL_ERROR);
         }

    /* no need to assign  << localVar2 = argv[2] >>  */ 

     {XFontStruct *font; XtVaGetValues(localVar1, argv[2], &font, NULL);
     returnVar = fontHeight(localVar1,argv[2]);
     }

     sprintf(conversionBuffer, "%d", returnVar);
     Tcl_SetResult(comInterpreter, conversionBuffer, TCL_VOLATILE);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XFlush
 * 	in: XtDisplay(Widget)		# Widget to determine display
 */

static int 
cmd_flush(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;

     DBUG_ENTER(argv[0]);  

     if (argc != 2) 
	 {
	 wafeArgcError(argc,argv,"",1);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 = (Widget) name2Widget(argv[1])))
         {
         wafeConvError(argc, argv, 1 ,NULL, "Widget");
         DBUG_RETURN (TCL_ERROR);
         }

     XFlush(XtDisplay(localVar1));

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * String
 * wafeGetApplicationResource vulgo getApplicationResource
 * 	in: Widget			# base widget 
 * 	in: String			# resource name
 * 	in: String			# resource class
 */

static int 
cmd_getApplicationResource(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     String returnVar;

     DBUG_ENTER(argv[0]);  

     if (argc != 4) 
	 {
	 wafeArgcError(argc,argv,"",3);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 = (Widget) name2Widget(argv[1])))
         {
         wafeConvError(argc, argv, 1 ,NULL, "Widget");
         DBUG_RETURN (TCL_ERROR);
         }

    /* no need to assign  << localVar2 = argv[2] >>  */ 

    /* no need to assign  << localVar3 = argv[3] >>  */ 

     returnVar = wafeGetApplicationResource(localVar1,argv[2],argv[3]);

     Tcl_SetResult(comInterpreter, returnVar, TCL_STATIC);

     DBUG_RETURN (TCL_OK);
     }     


#include <X11/IntrinsicP.h>
#define getClass(widget) (XtClass(widget)->core_class.class_name)

/* 
 * String
 * getClass
 * 	in: Widget			# widget
 */

static int 
cmd_getClass(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     String returnVar;

     DBUG_ENTER(argv[0]);  

     if (argc != 2) 
	 {
	 wafeArgcError(argc,argv,"",1);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 = (Widget) name2Widget(argv[1])))
         {
         wafeConvError(argc, argv, 1 ,NULL, "Widget");
         DBUG_RETURN (TCL_ERROR);
         }

     returnVar = getClass(localVar1);

     Tcl_SetResult(comInterpreter, returnVar, TCL_STATIC);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * int
 * getResourceList
 * 	in: Widget	     # widget
 * 	out: String *        # variable name for output of list of resources 
 * 	end: XtFree((String)localVar2);
 */

static int 
cmd_getResourceList(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     String * localVar2;
     int returnVar;
     char conversionBuffer[100];

     DBUG_ENTER(argv[0]);  

     if (argc != 3) 
	 {
	 wafeArgcError(argc,argv,"",2);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 = (Widget) name2Widget(argv[1])))
         {
         wafeConvError(argc, argv, 1 ,NULL, "Widget");
         DBUG_RETURN (TCL_ERROR);
         }

     returnVar = getResourceList(localVar1,&localVar2);

     
     Tcl_SetVar(wafeInterpreter, argv[2], Tcl_Merge(returnVar,localVar2), 0);

     sprintf(conversionBuffer, "%d", returnVar);
     Tcl_SetResult(comInterpreter, conversionBuffer, TCL_VOLATILE);

     XtFree((String)localVar2);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * XrmQuark
 * wafeGetQTypeOfAttribute vulgo getTypeOfAttribute
 * 	in: XtClass(Widget)		# widget
 * 	const: ParentWidget(localVar1)
 * 	in: XrmStringToQuark(String)	# attribute
 * 	const: NULL
 */

static int 
cmd_getTypeOfAttribute(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     XrmQuark returnVar;

     DBUG_ENTER(argv[0]);  

     if (argc != 3) 
	 {
	 wafeArgcError(argc,argv,"",2);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 = (Widget) name2Widget(argv[1])))
         {
         wafeConvError(argc, argv, 1 ,NULL, "Widget");
         DBUG_RETURN (TCL_ERROR);
         }

    /* no need to assign  << localVar2 = argv[2] >>  */ 

     returnVar = wafeGetQTypeOfAttribute(XtClass(localVar1),ParentWidget(localVar1),XrmStringToQuark(argv[2]),NULL);

     Tcl_SetResult(comInterpreter, XrmQuarkToString(returnVar), TCL_STATIC);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * String
 * getValue
 * 	in: Widget			# widget
 * 	in: XrmQuark			# attribute
 * 	free: freeProc
 */

static int 
cmd_getValue(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     XrmQuark localVar2;
     freeProc localVar3;
     String returnVar;

     DBUG_ENTER(argv[0]);  

     if (argc != 3) 
	 {
	 wafeArgcError(argc,argv,"",2);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 = (Widget) name2Widget(argv[1])))
         {
         wafeConvError(argc, argv, 1 ,NULL, "Widget");
         DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar2 = (XrmQuark) XrmStringToQuark(argv[2])))
         {
         wafeConvError(argc, argv, 2 ,NULL, "XrmQuark");
         DBUG_RETURN (TCL_ERROR);
         }

     returnVar = getValue(localVar1,localVar2,&localVar3);

     Tcl_SetResult(comInterpreter, returnVar, localVar3);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * (int) GrabReturns
 * XtGrabKeyboard
 * 	in: Widget			# widget
 * 	in: Boolean			# true | false
 * 	in: (int) SyncAsync		# pointer mode (sync | async)
 * 	in: (int) SyncAsync		# keyboard mode (sync | async)
 * 	const: CurrentTime
 */

static int 
cmd_grabKeyboard(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     Boolean localVar2;
     int localVar3;
     int localVar4;
     int returnVar;
     char *staticResultString;

     DBUG_ENTER(argv[0]);  

     if (argc != 5) 
	 {
	 wafeArgcError(argc,argv,"",4);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 = (Widget) name2Widget(argv[1])))
         {
         wafeConvError(argc, argv, 1 ,NULL, "Widget");
         DBUG_RETURN (TCL_ERROR);
         }

     if (!(wafeGetBoolean(argv[2],&localVar2)))
         {
         wafeConvError(argc, argv, 2 ,NULL, "Boolean");
         DBUG_RETURN (TCL_ERROR);
         }

     if (!strcmp(argv[3], "sync")) 
         localVar3 = GrabModeSync;
     else
     if (!strcmp(argv[3], "async")) 
         localVar3 = GrabModeAsync;
     else
         {
         wafeConvError(argc,argv, 3,NULL, "SyncAsync");
         DBUG_RETURN (TCL_ERROR);
        }


     if (!strcmp(argv[4], "sync")) 
         localVar4 = GrabModeSync;
     else
     if (!strcmp(argv[4], "async")) 
         localVar4 = GrabModeAsync;
     else
         {
         wafeConvError(argc,argv, 4,NULL, "SyncAsync");
         DBUG_RETURN (TCL_ERROR);
        }


     returnVar = XtGrabKeyboard(localVar1,localVar2,localVar3,localVar4,CurrentTime);

     if (returnVar == GrabSuccess) 
         staticResultString = "success";
     else if (returnVar == AlreadyGrabbed) 
         staticResultString = "alreadyGrabbed";
     else if (returnVar == GrabNotViewable) 
         staticResultString = "notViewable";
     else if (returnVar == GrabFrozen) 
         staticResultString = "frozen";
     else 
         staticResultString = "UNKNOWN";

     Tcl_SetResult(comInterpreter, staticResultString, TCL_STATIC);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * (int) GrabReturns
 * XtGrabPointer
 * 	in: Widget			# widget
 * 	in: Boolean			# owner events
 *         const: NoEventMask
 * 	in: (int) SyncAsync		# pointer mode (sync | async)
 * 	in: (int) SyncAsync             # keyboard mode (sync | async)
 * 	in: None | XtWindow(Widget)	# None | confine widget
 * 	const: None
 * 	const: CurrentTime
 */

static int 
cmd_grabPointer(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     Boolean localVar2;
     int localVar3;
     int localVar4;
     Widget localVar5;
     int returnVar;
     char *staticResultString;

     DBUG_ENTER(argv[0]);  

     if (argc != 6) 
	 {
	 wafeArgcError(argc,argv,"",5);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 = (Widget) name2Widget(argv[1])))
         {
         wafeConvError(argc, argv, 1 ,NULL, "Widget");
         DBUG_RETURN (TCL_ERROR);
         }

     if (!(wafeGetBoolean(argv[2],&localVar2)))
         {
         wafeConvError(argc, argv, 2 ,NULL, "Boolean");
         DBUG_RETURN (TCL_ERROR);
         }

     if (!strcmp(argv[3], "sync")) 
         localVar3 = GrabModeSync;
     else
     if (!strcmp(argv[3], "async")) 
         localVar3 = GrabModeAsync;
     else
         {
         wafeConvError(argc,argv, 4,NULL, "SyncAsync");
         DBUG_RETURN (TCL_ERROR);
        }


     if (!strcmp(argv[4], "sync")) 
         localVar4 = GrabModeSync;
     else
     if (!strcmp(argv[4], "async")) 
         localVar4 = GrabModeAsync;
     else
         {
         wafeConvError(argc,argv, 5,NULL, "SyncAsync");
         DBUG_RETURN (TCL_ERROR);
        }


     if (!strcmp(argv[5], "None")) 
         localVar5 = None;
     else
         if (!(localVar5 = (Widget) name2Widget(argv[5])))
         {
         wafeConvError(argc, argv, 6 ,NULL, "Widget");
         DBUG_RETURN (TCL_ERROR);
         }

     returnVar = XtGrabPointer(localVar1,localVar2,NoEventMask,localVar3,localVar4,XtWindow(localVar5),None,CurrentTime);

     if (returnVar == GrabSuccess) 
         staticResultString = "success";
     else if (returnVar == AlreadyGrabbed) 
         staticResultString = "alreadyGrabbed";
     else if (returnVar == GrabNotViewable) 
         staticResultString = "notViewable";
     else if (returnVar == GrabFrozen) 
         staticResultString = "frozen";
     else 
         staticResultString = "UNKNOWN";

     Tcl_SetResult(comInterpreter, staticResultString, TCL_STATIC);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * int
 * HeightOfScreen
 * 	in: XtScreen(Widget)     	# widget to determine screen
 */

static int 
cmd_heightOfScreen(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     int returnVar;
     char conversionBuffer[100];

     DBUG_ENTER(argv[0]);  

     if (argc != 2) 
	 {
	 wafeArgcError(argc,argv,"",1);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 = (Widget) name2Widget(argv[1])))
         {
         wafeConvError(argc, argv, 1 ,NULL, "Widget");
         DBUG_RETURN (TCL_ERROR);
         }

     returnVar = HeightOfScreen(XtScreen(localVar1));

     sprintf(conversionBuffer, "%d", returnVar);
     Tcl_SetResult(comInterpreter, conversionBuffer, TCL_VOLATILE);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XtInstallAccelerators
 * 	in: Widget			# destination
 * 	in: Widget			# source
 */

static int 
cmd_installAccelerators(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     Widget localVar2;

     DBUG_ENTER(argv[0]);  

     if (argc != 3) 
	 {
	 wafeArgcError(argc,argv,"",2);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 = (Widget) name2Widget(argv[1])))
         {
         wafeConvError(argc, argv, 1 ,NULL, "Widget");
         DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar2 = (Widget) name2Widget(argv[2])))
         {
         wafeConvError(argc, argv, 2 ,NULL, "Widget");
         DBUG_RETURN (TCL_ERROR);
         }

     XtInstallAccelerators(localVar1,localVar2);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XtInstallAllAccelerators
 * 	in: Widget			# destination
 * 	in: Widget			# source
 */

static int 
cmd_installAllAccelerators(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     Widget localVar2;

     DBUG_ENTER(argv[0]);  

     if (argc != 3) 
	 {
	 wafeArgcError(argc,argv,"",2);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 = (Widget) name2Widget(argv[1])))
         {
         wafeConvError(argc, argv, 1 ,NULL, "Widget");
         DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar2 = (Widget) name2Widget(argv[2])))
         {
         wafeConvError(argc, argv, 2 ,NULL, "Widget");
         DBUG_RETURN (TCL_ERROR);
         }

     XtInstallAllAccelerators(localVar1,localVar2);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * WidgetID (WidgetID)
 * name2WidgetId vulgo isWidget
 * 	in: String			# widget name
 */

static int 
cmd_isWidget(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     WidgetID returnVar;
     char conversionBuffer[100];

     DBUG_ENTER(argv[0]);  

     if (argc != 2) 
	 {
	 wafeArgcError(argc,argv,"",1);
	 DBUG_RETURN (TCL_ERROR);
         }

    /* no need to assign  << localVar1 = argv[1] >>  */ 

     returnVar = (WidgetID) name2WidgetId(argv[1]);

     sprintf(conversionBuffer, "%ld", returnVar);
     Tcl_SetResult(comInterpreter, conversionBuffer, TCL_VOLATILE);

     DBUG_RETURN (TCL_OK);
     }     


#ifdef LAYOUT
#include "Layout.h"
#endif
/* 
 * void
 * XLowerWindow
 * 	pre: if (!(XtWindow(localVar1))) returnTclError(argv[0],"Widget must be realized")
 * 	in: XtDisplay(Widget)           # Widget to be lowered
 * 	const: XtWindow(localVar1)
 */

static int 
cmd_lowerWindow(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;

     DBUG_ENTER(argv[0]);  

     if (argc != 2) 
	 {
	 wafeArgcError(argc,argv,"",1);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 = (Widget) name2Widget(argv[1])))
         {
         wafeConvError(argc, argv, 1 ,NULL, "Widget");
         DBUG_RETURN (TCL_ERROR);
         }

     if (!(XtWindow(localVar1))) returnTclError(argv[0],"Widget must be realized")
     XLowerWindow(XtDisplay(localVar1),XtWindow(localVar1));

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XtManageChildren vulgo manageChild
 * 	in: [Widget]		        # widgets
 * 	const: argc -1
 */

static int 
cmd_manageChild(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget * localVar1;

     DBUG_ENTER(argv[0]);  

     if (argc < 2) 
	 {
	 wafeArgcError(argc,argv,"at least ",1);
	 DBUG_RETURN (TCL_ERROR);
         }

     {    Widget *ptr;
          argv += 1;
          localVar1 = ptr =
             (Widget *)XtMalloc((argc-1)*sizeof(Widget));

          while (*argv)
             {
             if (!(*ptr =  name2Widget(*argv)))
                 {
                 wafeConvError(argc, argv, 1 ,NULL, "Widget");
                 DBUG_RETURN (TCL_ERROR);
                 }

          ptr ++; argv++;
          }
     }
     XtManageChildren(localVar1,argc -1);
     XtFree((char *)localVar1);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XtMapWidget
 * 	callmultiple
 * 		in: Widget		# widgets
 */

static int 
cmd_mapWidget(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     int count;

     DBUG_ENTER(argv[0]);  

     if (argc < 2) 
	 {
	 wafeArgcError(argc,argv,"at least ",1);
	 DBUG_RETURN (TCL_ERROR);
         }

     for (count = 1; count < argc; count++)
          {
         if (!(localVar1 = (Widget) name2Widget(argv[count])))
             {
             wafeConvError(argc, argv, count ,NULL, "Widget");
             DBUG_RETURN (TCL_ERROR);
             }

         XtMapWidget(localVar1);
          }

     DBUG_RETURN (TCL_OK);
     }     


#define mergeResources(localVar1,argc,argv) { XrmDatabase    dispDb, newDb = NULL; int            i; char         **v = argv; dispDb = XtDatabase(XtDisplay(localVar1)); for (i = 0; i < argc; i+=2)  XrmPutStringResource(&newDb, v[i], v[i+1]); XrmMergeDatabases(newDb, &dispDb);}

/* 
 * void 
 * mergeResources
 * 	in: Widget			# widget to determine database
 * 	in: [args avp] 			# resource-specification  value pairs
 */

static int 
cmd_mergeResources(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     Boolean freeArgv = False;
     char **argvArg;

     DBUG_ENTER(argv[0]);  

     if (argc < 3) 
	 {
	 wafeArgcError(argc,argv,"at least ",2);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 = (Widget) name2Widget(argv[1])))
         {
         wafeConvError(argc, argv, 1 ,NULL, "Widget");
         DBUG_RETURN (TCL_ERROR);
         }

     argc -= 2;
     argvArg = &argv[2];
     if (argc == 1)
        {
        if (wafeMergeArguments(argv[2],argv[0],&argc,&argvArg))
           freeArgv = True;
        else 
           DBUG_RETURN (TCL_ERROR);
        }
     if (argc%2)
        {
        wafeArgcError(argc+2, argv,"even number of attribute value pairs such as 2 or ",4);
        if (freeArgv) XtFree((char*)argvArg);
        DBUG_RETURN (TCL_ERROR);
        }

     mergeResources(localVar1,argc,argvArg);
     if (freeArgv) XtFree((char *)argvArg);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * WidgetID (WidgetID)
 * XtNameToWidget
 * 	in: Widget			# reference widget
 * 	in: String                      # partial widget name path
 */

static int 
cmd_nameToWidget(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     WidgetID returnVar;
     char conversionBuffer[100];

     DBUG_ENTER(argv[0]);  

     if (argc != 3) 
	 {
	 wafeArgcError(argc,argv,"",2);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 = (Widget) name2Widget(argv[1])))
         {
         wafeConvError(argc, argv, 1 ,NULL, "Widget");
         DBUG_RETURN (TCL_ERROR);
         }

    /* no need to assign  << localVar2 = argv[2] >>  */ 

     returnVar = (WidgetID) XtNameToWidget(localVar1,argv[2]);

     sprintf(conversionBuffer, "%ld", returnVar);
     Tcl_SetResult(comInterpreter, conversionBuffer, TCL_VOLATILE);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * WidgetID (WidgetID)
 * ParentWidget vulgo parent
 * 	in: Widget			# child widget
 */

static int 
cmd_parent(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     WidgetID returnVar;
     char conversionBuffer[100];

     DBUG_ENTER(argv[0]);  

     if (argc != 2) 
	 {
	 wafeArgcError(argc,argv,"",1);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 = (Widget) name2Widget(argv[1])))
         {
         wafeConvError(argc, argv, 1 ,NULL, "Widget");
         DBUG_RETURN (TCL_ERROR);
         }

     returnVar = (WidgetID) ParentWidget(localVar1);

     sprintf(conversionBuffer, "%ld", returnVar);
     Tcl_SetResult(comInterpreter, conversionBuffer, TCL_VOLATILE);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XtPopdown
 *         in: ShellWidget			# shell widget
 */

static int 
cmd_popdown(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;

     DBUG_ENTER(argv[0]);  

     if (argc != 2) 
	 {
	 wafeArgcError(argc,argv,"",1);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],shellWidgetClass,"Shell")))
         {
         wafeConvError(argc, argv, 1 ,NULL, "ShellWidget");
         DBUG_RETURN (TCL_ERROR);
         }

     XtPopdown(localVar1);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XtPopup
 *         in: ShellWidget			# widget
 *         in: XtGrabKind			# none | nonexclusive | exclusive
 */

static int 
cmd_popup(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     XtGrabKind localVar2;

     DBUG_ENTER(argv[0]);  

     if (argc != 3) 
	 {
	 wafeArgcError(argc,argv,"",2);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],shellWidgetClass,"Shell")))
         {
         wafeConvError(argc, argv, 1 ,NULL, "ShellWidget");
         DBUG_RETURN (TCL_ERROR);
         }

     if (!strcmp(argv[2], "none")) 
         localVar2 = XtGrabNone;
     else
     if (!strcmp(argv[2], "nonexclusive")) 
         localVar2 = XtGrabNonexclusive;
     else
     if (!strcmp(argv[2], "exclusive")) 
         localVar2 = XtGrabExclusive;
     else
         {
         wafeConvError(argc,argv, 2,NULL, "XtGrabKind");
         DBUG_RETURN (TCL_ERROR);
        }


     XtPopup(localVar1,localVar2);

     DBUG_RETURN (TCL_OK);
     }     


#define popupChildren(w) wafeCvtWidgetListToList(NULL,(w)->core.num_popups,(w)->core.popup_list)

/* 
 * (String) DString
 * popupChildren
 * 	in: Widget
 */

static int 
cmd_popupChildren(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     String returnVar;

     DBUG_ENTER(argv[0]);  

     if (argc != 2) 
	 {
	 wafeArgcError(argc,argv,"",1);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 = (Widget) name2Widget(argv[1])))
         {
         wafeConvError(argc, argv, 1 ,NULL, "Widget");
         DBUG_RETURN (TCL_ERROR);
         }

     returnVar = popupChildren(localVar1);

     Tcl_SetResult(comInterpreter, returnVar, XtFree);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XtPopupSpringLoaded
 *         in: ShellWidget			# shell widget
 */

static int 
cmd_popupSpringLoaded(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;

     DBUG_ENTER(argv[0]);  

     if (argc != 2) 
	 {
	 wafeArgcError(argc,argv,"",1);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],shellWidgetClass,"Shell")))
         {
         wafeConvError(argc, argv, 1 ,NULL, "ShellWidget");
         DBUG_RETURN (TCL_ERROR);
         }

     XtPopupSpringLoaded(localVar1);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * processPendingEvents
 */

static int 
cmd_processPendingEvents(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {

     DBUG_ENTER(argv[0]);  

     if (argc != 1) 
	 {
	 wafeArgcError(argc,argv,"",0);
	 DBUG_RETURN (TCL_ERROR);
         }

     processPendingEvents();

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XRaiseWindow
 * 	pre: if (!(XtWindow(localVar1))) returnTclError(argv[0],"Widget must be realized")
 * 	in: XtDisplay(Widget)		# widget to be raised
 * 	const: XtWindow(localVar1)
 */

static int 
cmd_raiseWindow(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;

     DBUG_ENTER(argv[0]);  

     if (argc != 2) 
	 {
	 wafeArgcError(argc,argv,"",1);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 = (Widget) name2Widget(argv[1])))
         {
         wafeConvError(argc, argv, 1 ,NULL, "Widget");
         DBUG_RETURN (TCL_ERROR);
         }

     if (!(XtWindow(localVar1))) returnTclError(argv[0],"Widget must be realized")
     XRaiseWindow(XtDisplay(localVar1),XtWindow(localVar1));

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * realizeWidgets vulgo realize
 */

static int 
cmd_realize(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {

     DBUG_ENTER(argv[0]);  

     if (argc != 1) 
	 {
	 wafeArgcError(argc,argv,"",0);
	 DBUG_RETURN (TCL_ERROR);
         }

     realizeWidgets();

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XtRealizeWidget
 * 	callmultiple
 * 		in: Widget		# widgets
 */

static int 
cmd_realizeWidget(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     int count;

     DBUG_ENTER(argv[0]);  

     if (argc < 2) 
	 {
	 wafeArgcError(argc,argv,"at least ",1);
	 DBUG_RETURN (TCL_ERROR);
         }

     for (count = 1; count < argc; count++)
          {
         if (!(localVar1 = (Widget) name2Widget(argv[count])))
             {
             wafeConvError(argc, argv, count ,NULL, "Widget");
             DBUG_RETURN (TCL_ERROR);
             }

         XtRealizeWidget(localVar1);
          }

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XtRemoveAllCallbacks
 * 	in: Widget			# widget
 * 	in: String			# callback name
 */

static int 
cmd_removeAllCallbacks(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;

     DBUG_ENTER(argv[0]);  

     if (argc != 3) 
	 {
	 wafeArgcError(argc,argv,"",2);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 = (Widget) name2Widget(argv[1])))
         {
         wafeConvError(argc, argv, 1 ,NULL, "Widget");
         DBUG_RETURN (TCL_ERROR);
         }

    /* no need to assign  << localVar2 = argv[2] >>  */ 

     XtRemoveAllCallbacks(localVar1,argv[2]);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void 
 * XtRemoveTimeOut 
 * 	in: XtIntervalId		# interval ID
 */

static int 
cmd_removeTimeOut(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     XtIntervalId localVar1;

     DBUG_ENTER(argv[0]);  

     if (argc != 2) 
	 {
	 wafeArgcError(argc,argv,"",1);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(sscanf(argv[1], "%lu", &localVar1)))
         {
         wafeConvError(argc, argv, 1 ,NULL, "XtIntervalId");
         DBUG_RETURN (TCL_ERROR);
         }

     XtRemoveTimeOut(localVar1);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * (String) DString
 * XtResolvePathname
 * 	in: XtDisplay(Widget)           # widget to determine display
 * 	in: NULL | String               # type
 * 	in: NULL | String               # filename
 * 	in: NULL | String               # suffix
 * 	in: NULL | String               # path
 * 	const: NULL                     # substitutions
 * 	const: 0                        # number of Substitutions
 * 	const: NULL                     # XtFilePredicate
 */

static int 
cmd_resolvePathname(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     String localVar2;
     String localVar3;
     String localVar4;
     String localVar5;
     String returnVar;

     DBUG_ENTER(argv[0]);  

     if (argc != 6) 
	 {
	 wafeArgcError(argc,argv,"",5);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 = (Widget) name2Widget(argv[1])))
         {
         wafeConvError(argc, argv, 1 ,NULL, "Widget");
         DBUG_RETURN (TCL_ERROR);
         }

     if (!strcmp(argv[2], "NULL")) 
         localVar2 = NULL;
     else
         localVar2 = argv[2];
     if (!strcmp(argv[3], "NULL")) 
         localVar3 = NULL;
     else
         localVar3 = argv[3];
     if (!strcmp(argv[4], "NULL")) 
         localVar4 = NULL;
     else
         localVar4 = argv[4];
     if (!strcmp(argv[5], "NULL")) 
         localVar5 = NULL;
     else
         localVar5 = argv[5];
     returnVar = XtResolvePathname(XtDisplay(localVar1),localVar2,localVar3,localVar4,localVar5,NULL,0,NULL);

     Tcl_SetResult(comInterpreter, returnVar, XtFree);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * setBusy
 * 	in: Widget			# shell widget 
 * 	in: Boolean			# sensitive true | false
 */

static int 
cmd_setBusy(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     Boolean localVar2;

     DBUG_ENTER(argv[0]);  

     if (argc != 3) 
	 {
	 wafeArgcError(argc,argv,"",2);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 = (Widget) name2Widget(argv[1])))
         {
         wafeConvError(argc, argv, 1 ,NULL, "Widget");
         DBUG_RETURN (TCL_ERROR);
         }

     if (!(wafeGetBoolean(argv[2],&localVar2)))
         {
         wafeConvError(argc, argv, 2 ,NULL, "Boolean");
         DBUG_RETURN (TCL_ERROR);
         }

     setBusy(localVar1,localVar2);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XtSetKeyboardFocus
 * 	in: Widget			# from widget tree
 * 	in: None|Widget			# to widget | None
 */

static int 
cmd_setKeyboardFocus(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     Widget localVar2;

     DBUG_ENTER(argv[0]);  

     if (argc != 3) 
	 {
	 wafeArgcError(argc,argv,"",2);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 = (Widget) name2Widget(argv[1])))
         {
         wafeConvError(argc, argv, 1 ,NULL, "Widget");
         DBUG_RETURN (TCL_ERROR);
         }

     if (!strcmp(argv[2], "None")) 
         localVar2 = None;
     else
         if (!(localVar2 = (Widget) name2Widget(argv[2])))
         {
         wafeConvError(argc, argv, 2 ,NULL, "Widget");
         DBUG_RETURN (TCL_ERROR);
         }

     XtSetKeyboardFocus(localVar1,localVar2);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XtSetSensitive 
 * 	in: Widget			# widget 
 * 	in: Boolean			# sensitive true | false
 */

static int 
cmd_setSensitive(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     Boolean localVar2;

     DBUG_ENTER(argv[0]);  

     if (argc != 3) 
	 {
	 wafeArgcError(argc,argv,"",2);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 = (Widget) name2Widget(argv[1])))
         {
         wafeConvError(argc, argv, 1 ,NULL, "Widget");
         DBUG_RETURN (TCL_ERROR);
         }

     if (!(wafeGetBoolean(argv[2],&localVar2)))
         {
         wafeConvError(argc, argv, 2 ,NULL, "Boolean");
         DBUG_RETURN (TCL_ERROR);
         }

     XtSetSensitive(localVar1,localVar2);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * setValues
 * 	in: Widget			# widget
 * 	in: [args avp]			# attribute value pairs
 */

static int 
cmd_setValues(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     Boolean freeArgv = False;
     char **argvArg;

     DBUG_ENTER(argv[0]);  

     if (argc < 3) 
	 {
	 wafeArgcError(argc,argv,"at least ",2);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 = (Widget) name2Widget(argv[1])))
         {
         wafeConvError(argc, argv, 1 ,NULL, "Widget");
         DBUG_RETURN (TCL_ERROR);
         }

     argc -= 2;
     argvArg = &argv[2];
     if (argc == 1)
        {
        if (wafeMergeArguments(argv[2],argv[0],&argc,&argvArg))
           freeArgv = True;
        else 
           DBUG_RETURN (TCL_ERROR);
        }
     if (argc%2)
        {
        wafeArgcError(argc+2, argv,"even number of attribute value pairs such as 2 or ",4);
        if (freeArgv) XtFree((char*)argvArg);
        DBUG_RETURN (TCL_ERROR);
        }

     setValues(localVar1,argc,argvArg);
     if (freeArgv) XtFree((char *)argvArg);

     DBUG_RETURN (TCL_OK);
     }     


#define ADDRESS_OF(w) &(w)

/* 
 * Boolean 
 * XSetWMProtocols
 * 	pre: if (!(XtWindow(localVar1))) returnTclError(argv[0],"Shell widget must be realized")
 * 	const: XtDisplay(localVar1)
 *         in: XtWindow(ShellWidget)	        # Shell Widget
 * 	in: ADDRESS_OF((Atom)WM_PROTOCOLS)	# WM_TAKE_FOCUS | WM_SAVE_YOURSELF | WM_DELETE_WINDOW
 * 	const: 1
 */

static int 
cmd_setWMProtocols(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     Atom localVar2;
     Boolean returnVar;

     DBUG_ENTER(argv[0]);  

     if (argc != 3) 
	 {
	 wafeArgcError(argc,argv,"",2);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],shellWidgetClass,"Shell")))
         {
         wafeConvError(argc, argv, 2 ,NULL, "ShellWidget");
         DBUG_RETURN (TCL_ERROR);
         }

     if (!strcmp(argv[2], "WM_TAKE_FOCUS")) 
         localVar2 = XInternAtom(XtDisplay(localVar1),"WM_TAKE_FOCUS",False);
     else
     if (!strcmp(argv[2], "WM_SAVE_YOURSELF")) 
         localVar2 = XInternAtom(XtDisplay(localVar1),"WM_SAVE_YOURSELF",False);
     else
     if (!strcmp(argv[2], "WM_DELETE_WINDOW")) 
         localVar2 = XInternAtom(XtDisplay(localVar1),"WM_DELETE_WINDOW",False);
     else
         {
         wafeConvError(argc,argv, 3,NULL, "WM_PROTOCOLS");
         DBUG_RETURN (TCL_ERROR);
        }


     if (!(XtWindow(localVar1))) returnTclError(argv[0],"Shell widget must be realized")
     returnVar = XSetWMProtocols(XtDisplay(localVar1),XtWindow(localVar1),ADDRESS_OF(localVar2),1);

     Tcl_SetResult(comInterpreter, returnVar ? "1" : "0", TCL_STATIC);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XSync
 * 	in: XtDisplay(Widget)		# Widget to determine display
 * 	in: Boolean			# Discard (Boolean)
 */

static int 
cmd_sync(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     Boolean localVar2;

     DBUG_ENTER(argv[0]);  

     if (argc != 3) 
	 {
	 wafeArgcError(argc,argv,"",2);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 = (Widget) name2Widget(argv[1])))
         {
         wafeConvError(argc, argv, 1 ,NULL, "Widget");
         DBUG_RETURN (TCL_ERROR);
         }

     if (!(wafeGetBoolean(argv[2],&localVar2)))
         {
         wafeConvError(argc, argv, 2 ,NULL, "Boolean");
         DBUG_RETURN (TCL_ERROR);
         }

     XSync(XtDisplay(localVar1),localVar2);

     DBUG_RETURN (TCL_OK);
     }     


#define textWidth(w,resource,string) XTextWidth(font, string, strlen(string))

/* 
 * int
 * textWidth
 * 	pre: {XFontStruct *font; XtVaGetValues(localVar1, argv[2], &font, NULL);
 * 	in: Widget			# Widget
 * 	in: String			# fontResource
 * 	in: String			# String
 *         post: }
 */

static int 
cmd_textWidth(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     int returnVar;
     char conversionBuffer[100];

     DBUG_ENTER(argv[0]);  

     if (argc != 4) 
	 {
	 wafeArgcError(argc,argv,"",3);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 = (Widget) name2Widget(argv[1])))
         {
         wafeConvError(argc, argv, 1 ,NULL, "Widget");
         DBUG_RETURN (TCL_ERROR);
         }

    /* no need to assign  << localVar2 = argv[2] >>  */ 

    /* no need to assign  << localVar3 = argv[3] >>  */ 

     {XFontStruct *font; XtVaGetValues(localVar1, argv[2], &font, NULL);
     returnVar = textWidth(localVar1,argv[2],argv[3]);
     }

     sprintf(conversionBuffer, "%d", returnVar);
     Tcl_SetResult(comInterpreter, conversionBuffer, TCL_VOLATILE);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XtTranslateCoords
 * 	in: Widget			# widget
 * 	in: Position    		# x coordinate in widget
 * 	in: Position    		# y coordinate in widget
 * 	out: Position   		# variable name for root window x
 * 	out: Position   		# variable name for root window y
 */

static int 
cmd_translateCoords(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     Position localVar2;
     Position localVar3;
     Position localVar4;
     Position localVar5;
     char conversionBuffer[100];

     DBUG_ENTER(argv[0]);  

     if (argc != 6) 
	 {
	 wafeArgcError(argc,argv,"",5);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 = (Widget) name2Widget(argv[1])))
         {
         wafeConvError(argc, argv, 1 ,NULL, "Widget");
         DBUG_RETURN (TCL_ERROR);
         }

     if (!(sscanf(argv[2], "%hd", &localVar2)))
         {
         wafeConvError(argc, argv, 2 ,NULL, "Position");
         DBUG_RETURN (TCL_ERROR);
         }

     if (!(sscanf(argv[3], "%hd", &localVar3)))
         {
         wafeConvError(argc, argv, 3 ,NULL, "Position");
         DBUG_RETURN (TCL_ERROR);
         }

     XtTranslateCoords(localVar1,localVar2,localVar3,&localVar4,&localVar5);

     sprintf(conversionBuffer, "%hd", localVar4);

     Tcl_SetVar(wafeInterpreter, argv[4], conversionBuffer, 0);

     sprintf(conversionBuffer, "%hd", localVar5);

     Tcl_SetVar(wafeInterpreter, argv[5], conversionBuffer, 0);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XtUngrabPointer
 * 	in: Widget			# widget with active pointer grab
 * 	const: CurrentTime
 */

static int 
cmd_ungrabPointer(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;

     DBUG_ENTER(argv[0]);  

     if (argc != 2) 
	 {
	 wafeArgcError(argc,argv,"",1);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 = (Widget) name2Widget(argv[1])))
         {
         wafeConvError(argc, argv, 1 ,NULL, "Widget");
         DBUG_RETURN (TCL_ERROR);
         }

     XtUngrabPointer(localVar1,CurrentTime);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XtUngrabKeyboard
 * 	in: Widget			# widget with active keyboard grab
 * 	const: CurrentTime
 */

static int 
cmd_ungrabKeyboard(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;

     DBUG_ENTER(argv[0]);  

     if (argc != 2) 
	 {
	 wafeArgcError(argc,argv,"",1);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 = (Widget) name2Widget(argv[1])))
         {
         wafeConvError(argc, argv, 1 ,NULL, "Widget");
         DBUG_RETURN (TCL_ERROR);
         }

     XtUngrabKeyboard(localVar1,CurrentTime);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XtUnmanageChildren vulgo unmanageChild
 * 	in: [Widget]		# widgets
 * 	const: argc -1
 */

static int 
cmd_unmanageChild(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget * localVar1;

     DBUG_ENTER(argv[0]);  

     if (argc < 2) 
	 {
	 wafeArgcError(argc,argv,"at least ",1);
	 DBUG_RETURN (TCL_ERROR);
         }

     {    Widget *ptr;
          argv += 1;
          localVar1 = ptr =
             (Widget *)XtMalloc((argc-1)*sizeof(Widget));

          while (*argv)
             {
             if (!(*ptr =  name2Widget(*argv)))
                 {
                 wafeConvError(argc, argv, 1 ,NULL, "Widget");
                 DBUG_RETURN (TCL_ERROR);
                 }

          ptr ++; argv++;
          }
     }
     XtUnmanageChildren(localVar1,argc -1);
     XtFree((char *)localVar1);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XtUnmapWidget
 * 	callmultiple
 * 		in: Widget		# widgets
 */

static int 
cmd_unmapWidget(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     int count;

     DBUG_ENTER(argv[0]);  

     if (argc < 2) 
	 {
	 wafeArgcError(argc,argv,"at least ",1);
	 DBUG_RETURN (TCL_ERROR);
         }

     for (count = 1; count < argc; count++)
          {
         if (!(localVar1 = (Widget) name2Widget(argv[count])))
             {
             wafeConvError(argc, argv, count ,NULL, "Widget");
             DBUG_RETURN (TCL_ERROR);
             }

         XtUnmapWidget(localVar1);
          }

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XtUnrealizeWidget
 * 	callmultiple
 * 		in: Widget		# widgets
 */

static int 
cmd_unrealizeWidget(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     int count;

     DBUG_ENTER(argv[0]);  

     if (argc < 2) 
	 {
	 wafeArgcError(argc,argv,"at least ",1);
	 DBUG_RETURN (TCL_ERROR);
         }

     for (count = 1; count < argc; count++)
          {
         if (!(localVar1 = (Widget) name2Widget(argv[count])))
             {
             wafeConvError(argc, argv, count ,NULL, "Widget");
             DBUG_RETURN (TCL_ERROR);
             }

         XtUnrealizeWidget(localVar1);
          }

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * String
 * waitForVariable
 * 	in: String			# variable name
 */

static int 
cmd_waitForVariable(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     String returnVar;

     DBUG_ENTER(argv[0]);  

     if (argc != 2) 
	 {
	 wafeArgcError(argc,argv,"",1);
	 DBUG_RETURN (TCL_ERROR);
         }

    /* no need to assign  << localVar1 = argv[1] >>  */ 

     returnVar = waitForVariable(argv[1]);

     Tcl_SetResult(comInterpreter, returnVar, TCL_STATIC);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * Widget
 * name2WidgetId vulgo widgetName
 * 	in: String			# widget reference
 */

static int 
cmd_widgetName(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget returnVar;

     DBUG_ENTER(argv[0]);  

     if (argc != 2) 
	 {
	 wafeArgcError(argc,argv,"",1);
	 DBUG_RETURN (TCL_ERROR);
         }

    /* no need to assign  << localVar1 = argv[1] >>  */ 

     returnVar = name2WidgetId(argv[1]);

     Tcl_SetResult(comInterpreter, wafeWidgetToName(returnVar), TCL_STATIC);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * int
 * WidthOfScreen
 * 	in: XtScreen(Widget)     	# widget to determine screen
 */

static int 
cmd_widthOfScreen(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     int returnVar;
     char conversionBuffer[100];

     DBUG_ENTER(argv[0]);  

     if (argc != 2) 
	 {
	 wafeArgcError(argc,argv,"",1);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 = (Widget) name2Widget(argv[1])))
         {
         wafeConvError(argc, argv, 1 ,NULL, "Widget");
         DBUG_RETURN (TCL_ERROR);
         }

     returnVar = WidthOfScreen(XtScreen(localVar1));

     sprintf(conversionBuffer, "%d", returnVar);
     Tcl_SetResult(comInterpreter, conversionBuffer, TCL_VOLATILE);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * long (long)
 * XtWindow
 *         in: Widget     			# widget whose window you want
 */

static int 
cmd_window(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     long returnVar;
     char conversionBuffer[100];

     DBUG_ENTER(argv[0]);  

     if (argc != 2) 
	 {
	 wafeArgcError(argc,argv,"",1);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 = (Widget) name2Widget(argv[1])))
         {
         wafeConvError(argc, argv, 1 ,NULL, "Widget");
         DBUG_RETURN (TCL_ERROR);
         }

     returnVar = (long) XtWindow(localVar1);

     sprintf(conversionBuffer, "%ld", returnVar);
     Tcl_SetResult(comInterpreter, conversionBuffer, TCL_VOLATILE);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XtDisownSelection
 * 	pre: if (!(XtWindow(localVar1))) returnTclError(argv[0],"Widget must be realized")
 *         in: Widget                 # widget making the request
 * 	const: XA_PRIMARY
 * 	const: CurrentTime
 */

static int 
cmd_disownSelection(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;

     DBUG_ENTER(argv[0]);  

     if (argc != 2) 
	 {
	 wafeArgcError(argc,argv,"",1);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 = (Widget) name2Widget(argv[1])))
         {
         wafeConvError(argc, argv, 1 ,NULL, "Widget");
         DBUG_RETURN (TCL_ERROR);
         }

     if (!(XtWindow(localVar1))) returnTclError(argv[0],"Widget must be realized")
     XtDisownSelection(localVar1,XA_PRIMARY,CurrentTime);

     DBUG_RETURN (TCL_OK);
     }     


extern void wafeGetSelectionValueProc();

/* 
 * void
 * XtGetSelectionValue
 * 	pre: if (!(XtWindow(localVar1))) returnTclError(argv[0],"Widget must be realized")
 * 	in: Widget                      # widget making the request
 * 	const: XA_PRIMARY
 * 	const: XA_STRING
 * 	const: wafeGetSelectionValueProc
 * 	in: XtNewString(String)		# Tcl command
 * 	const: CurrentTime
 */

static int 
cmd_getSelectionValue(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;

     DBUG_ENTER(argv[0]);  

     if (argc != 3) 
	 {
	 wafeArgcError(argc,argv,"",2);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 = (Widget) name2Widget(argv[1])))
         {
         wafeConvError(argc, argv, 1 ,NULL, "Widget");
         DBUG_RETURN (TCL_ERROR);
         }

    /* no need to assign  << localVar2 = argv[2] >>  */ 

     if (!(XtWindow(localVar1))) returnTclError(argv[0],"Widget must be realized")
     XtGetSelectionValue(localVar1,XA_PRIMARY,XA_STRING,wafeGetSelectionValueProc,XtNewString(argv[2]),CurrentTime);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * Boolean
 * wafeOwnSelectionCmd vulgo ownSelection
 * 	pre: if (!(XtWindow(localVar1))) returnTclError(argv[0],"Widget must be realized")
 *         in: Widget              # widget that whiches to become owner of the selection
 * 	in: XtNewString(String) # string to be put into selection
 * 	in: NULL | String 	# NULL | loseSelection TCL-command
 * 	in: NULL | String 	# NULL | doneSelection TCL-command
 */

static int 
cmd_ownSelection(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     String localVar3;
     String localVar4;
     Boolean returnVar;

     DBUG_ENTER(argv[0]);  

     if (argc != 5) 
	 {
	 wafeArgcError(argc,argv,"",4);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 = (Widget) name2Widget(argv[1])))
         {
         wafeConvError(argc, argv, 1 ,NULL, "Widget");
         DBUG_RETURN (TCL_ERROR);
         }

    /* no need to assign  << localVar2 = argv[2] >>  */ 

     if (!strcmp(argv[3], "NULL")) 
         localVar3 = NULL;
     else
         localVar3 = argv[3];
     if (!strcmp(argv[4], "NULL")) 
         localVar4 = NULL;
     else
         localVar4 = argv[4];
     if (!(XtWindow(localVar1))) returnTclError(argv[0],"Widget must be realized")
     returnVar = wafeOwnSelectionCmd(localVar1,XtNewString(argv[2]),localVar3,localVar4);

     Tcl_SetResult(comInterpreter, returnVar ? "1" : "0", TCL_STATIC);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * (String) DString
 * XFetchBuffer
 * 	in: XtDisplay(Widget)		# widget to determine display
 * 	const: &nbytes
 * 	in: int				# buffer number (1-7)
 * 	pre: {int nbytes;
 * 	post: }
 */

static int 
cmd_fetchBuffer(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     int localVar2;
     String returnVar;

     DBUG_ENTER(argv[0]);  

     if (argc != 3) 
	 {
	 wafeArgcError(argc,argv,"",2);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 = (Widget) name2Widget(argv[1])))
         {
         wafeConvError(argc, argv, 1 ,NULL, "Widget");
         DBUG_RETURN (TCL_ERROR);
         }

     if (!(sscanf(argv[2], "%d", &localVar2)))
         {
         wafeConvError(argc, argv, 3 ,NULL, "int");
         DBUG_RETURN (TCL_ERROR);
         }

     {int nbytes;
     returnVar = XFetchBuffer(XtDisplay(localVar1),&nbytes,localVar2);
     }

     Tcl_SetResult(comInterpreter, returnVar, XtFree);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * (String) DString
 * XFetchBytes
 * 	pre: { int bytes; XConvertSelection(XtDisplay(localVar1), XA_PRIMARY, XA_STRING, XA_CUT_BUFFER0, DefaultRootWindow(XtDisplay(localVar1)), CurrentTime); 
 * 	in: XtDisplay(Widget) 		# widget to determine display
 *         const:  &bytes
 * 	post: }
 */

static int 
cmd_fetchBytes(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     String returnVar;

     DBUG_ENTER(argv[0]);  

     if (argc != 2) 
	 {
	 wafeArgcError(argc,argv,"",1);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 = (Widget) name2Widget(argv[1])))
         {
         wafeConvError(argc, argv, 1 ,NULL, "Widget");
         DBUG_RETURN (TCL_ERROR);
         }

     { int bytes; XConvertSelection(XtDisplay(localVar1), XA_PRIMARY, XA_STRING, XA_CUT_BUFFER0, DefaultRootWindow(XtDisplay(localVar1)), CurrentTime);
     returnVar = XFetchBytes(XtDisplay(localVar1),&bytes);
     }

     Tcl_SetResult(comInterpreter, returnVar, XtFree);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XConvertSelection
 * 	in: XtDisplay(Widget)		# widget to determine display
 * 	const: XA_PRIMARY
 * 	const: XA_STRING
 * 	in: Atom			# target buffer number (0 to 6)
 * 	const: DefaultRootWindow(XtDisplay(wafeTopLevel))
 * 	const: CurrentTime
 */

static int 
cmd_convertSelection(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     Atom localVar2;

     DBUG_ENTER(argv[0]);  

     if (argc != 3) 
	 {
	 wafeArgcError(argc,argv,"",2);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 = (Widget) name2Widget(argv[1])))
         {
         wafeConvError(argc, argv, 1 ,NULL, "Widget");
         DBUG_RETURN (TCL_ERROR);
         }

     if (!strcmp(argv[2], "0")) 
         localVar2 = XA_CUT_BUFFER0;
     else
     if (!strcmp(argv[2], "1")) 
         localVar2 = XA_CUT_BUFFER1;
     else
     if (!strcmp(argv[2], "2")) 
         localVar2 = XA_CUT_BUFFER2;
     else
     if (!strcmp(argv[2], "3")) 
         localVar2 = XA_CUT_BUFFER3;
     else
     if (!strcmp(argv[2], "4")) 
         localVar2 = XA_CUT_BUFFER4;
     else
     if (!strcmp(argv[2], "5")) 
         localVar2 = XA_CUT_BUFFER5;
     else
     if (!strcmp(argv[2], "6")) 
         localVar2 = XA_CUT_BUFFER6;
     else
         {
         wafeConvError(argc,argv, 4,NULL, "Atom");
         DBUG_RETURN (TCL_ERROR);
        }


     XConvertSelection(XtDisplay(localVar1),XA_PRIMARY,XA_STRING,localVar2,DefaultRootWindow(XtDisplay(wafeTopLevel)),CurrentTime);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XStoreBuffer
 * 	in: XtDisplay(Widget)		# widget to determine display
 * 	in: String			# String
 * 	const: strlen(argv[2])
 * 	in: int				# buffer number (1-7)
 */

static int 
cmd_storeBuffer(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     int localVar3;

     DBUG_ENTER(argv[0]);  

     if (argc != 4) 
	 {
	 wafeArgcError(argc,argv,"",3);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 = (Widget) name2Widget(argv[1])))
         {
         wafeConvError(argc, argv, 1 ,NULL, "Widget");
         DBUG_RETURN (TCL_ERROR);
         }

    /* no need to assign  << localVar2 = argv[2] >>  */ 

     if (!(sscanf(argv[3], "%d", &localVar3)))
         {
         wafeConvError(argc, argv, 4 ,NULL, "int");
         DBUG_RETURN (TCL_ERROR);
         }

     XStoreBuffer(XtDisplay(localVar1),argv[2],strlen(argv[2]),localVar3);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * ******* begin required file <xpm.inc> *******
 */

/* yes buddy, it is a -*- c -*- program! */
#undef PIXMAPCACHETRACE
 /*
    * This file contains a new converter procedure and xpm support procedures:
    *
    *    A new StringToBitmap Converter, which is also able to convert
    *    Pixmaps (suffix .xpm). First it searches for a valid BitmapFile
    *    under the given filename; if the file format is invalid, it
    *    tries to interpret it as a pixmap file.
    */ 

#ifdef XPM
#include <xpm.h>
#include <X11/extensions/shape.h>
#endif
#include <X11/Xos.h>
#include <X11/Xmu/Xmu.h>

#ifdef XPM
 /* Create a linked list, which keeps track of all created pixmaps,
  * so that we can destroy Colorcells, if they are not longer needed.
  * Only the changePixmap command will use this feature, so pixmaps which
  * are set with setValues are still cached as usual by Xt!
  * Note that setting a pixmap with setValues therefore implies proctically
  * loosing these colorcells for the application's lifetime since Xt does
  * not see to free these!
  */
typedef struct _pixmapCache
     {
     Pixmap                pm;              /* Pixmap                */
     Pixmap                mask;            /* shape mask            */
     XpmAttributes        *attribPtr;       /* Colorcells, etc       */
     XrmQuark              fileName;        /* The filename..        */
     int                   count;           /* references            */
     struct _pixmapCache  *next;
     }  pixmapCache, *pixmapCachePtr;

static pixmapCachePtr pixmapCacheRoot = NULL;


 /* this is the per widget information about used pixmaps */
typedef struct _xpmList
     {
     XrmQuark         resName;  
     XrmQuark         fileName;
     Display         *dpy;
     Colormap         cmap;
     struct _xpmList *next;
     } xpmList, *xpmListPtr;
#endif


/* provide additional arguments for the pixmap converter: 
 */
static XtConvertArgRec xpmConvertArgsPixmap[] = {
  {XtWidgetBaseOffset, (XtPointer) XtOffsetOf(WidgetRec, core.window), 
   sizeof(Window)},
  {XtImmediate, (XtPointer)True, sizeof(Boolean)}
};


static XtConvertArgRec xpmConvertArgsBitmap[] = {
  {XtWidgetBaseOffset, (XtPointer) XtOffsetOf(WidgetRec, core.window), 
   sizeof(Window)}
};
   

/* try hard to locate bitmap or pixmap file */
static char *
locateBitmap(dpy, name, toPixmap)
Display *dpy;
char * name;
Boolean toPixmap;
    {
    char *fn;

    /* is the name enough? */
    if (access(name, R_OK) == 0)
	return name;
    else
	{
	if (!(fn = XtResolvePathname(dpy, "bitmaps", name, "", 
				     wafeFileSearchPath, NULL, 0, NULL)))
	    {
	    XtStringConversionWarning(name, toPixmap ? "Pixmap" : "Bitmap");
	    wafeWarn("convert", "Wafe's current FILESEARCHPATH is <%s>", 
		     wafeFileSearchPath,NULL,NULL);  
	    }
	return fn;
	}
    }


#ifdef XPM
static void 
setPixmap(widget, resource, qResName, pm, mask, width, height)
Widget        widget;
String        resource;
XrmQuark      qResName;
Pixmap        pm, mask;
unsigned int  width, height;
    {
    Display      *dpy = XtDisplay(widget);
    Window        window, root;
    Pixel         bpix;
    int           x,y;
    unsigned int  w,h,b,d;


#ifdef ATHENA
    /* XtVaSetValues fails nowadays on Label bitmaps with XtUnspecifiedPixmap*/
    if (pm == XtUnspecifiedPixmap) 
	return;
#endif

    if (qResName != qiconPixmap)
	{
	XtVaSetValues(widget, resource, pm, NULL);

/*	if ((pm != XtUnspecifiedPixmap) && (window = XtWindow(widget))) */
	if ((window = XtWindow(widget)))
	    if (mask)
		{
		int xOff=0, yOff=0;

		XGetGeometry(dpy,window,&root,&x,&y,&w,&h,&b,&d);
		if (w<width || h<height)
		    {
		    wafeWarn("changePixmap",
			"Shape mask for %s of %s larger than window; ignored", 
			resource, wafeWidgetToName(widget), NULL);
		    mask = (Pixmap) NULL;
		    } 
		else 
		    {
		    if (w>width)  xOff = (w - width ) / 2;
		    if (h>height) yOff = (h - height) / 2;
		    }
		XShapeCombineMask(dpy, window, ShapeBounding, xOff,yOff, 
				  mask, ShapeSet);
		XClearWindow(dpy,window);
		}
	    else
		{
		XShapeCombineMask(dpy, window, ShapeBounding, 0,0, 
				  mask, ShapeSet);
		}
	else
	    if (mask)
		wafeWarn("changePixmap",
			 "Cannot set shape mask for unrealized widget %s", 
			 wafeWidgetToName(widget), NULL, NULL);

	return;
	}

    /* icon pixmaps are more complicate to handle:
       1) get or create the icon window
       2) reconfigure it.
       3) under mwm and friends the rules for handling icons
          are different, since the icons are created withing a 
          surrounding frame
     */

    
    root = RootWindow(dpy, DefaultScreen(dpy));
    bpix = XBlackPixelOfScreen(DefaultScreenOfDisplay(dpy));

    XtVaGetValues(widget, XtNiconWindow, &window, NULL);
    if (!window)
	{
	window = XCreateSimpleWindow(dpy, root, 0, 0, 
				     width, height, 1, 
				     bpix, bpix);
	XtVaSetValues(widget, XtNiconWindow, window, NULL);
	}
    else 
	{
	XWindowChanges values;
	
	values.width  = width;
	values.height = height;

	/* reconfigure uglifies icon under MWM */
	if (motifWMRunning(widget))
	    {
	    XIconSize *size_list;
	    int count = 0;

	    XGetGeometry(dpy,window,&root,&x,&y,&w,&h,&b,&d);
	    XGetIconSizes(dpy, root, &size_list, &count);
	    if (count>0) 
		{
		if (values.width  > size_list->max_width)
		    values.width  = size_list->max_width;
		if (values.height > size_list->max_height)
		    values.height = size_list->max_height;

		values.x = (size_list->max_width  - values.width ) / 2 + 6;
		values.y = (size_list->max_height - values.height) / 2 + 6;

		XFree((char *)size_list);
		XReconfigureWMWindow(dpy,window, DefaultScreen(dpy),
				     CWX|CWY|CWWidth|CWHeight, &values);
		}
	    }
	else
	    XReconfigureWMWindow(dpy,window, DefaultScreen(dpy),
				 CWWidth|CWHeight, &values);
	}

    XSetWindowBackgroundPixmap(dpy, window, pm);
    XShapeCombineMask(dpy, window, ShapeBounding, 0, 0, mask, ShapeSet);
    XClearWindow(dpy,window);
    }



#ifdef PIXMAPCACHETRACE 
static void showPixmapCache(string)
String string;
    {
    pixmapCachePtr   pptr;
    fprintf(stderr,"Pixmap cache: %s\n",string);
    for (pptr=pixmapCacheRoot;  pptr != NULL; pptr=pptr->next)
	fprintf(stderr,"   %s (%x): count=%d\n",
		XrmQuarkToString(pptr->fileName),
		(int)pptr->pm,
		pptr->count
		);
    fprintf(stderr,"------------\n");
    }
#endif


/* Cleanup last settings:
 * Search the list of pixmaps to find out whether the specified pixmap's 
 * resources are to be freed - which is the case when it was created by
 * changePixmap
 */
static Pixmap 
freeInPixmapCache(dpy,cmap,qFileName)
Display    *dpy;
Colormap    cmap;
XrmQuark    qFileName;
    {
    pixmapCachePtr   pptr, lastPtr = NULL;
    Pixmap          toDestroy = (Pixmap) NULL;

    DBUG_ENTER("freeInPixmapCache");

#ifdef PIXMAPCACHETRACE 
    showPixmapCache("before Free");
#endif

    for (pptr=pixmapCacheRoot;  pptr != NULL; lastPtr=pptr, pptr=pptr->next)
	if (pptr->fileName == qFileName)
	    {
	    pptr->count--;
	    if (pptr->count < 1)
		{

		/* destroy Pixmap and deallocate resources */
		DBUG_PRINT("xpm",
			   ("deallocating pixmap %s (%x), %d colors", 
			    XrmQuarkToString(pptr->fileName), 
			    pptr->pm,
			    pptr->attribPtr->npixels));

		toDestroy = pptr->pm;
		if (pptr->attribPtr->depth > 1) 
		    XFreeColors(dpy, cmap, 
				pptr->attribPtr->pixels, 
				pptr->attribPtr->npixels, 0);
		if (pptr->mask) 
		    XFreePixmap(dpy,pptr->mask);

		XpmFreeAttributes(pptr->attribPtr);

		if (pptr == pixmapCacheRoot)
		    pixmapCacheRoot = pptr->next;
		else
		    lastPtr->next = pptr->next;
		XtFree((char *)pptr);
		}
	    break;
	    }
    
#ifdef PIXMAPCACHETRACE 
    showPixmapCache("after Free");
#endif
    DBUG_RETURN(toDestroy);
    }


String
xpmErrorReason (xpmReturnCode)
int             xpmReturnCode;
    {
    char *reason;
    
    switch (xpmReturnCode) 
	{
    case XpmColorError: 
	reason = "Color Error"; break;
    case XpmOpenFailed: 
	reason = "Open Failed"; break;
    case XpmFileInvalid: 
	reason = "File Invalid"; break;
    case XpmNoMemory: 
	reason = "No Memory"; break;
    case XpmColorFailed: 
	reason = "Color Failed"; break;
    default:
	reason = "Unknown Reason";
	}
    return reason;
    }

static pixmapCachePtr
getThroughPixmapCache(dpy,fname,qFileName,pixmapReturn)
Display      *dpy;
String        fname;
XrmQuark      qFileName;
Pixmap       *pixmapReturn;
    {
    pixmapCachePtr  pptr;
    char           *fn;
    int             xpmReturnCode,
                    screenNum  = DefaultScreen(dpy);
    unsigned int    depth      = DefaultDepth(dpy, screenNum);
    XpmAttributes  *attribPtr; 
    Pixmap          pixmap,mask;

    DBUG_ENTER("getThroughPixmapCache");
    /* is the pixmap already in the cache? */

    for (pptr = pixmapCacheRoot; pptr != NULL; pptr = pptr->next)
	{
	if (qFileName == pptr->fileName)
	    {
	    DBUG_PRINT("xpm", ("Pixmap %s (%x) found in cache",
			       fname, pptr->pm));
	    pptr->count ++;
	    DBUG_RETURN(pptr);
	    }
	}

    /* If the new pixmap's filename is None etc, 
     * don't create new entry, ut use shortcut
     */
    if (!strcmp(fname, "None"))
	{
	*pixmapReturn = None;
	DBUG_RETURN((pixmapCachePtr)NULL);
	}
    else 
    if (!strcmp(fname, "Unspecified"))
	{
	*pixmapReturn = XtUnspecifiedPixmap;
	DBUG_RETURN((pixmapCachePtr)NULL);
	}
    else
    if (!strcmp(fname, "ParentRelative"))
	{
	*pixmapReturn = ParentRelative;
	DBUG_RETURN((pixmapCachePtr)NULL);
	}

    /* we have to look for the file */
    if (!(fn = locateBitmap(dpy, fname, True)))
	{
	*pixmapReturn = XtUnspecifiedPixmap;
	DBUG_RETURN((pixmapCachePtr)NULL);
	}
    
    /* Now convert the new Pixmap-File, create a new element of the list 
     * and fill it with information.
     */
    attribPtr = (XpmAttributes *)XtCalloc(sizeof(XpmAttributes), sizeof(char));
    attribPtr->valuemask = XpmReturnPixels | XpmDepth | XpmReturnInfos;
    attribPtr->depth     = depth;
    /* fprintf(stderr, "changePixmap: calling xpmreadfile\n"); */
    xpmReturnCode = XpmReadFileToPixmap(dpy, RootWindow(dpy, screenNum), 
					fn, &pixmap, &mask, attribPtr); 
    /* fprintf(stderr, "changePixmap: xpmreadfile returned %d\n",returnVal); */
    if (fn != fname) 
	XtFree(fn);

    if (xpmReturnCode == XpmSuccess)
	{
	pptr = (pixmapCachePtr)XtMalloc(sizeof(pixmapCache));
	pptr->next      = pixmapCacheRoot;
	pptr->pm        = pixmap;
	pptr->mask      = mask;
	pptr->count     = 1;
	pptr->fileName  = qFileName;
	pptr->attribPtr = attribPtr;
	pixmapCacheRoot = pptr;
	DBUG_PRINT("xpm", ("%d colorcells are used for new pixmap %s (%x)", 
			   pptr->attribPtr->npixels, fname, pixmap));
	DBUG_RETURN(pptr);
	}
    else
	{
	char errorBuffer[200];
	sprintf(errorBuffer, 
		"Couldn't convert '%s' to pixmap (%s)", 
		fname,xpmErrorReason (xpmReturnCode));
	Tcl_SetResult(wafeInterpreter, errorBuffer, TCL_VOLATILE);
	XpmFreeAttributes(attribPtr);

	*pixmapReturn = XtUnspecifiedPixmap;
	DBUG_RETURN((pixmapCachePtr)NULL);

	}
    }     


void
freeXpmList(ptr)
char *ptr;
    {
    xpmListPtr p = (xpmListPtr)ptr, nextPtr;
    Pixmap     toDestroy;

    while (p) 
	{
	nextPtr = p->next;
	if ((toDestroy = freeInPixmapCache(p->dpy,p->cmap,p->fileName)))
	    XFreePixmap(p->dpy, toDestroy); 
	XtFree((char *)p);
	p = nextPtr;
	}
    }


static int
changePixmap(w,resource,fname)
Widget     w;
String     resource;
String     fname;
    {
    Colormap         cmap;
    Pixmap           toDestroy = (Pixmap)NULL,
                     pixmapReturn;
    Display         *dpy       = XtDisplay(w);
    XrmQuark         qResName  = XrmStringToQuark(resource), 
                     qFileName = XrmStringToQuark(fname);
    MMattribListPtr *al        = wafeMMgetAttribList(w,True);
    xpmListPtr       pixPtr    = (xpmListPtr)wafeMMgetValue(al, qxpmList),
                     tpixPtr;
    pixmapCachePtr   pptr;    

    if (!wafeGetQTypeOfAttribute(XtClass(w),ParentWidget(w),qResName,NULL))
	return wafeSetError("widget %s has no resource %s",
			    wafeWidgetToName(w), resource, NULL);

    for (tpixPtr = pixPtr; tpixPtr != NULL; tpixPtr = tpixPtr->next)
	if (qResName == tpixPtr->resName) /* it has already a xpm */
	    break;
    
    XtVaGetValues(w, XtNcolormap, &cmap, NULL);

    if (tpixPtr)
	{
	/* we have already a xpm for this widget & resource */
	if (qFileName == tpixPtr->fileName)
	    {
	    DBUG_PRINT("xpm", ("You are about to set the same pixmap!"));
	    return TCL_OK;
	    }
	else
	    toDestroy = freeInPixmapCache(dpy,cmap,tpixPtr->fileName);
	}
    else
	{
	/* we have no xpm for this widget & resource */
	tpixPtr = (xpmListPtr) XtMalloc(sizeof(xpmList));
	tpixPtr->next     = pixPtr;
	tpixPtr->resName  = qResName;
	tpixPtr->dpy      = dpy;
	tpixPtr->cmap     = cmap;
	if (!pixPtr) 
	    wafeMMreplace(al, qxpmList, (char *)tpixPtr, freeXpmList);
	}
    tpixPtr->fileName = qFileName;    

#ifdef PIXMAPCACHETRACE 
    showPixmapCache("Before");
#endif
    /* now try to obtain the pixmap by using the pixmap cache */
    if ((pptr = getThroughPixmapCache(dpy,fname,qFileName,&pixmapReturn))) 
	setPixmap(w, resource, qResName, pptr->pm, pptr->mask, 
		  pptr->attribPtr->width, pptr->attribPtr->height);
    else 
	setPixmap(w, resource, qResName, pixmapReturn, (Pixmap)NULL, 0, 0);

    if (toDestroy) 
	{
	DBUG_PRINT("xpm", ("old pixmap (%x) will be destroyed now", 
			   (int)toDestroy));
	XFreePixmap(dpy, toDestroy); 
	}

#ifdef PIXMAPCACHETRACE 
    showPixmapCache("After");
#endif
    if (wafeInterpreter->result && *(wafeInterpreter->result)) 
      return TCL_ERROR;
    else 
      return TCL_OK;
    }     
#endif /* XPM */



#define	CONVERSION_DONE(type, value) \
	{							\
	    if (toVal->addr != NULL) {				\
		if (toVal->size < sizeof(type)) {		\
		    toVal->size = sizeof(type);			\
		    return False;				\
		}						\
		*(type*)(toVal->addr) = (value);		\
	    }							\
	    else {						\
		static type static_val;				\
		static_val = (value);				\
		toVal->addr = (XtPointer)&static_val;		\
	    }							\
	    toVal->size = sizeof(type);				\
	    return True;					\
	}
               

Boolean
CvtStringToPixmapOrBitmap(dpy, args, num_args, fromVal, toVal,
		   converter_data)
Display *dpy;
XrmValuePtr args;
Cardinal *num_args;
XrmValuePtr fromVal;
XrmValuePtr toVal;
XtPointer *converter_data;
    {
    static Pixmap    pixmap;               /* static for cvt magic */
    String           name;
    Screen          *screen;
    int              screenNum;
    String           fn = NULL;
    unsigned int     width, height;
    int              xhot, yhot;
    unsigned char   *data;
    int              returnValue;
    Boolean          toPixmap = *num_args>1;
#ifdef XPM
    Pixmap           mask;
    Window           coreWin;
    XpmAttributes    attrib;
#endif
   
    pixmap = (Pixmap) NULL;
    name   = (String) fromVal->addr;

    screen = DefaultScreenOfDisplay(dpy);
    screenNum = DefaultScreen(dpy);

    DBUG_PRINT("xpm",("Trying to convert '%s' to %s",
		      name,toPixmap ? "Pixmap" : "Bitmap"));
  
    if (strcmp(name, "None") == 0) 
        {
        pixmap = None;
        CONVERSION_DONE(Pixmap,pixmap);
        }

    if (strcmp(name, "ParentRelative") == 0 && toPixmap) 
        {
        pixmap = ParentRelative;
        CONVERSION_DONE(Pixmap,pixmap);
        }

    if (strcmp(name, "Unspecified") == 0 && toPixmap) 
        {
        pixmap = XtUnspecifiedPixmap;
        CONVERSION_DONE(Pixmap,pixmap);
        }

#ifdef MOTIF12
    if ((pixmap = 
	 XmGetPixmapByDepth(screen,name, 
			    XBlackPixelOfScreen(screen),
			    XWhitePixelOfScreen(screen),
			    1)
	 ) != XmUNSPECIFIED_PIXMAP) 
	{
	CONVERSION_DONE(Pixmap,pixmap);
	}
#endif

    if (!(fn = locateBitmap(dpy, name, toPixmap)))
	return False;

    /* we have a valid filename fn */
    /* try to read file as bitmap file... */
    if (XmuReadBitmapDataFromFile(fn, &width, &height, &data,
				      &xhot, &yhot) == BitmapSuccess)
	{
	pixmap = XCreatePixmapFromBitmapData(dpy,
			RootWindowOfScreen(screen),
			(char *) data, width, height, 1, 0, 
			toPixmap?DefaultDepth(dpy, DefaultScreen(dpy)):1);

	XFree((char *)data);

	if (name != fn) XtFree(fn);
	CONVERSION_DONE(Pixmap,pixmap);
	}

#ifdef XPM    
    attrib.valuemask = XpmReturnPixels | XpmDepth | XpmReturnInfos;
    attrib.depth = DefaultDepthOfScreen(DefaultScreenOfDisplay(dpy));

    if ((returnValue = XpmReadFileToPixmap(dpy,RootWindow(dpy,screenNum),
					   fn, &pixmap, &mask, &attrib))
	!= XpmSuccess)
	{

	wafeWarn("convertPixmap", "Couldn't convert '%s' to pixmap (%s)", 
		fn, xpmErrorReason (returnValue), NULL);
#else
	wafeWarn("convertPixmap", "No XPM configured", NULL,NULL,NULL);
#endif
	XtStringConversionWarning(name, toPixmap ? "Pixmap" : "Bitmap");

	if (name != fn) XtFree(fn);
	return False;
#ifdef XPM
	}
    else 
	{
/*
	fprintf(stderr,"pixmap=%p, width=%d, height=%d, addr=%p\n",pixmap,
		attrib.width,attrib.height,toVal->addr);
*/
	coreWin = *((Window *) args[0].addr);
	if (wafeCurrentAttrib != qiconPixmap)
	    {
	    /* if toVal->addr is set we assume that the value comes
	       from a resource file, in which case we can't assume that
	       the core fields of the widget are already initialized; 
	       coreWin will be wrong; Wafe never sets toVal->addr */
	    if (coreWin && !toVal->addr) 
		{
		XShapeCombineMask(dpy, coreWin, ShapeBounding,
				  0, 0, mask, ShapeSet);
		/* fprintf(stderr,"converter set mask\n");*/
		}
	    }
	else 
	if (wafeCurrentWidget)
	    XtVaSetValues(wafeCurrentWidget,XtNiconMask,mask,NULL);
	
	if (name != fn) XtFree(fn);
	CONVERSION_DONE(Pixmap,pixmap);
	}
#endif /* XPM */
    }

/* to keep knowledge about xpmConvertArgsPixmap etc local ...
 */
void
wafeRegisterXpmTypeConverter(resourceType, toPixmap)
char * resourceType;
Boolean toPixmap;
    { 
    if (toPixmap)
	XtSetTypeConverter(XtRString, 
			   resourceType, 
			   (XtTypeConverter)CvtStringToPixmapOrBitmap, 
			   xpmConvertArgsPixmap, 
			   2,
			   XtCacheByDisplay,
			   NULL);
    else
	XtSetTypeConverter(XtRString, 
			   resourceType, 
			   (XtTypeConverter)CvtStringToPixmapOrBitmap, 
			   xpmConvertArgsBitmap, 
			   1, 
			   XtCacheByDisplay, 
			   NULL);
    }


/* 
 * ******* end required file <xpm.inc> *******
 */
/* 
 * hint: XPM
 * TCL_RETURN_CODE
 * changePixmap
 * 	in: Widget			# widget
 * 	in: String			# resource
 * 	in: String			# pixmap file
 */
#ifdef XPM

static int 
cmd_changePixmap(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     TCL_RETURN_CODE returnVar;

     DBUG_ENTER(argv[0]);  

     if (argc != 4) 
	 {
	 wafeArgcError(argc,argv,"",3);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 = (Widget) name2Widget(argv[1])))
         {
         wafeConvError(argc, argv, 1 ,NULL, "Widget");
         DBUG_RETURN (TCL_ERROR);
         }

    /* no need to assign  << localVar2 = argv[2] >>  */ 

    /* no need to assign  << localVar3 = argv[3] >>  */ 

     returnVar = changePixmap(localVar1,argv[2],argv[3]);

     DBUG_RETURN (returnVar);
     }     

#endif

/* 
 * hint: R6
 * WidgetID (WidgetID)
 * XtHooksOfDisplay
 * 	in: XtDisplay(Widget)		# widget to determine display
 *         post: wafeCurrentAttribList=wafeMMgetAttribList((Widget)returnVar,True); wafeMMsetAttribList((Widget)returnVar); wafeCurrentAttribList = NULL;
 */
#ifndef PRER6

static int 
cmd_hooksOfDisplay(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     WidgetID returnVar;
     char conversionBuffer[100];

     DBUG_ENTER(argv[0]);  

     if (argc != 2) 
	 {
	 wafeArgcError(argc,argv,"",1);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 = (Widget) name2Widget(argv[1])))
         {
         wafeConvError(argc, argv, 1 ,NULL, "Widget");
         DBUG_RETURN (TCL_ERROR);
         }

     returnVar = (WidgetID) XtHooksOfDisplay(XtDisplay(localVar1));
     wafeCurrentAttribList=wafeMMgetAttribList((Widget)returnVar,True); wafeMMsetAttribList((Widget)returnVar); wafeCurrentAttribList = NULL;

     sprintf(conversionBuffer, "%ld", returnVar);
     Tcl_SetResult(comInterpreter, conversionBuffer, TCL_VOLATILE);

     DBUG_RETURN (TCL_OK);
     }     

#endif

/* 
 * MapState
 * mapState
 * 	in: Widget                     # any widget
 */

static int 
cmd_mapState(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     MapState returnVar;
     char *staticResultString;

     DBUG_ENTER(argv[0]);  

     if (argc != 2) 
	 {
	 wafeArgcError(argc,argv,"",1);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 = (Widget) name2Widget(argv[1])))
         {
         wafeConvError(argc, argv, 1 ,NULL, "Widget");
         DBUG_RETURN (TCL_ERROR);
         }

     returnVar = mapState(localVar1);

     if (returnVar == 0) 
         staticResultString = "IsUnmapped";
     else if (returnVar == 1) 
         staticResultString = "IsUnviewable";
     else if (returnVar == 2) 
         staticResultString = "IsViewable";
     else 
         staticResultString = "UNKNOWN";

     Tcl_SetResult(comInterpreter, staticResultString, TCL_STATIC);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * XtWorkProcId
 * XtAppAddWorkProc
 * 	const: wafeAppContext 
 * 	const: workProc
 * 	in: XtNewString(String)		# Tcl command
 */

static int 
cmd_addWorkProc(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     XtWorkProcId returnVar;
     char conversionBuffer[100];

     DBUG_ENTER(argv[0]);  

     if (argc != 2) 
	 {
	 wafeArgcError(argc,argv,"",1);
	 DBUG_RETURN (TCL_ERROR);
         }

    /* no need to assign  << localVar1 = argv[1] >>  */ 

     returnVar = XtAppAddWorkProc(wafeAppContext,workProc,XtNewString(argv[1]));

     sprintf(conversionBuffer, "%lu", returnVar);
     Tcl_SetResult(comInterpreter, conversionBuffer, TCL_VOLATILE);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void 
 * XtRemoveWorkProc 
 * 	in: XtWorkProcId		# work proc ID
 */

static int 
cmd_removeWorkProc(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     XtWorkProcId localVar1;

     DBUG_ENTER(argv[0]);  

     if (argc != 2) 
	 {
	 wafeArgcError(argc,argv,"",1);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(sscanf(argv[1], "%lu", &localVar1)))
         {
         wafeConvError(argc, argv, 1 ,NULL, "XtWorkProcId");
         DBUG_RETURN (TCL_ERROR);
         }

     XtRemoveWorkProc(localVar1);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * Boolean
 * XtIsShell
 * 	in: Widget			# widget
 */

static int 
cmd_isShell(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     Boolean returnVar;

     DBUG_ENTER(argv[0]);  

     if (argc != 2) 
	 {
	 wafeArgcError(argc,argv,"",1);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 = (Widget) name2Widget(argv[1])))
         {
         wafeConvError(argc, argv, 1 ,NULL, "Widget");
         DBUG_RETURN (TCL_ERROR);
         }

     returnVar = XtIsShell(localVar1);

     Tcl_SetResult(comInterpreter, returnVar ? "1" : "0", TCL_STATIC);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * hint: R5
 * String (TCL_RETURN_CODE)
 * getActionList
 * 	in: XtClass(Widget)		# widget
 */
#ifndef PRER5

static int 
cmd_getActionList(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     TCL_RETURN_CODE returnVar;

     DBUG_ENTER(argv[0]);  

     if (argc != 2) 
	 {
	 wafeArgcError(argc,argv,"",1);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 = (Widget) name2Widget(argv[1])))
         {
         wafeConvError(argc, argv, 1 ,NULL, "Widget");
         DBUG_RETURN (TCL_ERROR);
         }

     returnVar = (TCL_RETURN_CODE) getActionList(XtClass(localVar1));

     DBUG_RETURN (returnVar);
     }     

#endif

#define name2AtomLV1chk(s) wafeStringToAtomChk(localVar1,s)
#ifdef MOTIF
#include <Xm/AtomMgr.h>
#endif

/* 
 * (String) DString
 * wafeGetAtomName vulgo atomName
 * 	in: XtDisplay(Widget)		# widget to determine display
 * 	in: name2AtomLV1chk(String)	# atom
 */

static int 
cmd_atomName(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     String returnVar;

     DBUG_ENTER(argv[0]);  

     if (argc != 3) 
	 {
	 wafeArgcError(argc,argv,"",2);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 = (Widget) name2Widget(argv[1])))
         {
         wafeConvError(argc, argv, 1 ,NULL, "Widget");
         DBUG_RETURN (TCL_ERROR);
         }

    /* no need to assign  << localVar2 = argv[2] >>  */ 

     returnVar = wafeGetAtomName(XtDisplay(localVar1),name2AtomLV1chk(argv[2]));

     Tcl_SetResult(comInterpreter, returnVar, XtFree);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * AtomID
 * wafeStringToAtom vulgo atomId
 * 	in: Widget			# widget to determine display
 * 	in: String			# atom
 */

static int 
cmd_atomId(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     AtomID returnVar;
     char conversionBuffer[100];

     DBUG_ENTER(argv[0]);  

     if (argc != 3) 
	 {
	 wafeArgcError(argc,argv,"",2);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 = (Widget) name2Widget(argv[1])))
         {
         wafeConvError(argc, argv, 1 ,NULL, "Widget");
         DBUG_RETURN (TCL_ERROR);
         }

    /* no need to assign  << localVar2 = argv[2] >>  */ 

     returnVar = wafeStringToAtom(localVar1,argv[2]);

     sprintf(conversionBuffer, "%ld", returnVar);
     Tcl_SetResult(comInterpreter, conversionBuffer, TCL_VOLATILE);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * AtomID
 * wafeStringToAtomChk vulgo isAtom
 * 	in: Widget			# widget to determine display
 * 	in: String			# atom
 */

static int 
cmd_isAtom(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     AtomID returnVar;
     char conversionBuffer[100];

     DBUG_ENTER(argv[0]);  

     if (argc != 3) 
	 {
	 wafeArgcError(argc,argv,"",2);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 = (Widget) name2Widget(argv[1])))
         {
         wafeConvError(argc, argv, 1 ,NULL, "Widget");
         DBUG_RETURN (TCL_ERROR);
         }

    /* no need to assign  << localVar2 = argv[2] >>  */ 

     returnVar = wafeStringToAtomChk(localVar1,argv[2]);

     sprintf(conversionBuffer, "%ld", returnVar);
     Tcl_SetResult(comInterpreter, conversionBuffer, TCL_VOLATILE);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * Boolean
 * motifWMRunning
 *        in: ShellWidget                 # any shell widget
 */

static int 
cmd_motifWMRunning(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     Boolean returnVar;

     DBUG_ENTER(argv[0]);  

     if (argc != 2) 
	 {
	 wafeArgcError(argc,argv,"",1);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],shellWidgetClass,"Shell")))
         {
         wafeConvError(argc, argv, 1 ,NULL, "ShellWidget");
         DBUG_RETURN (TCL_ERROR);
         }

     returnVar = motifWMRunning(localVar1);

     Tcl_SetResult(comInterpreter, returnVar ? "1" : "0", TCL_STATIC);

     DBUG_RETURN (TCL_OK);
     }     



void
wafeInitialize_XT()
{
 wafeCreateWidgetCommand("ApplicationShell",applicationShellWidgetClass,XtAppCreateShell,False);
#ifdef LAYOUT
 wafeCreateWidgetCommand("Layout",layoutWidgetClass,NULL,False);
#endif
 wafeCreateWidgetCommand("OverrideShell",overrideShellWidgetClass,XtCreatePopupShell,True);
 wafeCreateWidgetCommand("TopLevelShell",topLevelShellWidgetClass,XtCreatePopupShell,True);
 wafeCreateWidgetCommand("TransientShell",transientShellWidgetClass,XtCreatePopupShell,True);
#ifdef XPM
 Tcl_SetVar(wafeInterpreter,"PACKAGES","XPM",TCL_GLOBAL_ONLY|TCL_APPEND_VALUE|TCL_LIST_ELEMENT);
#endif
#ifdef LAYOUT
 Tcl_SetVar(wafeInterpreter,"PACKAGES","LAYOUT",TCL_GLOBAL_ONLY|TCL_APPEND_VALUE|TCL_LIST_ELEMENT);
#endif
 qString = WafePermStringToQuark("String");
 qCallback = WafePermStringToQuark("Callback");
 qPointer = WafePermStringToQuark("Pointer");
 qcallback = WafePermStringToQuark("callback");
 qbusyWindow = WafePermStringToQuark("busyWindow");
 qxpmList = WafePermStringToQuark("xpmList");
 qiconPixmap = WafePermStringToQuark("iconPixmap");
 qInt = WafePermStringToQuark("Int");
 qDimension = WafePermStringToQuark("Dimension");
 qCardinal = WafePermStringToQuark("Cardinal");
 qPosition = WafePermStringToQuark("Position");
 qFloat = WafePermStringToQuark("Float");
 qDouble = WafePermStringToQuark("Double");
 qPixel = WafePermStringToQuark("Pixel");
 qBoolean = WafePermStringToQuark("Boolean");
 qWidgetList = WafePermStringToQuark("WidgetList");
 qWidget = WafePermStringToQuark("Widget");
 XtSetTypeConverter(XtRString, XtRWidget,
	(XtTypeConverter)CvtStringToWidget, 
	NULL, 0, XtCacheNone, NULL);
 XtSetTypeConverter(XtRString, XtRCallback,
	(XtTypeConverter)CvtStringToCallback, 
	NULL, 0, XtCacheNone, NULL);
 XtSetTypeConverter(XtRString, XtRWidgetList,
	(XtTypeConverter)CvtStringToWidgetList, 
	NULL, 0, XtCacheNone, NULL);
 XtSetTypeConverter(XtRString, XtRPointer,
	(XtTypeConverter)CvtStringToPointer, 
	NULL, 0, XtCacheNone, NULL);
#ifndef PRER5
 XtSetTypeConverter(XtRString, XtRCardinal,
	(XtTypeConverter)XtCvtStringToInt, 
	NULL, 0, XtCacheNone, NULL);
#endif
 Tcl_CreateCommand(wafeInterpreter, "addTimeOut", cmd_addTimeOut, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "action", cmd_action, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "bell", cmd_bell, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "callActionProc", cmd_callActionProc, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "callCallbacks", cmd_callCallbacks, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "callback", cmd_callback, NULL, NULL);
#ifndef PRER5
 Tcl_CreateCommand(wafeInterpreter, "combineFileDatabase", cmd_combineFileDatabase, NULL, NULL);
#endif
 Tcl_CreateCommand(wafeInterpreter, "destroyWidget", cmd_destroyWidget, NULL, NULL);
#ifndef PRER5
 Tcl_CreateCommand(wafeInterpreter, "fallbackResources", cmd_fallbackResources, NULL, NULL);
#endif
 Tcl_CreateCommand(wafeInterpreter, "fontHeight", cmd_fontHeight, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "flush", cmd_flush, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "getApplicationResource", cmd_getApplicationResource, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "getClass", cmd_getClass, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "getResourceList", cmd_getResourceList, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "getTypeOfAttribute", cmd_getTypeOfAttribute, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "getValue", cmd_getValue, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "grabKeyboard", cmd_grabKeyboard, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "grabPointer", cmd_grabPointer, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "heightOfScreen", cmd_heightOfScreen, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "installAccelerators", cmd_installAccelerators, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "installAllAccelerators", cmd_installAllAccelerators, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "isWidget", cmd_isWidget, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "lowerWindow", cmd_lowerWindow, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "manageChild", cmd_manageChild, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "mapWidget", cmd_mapWidget, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "mergeResources", cmd_mergeResources, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "nameToWidget", cmd_nameToWidget, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "parent", cmd_parent, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "popdown", cmd_popdown, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "popup", cmd_popup, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "popupChildren", cmd_popupChildren, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "popupSpringLoaded", cmd_popupSpringLoaded, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "processPendingEvents", cmd_processPendingEvents, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "raiseWindow", cmd_raiseWindow, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "realize", cmd_realize, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "realizeWidget", cmd_realizeWidget, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "removeAllCallbacks", cmd_removeAllCallbacks, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "removeTimeOut", cmd_removeTimeOut, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "resolvePathname", cmd_resolvePathname, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "setBusy", cmd_setBusy, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "setKeyboardFocus", cmd_setKeyboardFocus, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "setSensitive", cmd_setSensitive, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "setValues", cmd_setValues, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "setWMProtocols", cmd_setWMProtocols, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "sync", cmd_sync, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "textWidth", cmd_textWidth, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "translateCoords", cmd_translateCoords, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "ungrabPointer", cmd_ungrabPointer, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "ungrabKeyboard", cmd_ungrabKeyboard, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "unmanageChild", cmd_unmanageChild, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "unmapWidget", cmd_unmapWidget, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "unrealizeWidget", cmd_unrealizeWidget, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "waitForVariable", cmd_waitForVariable, NULL, NULL);
 /* alias */  Tcl_CreateCommand(wafeInterpreter,"widgetId",cmd_isWidget, NULL,NULL);
 Tcl_CreateCommand(wafeInterpreter, "widgetName", cmd_widgetName, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "widthOfScreen", cmd_widthOfScreen, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "window", cmd_window, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "disownSelection", cmd_disownSelection, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "getSelectionValue", cmd_getSelectionValue, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "ownSelection", cmd_ownSelection, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "fetchBuffer", cmd_fetchBuffer, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "fetchBytes", cmd_fetchBytes, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "convertSelection", cmd_convertSelection, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "storeBuffer", cmd_storeBuffer, NULL, NULL);
 /* alias */  Tcl_CreateCommand(wafeInterpreter,"sV",cmd_setValues, NULL,NULL);
 /* alias */  Tcl_CreateCommand(wafeInterpreter,"gV",cmd_getValue, NULL,NULL);
 wafeRegisterXpmTypeConverter(XtRBitmap, False);
 wafeRegisterXpmTypeConverter(XtRPixmap, True);
#ifdef XPM
 Tcl_CreateCommand(wafeInterpreter, "changePixmap", cmd_changePixmap, NULL, NULL);
#endif
#ifndef PRER6
 Tcl_CreateCommand(wafeInterpreter, "hooksOfDisplay", cmd_hooksOfDisplay, NULL, NULL);
#endif
 Tcl_CreateCommand(wafeInterpreter, "mapState", cmd_mapState, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "addWorkProc", cmd_addWorkProc, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "removeWorkProc", cmd_removeWorkProc, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "isShell", cmd_isShell, NULL, NULL);
#ifndef PRER5
 Tcl_CreateCommand(wafeInterpreter, "getActionList", cmd_getActionList, NULL, NULL);
#endif
 Tcl_CreateCommand(wafeInterpreter, "atomName", cmd_atomName, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "atomId", cmd_atomId, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "isAtom", cmd_isAtom, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "motifWMRunning", cmd_motifWMRunning, NULL, NULL);
}
