/* Copyright (C) 1992 by Gustaf Neumann, Stefan Nusser

 *      Wirtschaftsuniversitaet Wien, 
 *      Abteilung fuer Wirtschaftsinformatik
 *      Augasse 2-6, 
 *      A-1090 Vienna, Austria
 *      neumann@wu-wien.ac.at, nusser@wu-wien.ac.at

 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided
 * that the above copyright notice appears in all copies and that both that
 * copyright notice and this permission notice appear in all supporting
 * documentation.  This software is provided "as is" without expressed or
 * implied warranty.

 * Creation: Sun Dec 18 22:08:52 EST 1994 on mohegan
 * Author: genc
 * Version: 1.0.6


 */
#define ATHENAR5_C
#include <wafe.h>
#ifdef ATHENAR5
#include <X11/Xaw/Panner.h>
#include <X11/Xaw/Porthole.h>
#include <X11/Xaw/Tree.h>
#include <X11/Xaw/Repeater.h>

/* 
 * ******* begin required file <athena5.inc> *******
 */

/* treat me like a -*-c-*- program, treat me, treat me, treat me! */

/*      Function Name: PannerCallback
 *      Description: called when the panner has moved.
 *      Arguments: panner - the panner widget.
 *                 child - child to be moved.
 *                 report_ptr - the panner record.
 *      Returns: none.
 */

static void 
pannerCallbackProc(w, child, report_ptr)
Widget w;
XtPointer child, report_ptr;
    {
    Arg args[2];
    XawPannerReport *report = (XawPannerReport *) report_ptr;

    XtSetArg(args[0], XtNx, -report->slider_x);
    XtSetArg(args[1], XtNy, -report->slider_y);
    
    XtSetValues(child, args, 2);
    }


/*      Function Name: PortholeCallback
 *      Description: called when the porthole or its child has
 *                   changed 
 *      Arguments: porthole - the porthole widget.
 *                 panner_ptr - the panner widget.
 *                 report_ptr - the porthole record.
 *      Returns: none.
 */


static void 
portholeCallbackProc(w, panner_ptr, report_ptr)
Widget w;
XtPointer panner_ptr, report_ptr;
    {
    Arg args[10];
    Cardinal n = 0;
    XawPannerReport *report = (XawPannerReport *) report_ptr;
    Widget panner = (Widget) panner_ptr;

    XtSetArg(args[n], XtNsliderX, report->slider_x); n++;
    XtSetArg(args[n], XtNsliderY, report->slider_y); n++;
    if (report->changed != (XawPRSliderX | XawPRSliderY)) 
	{
        XtSetArg(args[n], XtNsliderWidth,  report->slider_width);  n++;
        XtSetArg(args[n], XtNsliderHeight, report->slider_height); n++;
        XtSetArg(args[n], XtNcanvasWidth,  report->canvas_width);  n++;
        XtSetArg(args[n], XtNcanvasHeight, report->canvas_height); n++; 
	}
    XtSetValues(panner, args, n);
    }



/* 
 * ******* end required file <athena5.inc> *******
 */
extern void portholeCallbackProc();
extern void pannerCallbackProc();

#define XawTalk(pa, po, ch) XtAddCallback(po, XtNreportCallback, portholeCallbackProc, (XtPointer) pa); XtAddCallback(pa, XtNreportCallback, pannerCallbackProc, (XtPointer) ch)

/* 
 * void
 * XawTalk
 * 	in: PannerWidget	# panner
 * 	in: PortholeWidget	# porthole
 * 	in: Widget		# managed widget
 */

static int 
cmd_XawTalk(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     Widget localVar2;
     Widget localVar3;

     DBUG_ENTER(argv[0]);  

     if (argc != 4) 
	 {
	 wafeArgcError(argc,argv,"",3);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],pannerWidgetClass,"Panner")))
         {
         wafeConvError(argc, argv, 1 ,NULL, "PannerWidget");
         DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar2 =  name2WidgetOfClass(argv[2],portholeWidgetClass,"Porthole")))
         {
         wafeConvError(argc, argv, 2 ,NULL, "PortholeWidget");
         DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar3 = (Widget) name2Widget(argv[3])))
         {
         wafeConvError(argc, argv, 3 ,NULL, "Widget");
         DBUG_RETURN (TCL_ERROR);
         }

     XawTalk(localVar1,localVar2,localVar3);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XawTreeForceLayout
 * 	in: TreeWidget		# tree Widget

 */

static int 
cmd_XawTreeForceLayout(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;

     DBUG_ENTER(argv[0]);  

     if (argc != 2) 
	 {
	 wafeArgcError(argc,argv,"",1);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],treeWidgetClass,"Tree")))
         {
         wafeConvError(argc, argv, 1 ,NULL, "TreeWidget");
         DBUG_RETURN (TCL_ERROR);
         }

     XawTreeForceLayout(localVar1);

     DBUG_RETURN (TCL_OK);
     }     


#endif  /* of ifdef ATHENAR5 */

void
wafeInitialize_ATHENAR5()
{
#ifdef ATHENAR5
 wafeCreateWidgetCommand("Panner",pannerWidgetClass,NULL,False);
 wafeCreateWidgetCommand("Porthole",portholeWidgetClass,NULL,False);
 wafeCreateWidgetCommand("Repeater",repeaterWidgetClass,NULL,False);
 wafeCreateWidgetCommand("Tree",treeWidgetClass,NULL,False);
#ifdef XAWR5
 Tcl_SetVar(wafeInterpreter,"PACKAGES","XAWR5",TCL_GLOBAL_ONLY|TCL_APPEND_VALUE|TCL_LIST_ELEMENT);
#endif
 Tcl_CreateCommand(wafeInterpreter, "XawTalk", cmd_XawTalk, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XawTreeForceLayout", cmd_XawTreeForceLayout, NULL, NULL);

#else
 wafeCreateWidgetCommand("Panner",NULL,NULL,False);
 wafeCreateWidgetCommand("Porthole",NULL,NULL,False);
 wafeCreateWidgetCommand("Repeater",NULL,NULL,False);
 wafeCreateWidgetCommand("Tree",NULL,NULL,False);
#endif /* of ifdef ATHENAR5 */
}
