/* yes buddy, it is a -*- c -*- program! */
#undef PIXMAPCACHETRACE
 /*
    * This file contains a new converter procedure and xpm support procedures:
    *
    *    A new StringToBitmap Converter, which is also able to convert
    *    Pixmaps (suffix .xpm). First it searches for a valid BitmapFile
    *    under the given filename; if the file format is invalid, it
    *    tries to interpret it as a pixmap file.
    */ 

#ifdef XPM
#include <xpm.h>
#include <X11/extensions/shape.h>
#endif
#include <X11/Xos.h>
#include <X11/Xmu/Xmu.h>

#ifdef XPM
 /* Create a linked list, which keeps track of all created pixmaps,
  * so that we can destroy Colorcells, if they are not longer needed.
  * Only the changePixmap command will use this feature, so pixmaps which
  * are set with setValues are still cached as usual by Xt!
  * Note that setting a pixmap with setValues therefore implies proctically
  * loosing these colorcells for the application's lifetime since Xt does
  * not see to free these!
  */
typedef struct _pixmapCache
     {
     Pixmap                pm;              /* Pixmap                */
     Pixmap                mask;            /* shape mask            */
     XpmAttributes        *attribPtr;       /* Colorcells, etc       */
     XrmQuark              fileName;        /* The filename..        */
     int                   count;           /* references            */
     struct _pixmapCache  *next;
     }  pixmapCache, *pixmapCachePtr;

static pixmapCachePtr pixmapCacheRoot = NULL;


 /* this is the per widget information about used pixmaps */
typedef struct _xpmList
     {
     XrmQuark         resName;  
     XrmQuark         fileName;
     Display         *dpy;
     Colormap         cmap;
     struct _xpmList *next;
     } xpmList, *xpmListPtr;
#endif


/* provide additional arguments for the pixmap converter: 
 */
static XtConvertArgRec xpmConvertArgsPixmap[] = {
  {XtWidgetBaseOffset, (XtPointer) XtOffsetOf(WidgetRec, core.window), 
   sizeof(Window)},
  {XtImmediate, (XtPointer)True, sizeof(Boolean)}
};


static XtConvertArgRec xpmConvertArgsBitmap[] = {
  {XtWidgetBaseOffset, (XtPointer) XtOffsetOf(WidgetRec, core.window), 
   sizeof(Window)}
};
   

/* try hard to locate bitmap or pixmap file */
static char *
locateBitmap(dpy, name, toPixmap)
Display *dpy;
char * name;
Boolean toPixmap;
    {
    char *fn;

    /* is the name enough? */
    if (access(name, R_OK) == 0)
	return name;
    else
	{
	if (!(fn = XtResolvePathname(dpy, "bitmaps", name, "", 
			       wafeFileSearchPath, NULL, 0, NULL)))
	    {
	    XtStringConversionWarning(name, toPixmap ? "Pixmap" : "Bitmap");
	    wafeWarn("convert", "Wafe's current FILESEARCHPATH is <%s>", 
		     wafeFileSearchPath,NULL,NULL);  
	    }
	return fn;
	}
    }


#ifdef XPM
static void 
setPixmap(widget, resource, qResName, pm, mask, width, height)
Widget        widget;
String        resource;
XrmQuark      qResName;
Pixmap        pm, mask;
unsigned int  width, height;
    {
    Display      *dpy = XtDisplay(widget);
    Window        window, root;
    Pixel         bpix;
    int           x,y;
    unsigned int  w,h,b,d;


#ifdef ATHENA
    /* XtVaSetValues fails nowadays on Label bitmaps with XtUnspecifiedPixmap*/
    if (pm == XtUnspecifiedPixmap) 
	return;
#endif

    if (qResName != qiconPixmap)
	{
	XtVaSetValues(widget, resource, pm, NULL);

/*	if ((pm != XtUnspecifiedPixmap) && (window = XtWindow(widget))) */
	if ((window = XtWindow(widget)))
	    if (mask)
		{
		int xOff=0, yOff=0;

		XGetGeometry(dpy,window,&root,&x,&y,&w,&h,&b,&d);
		if (w<width || h<height)
		    {
		    wafeWarn("changePixmap",
			"Shape mask for %s of %s larger than window; ignored", 
			resource, wafeWidgetToName(widget), NULL);
		    mask = (Pixmap) NULL;
		    } 
		else 
		    {
		    if (w>width)  xOff = (w - width ) / 2;
		    if (h>height) yOff = (h - height) / 2;
		    }
		XShapeCombineMask(dpy, window, ShapeBounding, xOff,yOff, 
				  mask, ShapeSet);
		XClearWindow(dpy,window);
		}
	    else
		{
		XShapeCombineMask(dpy, window, ShapeBounding, 0,0, 
				  mask, ShapeSet);
		}
	else
	    if (mask)
		wafeWarn("changePixmap",
			 "Cannot set shape mask for unrealized widget %s", 
			 wafeWidgetToName(widget), NULL, NULL);

	return;
	}

    /* icon pixmaps are more complicate to handle:
       1) get or create the icon window
       2) reconfigure it.
       3) under mwm and friends the rules for handling icons
          are different, since the icons are created withing a 
          surrounding frame
     */

    
    root = RootWindow(dpy, DefaultScreen(dpy));
    bpix = XBlackPixelOfScreen(DefaultScreenOfDisplay(dpy));

    XtVaGetValues(widget, XtNiconWindow, &window, NULL);
    if (!window)
	{
	window = XCreateSimpleWindow(dpy, root, 0, 0, 
				     width, height, 1, 
				     bpix, bpix);
	XtVaSetValues(widget, XtNiconWindow, window, NULL);
	}
    else 
	{
	XWindowChanges values;
	
	values.width  = width;
	values.height = height;

	/* reconfigure uglifies icon under MWM */
	if (motifWMRunning(widget))
	    {
	    XIconSize *size_list;
	    int count = 0;

	    XGetGeometry(dpy,window,&root,&x,&y,&w,&h,&b,&d);
	    XGetIconSizes(dpy, root, &size_list, &count);
	    if (count>0) 
		{
		if (values.width  > size_list->max_width)
		    values.width  = size_list->max_width;
		if (values.height > size_list->max_height)
		    values.height = size_list->max_height;

		values.x = (size_list->max_width  - values.width ) / 2 + 6;
		values.y = (size_list->max_height - values.height) / 2 + 6;

		XFree((char *)size_list);
		XReconfigureWMWindow(dpy,window, DefaultScreen(dpy),
				     CWX|CWY|CWWidth|CWHeight, &values);
		}
	    }
	else
	    XReconfigureWMWindow(dpy,window, DefaultScreen(dpy),
				 CWWidth|CWHeight, &values);
	}

    XSetWindowBackgroundPixmap(dpy, window, pm);
    XShapeCombineMask(dpy, window, ShapeBounding, 0, 0, mask, ShapeSet);
    XClearWindow(dpy,window);
    }



#ifdef PIXMAPCACHETRACE 
static void showPixmapCache(string)
String string;
    {
    pixmapCachePtr   pptr;
    fprintf(stderr,"Pixmap cache: %s\n",string);
    for (pptr=pixmapCacheRoot;  pptr != NULL; pptr=pptr->next)
	fprintf(stderr,"   %s (%x): count=%d\n",
		XrmQuarkToString(pptr->fileName),
		(int)pptr->pm,
		pptr->count
		);
    fprintf(stderr,"------------\n");
    }
#endif


/* Cleanup last settings:
 * Search the list of pixmaps to find out whether the specified pixmap's 
 * resources are to be freed - which is the case when it was created by
 * changePixmap
 */
static Pixmap 
freeInPixmapCache(dpy,cmap,qFileName)
Display    *dpy;
Colormap    cmap;
XrmQuark    qFileName;
    {
    pixmapCachePtr   pptr, lastPtr = NULL;
    Pixmap          toDestroy = (Pixmap) NULL;

    DBUG_ENTER("freeInPixmapCache");

#ifdef PIXMAPCACHETRACE 
    showPixmapCache("before Free");
#endif

    for (pptr=pixmapCacheRoot;  pptr != NULL; lastPtr=pptr, pptr=pptr->next)
	if (pptr->fileName == qFileName)
	    {
	    pptr->count--;
	    if (pptr->count < 1)
		{

		/* destroy Pixmap and deallocate resources */
		DBUG_PRINT("pixmap",
			   ("deallocating pixmap %s (%x), %d colors", 
			    XrmQuarkToString(pptr->fileName), 
			    pptr->pm,
			    pptr->attribPtr->npixels));

		toDestroy = pptr->pm;
		if (pptr->attribPtr->depth > 1) 
		    XFreeColors(dpy, cmap, 
				pptr->attribPtr->pixels, 
				pptr->attribPtr->npixels, 0);
		if (pptr->mask) 
		    XFreePixmap(dpy,pptr->mask);

		XpmFreeAttributes(pptr->attribPtr);

		if (pptr == pixmapCacheRoot)
		    pixmapCacheRoot = pptr->next;
		else
		    lastPtr->next = pptr->next;
		XtFree((char *)pptr);
		}
	    break;
	    }
    
#ifdef PIXMAPCACHETRACE 
    showPixmapCache("after Free");
#endif
    DBUG_RETURN(toDestroy);
    }


String
xpmErrorReason (xpmReturnCode)
int             xpmReturnCode;
    {
    char *reason;
    
    switch (xpmReturnCode) 
	{
    case XpmColorError: 
	reason = "Color Error"; break;
    case XpmOpenFailed: 
	reason = "Open Failed"; break;
    case XpmFileInvalid: 
	reason = "File Invalid"; break;
    case XpmNoMemory: 
	reason = "No Memory"; break;
    case XpmColorFailed: 
	reason = "Color Failed"; break;
    default:
	reason = "Unknown Reason";
	}
    return reason;
    }

static pixmapCachePtr
getThroughPixmapCache(dpy,fname,qFileName,pixmapReturn)
Display      *dpy;
String        fname;
XrmQuark      qFileName;
Pixmap       *pixmapReturn;
    {
    pixmapCachePtr  pptr;
    char           *fn;
    int             xpmReturnCode,
                    screenNum  = DefaultScreen(dpy);
    unsigned int    depth      = DefaultDepth(dpy, screenNum);
    XpmAttributes  *attribPtr; 
    Pixmap          pixmap,mask;

    DBUG_ENTER("getThroughPixmapCache");
    /* is the pixmap already in the cache? */

    for (pptr = pixmapCacheRoot; pptr != NULL; pptr = pptr->next)
	{
	if (qFileName == pptr->fileName)
	    {
	    DBUG_PRINT("pixmap", ("Pixmap %s (%x) found in cache",
				  fname, pptr->pm));
	    pptr->count ++;
	    DBUG_RETURN(pptr);
	    }
	}

    /* If the new pixmap's filename is None etc, 
     * don't create new entry, ut use shortcut
     */
    if (!strcmp(fname, "None"))
	{
	*pixmapReturn = None;
	DBUG_RETURN((pixmapCachePtr)NULL);
	}
    else 
    if (!strcmp(fname, "Unspecified"))
	{
	*pixmapReturn = XtUnspecifiedPixmap;
	DBUG_RETURN((pixmapCachePtr)NULL);
	}
    else
    if (!strcmp(fname, "ParentRelative"))
	{
	*pixmapReturn = ParentRelative;
	DBUG_RETURN((pixmapCachePtr)NULL);
	}

    /* we have to look for the file */
    if (!(fn = locateBitmap(dpy, fname, True)))
	{
	*pixmapReturn = XtUnspecifiedPixmap;
	DBUG_RETURN((pixmapCachePtr)NULL);
	}
    
    /* Now convert the new Pixmap-File, create a new element of the list 
     * and fill it with information.
     */
    attribPtr = (XpmAttributes *)XtCalloc(sizeof(XpmAttributes), sizeof(char));
    attribPtr->valuemask = XpmReturnPixels | XpmDepth | XpmReturnInfos;
    attribPtr->depth     = depth;
    /* fprintf(stderr, "changePixmap: calling xpmreadfile\n"); */
    xpmReturnCode = XpmReadFileToPixmap(dpy, RootWindow(dpy, screenNum), 
					fn, &pixmap, &mask, attribPtr); 
    /* fprintf(stderr, "changePixmap: xpmreadfile returned %d\n",returnVal); */
    if (fn != fname) 
	XtFree(fn);

    if (xpmReturnCode == XpmSuccess)
	{
	pptr = (pixmapCachePtr)XtMalloc(sizeof(pixmapCache));
	pptr->next      = pixmapCacheRoot;
	pptr->pm        = pixmap;
	pptr->mask      = mask;
	pptr->count     = 1;
	pptr->fileName  = qFileName;
	pptr->attribPtr = attribPtr;
	pixmapCacheRoot = pptr;
	DBUG_PRINT("pixmap", ("%d colorcells are used for new pixmap %s (%x)", 
		    pptr->attribPtr->npixels, fname, pixmap));
	DBUG_RETURN(pptr);
	}
    else
	{
	char errorBuffer[200];
	sprintf(errorBuffer, 
		"Couldn't convert '%s' to pixmap (%s)", 
		fname,xpmErrorReason (xpmReturnCode));
	Tcl_SetResult(wafeInterpreter, errorBuffer, TCL_VOLATILE);
	XpmFreeAttributes(attribPtr);

	*pixmapReturn = XtUnspecifiedPixmap;
	DBUG_RETURN((pixmapCachePtr)NULL);

	}
    }     


void
freeXpmList(ptr)
char *ptr;
    {
    xpmListPtr p = (xpmListPtr)ptr, nextPtr;
    Pixmap     toDestroy;

    while (p) 
	{
	nextPtr = p->next;
	if ((toDestroy = freeInPixmapCache(p->dpy,p->cmap,p->fileName)))
	    XFreePixmap(p->dpy, toDestroy); 
	XtFree((char *)p);
	p = nextPtr;
	}
    }


static int
changePixmap(w,resource,fname)
Widget     w;
String     resource;
String     fname;
    {
    Colormap         cmap;
    Pixmap           toDestroy = (Pixmap)NULL,
                     pixmapReturn;
    Display         *dpy       = XtDisplay(w);
    XrmQuark         qResName  = XrmStringToQuark(resource), 
                     qFileName = XrmStringToQuark(fname);
    MMattribListPtr *al        = wafeMMgetAttribList(w,True);
    xpmListPtr       pixPtr    = (xpmListPtr)wafeMMgetValue(al, qxpmList),
                     tpixPtr;
    pixmapCachePtr   pptr;    
    Boolean          isConstraint;

    if (!wafeGetQTypeOfAttribute(XtClass(w),ParentWidget(w),qResName,
				 &isConstraint))
	return wafeSetError("widget %s has no resource %s",
			    wafeWidgetToName(w), resource, NULL);

    for (tpixPtr = pixPtr; tpixPtr != NULL; tpixPtr = tpixPtr->next)
	if (qResName == tpixPtr->resName) /* it has already a xpm */
	    break;
    
    XtVaGetValues(w, XtNcolormap, &cmap, NULL);

    if (tpixPtr)
	{
	/* we have already a xpm for this widget & resource */
	if (qFileName == tpixPtr->fileName)
	    {
	    DBUG_PRINT("pixmap", ("You are about to set the same pixmap!"));
	    return TCL_OK;
	    }
	else
	    toDestroy = freeInPixmapCache(dpy,cmap,tpixPtr->fileName);
	}
    else
	{
	/* we have no xpm for this widget & resource */
	tpixPtr = (xpmListPtr) XtMalloc(sizeof(xpmList));
	tpixPtr->next     = pixPtr;
	tpixPtr->resName  = qResName;
	tpixPtr->dpy      = dpy;
	tpixPtr->cmap     = cmap;
	if (!pixPtr) 
	    wafeMMreplace(al, qxpmList, (char *)tpixPtr, freeXpmList);
	}
    tpixPtr->fileName = qFileName;    

#ifdef PIXMAPCACHETRACE 
    showPixmapCache("Before");
#endif
    /* now try to obtain the pixmap by using the pixmap cache */
    if ((pptr = getThroughPixmapCache(dpy,fname,qFileName,&pixmapReturn))) 
	setPixmap(w, resource, qResName, pptr->pm, pptr->mask, 
		  pptr->attribPtr->width, pptr->attribPtr->height);
    else 
	setPixmap(w, resource, qResName, pixmapReturn, (Pixmap)NULL, 0, 0);

    if (toDestroy) 
	{
	DBUG_PRINT("pixmap", ("old pixmap (%x) will be destroyed now", 
			      (int)toDestroy));
	XFreePixmap(dpy, toDestroy); 
	}

#ifdef PIXMAPCACHETRACE 
    showPixmapCache("After");
#endif
    if (wafeInterpreter->result && *(wafeInterpreter->result)) 
      return TCL_ERROR;
    else 
      return TCL_OK;
    }     
#endif /* XPM */



#define	newDone(type, value) \
	{							\
	    if (toVal->addr != NULL) {				\
		if (toVal->size < sizeof(type)) {		\
		    toVal->size = sizeof(type);			\
		    return False;				\
		}						\
		*(type*)(toVal->addr) = (value);		\
	    }							\
	    else {						\
		static type static_val;				\
		static_val = (value);				\
		toVal->addr = (XtPointer)&static_val;		\
	    }							\
	    toVal->size = sizeof(type);				\
	    return True;					\
	}
               

Boolean
CvtStringToPixmapOrBitmap(dpy, args, num_args, fromVal, toVal,
		   converter_data)
Display *dpy;
XrmValuePtr args;
Cardinal *num_args;
XrmValuePtr fromVal;
XrmValuePtr toVal;
XtPointer *converter_data;
    {
    static Pixmap    pixmap;               /* static for cvt magic */
    String           name;
    Screen          *screen;
    int              screenNum;
    String           fn = NULL;
    unsigned int     width, height;
    int              xhot, yhot;
    unsigned char   *data;
    int              returnValue;
    Boolean          toPixmap = *num_args>1;
#ifdef XPM
    Pixmap           mask;
    Window           coreWin;
    XpmAttributes    attrib;
#endif

    pixmap = (Pixmap) NULL;
    name   = (String) fromVal->addr;
/*
    fprintf(stderr,"i am converting <%s> to %s\n",   
	  name, toPixmap ? "Pixmap" : "Bitmap");
 */
    screen = DefaultScreenOfDisplay(dpy);
    screenNum = DefaultScreen(dpy);
    
    if (strcmp(name, "None") == 0) 
        {
        pixmap = None;
        newDone(Pixmap,pixmap);
        }

    if (strcmp(name, "ParentRelative") == 0 && toPixmap) 
        {
        pixmap = ParentRelative;
        newDone(Pixmap,pixmap);
        }

    if (strcmp(name, "Unspecified") == 0 && toPixmap) 
        {
        pixmap = XtUnspecifiedPixmap;
        newDone(Pixmap,pixmap);
        }

    if (!(fn = locateBitmap(dpy, name, toPixmap)))
	return False;
    /* we have a valid filename fn */

    /* try to read file as bitmap file... */
    if (XmuReadBitmapDataFromFile(fn, &width, &height, &data,
				      &xhot, &yhot) == BitmapSuccess)
	{
	pixmap = XCreatePixmapFromBitmapData(dpy,
			RootWindowOfScreen(screen),
			(char *) data, width, height, 1, 0, 
			toPixmap?DefaultDepth(dpy, DefaultScreen(dpy)):1);
            /* in 0.95 we had:   DefaultDepth(dpy, DefaultScreen(dpy)));*/

	XFree((char *)data);

	if (name != fn) XtFree(fn);
	newDone(Pixmap,pixmap);
	}

#ifdef XPM    
    attrib.valuemask = XpmReturnPixels | XpmDepth | XpmReturnInfos;
    attrib.depth = DefaultDepthOfScreen(DefaultScreenOfDisplay(dpy));

    if ((returnValue = XpmReadFileToPixmap(dpy,RootWindow(dpy,screenNum),
					   fn, &pixmap, &mask, &attrib))
	!= XpmSuccess)
	{
	wafeWarn("convertPixmap", "Couldn't convert '%s' to pixmap (%s)", 
		fn, xpmErrorReason (returnValue), NULL);
#else
	wafeWarn("convertPixmap", "No XPM configured", NULL,NULL,NULL);
#endif
	XtStringConversionWarning(name, toPixmap ? "Pixmap" : "Bitmap");

	if (name != fn) XtFree(fn);
	return False;
#ifdef XPM
	}
    else 
	{
/*
	fprintf(stderr,"pixmap=%p, width=%d, height=%d, addr=%p\n",pixmap,
		attrib.width,attrib.height,toVal->addr);
*/
	coreWin = *((Window *) args[0].addr);
	if (wafeCurrentAttrib != qiconPixmap)
	    {
	    /* if toVal->addr is set we assume that the value comes
	       from a resource file, in which case we can't assume that
	       the core fields of the widget are already initialized; 
	       coreWin will be wrong; Wafe never sets toVal->addr */
	    if (coreWin && !toVal->addr) 
		{
		XShapeCombineMask(dpy, coreWin, ShapeBounding,
				  0, 0, mask, ShapeSet);
		/* fprintf(stderr,"converter set mask\n");*/
		}
	    }
	else 
	if (wafeCurrentWidget)
	    XtVaSetValues(wafeCurrentWidget,XtNiconMask,mask,NULL);
	
	if (name != fn) XtFree(fn);
	newDone(Pixmap,pixmap);
	}
#endif /* XPM */
    }

/* to keep knowledge about xpmConvertArgsPixmap etc local ...
 */
void
wafeRegisterXpmTypeConverter(resourceType, toPixmap)
char * resourceType;
Boolean toPixmap;
    { 
    if (toPixmap)
	XtSetTypeConverter(XtRString, 
			   resourceType, 
			   (XtTypeConverter)CvtStringToPixmapOrBitmap, 
			   xpmConvertArgsPixmap, 
			   2,
			   XtCacheByDisplay,
			   NULL);
    else
	XtSetTypeConverter(XtRString, 
			   resourceType, 
			   (XtTypeConverter)CvtStringToPixmapOrBitmap, 
			   xpmConvertArgsBitmap, 
			   1, 
			   XtCacheByDisplay, 
			   NULL);
    }

