/*
 * Copyright (C) 1992 by Gustaf Neumann, Stefan Nusser
 *
 *      Wirtschaftsuniversitaet Wien,
 *      Abteilung fuer Wirtschaftsinformatik
 *      Augasse 2-6,
 *      A-1090 Vienna, Austria
 *      neumann@@wu-wien.ac.at, nusser@@wu-wien.ac.at
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided
 * that the above copyright notice appears in all copies and that both that
 * copyright notice and this permission notice appear in all supporting
 * documentation.  This software is provided "as is" without expressed or
 * implied warranty.
 *
 * Date: Mon, Apr 13 1992
 * Author: Stefan Nusser, Gustaf Neumann
 * Version: 0.9
 */

/*
 *             ACTIONSCB.C
 *
 *             This file contains all commands dealing with actions,
 *             callbacks, accelerators, etc and all related functions:
 *
 *             wafePositionCursorCallbackProc
 *             wafePositionCallbackProc
 *             wafeExecActionProc
 */

#define ACTIONSCB_C

#include "wafe.h"

#ifdef ATHENA
#include<X11/Xaw/AsciiText.h>
#ifdef XEDW
#include "Xedw/XedwList.h"
#endif
#endif


/*
 * Additionally, we need the following handler procedures, which are located in the
 * files list.c and scrollbar.c.
 */


#ifdef XEDW
extern void edwListCallbackProc(
#if NeedFunctionPrototypes
     Widget, XtPointer, XtPointer
#endif
);
#endif


void
wafeActionPercentcode(inChar,outputPtr,event,w)
char    inChar;
char  **outputPtr;
XEvent *event;
Widget  w;
    {
    int    i;
    KeySym dummy;
    char   buffer[50];
    char  *ptr;
    switch (inChar)
	{
    case 't':
	switch (event->type)
	    {
	case ButtonPress:
	    strcpy(*outputPtr, "ButtonPress");
	    break;

	case ButtonRelease:
	    strcpy(*outputPtr, "ButtonRelease");
	    break;

	case MotionNotify:
	    strcpy(*outputPtr, "MotionNotify");
	    break;

	case KeyPress:
	    strcpy(*outputPtr, "KeyPress");
	    break;

	case KeyRelease:
	    strcpy(*outputPtr, "KeyRelease");
	    break;

	case EnterNotify:
	    strcpy(*outputPtr, "EnterNotify");
	    break;

	case LeaveNotify:
	    strcpy(*outputPtr, "LeaveNotify");
	    break;

	case ClientMessage:
	    strcpy(*outputPtr, "ClientMessage");
	    break;

	default:
	    strcpy(*outputPtr, "Unknown");
	    break;
	    }
	break;

    case 'w':
	strcpy(*outputPtr, XtName(w));
	break;

    case 'W':
	sprintf(*outputPtr, "%ld", (long)w);
	break;

    case 'x':
	sprintf(*outputPtr, "%d", event->xbutton.x);
	break;

    case 'y':
	sprintf(*outputPtr, "%d", event->xbutton.y);
	break;

    case 'X':
	sprintf(*outputPtr, "%d", event->xbutton.x_root);
	break;

    case 'Y':
	sprintf(*outputPtr, "%d", event->xbutton.y_root);
	break;

    case 'a':
	if (event->type == KeyPress || event->type == KeyRelease)
	    {
	    i = XLookupString((XKeyEvent *)event,
			      buffer, 50, &dummy, NULL);
	    *(buffer+i) = '\0';
	    wafeEscapedStrcpy(*outputPtr,buffer);
	    break;
	    }
	
    case 'b':
	if (event->type == ButtonPress || event->type == ButtonRelease)
	    {
	    sprintf(*outputPtr, "%d", event->xbutton.button);
	    break;
	    }

    case 'k':
	if (event->type == KeyPress || event->type == KeyRelease)
	    {
	    sprintf(*outputPtr, "%d", event->xkey.keycode);
	    break;
	    }

    case 'p':
	if (event->type == ClientMessage)
	    {
	    char *p =
		XGetAtomName(((XClientMessageEvent*)event)->display,
			     ((XClientMessageEvent*)event)->data.l[0]);
	    if (!p) p = "UNKNOWN";
	    strcpy(*outputPtr, p);
	    break;
	    }

    case 's':
	if (event->type == KeyPress || event->type == KeyRelease)
	    {
	    XLookupString((XKeyEvent *)event, buffer, 50,
			  &dummy, NULL);
	    ptr = XKeysymToString(dummy);
	    strcpy(*outputPtr, ptr);
	    break;
	    }
    case 'S':
	if (event->type == ButtonPress || event->type == ButtonRelease ||
	    event->type == KeyPress || event->type == KeyRelease ||
	    event->type == MotionNotify
	    )
	    {
	    sprintf(*outputPtr, "%d", event->xbutton.state);
	    break;
	    }


    default:
	ptr = *outputPtr;
	*ptr++ = '%';
	if (inChar != '%') 
	    *ptr++ = inChar;
	*ptr = '\0';
	break;
	}
    }



void
wafeExecActionProc(w, event, argv, argc)
Widget     w;
XEvent    *event;
char     **argv;
Cardinal  *argc;
    {
    char   assembled[1024];        /* Concat the arguments */
    char   command[1024];          /* Do % substitution    */
    int    i;
    char  *input = assembled;
    char  *output = command;

    DBUG_ENTER("execActionProc");

    wafeCurrentEvent = event;
    assembled[0] = '\0';

    for (i = 0; i < *argc; i++)
	{
	strcat(assembled, argv[i]);
	strcat(assembled, " ");
	}

    DBUG_PRINT("action", ("Assembled command: %s", assembled));

/*    fprintf(stderr,"event type=%d\n",event->type);*/

    for (; *input != '\0'; input++)
	{
	if (*input == '%')
	    {
	    wafeActionPercentcode(*(++input),&output,event,w);
	    output += strlen(output);
	    }
	else
	    *output++ = *input;
	}

    *output = '\0';

    DBUG_PRINT("action", ("command:<<%s>>", command));
    (void) wafeEval(wafeInterpreter, command, "execActionProc");
    wafeCurrentEvent = NULL;
    DBUG_VOID_RETURN;
    }



typedef struct {
        Widget widget;
        int xoffset;
        int yoffset;
} widgetAndOffset;

#define gt0(a) (((a) > 0) ? (a) : 0)

void
wafePositionCallbackProc(w, clientData, callData)
Widget     w;
XtPointer  clientData, callData;
     {
     Position  x,y, xRoot,yRoot, X,Y;
     widgetAndOffset *wao;

     DBUG_ENTER("positionCallbackProc");

     wao = (widgetAndOffset *)clientData;
     XtVaGetValues(wao->widget,
                   XtNx, &x,
                   XtNy, &y,
                   NULL);
     XtTranslateCoords(wafeTopLevel, x, y, &xRoot, &yRoot);
     X = xRoot+(wao->xoffset);
     Y = yRoot+(wao->yoffset);
     XtVaSetValues(w, XtNx, gt0(X), XtNy, gt0(Y), NULL);

     DBUG_VOID_RETURN;
     }


void
wafePositionCursorCallbackProc(w, clientData, callData)
Widget     w;
XtPointer  clientData, callData;
     {
     Window root, child;
     int  x, y, win_x,win_y;
     unsigned int mask;
     int offset = (int)clientData;
     Position X,Y;

     DBUG_ENTER("positionCursorCallbackProc");

     (void) XQueryPointer(XtDisplay(w), XtWindow(wafeTopLevel),
                         &root, &child,
                         &x, &y, &win_x, &win_y,
                         &mask);

     if (offset)
         {
	 X = x-offset;
	 Y = y-offset;
	 XtVaSetValues(w, XtNx, gt0(X), XtNy, gt0(Y), NULL);
         }
      else
	 {
	 Boolean mappedWhenManaged;
	 Dimension width, height;
	 Screen *screen = XtScreen(w);

	 XtVaGetValues(w, XtNmappedWhenManaged, &mappedWhenManaged, NULL);
	 if (mappedWhenManaged)
	     XtVaSetValues(w, XtNmappedWhenManaged, False, NULL);

	 XtRealizeWidget(w);
	 XtVaGetValues(w, XtNwidth, &width,
                          XtNheight, &height,
                          NULL);
	 X = x-width/2;
	 Y = y-height/2;

	 if ((int)(X+width) > WidthOfScreen(screen))
	   X = WidthOfScreen(screen) - width;
	 if ((int)(Y+height) > HeightOfScreen(screen))
	   Y = HeightOfScreen(screen) - height;

	 if (X < 0) X = 0;
	 if (Y < 0) Y = 0;

	 XtVaSetValues(w, XtNx, X, XtNy, Y,
		       XtNmappedWhenManaged, mappedWhenManaged,
		       NULL);
	 }

     DBUG_VOID_RETURN;
     }

/*
 *  FUNCTION: wafeCallbackCmd
 *  Arguments:
 *            Widget - Widget whose attribute is to be set
 *            char * - Name of attribute
 *            proc   - Name of callback procedure to use
 *            arg    - clientData argument
 *
 *  This function is called by the genereated callback procedure (XtGen) and
 *  cares for the special callData handling with list and scrollbar Widgets as
 *  well as for the clientData argument of the XtPopdown callback (a so
 *  called XtPopdownID).
 */

void
wafeCallbackCmd(argc, argv, w, proc)
int            argc;
char         **argv;
Widget         w;
XtCallbackProc proc;
    {
    Widget pop;
    String cbAttribute = argv[2];
    String arg = argv[4];

    if (proc == wafePositionCursorCallbackProc)   /* Additional argument is offset... */
	{
	int offset;

	if (!sscanf(arg, "%d", &offset))
	    {
	    wafeConvError(argc, argv, 4, NULL, "int");
	    return;
	    }

	XtAddCallback(w, cbAttribute, wafePositionCursorCallbackProc,
		      (XtPointer)offset);
	}
    else
    if (proc == wafePositionCallbackProc)   /* Additional argument is widget/offset */
	{
	widgetAndOffset *wao;
	char *colon, *slash;

	wao = (widgetAndOffset *)XtMalloc(sizeof(widgetAndOffset));
	if ((colon = (char*)strrchr(arg,':')))
	    {
	    *colon = '\0'; colon ++;
	    if ((slash = (char*)strrchr(colon,'/')))
		{
		*slash = '\0'; slash ++;
		if (!sscanf(slash, "%d", &(wao->yoffset)))
		    {
		    wafeConvError(argc, argv, 4, NULL, "Widget:xoffset/yoffset");
		    return;
		    }
		}

	    if (!sscanf(colon, "%d", &(wao->xoffset)))
		{
		wafeConvError(argc, argv, 4,NULL, "Widget:xoffset/yoffset");
		return;
		}
	    if (!slash) wao->yoffset = wao->xoffset;
	    }
	else
	    {
	    wao->xoffset = 50;
	    wao->yoffset = 50;
	    }
	if (!(wao->widget = name2Widget(arg)))
	    {
	    wafeConvError(argc, argv, 4,NULL, "Widget:xoffset/yoffset");
	    return;
	    }

	XtAddCallback(w, cbAttribute, wafePositionCallbackProc, (XtPointer)wao);
	}
    else
    if (proc == XtCallbackPopdown)   /* Build up XtPopdownID... */
	{
	XtPopdownID      pdPtr;
	pdPtr = (XtPopdownID)XtMalloc(sizeof(XtPopdownIDRec));

	if (!(pdPtr->shell_widget = name2Widget(strtok(arg, " "))))
	    {
	    wafeConvError(argc, argv, 4,NULL, "Widget");
	    return;
	    }

	if (!(pdPtr->enable_widget = name2Widget(strtok(NULL, " "))))
	    {
	    wafeConvError(argc, argv, 4,NULL, "Widget");
	    return;
	    }
	XtAddCallback(w, cbAttribute, XtCallbackPopdown, pdPtr);
	}
    else if (proc == wafeExecCallbackProc)
        {
	XtAddCallback(w, cbAttribute, proc, arg);
        }
    else
	{
	if (!(pop = name2Widget(arg)))  /* For all other callbacks: arg is a Widget */
	    {
	    wafeConvError(argc, argv, 4,NULL, "Widget");
	    return;
	    }
	XtAddCallback(w, cbAttribute, proc, (XtPointer)pop);
	}
    return;
    }


