/* Copyright (C) 1992 by Gustaf Neumann, Stefan Nusser

 *      Wirtschaftsuniversitaet Wien, 
 *      Abteilung fuer Wirtschaftsinformatik
 *      Augasse 2-6, 
 *      A-1090 Vienna, Austria
 *      neumann@wu-wien.ac.at, nusser@wu-wien.ac.at

 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided
 * that the above copyright notice appears in all copies and that both that
 * copyright notice and this permission notice appear in all supporting
 * documentation.  This software is provided "as is" without expressed or
 * implied warranty.

 * Creation: Sun Jul 31 13:33:30 EDT 1994 on mohegan
 * Author: genc
 * Version: 1


 */
#define XMGRAPH_C
#include <wafe.h>
typedef int TCL_RETURN_CODE;
#ifdef XMGRAPH

#include <stdio.h>
#include <X11/StringDefs.h>
#define ARC(w) (XmArcWidget)(w)

#include <Graph.h>
#include <Arc.h>
/* 
 * void
 * XmArcGetPos
 * 	in: ARC(XmArcWidget)			# name of arc Widget
 * 	out: Position				# out: x1
 * 	out: Position				# out: y1
 * 	out: Position				# out: x2
 * 	out: Position				# out: y2
 */

static int 
cmd_XmArcGetPos(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     Position localVar2;
     Position localVar3;
     Position localVar4;
     Position localVar5;
     char conversionBuffer[100];

     DBUG_ENTER(argv[0]);  

     if (argc != 6) 
	 {
	 wafeArgcError(argv[0],"",5,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmArcWidgetClass,"XmArc")))
         {
         wafeConvError(argv[0],"1",argv[1],"XmArcWidget");
         DBUG_RETURN (TCL_ERROR);
         }

     XmArcGetPos(ARC(localVar1),&localVar2,&localVar3,&localVar4,&localVar5);

     sprintf(conversionBuffer, "%hd", localVar2);

     Tcl_SetVar(wafeInterpreter, argv[2], conversionBuffer, 0);

     sprintf(conversionBuffer, "%hd", localVar3);

     Tcl_SetVar(wafeInterpreter, argv[3], conversionBuffer, 0);

     sprintf(conversionBuffer, "%hd", localVar4);

     Tcl_SetVar(wafeInterpreter, argv[4], conversionBuffer, 0);

     sprintf(conversionBuffer, "%hd", localVar5);

     Tcl_SetVar(wafeInterpreter, argv[5], conversionBuffer, 0);

     DBUG_RETURN (TCL_OK);
     }     


#include <Graph.h>
/* 
 * void
 * XmGraphInsertRoots
 * 	in: XmGraphWidget   # XmGraphWidget
 * 	in: [Widget]        # List of Widgets
 *         const: argc-2
 */

static int 
cmd_XmGraphInsertRoots(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     Widget * localVar2;

     DBUG_ENTER(argv[0]);  

     if (argc < 3) 
	 {
	 wafeArgcError(argv[0],"at least ",2,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmGraphWidgetClass,"XmGraph")))
         {
         wafeConvError(argv[0],"1",argv[1],"XmGraphWidget");
         DBUG_RETURN (TCL_ERROR);
         }

     {    Widget *ptr;
          argv += 2;
          localVar2 = ptr =
             (Widget *)XtMalloc((argc-2)*sizeof(Widget));

          while (*argv)
             {
             if (!(*ptr =  name2Widget(*argv)))
                 {
                 wafeConvError(argv[0],"2",*argv,"Widget");
                 DBUG_RETURN (TCL_ERROR);
                 }

          ptr ++; argv++;
          }
     }
     XmGraphInsertRoots(localVar1,localVar2,argc-2);
     wafeMMreplace(wafeMMgetAttribList(localVar1,True),WafePermStringToQuark("XmGraphInsertRoots"),(char*)localVar2,XtFree);

     DBUG_RETURN (TCL_OK);
     }     


#else
#endif

void
wafeInitialize_XmGrGen()
{
#ifdef XMGRAPH
 wafeCreateWidgetCommand("XmArc",xmArcWidgetClass,NULL,False);
 wafeCreateWidgetCommand("XmGraph",xmGraphWidgetClass,NULL,False);
 wafeCreateWidgetCommand("XmScrolledGraph",xmGraphWidgetClass,XmCreateScrolledGraph,False);
#ifdef XMGRAPH
 Tcl_SetVar(wafeInterpreter,"PACKAGES","XMGRAPH",TCL_GLOBAL_ONLY|TCL_APPEND_VALUE|TCL_LIST_ELEMENT);
#endif
 Tcl_CreateCommand(wafeInterpreter, "XmArcGetPos", cmd_XmArcGetPos, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XmGraphInsertRoots", cmd_XmGraphInsertRoots, NULL, NULL);

#else
#endif
}
