/* Copyright (C) 1992 by Gustaf Neumann, Stefan Nusser

 *      Wirtschaftsuniversitaet Wien, 
 *      Abteilung fuer Wirtschaftsinformatik
 *      Augasse 2-6, 
 *      A-1090 Vienna, Austria
 *      neumann@wu-wien.ac.at, nusser@wu-wien.ac.at

 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided
 * that the above copyright notice appears in all copies and that both that
 * copyright notice and this permission notice appear in all supporting
 * documentation.  This software is provided "as is" without expressed or
 * implied warranty.

 * Creation: Sun Jul 31 13:33:22 EDT 1994 on mohegan
 * Author: genc
 * Version: 1


 */
#define ATHENA_C
#include <wafe.h>
typedef int TCL_RETURN_CODE;
#ifdef ATHENA

/* 
 * ******* begin required file <athena.inc> *******
 */
/* treat me like a -*- c -*- program */

#define MAX_ITEM_LENGTH 200

/* KLUDGE KLUDGE KLUDGE for callbacks provided via resource mechanisms */
#define setQuark(resName,quark) \
    XtVaGetValues(newWidget, (resName), &callbackList, NULL); \
    if (callbackList && \
	callbackList->callback == (XtCallbackProc)wafeExecCallbackProc) \
	*(XrmQuark *)callbackList->closure = (quark)

XrmQuark qcallback;
XrmQuark qjumpProc;
XrmQuark qscrollProc;



/****************************************************************************
 *    FUNCTION:  name2Sink, name2Source
 *                                                                          
 *    Arguments: string containing an instance's name
 *    Returns:   source/sink widget of named text widget
 *                                                                          
 *****************************************************************************/

static Widget 
name2Sink(string)
char * string;
    {
    Widget localVar1, sink = NULL;

    if (!(localVar1 = name2Widget(string)))
	{
	wafeConvError("name2Sink","1",string,"Widget");
	return(NULL);
	}

    XtVaGetValues(localVar1, XtNtextSink, &sink, NULL);
    return(sink);
    }

/*
static Widget 
name2Source(string)
char * string;
    {
    Widget localVar1, source = NULL;

    if (!(localVar1 = name2Widget(string)))
	{
	wafeConvError("name2Source","1",string,"Widget");
	return(NULL);
	}

    XtVaGetValues(localVar1, XtNtextSource, &source, NULL);
    return(source);
    }
*/



/************** list widget support routines ******/
#include <X11/Xaw/List.h>

static int
listChange(w, widgetName, nitems, longest, resize, argc, argv)
Widget     w;
String     widgetName;
int        nitems;
int        longest;
int        resize;
int           argc;
char        **argv;
    {
    FILE    *fp;
    int      i, size=0;
    char   **list, **count, *offset;
    char     buffer [MAX_ITEM_LENGTH];
    char    *procName = "listChange";
    
    DBUG_ENTER(procName);
    
    if (!strcmp(argv[0], "List"))
	{
	  if (argc != 2)
	      {
	      wafeWarn(procName, "wrong number of arguments",
		       NULL,NULL,NULL);
	      DBUG_RETURN(TCL_ERROR);
	      }

	  if (Tcl_SplitList(wafeInterpreter,argv[1], &nitems, &list) != TCL_OK)
	      {
	      wafeWarn(procName, wafeInterpreter->result,
		       NULL,NULL,NULL);
	      DBUG_RETURN(TCL_ERROR);
	      }
	  }
    else 
    if (!strcmp(argv[0], "Arg"))
	{
        for (i = 1; i < argc; i++) 
	    size += strlen(argv[i])+1;
	
	list = count = (char **)XtMalloc((argc)*sizeof(char *)+size); 
	offset = (char *)list + (argc)*sizeof(char *);

	for (i = 1; i < argc; i++)
	    {
	    *count = offset;
	    strcpy(offset,argv[i]);
	    offset += strlen(argv[i])+1;
	    count++;
	    }

	*count = NULL;
	}
    else
    if (!strcmp(argv[0], "File"))
	{
	char **tmpList, **saveStart;

	if (argc != 2)
	    {
	    wafeWarn(procName, "wrong number of arguments",
		       NULL,NULL,NULL);
	    DBUG_RETURN(TCL_ERROR);
	    }

	if (!(fp = fopen(argv[1], "r")))
	    {
	    wafeWarn(procName, "Couldn't open File %s",
		       argv[1],NULL,NULL);
	    DBUG_RETURN(TCL_ERROR);
	    }

	saveStart = tmpList = count = (char **)XtMalloc(10*sizeof(char *));
	i = 0;

	while (fgets(buffer, 200, fp))
	    {
	    *count = XtNewString(buffer);
	    size += strlen(buffer)+1;
	    *(*count + strlen(buffer)-1) = '\0';
	    count++; i++;
	    if (!(i % 10))
		{
		DBUG_PRINT("list", ("Realloc"));
		saveStart = tmpList = (char**)XtRealloc((char *)tmpList,
						(i + 10)* sizeof(char *));
		count = tmpList + i;
		}
	    }
	*count = NULL;

	/* make it the list a single memory chunk to be 
         * compatible with the rest 
         */
	list = count = (char **)XtMalloc((i+1)*sizeof(char *)+size); 
	offset = (char *)list + (i+1)*sizeof(char *);

	while (*tmpList)
	    {
	    *count = offset;
	    strcpy(offset,*tmpList);
	    offset += strlen(*tmpList)+1;
	    XtFree(*tmpList);
	    tmpList++;
	    count++;
	    }
	*count = NULL;

        XtFree((char*)saveStart);
	}

    XawListChange(w, list, nitems, longest, resize);
    wafeMMreplace(wafeMMgetAttribList(w,True), qPointer, (char *)list,XtFree);

    DBUG_RETURN(TCL_OK);
    }

  
static void
listAppend(list, argc, argv)
Widget        list;
int           argc;
char        **argv;
    {
    char   **srcPtr, **trgtPtr;
    char   **newArray, **oldArray;
    int      nitems = 0;
    int      count;
    Boolean  resize;
    DBUG_ENTER("listAppend");
 
    XtVaGetValues(list, XtNlist, &oldArray, NULL);
    XtVaGetValues(list, XtNresize, &resize, NULL);
     
    for (srcPtr = oldArray; *srcPtr != NULL; srcPtr++)
	{
	nitems++;
	DBUG_PRINT("list", ("Checking %d", nitems));
	}

    newArray = (char **)XtMalloc((nitems * sizeof(char*)) + argc + 1);

    for(srcPtr = oldArray, trgtPtr = newArray; 
	*srcPtr != NULL; 
	srcPtr++, trgtPtr++)
	{          
	*trgtPtr = XtNewString(*srcPtr);
	DBUG_PRINT("list", ("Copied: >%s<\n", *trgtPtr));
	XtFree(*srcPtr);
	}

    XtFree((char *)oldArray);

    for (count = 0; count < argc; count++)
	{
	*trgtPtr = XtNewString(argv[count]);
	DBUG_PRINT("list", ("Added: >%s<", *trgtPtr));
	trgtPtr++;
	}

    *trgtPtr = NULL;

    XawListChange(list, newArray, 0, 0, resize);
    }


static Widget
listCreate(father, name, args, numArgs)
Widget   father;
char     *name;
ArgList  args;
Cardinal numArgs;
    {
    XtCallbackList callbackList = NULL;
    Widget newWidget = XtCreateWidget(name, listWidgetClass, 
				      father, args, numArgs);

    setQuark("callback",qcallback);

    return(newWidget);
    }

/******************** strip chart specific code ***************/
#include <X11/Xaw/StripChart.h>

typedef struct _scInfo
     {
     double            value;
     Widget            widget;
     struct _scInfo   *next;
     } scInfo, *scInfoPtr;

static scInfoPtr scBegin = NULL;

static void 
stripChartSet(sCWidget, value)
Widget  sCWidget;
double  value;
     {
     scInfoPtr   countPtr;

     if (!scBegin)         /* No Stripchart widgets exists yet*/
          {
	  wafeWarn("scSet", "No stripChart widget exists yet",
		   NULL,NULL,NULL);
          return;
          }

     for (countPtr = scBegin; 
          countPtr->widget != sCWidget && countPtr->next != NULL;
          countPtr = countPtr->next);

     if ((countPtr->next == NULL) && countPtr->widget != sCWidget)
          {
	  wafeWarn("scSet", "stripChart widget %s unknown", 
		   XtName(sCWidget),NULL,NULL);
          return;
          }

     DBUG_PRINT("sc",("Setting = %s to %f\n", 
		      XtName(countPtr->widget),value));

     countPtr->value = value;
     }


static void
scQueryProc(w, clientData, value)
Widget    w;
XtPointer clientData;
XtPointer value;
     {
     scInfoPtr   countPtr;

     DBUG_ENTER("Query");

     for (countPtr = scBegin; countPtr->widget != w;
          countPtr = countPtr->next);

     DBUG_PRINT("sc",("Name = %s, value = %f", 
		      XtName(countPtr->widget), countPtr->value));
/*
      fprintf(stderr,"float = %f\n",countPtr->value);
 */
     *((double*)value) = countPtr->value;

     DBUG_VOID_RETURN;
     }

static Widget
stripChartCreate(father, name, args, numArgs)
Widget   father;
char     *name;
ArgList  args;
Cardinal numArgs;
    {
    Widget newWidget;
    
    scInfoPtr  countPtr = (scInfoPtr)XtNew(scInfo);
    countPtr->next   = scBegin;
    countPtr->value  = 0.0;  /* default value */
    countPtr->widget = 
      newWidget = 
	XtCreateWidget(name, stripChartWidgetClass, father, args, numArgs);
    scBegin = countPtr;
    XtAddCallback(newWidget, "getValue", scQueryProc, NULL);  

    return(newWidget);
    }


/************** scrollbar widget support routines ******/
#include <X11/Xaw/Scrollbar.h>

static Widget
scrollbarCreate(father, name, args, numArgs)
Widget   father;
char     *name;
ArgList  args;
Cardinal numArgs;
    {
    XtCallbackList callbackList = NULL;
    Widget newWidget = XtCreateWidget(name, scrollbarWidgetClass, 
				      father, args, numArgs);

    setQuark("jumpProc",qjumpProc);
    setQuark("scrollProc",qscrollProc);

    return(newWidget);
    }

#include <X11/Xaw/AsciiText.h>

static Boolean
CvtEditTypeToString(dpy, args, num_args, fromVal, toVal, converterData)
Display   *dpy;
XrmValue  *args;
Cardinal  *num_args;
XrmValue  *fromVal;
XrmValue  *toVal;
XtPointer *converterData;
    {
    if ((XawTextEditType)fromVal->addr == XawtextEdit) 
	{
	toVal->addr = XtNewString("edit");
	toVal->size = 5;
	} 
    else if ((XawTextEditType)fromVal->addr == XawtextRead) 
	{
	toVal->addr = XtNewString("read");
	toVal->size = 5;
	} 
    else if ((XawTextEditType)fromVal->addr == XawtextAppend) 
	{
	toVal->addr = XtNewString("append");
	toVal->size = 7;
	}
    else 
	return False;
    
    return True;
    }

/* 
 * ******* end required file <athena.inc> *******
 */
#include <X11/Xaw/AsciiText.h>
/* 
 * Boolean
 * XawAsciiSave
 * 	in: XawTextGetSource(AsciiTextWidget)	# ascii text wiget
 */

static int 
cmd_XawAsciiSave(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     Boolean returnVar;

     DBUG_ENTER(argv[0]);  

     if (argc != 2) 
	 {
	 wafeArgcError(argv[0],"",1,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],asciiTextWidgetClass,"AsciiText")))
         {
         wafeConvError(argv[0],"1",argv[1],"AsciiTextWidget");
         DBUG_RETURN (TCL_ERROR);
         }

     returnVar = XawAsciiSave(XawTextGetSource(localVar1));

     Tcl_SetResult(comInterpreter, returnVar ? "1" : "0", TCL_STATIC);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * Boolean
 * XawAsciiSaveAsFile
 *         in: XawTextGetSource(AsciiTextWidget)	# ascii text wiget
 *         in: String			        # file name
 */

static int 
cmd_XawAsciiSaveAsFile(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     Boolean returnVar;

     DBUG_ENTER(argv[0]);  

     if (argc != 3) 
	 {
	 wafeArgcError(argv[0],"",2,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],asciiTextWidgetClass,"AsciiText")))
         {
         wafeConvError(argv[0],"1",argv[1],"AsciiTextWidget");
         DBUG_RETURN (TCL_ERROR);
         }

    /* no need to assign  << localVar2 = argv[2] >>  */ 

     returnVar = XawAsciiSaveAsFile(XawTextGetSource(localVar1),argv[2]);

     Tcl_SetResult(comInterpreter, returnVar ? "1" : "0", TCL_STATIC);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * Boolean
 * XawAsciiSourceChanged 
 * 	in: XawTextGetSource(AsciiTextWidget)	# ascii text wiget
 */

static int 
cmd_XawAsciiSourceChanged(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     Boolean returnVar;

     DBUG_ENTER(argv[0]);  

     if (argc != 2) 
	 {
	 wafeArgcError(argv[0],"",1,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],asciiTextWidgetClass,"AsciiText")))
         {
         wafeConvError(argv[0],"1",argv[1],"AsciiTextWidget");
         DBUG_RETURN (TCL_ERROR);
         }

     returnVar = XawAsciiSourceChanged(XawTextGetSource(localVar1));

     Tcl_SetResult(comInterpreter, returnVar ? "1" : "0", TCL_STATIC);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XawAsciiSourceFreeString
 * 	in: XawTextGetSource(AsciiTextWidget)	# ascii text wiget
 */

static int 
cmd_XawAsciiSourceFreeString(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;

     DBUG_ENTER(argv[0]);  

     if (argc != 2) 
	 {
	 wafeArgcError(argv[0],"",1,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],asciiTextWidgetClass,"AsciiText")))
         {
         wafeConvError(argv[0],"1",argv[1],"AsciiTextWidget");
         DBUG_RETURN (TCL_ERROR);
         }

     XawAsciiSourceFreeString(XawTextGetSource(localVar1));

     DBUG_RETURN (TCL_OK);
     }     


#include <X11/Xaw/Box.h>
#include <X11/Xaw/Clock.h>
#include <X11/Xaw/Command.h>
#include <X11/Xaw/Dialog.h>
/* 
 * (String) VString
 * XawDialogGetValueString
 * 	in: DialogWidget		# dialog widget
 */

static int 
cmd_XawDialogGetValueString(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     String returnVar;

     DBUG_ENTER(argv[0]);  

     if (argc != 2) 
	 {
	 wafeArgcError(argv[0],"",1,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],dialogWidgetClass,"Dialog")))
         {
         wafeConvError(argv[0],"1",argv[1],"DialogWidget");
         DBUG_RETURN (TCL_ERROR);
         }

     returnVar = XawDialogGetValueString(localVar1);

     Tcl_SetResult(comInterpreter, returnVar, TCL_VOLATILE);

     DBUG_RETURN (TCL_OK);
     }     


#include <X11/Xaw/Form.h>
/* 
 * void
 * XawFormDoLayout
 * 	in: FormWidget			# form widget
 * 	in: Boolean			# boolean
 */

static int 
cmd_XawFormDoLayout(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     Boolean localVar2;

     DBUG_ENTER(argv[0]);  

     if (argc != 3) 
	 {
	 wafeArgcError(argv[0],"",2,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],formWidgetClass,"Form")))
         {
         wafeConvError(argv[0],"1",argv[1],"FormWidget");
         DBUG_RETURN (TCL_ERROR);
         }

     if (!(wafeGetBoolean(argv[2],&localVar2)))
         {
         wafeConvError(argv[0],"2",argv[2],"Boolean");
         DBUG_RETURN (TCL_ERROR);
         }

     XawFormDoLayout(localVar1,localVar2);

     DBUG_RETURN (TCL_OK);
     }     


#include <X11/Xaw/Grip.h>
#include <X11/Xaw/Label.h>
#include <X11/Xaw/List.h>
/* 
 * void
 * listAppend vulgo XawListAppend
 * 	in: ListWidget			# list widget
 * 	in: [args]			# items
 */

static int 
cmd_XawListAppend(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;

     DBUG_ENTER(argv[0]);  

     if (argc < 3) 
	 {
	 wafeArgcError(argv[0],"at least ",2,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],listWidgetClass,"List")))
         {
         wafeConvError(argv[0],"1",argv[1],"ListWidget");
         DBUG_RETURN (TCL_ERROR);
         }

     argc -= 2;
     listAppend(localVar1,argc,&argv[2]);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * listChange vulgo XawListChange
 * 	in: ListWidget			# list widget
 * 	const: argv[1]
 * 	in: int				# number of items
 * 	in: int				# longest
 * 	in: int				# resize
 * 	in: [args]			# Arg items | File filename
 */

static int 
cmd_XawListChange(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     int localVar2;
     int localVar3;
     int localVar4;

     DBUG_ENTER(argv[0]);  

     if (argc < 6) 
	 {
	 wafeArgcError(argv[0],"at least ",5,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],listWidgetClass,"List")))
         {
         wafeConvError(argv[0],"1",argv[1],"ListWidget");
         DBUG_RETURN (TCL_ERROR);
         }

     if (!(sscanf(argv[2], "%d", &localVar2)))
         {
         wafeConvError(argv[0],"3",argv[2],"int");
         DBUG_RETURN (TCL_ERROR);
         }

     if (!(sscanf(argv[3], "%d", &localVar3)))
         {
         wafeConvError(argv[0],"4",argv[3],"int");
         DBUG_RETURN (TCL_ERROR);
         }

     if (!(sscanf(argv[4], "%d", &localVar4)))
         {
         wafeConvError(argv[0],"5",argv[4],"int");
         DBUG_RETURN (TCL_ERROR);
         }

     argc -= 5;
     listChange(localVar1,argv[1],localVar2,localVar3,localVar4,argc,&argv[5]);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XawListHighlight
 * 	in: ListWidget			# list widget
 * 	in: int				# item number
 */

static int 
cmd_XawListHighlight(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     int localVar2;

     DBUG_ENTER(argv[0]);  

     if (argc != 3) 
	 {
	 wafeArgcError(argv[0],"",2,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],listWidgetClass,"List")))
         {
         wafeConvError(argv[0],"1",argv[1],"ListWidget");
         DBUG_RETURN (TCL_ERROR);
         }

     if (!(sscanf(argv[2], "%d", &localVar2)))
         {
         wafeConvError(argv[0],"2",argv[2],"int");
         DBUG_RETURN (TCL_ERROR);
         }

     XawListHighlight(localVar1,localVar2);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * XawListReturnStruct *
 * XawListShowCurrent
 * 	in: ListWidget			# list widget
 */

static int 
cmd_XawListShowCurrent(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     XawListReturnStruct * returnVar;
     char conversionBuffer[100];

     DBUG_ENTER(argv[0]);  

     if (argc != 2) 
	 {
	 wafeArgcError(argv[0],"",1,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],listWidgetClass,"List")))
         {
         wafeConvError(argv[0],"1",argv[1],"ListWidget");
         DBUG_RETURN (TCL_ERROR);
         }

     returnVar = XawListShowCurrent(localVar1);

     if (returnVar == NULL) { DBUG_RETURN (TCL_ERROR); }
     
     Tcl_SetVar2(wafeInterpreter,"returnVar","string", returnVar->string,0);
     sprintf(conversionBuffer, "%d", returnVar->list_index);

     Tcl_SetVar2(wafeInterpreter,"returnVar","list_index", conversionBuffer,0);
     Tcl_SetResult(comInterpreter, "returnVar", TCL_VOLATILE);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XawListUnhighlight
 * 	in: ListWidget			# list widget
 */

static int 
cmd_XawListUnhighlight(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;

     DBUG_ENTER(argv[0]);  

     if (argc != 2) 
	 {
	 wafeArgcError(argv[0],"",1,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],listWidgetClass,"List")))
         {
         wafeConvError(argv[0],"1",argv[1],"ListWidget");
         DBUG_RETURN (TCL_ERROR);
         }

     XawListUnhighlight(localVar1);

     DBUG_RETURN (TCL_OK);
     }     


#include <X11/Xaw/Logo.h>
#include <X11/Xaw/Mailbox.h>
#include <X11/Xaw/MenuButton.h>
#include <X11/Xaw/Paned.h>
/* 
 * void
 * XawPanedAllowResize
 * 	in: PanedWidget			# paned widget
 * 	in: Boolean			# boolean
 */

static int 
cmd_XawPanedAllowResize(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     Boolean localVar2;

     DBUG_ENTER(argv[0]);  

     if (argc != 3) 
	 {
	 wafeArgcError(argv[0],"",2,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],panedWidgetClass,"Paned")))
         {
         wafeConvError(argv[0],"1",argv[1],"PanedWidget");
         DBUG_RETURN (TCL_ERROR);
         }

     if (!(wafeGetBoolean(argv[2],&localVar2)))
         {
         wafeConvError(argv[0],"2",argv[2],"Boolean");
         DBUG_RETURN (TCL_ERROR);
         }

     XawPanedAllowResize(localVar1,localVar2);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XawPanedGetMinMax
 * 	in: PanedWidget			# paned widget
 * 	out: int			# min
 * 	out: int			# max
 */

static int 
cmd_XawPanedGetMinMax(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     int localVar2;
     int localVar3;
     char conversionBuffer[100];

     DBUG_ENTER(argv[0]);  

     if (argc != 4) 
	 {
	 wafeArgcError(argv[0],"",3,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],panedWidgetClass,"Paned")))
         {
         wafeConvError(argv[0],"1",argv[1],"PanedWidget");
         DBUG_RETURN (TCL_ERROR);
         }

     XawPanedGetMinMax(localVar1,&localVar2,&localVar3);

     sprintf(conversionBuffer, "%d", localVar2);

     Tcl_SetVar(wafeInterpreter, argv[2], conversionBuffer, 0);

     sprintf(conversionBuffer, "%d", localVar3);

     Tcl_SetVar(wafeInterpreter, argv[3], conversionBuffer, 0);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * int
 * XawPanedGetNumSub
 * 	in: PanedWidget			# paned widget
 */

static int 
cmd_XawPanedGetNumSub(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     int returnVar;
     char conversionBuffer[100];

     DBUG_ENTER(argv[0]);  

     if (argc != 2) 
	 {
	 wafeArgcError(argv[0],"",1,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],panedWidgetClass,"Paned")))
         {
         wafeConvError(argv[0],"1",argv[1],"PanedWidget");
         DBUG_RETURN (TCL_ERROR);
         }

     returnVar = XawPanedGetNumSub(localVar1);

     sprintf(conversionBuffer, "%d", returnVar);
     Tcl_SetResult(comInterpreter, conversionBuffer, TCL_VOLATILE);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XawPanedSetMinMax
 * 	in: PanedWidget			# paned widget
 * 	in: int				# min
 * 	in: int				# max
 */

static int 
cmd_XawPanedSetMinMax(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     int localVar2;
     int localVar3;

     DBUG_ENTER(argv[0]);  

     if (argc != 4) 
	 {
	 wafeArgcError(argv[0],"",3,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],panedWidgetClass,"Paned")))
         {
         wafeConvError(argv[0],"1",argv[1],"PanedWidget");
         DBUG_RETURN (TCL_ERROR);
         }

     if (!(sscanf(argv[2], "%d", &localVar2)))
         {
         wafeConvError(argv[0],"2",argv[2],"int");
         DBUG_RETURN (TCL_ERROR);
         }

     if (!(sscanf(argv[3], "%d", &localVar3)))
         {
         wafeConvError(argv[0],"3",argv[3],"int");
         DBUG_RETURN (TCL_ERROR);
         }

     XawPanedSetMinMax(localVar1,localVar2,localVar3);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void 
 * XawPanedSetRefigureMode
 * 	in: PanedWidget			# paned widget
 * 	in: Boolean			# boolean
 */

static int 
cmd_XawPanedSetRefigureMode(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     Boolean localVar2;

     DBUG_ENTER(argv[0]);  

     if (argc != 3) 
	 {
	 wafeArgcError(argv[0],"",2,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],panedWidgetClass,"Paned")))
         {
         wafeConvError(argv[0],"1",argv[1],"PanedWidget");
         DBUG_RETURN (TCL_ERROR);
         }

     if (!(wafeGetBoolean(argv[2],&localVar2)))
         {
         wafeConvError(argv[0],"2",argv[2],"Boolean");
         DBUG_RETURN (TCL_ERROR);
         }

     XawPanedSetRefigureMode(localVar1,localVar2);

     DBUG_RETURN (TCL_OK);
     }     


#include <X11/Xaw/Scrollbar.h>
/* 
 * void
 * XawScrollbarSetThumb
 * 	in: ScrollbarWidget		# scrollbar widget
 * 	in: float			# top
 * 	in: float			# shown
 */

static int 
cmd_XawScrollbarSetThumb(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     float localVar2;
     float localVar3;

     DBUG_ENTER(argv[0]);  

     if (argc != 4) 
	 {
	 wafeArgcError(argv[0],"",3,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],scrollbarWidgetClass,"Scrollbar")))
         {
         wafeConvError(argv[0],"1",argv[1],"ScrollbarWidget");
         DBUG_RETURN (TCL_ERROR);
         }

     if (!(sscanf(argv[2], "%f", &localVar2)))
         {
         wafeConvError(argv[0],"2",argv[2],"float");
         DBUG_RETURN (TCL_ERROR);
         }

     if (!(sscanf(argv[3], "%f", &localVar3)))
         {
         wafeConvError(argv[0],"3",argv[3],"float");
         DBUG_RETURN (TCL_ERROR);
         }

     XawScrollbarSetThumb(localVar1,localVar2,localVar3);

     DBUG_RETURN (TCL_OK);
     }     


#include <X11/Xaw/SimpleMenu.h>
/* 
 * void 
 * XawSimpleMenuClearActiveEntry
 * 	in: SimpleMenuWidget		# widget
 */

static int 
cmd_XawSimpleMenuClearActiveEntry(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;

     DBUG_ENTER(argv[0]);  

     if (argc != 2) 
	 {
	 wafeArgcError(argv[0],"",1,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],simpleMenuWidgetClass,"SimpleMenu")))
         {
         wafeConvError(argv[0],"1",argv[1],"SimpleMenuWidget");
         DBUG_RETURN (TCL_ERROR);
         }

     XawSimpleMenuClearActiveEntry(localVar1);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * WidgetID (WidgetID)
 * XawSimpleMenuGetActiveEntry
 * 	in: SimpleMenuWidget		# widget
 */

static int 
cmd_XawSimpleMenuGetActiveEntry(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     WidgetID returnVar;
     char conversionBuffer[100];

     DBUG_ENTER(argv[0]);  

     if (argc != 2) 
	 {
	 wafeArgcError(argv[0],"",1,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],simpleMenuWidgetClass,"SimpleMenu")))
         {
         wafeConvError(argv[0],"1",argv[1],"SimpleMenuWidget");
         DBUG_RETURN (TCL_ERROR);
         }

     returnVar = (WidgetID) XawSimpleMenuGetActiveEntry(localVar1);

     sprintf(conversionBuffer, "%ld", returnVar);
     Tcl_SetResult(comInterpreter, conversionBuffer, TCL_VOLATILE);

     DBUG_RETURN (TCL_OK);
     }     


#include <X11/Xaw/Sme.h>
#include <X11/Xaw/SmeBSB.h>
#include <X11/Xaw/SmeLine.h>
#include <X11/Xaw/StripChart.h>
/* 
 * void
 * stripChartSet vulgo XawStripChartSet
 * 	in: StripChartWidget		# strip chart widget
 * 	in: double			# value
 */

static int 
cmd_XawStripChartSet(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     double localVar2;

     DBUG_ENTER(argv[0]);  

     if (argc != 3) 
	 {
	 wafeArgcError(argv[0],"",2,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],stripChartWidgetClass,"StripChart")))
         {
         wafeConvError(argv[0],"1",argv[1],"StripChartWidget");
         DBUG_RETURN (TCL_ERROR);
         }

     if (!(sscanf(argv[2], "%lf", &localVar2)))
         {
         wafeConvError(argv[0],"2",argv[2],"double");
         DBUG_RETURN (TCL_ERROR);
         }

     stripChartSet(localVar1,localVar2);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XawTextDisableRedisplay
 * 	in: AsciiTextWidget		# ascii text wiget
 */

static int 
cmd_XawTextDisableRedisplay(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;

     DBUG_ENTER(argv[0]);  

     if (argc != 2) 
	 {
	 wafeArgcError(argv[0],"",1,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],asciiTextWidgetClass,"AsciiText")))
         {
         wafeConvError(argv[0],"1",argv[1],"AsciiTextWidget");
         DBUG_RETURN (TCL_ERROR);
         }

     XawTextDisableRedisplay(localVar1);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XawTextDisplay
 * 	in: AsciiTextWidget		# ascii text wiget
 */

static int 
cmd_XawTextDisplay(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;

     DBUG_ENTER(argv[0]);  

     if (argc != 2) 
	 {
	 wafeArgcError(argv[0],"",1,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],asciiTextWidgetClass,"AsciiText")))
         {
         wafeConvError(argv[0],"1",argv[1],"AsciiTextWidget");
         DBUG_RETURN (TCL_ERROR);
         }

     XawTextDisplay(localVar1);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XawTextDisplayCaret
 * 	in: AsciiTextWidget		# ascii text wiget
 * 	in: Boolean			# boolean
 */

static int 
cmd_XawTextDisplayCaret(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     Boolean localVar2;

     DBUG_ENTER(argv[0]);  

     if (argc != 3) 
	 {
	 wafeArgcError(argv[0],"",2,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],asciiTextWidgetClass,"AsciiText")))
         {
         wafeConvError(argv[0],"1",argv[1],"AsciiTextWidget");
         DBUG_RETURN (TCL_ERROR);
         }

     if (!(wafeGetBoolean(argv[2],&localVar2)))
         {
         wafeConvError(argv[0],"2",argv[2],"Boolean");
         DBUG_RETURN (TCL_ERROR);
         }

     XawTextDisplayCaret(localVar1,localVar2);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XawTextEnableRedisplay
 * 	in: AsciiTextWidget		# ascii text wiget
 */

static int 
cmd_XawTextEnableRedisplay(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;

     DBUG_ENTER(argv[0]);  

     if (argc != 2) 
	 {
	 wafeArgcError(argv[0],"",1,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],asciiTextWidgetClass,"AsciiText")))
         {
         wafeConvError(argv[0],"1",argv[1],"AsciiTextWidget");
         DBUG_RETURN (TCL_ERROR);
         }

     XawTextEnableRedisplay(localVar1);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * XawTextPosition
 * XawTextGetInsertionPoint
 * 	in: AsciiTextWidget		# ascii text wiget
 */

static int 
cmd_XawTextGetInsertionPoint(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     XawTextPosition returnVar;
     char conversionBuffer[100];

     DBUG_ENTER(argv[0]);  

     if (argc != 2) 
	 {
	 wafeArgcError(argv[0],"",1,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],asciiTextWidgetClass,"AsciiText")))
         {
         wafeConvError(argv[0],"1",argv[1],"AsciiTextWidget");
         DBUG_RETURN (TCL_ERROR);
         }

     returnVar = XawTextGetInsertionPoint(localVar1);

     sprintf(conversionBuffer, "%ld", returnVar);
     Tcl_SetResult(comInterpreter, conversionBuffer, TCL_VOLATILE);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void 
 * XawTextGetSelectionPos
 *         in: AsciiTextWidget 		# ascii text wiget
 *         out: XawTextPosition		# varname for from position
 *         out: XawTextPosition 		# varname for to position
 */

static int 
cmd_XawTextGetSelectionPos(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     XawTextPosition localVar2;
     XawTextPosition localVar3;
     char conversionBuffer[100];

     DBUG_ENTER(argv[0]);  

     if (argc != 4) 
	 {
	 wafeArgcError(argv[0],"",3,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],asciiTextWidgetClass,"AsciiText")))
         {
         wafeConvError(argv[0],"1",argv[1],"AsciiTextWidget");
         DBUG_RETURN (TCL_ERROR);
         }

     XawTextGetSelectionPos(localVar1,&localVar2,&localVar3);

     sprintf(conversionBuffer, "%ld", localVar2);

     Tcl_SetVar(wafeInterpreter, argv[2], conversionBuffer, 0);

     sprintf(conversionBuffer, "%ld", localVar3);

     Tcl_SetVar(wafeInterpreter, argv[3], conversionBuffer, 0);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XawTextInvalidate
 * 	in: AsciiTextWidget		# ascii text wiget
 * 	in: XawTextPosition		# from postion
 * 	in: XawTextPosition		# to postion
 */

static int 
cmd_XawTextInvalidate(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     XawTextPosition localVar2;
     XawTextPosition localVar3;

     DBUG_ENTER(argv[0]);  

     if (argc != 4) 
	 {
	 wafeArgcError(argv[0],"",3,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],asciiTextWidgetClass,"AsciiText")))
         {
         wafeConvError(argv[0],"1",argv[1],"AsciiTextWidget");
         DBUG_RETURN (TCL_ERROR);
         }

     if (!(sscanf(argv[2], "%ld", &localVar2)))
         {
         wafeConvError(argv[0],"2",argv[2],"XawTextPosition");
         DBUG_RETURN (TCL_ERROR);
         }

     if (!(sscanf(argv[3], "%ld", &localVar3)))
         {
         wafeConvError(argv[0],"3",argv[3],"XawTextPosition");
         DBUG_RETURN (TCL_ERROR);
         }

     XawTextInvalidate(localVar1,localVar2,localVar3);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * XawTextPosition
 * XawTextSearch
 * 	in: AsciiTextWidget		# ascii text wiget
 * 	in: XawTextScanDirection	# scan direction
 * 	in: XawTextBlock		# text block
 */

static int 
cmd_XawTextSearch(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     XawTextScanDirection localVar2;
     XawTextBlock localVar3;
     XawTextPosition returnVar;
     char conversionBuffer[100];

     DBUG_ENTER(argv[0]);  

     if (argc != 4) 
	 {
	 wafeArgcError(argv[0],"",3,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],asciiTextWidgetClass,"AsciiText")))
         {
         wafeConvError(argv[0],"1",argv[1],"AsciiTextWidget");
         DBUG_RETURN (TCL_ERROR);
         }

     if (!strcmp(argv[2], "left")) 
         localVar2 = XawsdLeft;
     else
     if (!strcmp(argv[2], "right")) 
         localVar2 = XawsdRight;
     else
     if (!strcmp(argv[2], "Left")) 
         localVar2 = XawsdLeft;
     else
     if (!strcmp(argv[2], "Right")) 
         localVar2 = XawsdRight;
     else
         {
         wafeConvError(argv[0],"2",argv[2],"XawTextScanDirection");
         DBUG_RETURN (TCL_ERROR);
        }


     { char *charp;
         if (!(charp=Tcl_GetVar2(wafeInterpreter,argv[3],"firstPos", 0)))
               {
               wafeNoVarCompError("XawTextSearch",argv[3],"firstPos");
               DBUG_RETURN (TCL_ERROR);
               }
         if (!(sscanf(charp, "%d", &localVar3.firstPos)))
             {
             wafeConvError(argv[0],"3.firstPos",charp,"int");
             DBUG_RETURN (TCL_ERROR);
             }

         if (!(charp=Tcl_GetVar2(wafeInterpreter,argv[3],"length", 0)))
               {
               wafeNoVarCompError("XawTextSearch",argv[3],"length");
               DBUG_RETURN (TCL_ERROR);
               }
         if (!(sscanf(charp, "%d", &localVar3.length)))
             {
             wafeConvError(argv[0],"3.length",charp,"int");
             DBUG_RETURN (TCL_ERROR);
             }

         if (!(charp=Tcl_GetVar2(wafeInterpreter,argv[3],"ptr", 0)))
               {
               wafeNoVarCompError("XawTextSearch",argv[3],"ptr");
               DBUG_RETURN (TCL_ERROR);
               }
         localVar3.ptr = charp;
     }

     returnVar = XawTextSearch(localVar1,localVar2,&localVar3);

     sprintf(conversionBuffer, "%ld", returnVar);
     Tcl_SetResult(comInterpreter, conversionBuffer, TCL_VOLATILE);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XawTextSetInsertionPoint
 * 	in: AsciiTextWidget		# ascii text wiget
 * 	in: XawTextPosition		# position
 */

static int 
cmd_XawTextSetInsertionPoint(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     XawTextPosition localVar2;

     DBUG_ENTER(argv[0]);  

     if (argc != 3) 
	 {
	 wafeArgcError(argv[0],"",2,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],asciiTextWidgetClass,"AsciiText")))
         {
         wafeConvError(argv[0],"1",argv[1],"AsciiTextWidget");
         DBUG_RETURN (TCL_ERROR);
         }

     if (!(sscanf(argv[2], "%ld", &localVar2)))
         {
         wafeConvError(argv[0],"2",argv[2],"XawTextPosition");
         DBUG_RETURN (TCL_ERROR);
         }

     XawTextSetInsertionPoint(localVar1,localVar2);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void 
 * XawTextSetSelection
 *         in: AsciiTextWidget 		# ascii text wiget
 *         in: XawTextPosition		# from position
 *         in: XawTextPosition 		# to position
 */

static int 
cmd_XawTextSetSelection(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     XawTextPosition localVar2;
     XawTextPosition localVar3;

     DBUG_ENTER(argv[0]);  

     if (argc != 4) 
	 {
	 wafeArgcError(argv[0],"",3,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],asciiTextWidgetClass,"AsciiText")))
         {
         wafeConvError(argv[0],"1",argv[1],"AsciiTextWidget");
         DBUG_RETURN (TCL_ERROR);
         }

     if (!(sscanf(argv[2], "%ld", &localVar2)))
         {
         wafeConvError(argv[0],"2",argv[2],"XawTextPosition");
         DBUG_RETURN (TCL_ERROR);
         }

     if (!(sscanf(argv[3], "%ld", &localVar3)))
         {
         wafeConvError(argv[0],"3",argv[3],"XawTextPosition");
         DBUG_RETURN (TCL_ERROR);
         }

     XawTextSetSelection(localVar1,localVar2,localVar3);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XawTextSetSelectionArray
 * 	in: AsciiTextWidget		# ascii text wiget
 * 	in: [XawTextSelectType]		# selction array
 */

static int 
cmd_XawTextSetSelectionArray(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     XawTextSelectType * localVar2;

     DBUG_ENTER(argv[0]);  

     if (argc < 3) 
	 {
	 wafeArgcError(argv[0],"at least ",2,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],asciiTextWidgetClass,"AsciiText")))
         {
         wafeConvError(argv[0],"1",argv[1],"AsciiTextWidget");
         DBUG_RETURN (TCL_ERROR);
         }

     {    XawTextSelectType *ptr;
          argv += 2;
          localVar2 = ptr =
             (XawTextSelectType *)XtMalloc((argc-2)*sizeof(XawTextSelectType));

          while (*argv)
             {
             if (!strcmp(*argv, "selectAll")) 
                 *ptr = XawselectAll;
             else
             if (!strcmp(*argv, "selectChar")) 
                 *ptr = XawselectChar;
             else
             if (!strcmp(*argv, "selectLine")) 
                 *ptr = XawselectLine;
             else
             if (!strcmp(*argv, "selectNull")) 
                 *ptr = XawselectNull;
             else
             if (!strcmp(*argv, "selectParagraph")) 
                 *ptr = XawselectParagraph;
             else
             if (!strcmp(*argv, "selectPosition")) 
                 *ptr = XawselectPosition;
             else
             if (!strcmp(*argv, "selectWord")) 
                 *ptr = XawselectWord;
             else
                 {
                 wafeConvError(argv[0],"2",*argv,"XawTextSelectType");
                 DBUG_RETURN (TCL_ERROR);
                }


          ptr ++; argv++;
          }
     }
     XawTextSetSelectionArray(localVar1,localVar2);
     wafeMMreplace(wafeMMgetAttribList(localVar1,True),WafePermStringToQuark("XawTextSetSelectionArray"),(char*)localVar2,XtFree);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * int
 * XawTextSinkMaxHeight
 * 	in: (Widget)TextSink 		# ascii text wiget
 * 	in: int				# height
 */

static int 
cmd_XawTextSinkMaxHeight(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     int localVar2;
     int returnVar;
     char conversionBuffer[100];

     DBUG_ENTER(argv[0]);  

     if (argc != 3) 
	 {
	 wafeArgcError(argv[0],"",2,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 = (Widget) name2Sink(argv[1])))
         {
         wafeConvError(argv[0],"1",argv[1],"TextSink");
         DBUG_RETURN (TCL_ERROR);
         }

     if (!(sscanf(argv[2], "%d", &localVar2)))
         {
         wafeConvError(argv[0],"2",argv[2],"int");
         DBUG_RETURN (TCL_ERROR);
         }

     returnVar = XawTextSinkMaxHeight(localVar1,localVar2);

     sprintf(conversionBuffer, "%d", returnVar);
     Tcl_SetResult(comInterpreter, conversionBuffer, TCL_VOLATILE);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * int
 * XawTextSinkMaxLines
 * 	in: (Widget)TextSink		# ascii text wiget
 * 	in: Dimension			# height
 */

static int 
cmd_XawTextSinkMaxLines(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     Dimension localVar2;
     int returnVar;
     char conversionBuffer[100];

     DBUG_ENTER(argv[0]);  

     if (argc != 3) 
	 {
	 wafeArgcError(argv[0],"",2,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 = (Widget) name2Sink(argv[1])))
         {
         wafeConvError(argv[0],"1",argv[1],"TextSink");
         DBUG_RETURN (TCL_ERROR);
         }

     if (!(sscanf(argv[2], "%hu", &localVar2)))
         {
         wafeConvError(argv[0],"2",argv[2],"Dimension");
         DBUG_RETURN (TCL_ERROR);
         }

     returnVar = XawTextSinkMaxLines(localVar1,localVar2);

     sprintf(conversionBuffer, "%d", returnVar);
     Tcl_SetResult(comInterpreter, conversionBuffer, TCL_VOLATILE);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XawTextSinkSetTabs
 * 	in: (Widget)TextSink		# ascii text wiget
 * 	const: argc-2
 * 	in: [int]			# tabs
 */

static int 
cmd_XawTextSinkSetTabs(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     int * localVar2;

     DBUG_ENTER(argv[0]);  

     if (argc < 3) 
	 {
	 wafeArgcError(argv[0],"at least ",2,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 = (Widget) name2Sink(argv[1])))
         {
         wafeConvError(argv[0],"1",argv[1],"TextSink");
         DBUG_RETURN (TCL_ERROR);
         }

     {    int *ptr;
          argv += 2;
          localVar2 = ptr =
             (int *)XtMalloc((argc-2)*sizeof(int));

          while (*argv)
             {
             if (!(sscanf(*argv, "%d", &*ptr)))
                 {
                 wafeConvError(argv[0],"2",*argv,"int");
                 DBUG_RETURN (TCL_ERROR);
                 }

          ptr ++; argv++;
          }
     }
     XawTextSinkSetTabs(localVar1,argc-2,localVar2);
     wafeMMreplace(wafeMMgetAttribList(localVar1,True),WafePermStringToQuark("XawTextSinkSetTabs"),(char*)localVar2,XtFree);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * XawTextPosition
 * XawTextSourceRead 
 * 	in: XawTextGetSource(AsciiTextWidget)	# ascii text wiget
 * 	in: XawTextPosition		# position
 * 	out: XawTextBlock		# varname for text block
 * 	in: int				# length
 */

static int 
cmd_XawTextSourceRead(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     XawTextPosition localVar2;
     XawTextBlock localVar3;
     int localVar4;
     XawTextPosition returnVar;
     char conversionBuffer[100];

     DBUG_ENTER(argv[0]);  

     if (argc != 5) 
	 {
	 wafeArgcError(argv[0],"",4,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],asciiTextWidgetClass,"AsciiText")))
         {
         wafeConvError(argv[0],"1",argv[1],"AsciiTextWidget");
         DBUG_RETURN (TCL_ERROR);
         }

     if (!(sscanf(argv[2], "%ld", &localVar2)))
         {
         wafeConvError(argv[0],"2",argv[2],"XawTextPosition");
         DBUG_RETURN (TCL_ERROR);
         }

     if (!(sscanf(argv[4], "%d", &localVar4)))
         {
         wafeConvError(argv[0],"4",argv[4],"int");
         DBUG_RETURN (TCL_ERROR);
         }

     returnVar = XawTextSourceRead(XawTextGetSource(localVar1),localVar2,&localVar3,localVar4);

          sprintf(conversionBuffer, "%d", localVar3.firstPos);

     Tcl_SetVar2(wafeInterpreter,argv[3],"firstPos", conversionBuffer,0);
     sprintf(conversionBuffer, "%d", localVar3.length);

     Tcl_SetVar2(wafeInterpreter,argv[3],"length", conversionBuffer,0);
     
     Tcl_SetVar2(wafeInterpreter,argv[3],"ptr", localVar3.ptr,0);


     sprintf(conversionBuffer, "%ld", returnVar);
     Tcl_SetResult(comInterpreter, conversionBuffer, TCL_VOLATILE);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * XawTextPosition
 * XawTextSourceScan
 * 	in: XawTextGetSource(AsciiTextWidget)	# ascii text wiget
 * 	in: XawTextPosition		# position
 * 	in: XawTextScanType		# scan type
 * 	in: XawTextScanDirection	# scan direction
 * 	in: int				# count
 * 	in: Boolean			# include (boolean)
 */

static int 
cmd_XawTextSourceScan(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     XawTextPosition localVar2;
     XawTextScanType localVar3;
     XawTextScanDirection localVar4;
     int localVar5;
     Boolean localVar6;
     XawTextPosition returnVar;
     char conversionBuffer[100];

     DBUG_ENTER(argv[0]);  

     if (argc != 7) 
	 {
	 wafeArgcError(argv[0],"",6,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],asciiTextWidgetClass,"AsciiText")))
         {
         wafeConvError(argv[0],"1",argv[1],"AsciiTextWidget");
         DBUG_RETURN (TCL_ERROR);
         }

     if (!(sscanf(argv[2], "%ld", &localVar2)))
         {
         wafeConvError(argv[0],"2",argv[2],"XawTextPosition");
         DBUG_RETURN (TCL_ERROR);
         }

     if (!strcmp(argv[3], "position")) 
         localVar3 = XawstPositions;
     else
     if (!strcmp(argv[3], "whiteSpace")) 
         localVar3 = XawstWhiteSpace;
     else
     if (!strcmp(argv[3], "EOL")) 
         localVar3 = XawstEOL;
     else
     if (!strcmp(argv[3], "paragraph")) 
         localVar3 = XawstParagraph;
     else
     if (!strcmp(argv[3], "all")) 
         localVar3 = XawstAll;
     else
         {
         wafeConvError(argv[0],"3",argv[3],"XawTextScanType");
         DBUG_RETURN (TCL_ERROR);
        }


     if (!strcmp(argv[4], "left")) 
         localVar4 = XawsdLeft;
     else
     if (!strcmp(argv[4], "right")) 
         localVar4 = XawsdRight;
     else
     if (!strcmp(argv[4], "Left")) 
         localVar4 = XawsdLeft;
     else
     if (!strcmp(argv[4], "Right")) 
         localVar4 = XawsdRight;
     else
         {
         wafeConvError(argv[0],"4",argv[4],"XawTextScanDirection");
         DBUG_RETURN (TCL_ERROR);
        }


     if (!(sscanf(argv[5], "%d", &localVar5)))
         {
         wafeConvError(argv[0],"5",argv[5],"int");
         DBUG_RETURN (TCL_ERROR);
         }

     if (!(wafeGetBoolean(argv[6],&localVar6)))
         {
         wafeConvError(argv[0],"6",argv[6],"Boolean");
         DBUG_RETURN (TCL_ERROR);
         }

     returnVar = XawTextSourceScan(XawTextGetSource(localVar1),localVar2,localVar3,localVar4,localVar5,localVar6);

     sprintf(conversionBuffer, "%ld", returnVar);
     Tcl_SetResult(comInterpreter, conversionBuffer, TCL_VOLATILE);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * XawTextPosition
 * XawTextTopPosition
 * 	in: AsciiTextWidget		# ascii text wiget
 */

static int 
cmd_XawTextTopPosition(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     XawTextPosition returnVar;
     char conversionBuffer[100];

     DBUG_ENTER(argv[0]);  

     if (argc != 2) 
	 {
	 wafeArgcError(argv[0],"",1,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],asciiTextWidgetClass,"AsciiText")))
         {
         wafeConvError(argv[0],"1",argv[1],"AsciiTextWidget");
         DBUG_RETURN (TCL_ERROR);
         }

     returnVar = XawTextTopPosition(localVar1);

     sprintf(conversionBuffer, "%ld", returnVar);
     Tcl_SetResult(comInterpreter, conversionBuffer, TCL_VOLATILE);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * (int) ReplaceVal 
 * XawTextReplace
 *         in: AsciiTextWidget		# ascii text wiget
 *         in: XawTextPosition 		# from position
 *         in: XawTextPosition 		# to position
 *         in: XawTextBlock		# text block
 */

static int 
cmd_XawTextReplace(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     XawTextPosition localVar2;
     XawTextPosition localVar3;
     XawTextBlock localVar4;
     int returnVar;
     char *staticResultString;

     DBUG_ENTER(argv[0]);  

     if (argc != 5) 
	 {
	 wafeArgcError(argv[0],"",4,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],asciiTextWidgetClass,"AsciiText")))
         {
         wafeConvError(argv[0],"1",argv[1],"AsciiTextWidget");
         DBUG_RETURN (TCL_ERROR);
         }

     if (!(sscanf(argv[2], "%ld", &localVar2)))
         {
         wafeConvError(argv[0],"2",argv[2],"XawTextPosition");
         DBUG_RETURN (TCL_ERROR);
         }

     if (!(sscanf(argv[3], "%ld", &localVar3)))
         {
         wafeConvError(argv[0],"3",argv[3],"XawTextPosition");
         DBUG_RETURN (TCL_ERROR);
         }

     { char *charp;
         if (!(charp=Tcl_GetVar2(wafeInterpreter,argv[4],"firstPos", 0)))
               {
               wafeNoVarCompError("XawTextReplace",argv[4],"firstPos");
               DBUG_RETURN (TCL_ERROR);
               }
         if (!(sscanf(charp, "%d", &localVar4.firstPos)))
             {
             wafeConvError(argv[0],"4.firstPos",charp,"int");
             DBUG_RETURN (TCL_ERROR);
             }

         if (!(charp=Tcl_GetVar2(wafeInterpreter,argv[4],"length", 0)))
               {
               wafeNoVarCompError("XawTextReplace",argv[4],"length");
               DBUG_RETURN (TCL_ERROR);
               }
         if (!(sscanf(charp, "%d", &localVar4.length)))
             {
             wafeConvError(argv[0],"4.length",charp,"int");
             DBUG_RETURN (TCL_ERROR);
             }

         if (!(charp=Tcl_GetVar2(wafeInterpreter,argv[4],"ptr", 0)))
               {
               wafeNoVarCompError("XawTextReplace",argv[4],"ptr");
               DBUG_RETURN (TCL_ERROR);
               }
         localVar4.ptr = charp;
     }

     returnVar = XawTextReplace(localVar1,localVar2,localVar3,&localVar4);

     if (returnVar == XawEditDone) 
         staticResultString = "editDone";
     else if (returnVar == XawPositionError) 
         staticResultString = "positionError";
     else if (returnVar == XawEditError) 
         staticResultString = "editError";

     Tcl_SetResult(comInterpreter, staticResultString, TCL_STATIC);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void 
 * XawTextUnsetSelection
 *         in: AsciiTextWidget 		# ascii text wiget
 */

static int 
cmd_XawTextUnsetSelection(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;

     DBUG_ENTER(argv[0]);  

     if (argc != 2) 
	 {
	 wafeArgcError(argv[0],"",1,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],asciiTextWidgetClass,"AsciiText")))
         {
         wafeConvError(argv[0],"1",argv[1],"AsciiTextWidget");
         DBUG_RETURN (TCL_ERROR);
         }

     XawTextUnsetSelection(localVar1);

     DBUG_RETURN (TCL_OK);
     }     


#include <X11/Xaw/Toggle.h>
/* 
 * void
 * XawToggleChangeRadioGroup
 * 	in: ToggleWidget		# toggle widget
 * 	in: NULL | ToggleWidget		# NULL | toggle widget
 */

static int 
cmd_XawToggleChangeRadioGroup(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     Widget localVar2;

     DBUG_ENTER(argv[0]);  

     if (argc != 3) 
	 {
	 wafeArgcError(argv[0],"",2,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],toggleWidgetClass,"Toggle")))
         {
         wafeConvError(argv[0],"1",argv[1],"ToggleWidget");
         DBUG_RETURN (TCL_ERROR);
         }

     if (!strcmp(argv[2], "NULL")) 
         localVar2 = NULL;
     else
         if (!(localVar2 =  name2WidgetOfClass(argv[2],toggleWidgetClass,"Toggle")))
         {
         wafeConvError(argv[0],"2",argv[2],"ToggleWidget");
         DBUG_RETURN (TCL_ERROR);
         }

     XawToggleChangeRadioGroup(localVar1,localVar2);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * (String) VString
 * XawToggleGetCurrent
 * 	in: ToggleWidget		# toggle widget
 */

static int 
cmd_XawToggleGetCurrent(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     String returnVar;

     DBUG_ENTER(argv[0]);  

     if (argc != 2) 
	 {
	 wafeArgcError(argv[0],"",1,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],toggleWidgetClass,"Toggle")))
         {
         wafeConvError(argv[0],"1",argv[1],"ToggleWidget");
         DBUG_RETURN (TCL_ERROR);
         }

     returnVar = XawToggleGetCurrent(localVar1);

     Tcl_SetResult(comInterpreter, returnVar, TCL_VOLATILE);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XawToggleSetCurrent
 * 	in: ToggleWidget		# toggle widget
 * 	in: String			# radio data
 */

static int 
cmd_XawToggleSetCurrent(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;

     DBUG_ENTER(argv[0]);  

     if (argc != 3) 
	 {
	 wafeArgcError(argv[0],"",2,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],toggleWidgetClass,"Toggle")))
         {
         wafeConvError(argv[0],"1",argv[1],"ToggleWidget");
         DBUG_RETURN (TCL_ERROR);
         }

    /* no need to assign  << localVar2 = argv[2] >>  */ 

     XawToggleSetCurrent(localVar1,argv[2]);

     DBUG_RETURN (TCL_OK);
     }     


#define toggleSetRadioData(w, string) XtVaSetValues(w, XtNradioData, string, NULL)

/* 
 * void
 * toggleSetRadioData vulgo XawToggleSetRadioData
 * 	in: ToggleWidget		# toggle widget
 *         in: XtNewString(String)		# radio data
 */

static int 
cmd_XawToggleSetRadioData(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;

     DBUG_ENTER(argv[0]);  

     if (argc != 3) 
	 {
	 wafeArgcError(argv[0],"",2,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],toggleWidgetClass,"Toggle")))
         {
         wafeConvError(argv[0],"1",argv[1],"ToggleWidget");
         DBUG_RETURN (TCL_ERROR);
         }

    /* no need to assign  << localVar2 = argv[2] >>  */ 

     toggleSetRadioData(localVar1,XtNewString(argv[2]));

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XawToggleUnsetCurrent
 * 	in: ToggleWidget		# toggle widget
 */

static int 
cmd_XawToggleUnsetCurrent(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;

     DBUG_ENTER(argv[0]);  

     if (argc != 2) 
	 {
	 wafeArgcError(argv[0],"",1,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],toggleWidgetClass,"Toggle")))
         {
         wafeConvError(argv[0],"1",argv[1],"ToggleWidget");
         DBUG_RETURN (TCL_ERROR);
         }

     XawToggleUnsetCurrent(localVar1);

     DBUG_RETURN (TCL_OK);
     }     


#include <X11/Xaw/Viewport.h>
/* 
 * hint: R5|XAW3D
 * void
 * XawViewportSetCoordinates
 * 	in: ViewportWidget		# viewport Widget
 * 	in: Position			# x position
 * 	in: Position			# y position
 */
#if !defined(PRER5) || defined(XAW3D)

static int 
cmd_XawViewportSetCoordinates(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     Position localVar2;
     Position localVar3;

     DBUG_ENTER(argv[0]);  

     if (argc != 4) 
	 {
	 wafeArgcError(argv[0],"",3,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],viewportWidgetClass,"Viewport")))
         {
         wafeConvError(argv[0],"1",argv[1],"ViewportWidget");
         DBUG_RETURN (TCL_ERROR);
         }

     if (!(sscanf(argv[2], "%hd", &localVar2)))
         {
         wafeConvError(argv[0],"2",argv[2],"Position");
         DBUG_RETURN (TCL_ERROR);
         }

     if (!(sscanf(argv[3], "%hd", &localVar3)))
         {
         wafeConvError(argv[0],"3",argv[3],"Position");
         DBUG_RETURN (TCL_ERROR);
         }

     XawViewportSetCoordinates(localVar1,localVar2,localVar3);

     DBUG_RETURN (TCL_OK);
     }     

#endif

/* 
 * hint: R5|XAW3D
 * void
 * XawViewportSetLocation
 * 	in: ViewportWidget		# viewport Widget
 * 	in: double			# xoffset 
 * 	in: double			# yoffset

 */
#if !defined(PRER5) || defined(XAW3D)

static int 
cmd_XawViewportSetLocation(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     double localVar2;
     double localVar3;

     DBUG_ENTER(argv[0]);  

     if (argc != 4) 
	 {
	 wafeArgcError(argv[0],"",3,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],viewportWidgetClass,"Viewport")))
         {
         wafeConvError(argv[0],"1",argv[1],"ViewportWidget");
         DBUG_RETURN (TCL_ERROR);
         }

     if (!(sscanf(argv[2], "%lf", &localVar2)))
         {
         wafeConvError(argv[0],"2",argv[2],"double");
         DBUG_RETURN (TCL_ERROR);
         }

     if (!(sscanf(argv[3], "%lf", &localVar3)))
         {
         wafeConvError(argv[0],"3",argv[3],"double");
         DBUG_RETURN (TCL_ERROR);
         }

     XawViewportSetLocation(localVar1,localVar2,localVar3);

     DBUG_RETURN (TCL_OK);
     }     

#endif

#else
#endif

void
wafeInitialize_XawGen()
{
#ifdef ATHENA
 wafeCreateWidgetCommand("Text",asciiTextWidgetClass,NULL,False);
 wafeCreateWidgetCommand("Box",boxWidgetClass,NULL,False);
 wafeCreateWidgetCommand("Clock",clockWidgetClass,NULL,False);
 wafeCreateWidgetCommand("Command",commandWidgetClass,NULL,False);
 wafeCreateWidgetCommand("Dialog",dialogWidgetClass,NULL,False);
 wafeCreateWidgetCommand("Form",formWidgetClass,NULL,False);
 wafeCreateWidgetCommand("Grip",gripWidgetClass,NULL,False);
 wafeCreateWidgetCommand("Label",labelWidgetClass,NULL,False);
 wafeCreateWidgetCommand("List",listWidgetClass,listCreate,False);
 wafeCreateWidgetCommand("Logo",logoWidgetClass,NULL,False);
 wafeCreateWidgetCommand("Mailbox",mailboxWidgetClass,NULL,False);
 wafeCreateWidgetCommand("MenuButton",menuButtonWidgetClass,NULL,False);
 wafeCreateWidgetCommand("Paned",panedWidgetClass,NULL,False);
 wafeCreateWidgetCommand("Scrollbar",scrollbarWidgetClass,scrollbarCreate,False);
 wafeCreateWidgetCommand("SimpleMenu",simpleMenuWidgetClass,XtCreatePopupShell,True);
 wafeCreateWidgetCommand("Sme",smeObjectClass,NULL,False);
 wafeCreateWidgetCommand("SmeBSB",smeBSBObjectClass,NULL,False);
 wafeCreateWidgetCommand("SmeLine",smeLineObjectClass,NULL,False);
 wafeCreateWidgetCommand("StripChart",stripChartWidgetClass,stripChartCreate,False);
 wafeCreateWidgetCommand("Toggle",toggleWidgetClass,NULL,False);
 wafeCreateWidgetCommand("Viewport",viewportWidgetClass,NULL,False);
#ifdef ATHENA
 Tcl_SetVar(wafeInterpreter,"PACKAGES","ATHENA",TCL_GLOBAL_ONLY|TCL_APPEND_VALUE|TCL_LIST_ELEMENT);
#endif
#ifdef XAW3D
 Tcl_SetVar(wafeInterpreter,"PACKAGES","XAW3D",TCL_GLOBAL_ONLY|TCL_APPEND_VALUE|TCL_LIST_ELEMENT);
#endif
 qcallback = WafePermStringToQuark("callback");
 qjumpProc = WafePermStringToQuark("jumpProc");
 qscrollProc = WafePermStringToQuark("scrollProc");
 XtSetTypeConverter("EditMode", XtRString,
	(XtTypeConverter)CvtEditTypeToString, 
	NULL, 0, XtCacheNone, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XawAsciiSave", cmd_XawAsciiSave, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XawAsciiSaveAsFile", cmd_XawAsciiSaveAsFile, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XawAsciiSourceChanged", cmd_XawAsciiSourceChanged, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XawAsciiSourceFreeString", cmd_XawAsciiSourceFreeString, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XawDialogGetValueString", cmd_XawDialogGetValueString, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XawFormDoLayout", cmd_XawFormDoLayout, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XawListAppend", cmd_XawListAppend, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XawListChange", cmd_XawListChange, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XawListHighlight", cmd_XawListHighlight, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XawListShowCurrent", cmd_XawListShowCurrent, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XawListUnhighlight", cmd_XawListUnhighlight, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XawPanedAllowResize", cmd_XawPanedAllowResize, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XawPanedGetMinMax", cmd_XawPanedGetMinMax, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XawPanedGetNumSub", cmd_XawPanedGetNumSub, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XawPanedSetMinMax", cmd_XawPanedSetMinMax, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XawPanedSetRefigureMode", cmd_XawPanedSetRefigureMode, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XawScrollbarSetThumb", cmd_XawScrollbarSetThumb, NULL, NULL);
 /* alias */  Tcl_CreateCommand(wafeInterpreter,"scSet",cmd_XawStripChartSet, NULL,NULL);
 Tcl_CreateCommand(wafeInterpreter, "XawSimpleMenuClearActiveEntry", cmd_XawSimpleMenuClearActiveEntry, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XawSimpleMenuGetActiveEntry", cmd_XawSimpleMenuGetActiveEntry, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XawStripChartSet", cmd_XawStripChartSet, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XawTextDisableRedisplay", cmd_XawTextDisableRedisplay, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XawTextDisplay", cmd_XawTextDisplay, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XawTextDisplayCaret", cmd_XawTextDisplayCaret, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XawTextEnableRedisplay", cmd_XawTextEnableRedisplay, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XawTextGetInsertionPoint", cmd_XawTextGetInsertionPoint, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XawTextGetSelectionPos", cmd_XawTextGetSelectionPos, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XawTextInvalidate", cmd_XawTextInvalidate, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XawTextSearch", cmd_XawTextSearch, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XawTextSetInsertionPoint", cmd_XawTextSetInsertionPoint, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XawTextSetSelection", cmd_XawTextSetSelection, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XawTextSetSelectionArray", cmd_XawTextSetSelectionArray, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XawTextSinkMaxHeight", cmd_XawTextSinkMaxHeight, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XawTextSinkMaxLines", cmd_XawTextSinkMaxLines, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XawTextSinkSetTabs", cmd_XawTextSinkSetTabs, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XawTextSourceRead", cmd_XawTextSourceRead, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XawTextSourceScan", cmd_XawTextSourceScan, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XawTextTopPosition", cmd_XawTextTopPosition, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XawTextReplace", cmd_XawTextReplace, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XawTextUnsetSelection", cmd_XawTextUnsetSelection, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XawToggleChangeRadioGroup", cmd_XawToggleChangeRadioGroup, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XawToggleGetCurrent", cmd_XawToggleGetCurrent, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XawToggleSetCurrent", cmd_XawToggleSetCurrent, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XawToggleSetRadioData", cmd_XawToggleSetRadioData, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XawToggleUnsetCurrent", cmd_XawToggleUnsetCurrent, NULL, NULL);
#if !defined(PRER5) || defined(XAW3D)
 Tcl_CreateCommand(wafeInterpreter, "XawViewportSetCoordinates", cmd_XawViewportSetCoordinates, NULL, NULL);
#endif
#if !defined(PRER5) || defined(XAW3D)
 Tcl_CreateCommand(wafeInterpreter, "XawViewportSetLocation", cmd_XawViewportSetLocation, NULL, NULL);
#endif

#else
#endif
}
