#! ../wafe --f

scriptNeeds AtPlotter { This script needs the Plotter widget set! }

### A sample script using the Plotter widget to demonstrate
### AtXYLinePlotExtendData; one can use the cursor keys or the push
### buttons to alter the displayed x-range while the graph is 'live'
### updating
###
### Gustaf Neumann

set min 1 
set max 240

set translations {#override
   <Key>Left: exec(changeRange -20)
   <Key>Right: exec(changeRange +20)
}

fallbackResources topLevel \
    *Form.background gray80 \
    *AtPlotter.background gray90 \
    *AtPlotter.translations $translations \
    *AtPlotter.showLegend false \
    *AtPlotter.width 800 \
    *AtPlotter.height 120 \
    *p1.pf.foreground red \
    *p2.pf.foreground green \
    *p3.pf.foreground pink \
    *p4.pf.foreground turquoise \
    *p5.pf.foreground brown 

proc mkPlot {plot} {
  global plots min max
  AtPlotter $plot plot
    AtXYAxis x $plot autoScale false min $min max $max
    AtXYAxis y $plot vertical true       
  sV $plot xAxis $plot.x yAxis $plot.y
  AtXYLinePlot pf $plot
  lappend plots $plot
}

Form plot topLevel
mkPlot p1
mkPlot p2; sV p2 fromVert p1
mkPlot p3; sV p3 fromVert p2
mkPlot p4; sV p4 fromVert p3
mkPlot p5; sV p5 fromVert p4

Command Left  plot fromVert p5 callback { changeRange +60 }
Command Right plot fromVert p5 fromHoriz Left callback { changeRange -60 }
realize

proc changeRange {offset} {
  global plots min max
  incr min $offset
  incr max $offset
  foreach p $plots { sV $p.x min $min max $max }
}

set seed [pid]
proc random { nvalues } {
  global seed
  set seed [expr ($seed*12731+34197)%21473]
  return [expr $seed%$nvalues]
}

set time 0
proc tick {} {
  global time plots min max
  incr time
  if $time<$min {
    changeRange -60
  } elseif $time>$max {
    changeRange +60
  }
  foreach p $plots { AtXYLinePlotExtendData $p.pf $time/[random 100] }
  if $time<600 { addTimeOut 100 tick }
}

tick
