#> This section describes the commands available in Wafe to access the
#> functionality of Roger Reynold's (rogerr@netcom.com) Drag n' Drop
#> Library, version 1.3. Note, that drag and drop can be used between
#> various applications as well as within one application.

$PACKAGE = "RDD";

~handles
	RDD

~require
rdd.inc
	init rddWafeInit();

~require 
rdd.c

#> The command 'rddSetDropData' sets the drop data (an arbitrary
#> string) for the following drag and drop operation. The actual drag
#> operation is started typically by the action routine
#> 'rddWafeStartAction shell dragShell' (where 'shell' indicates the
#> type of the drag operation, and dragShell is a pre-existing shell,
#> that is dragged around on the screen) or by 'rddWafeStartAction
#> pixmap picture.xpm' where the given picture is used the visualize
#> the drag operation. 

void
rddSetDropData
	in: XtNewString(String)   	# message string
	const: strlen(argv[1])

#> The command 'rddAddDropHandler' allows to register a drop handler
#> which is executed after a successful drop operation in the given
#> widget (1st argument). The drop data, which was set previously
#> using the command 'rddSetDropData' is passed in the global Tcl
#> variable 'DROP', which is typically referenced in the given Tcl
#> Command (2nd argument).
#> 
#>    Example: rddAddDropHandler clear {undoAssignment $DROP}
#> 
#> If the the user released the button over a widget, that does not
#> have a drop handler associated, a Tcl procedure with the name
#> 'rddDropFailHandler' with no arguments is called.

void
rddAddDropHandler
	in: Widget		 	# widget	
	const: (XtCallbackProc)rddDropCallbackProc
	in: XtNewString(String)   	# Tcl command for successful drop


