/*
 * Copyright (C) 1992 by Gustaf Neumann, Stefan Nusser
 *
 *      Wirtschaftsuniversitaet Wien,
 *      Abteilung fuer Wirtschaftsinformatik
 *      Augasse 2-6,
 *      A-1090 Vienna, Austria
 *      neumann@@wu-wien.ac.at, nusser@@wu-wien.ac.at
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided
 * that the above copyright notice appears in all copies and that both that
 * copyright notice and this permission notice appear in all supporting
 * documentation.  This software is provided "as is" without expressed or
 * implied warranty.
 *
 * Date: Mon, Apr 13 1992
 * Author: Stefan Nusser, Gustaf Neumann
 * Version: 0.9
 */

/*
 *             ACTIONSCB.C
 *
 *             This file contains all commands dealing with actions,
 *             callbacks, accelerators, etc and all related functions:
 *
 *             wafePositionCursorCallbackProc
 *             wafePositionCallbackProc
 *             wafeExecActionProc
 */

#define ACTIONSCB_C

#include "wafe.h"

/*
 * Additionally, we need the following handler procedures, which are located in the
 * files list.c and scrollbar.c.
 */

#define KeySymStringBufferLength 100

void
wafeActionPercentcode(ws,inChar,event,w)
wafeString ws;
char       inChar;
XEvent    *event;
Widget     w;
    {
    KeySym keySym;
    char   KeySymStringBuffer[KeySymStringBufferLength];
    Boolean success = True;
    
    if (event) 
	{
	switch (inChar)
	    {
	case 't':
	    switch (event->type)
		{
	    case ButtonPress:
		wafeStringAppend(ws, "ButtonPress");
		break;
		
	    case ButtonRelease:
		wafeStringAppend(ws, "ButtonRelease");
		break;
		
	    case MotionNotify:
		wafeStringAppend(ws, "MotionNotify");
		break;

	    case KeyPress:
		wafeStringAppend(ws, "KeyPress");
		break;

	    case KeyRelease:
		wafeStringAppend(ws, "KeyRelease");
		break;

	    case EnterNotify:
		wafeStringAppend(ws, "EnterNotify");
		break;

	    case LeaveNotify:
		wafeStringAppend(ws, "LeaveNotify");
		break;

	    case ClientMessage:
		wafeStringAppend(ws, "ClientMessage");
		break;

	    default:
		wafeStringAppend(ws, "Unknown");
		break;
		}
	    break;

	case 'w':
	    wafeStringAppend(ws, XtName(w));
	    break;

	case 'W':
	    wafeStringAppendLong(ws, (long)w);
	    break;
	    
	case 'x':
	    wafeStringAppendInt(ws, event->xbutton.x);
	    break;

	case 'y':
	    wafeStringAppendInt(ws, event->xbutton.y);
	    break;

	case 'X':
	    wafeStringAppendInt(ws, event->xbutton.x_root);
	    break;

	case 'Y':
	    wafeStringAppendInt(ws, event->xbutton.y_root);
	    break;

	case 'a':
	    if (event->type == KeyPress || event->type == KeyRelease)
		{
		int len = XLookupString((XKeyEvent *)event,
			    KeySymStringBuffer,KeySymStringBufferLength,
			    &keySym, NULL);
		/*   *(KeySymStringBuffer+len) = '\0'; */
		wafeStringAppendEscaped(ws, KeySymStringBuffer, len);
		break;
		}
	    
	case 'b':
	    if (event->type == ButtonPress || event->type == ButtonRelease)
		{
		wafeStringAppendInt(ws, event->xbutton.button);
		break;
		}

	case 'k':
	    if (event->type == KeyPress || event->type == KeyRelease)
		{
		wafeStringAppendInt(ws, event->xkey.keycode);
		break;
		}

	case 'p':
	    if (event->type == ClientMessage)
		{
		char *p =
		    XGetAtomName(((XClientMessageEvent*)event)->display,
				 ((XClientMessageEvent*)event)->data.l[0]);
		if (!p) p = "UNKNOWN";
		wafeStringAppend(ws, p);
		break;
		}

	case 's':
	    if (event->type == KeyPress || event->type == KeyRelease)
		{
		if (XLookupString((XKeyEvent *)event, 
			      KeySymStringBuffer, KeySymStringBufferLength,
			      &keySym, NULL) > 0)
		    {
		    String s = XKeysymToString(keySym);
		    wafeStringAppend(ws, s);
		    }
		break;
		}
	case 'S':
	    if (event->type == ButtonPress || event->type == ButtonRelease ||
		event->type == KeyPress || event->type == KeyRelease ||
		event->type == MotionNotify
		)
		{
		wafeStringAppendInt(ws, event->xbutton.state);
		break;
		}
        case '%':
	    wafeStringAppendChar(ws, '%');
	    break;
	    
	default:
	    success = False;
	    }
	}
    else  /* no event */
	success = False;

    if (!success)
	{
	wafeStringAppendChar(ws,'%');
	wafeStringAppendChar(ws,inChar);
	}
    }


void
wafeExecActionProc(w, event, argv, argc)
Widget     w;
XEvent    *event;
char     **argv;
Cardinal  *argc;
    {
    wafeStringStruct assembled_s, command_s;
    wafeString assembled = &assembled_s;   /* Concat the arguments */
    wafeString command   = &command_s;     /* Do % substitution    */
    Cardinal i;
    char *input, *start;

    DBUG_ENTER("execActionProc");
    wafeCurrentEvent = event;

    wafeStringInit(assembled);
    wafeStringInit(command);

    for (i = 0; i < *argc; i++)
	{
	wafeStringAppend(assembled, argv[i]);
	wafeStringAppendChar(assembled, ' ');
	}
    if (*argc>0) 
	{
	assembled->length--;
	wafeStringAppendChar(assembled, '\0');
	}

    input = assembled->buffer;
    DBUG_PRINT("action", ("Assembled command: %s", input));

    /*  fprintf(stderr,"event type=%d\n",event->type);*/
    do 
	{
	for (start = input; *input && *input != '%'; input++);
	wafeStringAppendN(command,start,input-start);
	if (*input == '%')
	    {
	    wafeActionPercentcode(command,*++input,event,w); 
	    input++;
	    }
	} while (*input != '\0');

    wafeStringAppendChar(command, '\0');    
    wafeStringClear(assembled);

    DBUG_PRINT("action", ("command:<<%s>>", command->buffer));
    (void) wafeEval(wafeInterpreter, command->buffer, "execActionProc");
    wafeCurrentEvent = NULL;
    wafeStringClear(command);
    DBUG_VOID_RETURN;
    }



typedef struct {
        Widget widget;
        int xoffset;
        int yoffset;
} widgetAndOffset;

#define gt0(a) (((a) > 0) ? (a) : 0)

void
wafePositionCallbackProc(w, clientData, callData)
Widget     w;
XtPointer  clientData, callData;
     {
     Position  x,y, xRoot,yRoot, X,Y;
     widgetAndOffset *wao;

     DBUG_ENTER("positionCallbackProc");
     WAFE_UNUSED(callData);

     wao = (widgetAndOffset *)clientData;
     XtVaGetValues(wao->widget,
                   XtNx, &x,
                   XtNy, &y,
                   NULL);
     XtTranslateCoords(wafeTopLevel, x, y, &xRoot, &yRoot);
     X = xRoot+(wao->xoffset);
     Y = yRoot+(wao->yoffset);
     XtVaSetValues(w, XtNx, gt0(X), XtNy, gt0(Y), NULL);

     DBUG_VOID_RETURN;
     }


void
wafePositionCursorCallbackProc(w, clientData, callData)
Widget     w;
XtPointer  clientData, callData;
     {
     Window root, child;
     int  x, y, win_x,win_y;
     unsigned int mask;
     int offset = (int)clientData;
     Position X,Y;

     DBUG_ENTER("positionCursorCallbackProc");
     WAFE_UNUSED(callData);

     (void) XQueryPointer(XtDisplay(w), XtWindow(wafeTopLevel),
                         &root, &child,
                         &x, &y, &win_x, &win_y,
                         &mask);

     if (offset)
         {
	 X = x-offset;
	 Y = y-offset;
	 XtVaSetValues(w, XtNx, gt0(X), XtNy, gt0(Y), NULL);
         }
      else
	 {
	 Boolean mappedWhenManaged;
	 Dimension width, height;
	 Screen *screen = XtScreen(w);

	 XtVaGetValues(w, XtNmappedWhenManaged, &mappedWhenManaged, NULL);
	 if (mappedWhenManaged)
	     XtVaSetValues(w, XtNmappedWhenManaged, False, NULL);

	 XtRealizeWidget(w);
	 XtVaGetValues(w, XtNwidth, &width,
                          XtNheight, &height,
                          NULL);
	 X = x-width/2;
	 Y = y-height/2;

	 if ((int)(X+width) > WidthOfScreen(screen))
	   X = WidthOfScreen(screen) - width;
	 if ((int)(Y+height) > HeightOfScreen(screen))
	   Y = HeightOfScreen(screen) - height;

	 if (X < 0) X = 0;
	 if (Y < 0) Y = 0;

	 XtVaSetValues(w, XtNx, X, XtNy, Y,
		       XtNmappedWhenManaged, mappedWhenManaged,
		       NULL);
	 }

     DBUG_VOID_RETURN;
     }

/*
 *  FUNCTION: wafeCallbackCmd
 *  Arguments:
 *            Widget - Widget whose attribute is to be set
 *            char * - Name of attribute
 *            proc   - Name of callback procedure to use
 *            arg    - clientData argument
 *
 *  This function is called by the genereated callback procedure (XtGen) and
 *  cares for the special callData handling with list and scrollbar Widgets as
 *  well as for the clientData argument of the XtPopdown callback (a so
 *  called XtPopdownID).
 */

int
wafeCallbackCmd(argc, argv, w, proc)
int            argc;
char         **argv;
Widget         w;
XtCallbackProc proc;
    {
    Widget pop;
    String cbAttribute = argv[2];
    String arg = argv[4];

    if (proc == wafePositionCursorCallbackProc)   /* Additional argument is offset... */
	{
	int offset;

	if (!sscanf(arg, "%d", &offset))
	    return wafeConvError(argc, argv, 4, NULL, "int");

	XtAddCallback(w, cbAttribute, wafePositionCursorCallbackProc,
		      (XtPointer)offset);
	}
    else
    if (proc == wafePositionCallbackProc)   /* Additional argument is widget/offset */
	{
	widgetAndOffset *wao;
	char *colon, *slash;

	wao = (widgetAndOffset *)XtMalloc(sizeof(widgetAndOffset));
	if ((colon = (char*)strrchr(arg,':')))
	    {
	    *colon = '\0'; colon ++;
	    if ((slash = (char*)strrchr(colon,'/')))
		{
		*slash = '\0'; slash ++;
		if (!sscanf(slash, "%d", &(wao->yoffset)))
		    return wafeConvError(argc, argv, 4, NULL, 
					 "Widget:xoffset/yoffset");
		}

	    if (!sscanf(colon, "%d", &(wao->xoffset)))
		return wafeConvError(argc, argv, 4,NULL, 
				     "Widget:xoffset/yoffset");
	    if (!slash) wao->yoffset = wao->xoffset;
	    }
	else
	    {
	    wao->xoffset = 50;
	    wao->yoffset = 50;
	    }
	if (!(wao->widget = name2Widget(arg)))
	    return wafeConvError(argc, argv, 4,NULL, "Widget:xoffset/yoffset");

	XtAddCallback(w, cbAttribute, wafePositionCallbackProc, (XtPointer)wao);
	}
    else
    if (proc == XtCallbackPopdown)   /* Build up XtPopdownID... */
	{
	XtPopdownID      pdPtr;
	pdPtr = (XtPopdownID)XtMalloc(sizeof(XtPopdownIDRec));

	if (!(pdPtr->shell_widget = name2Widget(strtok(arg, wafe_SPACE))))
	    return wafeConvError(argc, argv, 4,NULL, XtRWidget);

	if (!(pdPtr->enable_widget = name2Widget(strtok(NULL, wafe_SPACE))))
	    return wafeConvError(argc, argv, 4,NULL, XtRWidget);

	XtAddCallback(w, cbAttribute, XtCallbackPopdown, pdPtr);
	}
    else if (proc == wafeExecCallbackProc)
        {
	XtAddCallback(w, cbAttribute, proc, arg);
        }
    else
	{
	if (!(pop = name2Widget(arg)))  /* For all other callbacks: arg is a Widget */
	    return wafeConvError(argc, argv, 4,NULL, XtRWidget);

	XtAddCallback(w, cbAttribute, proc, (XtPointer)pop);
	}
    return TCL_OK;
    }


