#> The XmGraph Widget requires Motif 1.1 or newer.

$PACKAGE = "XMGRAPH";

~handles 
	XMGRAPH

#define XmGraphArcDir unsigned char
#define XmGraphArcDrawMode unsigned char
#define XmGraphCapStyle unsigned char
#define XmGraphAutoLayoutType unsigned char

~require
XmGraph.inc
	

#define ARC(w) (XmArcWidget)(w)

#> The 'XmArc' widget class is to be used in cooperation with the
#> XmGraph widget class. An arc may be undirected, directed or
#> bidirected.

~widgetClass
XmArc
	include <Graph.h>
	include <Arc.h>
	arcEdited f WidgetID: \
	    (WidgetID)((XmGraphCallbackStruct *)callData)->old_from # old from
	arcEdited t WidgetID: \
	    (WidgetID)((XmGraphCallbackStruct *)callData)->old_to # old to
	arcEdited F WidgetID: \
	    (WidgetID)((XmGraphCallbackStruct *)callData)->new_from # new from
	arcEdited T WidgetID: \
	    (WidgetID)((XmGraphCallbackStruct *)callData)->new_to # new to


#> The command 'XmArcGetPos' returns the coordinates of the specified
#> widget in the variables given in argument 2 to 4.

void
XmArcGetPos
	in: ARC(XmArcWidget)	# name of arc Widget
	out: Position		# out: from x-coordiante 
	out: Position		# out: from y-corrdinate
	out: Position		# out: to x-coordinate
	out: Position		# out: to y-coordinate

#> The 'XmGraph' widget class provides the application developer with
#> the ability to display any group of widgets as a graph, with each
#> widget representing a node. The graph can be disconnected, as well
#> as contain cycles.  The arcs used to connect the nodes are
#> instances of an XmArc widget, developed specifically for use with
#> the XmGraph widget. An arc may be undirected, directed or
#> bidirected. Note that the XmGraph widget does not understand the
#> semantics of arc direction, ie. for layout and editing purposes, an
#> arc will always have a parent and a child regardless of its
#> direction.
#> 
#> The XmGraph widget has the ability to arrange all nodes either
#> horizontally or vertically according to an internal layout
#> algorithm, and supports an edit mode in which arcs and nodes may be
#> interactively repositioned as well as created, and a read-only mode
#> in which all events are passed directly to the children of the
#> Graph widget.  In edit mode, the XmGraph takes over all device
#> events for editing commands.

~widgetClass
XmGraph
	include <Graph.h>
	rConv XmRArcDirection XmGraphArcDir toString \
	      "directed","bidirected","undirected" \
	      XmDIRECTED,XmBIDIRECTED,XmUNDIRECTED 
	rConv XmRArcDrawMode XmGraphArcDrawMode toString \
	      "position_fixed","position_relative" \
	      XmPOSITION_FIXED,XmPOSITION_RELATIVE 
	rConv XmRCapStyle XmGraphCapStyle toString \
	      "capNotLast","capButt","capRound","capProjecting" \
	       XmCapNotLast,XmCapButt,XmCapRound,XmCapProjecting
	rConv  XmRAutoLayoutType XmGraphAutoLayoutType toString \
	      "never","always","arcs_only","nodes_only","partial" \
	       XmNEVER,XmALWAYS,XmARCS_ONLY,XmNODES_ONLY,XmPARTIAL
	newArc|newNode|arcMoved|nodeMoved|defaultAction|selectNode|selectArc|deselect|selectSubgraph N WidgetList: \
		((XmGraphCallbackStruct *)callData)->num_selected_widgets, \
		((XmGraphCallbackStruct *)callData)->selected_widgets \
			 # selected Nodes
	newArc|newNode|arcMoved|nodeMoved|defaultAction|selectNode|selectArc|deselect|selectSubgraph A WidgetList: \
		((XmGraphCallbackStruct *)callData)->num_selected_arcs, \
		((XmGraphCallbackStruct *)callData)->selected_arcs \
			 # selected Arcs
	newArc|newNode|arcMoved|defaultAction|selectNode|selectArc|deselect|selectSubgraph I WidgetID: \
		(WidgetID)((XmGraphCallbackStruct *)callData)->widget \
			 # child widgetID
	arcMoved f WidgetID: \
		(WidgetID)((XmGraphCallbackStruct *)callData)->old_from \
		         # old from widgetID
	arcMoved t WidgetID: \
		(WidgetID)((XmGraphCallbackStruct *)callData)->old_to 
                         # old to widgetID
	arcMoved F WidgetID: \
		(WidgetID)((XmGraphCallbackStruct *)callData)->new_from \
		         # new from widgetID
	arcMoved T WidgetID: \
		(WidgetID)((XmGraphCallbackStruct *)callData)->new_to \
		         # new to widgetID

#> An 'XmScrolledGraph' widget is an 'XmGraph' wdiget contained in an
#> 'XmScrolledWindow'. The XmScrolledGraph uses uses the AUTOMATIC
#> scrollbar mode of the XmScrolledWindow. The Graph widget does
#> extensive optimizations based on the existence of the
#> ScrolledWindow's clipWindow when created via XmScrolledGraph.

~pseudoWidgetClass
XmScrolledGraph
	className XmGraph
	createCmd XmCreateScrolledGraph

#> The command 'XmGraphInsertRoots' adds to the user roots list of
#> graph the specified nodes

void
XmGraphInsertRoots
	in: XmGraphWidget   # XmGraphWidget
	in: [Widget]        # nodes
        const: argc-2

#> The command 'XmGraphDestroyAllArcs' destroys all arcs of the
#> specified XmGraph widget.

void 
XmGraphDestroyAllArcs
        in: XmGraphWidget   # XmGraphWidget

#> The command 'XmGraphDestroyAllNodes' destroys all arcs of the
#> specified XmGraph widget.

void
XmGraphDestroyAllNodes
        in: XmGraphWidget   # XmGraphWidget

#> The function 'XmGraphGetArcsBetweenNodes' returns a list of all
#> XmArc widgets (in form of widget IDs) that extend from the widget
#> given in the 2nd argument to the widget specified in the third
#> argument. if no such arc exists, an empty list is returned.

(String) DString
getArcs vulgo XmGraphGetArcsBetweenNodes
        in: XmGraphWidget   # XmGraph Widget
        in: Widget          # from node 
        in: Widget          # to node


#> The command 'XmGraphCenterAroundWidget' places the specified node
#> (2nd argument) of a scrolled XmGraph widget to the center of the
#> displayed area

void 
XmGraphCenterAroundWidget
	in: XmGraphWidget   # XmGraph Widget
	in: Widget 	    # node