#> The Commands described in this section are these introduced by
#> Motif Version 2.0. Note that in Wafe versions compiled with Motif 2.0
#> the commands from sections Motif 1.1 to 2.0 are available.

$PACKAGE = "MOTIF20";

#include <X11/Shell.h>
#include <Xm/RepType.h>
#include <Xm/Text.h>
#include <Xm/Scale.h>
#include <Xm/ScrolledW.h>

~handles 
	MOTIF20

~require
motif20.inc
	quark XmRSet
        quark XmRDynamicPixmap

# modifyVerify and valueChanged callback not handled bidirectionally yet for
# XmCSText, XmComboBox

~widgetClass 
XmCSText
	include <Xm/CSText.h>
        nsConv Widget XmNsource NULL NULL \
		wafeLongToString XtFree wafeStringToLong NULL
        losingFocus|modifyVerify|motionVerify i XmTextPosition: \
                ((XmCSTextVerifyCallbackStruct *)callData)->currInsert \
			# position of insert cursor
        losingFocus|modifyVerify|motionVerify n XmTextPosition: \
                ((XmCSTextVerifyCallbackStruct *)callData)->newInsert \
			# new position of insert cursor
        losingFocus|modifyVerify f XmTextPosition: \
                ((XmCSTextVerifyCallbackStruct *)callData)->startPos \
			# startPos (from)
        losingFocus|modifyVerify t XmTextPosition: \
                ((XmCSTextVerifyCallbackStruct *)callData)-> endPos \
			# endPos (to)
        modifyVerify s EscapedXmString: \
                ((XmCSTextVerifyCallbackStruct *)callData)->text \
			# text

void
XmCSTextReplace
	in: XmCSTextWidget 	# Compound String Text widget
	in: XmTextPosition	# from character position
	in: XmTextPosition	# to character position
	in: XmString 		# insert string

~pseudoWidgetClass 
XmScrolledCSText
	className XmCSText
	createCmd XmCreateScrolledCSText


~widgetClass 
XmComboBox
	include <Xm/ComboBox.h>
        selection s EscapedXmString: \
	    ((XmComboBoxCallbackStruct *)callData)->item_or_text # item or text
        selection p int: \
	    ((XmComboBoxCallbackStruct *)callData)->item_position # position


~widgetClass 
XmContainer
	include <Xm/Container.h>
        outlineChanged a WidgetID: \
	    (WidgetID)((XmContainerOutlineCallbackStruct *)callData)->item \
	                # widget id of affected item 
	defaultAction|selection S WidgetList: \
		((XmContainerSelectCallbackStruct *)callData)->selected_item_count, \
		((XmContainerSelectCallbackStruct *)callData)->selected_items \
			# widget IDs of selected items


#> The function 'XmContainerGetItemChildren' returns the list of
#> widget IDs of the children of the specified widget (2nd argument)
#> in the XmContainer widget (1st argument). A child is a widget
#> having its 'entryParent' resource set to the specified widget. If
#> the specified widget has no children, an empty string is returned.

(String) DString
containerGetItemChildren vulgo XmContainerGetItemChildren
	in: XmContainerWidget   # XmContainer widget
	in: Widget              # parent widget

#> The procedure 'XmContainerRelayout' forces repositioning of all
#> items in the specified Container widget according to the item's
#> positionIndex and entryParent resources.

void
XmContainerRelayout
	in: XmContainerWidget   # XmContainer widget

#> The procedure 'XmContainerReorder' reorders the specified widgets
#> according to their positionIndex constraint resource. If the
#> 'layoutType' resource of the container widget is OUTLINE or DETAIL,
#> a re-layout of all items will be forced.

void
containerReorder vulgo XmContainerReorder
	in: XmContainerWidget   # XmContainer widget
        in: String              # widget list

#define xmIconGadgetWidgetClass xmIconGadgetClass

~widgetClass 
XmIconGadget
	include <Xm/IconG.h>

~widgetClass 
XmNotebook
	include <Xm/Notebook.h>
        pageChanged p int: \
	    ((XmNotebookCallbackStruct *)callData)->page_number \
	                # page number of current page
        pageChanged i WidgetID: \
	    (WidgetID)((XmNotebookCallbackStruct *)callData)->page_widget \
	                # widget id of current page
        pageChanged P int: \
	    ((XmNotebookCallbackStruct *)callData)->prev_page_number \
	                # page number of previous page
        pageChanged I WidgetID: \
	    (WidgetID)((XmNotebookCallbackStruct *)callData)->prev_page_widget \
	                # widget id of previous page

~widgetClass 
XmSpinBox
	include <Xm/SpinB.h>
	modifyVerify|valueChanged s EscapedXmString: \
		((XmSpinBoxCallbackStruct *)callData)->value 	# string value
	modifyVerify|valueChanged a WidgetID: \
		(WidgetID) ((XmSpinBoxCallbackStruct *)callData)->widget \
			# widgetID of affected widget
	modifyVerify|valueChanged p int: \
		((XmSpinBoxCallbackStruct *)callData)->position \
			# position
	modifyVerify|valueChanged b int: \
		((XmSpinBoxCallbackStruct *)callData)->crossed_boundary \
			# crossed boundary

#> The command 'XmGetXmScreen' returns the widgetID of the screen
#> object associated with the specified widget.

WidgetID (WidgetID)
XmGetXmScreen
       in: XtScreen(Widget)     # widget to determine screen
