/* Copyright (C) 1992 by Gustaf Neumann, Stefan Nusser

 *      Wirtschaftsuniversitaet Wien, 
 *      Abteilung fuer Wirtschaftsinformatik
 *      Augasse 2-6, 
 *      A-1090 Vienna, Austria
 *      neumann@wu-wien.ac.at, nusser@wu-wien.ac.at
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided
 * that the above copyright notice appears in all copies and that both that
 * copyright notice and this permission notice appear in all supporting
 * documentation.  This software is provided "as is" without expressed or
 * implied warranty.
 * 
 */

/*
 * This file was generated by genc.
 * Be aware that modifications of this file will be lost,
 * when genc is executed!

Creation: Fri Jul 14 00:04:24 EDT 1995 on mohegan
Author: genc
Version: 1.0.13

 */

#define MOTIF12_C
#include <wafe.h>
#ifdef MOTIF12
#include <Xm/DragDrop.h>
#include <Xm/DragDrop.h>
 extern XrmQuark qdragProc;
 extern XrmQuark qdropProc;
 extern XrmQuark qtransferProc;
 extern XrmQuark qconvertProc;

/* make emcas happy -*-C-*-  make emacs happy */

#include <ctype.h>
#include <Xm/AtomMgr.h>

#include <Xm/DragDrop.h>

static Widget currentDragContext;

static void
callbackProc(w, clientData, callData)
Widget w;
XtPointer clientData;
XtPointer callData;
    {
    XmAnyCallbackStruct *cbs = (XmAnyCallbackStruct *)callData;

    DBUG_ENTER("callbackProc");
    WAFE_UNUSED(clientData);

    if (cbs->reason == XmCR_DROP_MESSAGE)
	{
	XmDropProcCallbackStruct *drop_cbs =
	  (XmDropProcCallbackStruct *)callData;
	char *cmd = wafeMMgetValue(w, qdropProc, NULL, False);
	wafeExecCallbackProc(drop_cbs->dragContext, (XtPointer)cmd, callData);
	}
    DBUG_VOID_RETURN;
    }


static Boolean
convertSelectionIncrProc(w, selection, target, type, value, length, format,
			 max_length, client_data, request_id)
Widget        w;
Atom          *selection;
Atom          *target;
Atom          *type;
XtPointer     *value;
unsigned long *length;
int           *format;
unsigned long *max_length;
XtPointer     client_data;
XtRequestId   *request_id;
    {
    Boolean result = True;
    DBUG_ENTER("convertSelectionIncrProc");

    WAFE_UNUSED(max_length);
    WAFE_UNUSED(client_data);
    WAFE_UNUSED(request_id);

    if (XtClass(w) == xmDragContextClass)
	{
	Display *dpy       = XtDisplay(w);
	Atom COMPOUND_TEXT = XmInternAtom(dpy, "COMPOUND_TEXT", False);
	Atom DELETE        = XmInternAtom(dpy, "DELETE", False);
	Atom TARGETS       = XmInternAtom(dpy, "TARGETS", False);
	char *cd, *cmd, *targetName = NULL;
	
	if (!(*selection == XmInternAtom(dpy, "_MOTIF_DROP", False)))
	    DBUG_RETURN(False);  /* it looks as if this was not for us! */

	/* if there is a command for the convert procedure registered,
	   call it and provide the target as callData; this is necessary
	   for the DELETE target in DROP_MOVE command
	 */
	if ((cmd = wafeMMgetValue(w, qconvertProc, NULL, False)))
	    {
	    targetName = XGetAtomName(dpy,*target);
	    wafeExecCallbackProc(w, (XtPointer)cmd, targetName);
	    }
	    
	if (*target == COMPOUND_TEXT)
	    {
	    XmString tmpString;

	    /* we pass the text via the clientData resource */
	    XtVaGetValues(w, XmNclientData, &cd, NULL);
	    
	    if (!cd)
		{
		wafeWarn("convertSelectionIncrProc", "invalid clientData",
			 NULL,NULL,NULL);
		if (targetName) XFree(targetName);
		DBUG_RETURN(False);  
		}

	    tmpString = wafeCvtStringToXmString(cd);
	    /* it is wierd that the returned compound text is of type
               char* since - as it looks to me - CT can have inbedded
               nulls, which will cause truncations on strlen etc 
             */
	    *type = *target;
	    *value = (XtPointer)XmCvtXmStringToCT(tmpString);
	    *length = (unsigned long)(strlen(*value)+1);

	    XmStringFree(tmpString);
	    *format = 8;
	    }
	else 
	if (*target == DELETE)
	    {
	    if (!cmd) 
		wafeWarn("convertSelectionIncrProc", 
			 "no convertProc registered for a DROP_MOVE operation",
			 NULL,NULL,NULL);

	    *type = XmInternAtom(dpy, wafe_NULL, False);
	    *value = NULL;
	    *length = 0;
	    *format = 8;
	    }
	else 
        if (*target == TARGETS)  /* This target is required by ICCC */
	    {
	    int target_count = 0;
	    Atom *targs = (Atom *)XtMalloc((unsigned) (6 * sizeof(Atom)));
	    *value = (XtPointer) targs;

	    /* if targets are added, increase the constant in malloc! */
	    *targs++ = COMPOUND_TEXT;
	    target_count++;
	    *targs++ = DELETE;
	    target_count++;
	    *targs++ = TARGETS;
	    target_count++;
	    *targs++ = XmInternAtom(dpy, "MULTIPLE", False);
	    target_count++;  /* supported in the Intrinsics */
	    *targs++ = XmInternAtom(dpy, "TIMESTAMP", False);
	    target_count++; /* supported in the Intrinsics */
	    
	    *type = XA_ATOM;
	    *length = (target_count * sizeof(Atom)) >> 2;
	    *format = 32;
            }
	else
	    {
	    if (!targetName) targetName = XGetAtomName(dpy,*target);
	    wafeWarn("convertSelectionIncrProc","unknown target %s",
		     targetName,NULL,NULL);
	    result = False;
	    }

	if (targetName) XFree(targetName);
	}
    DBUG_RETURN(result);  
    }

static void
selectionCallbackProc (w, closure, selection, type, value, length, format)
Widget          w;
XtPointer       closure;
Atom*           selection;
Atom*           type;
XtPointer       value;
unsigned long*  length;
int*            format;
    {
    DBUG_ENTER("selectionCallbackProc");

    WAFE_UNUSED(closure);
    WAFE_UNUSED(format);

    if (XtClass(w) == xmDropTransferObjectClass)
	{
	dropTransferCallbackStruct dtCbs;
	Atom COMPOUND_TEXT, TEXT, FILE_NAME, A_NULL;
	XmDropTransferEntryRec *dropTransferEntries;
	char *cmd;
	Display *dpy;

	if (!currentDragContext)
	    DBUG_VOID_RETURN;   /* to avoid surprises... */
	
	dpy = XtDisplay(currentDragContext);
	if (! *selection == XmInternAtom(dpy, "_MOTIF_DROP", False))
	    DBUG_VOID_RETURN;   /* to avoid surprises... */

	if (!(cmd = wafeMMgetValue(w, qtransferProc, NULL, False)))
	    {
	    wafeWarn("selectionCallbackProc","no transferProc registered",
		     NULL,NULL,NULL);
	    DBUG_VOID_RETURN;
	    }

	XtVaGetValues(w, XmNdropTransfers,&dropTransferEntries, NULL);
	
	COMPOUND_TEXT = XInternAtom(dpy,"COMPOUND_TEXT", False);
	TEXT          = XInternAtom(dpy,"TEXT", False);
	FILE_NAME     = XInternAtom(dpy,"FILE_NAME", False);
	A_NULL        = XInternAtom(dpy, wafe_NULL, False);
	dtCbs.dest    = (String)dropTransferEntries->client_data;

	if (*type == COMPOUND_TEXT)
	    {
	    wafeStringStruct   ws_struct;
	    wafeString         ws = &ws_struct;
	    XmString t = XmCvtCTToXmString(value);
	    wafeStringInit(ws);
	    wafeCvtXmString2String(ws,t,True);
	    dtCbs.value = wafeStringValue(ws);
/*
	    fprintf(stderr,"+ in callbackProc, transferProc, widget = %p <%s> cmd=<%s>, <%s> <%s>\n",
		    w,XtName(w),cmd+sizeof(XrmQuark),dtCbs.value,value);
 */
	    wafeExecCallbackProc(w, (XtPointer)cmd, &dtCbs);
	    wafeStringClear(ws);
	    XmStringFree(t);
	    }
	else 
	if ((*type == XA_STRING) || (*type == TEXT) || (*type == FILE_NAME))
	    {
	    dtCbs.value = XtMalloc(*length + 1);
	    memcpy((char *)dtCbs.value, (char *)value, *length);
	    *((char*)(dtCbs.value) + *length) = '\0';
 	    }
	else
	if (*type == XT_CONVERT_FAIL)
	    wafeWarn("selectionCallbackProc","conversion failed",
		     NULL,NULL,NULL);
	else 
	if (*type != A_NULL && (*type != 0))
	    {
	    char *p;
            p = XGetAtomName(dpy,*type);
	    wafeWarn("selectionCallbackProc", "unknown type %s",
		     p,NULL,NULL);
	    if (p) XFree(p);
	    }
	}
    }


Boolean
CvtStringToCallbackProc(dpy, args, num_args, fromVal, toVal,
		    converter_data)
Display *dpy;
XrmValue *args;
Cardinal *num_args;
XrmValue *fromVal;
XrmValue *toVal;
XtPointer *converter_data;
    {
    char *charp = XtMalloc(strlen(fromVal->addr)+1+sizeof(XrmQuark));

    WAFE_UNUSED(dpy);
    WAFE_UNUSED(args);
    WAFE_UNUSED(num_args);
    WAFE_UNUSED(converter_data);

    *(XrmQuark *)charp = wafeCurrentAttrib;
    strcpy((char *)charp + sizeof(XrmQuark), (char *)fromVal->addr);
    wafeMMreplace(NULL, NULL, wafeCurrentAttrib, (char *)charp, XtFree);
    WAFE_CONVERSION_DONE(XtCallbackProc, callbackProc);
    }


Boolean
CvtStringToDragOperations(dpy, args, num_args, fromVal, toVal, converter_data)
Display *dpy;
XrmValue *args;
Cardinal *num_args;
XrmValue *fromVal;
XrmValue *toVal;
XtPointer *converter_data;
    {
    unsigned char result = '\0';
    char *p=strtok(fromVal->addr,"|");

    WAFE_UNUSED(dpy);
    WAFE_UNUSED(args);
    WAFE_UNUSED(num_args);
    WAFE_UNUSED(converter_data);

    do
	{
	if (!strcmp("DROP_COPY",p))
	    result |= XmDROP_COPY;
	else 
	if (!strcmp("DROP_MOVE",p))
	    result |= XmDROP_MOVE;
	else 
	if (!strcmp("DROP_LINK",p))
	    result |= XmDROP_LINK;
	else 
	if (!strcmp("DROP_NOOP",p))
	    result = XmDROP_NOOP;
	else
	    return False;
	}
    while ((p = strtok(NULL,"|")));
    WAFE_CONVERSION_DONE(unsigned char, result);
    }

Boolean
CvtStringToTransferStatus(dpy, args, num_args, fromVal, toVal, converter_data)
Display *dpy;
XrmValue *args;
Cardinal *num_args;
XrmValue *fromVal;
XrmValue *toVal;
XtPointer *converter_data;
    {
    unsigned char result = '\0';

    WAFE_UNUSED(dpy);
    WAFE_UNUSED(args);
    WAFE_UNUSED(num_args);
    WAFE_UNUSED(converter_data);

    if (!strcmp("TRANSFER_SUCCESS",fromVal->addr))
	result = XmTRANSFER_SUCCESS;
    else 
    if (!strcmp("TRANSFER_FAILURE",fromVal->addr))
	result = XmTRANSFER_FAILURE;
    else
	return False;

    WAFE_CONVERSION_DONE(unsigned char, result);
    }


Boolean
CvtStringToConvertSelectionIncrProc(dpy, args, num_args, fromVal, toVal,
		    converter_data)
Display *dpy;
XrmValue *args;
Cardinal *num_args;
XrmValue *fromVal;
XrmValue *toVal;
XtPointer *converter_data;
    {
    char *charp = XtMalloc(strlen(fromVal->addr)+1+sizeof(XrmQuark));

    WAFE_UNUSED(dpy);
    WAFE_UNUSED(args);
    WAFE_UNUSED(num_args);
    WAFE_UNUSED(converter_data);

    *(XrmQuark *)charp = wafeCurrentAttrib;
    strcpy((char *)charp + sizeof(XrmQuark), (char *)fromVal->addr);
    wafeMMreplace(NULL, NULL, wafeCurrentAttrib,(char *)charp, XtFree);
    WAFE_CONVERSION_DONE(XtConvertSelectionIncrProc, convertSelectionIncrProc);
    }


Boolean
CvtStringToSelectionCallbackProc(dpy, args, num_args, fromVal, toVal,
		    converter_data)
Display *dpy;
XrmValue *args;
Cardinal *num_args;
XrmValue *fromVal;
XrmValue *toVal;
XtPointer *converter_data;
    {
    char *charp = XtMalloc(strlen(fromVal->addr)+1+sizeof(XrmQuark));

    WAFE_UNUSED(dpy);
    WAFE_UNUSED(args);
    WAFE_UNUSED(num_args);
    WAFE_UNUSED(converter_data);

    *(XrmQuark *)charp = wafeCurrentAttrib;
    strcpy((char *)charp + sizeof(XrmQuark), (char *)fromVal->addr);
    wafeMMreplace(NULL, NULL, wafeCurrentAttrib,(char *)charp, XtFree);
    WAFE_CONVERSION_DONE(XtSelectionCallbackProc, selectionCallbackProc);
    }

static XmDropTransferEntryRec *
string2transferEntryRec(string,dpy)
_Xconst String string;
Display *dpy;
    {
    char **argv, **p, **innerArgv;
    int argc, count, n;
    XmDropTransferEntryRec *entries, *dropRecs;
    
    DBUG_ENTER("string2transferEntryRec");

    if (Tcl_SplitList(wafeInterpreter, string, &argc, &argv) == TCL_ERROR)
	{
	wafeWarn("CvtToDropTransfer", wafeInterpreter->result,
		 NULL,NULL,NULL);
	DBUG_RETURN((XmDropTransferEntryRec *)NULL);
	}
    count = argc;

    dropRecs = entries = 
      (XmDropTransferEntryRec*)XtMalloc(sizeof(XmDropTransferEntryRec)*count);
    for (p = argv; count>0; count--,p++)
	{
	if (Tcl_SplitList(wafeInterpreter, *p, &n, &innerArgv) == TCL_ERROR)
	    {
	    wafeWarn("CvtToDropTransferArg", wafeInterpreter->result,
		     NULL,NULL,NULL);
	    DBUG_RETURN((XmDropTransferEntryRec *)NULL);
	    }
	if (n != 2)
	    {
	    wafeWarn("CvtToDropTransferArg", 
		    "DropTransferRec should have two elements",
		     NULL,NULL,NULL);
	    XtFree((char *)argv);
	    DBUG_RETURN((XmDropTransferEntryRec *)NULL);
	    }
	entries->target = XInternAtom(dpy, innerArgv[0], False);
	entries->client_data = 
	  (XtPointer)wafeCvtName2Widget(innerArgv[1],True,NULL);
	entries++;
	XtFree((char *)innerArgv);
	}
    XtFree((char *)argv);
    DBUG_RETURN(dropRecs);
    }


Boolean
CvtStringToDropTransfers(dpy, args, num_args, fromVal, toVal,
		    converter_data)
Display *dpy;
XrmValue *args;
Cardinal *num_args;
XrmValue *fromVal;
XrmValue *toVal;
XtPointer *converter_data;
    {
    XmDropTransferEntryRec *dropRecs;

    WAFE_UNUSED(args);
    WAFE_UNUSED(num_args);
    WAFE_UNUSED(converter_data);

    if (!(dropRecs = string2transferEntryRec(fromVal->addr,dpy)))
	return False;
    
    wafeMMreplace(NULL, NULL, wafeCurrentAttrib, (char *)dropRecs, XtFree);
    WAFE_CONVERSION_DONE(XmDropTransferEntryRec*, dropRecs);
    }


static void
CBfreeAttribs(w, client_data, call_data)
Widget w;
caddr_t client_data;
caddr_t call_data;
    {
    WAFE_UNUSED(client_data);
    WAFE_UNUSED(call_data);

    (void)wafeMMfreeGarbage(w);
    }

static int cmd_XmDropSiteRegister();
static int cmd_XmDropSiteUpdate();
static int cmd_XmDropSiteUnregister();
static int cmd_XmDropSiteStartUpdate();
static int cmd_XmDropSiteEndUpdate();
static int cmd_XmDropTransferStart();
static int cmd_XmDragStart();
#include <X11/Shell.h>
#include <Xm/RepType.h>

#define convertSpecialResources(command,w,class,argc,argv) {ArgList           args; int               numArgs; XtInitializeWidgetClass(class); if (wafeConvert(ParentWidget(w), class, argv, &argc, &args, &numArgs, w)) { command(w, args, numArgs); wafeCurrentAttribList = NULL; XtFree((String)args); } }

#define createDnDWidget4(c,w,x,y) c(w,args,numArgs)
#define createDnDWidget5(c,w,e,x,y) c(w,e,args,numArgs)






static _Xconst Proc_signature cmds[] = {
     { "XmDropSiteRegister", cmd_XmDropSiteRegister },
     { "XmDropSiteUpdate", cmd_XmDropSiteUpdate },
     { "XmDropSiteUnregister", cmd_XmDropSiteUnregister },
     { "XmDropSiteStartUpdate", cmd_XmDropSiteStartUpdate },
     { "XmDropSiteEndUpdate", cmd_XmDropSiteEndUpdate },
     { "XmDropTransferStart", cmd_XmDropTransferStart },
     { "XmDragStart", cmd_XmDragStart },
    { NULL, NULL }
    };

static WidgetCreate_signature wccs[] = {
    {"XmDragIcon",NULL,NULL,False,False,XtInitializeWidgetClass},
    {"XmDropSiteManager",NULL,NULL,False,False,XtInitializeWidgetClass},
    {"XmDragContext",NULL,NULL,False,False,XtInitializeWidgetClass},
    {"XmDropTransfer",NULL,NULL,False,False,XtInitializeWidgetClass},
    { NULL,NULL,NULL,False,False,NULL }
    };

static _Xconst String pkgs[] = {
     "MOTIF12",
    NULL
     };



#define WS_XmDragIcon wccs[0].name
#define WS_XmDropSiteManager wccs[1].name
#define WS_XmDragContext wccs[2].name
#define WS_XmDropTransfer wccs[3].name
/* 
 * void
 * convertSpecialResources vulgo XmDropSiteRegister 
 * 	const: XmDropSiteRegister
 * 	in: Widget		# Widget to be registered
 * 	const: xmDropSiteManagerObjectClass
 * 	in: [args avp]          # drop site resources
 */

static int 
cmd_XmDropSiteRegister(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     Boolean freeArgv = False;
     char **argvArg;

     DBUG_ENTER(argv[0]);  
     WAFE_UNUSED(clientData);
     WAFE_UNUSED(comInterpreter);

     if (argc < 3) 
	 DBUG_RETURN(wafeArgcError(argc,argv,wafeStrings[31],2));

     if (!(localVar1 = (Widget) name2Widget(argv[1])))
         DBUG_RETURN(wafeConvError(argc, argv, 1, NULL, XtRWidget));

     argc -= 2;
     argvArg = &argv[2];
     if (argc == 1)
        {
        if (wafeMergeArguments(argv[2],argv[0],&argc,&argvArg))
           freeArgv = True;
        else 
           DBUG_RETURN (TCL_ERROR);
        }
     if (argc%2)
        {
        if (freeArgv) XtFree((char*)argvArg);
        DBUG_RETURN(wafeArgcError(argc+2, argv,"even number of attribute value pairs such as 2 or ",4));
        }

     convertSpecialResources(XmDropSiteRegister,localVar1,xmDropSiteManagerObjectClass,argc,argvArg);
     if (freeArgv) XtFree((char *)argvArg);

     DBUG_RETURN (TCL_OK);
     }


/* 
 * void
 * convertSpecialResources vulgo XmDropSiteUpdate
 * 	const: XmDropSiteUpdate
 * 	in: Widget		# Drop site to be modified
 * 	const: xmDropSiteManagerObjectClass
 * 	in: [args avp]          # drop site resources
 */

static int 
cmd_XmDropSiteUpdate(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     Boolean freeArgv = False;
     char **argvArg;

     DBUG_ENTER(argv[0]);  
     WAFE_UNUSED(clientData);
     WAFE_UNUSED(comInterpreter);

     if (argc < 3) 
	 DBUG_RETURN(wafeArgcError(argc,argv,wafeStrings[31],2));

     if (!(localVar1 = (Widget) name2Widget(argv[1])))
         DBUG_RETURN(wafeConvError(argc, argv, 1, NULL, XtRWidget));

     argc -= 2;
     argvArg = &argv[2];
     if (argc == 1)
        {
        if (wafeMergeArguments(argv[2],argv[0],&argc,&argvArg))
           freeArgv = True;
        else 
           DBUG_RETURN (TCL_ERROR);
        }
     if (argc%2)
        {
        if (freeArgv) XtFree((char*)argvArg);
        DBUG_RETURN(wafeArgcError(argc+2, argv,"even number of attribute value pairs such as 2 or ",4));
        }

     convertSpecialResources(XmDropSiteUpdate,localVar1,xmDropSiteManagerObjectClass,argc,argvArg);
     if (freeArgv) XtFree((char *)argvArg);

     DBUG_RETURN (TCL_OK);
     }


/* 
 * void
 * XmDropSiteUnregister
 * 	in: Widget		# Widget to be unregistered
 */

static int 
cmd_XmDropSiteUnregister(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;

     DBUG_ENTER(argv[0]);  
     WAFE_UNUSED(clientData);
     WAFE_UNUSED(comInterpreter);

     if (argc != 2) 
	 DBUG_RETURN(wafeArgcError(argc,argv,wafeStrings[2],1));

     if (!(localVar1 = (Widget) name2Widget(argv[1])))
         DBUG_RETURN(wafeConvError(argc, argv, 1, NULL, XtRWidget));

     XmDropSiteUnregister(localVar1);

     DBUG_RETURN (TCL_OK);
     }


/* 
 * void
 * XmDropSiteStartUpdate
 * 	in: Widget		# Widget to identify shell with multiple drop sites
 */

static int 
cmd_XmDropSiteStartUpdate(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;

     DBUG_ENTER(argv[0]);  
     WAFE_UNUSED(clientData);
     WAFE_UNUSED(comInterpreter);

     if (argc != 2) 
	 DBUG_RETURN(wafeArgcError(argc,argv,wafeStrings[2],1));

     if (!(localVar1 = (Widget) name2Widget(argv[1])))
         DBUG_RETURN(wafeConvError(argc, argv, 1, NULL, XtRWidget));

     XmDropSiteStartUpdate(localVar1);

     DBUG_RETURN (TCL_OK);
     }


/* 
 * void
 * XmDropSiteEndUpdate
 * 	in: Widget		# Widget to identify shell with multiple drop sites
 */

static int 
cmd_XmDropSiteEndUpdate(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;

     DBUG_ENTER(argv[0]);  
     WAFE_UNUSED(clientData);
     WAFE_UNUSED(comInterpreter);

     if (argc != 2) 
	 DBUG_RETURN(wafeArgcError(argc,argv,wafeStrings[2],1));

     if (!(localVar1 = (Widget) name2Widget(argv[1])))
         DBUG_RETURN(wafeConvError(argc, argv, 1, NULL, XtRWidget));

     XmDropSiteEndUpdate(localVar1);

     DBUG_RETURN (TCL_OK);
     }


/* 
 * WidgetID (WidgetID)
 * createDnDWidget4 vulgo XmDropTransferStart
 *         pre: { ArgList args; int numArgs; currentDragContext = localVar1; wafeConvert(localVar1,xmDropTransferObjectClass,argvArg,&argc,&args,&numArgs, NULL);
 *         const: XmDropTransferStart
 * 	in: Widget		# Drag Context
 * 	in: [args avp]          # Drop Transfer Resources
 *         post: wafeMMsetAttribList((Widget)returnVar); wafeCurrentAttribList = NULL; XtAddCallback((Widget)returnVar,XtNdestroyCallback,CBfreeAttribs,NULL); XtFree((char*)args); }
 */

static int 
cmd_XmDropTransferStart(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     Boolean freeArgv = False;
     char **argvArg;
     WidgetID returnVar;
     char conversionBuffer[100];

     DBUG_ENTER(argv[0]);  
     WAFE_UNUSED(clientData);
     WAFE_UNUSED(comInterpreter);

     if (argc < 3) 
	 DBUG_RETURN(wafeArgcError(argc,argv,wafeStrings[31],2));

     if (!(localVar1 = (Widget) name2Widget(argv[1])))
         DBUG_RETURN(wafeConvError(argc, argv, 1, NULL, XtRWidget));

     argc -= 2;
     argvArg = &argv[2];
     if (argc == 1)
        {
        if (wafeMergeArguments(argv[2],argv[0],&argc,&argvArg))
           freeArgv = True;
        else 
           DBUG_RETURN (TCL_ERROR);
        }
     if (argc%2)
        {
        if (freeArgv) XtFree((char*)argvArg);
        DBUG_RETURN(wafeArgcError(argc+2, argv,"even number of attribute value pairs such as 2 or ",4));
        }

     { ArgList args; int numArgs; currentDragContext = localVar1; wafeConvert(localVar1,xmDropTransferObjectClass,argvArg,&argc,&args,&numArgs, NULL);
     returnVar = (WidgetID) createDnDWidget4(XmDropTransferStart,localVar1,argc,argvArg);
     wafeMMsetAttribList((Widget)returnVar); wafeCurrentAttribList = NULL; XtAddCallback((Widget)returnVar,XtNdestroyCallback,CBfreeAttribs,NULL); XtFree((char*)args); }
     if (freeArgv) XtFree((char *)argvArg);

     sprintf(conversionBuffer, wafeStrings[9], returnVar);
     Tcl_SetResult(comInterpreter, conversionBuffer, TCL_VOLATILE);

     DBUG_RETURN (TCL_OK);
     }


/* 
 * WidgetID (WidgetID)
 * createDnDWidget5 vulgo XmDragStart
 *         pre: { ArgList args; int numArgs; wafeConvert(localVar1,xmDragContextClass,argvArg,&argc,&args,&numArgs, NULL);
 *         const: XmDragStart
 * 	in: Widget		# Widget (source for drag and drop)
 * 	const: wafeCurrentEvent
 * 	in: [args avp]          # Drag Context Resources
 *         post: wafeMMsetAttribList((Widget)returnVar); wafeCurrentAttribList = NULL; XtAddCallback((Widget)returnVar,XtNdestroyCallback,CBfreeAttribs,NULL); XtFree((char*)args); }
 */

static int 
cmd_XmDragStart(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     Boolean freeArgv = False;
     char **argvArg;
     WidgetID returnVar;
     char conversionBuffer[100];

     DBUG_ENTER(argv[0]);  
     WAFE_UNUSED(clientData);
     WAFE_UNUSED(comInterpreter);

     if (argc < 3) 
	 DBUG_RETURN(wafeArgcError(argc,argv,wafeStrings[31],2));

     if (!(localVar1 = (Widget) name2Widget(argv[1])))
         DBUG_RETURN(wafeConvError(argc, argv, 1, NULL, XtRWidget));

     argc -= 2;
     argvArg = &argv[2];
     if (argc == 1)
        {
        if (wafeMergeArguments(argv[2],argv[0],&argc,&argvArg))
           freeArgv = True;
        else 
           DBUG_RETURN (TCL_ERROR);
        }
     if (argc%2)
        {
        if (freeArgv) XtFree((char*)argvArg);
        DBUG_RETURN(wafeArgcError(argc+2, argv,"even number of attribute value pairs such as 2 or ",4));
        }

     { ArgList args; int numArgs; wafeConvert(localVar1,xmDragContextClass,argvArg,&argc,&args,&numArgs, NULL);
     returnVar = (WidgetID) createDnDWidget5(XmDragStart,localVar1,wafeCurrentEvent,argc,argvArg);
     wafeMMsetAttribList((Widget)returnVar); wafeCurrentAttribList = NULL; XtAddCallback((Widget)returnVar,XtNdestroyCallback,CBfreeAttribs,NULL); XtFree((char*)args); }
     if (freeArgv) XtFree((char *)argvArg);

     sprintf(conversionBuffer, wafeStrings[9], returnVar);
     Tcl_SetResult(comInterpreter, conversionBuffer, TCL_VOLATILE);

     DBUG_RETURN (TCL_OK);
     }


#endif  /* of ifdef MOTIF12 */

void
wafeInitialize_MOTIF12()
{
#ifdef MOTIF12
 wccs[0].wClass = xmDragIconObjectClass; /* not a C constant! */
 wccs[1].wClass = xmDropSiteManagerObjectClass; /* not a C constant! */
 wccs[2].wClass = xmDragContextWidgetClass; /* not a C constant! */
 wccs[3].wClass = xmDropTransferObjectClass; /* not a C constant! */
 XtSetTypeConverter(XtRString, XmRDropTransfers,
	(XtTypeConverter)CvtStringToDropTransfers, 
	NULL, 0, XtCacheNone, NULL);
 XtSetTypeConverter(XtRString, XmRCallbackProc,
	(XtTypeConverter)CvtStringToCallbackProc, 
	NULL, 0, XtCacheNone, NULL);
 XtSetTypeConverter(XtRString, "SelectionCallbackProc",
	(XtTypeConverter)CvtStringToSelectionCallbackProc, 
	NULL, 0, XtCacheNone, NULL);
 XtSetTypeConverter(XtRString, "ConvertSelectionIncrProc",
	(XtTypeConverter)CvtStringToConvertSelectionIncrProc, 
	NULL, 0, XtCacheNone, NULL);
 XtSetTypeConverter(XtRString, XmCDragOperations,
	(XtTypeConverter)CvtStringToDragOperations, 
	NULL, 0, XtCacheNone, NULL);
 XtSetTypeConverter(XtRString, XmRDropSiteOperations,
	(XtTypeConverter)CvtStringToDragOperations, 
	NULL, 0, XtCacheNone, NULL);
 XtSetTypeConverter(XtRString, XmRTransferStatus,
	(XtTypeConverter)CvtStringToTransferStatus, 
	NULL, 0, XtCacheNone, NULL);
 XmRepTypeInstallTearOffModelConverter();
 qdragProc = WafePermStringToQuark(XmNdragProc);
 qdropProc = WafePermStringToQuark(XmNdropProc);
 qtransferProc = WafePermStringToQuark(XmNtransferProc);
 qconvertProc = WafePermStringToQuark(XmNconvertProc);
 wafeCreateTclCmds(pkgs,wccs,cmds);
#endif /* of ifdef MOTIF12 */
}
