#> The Xew (EuroBridge) Widgets are designed primarily for use in
#> multimedia applications. These widgets were implemented by
#> Markku.Savela@vtt.fi. Wafe was tested and built with Xew 3.1, which
#> can be obtained from various ftp servers such as ftp.x.org.
#> 
#> For more information about Xew, consult 
#>    http://www.vtt.fi/tte/EuroBridge/Xew/

$PACKAGE = "XEW";

~handles
           XEW

~require
	Xew.inc
	rConv XtRXeContentFormat XeContentFormat toString \
              "unknown","iso2022","tiff","jpeg","gif","pbm","cgm","h261",\
			"mpeg","audio","odif","rle" \
              XeContentFormat_UNKNOWN,XeContentFormat_ISO2022,\
			XeContentFormat_TIFF,XeContentFormat_JPEG,\
			XeContentFormat_GIF,XeContentFormat_PBM,\
			XeContentFormat_CGM,XeContentFormat_H261,\
			XeContentFormat_MPEG,XeContentFormat_AUDIO,\
			XeContentFormat_ODIF,XeContentFormat_RLE
	rConv XtRXeScaling XeScaling toString \
	      "none","width","height","maxaspect","fitarea" \
	      XeScaling_NONE,XeScaling_WIDTH,XeScaling_HEIGHT,\
			XeScaling_MAXASPECT,XeScaling_FITAREA
	rConv XtRXeColormapUse XeColormapUse toString \
	      "shared","sharedown","optional","private" \
	      XeColormapUse_SHARED,XeColormapUse_SHAREDOWN,\
			XeColormapUse_OPTIONAL,XeColormapUse_PRIVATE
	rConv XtRXeColorMode XeColorMode toString \
              "none","mono","gray","color" \
	      XeColorMode_NONE,XeColorMode_MONO,XeColorMode_GRAY,\
			XeColorMode_COLOR
	rConv XtRXeDither XeDither toString \
	      "none","fs4" \
	      XeDither_NONE,XeDither_FS4
	rConv XtRXeColorQuantize XeColorQuantize toString \
              "fast","heckbert","ppmquant","jpeg" \
	      XeColorQuantize_FAST,XeColorQuantize_HECKBERT,\
			XeColorQuantize_PPMQUANT,XeColorQuantize_JPEG


#> The 'XeText' widget class is for displaying text with multinational
#> character sets (ISO 2022, COMPOUND_TEXT), multiple fonts, text
#> sizes, renditions, colors, alignments and justifications (ISO
#> 6429/ANSI X3.64-1979). Additionally, the XeText widget allows other
#> widgets (insets) to be embedded into the text stream.  The widget
#> class is suitable for applications that require a locale
#> independent international support and/or mixing of text with other
#> widgets.

~widgetClass
XeText
	include <Xew/Text.h>
	rConv XtRXeAlignment XeAlignment toString \
		"none","start","end","center","justified","around" \
		XeAlignment_NONE,XeAlignment_START,XeAlignment_END,\
			XeAlignment_CENTER,XeAlignment_JUSTIFIED,\
			XeAlignment_AROUND
	rConv XtRXeTextExport XeTextExport toString \
		"string","string-f","odif","odif-f","odif-fp" \
		XeTextExport_STRING,XeTextExport_STRING_F,XeTextExport_ODIF,\
			XeTextExport_ODIF_F,XeTextExport_ODIF_FP

#> The 'XeTextEd' widget class is an editable version of the 'XeText'
#> widget class.

~widgetClass
XeTextEd
	include <Xew/TextEd.h>
	creates XEW XeText

#> The 'XeRaster' widget class can display images in the GIF and
#> PBMPLUS formats, Support for JPEG, TIFF and RLE can be added just
#> by compilation switches and having the corresponding freely
#> available libraries.  XeRaster can be used by applications that
#> need a quick and easy way to display images in common formats. It
#> is not intended for image processing applications.

~widgetClass
XeRaster
	include <Xew/Raster.h>


#> The 'XeAudio' widget class "displays" audio content. This is
#> currently implemented only for /dev/audio on Sun SPARC
#> architecture.

~widgetClass
XeAudio
	include <Xew/Audio.h>

#> The 'XeVideo' widget class can play MPEG movies. It is based on the
#> Berkeley MPEG code.

~widgetClass
XeVideo
	include <Xew/Video.h>

#> The 'XeFrame' widget class uses the concepts of ODA (ISO 8613)
#> Frame object.  XeFrame stacks its children into absolute positions
#> or into column, which can be laid out vertically or
#> horizontally. The allowed geometry and positioning within column
#> can be constrained in various ways (alignments and ordering) and
#> they can have different border styles (shadow, solid, dotted lines,
#> etc).  XeFrame can be used as a basic building block for displaying
#> the pages of a document. It is also powerfull enough to be used as
#> a building block for the user interface panels.

~widgetClass
XeFrame
	include <Xew/Frame.h>
	rConv XeRFramePosition XeFramePositionType toString \
		"normal","reverse","fixed","inline","start","end" \
		XeFramePositionType_NORMAL,XeFramePositionType_REVERSE,\
			XeFramePositionType_FIXED,XeFramePositionType_INLINE,\
			XeFramePositionType_START,XeFramePositionType_END
	rConv XeRFrameBorder XeFrameAlignment toString \
		"right","left","center","top","bottom","above",\
			"around","below" \
		XeFrameAlignment_RIGHT,XeFrameAlignment_LEFT,\
			XeFrameAlignment_CENTER,XeFrameAlignment_TOP,\
			XeFrameAlignment_BOTTOM,XeFrameAlignment_ABOVE,\
			XeFrameAlignment_AROUND,XeFrameAlignment_BELOW

