#> The Xbae widget supports two widget classes, XbaeMatrix and
#> XbaeCaption. Wafe was tested and built with Xbae 3.8p1, Xbae can be
#> obtained from various ftp servers such as ftp.x.org.
#> 
#> Xbae requires Motif 1.1 or newer.

$PACKAGE = "XBAE";

~handles
           XBAE

~require 
        Xbae.inc
	privateString XbaeMatrixWidget

#> The 'XbaeCaption' widget class is a simple Motif manager widget
#> used to associate an XmLabel (caption) with it's single child. The
#> label may be either an XmString or Pixmap and can be displayed in
#> any one of twelve positions around the perimeter of the
#> child. XbaeCaption's geometry management technique is to simply
#> "shrink wrap" it's child and display the caption alongside it.  By
#> using XbaeCaption with an XmFrame child, groups of related widgets
#> can be labeled similarly to the IBM CUA "Group Box", but with more
#> flexibility.  XbaeCaption is also useful for associating labels
#> with individual XmTextField widgets.

~widgetClass
XbaeCaption
	include <Xbae/Caption.h>
	rConv XmRLabelAlignment XbaeLabelAlignment toString \
           "toporleft","top","left","center",\
		"bottomorright","bottom","right" \
	   XbaeAlignmentTopOrLeft,XbaeAlignmentTopOrLeft,\
		XbaeAlignmentTopOrLeft,XbaeAlignmentCenter,\
		XbaeAlignmentBottomOrRight,XbaeAlignmentBottomOrRight,\
		XbaeAlignmentBottomOrRight
	rConv XmRLabelPosition XbaeLabelPosition toString \
           "left","right","top","bottom" \
		XbaePositionLeft,XbaePositionRight,XbaePositionTop,\
		XbaePositionBottom

#> The 'XbaeMatrix' widget class is a Motif widget which presents an
#> editable array of string data to the user in a scrollable table
#> similar to a spreadsheet. The rows and columns of the Matrix may
#> optionally be labeled. Also, a number of "fixed" leading rows or
#> columns may be specified - these behave similarly to the
#> labels. While XbaeMatrix looks and acts like a grid of XmTextField
#> widgets, it actually contains only one XmTextField.  This means
#> that XbaeMatrix widgets with hundreds or thousands of rows have
#> much less overhead than they would if they used an XmTextField for
#> each cell. XbaeMatrix has callbacks for doing field validation and
#> customizing traversal. It allows cells to be assigned independent
#> colors.  It allows rows, columns and regions of cells to be
#> selected (highlighted).  The matrix can be dynamically grown or
#> shrunk by adding and deleting rows and columns at any position.

$ModifyVerifyCbs = "((XbaeMatrixModifyVerifyCallbackStruct *)callData)";

~widgetClass
XbaeMatrix
	include <Xbae/Matrix.h>
	rConv XmRGridType char toString \
           "XmGRID_NONE","XmGRID_LINE","XmGRID_SHADOW_IN","XmGRID_SHADOW_OUT" \
		XmGRID_NONE,XmGRID_LINE,XmGRID_SHADOW_IN,XmGRID_SHADOW_OUT
	enterCell|leaveCell|traverseCell|selectCell|modifyVerify r int: \
	       ((XbaeMatrixEnterCellCallbackStruct*)callData)->row # row
	enterCell|leaveCell|traverseCell|selectCell|modifyVerify c int: \
	       ((XbaeMatrixEnterCellCallbackStruct*)callData)->column # column
	leaveCell s EscapedString: \
	       ((XbaeMatrixLeaveCellCallbackStruct*)callData)->value # value
        traverseCell R int: \
	       ((XbaeMatrixTraverseCellCallbackStruct*)callData)->next_row \
		    # next row
        traverseCell C int: \
	       ((XbaeMatrixTraverseCellCallbackStruct*)callData)->next_column \
		    # next column
        modifyVerify i XmTextPosition: \
               $ModifyVerifyCbs->verify->currInsert # position of insert cursor
        modifyVerify n XmTextPosition: \
               $ModifyVerifyCbs->verify->newInsert  # new position of cursor
        modifyVerify f XmTextPosition: \
               $ModifyVerifyCbs->verify->startPos   # startPos (from)
        modifyVerify t XmTextPosition: \
               $ModifyVerifyCbs->verify->endPos     #   endPos (to)
        modifyVerify s EscapedStringN: \
               $ModifyVerifyCbs->verify->text->ptr, \
               $ModifyVerifyCbs->verify->text->length  # text

void
XbaeMatrixAddColumns vulgo XbaeMatrixAddEmptyColumns
        in: XbaeMatrixWidget          # Xbae Matrix Widget
        in: int                       # position
        const: NULL                   # columns
        const: NULL                   # labels
        const: NULL                   # widths
        const: NULL                   # max_lengths
        const: NULL                   # alignments
        const: NULL                   # label alignments
        const: NULL                   # colors
        in: int                       # number of columns to be insterted

void
XbaeMatrixAddRows vulgo XbaeMatrixAddEmptyRows
        in: XbaeMatrixWidget          # Xbae Matrix Widget
        in: int                       # position
        const: NULL                   # rows
        const: NULL                   # labels
        const: NULL                   # pixels
        in: int                       # number of rows to be insterted

void
XbaeMatrixCancelEdit
        in: XbaeMatrixWidget          # Xbae Matrix Widget
        in: Boolean                   # umap after canel?

void
XbaeMatrixCommitEdit
        in: XbaeMatrixWidget          # Xbae Matrix Widget
        in: Boolean                   # umap after canel?

void
XbaeMatrixDeleteColumns
        in: XbaeMatrixWidget          # Xbae Matrix Widget
        in: int                       # position
        in: int                       # number of columns to be deleted

void
XbaeMatrixDeleteRows
        in: XbaeMatrixWidget          # Xbae Matrix Widget
        in: int                       # position
        in: int                       # number of rows to be deleted

void
XbaeMatrixDeselectAll
        in: XbaeMatrixWidget          # Xbae Matrix Widget

void
XbaeMatrixDeselectColumn
        in: XbaeMatrixWidget          # Xbae Matrix Widget
        in: int                       # column

void
XbaeMatrixDeselectCell
        in: XbaeMatrixWidget          # Xbae Matrix Widget
        in: int                       # row
        in: int                       # column

void
XbaeMatrixDeselectRow
        in: XbaeMatrixWidget          # Xbae Matrix Widget
        in: int                       # row


void
XbaeMatrixEditCell
        in: XbaeMatrixWidget          # Xbae Matrix Widget
        in: int                       # row
        in: int                       # column

String
XbaeMatrixGetCell
        in: XbaeMatrixWidget          # Xbae Matrix Widget
        in: int                       # row
        in: int                       # column

void
XbaeMatrixSelectRow
        in: XbaeMatrixWidget          # Xbae Matrix Widget
        in: int                       # row

void
XbaeMatrixSelectColumn
        in: XbaeMatrixWidget          # Xbae Matrix Widget
        in: int                       # column

void
XbaeMatrixSetCell
        in: XbaeMatrixWidget          # Xbae Matrix Widget
        in: int                       # row
        in: int                       # column
        in: String                    # value

void
XbaeMatrixSetCellColor
        in: XbaeMatrixWidget          # Xbae Matrix Widget
        in: int                       # row
        in: int                       # column
        in: Pixel                     # value

TCL_RETURN_CODE
wafeMatrixEnterCellCBset vulgo XbaeEnterCellCBset
        in: Boolean     	      # doit

TCL_RETURN_CODE
wafeMatrixLeaveCellCBset vulgo XbaeLeaveCellCBset
        in: Boolean     	      # doit

TCL_RETURN_CODE
wafeMatrixTraverseCellCBset vulgo XbaeTraverseCellCBset
        in: int     		      # next row
        in: int     		      # next column

TCL_RETURN_CODE
wafeMatrixModifyVerifyCBset vulgo XbaeModifyVerifyCBset
        in: Boolean     		# doit
        in: long        		# currInsert or -1
        in: long        		# startPos or -1
        in: long        		# endPos or -1
        in: String        		# String
