/* Copyright (C) 1992 by Gustaf Neumann, Stefan Nusser

 *      Wirtschaftsuniversitaet Wien, 
 *      Abteilung fuer Wirtschaftsinformatik
 *      Augasse 2-6, 
 *      A-1090 Vienna, Austria
 *      neumann@wu-wien.ac.at, nusser@wu-wien.ac.at
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided
 * that the above copyright notice appears in all copies and that both that
 * copyright notice and this permission notice appear in all supporting
 * documentation.  This software is provided "as is" without expressed or
 * implied warranty.
 * 
 */

/*
 * This file was generated by genc.
 * Be aware that modifications of this file will be lost,
 * when genc is executed!

Creation: Sun Jul 16 22:23:56 EDT 1995 on mohegan
Author: genc
Version: 1.0.13

 */

#define XBAE_C
#include <wafe.h>
#ifdef XBAE
#include <Xbae/Caption.h>
#include <Xbae/Matrix.h>

/* make emcas happy -*-C-*-  make emacs happy */
#include <Xbae/Matrix.h>

extern int wafeModifyVerifyCBset(
#if NeedFunctionPrototypes
   Boolean, int, int, int, String
#endif
);

static int
wafeMatrixEnterCellCBset(doit)
Boolean doit;
    {
    XbaeMatrixEnterCellCallbackStruct *cbs = 
	(XbaeMatrixEnterCellCallbackStruct *)wafeCurrentCallData;
    DBUG_ENTER("wafeMatrixEnterCellCBset");
    if (!cbs || cbs->reason !=  XbaeEnterCellReason) 
	DBUG_RETURN(wafeSetError("calling wafeMatrixEnterCellCBset is only valid from a enterCellCallback",NULL,NULL,NULL));
    cbs->doit = doit;
    DBUG_RETURN(TCL_OK);
    }

static int
wafeMatrixLeaveCellCBset(doit)
Boolean doit;
    {
    XbaeMatrixLeaveCellCallbackStruct *cbs = 
	(XbaeMatrixLeaveCellCallbackStruct *)wafeCurrentCallData;
    DBUG_ENTER("wafeMatrixLeaveCellCBset");
    if (!cbs || cbs->reason !=  XbaeLeaveCellReason) 
	DBUG_RETURN(wafeSetError("calling wafeMatrixLeaveCellCBset is only valid from a LeaveCellCallback",NULL,NULL,NULL));
    cbs->doit = doit;
    DBUG_RETURN(TCL_OK);
    }

static int
wafeMatrixTraverseCellCBset(nextRow,nextCol)
int nextRow;
int nextCol;
    {
    XbaeMatrixTraverseCellCallbackStruct *cbs = 
	(XbaeMatrixTraverseCellCallbackStruct *)wafeCurrentCallData;
    DBUG_ENTER("wafeMatrixTraverseCellCBset");
    if (!cbs || cbs->reason !=  XbaeTraverseCellReason) 
	DBUG_RETURN(wafeSetError("calling wafeMatrixTraverseCellCBset is only valid from a traverseCellCallback",NULL,NULL,NULL));
    cbs->next_row    = nextRow;
    cbs->next_column = nextCol;
    DBUG_RETURN(TCL_OK);
    }

static int
wafeMatrixModifyVerifyCBset(doit, currInsert, startPos, endPos, string)
Boolean doit;
long currInsert, startPos, endPos;
String string;
    {
    XbaeMatrixModifyVerifyCallbackStruct *cbs = 
	(XbaeMatrixModifyVerifyCallbackStruct *)wafeCurrentCallData;
    XtPointer saveCallData;
    
    DBUG_ENTER("wafeModifyVerifyCBset");
    if (!cbs || cbs->reason !=  XbaeModifyVerifyReason) 
	DBUG_RETURN(wafeSetError("calling wafeModifyVerifyCBset is only valid from a ModifyVerifyCallback",NULL,NULL,NULL));

    saveCallData = wafeCurrentCallData;
    wafeCurrentCallData = (XtPointer) cbs->verify;
    wafeModifyVerifyCBset(doit, currInsert, startPos, endPos, string);
    wafeCurrentCallData = saveCallData;

    DBUG_RETURN(TCL_OK);
    }



static int cmd_XbaeMatrixAddEmptyColumns();
static int cmd_XbaeMatrixAddEmptyRows();
static int cmd_XbaeMatrixCancelEdit();
static int cmd_XbaeMatrixCommitEdit();
static int cmd_XbaeMatrixDeleteColumns();
static int cmd_XbaeMatrixDeleteRows();
static int cmd_XbaeMatrixDeselectAll();
static int cmd_XbaeMatrixDeselectColumn();
static int cmd_XbaeMatrixDeselectCell();
static int cmd_XbaeMatrixDeselectRow();
static int cmd_XbaeMatrixEditCell();
static int cmd_XbaeMatrixGetCell();
static int cmd_XbaeMatrixSelectRow();
static int cmd_XbaeMatrixSelectColumn();
static int cmd_XbaeMatrixSetCell();
static int cmd_XbaeMatrixSetCellColor();
static int cmd_XbaeEnterCellCBset();
static int cmd_XbaeLeaveCellCBset();
static int cmd_XbaeTraverseCellCBset();
static int cmd_XbaeModifyVerifyCBset();

 static _Xconst String XbaeLabelAlignment_strings[] = {
  "toporleft","top","left","center","bottomorright","bottom","right",NULL };
 static _Xconst int XbaeLabelAlignment_values[] = {
  XbaeAlignmentTopOrLeft,XbaeAlignmentTopOrLeft,XbaeAlignmentTopOrLeft,XbaeAlignmentCenter,XbaeAlignmentBottomOrRight,XbaeAlignmentBottomOrRight,XbaeAlignmentBottomOrRight,0 };
 static XtConvertArgRec XbaeLabelAlignment_args[] = { {XtAddress, NULL, 0} };

 static _Xconst String XbaeLabelPosition_strings[] = {
  "left","right","top","bottom",NULL };
 static _Xconst int XbaeLabelPosition_values[] = {
  XbaePositionLeft,XbaePositionRight,XbaePositionTop,XbaePositionBottom,0 };
 static XtConvertArgRec XbaeLabelPosition_args[] = { {XtAddress, NULL, 0} };

 static _Xconst String char_strings[] = {
  "XmGRID_NONE","XmGRID_LINE","XmGRID_SHADOW_IN","XmGRID_SHADOW_OUT",NULL };
 static _Xconst int char_values[] = {
  XmGRID_NONE,XmGRID_LINE,XmGRID_SHADOW_IN,XmGRID_SHADOW_OUT,0 };
 static XtConvertArgRec char_args[] = { {XtAddress, NULL, 0} };


static void wafeClassInit_XbaeCaption(wClass)
WidgetClass wClass;
{
 XtInitializeWidgetClass(wClass);

 XbaeLabelAlignment_args[0].address_id= (XtPointer)
   wafeAddRConv(XmRLabelAlignment,sizeof(XbaeLabelAlignment),
		XbaeLabelAlignment_strings, (XtPointer)XbaeLabelAlignment_values);
 XtSetTypeConverter(XmRLabelAlignment,XtRString,wafeCvtRToString,
		    XbaeLabelAlignment_args,XtNumber(XbaeLabelAlignment_args),
                    XtCacheNone,NULL);

 XbaeLabelPosition_args[0].address_id= (XtPointer)
   wafeAddRConv(XmRLabelPosition,sizeof(XbaeLabelPosition),
		XbaeLabelPosition_strings, (XtPointer)XbaeLabelPosition_values);
 XtSetTypeConverter(XmRLabelPosition,XtRString,wafeCvtRToString,
		    XbaeLabelPosition_args,XtNumber(XbaeLabelPosition_args),
                    XtCacheNone,NULL);
}

static void wafeClassInit_XbaeMatrix(wClass)
WidgetClass wClass;
{
 static _Xconst Proc_signature cmds[] = {
 { "XbaeMatrixAddEmptyColumns", cmd_XbaeMatrixAddEmptyColumns },
 { "XbaeMatrixAddEmptyRows", cmd_XbaeMatrixAddEmptyRows },
 { "XbaeMatrixCancelEdit", cmd_XbaeMatrixCancelEdit },
 { "XbaeMatrixCommitEdit", cmd_XbaeMatrixCommitEdit },
 { "XbaeMatrixDeleteColumns", cmd_XbaeMatrixDeleteColumns },
 { "XbaeMatrixDeleteRows", cmd_XbaeMatrixDeleteRows },
 { "XbaeMatrixDeselectAll", cmd_XbaeMatrixDeselectAll },
 { "XbaeMatrixDeselectColumn", cmd_XbaeMatrixDeselectColumn },
 { "XbaeMatrixDeselectCell", cmd_XbaeMatrixDeselectCell },
 { "XbaeMatrixDeselectRow", cmd_XbaeMatrixDeselectRow },
 { "XbaeMatrixEditCell", cmd_XbaeMatrixEditCell },
 { "XbaeMatrixGetCell", cmd_XbaeMatrixGetCell },
 { "XbaeMatrixSelectRow", cmd_XbaeMatrixSelectRow },
 { "XbaeMatrixSelectColumn", cmd_XbaeMatrixSelectColumn },
 { "XbaeMatrixSetCell", cmd_XbaeMatrixSetCell },
 { "XbaeMatrixSetCellColor", cmd_XbaeMatrixSetCellColor },
 { NULL, NULL }
 };
 XtInitializeWidgetClass(wClass);
 wafeCreateTclProcs(cmds);

 char_args[0].address_id= (XtPointer)
   wafeAddRConv(XmRGridType,sizeof(char),
		char_strings, (XtPointer)char_values);
 XtSetTypeConverter(XmRGridType,XtRString,wafeCvtRToString,
		    char_args,XtNumber(char_args),
                    XtCacheNone,NULL);
}




static _Xconst Proc_signature cmds[] = {
     { "XbaeEnterCellCBset", cmd_XbaeEnterCellCBset },
     { "XbaeLeaveCellCBset", cmd_XbaeLeaveCellCBset },
     { "XbaeTraverseCellCBset", cmd_XbaeTraverseCellCBset },
     { "XbaeModifyVerifyCBset", cmd_XbaeModifyVerifyCBset },
    { NULL, NULL }
    };

static WidgetCreate_signature wccs[] = {
    {"XbaeCaption",NULL,NULL,False,False,wafeClassInit_XbaeCaption},
    {"XbaeMatrix",NULL,NULL,False,False,wafeClassInit_XbaeMatrix},
    { NULL,NULL,NULL,False,False,NULL }
    };

static _Xconst String pkgs[] = {
     "XBAE",
    NULL
     };



 static _Xconst String WS_XbaeMatrixWidget = "XbaeMatrixWidget";
#define WS_XbaeCaption wccs[0].name
#define WS_XbaeMatrix wccs[1].name
/* 
 * void
 * XbaeMatrixAddColumns vulgo XbaeMatrixAddEmptyColumns
 *         in: XbaeMatrixWidget          # Xbae Matrix Widget
 *         in: int                       # position
 *         const: NULL                   # columns
 *         const: NULL                   # labels
 *         const: NULL                   # widths
 *         const: NULL                   # max_lengths
 *         const: NULL                   # alignments
 *         const: NULL                   # label alignments
 *         const: NULL                   # colors
 *         in: int                       # number of columns to be insterted
 */

static int 
cmd_XbaeMatrixAddEmptyColumns(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     int localVar2;
     int localVar3;

     DBUG_ENTER(argv[0]);  
     WAFE_UNUSED(clientData);
     WAFE_UNUSED(comInterpreter);

     if (argc != 4) 
	 DBUG_RETURN(wafeArgcError(argc,argv,wafeStrings[2],3));

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xbaeMatrixWidgetClass)))
         DBUG_RETURN(wafeConvError(argc, argv, 1, NULL, WS_XbaeMatrixWidget));

     if (!(sscanf(argv[2], wafeStrings[7], &localVar2)))
         DBUG_RETURN(wafeConvError(argc, argv, 2, NULL, wafeStrings[14]));

     if (!(sscanf(argv[3], wafeStrings[7], &localVar3)))
         DBUG_RETURN(wafeConvError(argc, argv, 3, NULL, wafeStrings[14]));

     XbaeMatrixAddColumns(localVar1,localVar2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,localVar3);

     DBUG_RETURN (TCL_OK);
     }


/* 
 * void
 * XbaeMatrixAddRows vulgo XbaeMatrixAddEmptyRows
 *         in: XbaeMatrixWidget          # Xbae Matrix Widget
 *         in: int                       # position
 *         const: NULL                   # rows
 *         const: NULL                   # labels
 *         const: NULL                   # pixels
 *         in: int                       # number of rows to be insterted
 */

static int 
cmd_XbaeMatrixAddEmptyRows(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     int localVar2;
     int localVar3;

     DBUG_ENTER(argv[0]);  
     WAFE_UNUSED(clientData);
     WAFE_UNUSED(comInterpreter);

     if (argc != 4) 
	 DBUG_RETURN(wafeArgcError(argc,argv,wafeStrings[2],3));

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xbaeMatrixWidgetClass)))
         DBUG_RETURN(wafeConvError(argc, argv, 1, NULL, WS_XbaeMatrixWidget));

     if (!(sscanf(argv[2], wafeStrings[7], &localVar2)))
         DBUG_RETURN(wafeConvError(argc, argv, 2, NULL, wafeStrings[14]));

     if (!(sscanf(argv[3], wafeStrings[7], &localVar3)))
         DBUG_RETURN(wafeConvError(argc, argv, 3, NULL, wafeStrings[14]));

     XbaeMatrixAddRows(localVar1,localVar2,NULL,NULL,NULL,localVar3);

     DBUG_RETURN (TCL_OK);
     }


/* 
 * void
 * XbaeMatrixCancelEdit
 *         in: XbaeMatrixWidget          # Xbae Matrix Widget
 *         in: Boolean                   # umap after canel?
 */

static int 
cmd_XbaeMatrixCancelEdit(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     Boolean localVar2;

     DBUG_ENTER(argv[0]);  
     WAFE_UNUSED(clientData);
     WAFE_UNUSED(comInterpreter);

     if (argc != 3) 
	 DBUG_RETURN(wafeArgcError(argc,argv,wafeStrings[2],2));

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xbaeMatrixWidgetClass)))
         DBUG_RETURN(wafeConvError(argc, argv, 1, NULL, WS_XbaeMatrixWidget));

     if (!(wafeGetBoolean(argv[2],&localVar2)))
         DBUG_RETURN(wafeConvError(argc, argv, 2, NULL, XtRBoolean));

     XbaeMatrixCancelEdit(localVar1,localVar2);

     DBUG_RETURN (TCL_OK);
     }


/* 
 * void
 * XbaeMatrixCommitEdit
 *         in: XbaeMatrixWidget          # Xbae Matrix Widget
 *         in: Boolean                   # umap after canel?
 */

static int 
cmd_XbaeMatrixCommitEdit(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     Boolean localVar2;

     DBUG_ENTER(argv[0]);  
     WAFE_UNUSED(clientData);
     WAFE_UNUSED(comInterpreter);

     if (argc != 3) 
	 DBUG_RETURN(wafeArgcError(argc,argv,wafeStrings[2],2));

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xbaeMatrixWidgetClass)))
         DBUG_RETURN(wafeConvError(argc, argv, 1, NULL, WS_XbaeMatrixWidget));

     if (!(wafeGetBoolean(argv[2],&localVar2)))
         DBUG_RETURN(wafeConvError(argc, argv, 2, NULL, XtRBoolean));

     XbaeMatrixCommitEdit(localVar1,localVar2);

     DBUG_RETURN (TCL_OK);
     }


/* 
 * void
 * XbaeMatrixDeleteColumns
 *         in: XbaeMatrixWidget          # Xbae Matrix Widget
 *         in: int                       # position
 *         in: int                       # number of columns to be deleted
 */

static int 
cmd_XbaeMatrixDeleteColumns(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     int localVar2;
     int localVar3;

     DBUG_ENTER(argv[0]);  
     WAFE_UNUSED(clientData);
     WAFE_UNUSED(comInterpreter);

     if (argc != 4) 
	 DBUG_RETURN(wafeArgcError(argc,argv,wafeStrings[2],3));

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xbaeMatrixWidgetClass)))
         DBUG_RETURN(wafeConvError(argc, argv, 1, NULL, WS_XbaeMatrixWidget));

     if (!(sscanf(argv[2], wafeStrings[7], &localVar2)))
         DBUG_RETURN(wafeConvError(argc, argv, 2, NULL, wafeStrings[14]));

     if (!(sscanf(argv[3], wafeStrings[7], &localVar3)))
         DBUG_RETURN(wafeConvError(argc, argv, 3, NULL, wafeStrings[14]));

     XbaeMatrixDeleteColumns(localVar1,localVar2,localVar3);

     DBUG_RETURN (TCL_OK);
     }


/* 
 * void
 * XbaeMatrixDeleteRows
 *         in: XbaeMatrixWidget          # Xbae Matrix Widget
 *         in: int                       # position
 *         in: int                       # number of rows to be deleted
 */

static int 
cmd_XbaeMatrixDeleteRows(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     int localVar2;
     int localVar3;

     DBUG_ENTER(argv[0]);  
     WAFE_UNUSED(clientData);
     WAFE_UNUSED(comInterpreter);

     if (argc != 4) 
	 DBUG_RETURN(wafeArgcError(argc,argv,wafeStrings[2],3));

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xbaeMatrixWidgetClass)))
         DBUG_RETURN(wafeConvError(argc, argv, 1, NULL, WS_XbaeMatrixWidget));

     if (!(sscanf(argv[2], wafeStrings[7], &localVar2)))
         DBUG_RETURN(wafeConvError(argc, argv, 2, NULL, wafeStrings[14]));

     if (!(sscanf(argv[3], wafeStrings[7], &localVar3)))
         DBUG_RETURN(wafeConvError(argc, argv, 3, NULL, wafeStrings[14]));

     XbaeMatrixDeleteRows(localVar1,localVar2,localVar3);

     DBUG_RETURN (TCL_OK);
     }


/* 
 * void
 * XbaeMatrixDeselectAll
 *         in: XbaeMatrixWidget          # Xbae Matrix Widget
 */

static int 
cmd_XbaeMatrixDeselectAll(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;

     DBUG_ENTER(argv[0]);  
     WAFE_UNUSED(clientData);
     WAFE_UNUSED(comInterpreter);

     if (argc != 2) 
	 DBUG_RETURN(wafeArgcError(argc,argv,wafeStrings[2],1));

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xbaeMatrixWidgetClass)))
         DBUG_RETURN(wafeConvError(argc, argv, 1, NULL, WS_XbaeMatrixWidget));

     XbaeMatrixDeselectAll(localVar1);

     DBUG_RETURN (TCL_OK);
     }


/* 
 * void
 * XbaeMatrixDeselectColumn
 *         in: XbaeMatrixWidget          # Xbae Matrix Widget
 *         in: int                       # column
 */

static int 
cmd_XbaeMatrixDeselectColumn(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     int localVar2;

     DBUG_ENTER(argv[0]);  
     WAFE_UNUSED(clientData);
     WAFE_UNUSED(comInterpreter);

     if (argc != 3) 
	 DBUG_RETURN(wafeArgcError(argc,argv,wafeStrings[2],2));

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xbaeMatrixWidgetClass)))
         DBUG_RETURN(wafeConvError(argc, argv, 1, NULL, WS_XbaeMatrixWidget));

     if (!(sscanf(argv[2], wafeStrings[7], &localVar2)))
         DBUG_RETURN(wafeConvError(argc, argv, 2, NULL, wafeStrings[14]));

     XbaeMatrixDeselectColumn(localVar1,localVar2);

     DBUG_RETURN (TCL_OK);
     }


/* 
 * void
 * XbaeMatrixDeselectCell
 *         in: XbaeMatrixWidget          # Xbae Matrix Widget
 *         in: int                       # row
 *         in: int                       # column
 */

static int 
cmd_XbaeMatrixDeselectCell(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     int localVar2;
     int localVar3;

     DBUG_ENTER(argv[0]);  
     WAFE_UNUSED(clientData);
     WAFE_UNUSED(comInterpreter);

     if (argc != 4) 
	 DBUG_RETURN(wafeArgcError(argc,argv,wafeStrings[2],3));

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xbaeMatrixWidgetClass)))
         DBUG_RETURN(wafeConvError(argc, argv, 1, NULL, WS_XbaeMatrixWidget));

     if (!(sscanf(argv[2], wafeStrings[7], &localVar2)))
         DBUG_RETURN(wafeConvError(argc, argv, 2, NULL, wafeStrings[14]));

     if (!(sscanf(argv[3], wafeStrings[7], &localVar3)))
         DBUG_RETURN(wafeConvError(argc, argv, 3, NULL, wafeStrings[14]));

     XbaeMatrixDeselectCell(localVar1,localVar2,localVar3);

     DBUG_RETURN (TCL_OK);
     }


/* 
 * void
 * XbaeMatrixDeselectRow
 *         in: XbaeMatrixWidget          # Xbae Matrix Widget
 *         in: int                       # row
 */

static int 
cmd_XbaeMatrixDeselectRow(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     int localVar2;

     DBUG_ENTER(argv[0]);  
     WAFE_UNUSED(clientData);
     WAFE_UNUSED(comInterpreter);

     if (argc != 3) 
	 DBUG_RETURN(wafeArgcError(argc,argv,wafeStrings[2],2));

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xbaeMatrixWidgetClass)))
         DBUG_RETURN(wafeConvError(argc, argv, 1, NULL, WS_XbaeMatrixWidget));

     if (!(sscanf(argv[2], wafeStrings[7], &localVar2)))
         DBUG_RETURN(wafeConvError(argc, argv, 2, NULL, wafeStrings[14]));

     XbaeMatrixDeselectRow(localVar1,localVar2);

     DBUG_RETURN (TCL_OK);
     }


/* 
 * void
 * XbaeMatrixEditCell
 *         in: XbaeMatrixWidget          # Xbae Matrix Widget
 *         in: int                       # row
 *         in: int                       # column
 */

static int 
cmd_XbaeMatrixEditCell(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     int localVar2;
     int localVar3;

     DBUG_ENTER(argv[0]);  
     WAFE_UNUSED(clientData);
     WAFE_UNUSED(comInterpreter);

     if (argc != 4) 
	 DBUG_RETURN(wafeArgcError(argc,argv,wafeStrings[2],3));

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xbaeMatrixWidgetClass)))
         DBUG_RETURN(wafeConvError(argc, argv, 1, NULL, WS_XbaeMatrixWidget));

     if (!(sscanf(argv[2], wafeStrings[7], &localVar2)))
         DBUG_RETURN(wafeConvError(argc, argv, 2, NULL, wafeStrings[14]));

     if (!(sscanf(argv[3], wafeStrings[7], &localVar3)))
         DBUG_RETURN(wafeConvError(argc, argv, 3, NULL, wafeStrings[14]));

     XbaeMatrixEditCell(localVar1,localVar2,localVar3);

     DBUG_RETURN (TCL_OK);
     }


/* 
 * String
 * XbaeMatrixGetCell
 *         in: XbaeMatrixWidget          # Xbae Matrix Widget
 *         in: int                       # row
 *         in: int                       # column
 */

static int 
cmd_XbaeMatrixGetCell(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     int localVar2;
     int localVar3;
     String returnVar;

     DBUG_ENTER(argv[0]);  
     WAFE_UNUSED(clientData);
     WAFE_UNUSED(comInterpreter);

     if (argc != 4) 
	 DBUG_RETURN(wafeArgcError(argc,argv,wafeStrings[2],3));

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xbaeMatrixWidgetClass)))
         DBUG_RETURN(wafeConvError(argc, argv, 1, NULL, WS_XbaeMatrixWidget));

     if (!(sscanf(argv[2], wafeStrings[7], &localVar2)))
         DBUG_RETURN(wafeConvError(argc, argv, 2, NULL, wafeStrings[14]));

     if (!(sscanf(argv[3], wafeStrings[7], &localVar3)))
         DBUG_RETURN(wafeConvError(argc, argv, 3, NULL, wafeStrings[14]));

     returnVar = XbaeMatrixGetCell(localVar1,localVar2,localVar3);

     Tcl_SetResult(comInterpreter, returnVar, TCL_STATIC);

     DBUG_RETURN (TCL_OK);
     }


/* 
 * void
 * XbaeMatrixSelectRow
 *         in: XbaeMatrixWidget          # Xbae Matrix Widget
 *         in: int                       # row
 */

static int 
cmd_XbaeMatrixSelectRow(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     int localVar2;

     DBUG_ENTER(argv[0]);  
     WAFE_UNUSED(clientData);
     WAFE_UNUSED(comInterpreter);

     if (argc != 3) 
	 DBUG_RETURN(wafeArgcError(argc,argv,wafeStrings[2],2));

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xbaeMatrixWidgetClass)))
         DBUG_RETURN(wafeConvError(argc, argv, 1, NULL, WS_XbaeMatrixWidget));

     if (!(sscanf(argv[2], wafeStrings[7], &localVar2)))
         DBUG_RETURN(wafeConvError(argc, argv, 2, NULL, wafeStrings[14]));

     XbaeMatrixSelectRow(localVar1,localVar2);

     DBUG_RETURN (TCL_OK);
     }


/* 
 * void
 * XbaeMatrixSelectColumn
 *         in: XbaeMatrixWidget          # Xbae Matrix Widget
 *         in: int                       # column
 */

static int 
cmd_XbaeMatrixSelectColumn(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     int localVar2;

     DBUG_ENTER(argv[0]);  
     WAFE_UNUSED(clientData);
     WAFE_UNUSED(comInterpreter);

     if (argc != 3) 
	 DBUG_RETURN(wafeArgcError(argc,argv,wafeStrings[2],2));

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xbaeMatrixWidgetClass)))
         DBUG_RETURN(wafeConvError(argc, argv, 1, NULL, WS_XbaeMatrixWidget));

     if (!(sscanf(argv[2], wafeStrings[7], &localVar2)))
         DBUG_RETURN(wafeConvError(argc, argv, 2, NULL, wafeStrings[14]));

     XbaeMatrixSelectColumn(localVar1,localVar2);

     DBUG_RETURN (TCL_OK);
     }


/* 
 * void
 * XbaeMatrixSetCell
 *         in: XbaeMatrixWidget          # Xbae Matrix Widget
 *         in: int                       # row
 *         in: int                       # column
 *         in: String                    # value
 */

static int 
cmd_XbaeMatrixSetCell(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     int localVar2;
     int localVar3;

     DBUG_ENTER(argv[0]);  
     WAFE_UNUSED(clientData);
     WAFE_UNUSED(comInterpreter);

     if (argc != 5) 
	 DBUG_RETURN(wafeArgcError(argc,argv,wafeStrings[2],4));

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xbaeMatrixWidgetClass)))
         DBUG_RETURN(wafeConvError(argc, argv, 1, NULL, WS_XbaeMatrixWidget));

     if (!(sscanf(argv[2], wafeStrings[7], &localVar2)))
         DBUG_RETURN(wafeConvError(argc, argv, 2, NULL, wafeStrings[14]));

     if (!(sscanf(argv[3], wafeStrings[7], &localVar3)))
         DBUG_RETURN(wafeConvError(argc, argv, 3, NULL, wafeStrings[14]));

    /* no need to assign  << localVar4 = argv[4] >>  */ 

     XbaeMatrixSetCell(localVar1,localVar2,localVar3,argv[4]);

     DBUG_RETURN (TCL_OK);
     }


/* 
 * void
 * XbaeMatrixSetCellColor
 *         in: XbaeMatrixWidget          # Xbae Matrix Widget
 *         in: int                       # row
 *         in: int                       # column
 *         in: Pixel                     # value
 */

static int 
cmd_XbaeMatrixSetCellColor(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     int localVar2;
     int localVar3;
     Pixel localVar4;

     DBUG_ENTER(argv[0]);  
     WAFE_UNUSED(clientData);
     WAFE_UNUSED(comInterpreter);

     if (argc != 5) 
	 DBUG_RETURN(wafeArgcError(argc,argv,wafeStrings[2],4));

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xbaeMatrixWidgetClass)))
         DBUG_RETURN(wafeConvError(argc, argv, 1, NULL, WS_XbaeMatrixWidget));

     if (!(sscanf(argv[2], wafeStrings[7], &localVar2)))
         DBUG_RETURN(wafeConvError(argc, argv, 2, NULL, wafeStrings[14]));

     if (!(sscanf(argv[3], wafeStrings[7], &localVar3)))
         DBUG_RETURN(wafeConvError(argc, argv, 3, NULL, wafeStrings[14]));

     if (!(localVar4 = (Pixel) wafeCvtStringToPixel(localVar1,argv[4])))
         DBUG_RETURN(wafeConvError(argc, argv, 4, NULL, XtRPixel));

     XbaeMatrixSetCellColor(localVar1,localVar2,localVar3,localVar4);

     DBUG_RETURN (TCL_OK);
     }


/* 
 * TCL_RETURN_CODE
 * wafeMatrixEnterCellCBset vulgo XbaeEnterCellCBset
 *         in: Boolean     	      # doit
 */

static int 
cmd_XbaeEnterCellCBset(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Boolean localVar1;
     TCL_RETURN_CODE returnVar;

     DBUG_ENTER(argv[0]);  
     WAFE_UNUSED(clientData);
     WAFE_UNUSED(comInterpreter);

     if (argc != 2) 
	 DBUG_RETURN(wafeArgcError(argc,argv,wafeStrings[2],1));

     if (!(wafeGetBoolean(argv[1],&localVar1)))
         DBUG_RETURN(wafeConvError(argc, argv, 1, NULL, XtRBoolean));

     returnVar = wafeMatrixEnterCellCBset(localVar1);

     DBUG_RETURN (returnVar);
     }


/* 
 * TCL_RETURN_CODE
 * wafeMatrixLeaveCellCBset vulgo XbaeLeaveCellCBset
 *         in: Boolean     	      # doit
 */

static int 
cmd_XbaeLeaveCellCBset(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Boolean localVar1;
     TCL_RETURN_CODE returnVar;

     DBUG_ENTER(argv[0]);  
     WAFE_UNUSED(clientData);
     WAFE_UNUSED(comInterpreter);

     if (argc != 2) 
	 DBUG_RETURN(wafeArgcError(argc,argv,wafeStrings[2],1));

     if (!(wafeGetBoolean(argv[1],&localVar1)))
         DBUG_RETURN(wafeConvError(argc, argv, 1, NULL, XtRBoolean));

     returnVar = wafeMatrixLeaveCellCBset(localVar1);

     DBUG_RETURN (returnVar);
     }


/* 
 * TCL_RETURN_CODE
 * wafeMatrixTraverseCellCBset vulgo XbaeTraverseCellCBset
 *         in: int     		      # next row
 *         in: int     		      # next column
 */

static int 
cmd_XbaeTraverseCellCBset(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     int localVar1;
     int localVar2;
     TCL_RETURN_CODE returnVar;

     DBUG_ENTER(argv[0]);  
     WAFE_UNUSED(clientData);
     WAFE_UNUSED(comInterpreter);

     if (argc != 3) 
	 DBUG_RETURN(wafeArgcError(argc,argv,wafeStrings[2],2));

     if (!(sscanf(argv[1], wafeStrings[7], &localVar1)))
         DBUG_RETURN(wafeConvError(argc, argv, 1, NULL, wafeStrings[14]));

     if (!(sscanf(argv[2], wafeStrings[7], &localVar2)))
         DBUG_RETURN(wafeConvError(argc, argv, 2, NULL, wafeStrings[14]));

     returnVar = wafeMatrixTraverseCellCBset(localVar1,localVar2);

     DBUG_RETURN (returnVar);
     }


/* 
 * TCL_RETURN_CODE
 * wafeMatrixModifyVerifyCBset vulgo XbaeModifyVerifyCBset
 *         in: Boolean     		# doit
 *         in: long        		# currInsert or -1
 *         in: long        		# startPos or -1
 *         in: long        		# endPos or -1
 *         in: String        		# String

 */

static int 
cmd_XbaeModifyVerifyCBset(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Boolean localVar1;
     long localVar2;
     long localVar3;
     long localVar4;
     TCL_RETURN_CODE returnVar;

     DBUG_ENTER(argv[0]);  
     WAFE_UNUSED(clientData);
     WAFE_UNUSED(comInterpreter);

     if (argc != 6) 
	 DBUG_RETURN(wafeArgcError(argc,argv,wafeStrings[2],5));

     if (!(wafeGetBoolean(argv[1],&localVar1)))
         DBUG_RETURN(wafeConvError(argc, argv, 1, NULL, XtRBoolean));

     if (!(sscanf(argv[2], wafeStrings[9], &localVar2)))
         DBUG_RETURN(wafeConvError(argc, argv, 2, NULL, wafeStrings[17]));

     if (!(sscanf(argv[3], wafeStrings[9], &localVar3)))
         DBUG_RETURN(wafeConvError(argc, argv, 3, NULL, wafeStrings[17]));

     if (!(sscanf(argv[4], wafeStrings[9], &localVar4)))
         DBUG_RETURN(wafeConvError(argc, argv, 4, NULL, wafeStrings[17]));

    /* no need to assign  << localVar5 = argv[5] >>  */ 

     returnVar = wafeMatrixModifyVerifyCBset(localVar1,localVar2,localVar3,localVar4,argv[5]);

     DBUG_RETURN (returnVar);
     }


#endif  /* of ifdef XBAE */

void
wafeInitialize_XBAE()
{
#ifdef XBAE
 wccs[0].wClass = xbaeCaptionWidgetClass; /* not a C constant! */
 wccs[1].wClass = xbaeMatrixWidgetClass; /* not a C constant! */
 wafeCreateTclCmds(pkgs,wccs,cmds);
#endif /* of ifdef XBAE */
}
