#
# file should be sourced 
# showRes lists the resources and its types for the given widget 
#
proc showRes {widget {filter ""}} {
  getResourceList $widget res

  set class [getClass $widget]
  set l  "Attributes of Widget $widget (Class $class)"
  if [string compare "" $filter] {
    append l "matching *$filter*:"
  }
  puts stderr $l
  foreach r [lsort $res] {
    set type [getTypeOfAttribute $widget $r]
    if {[string compare "" [info command getDomain]] && \
	[string compare "" [getDomain $type]]} {
      set gd getDomain
    } else {
      set gd ""
    }
    set l  "    [format {%-25s %-10s %-25s} $r $gd $type]"
    if [string match *$filter* $l] {
      puts stderr $l
    }
  }
}
