/* make emcas happy -*-C-*-  make emacs happy */

#include <ctype.h>
#include <Xm/AtomMgr.h>

#include <Xm/DragDrop.h>

static Widget currentDragContext;

static void
callbackProc(w, clientData, callData)
Widget w;
XtPointer clientData;
XtPointer callData;
    {
    XmAnyCallbackStruct *cbs = (XmAnyCallbackStruct *)callData;

    DBUG_ENTER("callbackProc");
    WAFE_UNUSED(clientData);

    if (cbs->reason == XmCR_DROP_MESSAGE)
	{
	XmDropProcCallbackStruct *drop_cbs =
	  (XmDropProcCallbackStruct *)callData;
	char *cmd = wafeMMgetValue(w, qdropProc, NULL, False);
	wafeExecCallbackProc(drop_cbs->dragContext, (XtPointer)cmd, callData);
	}
    DBUG_VOID_RETURN;
    }


static Boolean
convertSelectionIncrProc(w, selection, target, type, value, length, format,
			 max_length, client_data, request_id)
Widget        w;
Atom          *selection;
Atom          *target;
Atom          *type;
XtPointer     *value;
unsigned long *length;
int           *format;
unsigned long *max_length;
XtPointer     client_data;
XtRequestId   *request_id;
    {
    Boolean result = True;
    DBUG_ENTER("convertSelectionIncrProc");

    WAFE_UNUSED(max_length);
    WAFE_UNUSED(client_data);
    WAFE_UNUSED(request_id);

    if (XtClass(w) == xmDragContextClass)
	{
	Display *dpy       = XtDisplay(w);
	Atom COMPOUND_TEXT = XmInternAtom(dpy, "COMPOUND_TEXT", False);
	Atom DELETE        = XmInternAtom(dpy, "DELETE", False);
	Atom TARGETS       = XmInternAtom(dpy, "TARGETS", False);
	char *cd, *cmd, *targetName = NULL;
	
	if (!(*selection == XmInternAtom(dpy, "_MOTIF_DROP", False)))
	    DBUG_RETURN(False);  /* it looks as if this was not for us! */

	/* if there is a command for the convert procedure registered,
	   call it and provide the target as callData; this is necessary
	   for the DELETE target in DROP_MOVE command
	 */
	if ((cmd = wafeMMgetValue(w, qconvertProc, NULL, False)))
	    {
	    targetName = XGetAtomName(dpy,*target);
	    wafeExecCallbackProc(w, (XtPointer)cmd, targetName);
	    }
	    
	if (*target == COMPOUND_TEXT)
	    {
	    XmString tmpString;

	    /* we pass the text via the clientData resource */
	    XtVaGetValues(w, XmNclientData, &cd, NULL);
	    
	    if (!cd)
		{
		wafeWarn("convertSelectionIncrProc", "invalid clientData",
			 NULL,NULL,NULL);
		if (targetName) XFree(targetName);
		DBUG_RETURN(False);  
		}

	    tmpString = wafeCvtStringToXmString(cd);
	    /* it is wierd that the returned compound text is of type
               char* since - as it looks to me - CT can have inbedded
               nulls, which will cause truncations on strlen etc 
             */
	    *type = *target;
	    *value = (XtPointer)XmCvtXmStringToCT(tmpString);
	    *length = (unsigned long)(strlen(*value)+1);

	    XmStringFree(tmpString);
	    *format = 8;
	    }
	else 
	if (*target == DELETE)
	    {
	    if (!cmd) 
		wafeWarn("convertSelectionIncrProc", 
			 "no convertProc registered for a DROP_MOVE operation",
			 NULL,NULL,NULL);

	    *type = XmInternAtom(dpy, wafe_NULL, False);
	    *value = NULL;
	    *length = 0;
	    *format = 8;
	    }
	else 
        if (*target == TARGETS)  /* This target is required by ICCC */
	    {
	    int target_count = 0;
	    Atom *targs = (Atom *)XtMalloc((unsigned) (6 * sizeof(Atom)));
	    *value = (XtPointer) targs;

	    /* if targets are added, increase the constant in malloc! */
	    *targs++ = COMPOUND_TEXT;
	    target_count++;
	    *targs++ = DELETE;
	    target_count++;
	    *targs++ = TARGETS;
	    target_count++;
	    *targs++ = XmInternAtom(dpy, "MULTIPLE", False);
	    target_count++;  /* supported in the Intrinsics */
	    *targs++ = XmInternAtom(dpy, "TIMESTAMP", False);
	    target_count++; /* supported in the Intrinsics */
	    
	    *type = XA_ATOM;
	    *length = (target_count * sizeof(Atom)) >> 2;
	    *format = 32;
            }
	else
	    {
	    if (!targetName) targetName = XGetAtomName(dpy,*target);
	    wafeWarn("convertSelectionIncrProc","unknown target %s",
		     targetName,NULL,NULL);
	    result = False;
	    }

	if (targetName) XFree(targetName);
	}
    DBUG_RETURN(result);  
    }

static void
selectionCallbackProc (w, closure, selection, type, value, length, format)
Widget          w;
XtPointer       closure;
Atom*           selection;
Atom*           type;
XtPointer       value;
unsigned long*  length;
int*            format;
    {
    DBUG_ENTER("selectionCallbackProc");

    WAFE_UNUSED(closure);
    WAFE_UNUSED(format);

    if (XtClass(w) == xmDropTransferObjectClass)
	{
	dropTransferCallbackStruct dtCbs;
	Atom COMPOUND_TEXT, TEXT, FILE_NAME, A_NULL;
	XmDropTransferEntryRec *dropTransferEntries;
	char *cmd;
	Display *dpy;

	if (!currentDragContext)
	    DBUG_VOID_RETURN;   /* to avoid surprises... */
	
	dpy = XtDisplay(currentDragContext);
	if (! *selection == XmInternAtom(dpy, "_MOTIF_DROP", False))
	    DBUG_VOID_RETURN;   /* to avoid surprises... */

	if (!(cmd = wafeMMgetValue(w, qtransferProc, NULL, False)))
	    {
	    wafeWarn("selectionCallbackProc","no transferProc registered",
		     NULL,NULL,NULL);
	    DBUG_VOID_RETURN;
	    }

	XtVaGetValues(w, XmNdropTransfers,&dropTransferEntries, NULL);
	
	COMPOUND_TEXT = XInternAtom(dpy,"COMPOUND_TEXT", False);
	TEXT          = XInternAtom(dpy,"TEXT", False);
	FILE_NAME     = XInternAtom(dpy,"FILE_NAME", False);
	A_NULL        = XInternAtom(dpy, wafe_NULL, False);
	dtCbs.dest    = (String)dropTransferEntries->client_data;

	if (*type == COMPOUND_TEXT)
	    {
	    wafeStringStruct   ws_struct;
	    wafeString         ws = &ws_struct;
	    XmString t = XmCvtCTToXmString(value);
	    wafeStringInit(ws);
	    wafeCvtXmString2String(ws,t,True);
	    dtCbs.value = wafeStringValue(ws);
/*
	    fprintf(stderr,"+ in callbackProc, transferProc, widget = %p <%s> cmd=<%s>, <%s> <%s>\n",
		    w,XtName(w),cmd+sizeof(XrmQuark),dtCbs.value,value);
 */
	    wafeExecCallbackProc(w, (XtPointer)cmd, &dtCbs);
	    wafeStringClear(ws);
	    XmStringFree(t);
	    }
	else 
	if ((*type == XA_STRING) || (*type == TEXT) || (*type == FILE_NAME))
	    {
	    dtCbs.value = XtMalloc(*length + 1);
	    memcpy((char *)dtCbs.value, (char *)value, *length);
	    *((char*)(dtCbs.value) + *length) = '\0';
 	    }
	else
	if (*type == XT_CONVERT_FAIL)
	    wafeWarn("selectionCallbackProc","conversion failed",
		     NULL,NULL,NULL);
	else 
	if (*type != A_NULL && (*type != 0))
	    {
	    char *p;
            p = XGetAtomName(dpy,*type);
	    wafeWarn("selectionCallbackProc", "unknown type %s",
		     p,NULL,NULL);
	    if (p) XFree(p);
	    }
	}
    }


Boolean
CvtStringToCallbackProc(dpy, args, num_args, fromVal, toVal,
		    converter_data)
Display *dpy;
XrmValue *args;
Cardinal *num_args;
XrmValue *fromVal;
XrmValue *toVal;
XtPointer *converter_data;
    {
    char *charp = XtMalloc(strlen(fromVal->addr)+1+sizeof(XrmQuark));

    WAFE_UNUSED(dpy);
    WAFE_UNUSED(args);
    WAFE_UNUSED(num_args);
    WAFE_UNUSED(converter_data);

    *(XrmQuark *)charp = wafeCurrentAttrib;
    strcpy((char *)charp + sizeof(XrmQuark), (char *)fromVal->addr);
    wafeMMreplace(NULL, NULL, wafeCurrentAttrib, (char *)charp, XtFree);
    WAFE_CONVERSION_DONE(XtCallbackProc, callbackProc);
    }


Boolean
CvtStringToDragOperations(dpy, args, num_args, fromVal, toVal, converter_data)
Display *dpy;
XrmValue *args;
Cardinal *num_args;
XrmValue *fromVal;
XrmValue *toVal;
XtPointer *converter_data;
    {
    unsigned char result = '\0';
    char *p=strtok(fromVal->addr,"|");

    WAFE_UNUSED(dpy);
    WAFE_UNUSED(args);
    WAFE_UNUSED(num_args);
    WAFE_UNUSED(converter_data);

    do
	{
	if (!strcmp("DROP_COPY",p))
	    result |= XmDROP_COPY;
	else 
	if (!strcmp("DROP_MOVE",p))
	    result |= XmDROP_MOVE;
	else 
	if (!strcmp("DROP_LINK",p))
	    result |= XmDROP_LINK;
	else 
	if (!strcmp("DROP_NOOP",p))
	    result = XmDROP_NOOP;
	else
	    return False;
	}
    while ((p = strtok(NULL,"|")));
    WAFE_CONVERSION_DONE(unsigned char, result);
    }

Boolean
CvtStringToTransferStatus(dpy, args, num_args, fromVal, toVal, converter_data)
Display *dpy;
XrmValue *args;
Cardinal *num_args;
XrmValue *fromVal;
XrmValue *toVal;
XtPointer *converter_data;
    {
    unsigned char result = '\0';

    WAFE_UNUSED(dpy);
    WAFE_UNUSED(args);
    WAFE_UNUSED(num_args);
    WAFE_UNUSED(converter_data);

    if (!strcmp("TRANSFER_SUCCESS",fromVal->addr))
	result = XmTRANSFER_SUCCESS;
    else 
    if (!strcmp("TRANSFER_FAILURE",fromVal->addr))
	result = XmTRANSFER_FAILURE;
    else
	return False;

    WAFE_CONVERSION_DONE(unsigned char, result);
    }


Boolean
CvtStringToConvertSelectionIncrProc(dpy, args, num_args, fromVal, toVal,
		    converter_data)
Display *dpy;
XrmValue *args;
Cardinal *num_args;
XrmValue *fromVal;
XrmValue *toVal;
XtPointer *converter_data;
    {
    char *charp = XtMalloc(strlen(fromVal->addr)+1+sizeof(XrmQuark));

    WAFE_UNUSED(dpy);
    WAFE_UNUSED(args);
    WAFE_UNUSED(num_args);
    WAFE_UNUSED(converter_data);

    *(XrmQuark *)charp = wafeCurrentAttrib;
    strcpy((char *)charp + sizeof(XrmQuark), (char *)fromVal->addr);
    wafeMMreplace(NULL, NULL, wafeCurrentAttrib,(char *)charp, XtFree);
    WAFE_CONVERSION_DONE(XtConvertSelectionIncrProc, convertSelectionIncrProc);
    }


Boolean
CvtStringToSelectionCallbackProc(dpy, args, num_args, fromVal, toVal,
		    converter_data)
Display *dpy;
XrmValue *args;
Cardinal *num_args;
XrmValue *fromVal;
XrmValue *toVal;
XtPointer *converter_data;
    {
    char *charp = XtMalloc(strlen(fromVal->addr)+1+sizeof(XrmQuark));

    WAFE_UNUSED(dpy);
    WAFE_UNUSED(args);
    WAFE_UNUSED(num_args);
    WAFE_UNUSED(converter_data);

    *(XrmQuark *)charp = wafeCurrentAttrib;
    strcpy((char *)charp + sizeof(XrmQuark), (char *)fromVal->addr);
    wafeMMreplace(NULL, NULL, wafeCurrentAttrib,(char *)charp, XtFree);
    WAFE_CONVERSION_DONE(XtSelectionCallbackProc, selectionCallbackProc);
    }

static XmDropTransferEntryRec *
string2transferEntryRec(string,dpy)
_Xconst String string;
Display *dpy;
    {
    char **argv, **p, **innerArgv;
    int argc, count, n;
    XmDropTransferEntryRec *entries, *dropRecs;
    
    DBUG_ENTER("string2transferEntryRec");

    if (Tcl_SplitList(wafeInterpreter, string, &argc, &argv) == TCL_ERROR)
	{
	wafeWarn("CvtToDropTransfer", wafeInterpreter->result,
		 NULL,NULL,NULL);
	DBUG_RETURN((XmDropTransferEntryRec *)NULL);
	}
    count = argc;

    dropRecs = entries = 
      (XmDropTransferEntryRec*)XtMalloc(sizeof(XmDropTransferEntryRec)*count);
    for (p = argv; count>0; count--,p++)
	{
	if (Tcl_SplitList(wafeInterpreter, *p, &n, &innerArgv) == TCL_ERROR)
	    {
	    wafeWarn("CvtToDropTransferArg", wafeInterpreter->result,
		     NULL,NULL,NULL);
	    DBUG_RETURN((XmDropTransferEntryRec *)NULL);
	    }
	if (n != 2)
	    {
	    wafeWarn("CvtToDropTransferArg", 
		    "DropTransferRec should have two elements",
		     NULL,NULL,NULL);
	    XtFree((char *)argv);
	    DBUG_RETURN((XmDropTransferEntryRec *)NULL);
	    }
	entries->target = XInternAtom(dpy, innerArgv[0], False);
	entries->client_data = 
	  (XtPointer)wafeCvtName2Widget(innerArgv[1],True,NULL);
	entries++;
	XtFree((char *)innerArgv);
	}
    XtFree((char *)argv);
    DBUG_RETURN(dropRecs);
    }


Boolean
CvtStringToDropTransfers(dpy, args, num_args, fromVal, toVal,
		    converter_data)
Display *dpy;
XrmValue *args;
Cardinal *num_args;
XrmValue *fromVal;
XrmValue *toVal;
XtPointer *converter_data;
    {
    XmDropTransferEntryRec *dropRecs;

    WAFE_UNUSED(args);
    WAFE_UNUSED(num_args);
    WAFE_UNUSED(converter_data);

    if (!(dropRecs = string2transferEntryRec(fromVal->addr,dpy)))
	return False;
    
    wafeMMreplace(NULL, NULL, wafeCurrentAttrib, (char *)dropRecs, XtFree);
    WAFE_CONVERSION_DONE(XmDropTransferEntryRec*, dropRecs);
    }


static void
CBfreeAttribs(w, client_data, call_data)
Widget w;
caddr_t client_data;
caddr_t call_data;
    {
    WAFE_UNUSED(client_data);
    WAFE_UNUSED(call_data);

    (void)wafeMMfreeGarbage(w);
    }
