/*
 * Copyright (C) 1992 by Gustaf Neumann, Stefan Nusser
 *
 *      Wirtschaftsuniversitaet Wien,
 *      Abteilung fuer Wirtschaftsinformatik
 *      Augasse 2-6,
 *      A-1090 Vienna, Austria
 *      neumann@wu-wien.ac.at, nusser@wu-wien.ac.at
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided
 * that the above copyright notice appears in all copies and that both that
 * copyright notice and this permission notice appear in all supporting
 * documentation.  This software is provided "as is" without expressed or
 * implied warranty.
 *
 * Date: Mon, Apr 13 1992
 * Author: Stefan Nusser, Gustaf Neumann
 * Version: 0.96
 */

#define CREATEW_C

#include "wafe.h"
#include "wafe_quarks.h"

#ifdef ATHENA
#include <X11/Xaw/List.h>
#endif

static _Xconst String managedString[] =  { "unmanaged", "managed", NULL };

static int
tclWidgetCommand(clientData, comInterpreter, argc, argv)
ClientData   clientData;
Tcl_Interp  *comInterpreter;
int          argc;
char       **argv;
    {
    Widget         parent, newWidget;
    char          *name;
    char          *widgetClassName;
    ArgList        args;
    Cardinal       numArgs;
    char           *displayString = NULL;
    Boolean        managed = True,
                   freeArgv = False,
                   mustManuallyManage = False;
    static char    intBuffer[INT_AS_STRING];
    WidgetCreate_signature *wccs = (WidgetCreate_signature *)clientData;

    DBUG_ENTER("tclWidgetCommand");
    if (argc < 3) 
	DBUG_RETURN (wafeArgcError(argc, argv,"at least ",2));

    widgetClassName = *argv;
    name = *(++argv);

    DBUG_PRINT("create",("class = '%s', name = '%s'", widgetClassName, name));
    if (!name || !*name || (*name <= '9' && *name >= '0') ||
	*name == '-' || *name == '*' || *name == '.')
	wafeWarn(widgetClassName,
		"Widget name should start with an alphabetic character: <%s>!",
		 name,NULL,NULL);

    argv++;
    
    /* will open shell on a different display */
    if (wccs->wCreateFunction == XtAppCreateShell)
	{
	displayString = *argv;
	parent = NULL;   /* will not be used, only to make -Wall happy */
	}
    else 
    if ( wccs->createsShell )
	/* if we create a shell, the parent can be of any class */
	{
	if (!(parent = name2Widget(*argv))) 
	    DBUG_RETURN(wafeConvError(argc, argv-2, 2, NULL, XtRWidget));
	}
    else
	/* parent must be composite */
	{
	if (!(parent = name2WidgetOfClass(*argv, compositeWidgetClass)))
	    DBUG_RETURN(wafeConvError(argc, argv-2, 2, NULL, 
				      "CompositeWidget"));
	}

    argc-=3;
    argv++;

    if (argc)
	{
	/* Enter if creation of unmanaged widget... */ 
	if (!strcmp(*argv, managedString[0]))
	    {
	    argv++; 
	    argc--;
	    managed = False;
	    }

	/* Check whether an attribute-value list was given
         * and replace argc and argv if so
         */
	if (argc == 1) 
	    if (wafeMergeArguments(*argv, widgetClassName, &argc, &argv))
		freeArgv = True;

	/* argc must now be even  
	 */
	if (argc % 2)
	    DBUG_RETURN(wafeSetError("Wrong # of arguments in %s %s widget %s",
				     managedString[(int)managed],
				     widgetClassName, name));
	}

    if (wccs->classInit)  
	{
	(*wccs->classInit)(wccs->wClass);
	wccs->classInit = NULL;
	}
    
    if (wafeConvert(parent, wccs->wClass, argv, &argc, &args, &numArgs, NULL))
	{
	Boolean pointerResourceResetted = False;

	if (wccs->wCreateFunction == NULL) /*no special create procedure used*/
	    {
	    newWidget = (managed ? XtCreateManagedWidget : XtCreateWidget)
		(name, wccs->wClass, parent, args, numArgs);
	    }
	else 
	if (wccs->wCreateFunction == XtCreatePopupShell) 
	    {
	    newWidget = XtCreatePopupShell(name,wccs->wClass,parent,args,numArgs);
	    MOTIF_EDITRES_HANDLER(newWidget);
	    if (!managed)
		wafeWarn(widgetClassName,
		     "Warning: can't create unmanaged shell; shell is managed",
		     NULL,NULL,NULL); 

	    }
	else
	if (wccs->wCreateFunction == XtAppCreateShell) 
	    {
       	    Display *dpy;
#ifdef PRER5
	    Cardinal null = 0;
	    Cardinal *argc = &null;
#else
	    int null = 0;
	    int *argc = &null;
#endif
	    /* assert(parent == NULL);*/

	    dpy = XtOpenDisplay(wafeAppContext,displayString, 
				Nil(char), Nil(char), 
				Nil(XrmOptionDescRec), 0, 
				argc, Nil(String));
	    if (dpy == NULL) 
		DBUG_RETURN(wafeSetError("%s: cannot open display <%s>",
					 widgetClassName, displayString, 
					 NULL));     

	    newWidget = XtAppCreateShell(XtName(wafeTopLevel), 
					 wafeAppClass, wccs->wClass, dpy, 
					 args, numArgs);
	    wafeAddToEndOfWidgetList(&wafeWidgetTrees, 
				     newWidget, XtNewString(name));
	    MOTIF_EDITRES_HANDLER(newWidget);
	    if (!managed)
	      wafeWarn(widgetClassName,
		      "cannot create unmanaged shell; shell is managed", 
		       NULL,NULL,NULL);
	    }
	else
	if (wccs->wCreateFunction == WafeDontManage) 
	    {
	    newWidget = XtCreateWidget(name, wccs->wClass, parent, args, numArgs);
	    }
        else
	    {
	    /* Use function pointer to create widget */
	    newWidget = (*wccs->wCreateFunction)(parent, name, args, numArgs);
	    /* delay manage until all resources are set */
	    mustManuallyManage = managed; 
            /* fprintf(stderr,"createfunction, manage=%d\n",managed);*/
	    /* these commands create as a side effect a parent shell */
	    if (wccs->createsShell)
	        {
		MOTIF_EDITRES_HANDLER(XtParent(newWidget));
	        }
	}


#ifdef WIDGETLISTTRACE
	fprintf(stderr,"----------------------------\n");
	printWidgetList(NULL);
#endif
	
	DBUG_PRINT("create", ("Created %s %s widget <%s> [%p]", 
			      managedString[(int)managed],
			      widgetClassName, name, newWidget));
	XtFree((char*)args);
	/*
	 * now convert pointer attributes that were set via resources
	 * these conversion were aborted....
         */

	DBUG_PRINT("create",("pointerResourceValue %d, delayed args=%d)",
			     wafePointerResourceValue,argc));

	if (wafePointerResourceValue) 
	    {
	    pointerResourceResetted = wafeResetResource(newWidget, qPointer);
	    wafePointerResourceValue = False;
	    }
	

	/*
	 * now convert attributes that need the actual widget instance;
	 * these conversion were delayed....
         */

	if (argc > 0  || pointerResourceResetted)
	    {
#ifdef ATHENA
	    Boolean mustResetNumberStrings;
	    Boolean mustResetLongest;

	    mustResetNumberStrings = 
		mustResetLongest = 
		(wccs->wClass == listWidgetClass) ?
		    pointerResourceResetted : False;
#endif			
	    
	    if (argc>0)
		{
		if (wafeConvert(parent, wccs->wClass, argv, &argc, 
				&args, &numArgs, newWidget))
		    {
#ifdef ATHENA
		    if (wccs->wClass == listWidgetClass) 
			wafeCheckListWidgetResources(numArgs,args, 
						     pointerResourceResetted,
						     &mustResetNumberStrings,
						     &mustResetLongest);
#endif
		    XtSetValues(newWidget, args, numArgs);
		    XtFree((String)args);
		    }
		}

#ifdef ATHENA
	    /*fprintf(stderr,"mustResetNumberStrings = %d\n",
		    mustResetNumberStrings);*/
	    
	    if (mustResetNumberStrings)
		XtVaSetValues(newWidget,  XtNnumberStrings,0, NULL);
# ifdef PRER6
	    if (mustResetLongest)
		XtVaSetValues(newWidget,  XtNlongest,0,       NULL);
# endif
#endif
	    }
	

	if (mustManuallyManage && XtIsRectObj(newWidget)) 
	    XtManageChild(newWidget);

	/* set attriblist(newWidget) to wafeCurrentAttribList) */
	wafeMMsetAttribList(newWidget); 
	wafeCurrentAttribList = NULL;

	sprintf(intBuffer,"%ld",(long)newWidget);
	Tcl_SetResult(comInterpreter, intBuffer, TCL_STATIC);

	DBUG_RETURN(TCL_OK);
	}
	
    wafeCurrentAttribList = NULL;
    XtFree((char*)args);
    if (freeArgv) XtFree((char *)argv);

    DBUG_RETURN(wafeSetError("Couldn't create %s %s widget named <%s>",
			     managedString[(int)managed],
			     widgetClassName, name));
    }
       
static int
warningCommand(clientData, comInterpreter, argc, argv)
ClientData   clientData;
Tcl_Interp  *comInterpreter;
int          argc;
char       **argv;
    {
    WAFE_UNUSED(comInterpreter||argc||argv);
    wafeFatal((char *)clientData,
            "This command is not available in your configuration", NULL);
    return(TCL_OK);
    }

#ifdef NEVER
static void 
wafeCreateWidgetCommand(command, wClass, wCreateFunction, createsShell)
_Xconst String command;
WidgetClass wClass;
widgetProc wCreateFunction;
Boolean createsShell;
    {
    wComInfoPtr  wInfoPtr;

    DBUG_ENTER("wafeCreateWidgetCommand");

    if (!wClass)
	{
	Tcl_CreateCommand(wafeInterpreter, command, 
			  warningCommand, (ClientData)command, NULL);
	DBUG_PRINT("create",("Warning command %s created", command));
	DBUG_VOID_RETURN;
	}

    XtInitializeWidgetClass(wClass); 

    wInfoPtr = (wComInfoPtr)XtMalloc(sizeof(wComInfo));
    wInfoPtr->wClass = wClass;
    wInfoPtr->wCreateFunction = wCreateFunction;
    wInfoPtr->createsShell = createsShell;

    Tcl_CreateCommand(wafeInterpreter, command, 
		      tclWidgetCommand, (ClientData)wInfoPtr, NULL);

    DBUG_PRINT("create",("Command %s created", command));
    DBUG_VOID_RETURN;
    }
#endif


typedef struct _wClasses
    {
    char *package;
    _Xconst WidgetCreate_signature *wccs;
    struct _wClasses *next;
    } wClasses, *wClassesPtr;

static wClassesPtr knownClasses = NULL;

void
wafeInitClass(pkg,className)
_Xconst String pkg;
_Xconst String className;
    {
    wClassesPtr w = knownClasses;
    /* fprintf(stderr,"wafeInitClass %s %s\n", pkg, className);*/
    for (; w; w=w->next)
	{
	/* fprintf(stderr,"checking  package %s\n", w->package);*/
	if (!pkg || (w->package && !strcmp(w->package,pkg)))
	    {
	    WidgetCreate_signature *wccs = w->wccs;
	    /* fprintf(stderr,"found package %s\n", pkg); */
	    for(; wccs->name; wccs++)
		{
		/*
		 fprintf(stderr,"checking  class %s - %s\n", 	
		   className, wccs->name);*/
		if (!strcmp(wccs->name,className))
		    {
		    /* fprintf(stderr,"found %s\n", className);*/
		    if (wccs->classInit)
			{
			/* fprintf(stderr,"initialized\n");*/
			(*wccs->classInit)(wccs->wClass);
			wccs->classInit = NULL;
			}
		    break;
		    }
		}
	    break;
	    }
	}
    }


void
wafeCreateTclCmds(pkgs,wccs,cmds)
_Xconst String *pkgs;
_Xconst WidgetCreate_signature *wccs;
_Xconst Proc_signature *cmds;
    {
    if (wccs)
	{
	wClassesPtr tmp = knownClasses;
	knownClasses = (wClassesPtr)XtMalloc(sizeof(wClasses));
	knownClasses->package = *pkgs;
	knownClasses->wccs = wccs;
	knownClasses->next = tmp;
	/* fprintf(stderr,"adding package %s\n", *pkgs); */
	
	while(wccs->name) 
	    {
	    if (wccs->wClass)
		{
		if (wccs->init)
		    XtInitializeWidgetClass(wccs->wClass);

		Tcl_CreateCommand(wafeInterpreter, wccs->name, 
				  tclWidgetCommand, 
				  (ClientData)wccs, NULL);
		}
	    else 
		{
		Tcl_CreateCommand(wafeInterpreter, wccs->name, 
				  warningCommand, (ClientData)wccs->name, 
				  NULL);
		}
	    
	    wccs++;
	    }
	}

    if (cmds)
	while(cmds->name) 
	    {
	    if (cmds->proc)
		Tcl_CreateCommand(wafeInterpreter,
				  cmds->name, cmds->proc, NULL,NULL);
	    cmds++;
	    }

    if (pkgs)
	while(*pkgs)
	    {
	    Tcl_SetVar(wafeInterpreter,"PACKAGES", *pkgs,
		       TCL_GLOBAL_ONLY|TCL_APPEND_VALUE|TCL_LIST_ELEMENT);
	    pkgs++;
	    }
    }

void
wafeCreateTclProcs(cmds)
_Xconst Proc_signature *cmds;
    {
    if (cmds)
	while(cmds->name) 
	    {
	    if (cmds->proc)
		Tcl_CreateCommand(wafeInterpreter,
				  cmds->name, cmds->proc, NULL,NULL);
	    cmds++;
	    }
    }
