$PACKAGE = "XT", $UBIQUITUS=1;

~handles
	LAYOUT

#include <X11/Xatom.h>
#include <X11/Xmu/Converters.h>

~require 
	Xt.inc
	quark XtRString
	quark XtRCallback
	quark XtRPointer
	quark XtNcallback
	privateQuark XtRInt
	privateQuark "Long"
	privateQuark XtRDimension
	privateQuark XtRCardinal
	privateQuark XtRPosition
	privateQuark XtRFloat
	privateQuark Double
	privateQuark XtRPixel
	privateQuark XtRBoolean
	privateQuark XtRWidgetList
	privateQuark XtRWidget
	conv XtRString XtRWidget     None CvtStringToWidget
	conv XtRString XtRCallback   None CvtStringToCallback
	conv XtRString XtRWidgetList None CvtStringToWidgetList
	conv XtRString XtRPointer    None CvtStringToPointer
        nsConv WidgetList XtNchildren XtNnumChildren NULL \
		wafeCvtWidgetListToList XtFree NULL NULL
	rConv XtRInitialState int toString \
	      "NormalState","IconicState" \
	      NormalState,IconicState
	init #ifndef PRER5
	conv XtRString XtRCardinal   None XtCvtStringToInt
	init #endif
	conv XtRString XtRPixel ByDisplay CvtStringToPixel wafeColorConvertArgs FreePixel
#	conv XtRString XtRFontStruct ByDisplay wafeCvtStringToFontStruct displayConvertArg FreeFontStruct

#> The command 'addTimeOut' creates a timeout and returns an identifier
#> for it.  The timeout interval is set in ms.  The callback procedure
#> (the specified Tcl command) is called when the time interval
#> elapses, and then the timeout is removed.

XtIntervalId
XtAppAddTimeOut 
	const: wafeAppContext 
	in: unsigned long		# time interval in ms
	const: timerProc
	in: XtNewString(String)		# Tcl command


#> The command 'action' calls depending on its 2nd argument the Xt
#> functions XtAugmentTranslations, XtOverrideTranslations or
#> XtSetValues to update the translation table of the specified
#> widget.
#> 
#> If "augment" is specified the function nondestructively merges the
#> new translations into the existing widget translations.  If the new
#> translations contain an event or event sequence that already exists
#> in the widget's translations, the new translation is ignored.
#> 
#> If "override" is specified the function destructively merges the
#> new translations into the existing widget translations.  If the new
#> translations contain an event or event sequence that already exists
#> in the widget's translations, the new translation is merged in and
#> override the widget's translation.
#> 
#> If "replace" is specified the function replaces the existing
#> translation table completely with the specified table.

void
action
	in: Widget			# widget
	in: (int)TranslationModifier	# override | augment | replace
        in: XtTranslations		# translation table

#> The ApplicationShell widget class is a subclass of TopLevelShell
#> that is used for normal top level application window. Instead of
#> the parent diget the third argument is interpreted as display
#> string (eg unix:0.0).

~widgetClass
ApplicationShell
	createCmd XtAppCreateShell

#> The command 'bell' rings the bell on the keyboard of the display of
#> the specified widget, if possible.  The specified volume is
#> relative to the base volume for the keyboard.  If the value for the
#> percent argument is not in the range -100 to 100 inclusive, a
#> BadValue error results.  The volume at which the bell rings when
#> the percent argument is nonnegative is:
#>
#>             base - [(base * percent) / 100] + percent
#>
#> The volume at which the bell rings when the percent argument is
#> negative is:
#>
#>               base + [(base * percent) / 100]

void
XBell
        in: XtDisplay(Widget{Display})	# widget to determine display
	in: int				# percent (-100 = off, 0 .. 100)

#> The command 'callActionProc' can be used to call explicitely the
#> specified action procedure of the given widget. CallActionProc
#> searches for the named action routine in the same manner and order
#> as translation tables are bound.  If found, the action routine is
#> invoked with the specified widget, event pointer, and parameters.
#> Certain parts of the event structure can be specified via the 2nd
#> argument.

void
callActionProc
	in: Widget			# widget
	in: String			# event structure
	in: String			# name of action procedure
	in: [args opt]			# parameters of action procedure

#> The command 'callCallbacks' calls each procedure that is registered
#> in the specified widget's callback list. The optional constant
#> "float" and value should be used only for callback procedures that
#> expect this in their CallData arguments (eg. the "jumpProc"
#> callback in the athena Scrollbar widget class).

void
callCallbacks
	in: Widget			# widget
	in: String			# callback
	in: [args opt]			# optional float and value 

#> The command 'callback' can be used to set the callback resource of
#> the named widget to one of Wafe's predefined toolkit function. For
#> the predefined types refer to the following table. Note that the
#> execution of a Wafe command can be registered with the callback
#> resource of a widget with the setValues command.
#>
#>   none             realize a popup-shell, grab-type none
#>   exclusive        realize a popup-shell, grab-type exclusive
#>   nonexclusive     realize a popup-shell, grab-type nonexclusive
#>   popdown          unrealize a popup-shell
#>   position         position a popup-shell relative to its parent
#>   positionCursor   position a popup-shell under the cursor
#> 
#> The contents of 4th argument depend on the predefined callback
#> types and is a widget reference, if the 3rd argment is "none",
#> "exclusive", "nonexclusive" or "popdown". if the 3rd argument is
#> "position", the 4th argument has the form
#> "widgetreference:xoffset/yoffset", where the offsets are
#> optional. If the 3rd argument is "positionCursor" the 4th argument
#> will be treated as a relative position. If it is 0 the widget will
#> pop up centered over the cursor if possible.

extern wafePositionCallbackProc();
extern wafePositionCursorCallbackProc();

#define wafeCallbackCmdArgs(w,res,type,arg) wafeCallbackCmd(argc,argv,w,type) 

TCL_RETURN_CODE
wafeCallbackCmdArgs vulgo callback
	in: Widget			# widget
	in: String			# callback resource
        in: XtCallbackProc		# none | exclusive | nonexclusive | popdown | position | positionCursor
        in: String			# string (depends on third argument, widget reference for none | exclusive | nonexclusive | popdown)

#> The command 'combineFileDatabase' merges the contents of a resource
#> file (1st argument) into the the resource database of the screen on
#> which the specified widget (2nd argument) is being displayed. If
#> the same resource specifier is used for an entry in both the
#> resource file and the resource database, the entry in the file will
#> replace the entry in the database if override (3rd argument) is
#> true; otherwise, the entry in file is discarded.  The file is
#> parsed in the current locale.  If the cannot be read a zero status
#> is returned; otherwise a nonzero status is returned.  The database
#> entries are merged without changing values or types, regardless of
#> the locale of the database.

hint: R5
Status
combineFileDatabase
	in: String			# filename
        in: Widget{Display}		# widget to determine database
	in: Bool			# override


#> The command 'destroyWidget' takes any number of widget references
#> as arguments, destroys these and releases all widget specific
#> allocated resources.

void
XtDestroyWidget
	callmultiple
		in: wafeMMfreeGarbage(Widget)	# widgets

#> The command 'fallbackResources' can be used to specify default
#> resource values within a Wafe application. The first argument is
#> used to determine the resource database, the following arguments
#> are attribute (resource specifications)/value pairs. 
#> 
#> If a matching ressource entry is already available in the resource
#> database, the provided value in fallbackResources is ignored.
#> FallbackResources have the lowest priority and can be used
#> conveniantely together with resource files, which have an higher
#> priority. They should be used to provide default resources.
#>
#> Note that with 'fallbackResources' one can specify class names as
#> well as instance names in resource specifications, the same syntax
#> as in an application default files can be used. Therefore the
#> resource specification can, in contrast to the 'setValues' command,
#> be applied to several widgets in the application. Note as well,
#> that the resources will be evaluated typically when a widget is
#> created; therefore 'fallbackResources' does not change resources of
#> already created widgets.

#define fallbackResources(localVar1,argc,argv) { \
     XrmDatabase    dispDb, newDb = NULL; \
     int            i; \
     char         **v = argv; \
     dispDb = XtDatabase(XtDisplay(localVar1)); \
     for (i = 0; i < argc; i+=2)  { \
	if (*v[i] == '#') continue; \
        XrmPutStringResource(&newDb, v[i], v[i+1]); \
     } \
     XrmCombineDatabase(newDb, &dispDb, False);}

hint: R5
void 
fallbackResources
        in: Widget{Display}		# widget to determine database
	in: [args avp] 			# resource-specification  value pairs


#> The function 'fontHeight' returns the height of a font in
#> pixels. The font is taken is taken from the given 'fontResource'
#> (2nd argument) of the given widget (first argument).

#define fontHeight(w,resource) \
         (font->max_bounds.ascent + font->max_bounds.descent)

int
fontHeight
	pre: {XFontStruct *font; \
              XtVaGetValues(localVar1, argv[2], &font, NULL);
	in: Widget			# Widget
	in: String			# fontResource
        post: }


#> The command 'xflush' flushes the output buffer from the client to X
#> server connection.  Most client applications need not use this
#> function because the output buffer is automatically flushed as
#> needed by calls to XPending, XNextEvent, and XWindowEvent.  Events
#> generated by the server may be enqueued into the library's event
#> queue.

void
XFlush vulgo xflush
        in: XtDisplay(Widget{Display})		# Widget to determine display

#> The function 'getApplicationResource' can be used to obtain values
#> from the Xt's resource database from the screen of the specified
#> widget (1st argument). The provided resourceName (2nd argument) and
#> resourceClass (3rd argument) can be arbitrary, application specific
#> strings different from with the widget's resources provided by the
#> toolkit.  On success the return value is the fetched resource
#> value, on failure, an empty string is returned. For Boolean
#> resources (the specified resource class is "Boolean"), 0 or 1 is
#> returned.

String
wafeGetApplicationResource vulgo getApplicationResource
	in: Widget			# base widget 
	in: String			# resource name
	in: String			# resource class


#> The function 'getClass' returns the class of the specified widget
#> in form of a string.

#include <X11/IntrinsicP.h>
#define getClass(widget) (XtClass(widget)->core_class.class_name)

String
getClass
	in: Widget			# widget

#> The command  'getResourceList' returns the number of
#> resources for a specified widget instance and the list of resources
#> in the variable specified as third argument. Note that the returned
#> list might contain inherited geometry constraint resources and the
#> like.

int
getResourceList
	in: Widget	     # widget
	out: String *        # variable name for output of list of resources 
	end: XtFree((String)localVar2);


#> The function 'getTypeOfAttribute' returns the type of the given
#> attribute (2nd argument) for the specified widget (first
#> argument). If the widget class does not have an attribute with the
#> given name, an empty string is returned.

XrmQuark
wafeGetQTypeOfAttribute vulgo getTypeOfAttribute
	in: XtClass(Widget)		# widget
	const: ParentWidget(localVar1)
	in: XrmStringToQuark(String)	# attribute
	const: NULL


#> The function 'getValue' returns the resource value for a resource
#> (2nd argument) of the the specified widget (first argument).  Note
#> that Wafe tries to convert the result to the best possible string
#> representation suitable for Tcl; however, some attributes cannot
#> be converted into a string.

String
getValue
	in: Widget			# widget
	in: XrmQuark			# attribute
	free: freeProc

#> The function 'grabKeyboard' establishes an active keyboard grab
#> with the specified widget's window as the grab window. It returns
#> on success "success" or on failure "alreadyGrabbed", "notViewable"
#> or "frozen". When the keyboard is grabbed, all key events will be
#> delivered to the specified widget, regardless of the location of
#> the pointer. If the second argument 'owner events' is false, all
#> generated key events are reported. If the 2nd argument is true, the
#> events are reported as usual. 
#> 
#> The 3rd argument controls pointer processing during the grab, the
#> 4th keyboard processing. If the 'pointer mode' (3rd argument) is
#> "async" key event processing continues as usual, if it is 'sync'
#> the state of the pointer as seen by the application appears to be
#> frozen.  If the 'keyboard mode' (4th argument) is 'async', keyboard
#> event processing is unaffected by the activation of the grab, if it
#> is 'sync', the state of the keyboard as seen by the application
#> appears to be frozen.
#> 
#> The 5th argument 'confine widget' can be 'None' or a widget
#> reference. In the latter case, the pointer is restricted to stay in
#> the window of the specified widget.

(int) GrabReturns
XtGrabKeyboard
	in: Widget			# widget
	in: Boolean			# true | false
	in: (int) SyncAsync		# pointer mode (sync | async)
	in: (int) SyncAsync		# keyboard mode (sync | async)
	const: CurrentTime

#> The function 'grabPointer' establishes an active pointer grab with
#> the specified the widget's window as the grab window. It returns on
#> success "success" or on failure "alreadyGrabbed", "notViewable" or
#> "frozen". When the pointer is grabbed, all pointer events will be
#> delivered to the specified widget, regardless of the location of
#> the pointer. If the second argument 'owner events' is false, all
#> generated pointer events are reported.If the 2nd argument is true,
#> the events are reported as usual.
#> 
#> The 3rd argument controls pointer processing during the grab, the
#> 4th keyboard processing. If the 'pointer mode' (3rd argument) is
#> "async" pointer event processing continues as usual, if it is
#> 'sync' the state of the pointer as seen by the application appears
#> to be frozen.  If the 'keyboard mode' (4th argument) is 'async',
#> keyboard event processing is unaffected by the activation of the
#> grab, if it is 'sync', the state of the keyboard as seen by the
#> application appears to be frozen.
#> 
#> The 5th argument 'confine widget' can be 'None' or a widget
#> reference. In the latter case, the pointer is restricted to stay in
#> the window of the specified widget.

(int) GrabReturns
XtGrabPointer
	in: Widget			# widget
	in: Boolean			# owner events
        const: NoEventMask
	in: (int) SyncAsync		# pointer mode (sync | async)
	in: (int) SyncAsync             # keyboard mode (sync | async)
	in: None | XtWindow(Widget)	# None | confine widget
	const: None
	const: CurrentTime

#> The function 'heightOfScreen' returns the height of the screen (on
#> which the specified widget is displayed) in pixels.

int
HeightOfScreen
	in: XtScreen(Widget)     	# widget to determine screen

#> The command 'installAccelerators' merges the accelerator table from
#> 'source' (2nd argument) to 'destination' (1st argument).
#> Accelerators provide a facility by which actions defined in one
#> widget can be triggered by events in another widget.  The resource
#> named 'accelerators' of the 'source' widget should be set to the
#> accelerator table before this command is issued (eg. via the
#> application default file or sV etc.). After this call events in the
#> 'destination' widget will trigger actions in the 'source' widget.

void
XtInstallAccelerators
	in: Widget			# destination
	in: Widget			# source

#> The command 'installAllAccelerators' installs the accelerators from
#> 'source' (2nd argument) and its children to 'destination' (1st
#> argument).  Accelerators provide a facility by which actions
#> defined in one widget can be triggered by events in another widget.
#> The resource named 'accelerators' of the 'source' widget should be
#> set to the accelerator table before this command is issued (eg. via
#> the application default file or sV etc.). After this call events in
#> the 'destination' widget will trigger actions in the 'source'
#> widget.

void
XtInstallAllAccelerators
	in: Widget			# destination
	in: Widget			# source

#> The function 'isWidget' returns 0 if no widget with the widget
#> reference exists currently, otherwise non-zero.

WidgetID (WidgetID)
name2WidgetId vulgo isWidget
	in: String			# widget name 


#> The Layout widget class is a very powerful constraint widget with
#> TeX like semantics. It can be used to define the gemoetry of a
#> composite widget in terms of (stretchable) boxes and (tretchable)
#> glue. In order to use this widget class, LAYOUT must be specified during
#> compilation.


hint: LAYOUT
~widgetClass 
Layout
	include "Layout.h"

#> The command 'lowerWindow' lowers the window of the specified widget
#> in the stacking hierarchy of the window manager. The specified
#> widget must be realized (it must have already a window assigned).

void
XLowerWindow
	in: XtDisplay(Widget{Display,Window})	# widget to be lowered
	const: XtWindow(localVar1)

#> The command 'manageChild' takes any number of widgets as arguments
#> and brings them under parental (geometry) management. This is only
#> necessary, when the widget creating command are used with the
#> 'unmanaged' argument or the widget has been set explicitely to
#> unmanaged. All widgets specified in the argument list have to have
#> the same parent widget.

void
XtManageChildren vulgo manageChild
        in: [Widget{Parent}]	        # widgets
	const: argc -1

#> The command 'mapWidget' maps all specified widgets to the
#> associated display.

void
XtMapWidget
	callmultiple
		in: Widget		# widgets

#> The command 'mergeResources' can be used to specify resource values
#> within a Wafe application. The first argument is used to determine
#> the resource database, the following arguments are attribute
#> (resource specifications)/value pairs.
#> 
#> If a matching ressource entry is already available in the resource
#> database, it will be replaced by the specified entry.
#>
#> Note that with 'mergeResources' one can specify class names as well
#> as instance names in resource specifications, the same syntax as in
#> an application default files can be used. Therefore the resource
#> specification can, in contrast to the 'setValues' command, be
#> applied to several widgets. Note as well, that the resources will
#> be evaluated typically when a widget is created; therefore
#> 'mergeResources' does not change resources of already created
#> widgets.

#define mergeResources(localVar1,argc,argv) { \
     XrmDatabase    dispDb, newDb = NULL; \
     int            i; \
     char         **v = argv; \
     dispDb = XtDatabase(XtDisplay(localVar1)); \
     for (i = 0; i < argc; i+=2)  { \
	if (*v[i] == '#') continue; \
        XrmPutStringResource(&newDb, v[i], v[i+1]); \
     } \
     XrmMergeDatabases(newDb, &dispDb);}

void 
mergeResources
        in: Widget{Display}		# widget to determine database
	in: [args avp] 			# resource-specification  value pairs


#> The function 'nameToWidget' returns the widget-ID of a widget with
#> the name (widget path) specified in the 2nd argument in the widget
#> tree under the specified widget (1st argument). If no such widget
#> exists the command returns 0.

WidgetID (WidgetID)
XtNameToWidget
	in: Widget			# reference widget
	in: String                      # partial widget name path


#> The widget class 'OverrideShell' is a subclass of the 'Shell'
#> widget class that performs no interaction with the window
#> manager. It is used for widgets (such as popup menues) that should
#> bypass the window manager. If you want a shell that can be
#> iconified, use a TopLevelShell. If you do want window manager
#> interaction use a TransientShell.

~widgetClass
OverrideShell
	createCmd XtCreatePopupShell
	createsShell


#> The function 'parent' returns the widget-ID of the parent widget of
#> the specified widget.

WidgetID (WidgetID)
ParentWidget vulgo parent
	in: Widget			# child widget


#> The command 'popdown' pops a previously created and mapped
#> popup shell down.

void
XtPopdown
        in: ShellWidget			# shell widget

#> The command 'popup' pops an existing TransientShell or
#> OverrideShel up. The kind of grab used is specified with the 2nd
#> argument which is the way how user events are constrained to the
#> popup shell or its children. It can be one of the constants 'none',
#> 'nonexclusive' or 'exclusive'.

void
XtPopup
        in: ShellWidget			# widget
        in: XtGrabKind			# none | nonexclusive | exclusive

#define popupChildren(w) wafeCvtWidgetListToList((w)->core.num_popups,(w)->core.popup_list)

#> The command 'popupChildren' is similar to [gV Widget children] of a
#> composite widget, but it returns the list of popup Shells which are
#> created as children of the given widget. Popup shells are not
#> required to be children of composite widgets. If a widget has no
#> popup children an empty list is returned.

(String) DString
popupChildren
	in: Widget

#> The command 'popupSpringLoaded' displays the specified and
#> previously created shell widget as a spring-loaded popup. This
#> means that the shell is invisible to the window manager and
#> disables user input to all windows except to the popup itself.

void
XtPopupSpringLoaded
        in: ShellWidget			# shell widget

#> The command 'processPendingEvents' processes all currently pending
#> events before continuing with the next tcl command. This can be
#> useful for refreshing the screen while computing heavily in
#> Tcl. Another application area for this command is wafeperl/mofeperl
#> where the use can force screen refresh etc. while computing in
#> Perl.
#> 
#> Note, that by procedding pending events also callback or actions
#> procedures might be triggered by this command, which might issue
#> arbitrary Tcl commands and alter global variables etc.

void
processPendingEvents

#> The command 'raiseWindow' raises the window of the specified widget
#> in the stacking hierarchy of the window manager. The specified
#> widget must be realized (it must have already a window assigned).

void
XRaiseWindow
	in: XtDisplay(Widget{Display,Window})	# widget to be raised
	const: XtWindow(localVar1)


#> The command 'realize' realizes all top level application shells
#> (which is at least the automatically created main shell of the
#> application with the name 'topLevel').

void
realizeWidgets vulgo realize


#> The command 'realizeWidget' realizes all specified widgets. This
#> command should only be used in cases where it is necessary to
#> realize widgets separately (sometimes needed for geometry
#> management).

void
XtRealizeWidget
	callmultiple
		in: Widget		# widgets

#> The command 'removeAllCallbacks' is used to un-register all
#> callback procedures currently associated with the specified
#> callback resource (2nd argument) of the specified widget (1st
#> argument).

void
XtRemoveAllCallbacks
	in: Widget			# widget
	in: String			# callback name


#> The command 'removeTimeOut' removes an timeout command specified by
#> the specified interval ID. The interval ID was obtained by addTimeOut.

void 
XtRemoveTimeOut 
	in: XtIntervalId		# interval ID

#> The command 'resolvePathName' returns the fully qualified filename
#> of a readable file of a certain type (2nd argument) with the
#> specified filename (3rd argument) and the specified suffix (4th
#> argument) on the given path (5th argument). The type specifies the
#> kind of file (eg. 'bitmap' or 'help') and can be referred to via
#> percent code '%T', or it can be empty. If no matching file can
#> be located at the given path, an empty string is returned.

(String) DString
XtResolvePathname
        in: XtDisplay(Widget{Display})  # widget to determine display
	in: NULL | String               # type
	in: NULL | String               # filename
	in: NULL | String               # suffix
	in: NULL | String               # path
	const: NULL                     # substitutions
	const: 0                        # number of Substitutions
	const: NULL                     # XtFilePredicate

#> The command 'setKeyboardFocus' causes keyboard events that occur in
#> the widget hierarchy rooted by the first argument to be be
#> dispatched in the widget specified as 2nd argument.

void
XtSetKeyboardFocus
	in: Widget			# from widget tree
	in: None|Widget			# to widget | None

#> The command 'setSensitive' sets a widget and its children sensitive
#> or insensitive depending on the boolean state argument (2nd argument)

void
XtSetSensitive 
	in: Widget			# widget 
	in: Boolean			# sensitive true | false


#> The command 'setValues' changes one or more attribute-value pairs
#> of the specified widget. According to the argument type, Wafe has
#> to perform different type conversions. Note that some attributes of
#> some widgets cannot be set by this command (for example, there is
#> no string representation of a Colormap). Wafe allows to set
#> attributes of type Callback to be set to Tcl commands.

void
setValues
	in: Widget			# widget
	in: [args avp]			# attribute value pairs

#> The function 'setWMProtocols' sets the WM_PROTOCOLS property of the
#> specified widget's window (usually a shell widget) to one of the
#> three predefined values listed (2nd argument). The specified widget
#> (1st argument) must be realized.
#> 
#> The following example binds the close action of the mwm or similar
#> window managers to a Tcl (Wafe) command.
#> 
#>   setWMProtocols topLevel WM_DELETE_WINDOW
#>   action topLevel override {<Message>WM_PROTOCOLS: exec(puts "hello world")}

#define ADDRESS_OF(w) &(w)

Boolean 
XSetWMProtocols
	const: XtDisplay(localVar1)
        in: XtWindow(ShellWidget{Window})       # Shell Widget
	in: ADDRESS_OF((Atom)WM_PROTOCOLS)	# WM_TAKE_FOCUS | WM_SAVE_YOURSELF | WM_DELETE_WINDOW
	const: 1


#> The command 'sync' flushes the request buffer of the x server on
#> the display of the specified widget. If the 2nd argument is set to
#> true, all events in the input queue are discarded.

void
XSync
        in: XtDisplay(Widget{Display})	# Widget to determine display
	in: Boolean			# Discard (Boolean)

#> The function 'textWidth' returns width of given string (3rd
#> argument) in pixels using font from the specified fontResource (2nd
#> argument) of the specified widget (1st argument). 

#define textWidth(w,resource,string) \
         XTextWidth(font, string, strlen(string))

int
textWidth
	pre: {XFontStruct *font; \
              XtVaGetValues(localVar1, argv[2], &font, NULL);
	in: Widget			# Widget
	in: String			# fontResource
	in: String			# String
        post: }

#> The widget class 'TopLevelShell' is used for additional shells in
#> applications having more than one top-level window (one of which
#> serves as the root of a widget tree instance). The created shell
#> can be separately iconified. If you do not want window manager
#> interaction use a OverrideShell.

~widgetClass
TopLevelShell
	createCmd XtCreatePopupShell
	createsShell

#> The widget class 'TransientShell' is used for pop up shell widgets
#> such as dialog boxes that do not bypass window management. Most
#> window managers will not allow to iconify instances of the
#> TransientShell widget class on it own, and may iconify it
#> automatically if the window, for which the shell is transient for,
#> is iconified. If you want a shell that can be iconified, use a
#> TopLevelShell. If you do not want window manager interaction use a
#> OverrideShell.

~widgetClass
TransientShell
	createCmd XtCreatePopupShell
	createsShell

#> The command 'translateCoords' translates the coordinates 'x' and
#> 'y' coordinates in the given widget into root window
#> coordinates. After the execution the Tcl variables specified in the
#> 4th and 5th argument will be bound with the resulting values.

void
XtTranslateCoords
	in: Widget			# widget
	in: Position    		# x coordinate in widget
	in: Position    		# y coordinate in widget
	out: Position   		# variable name for root window x
	out: Position   		# variable name for root window y

#> The command 'ungrabPointer' releases an active pointer grab.

void
XtUngrabPointer
	in: Widget			# widget with active pointer grab
	const: CurrentTime

#> The command 'ungrabKeyboard' releases an active keyboard grab.

void
XtUngrabKeyboard
	in: Widget			# widget with active keyboard grab
	const: CurrentTime

#> The command 'unmanageChild' takes any number of widgets as
#> arguments and removes them from parental management.  All widgets
#> specified in the argument list have to have the same parent widget.

void
XtUnmanageChildren vulgo unmanageChild
        in: [Widget{Parent}]		# widgets
	const: argc -1

#> The command 'unmapWidget' takes any number of widgets as arguments
#> and unmaps them.

void
XtUnmapWidget
	callmultiple
		in: Widget		# widgets

#> The command 'unrealizeWidget' takes any number of widgets as arguments
#> and unrelaizes them.

void
XtUnrealizeWidget
	callmultiple
		in: Widget		# widgets

#> The function 'waitForVariable' can be used to "wait" in a Tcl
#> command until a Tcl variable is set (eg. from a callback or action
#> routine). While Wafe is waiting, other events can be processed. If
#> the variable is set, 'waitForVariable' returns the variables value.
#> 
#> In a first step, waitForVariable unsets the specified GLOBAL Tcl
#> variable and enters a new event loop. This "inner" event loop will
#> be left, when the specified variable is set. 
#> 
#> 'waitForVariable' is commonly used for synchronization tasks.

String
waitForVariable
	in: String			# variable name

~alias 
	widgetId isWidget

#> The function 'widgetName' returns the name of the specified widget.

Widget
name2WidgetId vulgo widgetName
	in: String			# widget reference 

#> The function 'widthOfScreen' returns the width of the screen on
#> which the specified widget is displayed in pixels.

int
WidthOfScreen
	in: XtScreen(Widget)     	# widget to determine screen

#> The function 'window' returns the window id of the specified widget.

long (long)
XtWindow
        in: Widget     			# widget whose window you want










#####  selection handling #####

#> The command 'disownSelection' can be used if a widget explicitly
#> wants to disclaim its ownership of the PRIMARY selection
#> buffer. Note that the widget automatically looses the ownership,
#> whenever an other widget claims to be the owner. The specified
#> widget must be realized.

void
XtDisownSelection
        in: Widget{Window}         # widget making the request
	const: XA_PRIMARY
	const: CurrentTime


#> The command 'getSelectionValue' is used if a widget wants to
#> retrieve the current contents of the PRIMARY selection buffer. The
#> registered command string will be executed as soon as the selection
#> data is availaible. The global Tcl variable PRIMARY will be set to
#> pass the requested information. The specified widget must be realized

extern void wafeGetSelectionValueProc();

void
XtGetSelectionValue
	in: Widget{Window}              # widget making the request
	const: XA_PRIMARY
	const: XA_STRING
	const: wafeGetSelectionValueProc
	in: XtNewString(String)		# Tcl command
	const: CurrentTime


#> The function 'ownSelection' claims ownership of the current PRIMARY
#> selection buffer for the specified widget (1st argument) and places
#> the specified string (2nd argument) into the selection buffer, such
#> it can be "pasted" into another window.  The function returns true,
#> if the specified widget successfully became selection owner. The
#> specified widget must be realized.
#> 
#> This function takes two additional arguments, both of them valid
#> Wafe-commands or the constant 'NULL'. The 3rd argument is a Wafe
#> command to be executed, when the widget looses the ownership of the
#> PRIMARY buffer. The 4th argument is a Wafe command which will be
#> executed when the selection transfer process is completed
#> (typically, when a a paste action is completed). The constant
#> 'NULL' means that no callback function is to be executed on these
#> conditions.

Boolean
wafeOwnSelectionCmd vulgo ownSelection
        in: Widget{Window}      # widget that whiches to become owner of the selection
	in: XtNewString(String) # string to be put into selection
	in: NULL | String 	# NULL | loseSelection TCL-command
	in: NULL | String 	# NULL | doneSelection TCL-command


#> The function 'fetchBuffer' retrieves the contents of the specified
#> cut buffer of the display of the specified widget and returns it.

(String) DString
XFetchBuffer
        in: XtDisplay(Widget{Display})		# widget to determine display
	const: &nbytes
	in: int				# buffer number (1-7)
	pre: {int nbytes;
	post: }


#> The function 'fetchBytes' is a conveniance routine used to put the
#> PRIMARY selection of the display of the specified widget into CUT
#> BUFFER 0 and to returns it.

(String) DString
XFetchBytes
	pre: { int bytes; \
		XConvertSelection(XtDisplay(localVar1), XA_PRIMARY, \
			XA_STRING, XA_CUT_BUFFER0, \
			DefaultRootWindow(XtDisplay(localVar1)), \
			CurrentTime); 
        in: XtDisplay(Widget{Display}) 		# widget to determine display
        const:  &bytes
	post: }


#> The command 'convertSelection' requests the current value of the
#> PRIMARY selection and places it into the specified cut buffer
#> for further use.

void
XConvertSelection
	in: XtDisplay(Widget{Display})	# widget to determine display
	const: XA_PRIMARY
	const: XA_STRING
	in: Atom			# target buffer number (0 to 6)
	const: DefaultRootWindow(XtDisplay(wafeTopLevel))
	const: CurrentTime

#> The command 'storeBuffer' stores the specified string (2nd
#> argument) into the specified cut buffer (3rd arguemnt) on the
#> display of the given widget (1st argument).

void
XStoreBuffer
	in: XtDisplay(Widget{Display})	# widget to determine display
	in: String			# String
	const: strlen(argv[2])
	in: int				# buffer number (1-7)


~alias 
	sV setValues
	gV getValue

#> The function 'hooksOfDisplay' returns the widget ID of the Hook
#> Object, which can be used for sV, gV, showRes etc. The specified
#> widget determines the display.

hint: R6
WidgetID (WidgetID)
XtHooksOfDisplay
	in: XtDisplay(Widget{Display})	# widget to determine display
        post: wafeCurrentAttribList=wafeMMgetAttribList((Widget)returnVar,True); \
              wafeMMsetAttribList((Widget)returnVar); \
	      wafeCurrentAttribList = NULL; 

#> The function 'mapState' returns the map state of the specified
#> widget, which is either 'IsUnmapped', 'IsUnviewable' or
#> 'IsViewable'. A return value of 'IsUnviewable' indicates that the
#> window of the specified widget is mapped but some ancestor is
#> unmapped.

MapState
mapState
        in: Widget{Display}                     # any widget


#> The function 'addWorkProc' adds the specified Wafe command as work
#> procedure and returns its ID. Work procedures can be used to
#> implement a simple form of backckground processing. Most
#> application spend most of its time waiting for input. A work
#> procedure can be registered which will be executed whenever Xt is
#> idle.  Unless the specified Wafe function returns 1, it will be
#> restarted automatically when Xt is idle again. See Xt Intrinsics
#> Manual for more details (XtAppAddWorkProc, XtWorkProc)

XtWorkProcId
XtAppAddWorkProc
	const: wafeAppContext 
	const: workProc
	in: XtNewString(String)		# Tcl command

#> The command 'removeWorkProc' removes a work procedure with the
#> specified ID, which was returned by the function 'addWorkProc'.

void 
XtRemoveWorkProc 
	in: XtWorkProcId		# work proc ID


#> The function 'isShell' test whether the specified widget is a shell
#> widget and returns the boolean value 0 or 1.

Boolean
XtIsShell
	in: Widget			# widget


#> The function 'getActionList' returns the names of the actions
#> associated with the specified widget.

hint: R5
String (TCL_RETURN_CODE)
getActionList
	in: XtClass(Widget)		# widget


#> The function 'atomName' return the name of an atom. It never
#> creates a new atom. If the atom does not exist an empty string is
#> returned. Currently, this function cannot be used to obtain names
#> for invalid atom ids.

#define name2AtomLV1chk(s) wafeStringToAtomChk(localVar1,s)
#ifdef MOTIF
#include <Xm/AtomMgr.h>
#endif

(String) DString
wafeGetAtomName vulgo atomName
	in: XtDisplay(Widget{Display})	# widget to determine display
	in: name2AtomLV1chk(String)	# atom

#> The function 'atomId' returns the atom ID of an atom. If the atom
#> does not exist, a new atom with the given name is created.

AtomID
wafeStringToAtom vulgo atomId
	in: Widget			# widget to determine display
	in: String			# atom

#> The function 'isAtomId' checks, whether an atom with the specified
#> name exists. On failure the function returns 0. Currently, isAtomId
#> function cannot be used to check invalid atom ids.

AtomID
wafeStringToAtomChk vulgo isAtom
	in: Widget			# widget to determine display
	in: String			# atom


#> The function 'motifWMRunning' returns 1 when an OSF/Motif compliant
#> window manager (eg mwm or dtwm is running), otherwise 0. The
#> provided argument can be any shell of the application (eg. topLevel).

Boolean
wafeMWMrunning vulgo motifWMRunning
       in: ShellWidget                 	# any shell widget

#> The procedure 'reparentWindow' modifies the window hierarchy by
#> placing the window of the widget specified as second argument under
#> the window of the widget specified as second argument. The specified
#> widgets must be realized.

void
XReparentWindow
       const: XtDisplay(localVar1)
       in: XtWindow(Widget{Display,Window})  # widget to reparent
       in: XtWindow(Widget{Window})          # new parent
       in: int                          # x coordinate
       in: int                          # y coordinate

#> The function 'isManaged' determines whether the specified widget
#> is currently managed by its parent or not

Boolean
XtIsManaged
	in: Widget			# Widget


#> The function 'getDomain' returns the domain (all possible values)
#> for a resource Type (1st argument) with enumerable values. Currently
#> this function is only available for Motif resources, but it is planned
#> to extend this functionality for other resource types as well. 
#> 
#> The resource type of a resource is documented in the widget
#> documentation (eg. man pages) and can be obtained dynamically
#> using the command 'getTypeOfAttribute Widget attributeName'. 
#> Additionally the command 'showRes Widget' prints this information 
#> on the screen.

(String) DString
wafeGetDomain vulgo getDomain
	in: String	# resource type
