/* Copyright (C) 1992 by Gustaf Neumann, Stefan Nusser

 *      Wirtschaftsuniversitaet Wien, 
 *      Abteilung fuer Wirtschaftsinformatik
 *      Augasse 2-6, 
 *      A-1090 Vienna, Austria
 *      neumann@wu-wien.ac.at, nusser@wu-wien.ac.at
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided
 * that the above copyright notice appears in all copies and that both that
 * copyright notice and this permission notice appear in all supporting
 * documentation.  This software is provided "as is" without expressed or
 * implied warranty.
 * 
 */

/*
 * This file was generated by genc.
 * Be aware that modifications of this file will be lost,
 * when genc is executed!

Creation: Thu Jun 29 03:36:23 EDT 1995 on mohegan
Author: genc
Version: 1.0.12

 */

#define ATHENAR5_C
#include <wafe.h>
#ifdef ATHENAR5
#include <X11/Xaw/Panner.h>
#include <X11/Xaw/Porthole.h>
#include <X11/Xaw/Repeater.h>
#include <X11/Xaw/Tree.h>

/* treat me like a -*-c-*- program, treat me, treat me, treat me! */
#include <X11/Xaw/Panner.h>

/*      Function Name: PannerCallback
 *      Description: called when the panner has moved.
 *      Arguments: panner - the panner widget.
 *                 child - child to be moved.
 *                 report_ptr - the panner record.
 *      Returns: none.
 */

static void 
pannerCallbackProc(w, child, report_ptr)
Widget w;
XtPointer child, report_ptr;
    {
    Arg args[2];
    XawPannerReport *report = (XawPannerReport *) report_ptr;

    WAFE_UNUSED(w);

    XtSetArg(args[0], XtNx, -report->slider_x);
    XtSetArg(args[1], XtNy, -report->slider_y);
    
    XtSetValues(child, args, 2);
    }


/*      Function Name: PortholeCallback
 *      Description: called when the porthole or its child has
 *                   changed 
 *      Arguments: porthole - the porthole widget.
 *                 panner_ptr - the panner widget.
 *                 report_ptr - the porthole record.
 *      Returns: none.
 */


static void 
portholeCallbackProc(w, panner_ptr, report_ptr)
Widget w;
XtPointer panner_ptr, report_ptr;
    {
    Arg args[10];
    Cardinal n = 0;
    XawPannerReport *report = (XawPannerReport *) report_ptr;
    Widget panner = (Widget) panner_ptr;

    WAFE_UNUSED(w);

    XtSetArg(args[n], XtNsliderX, report->slider_x); n++;
    XtSetArg(args[n], XtNsliderY, report->slider_y); n++;
    if (report->changed != (XawPRSliderX | XawPRSliderY)) 
	{
        XtSetArg(args[n], XtNsliderWidth,  report->slider_width);  n++;
        XtSetArg(args[n], XtNsliderHeight, report->slider_height); n++;
        XtSetArg(args[n], XtNcanvasWidth,  report->canvas_width);  n++;
        XtSetArg(args[n], XtNcanvasHeight, report->canvas_height); n++; 
	}
    XtSetValues(panner, args, n);
    }


#define XawTalk(pa, po, ch) XtAddCallback(po, XtNreportCallback, \
                            portholeCallbackProc, (XtPointer) pa); \
                         XtAddCallback(pa, XtNreportCallback, \
                            pannerCallbackProc, (XtPointer) ch)


static int cmd_XawTalk();
static int cmd_XawTreeForceLayout();

 static _Xconst String XtGravity_strings[] = {
  "north","south","west","east",NULL };
 static _Xconst int XtGravity_values[] = {
  NorthGravity,SouthGravity,WestGravity,EastGravity,0 };
 static XtConvertArgRec XtGravity_args[] = { {XtAddress, NULL, 0} };


static void wafeClassInit_Panner(wClass)
WidgetClass wClass;
{
 static _Xconst Proc_signature cmds[] = {
 { "XawTalk", cmd_XawTalk },
 { NULL, NULL }
 };
 XtInitializeWidgetClass(wClass);
 wafeCreateTclProcs(cmds);
}

static void wafeClassInit_Tree(wClass)
WidgetClass wClass;
{
 static _Xconst Proc_signature cmds[] = {
 { "XawTreeForceLayout", cmd_XawTreeForceLayout },
 { NULL, NULL }
 };
 XtInitializeWidgetClass(wClass);
 wafeCreateTclProcs(cmds);

 XtGravity_args[0].address_id= (XtPointer)
   wafeAddRConv(XtRGravity,sizeof(XtGravity),
		XtGravity_strings, (XtPointer)XtGravity_values);
 XtSetTypeConverter(XtRGravity,XtRString,wafeCvtRToString,
		    XtGravity_args,XtNumber(XtGravity_args),
                    XtCacheNone,NULL);
}




static _Xconst Proc_signature *cmds = NULL; 

static WidgetCreate_signature wccs[] = {
    {"Panner",NULL,NULL,False,False,wafeClassInit_Panner},
    {"Porthole",NULL,NULL,False,False,XtInitializeWidgetClass},
    {"Repeater",NULL,NULL,False,False,XtInitializeWidgetClass},
    {"Tree",NULL,NULL,False,False,wafeClassInit_Tree},
    { NULL,NULL,NULL,False,False,NULL }
    };

static _Xconst String pkgs[] = {
#ifdef XAWR5
     "XAWR5",
#endif
    NULL
     };



#define WS_Panner wccs[0].name
#define WS_Porthole wccs[1].name
/* 
 * void
 * XawTalk
 * 	in: PannerWidget	# panner
 * 	in: PortholeWidget	# porthole
 * 	in: Widget		# managed widget
 */

static int 
cmd_XawTalk(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     Widget localVar2;
     Widget localVar3;

     DBUG_ENTER(argv[0]);  
     WAFE_UNUSED(clientData);
     WAFE_UNUSED(comInterpreter);

     if (argc != 4) 
	 DBUG_RETURN(wafeArgcError(argc,argv,wafeStrings[2],3));

     if (!(localVar1 =  name2WidgetOfClass(argv[1],pannerWidgetClass)))
         DBUG_RETURN(wafeConvError(argc, argv, 1, NULL, "PannerWidget"));

     if (!(localVar2 =  name2WidgetOfClass(argv[2],portholeWidgetClass)))
         DBUG_RETURN(wafeConvError(argc, argv, 2, NULL, "PortholeWidget"));

     if (!(localVar3 = (Widget) name2Widget(argv[3])))
         DBUG_RETURN(wafeConvError(argc, argv, 3, NULL, XtRWidget));

     XawTalk(localVar1,localVar2,localVar3);

     DBUG_RETURN (TCL_OK);
     }


#define WS_Repeater wccs[2].name
#define WS_Tree wccs[3].name
/* 
 * void
 * XawTreeForceLayout
 * 	in: TreeWidget		# tree Widget

 */

static int 
cmd_XawTreeForceLayout(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;

     DBUG_ENTER(argv[0]);  
     WAFE_UNUSED(clientData);
     WAFE_UNUSED(comInterpreter);

     if (argc != 2) 
	 DBUG_RETURN(wafeArgcError(argc,argv,wafeStrings[2],1));

     if (!(localVar1 =  name2WidgetOfClass(argv[1],treeWidgetClass)))
         DBUG_RETURN(wafeConvError(argc, argv, 1, NULL, "TreeWidget"));

     XawTreeForceLayout(localVar1);

     DBUG_RETURN (TCL_OK);
     }


#endif  /* of ifdef ATHENAR5 */

void
wafeInitialize_ATHENAR5()
{
#ifdef ATHENAR5
 wccs[0].wClass = pannerWidgetClass; /* not a C constant! */
 wccs[1].wClass = portholeWidgetClass; /* not a C constant! */
 wccs[2].wClass = repeaterWidgetClass; /* not a C constant! */
 wccs[3].wClass = treeWidgetClass; /* not a C constant! */
 wafeCreateTclCmds(pkgs,wccs,cmds);
#endif /* of ifdef ATHENAR5 */
}
