/* make emcas happy -*-C-*-  make emacs happy */
#include <Xm/Container.h>

static _Xconst char *outlineStateString[] = {
  "collapsed",
  "expanded"
};

static XtConvertArgRec OutlineStateConvertArgs[] = {
    {XtAddress, (XtPointer)XmROutlineState, 0},
};

static Boolean
CvtMotif20ToString(dpy, args, num_args, fromVal, toVal, converterData)
Display   *dpy;
XrmValue  *args;
Cardinal  *num_args;
XrmValue  *fromVal;
XrmValue  *toVal;
XtPointer *converterData;
    {
    /* fprintf(stderr,"num = %d, type='%s'\n", *num_args, args[0].addr); */

    if (*num_args != 1) 
	return False;

    if (!strcmp( args[0].addr,XmROutlineState)) 
	{
	unsigned char pos = (unsigned char)(long)fromVal->addr;

	/*fprintf(stderr,"pos=%d addr=%08x\n",pos,fromVal->addr);*/
	if (pos >= XtNumber(outlineStateString)) 
	    return False;

	toVal->addr = (String)outlineStateString[pos];
	toVal->size = strlen((String)toVal->addr)+1;
	return True;
	}

    return False;
    }

static String
containerGetItemChildren(container,parent)
Widget container;
Widget parent;
    {
    WidgetList wl;
    int num = XmContainerGetItemChildren(container,parent,&wl);
    String result = wafeCvtWidgetListToList(num,wl);
    if (num) XtFree((char *)wl);
    return result;
    }


static void
containerReorder(container,s)
Widget container;
String s;
    {
    int argc, i;
    char **argv;
    
    if (Tcl_SplitList(wafeInterpreter,s, &argc,&argv) != TCL_OK) 
	return;
    
    for ( i = 0; i < argc; i++ )   
	/* we assume that sizeof(char*) = sizeof(Widget) */
	if (!(argv[i] = (char *) name2Widget(argv[i])))
	    {
	    wafeConvWarn(XtRWidgetList,argv[i],XtRWidget);
	    XtFree((char *)argv);
	    return;
	    }
    
    XmContainerReorder(container, (WidgetList)argv, argc);
    XtFree((char *)argv);
    }
