/* dbug needs stdio */
#undef USECONTEXT
#undef HASH

#include <stdio.h>
#include <dbug.h>
#include <tcl.h>
#include <signal.h>

/* for some systems tcl.h defines CONST, 
   which conflicts with PRER5 Intrinsics
   we save it for later usage in _Xconst
 */

#ifdef PRER5
# ifdef CONST
#  define saveCONST CONST
#  undef CONST
# endif
#endif

#include <X11/Intrinsic.h>
#include <X11/Shell.h>
#include <X11/StringDefs.h>
#include <X11/Xos.h>
#ifndef PRER5
# include <X11/Xfuncs.h>
#endif

#ifndef _Xconst
# ifdef saveCONST
#  define _Xconst saveCONST
#  undef saveCONST
# else
#  define _Xconst
# endif
#endif

/* The following should bot be necessary at all but it turns out
   the the Xos.h files for open windows do not define the string
   functions properly */
#ifdef sun
# include <string.h>
#endif


#ifdef DEBUG_MALLOC
# include <malloc.h>
#endif

#ifndef X_NOT_STDC_ENV
# include <stdlib.h>
#endif

#include "wafe_strings.h"

/*********************** constants and macros **************************/

#define wafeDefaultFileSearchPath "/usr/lib/X11/%L/%T/%N%C%S:/usr/lib/X11/%l/%T/%N%C%S:/usr/lib/X11/%T/%N%C%S:/usr/lib/X11/%L/%T/%N%S:/usr/lib/X11/%l/%T/%N%S:/usr/lib/X11/%T/%N%S:/usr/include/X11/%T/%N:%N"


#ifdef __alpha
# define LONG_AS_STRING 	22    /* max length for %ld */
#else
# define LONG_AS_STRING 	12    /* max length for %ld */
#endif
#define INT_AS_STRING 		12    /* max length for %d  */
#define FLOAT_AS_STRING		20    /* max length for %f  */

#ifndef SIGMAX
# define SIGMAX NSIG
#endif

#define WafeDontManage ((Widget (*)()) -1)

/* user defineable handlers */
#define STDIN   0
#define STDOUT  1
#define STDERR  2
#define XIOERR  3
#define HTMLVISITED 4
#define HANDLERMAX HTMLVISITED+1

#define ParentWidget(w) ( XtParent(w) == NULL ? w : XtParent(w) )
#define Nil(Typ)                ((Typ *) 0)

#define name2Widget(name)          wafeCvtName2Widget(name,False,NULL)
#define name2WidgetId(name)        wafeCvtName2Widget(name,False,NULL)
#define name2WidgetOfClass(name,c) wafeCvtName2Widget(name,False,c)

#ifdef MOTIF 
# define wafeGetAtomName(d,a)  ((a) ? XmGetAtomName(d,a) : XtNewString(""))
# define wafeInternAtom(d,s,e) XmInternAtom(d,s,e)
#else
# define wafeGetAtomName(d,a)  ((a) ? XGetAtomName(d,a) : XtNewString(""))
# define wafeInternAtom(d,s,e) XInternAtom(d,s,e)
#endif

#define wafeStringToAtom(w,name)     wafeCvtStringToAtom(w,name,False)
#define wafeStringToAtomChk(w,name)  wafeCvtStringToAtom(w,name,True)

#define returnTclError(cmd,string)  {\
     Tcl_AppendResult(wafeInterpreter,"Wafe(",(cmd),"): ",(string),NULL); \
     DBUG_RETURN(TCL_ERROR);}

#define setValues(w,argc,argv) {\
    ArgList           args; \
    int               numArgs; \
    MMattribListPtr  *saveCurrentAttribList = wafeCurrentAttribList; \
    if (wafeConvert(ParentWidget(w), XtClass(w), \
		argv, &argc, &args, &numArgs, w)) { \
	XtSetValues(w, args, numArgs); \
	wafeCurrentAttribList = saveCurrentAttribList; \
	XtFree((String)args); \
	} \
    } 


#ifdef PRER5
# define WafePermStringToQuark(n) XrmStringToQuark((n))
#else
# define WafePermStringToQuark(n) XrmPermStringToQuark((n))
#endif

/* we had trouble with XtConvertAndStore on some platforms...
#ifndef PRER5
#define IFCONVERTANDSTORE(w, from,inp, to,outp) \
	if(XtConvertAndStore(w, from, & inp, to, & outp))
#else
#define IFCONVERTANDSTORE(w, from, inp, to, outp) \
	  XtConvert(w, from, & inp, to, & outp); \
	    if (outp.addr)
#endif
*/
#define IFCONVERTANDSTORE(w, from, inp, to, outp) \
	  XtConvert(w, from, & inp, to, & outp); \
	    if (outp.addr)

#ifdef MOTIF
#include <Xm/Xm.h>
# define MOTIF11
# if (XmVERSION == 1) && (XmREVISION >= 2)
#  define MOTIF12
# else 
#  if (XmVERSION >= 2)
#   define MOTIF12
#   define MOTIF20
#  endif
# endif
#endif

#if !defined(PRER5) && defined(MOTIF11) && defined(MOTIF_EDITRES)
# include <X11/Xmu/Editres.h>
# define MOTIF_EDITRES_HANDLER(w) \
    XtAddEventHandler((w), (EventMask)0, True, _XEditResCheckMessages, NULL);
#else
# define MOTIF_EDITRES_HANDLER(w) 
#endif


#ifdef MAIN 
# define WAFE_EXTERN
# define WAFE_INIT(var,value) var = value
#else
# define WAFE_EXTERN extern
# define WAFE_INIT(var, value) var
#endif

/************************* global variables *************************/

WAFE_EXTERN Tcl_Interp    *wafeInterpreter;     /* single tcl-interpreter */
WAFE_EXTERN XtAppContext   wafeAppContext;      /* application context    */
WAFE_EXTERN Widget         wafeTopLevel;        /* top level window       */

WAFE_EXTERN int WAFE_INIT(wafeClientPid, 0);   /* PID of child process      */
WAFE_EXTERN int WAFE_INIT(wafeExtraCom,0);     /* Extra communication chan. */
WAFE_EXTERN int WAFE_INIT(wafeExtraClient,0);  /* client side of cannel     */
WAFE_EXTERN int WAFE_INIT(wafeToClient,-1);    /* channel to client         */
WAFE_EXTERN int WAFE_INIT(wafeFromClient,-1);  /* channel from client       */
WAFE_EXTERN int WAFE_INIT(wafeErrorClient,-1); /* error channel from client */

WAFE_EXTERN String WAFE_INIT(wafeScriptName, NULL); /* for fileMode         */
#define fileMode          (wafeScriptName != NULL)
#define frontendMode      (wafeClientPid != 0)

WAFE_EXTERN String    WAFE_INIT(wafeAppClass, NULL);
WAFE_EXTERN String            wafeFileSearchPath;
WAFE_EXTERN XEvent           *wafeCurrentEvent; /* current event for actions */
WAFE_EXTERN int       WAFE_INIT(wafeInnerEventLoop, 0);

#ifdef MOTIF
WAFE_EXTERN XtPointer WAFE_INIT(wafeCurrentCallData,NULL); /* calldata in callbacks */
#endif

#define wafe_ZERO  wafeStrings[0]
#define wafe_ONE   wafeStrings[1]
#define wafe_EMPTY wafeStrings[2]
#define wafe_NULL  wafeStrings[3]
#define wafe_NONE  wafeStrings[4]
#define wafe_SPACE wafeStrings[5]
#define wafe_NL    wafeStrings[6]

/*
 * Some Widgets have subparts or subobjects providing ressources,
 * which are not visible to XtGetResourceList(). For each of them
 * we create a static list containing attribute/type pairs, as defined by
 * the following structure. Anyone who knows a more elegant solution
 * **PLEASE** email it to us!!
 */

typedef struct
    {
    char *resource_name;
    char *resource_type;
    } addResInfo;


typedef long  WidgetID;
typedef long  AtomID;
typedef int   TCL_RETURN_CODE;


/*
 * ---------------- wafeString operations -------------------------
 */
#define WAFESTRING_SLACK   2048
#define WAFESTRING_MIN      512

#define wafeStringValue(ws) ((ws)->buffer)
#define wafeStringLength(ws) ((ws)->length)

typedef struct
    {
    char *buffer;
    int length;
    int max;
    char sBuffer[WAFESTRING_MIN];
    } wafeStringStruct, *wafeString;

#ifndef WAFESTRING_C
extern void wafeStringInit(
#if NeedFunctionPrototypes
    wafeString
#endif
);

extern void wafeStringClear(
#if NeedFunctionPrototypes
    wafeString
#endif
);

extern wafeString wafeStringNew();

extern wafeString wafeStringFree(
#if NeedFunctionPrototypes
    wafeString
#endif
);

extern void wafeStringAppend(
#if NeedFunctionPrototypes
    wafeString, String
#endif
);

extern void wafeStringAppendN(
#if NeedFunctionPrototypes
    wafeString, String, int
#endif
);

extern void wafeStringAppendEscaped(
#if NeedFunctionPrototypes
    wafeString, String, int
#endif
);

extern void wafeStringAppendLong(
#if NeedFunctionPrototypes
    wafeString, long
#endif
);

extern void wafeStringAppendInt(
#if NeedFunctionPrototypes
    wafeString, int
#endif
);

extern void wafeStringAppendShort(
#if NeedFunctionPrototypes
    wafeString, short
#endif
);
extern void wafeStringAppendFloat(
#if NeedFunctionPrototypes
    wafeString, double
#endif
);

extern void wafeStringAppendPointer(
#if NeedFunctionPrototypes
    wafeString, XtPointer
#endif
);

extern void wafeStringAppendChar(
#if NeedFunctionPrototypes
    wafeString, char
#endif
);

extern void wafeStringAppendListItemEscaped(
#if NeedFunctionPrototypes
    wafeString, String
#endif
);

extern void wafeStringAppendListEscaped(
#if NeedFunctionPrototypes
    wafeString, Cardinal, String *
#endif
);

extern void wafeStringAppendWidgetList(
#if NeedFunctionPrototypes
    wafeString, Cardinal, WidgetList
#endif
);

extern void wafeStringAppendIntList(
#if NeedFunctionPrototypes
    wafeString, Cardinal, int *
#endif
);

extern String wafeCvtWidgetListToList(
#if NeedFunctionPrototypes
     Cardinal, WidgetList
#endif			 
);

extern String wafeCvtIntsToList(
#if NeedFunctionPrototypes
     Cardinal, int *
#endif			 
);

#endif


/* 
 * ----------------- memory management -----------------------------
 * memory management uses a widget list and 
 * a per widget attibute list keeping the resources to be freed
 * on setValues or destroys
 */

typedef struct _MMattribList
    {
    XrmQuark               attribute;
    char                  *value;
    struct _MMattribList  *next;
    } MMattribList, *MMattribListPtr;


typedef struct _WidgetListItem
    {
    Widget                widget;
    XtPointer             info;
    struct _WidgetListItem *next;
    } WidgetListItem, *WidgetListPtr;

WAFE_EXTERN XrmQuark         wafeCurrentAttrib;
WAFE_EXTERN Boolean          wafePointerResourceValue;
WAFE_EXTERN MMattribListPtr *wafeCurrentAttribList;
WAFE_EXTERN WidgetListPtr    wafeWidgetTrees;

#ifdef USECONTEXT
WAFE_EXTERN XContext WAFE_INIT(wafeCtx, 0);
#endif

/* in order to make wafeMMgetAttribList more lazy we use a 
 * global static variable
 */
WAFE_EXTERN Widget wafeCurrentWidget;

/*
 * type definition for freeing procedures
 */

typedef void (*freeProc)(
#if NeedFunctionPrototypes
    char *
#endif 
);

/*
 * ---------------- initialization structures -------------------------
 */


typedef Widget (widgetProc)();
#ifdef NEVER
#if NeedFunctionPrototypes
    _Xconst String      /* name */,
    WidgetClass         /* widget_class */,
    Widget              /* parent */,
    ArgList             /* args */,
    Cardinal            /* num_args */
#endif 
);
#endif /* NEVER */

typedef struct 
    {
    _Xconst String name;
    Tcl_CmdProc *proc;
    } Proc_signature;

typedef struct 
    {
    _Xconst String name;
    WidgetClass    wClass;
    widgetProc     *wCreateFunction;
    Boolean        createsShell;
    } WidgetCreate_signature;

#ifdef MOTIF12
#define xmDragContextWidgetClass xmDragContextClass
typedef struct
    {
    String dest;
    XtPointer value;
    } dropTransferCallbackStruct;
#endif

/************** no global variables beyond this point ************/

/*
 * This  is our version of Xt's XtResource structure, containing only the
 * name of the resource in quark representation and the type as string and 
 * as Quark as well..
 * Compare to resList2QTypeList in resources.c. RESINFO maintains a global
 * List, consisting of several lists, one for each WidgetClass!
 */

typedef struct _QType
     {
     XrmQuark qName;
     char *type;
     XrmQuark  qType;
     struct _QType *next;
     } QType, *QTypeList;


/*************************** externs for callback.c **************/

#ifdef MOTIF11
#ifdef CALLBACK_C
#include <Xm/Xm.h>

extern void wafeStringAppendXmEscaped(
#if NeedFunctionPrototypes
     wafeString, XmString
#endif
);

extern void wafeStringAppendXmStringTableEscaped(
#if NeedFunctionPrototypes
     wafeString, int, XmStringTable
#endif
);

extern String wafeCvtXmStringTable2String(
#if NeedFunctionPrototypes
    int, XmStringTable
#endif
);
#endif
#endif


/*************************** externs from mm.c **************/
#ifndef MM_C
extern void wafeMMreplace(
#if NeedFunctionPrototypes
    Widget, MMattribListPtr *, XrmQuark, char *, freeProc
#endif
);

extern MMattribListPtr * wafeMMgetAttribList(
#if NeedFunctionPrototypes
    Widget, Boolean
#endif
);

extern Widget wafeMMfreeGarbage(
#if NeedFunctionPrototypes
    Widget
#endif
);

extern char * wafeMMgetValue(
#if NeedFunctionPrototypes
    Widget, XrmQuark, MMattribListPtr **, Boolean
#endif
);

extern void wafeAddToEndOfWidgetList(
#if NeedFunctionPrototypes
     WidgetListPtr *, Widget, XtPointer
#endif
);

extern void wafeMMsetAttribList(
#if NeedFunctionPrototypes
      Widget
#endif
);
#endif


/*************************** externs from handlers.c **************/

#ifndef HANDLERS_C
extern void wafeInit(
#if NeedFunctionPrototypes
    int, char **, Boolean, Boolean
#endif
);

extern void wafeProcessEvents(
);

extern void wafeExit(
#if NeedFunctionPrototypes
    int
#endif
);

extern void wafeFatal(
#if NeedFunctionPrototypes
    String, String, String
#endif
);

extern void wafeWarn(
#if NeedFunctionPrototypes
    String, String, String, String, String
#endif
);

extern int wafeSetError(
#if NeedFunctionPrototypes
    String, String, String, String
#endif
);

extern int wafeEval(
#if NeedFunctionPrototypes
     Tcl_Interp *, char *, char *
#endif			 
);

extern Boolean wafeMergeArguments(
#if NeedFunctionPrototypes
     char *, char *, int *, char ***
#endif			 
);

int
wafeConvError (
#if NeedFunctionPrototypes
     int, char**, int, String, String
#endif
);

void
wafeConvWarn (
#if NeedFunctionPrototypes
     String, String, String
#endif
);

int
wafeArgcError (
#if NeedFunctionPrototypes
     int, char**, String, int
#endif
);

void
wafeNoVarCompError (
#if NeedFunctionPrototypes
     int, char**, int, String
#endif
);

#endif


/*************************** externs from callback.c **************/

#ifndef CALLBACK_C
extern void wafeQuarkInitializeGeneratedCode();

extern void wafeExecCallbackProc(
#if NeedFunctionPrototypes
     Widget, XtPointer, XtPointer
#endif
);
#endif


/*************************** externs from converters.c **************/

#ifndef CONVERTERS_C
/*
 * Functions from file CONVERTERS.C
 */
extern int wafeConvert(
#if NeedFunctionPrototypes
     Widget, WidgetClass, char**, int*, ArgList*, int*, Widget
#endif
);

extern Widget wafeCvtName2Widget(
#if NeedFunctionPrototypes
     _Xconst String, Boolean, WidgetClass
#endif
);

extern XtTypeConverter CvtStringToWidget(
#if NeedFunctionPrototypes
     Display*, XrmValue*, Cardinal*, XrmValue*, XrmValue*, XtPointer*
#endif
);

extern void CvtStringToCallback(
#if NeedFunctionPrototypes
     XrmValuePtr, Cardinal *, XrmValuePtr, XrmValuePtr
#endif
);

extern void CvtStringToWidgetList(
#if NeedFunctionPrototypes
     XrmValuePtr, Cardinal *, XrmValuePtr, XrmValuePtr
#endif
);

extern String wafeWidgetToName(
#if NeedFunctionPrototypes
     Widget
#endif
);

extern String wafeGetBoolean(
#if NeedFunctionPrototypes
     _Xconst String, Boolean*
#endif
);

extern Atom wafeCvtStringToAtom(
#if NeedFunctionPrototypes
   Widget, _Xconst String, Boolean
#endif
);

extern Pixel wafeCvtStringToPixel(
#if NeedFunctionPrototypes
   Widget, _Xconst String
#endif
);

extern void wafeFixSplittedList(
#if NeedFunctionPrototypes
   int, String **
#endif
);


#endif

/*************************** externs from resources.c **************/

#ifndef RESOURCES_C
extern XrmQuark wafeGetQTypeOfAttribute(
#if NeedFunctionPrototypes
     WidgetClass, Widget, XrmQuark, Boolean*
#endif
);

extern String wafeGetApplicationResource(
#if NeedFunctionPrototypes
     Widget, _Xconst String, _Xconst String
#endif
);

extern Boolean wafeResetResource(
#if NeedFunctionPrototypes
     Widget, XrmQuark
#endif
);
#endif

/*************************** externs from createw.c **************/
#ifndef CREATE_C
extern
#endif
void wafeCreateTclCmds(
# if NeedFunctionPrototypes
  _Xconst String *, 
  _Xconst WidgetCreate_signature *, 
  _Xconst Proc_signature *
# endif
 );

/*************************** externs from actionsb.c **************/
#ifndef ACTIONSCB_C
extern void wafeActionPercentcode(
#if NeedFunctionPrototypes
  wafeString, char, XEvent *, Widget
#endif
);
#endif

/*************************** externs from XtGen.c **************/

#ifndef PIXMAP_C
extern void wafeRegisterXpmTypeConverter(
#if NeedFunctionPrototypes
  _Xconst String, Boolean
#endif
);
#endif /* PIXMAP_C */

/*************************** externs from XmGen.c **************/
#ifdef MOTIF
#ifndef MOTIF11_C
extern XmString wafeCvtStringToXmString(
#if NeedFunctionPrototypes
   String
#endif
);

extern void wafeCvtXmString2String(
#if NeedFunctionPrototypes
    wafeString, XmString, Boolean
#endif
);

#endif
#endif /* MOTIF */

/*************************** externs from XawGen.c **************/
#ifdef ATHENA
# ifndef ATHENA_C

extern void wafeCheckListWidgetResources(
#if NeedFunctionPrototypes
   int, ArgList, Boolean, Boolean*, Boolean*
#endif
);

# endif
#endif /* ATHENA */
