/* Copyright (C) 1992 by Gustaf Neumann, Stefan Nusser

 *      Wirtschaftsuniversitaet Wien, 
 *      Abteilung fuer Wirtschaftsinformatik
 *      Augasse 2-6, 
 *      A-1090 Vienna, Austria
 *      neumann@wu-wien.ac.at, nusser@wu-wien.ac.at
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided
 * that the above copyright notice appears in all copies and that both that
 * copyright notice and this permission notice appear in all supporting
 * documentation.  This software is provided "as is" without expressed or
 * implied warranty.
 * 
 */

/*
 * This file was generated by genc.
 * Be aware that modifications of this file will be lost,
 * when genc is executed!

Creation: Wed Mar  1 11:46:25 EST 1995 on mohegan
Author: genc
Version: 1.0.8

 */

#define MOTIF11_C
#include <wafe.h>
/*
static _Xconst Proc_signature cmds[];
static WidgetCreate_signature wccs[];
*/
#ifdef MOTIF11
#include <Xm/ArrowB.h>
#include <Xm/ArrowBG.h>
#include <Xm/BulletinB.h>
#include <Xm/CascadeB.h>
#include <Xm/CascadeBG.h>
#include <Xm/Command.h>
#include <Xm/DialogS.h>
#include <Xm/DrawingA.h>
#include <Xm/DrawnB.h>
#include <Xm/FileSB.h>
#include <Xm/Form.h>
#include <Xm/Frame.h>
#include <Xm/Label.h>
#include <Xm/LabelG.h>
#include <Xm/List.h>
#include <Xm/MainW.h>
#include <Xm/MenuShell.h>
#include <Xm/MessageB.h>
#include <Xm/PanedW.h>
#include <Xm/PushB.h>
#include <Xm/PushBG.h>
#include <Xm/RowColumn.h>
#include <Xm/Scale.h>
#include <Xm/ScrollBar.h>
#include <Xm/ScrolledW.h>
#include <Xm/SelectioB.h>
#include <Xm/Separator.h>
#include <Xm/SeparatoG.h>
#include <Xm/Text.h>
#include <Xm/TextF.h>
#include <Xm/ToggleB.h>
#include <Xm/ToggleBG.h>
 extern XrmQuark qXmString;
 extern XrmQuark qWindow;
 extern XrmQuark qShort;
 extern XrmQuark qMenuWidget;
 extern XrmQuark qHorizontalDimension;
 extern XrmQuark qVerticalDimension;
 extern XrmQuark qShellHorizDim;
 extern XrmQuark qShellVertDim;
 extern XrmQuark qTextPosition;
 extern XrmQuark qVerticalPosition;
 extern XrmQuark qHorizontalPosition;
 extern XrmQuark qVerticalInt;
 extern XrmQuark qHorizontalInt;
 extern XrmQuark qPixmap;
 extern XrmQuark qBackgroundPixmap;
 extern XrmQuark qGadgetPixmap;
 extern XrmQuark qManBottomShadowPixmap;
 extern XrmQuark qManForegroundPixmap;
 extern XrmQuark qManHighlightPixmap;
 extern XrmQuark qManTopShadowPixmap;
 extern XrmQuark qPrimBottomShadowPixmap;
 extern XrmQuark qPrimForegroundPixmap;
 extern XrmQuark qPrimHighlightPixmap;
 extern XrmQuark qPrimTopShadowPixmap;
 extern XrmQuark qXmBackgroundPixmap;
 extern XrmQuark qsource;
 static XrmQuark qXmStringTable;
 static XrmQuark qitems;
 static XrmQuark qselectedItems;
 static XrmQuark qfileSearchProc;
 static XrmQuark qdirSearchProc;

/* make emcas happy -*-C-*-  make emacs happy */

#include <ctype.h>
#include <Xm/AtomMgr.h>
#include <Xm/List.h>
#include <X11/IntrinsicP.h>

#include <wafe_quarks.h>

#ifdef MOTIF20
#define WAFE_FONTLIST_TAG XmSTRING_COMPONENT_FONTLIST_ELEMENT_TAG
#else
#define WAFE_FONTLIST_TAG XmSTRING_COMPONENT_CHARSET
#endif

static XmStringCharSet defaultCharSet;

#define	CONVERSION_DONE(type, value) \
	{							\
	    if (toVal->addr != NULL) {				\
		if (toVal->size < sizeof(type)) {		\
		    toVal->size = sizeof(type);			\
		    return False;				\
		}						\
		*(type*)(toVal->addr) = (value);		\
	    }							\
	    else {						\
		static type static_val;				\
		static_val = (value);				\
		toVal->addr = (XtPointer)&static_val;		\
	    }							\
	    toVal->size = sizeof(type);				\
	    return True;					\
	}

extern Boolean wafeInstallImage(
#if NeedFunctionPrototypes
    Display *, String, String, Boolean, int *
#endif
);

/*
 * Initialize the default character Set variable!
 */

void
wafeMotifInit()
    {
    XmStringContext   context;
    char              *text = NULL;
    XmString          dummy = XmStringCreateSimple(wafe_ONE);
    String            pixmapClasses[] = 
	{
	XmRBackgroundPixmap,
	XmRGadgetPixmap,
	XmRManBottomShadowPixmap,
	XmRManForegroundPixmap,
	XmRManHighlightPixmap,
	XmRManTopShadowPixmap,
	XmRPixmap,
	XmRPrimBottomShadowPixmap,
	XmRPrimForegroundPixmap,
	XmRPrimHighlightPixmap,
	XmRPrimTopShadowPixmap,
	XmRXmBackgroundPixmap,
#ifdef MOTIF20
	XmRDynamicPixmap,
#endif
	NULL
	}, *p = pixmapClasses;

    XmStringCharSet    tag;
    XmStringComponentType unknown_tag;
    XmStringComponentType type;
    unsigned short     unknown_length;
    unsigned char     *unknown_value;
    XmStringDirection  dir;

    if (!XmStringInitContext(&context, dummy))
	wafeFatal("motif","Could not create String Context",NULL);


    while ((type = XmStringGetNextComponent(context, &text, &tag, &dir, 
					    &unknown_tag,&unknown_length,
					    &unknown_value))
	   != XmSTRING_COMPONENT_END)
	{
	DBUG_PRINT("motif", 
		   ("type %d, textsegment '%s', tag '%s', dir %d, u_tag %d",
		    type, text, tag, dir, unknown_tag));
	if (type == WAFE_FONTLIST_TAG)
	    {
	    defaultCharSet = tag;
	    break;
	    }
	}

    if (text) XtFree(text);
    XmStringFree(dummy);
    XmStringFreeContext(context);

    DBUG_PRINT("motif",("defaultCharSet is <%s> Xm='%s'",
			defaultCharSet,XmSTRING_DEFAULT_CHARSET));

    while (*p) 
	wafeRegisterXpmTypeConverter(*p++, True);
    }

#ifndef MOTIF20
/* Motif 2.0 comes with such an procedure */
static XmString
XmStringConcatAndFree(s1, s2)
XmString s1;
XmString s2;
    {
    XmString result = XmStringConcat(s1, s2);
    XmStringFree(s1);
    XmStringFree(s2);
    return result;
    }
#endif /* !MOTIF20 */


XmString
wafeCvtStringToXmString(inString)
String inString;
    {
    XmStringDirection  dir = XmSTRING_DIRECTION_L_TO_R;
    XmString           result = NULL;
    char              *start, *end, *next, *csv, lastChar;
    Boolean            sep, readTag;
    
    wafeStringStruct cs_s;
    wafeString cs = &cs_s;   /* Char set */

    wafeStringInit(cs);
    wafeStringAppend(cs,XmSTRING_DEFAULT_CHARSET);
    csv = wafeStringValue(cs);

    /*
       fprintf(stderr, "Converting string <%s>\n", inString);
    */

    for (start = inString; *start; start = next)
	{
	for (end = start; *end && *end != '\n' && *end != '^'; end++);
	readTag = sep = False;
	
	if (*end)
	    {
	    next = end+1;
	    if (*end == '^')
		{
		if (*next == '^')
		    {
		    end = next;
		    next++;
		    }
		else
		    readTag = True;
		}
	    else
		sep = True; /* must be (*end == '\n') */
	    }
	else
	    next = end;

	/* terminate and create segment */
	lastChar = *end;
	*end = '\0';
	result = result ?
	    XmStringConcatAndFree(result, 
			  XmStringSegmentCreate(start, csv, dir, sep)) :
			  XmStringSegmentCreate(start, csv, dir, sep);
	*end = lastChar;
	
	if (readTag)
	    {
	    char *tagStart,*tagEnd;
	    int tagLength;
	    
	    for (; *end && !isalpha(*end); end++);
	    tagStart = end;
	    for (; *end && (isalpha(*end) || *end == '_'); end++);
	    tagEnd = end;
	    for (; *end && *end == ' '; end++);
	    next = *end ? end++ : end;

	    tagLength = tagEnd-tagStart;
	    if (tagLength == 0)
		wafeWarn(XmRXmString, "Ignoring empty tag", NULL,NULL,NULL);
	    else
	    if (tagLength == 2 && *tagStart == 'l' && *(tagStart+1) == 'r')
		dir = XmSTRING_DIRECTION_L_TO_R;
	    else
	    if (tagLength == 2 && *tagStart == 'r' && *(tagStart+1) == 'l')
		dir = XmSTRING_DIRECTION_R_TO_L;
	    else
		{
		wafeStringClear(cs);
		wafeStringAppendN(cs,tagStart,tagLength);
		csv = wafeStringValue(cs);
		}
	    }
	} /* for */

    if (!result) 
       result = XmStringSegmentCreate(wafe_EMPTY, csv, dir, False);

    return result;
    }


static XmStringTable
wafeCvtStringToXmStringTable(inString)
char * inString;
    {
    int argc;
    char ** argv;
    XmString *strTable, *t;
    int i;

    Tcl_SplitList(wafeInterpreter,inString, &argc,&argv);
    t = strTable = (XmString *)XtMalloc((argc+1)*sizeof(XmString));

    for ( i = 0; i < argc; i++, t++ )
	if (!(*t = wafeCvtStringToXmString(argv[i])))
	    {
	    wafeConvWarn("wafeCvtStringToXmStringTable", argv[i],XmRXmString);
	    XtFree((char *)argv);
	    return NULL;
	    }
    *t = NULL;

    XtFree((char *)argv);
    return (XmStringTable) strTable;
    }


/* Queries a XmString Value and translates it to a valid input string */

void
wafeCvtXmString2String(ws,compStr,returnTags)
wafeString    ws;
XmString      compStr;
Boolean       returnTags;
    {
    XmStringContext    context;
    XmStringDirection  dir,
                       lastDir = XmSTRING_DIRECTION_L_TO_R;
    char               *ptr;
    Boolean            firstCharSet = True;
    char              *text;
    XmStringCharSet    tag;
    XmStringComponentType unknown_tag;
    XmStringComponentType type;
    unsigned short     unknown_length;
    unsigned char     *unknown_value;

    DBUG_ENTER("wafeCvtXmString2String");

    if (!XmStringInitContext(&context, compStr))
	{
	wafeWarn("motif", "Could not obtain String Context", NULL,NULL,NULL);
	DBUG_VOID_RETURN;
	}

    while ((type = XmStringGetNextComponent(context, &text, &tag, &dir, 
					    &unknown_tag,&unknown_length,
					    &unknown_value))
	   != XmSTRING_COMPONENT_END)
	{

	DBUG_PRINT("motif", ("type %d, dir %d, u_tag %d",
			     type, dir, unknown_tag));

	switch (type)
	    {
	case XmSTRING_COMPONENT_TEXT:
#ifdef MOTIF12
	case XmSTRING_COMPONENT_LOCALE_TEXT:
#endif
	    if (returnTags)
		{
		char *t = text;
		DBUG_PRINT("motif", ("text segment '%s'", text));
		do
		    {
		    for (ptr = t; *ptr && *ptr != '^'; ptr++);
		    wafeStringAppendN(ws, t, ptr-t);
		    if (*ptr == '^') 
			{
			wafeStringAppend(ws, "^^");
			t = ++ptr;
			}
		    } while (*ptr);
		}
	    else
		wafeStringAppend(ws, text);

	    XtFree(text);
	    break;

	case XmSTRING_COMPONENT_SEPARATOR:
	    wafeStringAppendChar(ws, '\n');
	    break;

	case XmSTRING_COMPONENT_DIRECTION:
	    if (returnTags && dir != lastDir)
		{
		if (dir == XmSTRING_DIRECTION_L_TO_R)
		    wafeStringAppend(ws, "^lr ");
		else
		    wafeStringAppend(ws, "^rl ");
		lastDir = dir;
		}
	    break;

        case WAFE_FONTLIST_TAG:
	    DBUG_PRINT("motif",
		       ("firstCharSet %d, tag='%s', defaultCharSet='%s'",
			firstCharSet,tag,defaultCharSet));
	    if (returnTags && !(firstCharSet && 
		  (!strcmp(tag, defaultCharSet) || 
		   !strcmp(tag, XmFONTLIST_DEFAULT_TAG)
		   ))
		)
		{
		wafeStringAppendChar(ws, '^');
		wafeStringAppend(ws, tag);
		wafeStringAppendChar(ws, ' ');
		firstCharSet = False;
		}
	    XtFree(tag);
	    break;

	case XmSTRING_COMPONENT_UNKNOWN:
	    wafeWarn("motif", "Unknown component in XmString ignored!",
		     NULL,NULL,NULL);
	    break;
	    }
	
	}
    
    XmStringFreeContext(context);
    DBUG_VOID_RETURN;
    }


void
wafeStringAppendXmEscaped(ws,compStr)
wafeString ws;
XmString   compStr;
    {
    wafeStringStruct   ws0_struct;
    wafeString         ws0 = &ws0_struct;
    wafeStringInit(ws0);
    wafeCvtXmString2String(ws0,compStr,True);
    wafeStringAppendEscaped(ws,wafeStringValue(ws0),wafeStringLength(ws0));
    wafeStringClear(ws0);
    }

static int
currentStringTableSize () 
    {
    int count = 0;
    if (wafeCurrentWidget && wafeCurrentAttrib)
	    {
	    /* try hard to figure out what the length of the XmStringTable is.
	     *
	     * i have tried before the following code, which was not reliable; 
	     * if somebody knows a better way, how to determine the number of 
	     * items in a XmStringTable please, let me know
	     *
	     *  for (; strTable[count] && 
	     *         ((unsigned)strTable[count] & 0xffff0000) && 
	     *       *strTable[count] == 0xdf; count++) 
	     */
	
	    if (XtClass(wafeCurrentWidget) == xmListWidgetClass)
		{
		if (wafeCurrentAttrib == qitems)
		    XtVaGetValues(wafeCurrentWidget, 
				  XmNitemCount, &count, NULL);
		else 
		    if (wafeCurrentAttrib == qselectedItems)
			XtVaGetValues(wafeCurrentWidget, 
				      XmNselectedItemCount, &count, NULL);
		}
	    else
		wafeWarn(XmRXmString,
			 "No XmStringTables known for class %s",
			 (XtClass(wafeCurrentWidget)->core_class.class_name),
			 NULL,NULL);
	    }
	else
	    wafeWarn(XmRXmString,"Cannot determine size of XmStringTable",
		     NULL,NULL,NULL);
    return count;
    }


String
wafeCvtXmStringTable2String(count,strTable)
int           count;
XmStringTable strTable;
    {
    char     **temp, **cPtr;
    XmString  *ptr;
    char      *result;
    int        i;
    wafeStringStruct   ws_struct;
    wafeString         ws = &ws_struct;

    DBUG_ENTER("wafeCvtXmStringTable2String");

    wafeStringInit(ws);
    
    if (count == -1)
	count = currentStringTableSize();

    temp = (char **)XtMalloc(count*sizeof(char *));
    for (ptr=strTable, cPtr=temp, i=count; i>0; ptr++, cPtr++, i--)
	{
	wafeCvtXmString2String(ws,*ptr,True);
	*cPtr = XtNewString(wafeStringValue(ws));
	wafeStringClear(ws);
	}

    result = Tcl_Merge(count, temp);
    for (cPtr = temp, i=count; i>0; cPtr++, i--)
	XtFree(*cPtr);

    XtFree((char *)temp);
    DBUG_RETURN (result);
    }

void
wafeStringAppendXmStringTableEscaped(ws,count,strTable)
wafeString    ws;
int           count;
XmStringTable strTable;
    {
    XmString  *ptr;
    int        i;
    wafeStringStruct   ws0_struct;
    wafeString         ws0 = &ws0_struct;

    DBUG_ENTER("wafeCvtXmStringTable2StringEscaped");

    if (count == -1)
	count = currentStringTableSize();

    DBUG_PRINT(XmRXmString,("count %d",count));
    
    if (count>0)
	{
	wafeStringInit(ws0);    
	for (ptr=strTable, i=count; i>0; ptr++, i--)
	    {
	    wafeCvtXmString2String(ws0,*ptr,True);
	    wafeStringAppendListItemEscaped(ws,wafeStringValue(ws0));
	    wafeStringClear(ws0);
	    }

	ws->length--;
	ws->buffer[ws->length] = 0;
	}

    DBUG_VOID_RETURN;
    }

/*
 * Two converter function wrappers for the *2String functions, which are
 * called by getValues
 */

static Boolean
CvtXmStringToString(dpy, args, num_args, fromVal, toVal, converterData)
Display   *dpy;
XrmValue  *args;
Cardinal  *num_args;
XrmValue  *fromVal;
XrmValue  *toVal;
XtPointer *converterData;
    {
    wafeStringStruct   ws_struct;
    wafeString         ws = &ws_struct;

    DBUG_ENTER("CvtXmStringToString");
    wafeStringInit(ws);
    wafeCvtXmString2String(ws,(XmString)(fromVal->addr),True);
    toVal->addr = XtNewString(wafeStringValue(ws));
    toVal->size = wafeStringLength(ws); 
    wafeStringClear(ws);
    DBUG_RETURN(True);
    }


static Boolean
CvtXmStringTableToString(dpy, args, num_args, fromVal, toVal, converter_data)
Display   *dpy;
XrmValue  *args;
Cardinal  *num_args;
XrmValue  *fromVal;
XrmValue  *toVal;
XtPointer *converter_data;
    {
    static char *result;
    DBUG_ENTER("CvtXmStringTableToString");
    result = wafeCvtXmStringTable2String(-1,(XmStringTable)(fromVal->addr));
    toVal->addr = result;
    toVal->size = 1; /* it should not matter either */
    DBUG_RETURN(True);
    }


static void
freeXmStringTable(table)
XmStringTable  table;
    {
    XmStringTable t = table;
    while (*t != NULL)
	XmStringFree(*t++);
    XtFree((char *)table);
    }	


Boolean
CvtStringToXmStrings(dpy, args, num_args, fromVal, toVal, converter_data)
Display   *dpy;
XrmValue  *args;
Cardinal  *num_args;
XrmValue  *fromVal;
XrmValue  *toVal;
XtPointer *converter_data;
    {
    int               argc, count;
    char            **argv;
    XmString         *ptr;
    static XmString  *result;

    DBUG_ENTER("CvtStringToXmStrings");

    if (Tcl_SplitList(wafeInterpreter,(char*)fromVal->addr, &argc, &argv)
	!= TCL_OK)
	{
	wafeWarn("CvtStringToXmStrings", wafeInterpreter->result,
		 NULL,NULL,NULL);
	return False;
	}


    result = (XmString *)XtMalloc((argc+1)*sizeof(XmString));
    for(count = 0, ptr = result; count < argc; count++, ptr++)
	{
	if ((*ptr = wafeCvtStringToXmString(argv[count],NULL,0)) == NULL)
	    {
	    XtDisplayStringConversionWarning(dpy, (char *)fromVal->addr,
					     XmRString);
	    XtFree((char *)result);
	    XtFree((char *)argv);
	    return False;
	    }
	}
    *ptr = NULL;
    XtFree((char *)argv);

    if (toVal->addr)
	{
	wafeWarn("CvtStringToXmStrings", 
		 "somebody else called CvtStringToXmStrings",
		 NULL,NULL,NULL);
	
	if (toVal->size < sizeof(XmString *))
	    {
	    toVal->size = sizeof(XmString *);
	    XtFree((char *)result);
	    DBUG_RETURN(False);
	    }

	toVal->size = sizeof(XmString *);
	*(XmString **)(toVal->addr) = result;
	DBUG_RETURN(True);
	}

    toVal->size = sizeof(XmString **);
    toVal->addr = (caddr_t)&result;
    wafeMMreplace(NULL,NULL, wafeCurrentAttrib,
		  (char *)result, freeXmStringTable);
    DBUG_RETURN(True);
    }


Boolean
CvtStringToXmString(dpy, args, num_args, fromVal, toVal,
                                converter_data)
Display   *dpy;
XrmValue  *args;
Cardinal  *num_args;
XrmValue  *fromVal;
XrmValue  *toVal;
XtPointer *converter_data;
    {
    static XmString  result;
    DBUG_ENTER("CvtStringToXmString");

    DBUG_PRINT("CvtStringToXmString",
	       ("CvtStringToXmString: <%s> (toval: %p %d)\n",
		fromVal->addr, toVal->addr, toVal->size));


    if ((result = wafeCvtStringToXmString((char *)fromVal->addr, NULL, 0)) == NULL)
	{
	XtDisplayStringConversionWarning(dpy, (char *)fromVal->addr,
					 XmRXmString);
	DBUG_RETURN(False);
	}

    if (toVal->addr)
	{
	if (toVal->size < sizeof(XmString))
	    {
	    toVal->size = sizeof(XmString);
	    XmStringFree(result);
	    DBUG_RETURN(False);
	    }

	toVal->size = sizeof(XmString);
	*(XmString *)(toVal->addr) = result;
	DBUG_RETURN(True);
	}

    toVal->size = sizeof(XmString *);
    toVal->addr = (XtPointer)result;

    wafeMMreplace(NULL,NULL, wafeCurrentAttrib,
		  (char *)result, (freeProc)XmStringFree);
    DBUG_RETURN(True);
    }


static Boolean
CvtStringToLong(dpy, args, num_args, fromVal, toVal,
                                converter_data)
Display   *dpy;
XrmValue  *args;
Cardinal  *num_args;
XrmValue  *fromVal;
XrmValue  *toVal;
XtPointer *converter_data;
    {
    long result;

    if (sscanf((char *)fromVal->addr, "%ld", &result) == 1)
	{
	CONVERSION_DONE(long, result);
	}
    else
	return False;
    }


#include <Xm/Protocols.h>
static void
wafeAddProtocol(w, property, protocol)
Widget   w;
Atom     property, protocol;
    {
    XmAddProtocols(w,property,&protocol,1);
    }

static void
protocolCallbackProc(w, clientData, callData)
Widget w;
XtPointer clientData;
XtPointer callData;
    {
    DBUG_ENTER("protocolCallbackProc");
    wafeExecCallbackProc(w, clientData, callData);
    DBUG_VOID_RETURN;
    }

static void
wafeAddProtocolCallback(w, property, protocol, string)
Widget   w;
Atom     property, protocol;
String   string;
    {
    char *charp = XtMalloc(strlen(string)+1+sizeof(XrmQuark));

    *(XrmQuark *)charp = (XrmQuark)0;
    strcpy((char *)charp + sizeof(XrmQuark), (char *)string);
    XmAddProtocolCallback(w, property, protocol, 
			  protocolCallbackProc, 
			  (XtPointer)charp);
    }

int
wafeModifyVerifyCBset(doit, currInsert, startPos, endPos, string)
Boolean doit;
long currInsert, startPos, endPos;
String string;
    {
    XmTextVerifyCallbackStruct *cbs = 
	(XmTextVerifyCallbackStruct *)wafeCurrentCallData;
    int newLength =  strlen(string);

    DBUG_ENTER("wafeModifyVerifyCBset");
    
    if (!cbs || cbs->reason !=  XmCR_MODIFYING_TEXT_VALUE) 
	DBUG_RETURN(wafeSetError("calling wafeModifyVerifyCBset is only valid from a modifyVerifyCallback",NULL,NULL,NULL));

    cbs->doit = doit;

    if (doit)
	{
	if (currInsert>=0) cbs->newInsert    = currInsert;
	if (startPos>=0)   cbs->startPos     = startPos;
	if (endPos>=0)     cbs->endPos       = endPos;

	if (newLength>0) 
	    {
	    if (newLength >= cbs->text->length) 
		cbs->text->ptr = XtRealloc(cbs->text->ptr,newLength+1);
	    
	    strcpy(cbs->text->ptr, string);
	    cbs->text->length = newLength;
	    }
	else 
	    {
	    if (cbs->text->length>0) 
		XtFree(cbs->text->ptr);
	    cbs->text->ptr    = NULL;
	    cbs->text->length = 0;
	    }
	}

    DBUG_RETURN(TCL_OK);
    }

#include <Xm/FileSB.h>

static void
fileSearchProc(w, searchData)
Widget  w;
XmFileSelectionBoxCallbackStruct *searchData;
    {
    char *cmd;
    DBUG_ENTER("fileSearchProc");
    if ((cmd = wafeMMgetValue(w, qfileSearchProc, NULL, False)))
	wafeExecCallbackProc(w, (XtPointer)cmd, searchData);

    DBUG_VOID_RETURN;
    }

static void
dirSearchProc(w, searchData)
Widget  w;
XmFileSelectionBoxCallbackStruct *searchData;
    {
    char *cmd;
    DBUG_ENTER("dirSearchProc");
    if ((cmd = wafeMMgetValue(w, qdirSearchProc, NULL, False)))
	wafeExecCallbackProc(w, (XtPointer)cmd, searchData);

    DBUG_VOID_RETURN;
    }



Boolean
CvtStringToFileSearchProc(dpy, args, num_args, fromVal, toVal,
		    converter_data)
Display *dpy;
XrmValue *args;
Cardinal *num_args;
XrmValue *fromVal;
XrmValue *toVal;
XtPointer *converter_data;
    {
    if (wafeCurrentAttrib == qfileSearchProc || 
	wafeCurrentAttrib == qdirSearchProc   ) 
	{
	char *charp = XtMalloc(strlen(fromVal->addr)+1+sizeof(XrmQuark));
	XtPointer proc = (wafeCurrentAttrib == qfileSearchProc) ? 
		(XtPointer)fileSearchProc : 
                (XtPointer)dirSearchProc;

	*(XrmQuark *)charp = wafeCurrentAttrib;
	strcpy((char *)charp + sizeof(XrmQuark), (char *)fromVal->addr);
	wafeMMreplace(NULL, NULL, wafeCurrentAttrib,
		      (char *)charp, XtFree);

	CONVERSION_DONE(XtPointer, proc);
	} 
    else 
	return False;
    }


int
XmGetString(w,resource)
Widget w;
String resource;
    {
    XrmQuark qResName   = XrmStringToQuark(resource);
    XrmQuark qType;
    
    if (!(qType = wafeGetQTypeOfAttribute(XtClass(w),
					  ParentWidget(w),qResName,NULL)))
	return wafeSetError("widget %s has no resource %s",
			    wafeWidgetToName(w), resource, NULL);

    if (qType == qXmString) 
	{
	XmString s;
	wafeStringStruct   ws_struct;
	wafeString         ws = &ws_struct;
	wafeStringInit(ws);
	XtVaGetValues(w,resource,&s,NULL);
	wafeCvtXmString2String(ws, s, False);
	Tcl_SetResult(wafeInterpreter, wafeStringValue(ws), TCL_VOLATILE);
	wafeStringClear(ws);
	}
    else 
    if (qType == qString) 
	{
	String returnString = NULL;
	XtVaGetValues(w,resource,&returnString,NULL);
	Tcl_SetResult(wafeInterpreter, returnString, TCL_VOLATILE);
	}
    else
	{
	return wafeSetError("resource %s is not of type String or XmString",
			    resource, NULL, NULL);
	/* maybe we should handle XmStringTables here as well */
	}
    return TCL_OK;
    }

static int cmd_XmAddTabGroup();
static int cmd_XmCascadeButtonGadgetHighlight();
static int cmd_XmCascadeButtonHighlight();
static int cmd_XmCommandAppendValue();
static int cmd_XmCommandError();
static int cmd_XmCommandGetChild();
static int cmd_XmFileSelectionBoxGetChild();
static int cmd_XmFileSelectionDoSearch();
static int cmd_XmGetDestination();
static int cmd_XmListAddItem();
static int cmd_XmListAddItems();
static int cmd_XmListAddItemUnselected();
static int cmd_XmListDeleteAllItems();
static int cmd_XmListDeleteItem();
static int cmd_XmListDeleteItems();
static int cmd_XmListDeleteItemsPos();
static int cmd_XmListDeletePos();
static int cmd_XmListDeselectAllItems();
static int cmd_XmListDeselectItem();
static int cmd_XmListDeselectPos();
static int cmd_XmListGetMatchPos();
static int cmd_XmListGetSelectedPos();
static int cmd_XmListItemExists();
static int cmd_XmListItemPos();
static int cmd_XmListReplaceItems();
static int cmd_XmListReplaceItemsPos();
static int cmd_XmListSelectItem();
static int cmd_XmListSelectPos();
static int cmd_XmListSetAddMode();
static int cmd_XmListSetBottomItem();
static int cmd_XmListSetBottomPos();
static int cmd_XmListSetHorizPos();
static int cmd_XmListSetItem();
static int cmd_XmListSetPos();
static int cmd_XmMainWindowSetAreas();
static int cmd_XmMenuPosition();
static int cmd_XmMessageBoxGetChild();
static int cmd_XmProcessTraversal();
static int cmd_XmScrollBarGetValues();
static int cmd_XmScrollBarSetValues();
static int cmd_XmSelectionBoxGetChild();
static int cmd_XmTextClearSelection();
static int cmd_XmTextCopy();
static int cmd_XmTextCut();
static int cmd_XmTextFieldClearSelection();
static int cmd_XmTextFieldCopy();
static int cmd_XmTextFieldCut();
static int cmd_XmTextFieldGetBaseline();
static int cmd_XmTextFieldGetLastPosition();
static int cmd_XmTextFieldGetSelection();
static int cmd_XmTextFieldGetSelectionPosition();
static int cmd_XmTextFieldGetString();
static int cmd_XmTextFieldInsert();
static int cmd_XmTextFieldPaste();
static int cmd_XmTextFieldPosToXY();
static int cmd_XmTextFieldRemove();
static int cmd_XmTextFieldReplace();
static int cmd_XmTextFieldSetAddMode();
static int cmd_XmTextFieldSetHighlight();
static int cmd_XmTextFieldSetSelection();
static int cmd_XmTextFieldShowPosition();
static int cmd_XmTextFieldXYToPos();
static int cmd_XmTextGetBaseline();
static int cmd_XmTextGetLastPosition();
static int cmd_XmTextGetSelection();
static int cmd_XmTextGetSelectionPosition();
static int cmd_XmTextGetString();
static int cmd_XmTextInsert();
static int cmd_XmTextPaste();
static int cmd_XmTextPosToXY();
static int cmd_XmTextRemove();
static int cmd_XmTextReplace();
static int cmd_XmTextScroll();
static int cmd_XmTextSetAddMode();
static int cmd_XmTextSetHighlight();
static int cmd_XmTextSetSelection();
static int cmd_XmTextShowPosition();
static int cmd_XmTextXYToPos();
static int cmd_XmToggleButtonGetState();
static int cmd_XmToggleButtonSetState();
static int cmd_XmToggleButtonGadgetGetState();
static int cmd_XmToggleButtonGadgetSetState();
static int cmd_XmUpdateDisplay();
static int cmd_XmAddProtocol();
static int cmd_XmAddProtocolCallback();
static int cmd_XmActivateProtocol();
static int cmd_XmDeactivateProtocol();
static int cmd_XmTextSetSelectionArray();
static int cmd_XmTextFieldSetSelectionArray();
static int cmd_XmModifyVerifyCBset();
static int cmd_XmInstallImage();
static int cmd_XmGetString();

static _Xconst Proc_signature cmds[] = {
    { "XmAddTabGroup", cmd_XmAddTabGroup },
    { "XmCascadeButtonGadgetHighlight", cmd_XmCascadeButtonGadgetHighlight },
    { "XmCascadeButtonHighlight", cmd_XmCascadeButtonHighlight },
    { "XmCommandAppendValue", cmd_XmCommandAppendValue },
    { "XmCommandError", cmd_XmCommandError },
    { "XmCommandGetChild", cmd_XmCommandGetChild },
    { "XmFileSelectionBoxGetChild", cmd_XmFileSelectionBoxGetChild },
    { "XmFileSelectionDoSearch", cmd_XmFileSelectionDoSearch },
    { "XmGetDestination", cmd_XmGetDestination },
    { "XmListAddItem", cmd_XmListAddItem },
    { "XmListAddItems", cmd_XmListAddItems },
    { "XmListAddItemUnselected", cmd_XmListAddItemUnselected },
    { "XmListDeleteAllItems", cmd_XmListDeleteAllItems },
    { "XmListDeleteItem", cmd_XmListDeleteItem },
    { "XmListDeleteItems", cmd_XmListDeleteItems },
    { "XmListDeleteItemsPos", cmd_XmListDeleteItemsPos },
    { "XmListDeletePos", cmd_XmListDeletePos },
    { "XmListDeselectAllItems", cmd_XmListDeselectAllItems },
    { "XmListDeselectItem", cmd_XmListDeselectItem },
    { "XmListDeselectPos", cmd_XmListDeselectPos },
    { "XmListGetMatchPos", cmd_XmListGetMatchPos },
    { "XmListGetSelectedPos", cmd_XmListGetSelectedPos },
    { "XmListItemExists", cmd_XmListItemExists },
    { "XmListItemPos", cmd_XmListItemPos },
    { "XmListReplaceItems", cmd_XmListReplaceItems },
    { "XmListReplaceItemsPos", cmd_XmListReplaceItemsPos },
    { "XmListSelectItem", cmd_XmListSelectItem },
    { "XmListSelectPos", cmd_XmListSelectPos },
    { "XmListSetAddMode", cmd_XmListSetAddMode },
    { "XmListSetBottomItem", cmd_XmListSetBottomItem },
    { "XmListSetBottomPos", cmd_XmListSetBottomPos },
    { "XmListSetHorizPos", cmd_XmListSetHorizPos },
    { "XmListSetItem", cmd_XmListSetItem },
    { "XmListSetPos", cmd_XmListSetPos },
    { "XmMainWindowSetAreas", cmd_XmMainWindowSetAreas },
    { "XmMenuPosition", cmd_XmMenuPosition },
    { "XmMessageBoxGetChild", cmd_XmMessageBoxGetChild },
    { "XmProcessTraversal", cmd_XmProcessTraversal },
    { "XmScrollBarGetValues", cmd_XmScrollBarGetValues },
    { "XmScrollBarSetValues", cmd_XmScrollBarSetValues },
    { "XmSelectionBoxGetChild", cmd_XmSelectionBoxGetChild },
    { "XmTextClearSelection", cmd_XmTextClearSelection },
    { "XmTextCopy", cmd_XmTextCopy },
    { "XmTextCut", cmd_XmTextCut },
    { "XmTextFieldClearSelection", cmd_XmTextFieldClearSelection },
    { "XmTextFieldCopy", cmd_XmTextFieldCopy },
    { "XmTextFieldCut", cmd_XmTextFieldCut },
    { "XmTextFieldGetBaseline", cmd_XmTextFieldGetBaseline },
    { "XmTextFieldGetLastPosition", cmd_XmTextFieldGetLastPosition },
    { "XmTextFieldGetSelection", cmd_XmTextFieldGetSelection },
    { "XmTextFieldGetSelectionPosition", cmd_XmTextFieldGetSelectionPosition },
    { "XmTextFieldGetString", cmd_XmTextFieldGetString },
    { "XmTextFieldInsert", cmd_XmTextFieldInsert },
    { "XmTextFieldPaste", cmd_XmTextFieldPaste },
    { "XmTextFieldPosToXY", cmd_XmTextFieldPosToXY },
    { "XmTextFieldRemove", cmd_XmTextFieldRemove },
    { "XmTextFieldReplace", cmd_XmTextFieldReplace },
    { "XmTextFieldSetAddMode", cmd_XmTextFieldSetAddMode },
    { "XmTextFieldSetHighlight", cmd_XmTextFieldSetHighlight },
    { "XmTextFieldSetSelection", cmd_XmTextFieldSetSelection },
    { "XmTextFieldShowPosition", cmd_XmTextFieldShowPosition },
    { "XmTextFieldXYToPos", cmd_XmTextFieldXYToPos },
    { "XmTextGetBaseline", cmd_XmTextGetBaseline },
    { "XmTextGetLastPosition", cmd_XmTextGetLastPosition },
    { "XmTextGetSelection", cmd_XmTextGetSelection },
    { "XmTextGetSelectionPosition", cmd_XmTextGetSelectionPosition },
    { "XmTextGetString", cmd_XmTextGetString },
    { "XmTextInsert", cmd_XmTextInsert },
    { "XmTextPaste", cmd_XmTextPaste },
    { "XmTextPosToXY", cmd_XmTextPosToXY },
    { "XmTextRemove", cmd_XmTextRemove },
    { "XmTextReplace", cmd_XmTextReplace },
    { "XmTextScroll", cmd_XmTextScroll },
    { "XmTextSetAddMode", cmd_XmTextSetAddMode },
    { "XmTextSetHighlight", cmd_XmTextSetHighlight },
    { "XmTextSetSelection", cmd_XmTextSetSelection },
    { "XmTextShowPosition", cmd_XmTextShowPosition },
    { "XmTextXYToPos", cmd_XmTextXYToPos },
    { "XmToggleButtonGetState", cmd_XmToggleButtonGetState },
    { "XmToggleButtonSetState", cmd_XmToggleButtonSetState },
    { "XmToggleButtonGadgetGetState", cmd_XmToggleButtonGadgetGetState },
    { "XmToggleButtonGadgetSetState", cmd_XmToggleButtonGadgetSetState },
    { "XmUpdateDisplay", cmd_XmUpdateDisplay },
    { "XmAddProtocol", cmd_XmAddProtocol },
    { "XmAddProtocolCallback", cmd_XmAddProtocolCallback },
    { "XmActivateProtocol", cmd_XmActivateProtocol },
    { "XmDeactivateProtocol", cmd_XmDeactivateProtocol },
    { "XmTextSetSelectionArray", cmd_XmTextSetSelectionArray },
    { "XmTextFieldSetSelectionArray", cmd_XmTextFieldSetSelectionArray },
    { "XmModifyVerifyCBset", cmd_XmModifyVerifyCBset },
    { "XmInstallImage", cmd_XmInstallImage },
    { "XmGetString", cmd_XmGetString },
    { NULL, NULL }
    };

static WidgetCreate_signature wccs[] = {
    { "XmArrowButton",NULL,NULL,False },
    { "XmArrowButtonGadget",NULL,NULL,False },
    { "XmBulletinBoard",NULL,NULL,False },
    { "XmBulletinBoardDialog",NULL,XmCreateBulletinBoardDialog,True },
    { "XmCascadeButton",NULL,NULL,False },
    { "XmCascadeButtonGadget",NULL,NULL,False },
    { "XmCommand",NULL,NULL,False },
    { "XmDialogShell",NULL,NULL,True },
    { "XmDrawingArea",NULL,NULL,False },
    { "XmDrawnButton",NULL,NULL,False },
    { "XmErrorDialog",NULL,XmCreateErrorDialog,True },
    { "XmFileSelectionBox",NULL,NULL,False },
    { "XmFileSelectionDialog",NULL,XmCreateFileSelectionDialog,True },
    { "XmForm",NULL,NULL,False },
    { "XmFormDialog",NULL,XmCreateFormDialog,True },
    { "XmFrame",NULL,NULL,False },
    { "XmInformationDialog",NULL,XmCreateInformationDialog,True },
    { "XmLabel",NULL,NULL,False },
    { "XmLabelGadget",NULL,NULL,False },
    { "XmList",NULL,NULL,False },
    { "XmMainWindow",NULL,NULL,False },
    { "XmMenuBar",NULL,XmCreateMenuBar,False },
    { "XmMenuShell",NULL,NULL,True },
    { "XmMessageBox",NULL,NULL,False },
    { "XmMessageDialog",NULL,XmCreateMessageDialog,True },
    { "XmOptionMenu",NULL,XmCreateOptionMenu,False },
    { "XmPanedWindow",NULL,NULL,False },
    { "XmPopupMenu",NULL,XmCreatePopupMenu,False },
    { "XmPromptDialog",NULL,XmCreatePromptDialog,True },
    { "XmPulldownMenu",NULL,XmCreatePulldownMenu,False },
    { "XmPushButton",NULL,NULL,False },
    { "XmPushButtonGadget",NULL,NULL,False },
    { "XmQuestionDialog",NULL,XmCreateQuestionDialog,True },
    { "XmRadioBox",NULL,XmCreateRadioBox,False },
    { "XmRowColumn",NULL,NULL,False },
    { "XmScale",NULL,NULL,False },
    { "XmScrollBar",NULL,NULL,False },
    { "XmScrolledList",NULL,XmCreateScrolledList,False },
    { "XmScrolledText",NULL,XmCreateScrolledText,False },
    { "XmScrolledWindow",NULL,NULL,False },
    { "XmSelectionBox",NULL,NULL,False },
    { "XmSelectionDialog",NULL,XmCreateSelectionDialog,True },
    { "XmSeparator",NULL,NULL,False },
    { "XmSeparatorGadget",NULL,NULL,False },
    { "XmSimpleCheckBox",NULL,XmCreateSimpleCheckBox,False },
    { "XmSimpleMenuBar",NULL,XmCreateSimpleMenuBar,False },
    { "XmSimpleOptionMenu",NULL,XmCreateSimpleOptionMenu,False },
    { "XmSimplePopupMenu",NULL,XmCreateSimplePopupMenu,False },
    { "XmSimplePulldownMenu",NULL,XmCreateSimplePulldownMenu,False },
    { "XmSimpleRadioBox",NULL,XmCreateSimpleRadioBox,False },
    { "XmText",NULL,NULL,False },
    { "XmTextField",NULL,NULL,False },
    { "XmToggleButton",NULL,NULL,False },
    { "XmToggleButtonGadget",NULL,NULL,False },
    { "XmWarningDialog",NULL,XmCreateWarningDialog,True },
    { "XmWorkingDialog",NULL,XmCreateWorkingDialog,True },
    { NULL,NULL,NULL,False }
    };

static _Xconst String pkgs[] = {
     "MOTIF11",
    NULL
     };


#include <X11/Shell.h>
#include <Xm/RowColumn.h>

#define WS_XmAddTabGroup cmds[0].name
/* 
 * void
 * XmAddTabGroup
 * 	in: Widget     		# widget to be added
 */

static int 
cmd_XmAddTabGroup(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;

     DBUG_ENTER(argv[0]);  

     if (argc != 2) 
	 DBUG_RETURN(wafeArgcError(argc,argv,wafeStrings[2],1));

     if (!(localVar1 = (Widget) name2Widget(argv[1])))
         DBUG_RETURN (wafeConvError(argc, argv, 1 ,NULL, XtRWidget));

     XmAddTabGroup(localVar1);

     DBUG_RETURN (TCL_OK);
     }



#define WS_XmArrowButton wccs[0].name
#define WS_XmArrowButtonGadget wccs[1].name
#define WS_XmBulletinBoard wccs[2].name
#define WS_XmBulletinBoardDialog wccs[3].name
#define WS_XmCascadeButton wccs[4].name
#define WS_XmCascadeButtonGadget wccs[5].name
#define WS_XmCascadeButtonGadgetHighlight cmds[1].name
/* 
 * void 
 * XmCascadeButtonGadgetHighlight
 * 	in: XmCascadeButtonGadget   	# cascadeButtonGadget to be highlighted
 * 	in: Boolean          	    	# highlight (bool)
 */

static int 
cmd_XmCascadeButtonGadgetHighlight(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     Boolean localVar2;

     DBUG_ENTER(argv[0]);  

     if (argc != 3) 
	 DBUG_RETURN(wafeArgcError(argc,argv,wafeStrings[2],2));

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmCascadeButtonGadgetClass)))
         DBUG_RETURN (wafeConvError(argc, argv, 1 ,NULL, WS_XmCascadeButtonGadget));

     if (!(wafeGetBoolean(argv[2],&localVar2)))
         DBUG_RETURN (wafeConvError(argc, argv, 2 ,NULL, XtRBoolean));

     XmCascadeButtonGadgetHighlight(localVar1,localVar2);

     DBUG_RETURN (TCL_OK);
     }



#define WS_XmCascadeButtonHighlight cmds[2].name
/* 
 * void 
 * XmCascadeButtonHighlight
 * 	in: XmCascadeButtonGadget   	# widget to be highlighted
 * 	in: Boolean          	    	# highlight (bool)
 */

static int 
cmd_XmCascadeButtonHighlight(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     Boolean localVar2;

     DBUG_ENTER(argv[0]);  

     if (argc != 3) 
	 DBUG_RETURN(wafeArgcError(argc,argv,wafeStrings[2],2));

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmCascadeButtonGadgetClass)))
         DBUG_RETURN (wafeConvError(argc, argv, 1 ,NULL, WS_XmCascadeButtonGadget));

     if (!(wafeGetBoolean(argv[2],&localVar2)))
         DBUG_RETURN (wafeConvError(argc, argv, 2 ,NULL, XtRBoolean));

     XmCascadeButtonHighlight(localVar1,localVar2);

     DBUG_RETURN (TCL_OK);
     }



#define WS_XmCommand wccs[6].name
#define WS_XmCommandAppendValue cmds[3].name
/* 
 * void
 * XmCommandAppendValue
 * 	in: XmCommandWidget          	# command widget 
 * 	in: XmString         		# command string
 */

static int 
cmd_XmCommandAppendValue(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     XmString localVar2;

     DBUG_ENTER(argv[0]);  

     if (argc != 3) 
	 DBUG_RETURN(wafeArgcError(argc,argv,wafeStrings[2],2));

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmCommandWidgetClass)))
         DBUG_RETURN (wafeConvError(argc, argv, 1 ,NULL, wafeStrings[32]));

     if (!(localVar2 = (XmString) wafeCvtStringToXmString(argv[2])))
         DBUG_RETURN (wafeConvError(argc, argv, 2 ,NULL, XmRXmString));

     XmCommandAppendValue(localVar1,localVar2);
     XmStringFree(localVar2);

     DBUG_RETURN (TCL_OK);
     }



#define WS_XmCommandError cmds[4].name
/* 
 * void
 * XmCommandError
 * 	in: XmCommandWidget           	# command widget 
 * 	in: XmString         		# error message
 */

static int 
cmd_XmCommandError(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     XmString localVar2;

     DBUG_ENTER(argv[0]);  

     if (argc != 3) 
	 DBUG_RETURN(wafeArgcError(argc,argv,wafeStrings[2],2));

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmCommandWidgetClass)))
         DBUG_RETURN (wafeConvError(argc, argv, 1 ,NULL, wafeStrings[32]));

     if (!(localVar2 = (XmString) wafeCvtStringToXmString(argv[2])))
         DBUG_RETURN (wafeConvError(argc, argv, 2 ,NULL, XmRXmString));

     XmCommandError(localVar1,localVar2);
     XmStringFree(localVar2);

     DBUG_RETURN (TCL_OK);
     }



#define WS_XmCommandGetChild cmds[5].name
/* 
 * WidgetID (WidgetID)
 * XmCommandGetChild
 * 	in: XmCommandWidget	        # command widget
 * 	in: (unsigned char)XmChild 	# child reference
 */

static int 
cmd_XmCommandGetChild(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     unsigned char localVar2;
     WidgetID returnVar;
     char conversionBuffer[100];

     DBUG_ENTER(argv[0]);  

     if (argc != 3) 
	 DBUG_RETURN(wafeArgcError(argc,argv,wafeStrings[2],2));

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmCommandWidgetClass)))
         DBUG_RETURN (wafeConvError(argc, argv, 1 ,NULL, wafeStrings[32]));

     if (!strcmp(argv[2], wafeStrings[44])) 
         localVar2 = XmDIALOG_CANCEL_BUTTON;
     else
     if (!strcmp(argv[2], wafeStrings[46])) 
         localVar2 = XmDIALOG_DEFAULT_BUTTON;
     else
     if (!strcmp(argv[2], wafeStrings[51])) 
         localVar2 = XmDIALOG_HELP_BUTTON;
     else
     if (!strcmp(argv[2], wafeStrings[56])) 
         localVar2 = XmDIALOG_OK_BUTTON;
     else
     if (!strcmp(argv[2], wafeStrings[59])) 
         localVar2 = XmDIALOG_SEPARATOR;
     else
     if (!strcmp(argv[2], wafeStrings[60])) 
         localVar2 = XmDIALOG_SYMBOL_LABEL;
     else
     if (!strcmp(argv[2], wafeStrings[55])) 
         localVar2 = XmDIALOG_MESSAGE_LABEL;
     else
     if (!strcmp(argv[2], wafeStrings[43])) 
         localVar2 = XmDIALOG_APPLY_BUTTON;
     else
     if (!strcmp(argv[2], wafeStrings[47])) 
         localVar2 = XmDIALOG_DIR_LIST;
     else
     if (!strcmp(argv[2], wafeStrings[48])) 
         localVar2 = XmDIALOG_DIR_LIST_LABEL;
     else
     if (!strcmp(argv[2], wafeStrings[49])) 
         localVar2 = XmDIALOG_FILTER_LABEL;
     else
     if (!strcmp(argv[2], wafeStrings[50])) 
         localVar2 = XmDIALOG_FILTER_TEXT;
     else
     if (!strcmp(argv[2], wafeStrings[53])) 
         localVar2 = XmDIALOG_LIST;
     else
     if (!strcmp(argv[2], wafeStrings[54])) 
         localVar2 = XmDIALOG_LIST_LABEL;
     else
     if (!strcmp(argv[2], wafeStrings[58])) 
         localVar2 = XmDIALOG_SELECTION_LABEL;
     else
     if (!strcmp(argv[2], wafeStrings[61])) 
         localVar2 = XmDIALOG_TEXT;
     else
     if (!strcmp(argv[2], wafeStrings[62])) 
         localVar2 = XmDIALOG_WORK_AREA;
     else
     if (!strcmp(argv[2], wafeStrings[45])) 
         localVar2 = XmDIALOG_COMMAND_TEXT;
     else
     if (!strcmp(argv[2], wafeStrings[57])) 
         localVar2 = XmDIALOG_PROMPT_LABEL;
     else
     if (!strcmp(argv[2], wafeStrings[52])) 
         localVar2 = XmDIALOG_HISTORY_LIST;
     else
         DBUG_RETURN(wafeConvError(argc,argv, 2,NULL, wafeStrings[33]));


     returnVar = (WidgetID) XmCommandGetChild(localVar1,localVar2);

     sprintf(conversionBuffer, wafeStrings[9], returnVar);
     Tcl_SetResult(comInterpreter, conversionBuffer, TCL_VOLATILE);

     DBUG_RETURN (TCL_OK);
     }



#define WS_XmDialogShell wccs[7].name
#define WS_XmDrawingArea wccs[8].name
#define WS_XmDrawnButton wccs[9].name
#define WS_XmErrorDialog wccs[10].name
#define WS_XmFileSelectionBox wccs[11].name
#define WS_XmFileSelectionBoxGetChild cmds[6].name
/* 
 * WidgetID (WidgetID)
 * XmFileSelectionBoxGetChild
 * 	in: XmFileSelectionBoxWidget		# file selection box widget
 * 	in: (unsigned char)XmChild 		# child reference
 */

static int 
cmd_XmFileSelectionBoxGetChild(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     unsigned char localVar2;
     WidgetID returnVar;
     char conversionBuffer[100];

     DBUG_ENTER(argv[0]);  

     if (argc != 3) 
	 DBUG_RETURN(wafeArgcError(argc,argv,wafeStrings[2],2));

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmFileSelectionBoxWidgetClass)))
         DBUG_RETURN (wafeConvError(argc, argv, 1 ,NULL, wafeStrings[34]));

     if (!strcmp(argv[2], wafeStrings[44])) 
         localVar2 = XmDIALOG_CANCEL_BUTTON;
     else
     if (!strcmp(argv[2], wafeStrings[46])) 
         localVar2 = XmDIALOG_DEFAULT_BUTTON;
     else
     if (!strcmp(argv[2], wafeStrings[51])) 
         localVar2 = XmDIALOG_HELP_BUTTON;
     else
     if (!strcmp(argv[2], wafeStrings[56])) 
         localVar2 = XmDIALOG_OK_BUTTON;
     else
     if (!strcmp(argv[2], wafeStrings[59])) 
         localVar2 = XmDIALOG_SEPARATOR;
     else
     if (!strcmp(argv[2], wafeStrings[60])) 
         localVar2 = XmDIALOG_SYMBOL_LABEL;
     else
     if (!strcmp(argv[2], wafeStrings[55])) 
         localVar2 = XmDIALOG_MESSAGE_LABEL;
     else
     if (!strcmp(argv[2], wafeStrings[43])) 
         localVar2 = XmDIALOG_APPLY_BUTTON;
     else
     if (!strcmp(argv[2], wafeStrings[47])) 
         localVar2 = XmDIALOG_DIR_LIST;
     else
     if (!strcmp(argv[2], wafeStrings[48])) 
         localVar2 = XmDIALOG_DIR_LIST_LABEL;
     else
     if (!strcmp(argv[2], wafeStrings[49])) 
         localVar2 = XmDIALOG_FILTER_LABEL;
     else
     if (!strcmp(argv[2], wafeStrings[50])) 
         localVar2 = XmDIALOG_FILTER_TEXT;
     else
     if (!strcmp(argv[2], wafeStrings[53])) 
         localVar2 = XmDIALOG_LIST;
     else
     if (!strcmp(argv[2], wafeStrings[54])) 
         localVar2 = XmDIALOG_LIST_LABEL;
     else
     if (!strcmp(argv[2], wafeStrings[58])) 
         localVar2 = XmDIALOG_SELECTION_LABEL;
     else
     if (!strcmp(argv[2], wafeStrings[61])) 
         localVar2 = XmDIALOG_TEXT;
     else
     if (!strcmp(argv[2], wafeStrings[62])) 
         localVar2 = XmDIALOG_WORK_AREA;
     else
     if (!strcmp(argv[2], wafeStrings[45])) 
         localVar2 = XmDIALOG_COMMAND_TEXT;
     else
     if (!strcmp(argv[2], wafeStrings[57])) 
         localVar2 = XmDIALOG_PROMPT_LABEL;
     else
     if (!strcmp(argv[2], wafeStrings[52])) 
         localVar2 = XmDIALOG_HISTORY_LIST;
     else
         DBUG_RETURN(wafeConvError(argc,argv, 2,NULL, wafeStrings[33]));


     returnVar = (WidgetID) XmFileSelectionBoxGetChild(localVar1,localVar2);

     sprintf(conversionBuffer, wafeStrings[9], returnVar);
     Tcl_SetResult(comInterpreter, conversionBuffer, TCL_VOLATILE);

     DBUG_RETURN (TCL_OK);
     }



#define WS_XmFileSelectionDialog wccs[12].name
#define WS_XmFileSelectionDoSearch cmds[7].name
/* 
 * void
 * XmFileSelectionDoSearch
 * 	in: XmFileSelectionBoxWidget		# file selection box
 * 	in: XmString				# directory mask
 */

static int 
cmd_XmFileSelectionDoSearch(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     XmString localVar2;

     DBUG_ENTER(argv[0]);  

     if (argc != 3) 
	 DBUG_RETURN(wafeArgcError(argc,argv,wafeStrings[2],2));

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmFileSelectionBoxWidgetClass)))
         DBUG_RETURN (wafeConvError(argc, argv, 1 ,NULL, wafeStrings[34]));

     if (!(localVar2 = (XmString) wafeCvtStringToXmString(argv[2])))
         DBUG_RETURN (wafeConvError(argc, argv, 2 ,NULL, XmRXmString));

     XmFileSelectionDoSearch(localVar1,localVar2);
     XmStringFree(localVar2);

     DBUG_RETURN (TCL_OK);
     }



#define WS_XmForm wccs[13].name
#define WS_XmFormDialog wccs[14].name
#define WS_XmFrame wccs[15].name
#define WS_XmGetDestination cmds[8].name
/* 
 * WidgetID (WidgetID)
 * XmGetDestination
 * 	in: XtDisplay(Widget)	        # any widget
 */

static int 
cmd_XmGetDestination(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     WidgetID returnVar;
     char conversionBuffer[100];

     DBUG_ENTER(argv[0]);  

     if (argc != 2) 
	 DBUG_RETURN(wafeArgcError(argc,argv,wafeStrings[2],1));

     if (!(localVar1 = (Widget) name2Widget(argv[1])))
         DBUG_RETURN (wafeConvError(argc, argv, 1 ,NULL, XtRWidget));

     returnVar = (WidgetID) XmGetDestination(XtDisplay(localVar1));

     sprintf(conversionBuffer, wafeStrings[9], returnVar);
     Tcl_SetResult(comInterpreter, conversionBuffer, TCL_VOLATILE);

     DBUG_RETURN (TCL_OK);
     }



#define WS_XmInformationDialog wccs[16].name
#define WS_XmLabel wccs[17].name
#define WS_XmLabelGadget wccs[18].name
#define WS_XmList wccs[19].name
#define WS_XmListAddItem cmds[9].name
/* 
 * void
 * XmListAddItem
 * 	in: XmListWidget	# List Widget
 * 	in: XmString		# Item to add
 * 	in: int			# Position
 */

static int 
cmd_XmListAddItem(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     XmString localVar2;
     int localVar3;

     DBUG_ENTER(argv[0]);  

     if (argc != 4) 
	 DBUG_RETURN(wafeArgcError(argc,argv,wafeStrings[2],3));

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmListWidgetClass)))
         DBUG_RETURN (wafeConvError(argc, argv, 1 ,NULL, wafeStrings[36]));

     if (!(localVar2 = (XmString) wafeCvtStringToXmString(argv[2])))
         DBUG_RETURN (wafeConvError(argc, argv, 2 ,NULL, XmRXmString));

     if (!(sscanf(argv[3], wafeStrings[7], &localVar3)))
         DBUG_RETURN (wafeConvError(argc, argv, 3 ,NULL, wafeStrings[14]));

     XmListAddItem(localVar1,localVar2,localVar3);
     XmStringFree(localVar2);

     DBUG_RETURN (TCL_OK);
     }



#define WS_XmListAddItems cmds[10].name
/* 
 * void
 * XmListAddItems
 * 	in: XmListWidget	# List Widget
 * 	in: XmStringTable	# items
 * 	in: int			# number of items
 * 	in: int			# position
 */

static int 
cmd_XmListAddItems(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     XmStringTable localVar2;
     int localVar3;
     int localVar4;

     DBUG_ENTER(argv[0]);  

     if (argc != 5) 
	 DBUG_RETURN(wafeArgcError(argc,argv,wafeStrings[2],4));

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmListWidgetClass)))
         DBUG_RETURN (wafeConvError(argc, argv, 1 ,NULL, wafeStrings[36]));

     if (!(localVar2 = (XmStringTable) wafeCvtStringToXmStringTable(argv[2])))
         DBUG_RETURN (wafeConvError(argc, argv, 2 ,NULL, XmRXmStringTable));

     if (!(sscanf(argv[3], wafeStrings[7], &localVar3)))
         DBUG_RETURN (wafeConvError(argc, argv, 3 ,NULL, wafeStrings[14]));

     if (!(sscanf(argv[4], wafeStrings[7], &localVar4)))
         DBUG_RETURN (wafeConvError(argc, argv, 4 ,NULL, wafeStrings[14]));

     XmListAddItems(localVar1,localVar2,localVar3,localVar4);
     freeXmStringTable(localVar2);

     DBUG_RETURN (TCL_OK);
     }



#define WS_XmListAddItemUnselected cmds[11].name
/* 
 * void
 * XmListAddItemUnselected
 * 	in: XmListWidget	# List Widget
 * 	in: XmString		# Item to add
 * 	in: int			# Position
 */

static int 
cmd_XmListAddItemUnselected(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     XmString localVar2;
     int localVar3;

     DBUG_ENTER(argv[0]);  

     if (argc != 4) 
	 DBUG_RETURN(wafeArgcError(argc,argv,wafeStrings[2],3));

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmListWidgetClass)))
         DBUG_RETURN (wafeConvError(argc, argv, 1 ,NULL, wafeStrings[36]));

     if (!(localVar2 = (XmString) wafeCvtStringToXmString(argv[2])))
         DBUG_RETURN (wafeConvError(argc, argv, 2 ,NULL, XmRXmString));

     if (!(sscanf(argv[3], wafeStrings[7], &localVar3)))
         DBUG_RETURN (wafeConvError(argc, argv, 3 ,NULL, wafeStrings[14]));

     XmListAddItemUnselected(localVar1,localVar2,localVar3);
     XmStringFree(localVar2);

     DBUG_RETURN (TCL_OK);
     }



#define WS_XmListDeleteAllItems cmds[12].name
/* 
 * void
 * XmListDeleteAllItems
 * 	in: XmListWidget	# List Widget
 */

static int 
cmd_XmListDeleteAllItems(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;

     DBUG_ENTER(argv[0]);  

     if (argc != 2) 
	 DBUG_RETURN(wafeArgcError(argc,argv,wafeStrings[2],1));

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmListWidgetClass)))
         DBUG_RETURN (wafeConvError(argc, argv, 1 ,NULL, wafeStrings[36]));

     XmListDeleteAllItems(localVar1);

     DBUG_RETURN (TCL_OK);
     }



#define WS_XmListDeleteItem cmds[13].name
/* 
 * void
 * XmListDeleteItem
 * 	in: XmListWidget	# List Widget
 * 	in: XmString		# Item to delete
 */

static int 
cmd_XmListDeleteItem(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     XmString localVar2;

     DBUG_ENTER(argv[0]);  

     if (argc != 3) 
	 DBUG_RETURN(wafeArgcError(argc,argv,wafeStrings[2],2));

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmListWidgetClass)))
         DBUG_RETURN (wafeConvError(argc, argv, 1 ,NULL, wafeStrings[36]));

     if (!(localVar2 = (XmString) wafeCvtStringToXmString(argv[2])))
         DBUG_RETURN (wafeConvError(argc, argv, 2 ,NULL, XmRXmString));

     XmListDeleteItem(localVar1,localVar2);
     XmStringFree(localVar2);

     DBUG_RETURN (TCL_OK);
     }



#define WS_XmListDeleteItems cmds[14].name
/* 
 * void
 * XmListDeleteItems
 * 	in: XmListWidget	# List Widget
 * 	in: XmStringTable	# items
 * 	in: int			# number of items
 */

static int 
cmd_XmListDeleteItems(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     XmStringTable localVar2;
     int localVar3;

     DBUG_ENTER(argv[0]);  

     if (argc != 4) 
	 DBUG_RETURN(wafeArgcError(argc,argv,wafeStrings[2],3));

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmListWidgetClass)))
         DBUG_RETURN (wafeConvError(argc, argv, 1 ,NULL, wafeStrings[36]));

     if (!(localVar2 = (XmStringTable) wafeCvtStringToXmStringTable(argv[2])))
         DBUG_RETURN (wafeConvError(argc, argv, 2 ,NULL, XmRXmStringTable));

     if (!(sscanf(argv[3], wafeStrings[7], &localVar3)))
         DBUG_RETURN (wafeConvError(argc, argv, 3 ,NULL, wafeStrings[14]));

     XmListDeleteItems(localVar1,localVar2,localVar3);
     freeXmStringTable(localVar2);

     DBUG_RETURN (TCL_OK);
     }



#define WS_XmListDeleteItemsPos cmds[15].name
/* 
 * void
 * XmListDeleteItemsPos
 * 	in: XmListWidget	# List Widget	
 * 	in: int			# number of items
 * 	in: int			# position of first item to be deleted
 */

static int 
cmd_XmListDeleteItemsPos(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     int localVar2;
     int localVar3;

     DBUG_ENTER(argv[0]);  

     if (argc != 4) 
	 DBUG_RETURN(wafeArgcError(argc,argv,wafeStrings[2],3));

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmListWidgetClass)))
         DBUG_RETURN (wafeConvError(argc, argv, 1 ,NULL, wafeStrings[36]));

     if (!(sscanf(argv[2], wafeStrings[7], &localVar2)))
         DBUG_RETURN (wafeConvError(argc, argv, 2 ,NULL, wafeStrings[14]));

     if (!(sscanf(argv[3], wafeStrings[7], &localVar3)))
         DBUG_RETURN (wafeConvError(argc, argv, 3 ,NULL, wafeStrings[14]));

     XmListDeleteItemsPos(localVar1,localVar2,localVar3);

     DBUG_RETURN (TCL_OK);
     }



#define WS_XmListDeletePos cmds[16].name
/* 
 * void
 * XmListDeletePos
 * 	in: XmListWidget	# List Widget	
 * 	in: int			# position of item
 */

static int 
cmd_XmListDeletePos(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     int localVar2;

     DBUG_ENTER(argv[0]);  

     if (argc != 3) 
	 DBUG_RETURN(wafeArgcError(argc,argv,wafeStrings[2],2));

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmListWidgetClass)))
         DBUG_RETURN (wafeConvError(argc, argv, 1 ,NULL, wafeStrings[36]));

     if (!(sscanf(argv[2], wafeStrings[7], &localVar2)))
         DBUG_RETURN (wafeConvError(argc, argv, 2 ,NULL, wafeStrings[14]));

     XmListDeletePos(localVar1,localVar2);

     DBUG_RETURN (TCL_OK);
     }



#define WS_XmListDeselectAllItems cmds[17].name
/* 
 * void
 * XmListDeselectAllItems
 * 	in: XmListWidget	# List Widget
 */

static int 
cmd_XmListDeselectAllItems(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;

     DBUG_ENTER(argv[0]);  

     if (argc != 2) 
	 DBUG_RETURN(wafeArgcError(argc,argv,wafeStrings[2],1));

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmListWidgetClass)))
         DBUG_RETURN (wafeConvError(argc, argv, 1 ,NULL, wafeStrings[36]));

     XmListDeselectAllItems(localVar1);

     DBUG_RETURN (TCL_OK);
     }



#define WS_XmListDeselectItem cmds[18].name
/* 
 * void
 * XmListDeselectItem
 * 	in: XmListWidget	# List Widget	
 * 	in: XmString		# item
 */

static int 
cmd_XmListDeselectItem(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     XmString localVar2;

     DBUG_ENTER(argv[0]);  

     if (argc != 3) 
	 DBUG_RETURN(wafeArgcError(argc,argv,wafeStrings[2],2));

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmListWidgetClass)))
         DBUG_RETURN (wafeConvError(argc, argv, 1 ,NULL, wafeStrings[36]));

     if (!(localVar2 = (XmString) wafeCvtStringToXmString(argv[2])))
         DBUG_RETURN (wafeConvError(argc, argv, 2 ,NULL, XmRXmString));

     XmListDeselectItem(localVar1,localVar2);
     XmStringFree(localVar2);

     DBUG_RETURN (TCL_OK);
     }



#define WS_XmListDeselectPos cmds[19].name
/* 
 * void
 * XmListDeselectPos
 * 	in: XmListWidget	# List Widget	
 * 	in: int			# position of item
 */

static int 
cmd_XmListDeselectPos(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     int localVar2;

     DBUG_ENTER(argv[0]);  

     if (argc != 3) 
	 DBUG_RETURN(wafeArgcError(argc,argv,wafeStrings[2],2));

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmListWidgetClass)))
         DBUG_RETURN (wafeConvError(argc, argv, 1 ,NULL, wafeStrings[36]));

     if (!(sscanf(argv[2], wafeStrings[7], &localVar2)))
         DBUG_RETURN (wafeConvError(argc, argv, 2 ,NULL, wafeStrings[14]));

     XmListDeselectPos(localVar1,localVar2);

     DBUG_RETURN (TCL_OK);
     }



#define WS_XmListGetMatchPos cmds[20].name
/* 
 * Boolean                          
 * XmListGetMatchPos
 * 	in: XmListWidget	# List Widget   
 * 	in: XmString		# item
 * 	out: list(int*,int)	# list of positions
 */

static int 
cmd_XmListGetMatchPos(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     XmString localVar2;
     int* localVar3list;
     int localVar3count;
     Boolean returnVar;
     char *ptr;

     DBUG_ENTER(argv[0]);  

     if (argc != 4) 
	 DBUG_RETURN(wafeArgcError(argc,argv,wafeStrings[2],3));

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmListWidgetClass)))
         DBUG_RETURN (wafeConvError(argc, argv, 1 ,NULL, wafeStrings[36]));

     if (!(localVar2 = (XmString) wafeCvtStringToXmString(argv[2])))
         DBUG_RETURN (wafeConvError(argc, argv, 2 ,NULL, XmRXmString));

     returnVar = XmListGetMatchPos(localVar1,localVar2,&localVar3list, &localVar3count);
     XmStringFree(localVar2);

     ptr = wafeCvtIntsToList(localVar3count,localVar3list);
     Tcl_SetVar(wafeInterpreter,argv[3],ptr,0);
     XtFree(ptr);

     Tcl_SetResult(comInterpreter, wafeStrings[returnVar?1:0], TCL_STATIC);

     DBUG_RETURN (TCL_OK);
     }



#define WS_XmListGetSelectedPos cmds[21].name
/* 
 * Boolean
 * XmListGetSelectedPos
 * 	in: XmListWidget	# List Widget
 * 	out: list(int*,int)     # list of highlighted items
 */

static int 
cmd_XmListGetSelectedPos(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     int* localVar2list;
     int localVar2count;
     Boolean returnVar;
     char *ptr;

     DBUG_ENTER(argv[0]);  

     if (argc != 3) 
	 DBUG_RETURN(wafeArgcError(argc,argv,wafeStrings[2],2));

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmListWidgetClass)))
         DBUG_RETURN (wafeConvError(argc, argv, 1 ,NULL, wafeStrings[36]));

     returnVar = XmListGetSelectedPos(localVar1,&localVar2list, &localVar2count);

     ptr = wafeCvtIntsToList(localVar2count,localVar2list);
     Tcl_SetVar(wafeInterpreter,argv[2],ptr,0);
     XtFree(ptr);

     Tcl_SetResult(comInterpreter, wafeStrings[returnVar?1:0], TCL_STATIC);

     DBUG_RETURN (TCL_OK);
     }



#define WS_XmListItemExists cmds[22].name
/* 
 * Boolean
 * XmListItemExists
 * 	in: XmListWidget	# List Widget
 * 	in: XmString		# Item
 */

static int 
cmd_XmListItemExists(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     XmString localVar2;
     Boolean returnVar;

     DBUG_ENTER(argv[0]);  

     if (argc != 3) 
	 DBUG_RETURN(wafeArgcError(argc,argv,wafeStrings[2],2));

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmListWidgetClass)))
         DBUG_RETURN (wafeConvError(argc, argv, 1 ,NULL, wafeStrings[36]));

     if (!(localVar2 = (XmString) wafeCvtStringToXmString(argv[2])))
         DBUG_RETURN (wafeConvError(argc, argv, 2 ,NULL, XmRXmString));

     returnVar = XmListItemExists(localVar1,localVar2);
     XmStringFree(localVar2);

     Tcl_SetResult(comInterpreter, wafeStrings[returnVar?1:0], TCL_STATIC);

     DBUG_RETURN (TCL_OK);
     }



#define WS_XmListItemPos cmds[23].name
/* 
 * int
 * XmListItemPos
 * 	in: XmListWidget	# List Widget
 * 	in: XmString		# Item
 */

static int 
cmd_XmListItemPos(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     XmString localVar2;
     int returnVar;
     char conversionBuffer[100];

     DBUG_ENTER(argv[0]);  

     if (argc != 3) 
	 DBUG_RETURN(wafeArgcError(argc,argv,wafeStrings[2],2));

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmListWidgetClass)))
         DBUG_RETURN (wafeConvError(argc, argv, 1 ,NULL, wafeStrings[36]));

     if (!(localVar2 = (XmString) wafeCvtStringToXmString(argv[2])))
         DBUG_RETURN (wafeConvError(argc, argv, 2 ,NULL, XmRXmString));

     returnVar = XmListItemPos(localVar1,localVar2);
     XmStringFree(localVar2);

     sprintf(conversionBuffer, wafeStrings[7], returnVar);
     Tcl_SetResult(comInterpreter, conversionBuffer, TCL_VOLATILE);

     DBUG_RETURN (TCL_OK);
     }



#define WS_XmListReplaceItems cmds[24].name
/* 
 * void
 * XmListReplaceItems
 * 	in: XmListWidget	# List Widget
 * 	in: XmStringTable	# Items to be replaced
 * 	in: int			# number of items to be replaced
 * 	in: XmStringTable	# new items
 */

static int 
cmd_XmListReplaceItems(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     XmStringTable localVar2;
     int localVar3;
     XmStringTable localVar4;

     DBUG_ENTER(argv[0]);  

     if (argc != 5) 
	 DBUG_RETURN(wafeArgcError(argc,argv,wafeStrings[2],4));

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmListWidgetClass)))
         DBUG_RETURN (wafeConvError(argc, argv, 1 ,NULL, wafeStrings[36]));

     if (!(localVar2 = (XmStringTable) wafeCvtStringToXmStringTable(argv[2])))
         DBUG_RETURN (wafeConvError(argc, argv, 2 ,NULL, XmRXmStringTable));

     if (!(sscanf(argv[3], wafeStrings[7], &localVar3)))
         DBUG_RETURN (wafeConvError(argc, argv, 3 ,NULL, wafeStrings[14]));

     if (!(localVar4 = (XmStringTable) wafeCvtStringToXmStringTable(argv[4])))
         DBUG_RETURN (wafeConvError(argc, argv, 4 ,NULL, XmRXmStringTable));

     XmListReplaceItems(localVar1,localVar2,localVar3,localVar4);
     freeXmStringTable(localVar2);
     freeXmStringTable(localVar4);

     DBUG_RETURN (TCL_OK);
     }



#define WS_XmListReplaceItemsPos cmds[25].name
/* 
 * void
 * XmListReplaceItemsPos
 * 	in: XmListWidget	# List Widget
 * 	in: XmStringTable	# New items
 * 	in: int			# number of items to be replaced
 * 	in: int 		# first Pos of items to be replaced
 */

static int 
cmd_XmListReplaceItemsPos(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     XmStringTable localVar2;
     int localVar3;
     int localVar4;

     DBUG_ENTER(argv[0]);  

     if (argc != 5) 
	 DBUG_RETURN(wafeArgcError(argc,argv,wafeStrings[2],4));

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmListWidgetClass)))
         DBUG_RETURN (wafeConvError(argc, argv, 1 ,NULL, wafeStrings[36]));

     if (!(localVar2 = (XmStringTable) wafeCvtStringToXmStringTable(argv[2])))
         DBUG_RETURN (wafeConvError(argc, argv, 2 ,NULL, XmRXmStringTable));

     if (!(sscanf(argv[3], wafeStrings[7], &localVar3)))
         DBUG_RETURN (wafeConvError(argc, argv, 3 ,NULL, wafeStrings[14]));

     if (!(sscanf(argv[4], wafeStrings[7], &localVar4)))
         DBUG_RETURN (wafeConvError(argc, argv, 4 ,NULL, wafeStrings[14]));

     XmListReplaceItemsPos(localVar1,localVar2,localVar3,localVar4);
     freeXmStringTable(localVar2);

     DBUG_RETURN (TCL_OK);
     }



#define WS_XmListSelectItem cmds[26].name
/* 
 * void
 * XmListSelectItem
 * 	in: XmListWidget	# List Widget
 * 	in: XmString		# item to highlight
 * 	in: Boolean		# Invoke callback yes/no
 */

static int 
cmd_XmListSelectItem(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     XmString localVar2;
     Boolean localVar3;

     DBUG_ENTER(argv[0]);  

     if (argc != 4) 
	 DBUG_RETURN(wafeArgcError(argc,argv,wafeStrings[2],3));

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmListWidgetClass)))
         DBUG_RETURN (wafeConvError(argc, argv, 1 ,NULL, wafeStrings[36]));

     if (!(localVar2 = (XmString) wafeCvtStringToXmString(argv[2])))
         DBUG_RETURN (wafeConvError(argc, argv, 2 ,NULL, XmRXmString));

     if (!(wafeGetBoolean(argv[3],&localVar3)))
         DBUG_RETURN (wafeConvError(argc, argv, 3 ,NULL, XtRBoolean));

     XmListSelectItem(localVar1,localVar2,localVar3);
     XmStringFree(localVar2);

     DBUG_RETURN (TCL_OK);
     }



#define WS_XmListSelectPos cmds[27].name
/* 
 * void
 * XmListSelectPos
 * 	in: XmListWidget	# List Widget
 * 	in: int			# Position of item 
 * 	in: Boolean		# Invoke callback yes/no
 */

static int 
cmd_XmListSelectPos(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     int localVar2;
     Boolean localVar3;

     DBUG_ENTER(argv[0]);  

     if (argc != 4) 
	 DBUG_RETURN(wafeArgcError(argc,argv,wafeStrings[2],3));

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmListWidgetClass)))
         DBUG_RETURN (wafeConvError(argc, argv, 1 ,NULL, wafeStrings[36]));

     if (!(sscanf(argv[2], wafeStrings[7], &localVar2)))
         DBUG_RETURN (wafeConvError(argc, argv, 2 ,NULL, wafeStrings[14]));

     if (!(wafeGetBoolean(argv[3],&localVar3)))
         DBUG_RETURN (wafeConvError(argc, argv, 3 ,NULL, XtRBoolean));

     XmListSelectPos(localVar1,localVar2,localVar3);

     DBUG_RETURN (TCL_OK);
     }



#define WS_XmListSetAddMode cmds[28].name
/* 
 * void
 * XmListSetAddMode
 * 	in: XmListWidget 	# List Widget
 * 	in: Boolean		# Use Add Mode yes/no
 */

static int 
cmd_XmListSetAddMode(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     Boolean localVar2;

     DBUG_ENTER(argv[0]);  

     if (argc != 3) 
	 DBUG_RETURN(wafeArgcError(argc,argv,wafeStrings[2],2));

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmListWidgetClass)))
         DBUG_RETURN (wafeConvError(argc, argv, 1 ,NULL, wafeStrings[36]));

     if (!(wafeGetBoolean(argv[2],&localVar2)))
         DBUG_RETURN (wafeConvError(argc, argv, 2 ,NULL, XtRBoolean));

     XmListSetAddMode(localVar1,localVar2);

     DBUG_RETURN (TCL_OK);
     }



#define WS_XmListSetBottomItem cmds[29].name
/* 
 * void
 * XmListSetBottomItem	
 * 	in: XmListWidget 	# List Widget
 * 	in: XmString		# item to be displayed as last item
 */

static int 
cmd_XmListSetBottomItem(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     XmString localVar2;

     DBUG_ENTER(argv[0]);  

     if (argc != 3) 
	 DBUG_RETURN(wafeArgcError(argc,argv,wafeStrings[2],2));

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmListWidgetClass)))
         DBUG_RETURN (wafeConvError(argc, argv, 1 ,NULL, wafeStrings[36]));

     if (!(localVar2 = (XmString) wafeCvtStringToXmString(argv[2])))
         DBUG_RETURN (wafeConvError(argc, argv, 2 ,NULL, XmRXmString));

     XmListSetBottomItem(localVar1,localVar2);
     XmStringFree(localVar2);

     DBUG_RETURN (TCL_OK);
     }



#define WS_XmListSetBottomPos cmds[30].name
/* 
 * void
 * XmListSetBottomPos
 * 	in: XmListWidget 	# List Widget
 * 	in: int			# item to be displayed as last item
 */

static int 
cmd_XmListSetBottomPos(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     int localVar2;

     DBUG_ENTER(argv[0]);  

     if (argc != 3) 
	 DBUG_RETURN(wafeArgcError(argc,argv,wafeStrings[2],2));

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmListWidgetClass)))
         DBUG_RETURN (wafeConvError(argc, argv, 1 ,NULL, wafeStrings[36]));

     if (!(sscanf(argv[2], wafeStrings[7], &localVar2)))
         DBUG_RETURN (wafeConvError(argc, argv, 2 ,NULL, wafeStrings[14]));

     XmListSetBottomPos(localVar1,localVar2);

     DBUG_RETURN (TCL_OK);
     }



#define WS_XmListSetHorizPos cmds[31].name
/* 
 * void
 * XmListSetHorizPos
 * 	in: XmListWidget 	# List Widget
 * 	in: int			# horizontal Position
 */

static int 
cmd_XmListSetHorizPos(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     int localVar2;

     DBUG_ENTER(argv[0]);  

     if (argc != 3) 
	 DBUG_RETURN(wafeArgcError(argc,argv,wafeStrings[2],2));

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmListWidgetClass)))
         DBUG_RETURN (wafeConvError(argc, argv, 1 ,NULL, wafeStrings[36]));

     if (!(sscanf(argv[2], wafeStrings[7], &localVar2)))
         DBUG_RETURN (wafeConvError(argc, argv, 2 ,NULL, wafeStrings[14]));

     XmListSetHorizPos(localVar1,localVar2);

     DBUG_RETURN (TCL_OK);
     }



#define WS_XmListSetItem cmds[32].name
/* 
 * void
 * XmListSetItem
 * 	in: XmListWidget 	# List Widget
 * 	in: XmString		# item
 */

static int 
cmd_XmListSetItem(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     XmString localVar2;

     DBUG_ENTER(argv[0]);  

     if (argc != 3) 
	 DBUG_RETURN(wafeArgcError(argc,argv,wafeStrings[2],2));

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmListWidgetClass)))
         DBUG_RETURN (wafeConvError(argc, argv, 1 ,NULL, wafeStrings[36]));

     if (!(localVar2 = (XmString) wafeCvtStringToXmString(argv[2])))
         DBUG_RETURN (wafeConvError(argc, argv, 2 ,NULL, XmRXmString));

     XmListSetItem(localVar1,localVar2);
     XmStringFree(localVar2);

     DBUG_RETURN (TCL_OK);
     }



#define WS_XmListSetPos cmds[33].name
/* 
 * void
 * XmListSetPos
 * 	in: XmListWidget 	# List Widget
 * 	in: int			# Position
 */

static int 
cmd_XmListSetPos(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     int localVar2;

     DBUG_ENTER(argv[0]);  

     if (argc != 3) 
	 DBUG_RETURN(wafeArgcError(argc,argv,wafeStrings[2],2));

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmListWidgetClass)))
         DBUG_RETURN (wafeConvError(argc, argv, 1 ,NULL, wafeStrings[36]));

     if (!(sscanf(argv[2], wafeStrings[7], &localVar2)))
         DBUG_RETURN (wafeConvError(argc, argv, 2 ,NULL, wafeStrings[14]));

     XmListSetPos(localVar1,localVar2);

     DBUG_RETURN (TCL_OK);
     }



#define WS_XmMainWindow wccs[20].name
#define WS_XmMainWindowSetAreas cmds[34].name
/* 
 * void
 * XmMainWindowSetAreas
 * 	in: NULL | Widget	# main window widget
 * 	in: NULL | Widget	# menu bar widget
 * 	in: NULL | Widget	# command window widget
 * 	in: NULL | Widget	# horizontal scrollbar widget
 * 	in: NULL | Widget	# vertical scrollbar widget
 * 	in: NULL | Widget	# work region widget
 */

static int 
cmd_XmMainWindowSetAreas(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     Widget localVar2;
     Widget localVar3;
     Widget localVar4;
     Widget localVar5;
     Widget localVar6;

     DBUG_ENTER(argv[0]);  

     if (argc != 7) 
	 DBUG_RETURN(wafeArgcError(argc,argv,wafeStrings[2],6));

     if (!strcmp(argv[1], wafeStrings[3])) 
         localVar1 = NULL;
     else
         if (!(localVar1 = (Widget) name2Widget(argv[1])))
         DBUG_RETURN (wafeConvError(argc, argv, 1 ,NULL, XtRWidget));

     if (!strcmp(argv[2], wafeStrings[3])) 
         localVar2 = NULL;
     else
         if (!(localVar2 = (Widget) name2Widget(argv[2])))
         DBUG_RETURN (wafeConvError(argc, argv, 2 ,NULL, XtRWidget));

     if (!strcmp(argv[3], wafeStrings[3])) 
         localVar3 = NULL;
     else
         if (!(localVar3 = (Widget) name2Widget(argv[3])))
         DBUG_RETURN (wafeConvError(argc, argv, 3 ,NULL, XtRWidget));

     if (!strcmp(argv[4], wafeStrings[3])) 
         localVar4 = NULL;
     else
         if (!(localVar4 = (Widget) name2Widget(argv[4])))
         DBUG_RETURN (wafeConvError(argc, argv, 4 ,NULL, XtRWidget));

     if (!strcmp(argv[5], wafeStrings[3])) 
         localVar5 = NULL;
     else
         if (!(localVar5 = (Widget) name2Widget(argv[5])))
         DBUG_RETURN (wafeConvError(argc, argv, 5 ,NULL, XtRWidget));

     if (!strcmp(argv[6], wafeStrings[3])) 
         localVar6 = NULL;
     else
         if (!(localVar6 = (Widget) name2Widget(argv[6])))
         DBUG_RETURN (wafeConvError(argc, argv, 6 ,NULL, XtRWidget));

     XmMainWindowSetAreas(localVar1,localVar2,localVar3,localVar4,localVar5,localVar6);

     DBUG_RETURN (TCL_OK);
     }



#define WS_XmMenuBar wccs[21].name
#define WS_XmMenuShell wccs[22].name
#define WS_XmMenuPosition cmds[35].name
/* 
 * void
 * XmMenuPosition
 * 	in: Widget		# menu widget
 * 	const: (XButtonPressedEvent *) wafeCurrentEvent
 */

static int 
cmd_XmMenuPosition(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;

     DBUG_ENTER(argv[0]);  

     if (argc != 2) 
	 DBUG_RETURN(wafeArgcError(argc,argv,wafeStrings[2],1));

     if (!(localVar1 = (Widget) name2Widget(argv[1])))
         DBUG_RETURN (wafeConvError(argc, argv, 1 ,NULL, XtRWidget));

     XmMenuPosition(localVar1,(XButtonPressedEvent *) wafeCurrentEvent);

     DBUG_RETURN (TCL_OK);
     }



#define WS_XmMessageBox wccs[23].name
#define WS_XmMessageBoxGetChild cmds[36].name
/* 
 * WidgetID (WidgetID)
 * XmMessageBoxGetChild
 * 	in: XmMessageBoxWidget		# message box widget
 * 	in: (unsigned char)XmChild 	# child reference
 */

static int 
cmd_XmMessageBoxGetChild(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     unsigned char localVar2;
     WidgetID returnVar;
     char conversionBuffer[100];

     DBUG_ENTER(argv[0]);  

     if (argc != 3) 
	 DBUG_RETURN(wafeArgcError(argc,argv,wafeStrings[2],2));

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmMessageBoxWidgetClass)))
         DBUG_RETURN (wafeConvError(argc, argv, 1 ,NULL, "XmMessageBoxWidget"));

     if (!strcmp(argv[2], wafeStrings[44])) 
         localVar2 = XmDIALOG_CANCEL_BUTTON;
     else
     if (!strcmp(argv[2], wafeStrings[46])) 
         localVar2 = XmDIALOG_DEFAULT_BUTTON;
     else
     if (!strcmp(argv[2], wafeStrings[51])) 
         localVar2 = XmDIALOG_HELP_BUTTON;
     else
     if (!strcmp(argv[2], wafeStrings[56])) 
         localVar2 = XmDIALOG_OK_BUTTON;
     else
     if (!strcmp(argv[2], wafeStrings[59])) 
         localVar2 = XmDIALOG_SEPARATOR;
     else
     if (!strcmp(argv[2], wafeStrings[60])) 
         localVar2 = XmDIALOG_SYMBOL_LABEL;
     else
     if (!strcmp(argv[2], wafeStrings[55])) 
         localVar2 = XmDIALOG_MESSAGE_LABEL;
     else
     if (!strcmp(argv[2], wafeStrings[43])) 
         localVar2 = XmDIALOG_APPLY_BUTTON;
     else
     if (!strcmp(argv[2], wafeStrings[47])) 
         localVar2 = XmDIALOG_DIR_LIST;
     else
     if (!strcmp(argv[2], wafeStrings[48])) 
         localVar2 = XmDIALOG_DIR_LIST_LABEL;
     else
     if (!strcmp(argv[2], wafeStrings[49])) 
         localVar2 = XmDIALOG_FILTER_LABEL;
     else
     if (!strcmp(argv[2], wafeStrings[50])) 
         localVar2 = XmDIALOG_FILTER_TEXT;
     else
     if (!strcmp(argv[2], wafeStrings[53])) 
         localVar2 = XmDIALOG_LIST;
     else
     if (!strcmp(argv[2], wafeStrings[54])) 
         localVar2 = XmDIALOG_LIST_LABEL;
     else
     if (!strcmp(argv[2], wafeStrings[58])) 
         localVar2 = XmDIALOG_SELECTION_LABEL;
     else
     if (!strcmp(argv[2], wafeStrings[61])) 
         localVar2 = XmDIALOG_TEXT;
     else
     if (!strcmp(argv[2], wafeStrings[62])) 
         localVar2 = XmDIALOG_WORK_AREA;
     else
     if (!strcmp(argv[2], wafeStrings[45])) 
         localVar2 = XmDIALOG_COMMAND_TEXT;
     else
     if (!strcmp(argv[2], wafeStrings[57])) 
         localVar2 = XmDIALOG_PROMPT_LABEL;
     else
     if (!strcmp(argv[2], wafeStrings[52])) 
         localVar2 = XmDIALOG_HISTORY_LIST;
     else
         DBUG_RETURN(wafeConvError(argc,argv, 2,NULL, wafeStrings[33]));


     returnVar = (WidgetID) XmMessageBoxGetChild(localVar1,localVar2);

     sprintf(conversionBuffer, wafeStrings[9], returnVar);
     Tcl_SetResult(comInterpreter, conversionBuffer, TCL_VOLATILE);

     DBUG_RETURN (TCL_OK);
     }



#define WS_XmMessageDialog wccs[24].name
#define WS_XmOptionMenu wccs[25].name
#define WS_XmPanedWindow wccs[26].name
#define WS_XmPopupMenu wccs[27].name
#define WS_XmProcessTraversal cmds[37].name
/* 
 * Boolean
 * XmProcessTraversal
 * 	in: Widget		# Widget for which to traverse hierarchy
 * 	in: (int) XmTravDir	# direction in which to traverse widget hierarchy
 */

static int 
cmd_XmProcessTraversal(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     int localVar2;
     Boolean returnVar;

     DBUG_ENTER(argv[0]);  

     if (argc != 3) 
	 DBUG_RETURN(wafeArgcError(argc,argv,wafeStrings[2],2));

     if (!(localVar1 = (Widget) name2Widget(argv[1])))
         DBUG_RETURN (wafeConvError(argc, argv, 1 ,NULL, XtRWidget));

     if (!strcmp(argv[2], "TRAVERSE_CURRENT")) 
         localVar2 = XmTRAVERSE_CURRENT;
     else
     if (!strcmp(argv[2], "TRAVERSE_NEXT")) 
         localVar2 = XmTRAVERSE_NEXT;
     else
     if (!strcmp(argv[2], "TRAVERSE_PREV")) 
         localVar2 = XmTRAVERSE_PREV;
     else
     if (!strcmp(argv[2], "TRAVERSE_HOME")) 
         localVar2 = XmTRAVERSE_HOME;
     else
     if (!strcmp(argv[2], "TRAVERSE_NEXT_TAB_GROUP")) 
         localVar2 = XmTRAVERSE_NEXT_TAB_GROUP;
     else
     if (!strcmp(argv[2], "TRAVERSE_PREV_TAB_GROUP")) 
         localVar2 = XmTRAVERSE_PREV_TAB_GROUP;
     else
     if (!strcmp(argv[2], "TRAVERSE_UP")) 
         localVar2 = XmTRAVERSE_UP;
     else
     if (!strcmp(argv[2], "TRAVERSE_DOWN")) 
         localVar2 = XmTRAVERSE_DOWN;
     else
     if (!strcmp(argv[2], "TRAVERSE_LEFT")) 
         localVar2 = XmTRAVERSE_LEFT;
     else
     if (!strcmp(argv[2], "TRAVERSE_RIGHT")) 
         localVar2 = XmTRAVERSE_RIGHT;
     else
         DBUG_RETURN(wafeConvError(argc,argv, 2,NULL, "XmTravDir"));


     returnVar = XmProcessTraversal(localVar1,localVar2);

     Tcl_SetResult(comInterpreter, wafeStrings[returnVar?1:0], TCL_STATIC);

     DBUG_RETURN (TCL_OK);
     }



#define WS_XmPromptDialog wccs[28].name
#define WS_XmPulldownMenu wccs[29].name
#define WS_XmPushButton wccs[30].name
#define WS_XmPushButtonGadget wccs[31].name
#define WS_XmQuestionDialog wccs[32].name
#define WS_XmRadioBox wccs[33].name
#define WS_XmRowColumn wccs[34].name
#define WS_XmScale wccs[35].name
#define WS_XmScrollBar wccs[36].name
#define WS_XmScrollBarGetValues cmds[38].name
/* 
 * void
 * XmScrollBarGetValues 
 * 	in: XmScrollBarWidget		# scrollbar widget
 * 	out: int	      		# value (slider position)
 *         out: int              		# slider size
 * 	out: int              		# increment (smallest movement)
 * 	out: int              		# page increment
 */

static int 
cmd_XmScrollBarGetValues(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     int localVar2;
     int localVar3;
     int localVar4;
     int localVar5;
     char conversionBuffer[100];

     DBUG_ENTER(argv[0]);  

     if (argc != 6) 
	 DBUG_RETURN(wafeArgcError(argc,argv,wafeStrings[2],5));

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmScrollBarWidgetClass)))
         DBUG_RETURN (wafeConvError(argc, argv, 1 ,NULL, wafeStrings[37]));

     XmScrollBarGetValues(localVar1,&localVar2,&localVar3,&localVar4,&localVar5);

     sprintf(conversionBuffer, wafeStrings[7], localVar2);

     Tcl_SetVar(wafeInterpreter,argv[2],conversionBuffer,0);

     sprintf(conversionBuffer, wafeStrings[7], localVar3);

     Tcl_SetVar(wafeInterpreter,argv[3],conversionBuffer,0);

     sprintf(conversionBuffer, wafeStrings[7], localVar4);

     Tcl_SetVar(wafeInterpreter,argv[4],conversionBuffer,0);

     sprintf(conversionBuffer, wafeStrings[7], localVar5);

     Tcl_SetVar(wafeInterpreter,argv[5],conversionBuffer,0);

     DBUG_RETURN (TCL_OK);
     }



#define WS_XmScrollBarSetValues cmds[39].name
/* 
 * void
 * XmScrollBarSetValues 
 * 	in: XmScrollBarWidget 		# scrollbar widget
 * 	in: int	              		# value (slider position)
 *         in: int               		# slider size
 * 	in: int               		# increment (smallest movement)
 * 	in: int               		# page increment 
 * 	in: Boolean           		# notify
 */

static int 
cmd_XmScrollBarSetValues(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     int localVar2;
     int localVar3;
     int localVar4;
     int localVar5;
     Boolean localVar6;

     DBUG_ENTER(argv[0]);  

     if (argc != 7) 
	 DBUG_RETURN(wafeArgcError(argc,argv,wafeStrings[2],6));

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmScrollBarWidgetClass)))
         DBUG_RETURN (wafeConvError(argc, argv, 1 ,NULL, wafeStrings[37]));

     if (!(sscanf(argv[2], wafeStrings[7], &localVar2)))
         DBUG_RETURN (wafeConvError(argc, argv, 2 ,NULL, wafeStrings[14]));

     if (!(sscanf(argv[3], wafeStrings[7], &localVar3)))
         DBUG_RETURN (wafeConvError(argc, argv, 3 ,NULL, wafeStrings[14]));

     if (!(sscanf(argv[4], wafeStrings[7], &localVar4)))
         DBUG_RETURN (wafeConvError(argc, argv, 4 ,NULL, wafeStrings[14]));

     if (!(sscanf(argv[5], wafeStrings[7], &localVar5)))
         DBUG_RETURN (wafeConvError(argc, argv, 5 ,NULL, wafeStrings[14]));

     if (!(wafeGetBoolean(argv[6],&localVar6)))
         DBUG_RETURN (wafeConvError(argc, argv, 6 ,NULL, XtRBoolean));

     XmScrollBarSetValues(localVar1,localVar2,localVar3,localVar4,localVar5,localVar6);

     DBUG_RETURN (TCL_OK);
     }



#define WS_XmScrolledList wccs[37].name
#define WS_XmScrolledText wccs[38].name
#define WS_XmScrolledWindow wccs[39].name
#define WS_XmSelectionBox wccs[40].name
#define WS_XmSelectionBoxGetChild cmds[40].name
/* 
 * WidgetID (WidgetID)
 * XmSelectionBoxGetChild
 * 	in: XmSelectionBoxWidget	# selection box widget
 * 	in: (unsigned char)XmChild 	# child reference
 */

static int 
cmd_XmSelectionBoxGetChild(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     unsigned char localVar2;
     WidgetID returnVar;
     char conversionBuffer[100];

     DBUG_ENTER(argv[0]);  

     if (argc != 3) 
	 DBUG_RETURN(wafeArgcError(argc,argv,wafeStrings[2],2));

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmSelectionBoxWidgetClass)))
         DBUG_RETURN (wafeConvError(argc, argv, 1 ,NULL, "XmSelectionBoxWidget"));

     if (!strcmp(argv[2], wafeStrings[44])) 
         localVar2 = XmDIALOG_CANCEL_BUTTON;
     else
     if (!strcmp(argv[2], wafeStrings[46])) 
         localVar2 = XmDIALOG_DEFAULT_BUTTON;
     else
     if (!strcmp(argv[2], wafeStrings[51])) 
         localVar2 = XmDIALOG_HELP_BUTTON;
     else
     if (!strcmp(argv[2], wafeStrings[56])) 
         localVar2 = XmDIALOG_OK_BUTTON;
     else
     if (!strcmp(argv[2], wafeStrings[59])) 
         localVar2 = XmDIALOG_SEPARATOR;
     else
     if (!strcmp(argv[2], wafeStrings[60])) 
         localVar2 = XmDIALOG_SYMBOL_LABEL;
     else
     if (!strcmp(argv[2], wafeStrings[55])) 
         localVar2 = XmDIALOG_MESSAGE_LABEL;
     else
     if (!strcmp(argv[2], wafeStrings[43])) 
         localVar2 = XmDIALOG_APPLY_BUTTON;
     else
     if (!strcmp(argv[2], wafeStrings[47])) 
         localVar2 = XmDIALOG_DIR_LIST;
     else
     if (!strcmp(argv[2], wafeStrings[48])) 
         localVar2 = XmDIALOG_DIR_LIST_LABEL;
     else
     if (!strcmp(argv[2], wafeStrings[49])) 
         localVar2 = XmDIALOG_FILTER_LABEL;
     else
     if (!strcmp(argv[2], wafeStrings[50])) 
         localVar2 = XmDIALOG_FILTER_TEXT;
     else
     if (!strcmp(argv[2], wafeStrings[53])) 
         localVar2 = XmDIALOG_LIST;
     else
     if (!strcmp(argv[2], wafeStrings[54])) 
         localVar2 = XmDIALOG_LIST_LABEL;
     else
     if (!strcmp(argv[2], wafeStrings[58])) 
         localVar2 = XmDIALOG_SELECTION_LABEL;
     else
     if (!strcmp(argv[2], wafeStrings[61])) 
         localVar2 = XmDIALOG_TEXT;
     else
     if (!strcmp(argv[2], wafeStrings[62])) 
         localVar2 = XmDIALOG_WORK_AREA;
     else
     if (!strcmp(argv[2], wafeStrings[45])) 
         localVar2 = XmDIALOG_COMMAND_TEXT;
     else
     if (!strcmp(argv[2], wafeStrings[57])) 
         localVar2 = XmDIALOG_PROMPT_LABEL;
     else
     if (!strcmp(argv[2], wafeStrings[52])) 
         localVar2 = XmDIALOG_HISTORY_LIST;
     else
         DBUG_RETURN(wafeConvError(argc,argv, 2,NULL, wafeStrings[33]));


     returnVar = (WidgetID) XmSelectionBoxGetChild(localVar1,localVar2);

     sprintf(conversionBuffer, wafeStrings[9], returnVar);
     Tcl_SetResult(comInterpreter, conversionBuffer, TCL_VOLATILE);

     DBUG_RETURN (TCL_OK);
     }



#define WS_XmSelectionDialog wccs[41].name
#define WS_XmSeparator wccs[42].name
#define WS_XmSeparatorGadget wccs[43].name
#define WS_XmSimpleCheckBox wccs[44].name
#define WS_XmSimpleMenuBar wccs[45].name
#define WS_XmSimpleOptionMenu wccs[46].name
#define WS_XmSimplePopupMenu wccs[47].name
#define WS_XmSimplePulldownMenu wccs[48].name
#define WS_XmSimpleRadioBox wccs[49].name
#define WS_XmText wccs[50].name
#define WS_XmTextClearSelection cmds[41].name
/* 
 * void
 * XmTextClearSelection
 * 	in: XmTextWidget 	# Text widget
 * 	const: time(NULL)
 */

static int 
cmd_XmTextClearSelection(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;

     DBUG_ENTER(argv[0]);  

     if (argc != 2) 
	 DBUG_RETURN(wafeArgcError(argc,argv,wafeStrings[2],1));

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmTextWidgetClass)))
         DBUG_RETURN (wafeConvError(argc, argv, 1 ,NULL, wafeStrings[40]));

     XmTextClearSelection(localVar1,time(NULL));

     DBUG_RETURN (TCL_OK);
     }



#define WS_XmTextCopy cmds[42].name
/* 
 * Boolean
 * XmTextCopy
 * 	in: XmTextWidget 	# Text widget
 * 	const: time(NULL)
 */

static int 
cmd_XmTextCopy(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     Boolean returnVar;

     DBUG_ENTER(argv[0]);  

     if (argc != 2) 
	 DBUG_RETURN(wafeArgcError(argc,argv,wafeStrings[2],1));

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmTextWidgetClass)))
         DBUG_RETURN (wafeConvError(argc, argv, 1 ,NULL, wafeStrings[40]));

     returnVar = XmTextCopy(localVar1,time(NULL));

     Tcl_SetResult(comInterpreter, wafeStrings[returnVar?1:0], TCL_STATIC);

     DBUG_RETURN (TCL_OK);
     }



#define WS_XmTextCut cmds[43].name
/* 
 * Boolean
 * XmTextCut
 * 	in: XmTextWidget 	# Text widget
 * 	const: time(NULL)
 */

static int 
cmd_XmTextCut(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     Boolean returnVar;

     DBUG_ENTER(argv[0]);  

     if (argc != 2) 
	 DBUG_RETURN(wafeArgcError(argc,argv,wafeStrings[2],1));

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmTextWidgetClass)))
         DBUG_RETURN (wafeConvError(argc, argv, 1 ,NULL, wafeStrings[40]));

     returnVar = XmTextCut(localVar1,time(NULL));

     Tcl_SetResult(comInterpreter, wafeStrings[returnVar?1:0], TCL_STATIC);

     DBUG_RETURN (TCL_OK);
     }



#define WS_XmTextField wccs[51].name
#define WS_XmTextFieldClearSelection cmds[44].name
/* 
 * void
 * XmTextFieldClearSelection
 * 	in: XmTextFieldWidget 	# Text field widget
 * 	const: time(NULL)
 */

static int 
cmd_XmTextFieldClearSelection(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;

     DBUG_ENTER(argv[0]);  

     if (argc != 2) 
	 DBUG_RETURN(wafeArgcError(argc,argv,wafeStrings[2],1));

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmTextFieldWidgetClass)))
         DBUG_RETURN (wafeConvError(argc, argv, 1 ,NULL, wafeStrings[38]));

     XmTextFieldClearSelection(localVar1,time(NULL));

     DBUG_RETURN (TCL_OK);
     }



#define WS_XmTextFieldCopy cmds[45].name
/* 
 * Boolean
 * XmTextFieldCopy
 * 	in: XmTextFieldWidget 		# Text field widget
 * 	const: time(NULL)
 */

static int 
cmd_XmTextFieldCopy(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     Boolean returnVar;

     DBUG_ENTER(argv[0]);  

     if (argc != 2) 
	 DBUG_RETURN(wafeArgcError(argc,argv,wafeStrings[2],1));

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmTextFieldWidgetClass)))
         DBUG_RETURN (wafeConvError(argc, argv, 1 ,NULL, wafeStrings[38]));

     returnVar = XmTextFieldCopy(localVar1,time(NULL));

     Tcl_SetResult(comInterpreter, wafeStrings[returnVar?1:0], TCL_STATIC);

     DBUG_RETURN (TCL_OK);
     }



#define WS_XmTextFieldCut cmds[46].name
/* 
 * Boolean
 * XmTextFieldCut
 * 	in: XmTextFieldWidget 		# Text field widget
 * 	const: time(NULL)
 */

static int 
cmd_XmTextFieldCut(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     Boolean returnVar;

     DBUG_ENTER(argv[0]);  

     if (argc != 2) 
	 DBUG_RETURN(wafeArgcError(argc,argv,wafeStrings[2],1));

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmTextFieldWidgetClass)))
         DBUG_RETURN (wafeConvError(argc, argv, 1 ,NULL, wafeStrings[38]));

     returnVar = XmTextFieldCut(localVar1,time(NULL));

     Tcl_SetResult(comInterpreter, wafeStrings[returnVar?1:0], TCL_STATIC);

     DBUG_RETURN (TCL_OK);
     }



#define WS_XmTextFieldGetBaseline cmds[47].name
/* 
 * int
 * XmTextFieldGetBaseline
 * 	in: XmTextFieldWidget 		# Text field widget
 */

static int 
cmd_XmTextFieldGetBaseline(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     int returnVar;
     char conversionBuffer[100];

     DBUG_ENTER(argv[0]);  

     if (argc != 2) 
	 DBUG_RETURN(wafeArgcError(argc,argv,wafeStrings[2],1));

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmTextFieldWidgetClass)))
         DBUG_RETURN (wafeConvError(argc, argv, 1 ,NULL, wafeStrings[38]));

     returnVar = XmTextFieldGetBaseline(localVar1);

     sprintf(conversionBuffer, wafeStrings[7], returnVar);
     Tcl_SetResult(comInterpreter, conversionBuffer, TCL_VOLATILE);

     DBUG_RETURN (TCL_OK);
     }



#define WS_XmTextFieldGetLastPosition cmds[48].name
/* 
 * XmTextPosition
 * XmTextFieldGetLastPosition
 * 	in: XmTextFieldWidget 		# Text field widget
 */

static int 
cmd_XmTextFieldGetLastPosition(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     XmTextPosition returnVar;
     char conversionBuffer[100];

     DBUG_ENTER(argv[0]);  

     if (argc != 2) 
	 DBUG_RETURN(wafeArgcError(argc,argv,wafeStrings[2],1));

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmTextFieldWidgetClass)))
         DBUG_RETURN (wafeConvError(argc, argv, 1 ,NULL, wafeStrings[38]));

     returnVar = XmTextFieldGetLastPosition(localVar1);

     sprintf(conversionBuffer, wafeStrings[9], returnVar);
     Tcl_SetResult(comInterpreter, conversionBuffer, TCL_VOLATILE);

     DBUG_RETURN (TCL_OK);
     }



#define WS_XmTextFieldGetSelection cmds[49].name
/* 
 * (String) DString
 * XmTextFieldGetSelection
 * 	in: XmTextFieldWidget 		# Text field widget
 */

static int 
cmd_XmTextFieldGetSelection(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     String returnVar;

     DBUG_ENTER(argv[0]);  

     if (argc != 2) 
	 DBUG_RETURN(wafeArgcError(argc,argv,wafeStrings[2],1));

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmTextFieldWidgetClass)))
         DBUG_RETURN (wafeConvError(argc, argv, 1 ,NULL, wafeStrings[38]));

     returnVar = XmTextFieldGetSelection(localVar1);

     Tcl_SetResult(comInterpreter, returnVar, XtFree);

     DBUG_RETURN (TCL_OK);
     }



#define WS_XmTextFieldGetSelectionPosition cmds[50].name
/* 
 * Boolean
 * XmTextFieldGetSelectionPosition
 * 	in: XmTextFieldWidget 	# Text field widget
 * 	out: XmTextPosition	# left boundary
 * 	out: XmTextPosition     # right boundary
 */

static int 
cmd_XmTextFieldGetSelectionPosition(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     XmTextPosition localVar2;
     XmTextPosition localVar3;
     Boolean returnVar;
     char conversionBuffer[100];

     DBUG_ENTER(argv[0]);  

     if (argc != 4) 
	 DBUG_RETURN(wafeArgcError(argc,argv,wafeStrings[2],3));

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmTextFieldWidgetClass)))
         DBUG_RETURN (wafeConvError(argc, argv, 1 ,NULL, wafeStrings[38]));

     returnVar = XmTextFieldGetSelectionPosition(localVar1,&localVar2,&localVar3);

     sprintf(conversionBuffer, wafeStrings[9], localVar2);

     Tcl_SetVar(wafeInterpreter,argv[2],conversionBuffer,0);

     sprintf(conversionBuffer, wafeStrings[9], localVar3);

     Tcl_SetVar(wafeInterpreter,argv[3],conversionBuffer,0);

     Tcl_SetResult(comInterpreter, wafeStrings[returnVar?1:0], TCL_STATIC);

     DBUG_RETURN (TCL_OK);
     }



#define WS_XmTextFieldGetString cmds[51].name
/* 
 * (String) DString
 * XmTextFieldGetString
 * 	in: XmTextFieldWidget	# Text field widget
 */

static int 
cmd_XmTextFieldGetString(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     String returnVar;

     DBUG_ENTER(argv[0]);  

     if (argc != 2) 
	 DBUG_RETURN(wafeArgcError(argc,argv,wafeStrings[2],1));

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmTextFieldWidgetClass)))
         DBUG_RETURN (wafeConvError(argc, argv, 1 ,NULL, wafeStrings[38]));

     returnVar = XmTextFieldGetString(localVar1);

     Tcl_SetResult(comInterpreter, returnVar, XtFree);

     DBUG_RETURN (TCL_OK);
     }



#define WS_XmTextFieldInsert cmds[52].name
/* 
 * void
 * XmTextFieldInsert
 * 	in: XmTextFieldWidget 	# Text field widget
 * 	in: XmTextPosition	# character position
 * 	in: String              # text string to be inserted
 */

static int 
cmd_XmTextFieldInsert(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     XmTextPosition localVar2;

     DBUG_ENTER(argv[0]);  

     if (argc != 4) 
	 DBUG_RETURN(wafeArgcError(argc,argv,wafeStrings[2],3));

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmTextFieldWidgetClass)))
         DBUG_RETURN (wafeConvError(argc, argv, 1 ,NULL, wafeStrings[38]));

     if (!(sscanf(argv[2], wafeStrings[9], &localVar2)))
         DBUG_RETURN (wafeConvError(argc, argv, 2 ,NULL, XmRTextPosition));

    /* no need to assign  << localVar3 = argv[3] >>  */ 

     XmTextFieldInsert(localVar1,localVar2,argv[3]);

     DBUG_RETURN (TCL_OK);
     }



#define WS_XmTextFieldPaste cmds[53].name
/* 
 * Boolean
 * XmTextFieldPaste
 * 	in: XmTextFieldWidget 	# Text field widget
 */

static int 
cmd_XmTextFieldPaste(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     Boolean returnVar;

     DBUG_ENTER(argv[0]);  

     if (argc != 2) 
	 DBUG_RETURN(wafeArgcError(argc,argv,wafeStrings[2],1));

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmTextFieldWidgetClass)))
         DBUG_RETURN (wafeConvError(argc, argv, 1 ,NULL, wafeStrings[38]));

     returnVar = XmTextFieldPaste(localVar1);

     Tcl_SetResult(comInterpreter, wafeStrings[returnVar?1:0], TCL_STATIC);

     DBUG_RETURN (TCL_OK);
     }



#define WS_XmTextFieldPosToXY cmds[54].name
/* 
 * Boolean
 * XmTextFieldPosToXY
 * 	in: XmTextFieldWidget 	# Text field widget
 * 	in: XmTextPosition	# character position
 * 	out: Position		# x coord relative to top left
 * 	out: Position		# y coord relative to top left
 */

static int 
cmd_XmTextFieldPosToXY(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     XmTextPosition localVar2;
     Position localVar3;
     Position localVar4;
     Boolean returnVar;
     char conversionBuffer[100];

     DBUG_ENTER(argv[0]);  

     if (argc != 5) 
	 DBUG_RETURN(wafeArgcError(argc,argv,wafeStrings[2],4));

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmTextFieldWidgetClass)))
         DBUG_RETURN (wafeConvError(argc, argv, 1 ,NULL, wafeStrings[38]));

     if (!(sscanf(argv[2], wafeStrings[9], &localVar2)))
         DBUG_RETURN (wafeConvError(argc, argv, 2 ,NULL, XmRTextPosition));

     returnVar = XmTextFieldPosToXY(localVar1,localVar2,&localVar3,&localVar4);

     sprintf(conversionBuffer, wafeStrings[8], localVar3);

     Tcl_SetVar(wafeInterpreter,argv[3],conversionBuffer,0);

     sprintf(conversionBuffer, wafeStrings[8], localVar4);

     Tcl_SetVar(wafeInterpreter,argv[4],conversionBuffer,0);

     Tcl_SetResult(comInterpreter, wafeStrings[returnVar?1:0], TCL_STATIC);

     DBUG_RETURN (TCL_OK);
     }



#define WS_XmTextFieldRemove cmds[55].name
/* 
 * Boolean
 * XmTextFieldRemove
 * 	in: XmTextFieldWidget 	# Text field widget
 */

static int 
cmd_XmTextFieldRemove(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     Boolean returnVar;

     DBUG_ENTER(argv[0]);  

     if (argc != 2) 
	 DBUG_RETURN(wafeArgcError(argc,argv,wafeStrings[2],1));

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmTextFieldWidgetClass)))
         DBUG_RETURN (wafeConvError(argc, argv, 1 ,NULL, wafeStrings[38]));

     returnVar = XmTextFieldRemove(localVar1);

     Tcl_SetResult(comInterpreter, wafeStrings[returnVar?1:0], TCL_STATIC);

     DBUG_RETURN (TCL_OK);
     }



#define WS_XmTextFieldReplace cmds[56].name
/* 
 * void
 * XmTextFieldReplace
 * 	in: XmTextFieldWidget 	# Text field widget
 * 	in: XmTextPosition	# from character position
 * 	in: XmTextPosition	# to character position
 * 	in: String 		# insert string
 */

static int 
cmd_XmTextFieldReplace(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     XmTextPosition localVar2;
     XmTextPosition localVar3;

     DBUG_ENTER(argv[0]);  

     if (argc != 5) 
	 DBUG_RETURN(wafeArgcError(argc,argv,wafeStrings[2],4));

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmTextFieldWidgetClass)))
         DBUG_RETURN (wafeConvError(argc, argv, 1 ,NULL, wafeStrings[38]));

     if (!(sscanf(argv[2], wafeStrings[9], &localVar2)))
         DBUG_RETURN (wafeConvError(argc, argv, 2 ,NULL, XmRTextPosition));

     if (!(sscanf(argv[3], wafeStrings[9], &localVar3)))
         DBUG_RETURN (wafeConvError(argc, argv, 3 ,NULL, XmRTextPosition));

    /* no need to assign  << localVar4 = argv[4] >>  */ 

     XmTextFieldReplace(localVar1,localVar2,localVar3,argv[4]);

     DBUG_RETURN (TCL_OK);
     }



#define WS_XmTextFieldSetAddMode cmds[57].name
/* 
 * void
 * XmTextFieldSetAddMode
 * 	in: XmTextFieldWidget 	# Text field widget
 * 	in: Boolean		# true | false
 */

static int 
cmd_XmTextFieldSetAddMode(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     Boolean localVar2;

     DBUG_ENTER(argv[0]);  

     if (argc != 3) 
	 DBUG_RETURN(wafeArgcError(argc,argv,wafeStrings[2],2));

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmTextFieldWidgetClass)))
         DBUG_RETURN (wafeConvError(argc, argv, 1 ,NULL, wafeStrings[38]));

     if (!(wafeGetBoolean(argv[2],&localVar2)))
         DBUG_RETURN (wafeConvError(argc, argv, 2 ,NULL, XtRBoolean));

     XmTextFieldSetAddMode(localVar1,localVar2);

     DBUG_RETURN (TCL_OK);
     }



#define WS_XmTextFieldSetHighlight cmds[58].name
/* 
 * void
 * XmTextFieldSetHighlight
 * 	in: XmTextFieldWidget 	# Text field widget
 * 	in: XmTextPosition	# from character position
 * 	in: XmTextPosition	# to character position
 * 	in: XmHighlightMode	# HIGHLIGHT_NORMAL | HIGHLIGHT_SELECTED | HIGHLIGHT_SECONDARY_SELECTED
 */

static int 
cmd_XmTextFieldSetHighlight(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     XmTextPosition localVar2;
     XmTextPosition localVar3;
     XmHighlightMode localVar4;

     DBUG_ENTER(argv[0]);  

     if (argc != 5) 
	 DBUG_RETURN(wafeArgcError(argc,argv,wafeStrings[2],4));

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmTextFieldWidgetClass)))
         DBUG_RETURN (wafeConvError(argc, argv, 1 ,NULL, wafeStrings[38]));

     if (!(sscanf(argv[2], wafeStrings[9], &localVar2)))
         DBUG_RETURN (wafeConvError(argc, argv, 2 ,NULL, XmRTextPosition));

     if (!(sscanf(argv[3], wafeStrings[9], &localVar3)))
         DBUG_RETURN (wafeConvError(argc, argv, 3 ,NULL, XmRTextPosition));

     if (!strcmp(argv[4], wafeStrings[64])) 
         localVar4 = XmHIGHLIGHT_NORMAL;
     else
     if (!strcmp(argv[4], wafeStrings[63])) 
         localVar4 = XmHIGHLIGHT_SELECTED;
     else
     if (!strcmp(argv[4], wafeStrings[65])) 
         localVar4 = XmHIGHLIGHT_SECONDARY_SELECTED;
     else
         DBUG_RETURN(wafeConvError(argc,argv, 4,NULL, wafeStrings[35]));


     XmTextFieldSetHighlight(localVar1,localVar2,localVar3,localVar4);

     DBUG_RETURN (TCL_OK);
     }



#define WS_XmTextFieldSetSelection cmds[59].name
/* 
 * void
 * XmTextFieldSetSelection
 * 	in: XmTextFieldWidget 	# Text field widget
 * 	in: XmTextPosition	# from character position
 * 	in: XmTextPosition	# to character position
 * 	const: time(NULL)
 */

static int 
cmd_XmTextFieldSetSelection(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     XmTextPosition localVar2;
     XmTextPosition localVar3;

     DBUG_ENTER(argv[0]);  

     if (argc != 4) 
	 DBUG_RETURN(wafeArgcError(argc,argv,wafeStrings[2],3));

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmTextFieldWidgetClass)))
         DBUG_RETURN (wafeConvError(argc, argv, 1 ,NULL, wafeStrings[38]));

     if (!(sscanf(argv[2], wafeStrings[9], &localVar2)))
         DBUG_RETURN (wafeConvError(argc, argv, 2 ,NULL, XmRTextPosition));

     if (!(sscanf(argv[3], wafeStrings[9], &localVar3)))
         DBUG_RETURN (wafeConvError(argc, argv, 3 ,NULL, XmRTextPosition));

     XmTextFieldSetSelection(localVar1,localVar2,localVar3,time(NULL));

     DBUG_RETURN (TCL_OK);
     }



#define WS_XmTextFieldShowPosition cmds[60].name
/* 
 * void
 * XmTextFieldShowPosition
 * 	in: XmTextFieldWidget 	# Text field widget
 * 	in: XmTextPosition	# character position to display
 */

static int 
cmd_XmTextFieldShowPosition(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     XmTextPosition localVar2;

     DBUG_ENTER(argv[0]);  

     if (argc != 3) 
	 DBUG_RETURN(wafeArgcError(argc,argv,wafeStrings[2],2));

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmTextFieldWidgetClass)))
         DBUG_RETURN (wafeConvError(argc, argv, 1 ,NULL, wafeStrings[38]));

     if (!(sscanf(argv[2], wafeStrings[9], &localVar2)))
         DBUG_RETURN (wafeConvError(argc, argv, 2 ,NULL, XmRTextPosition));

     XmTextFieldShowPosition(localVar1,localVar2);

     DBUG_RETURN (TCL_OK);
     }



#define WS_XmTextFieldXYToPos cmds[61].name
/* 
 * void
 * XmTextFieldXYToPos
 * 	in: XmTextFieldWidget 	# Text field widget
 * 	in: Position		# x coord relative to top left
 * 	in: Position		# y coord relative to top left
 */

static int 
cmd_XmTextFieldXYToPos(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     Position localVar2;
     Position localVar3;

     DBUG_ENTER(argv[0]);  

     if (argc != 4) 
	 DBUG_RETURN(wafeArgcError(argc,argv,wafeStrings[2],3));

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmTextFieldWidgetClass)))
         DBUG_RETURN (wafeConvError(argc, argv, 1 ,NULL, wafeStrings[38]));

     if (!(sscanf(argv[2], wafeStrings[8], &localVar2)))
         DBUG_RETURN (wafeConvError(argc, argv, 2 ,NULL, XtRPosition));

     if (!(sscanf(argv[3], wafeStrings[8], &localVar3)))
         DBUG_RETURN (wafeConvError(argc, argv, 3 ,NULL, XtRPosition));

     XmTextFieldXYToPos(localVar1,localVar2,localVar3);

     DBUG_RETURN (TCL_OK);
     }



#define WS_XmTextGetBaseline cmds[62].name
/* 
 * int
 * XmTextGetBaseline
 * 	in: XmTextWidget 	# Text widget
 */

static int 
cmd_XmTextGetBaseline(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     int returnVar;
     char conversionBuffer[100];

     DBUG_ENTER(argv[0]);  

     if (argc != 2) 
	 DBUG_RETURN(wafeArgcError(argc,argv,wafeStrings[2],1));

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmTextWidgetClass)))
         DBUG_RETURN (wafeConvError(argc, argv, 1 ,NULL, wafeStrings[40]));

     returnVar = XmTextGetBaseline(localVar1);

     sprintf(conversionBuffer, wafeStrings[7], returnVar);
     Tcl_SetResult(comInterpreter, conversionBuffer, TCL_VOLATILE);

     DBUG_RETURN (TCL_OK);
     }



#define WS_XmTextGetLastPosition cmds[63].name
/* 
 * XmTextPosition
 * XmTextGetLastPosition
 * 	in: XmTextWidget 	# Text widget
 */

static int 
cmd_XmTextGetLastPosition(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     XmTextPosition returnVar;
     char conversionBuffer[100];

     DBUG_ENTER(argv[0]);  

     if (argc != 2) 
	 DBUG_RETURN(wafeArgcError(argc,argv,wafeStrings[2],1));

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmTextWidgetClass)))
         DBUG_RETURN (wafeConvError(argc, argv, 1 ,NULL, wafeStrings[40]));

     returnVar = XmTextGetLastPosition(localVar1);

     sprintf(conversionBuffer, wafeStrings[9], returnVar);
     Tcl_SetResult(comInterpreter, conversionBuffer, TCL_VOLATILE);

     DBUG_RETURN (TCL_OK);
     }



#define WS_XmTextGetSelection cmds[64].name
/* 
 * (String) DString
 * XmTextGetSelection
 * 	in: XmTextWidget 	# Text widget
 */

static int 
cmd_XmTextGetSelection(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     String returnVar;

     DBUG_ENTER(argv[0]);  

     if (argc != 2) 
	 DBUG_RETURN(wafeArgcError(argc,argv,wafeStrings[2],1));

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmTextWidgetClass)))
         DBUG_RETURN (wafeConvError(argc, argv, 1 ,NULL, wafeStrings[40]));

     returnVar = XmTextGetSelection(localVar1);

     Tcl_SetResult(comInterpreter, returnVar, XtFree);

     DBUG_RETURN (TCL_OK);
     }



#define WS_XmTextGetSelectionPosition cmds[65].name
/* 
 * Boolean
 * XmTextGetSelectionPosition
 * 	in: XmTextWidget 	# Text widget
 * 	out: XmTextPosition	# left boundary
 * 	out: XmTextPosition     # right boundary
 */

static int 
cmd_XmTextGetSelectionPosition(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     XmTextPosition localVar2;
     XmTextPosition localVar3;
     Boolean returnVar;
     char conversionBuffer[100];

     DBUG_ENTER(argv[0]);  

     if (argc != 4) 
	 DBUG_RETURN(wafeArgcError(argc,argv,wafeStrings[2],3));

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmTextWidgetClass)))
         DBUG_RETURN (wafeConvError(argc, argv, 1 ,NULL, wafeStrings[40]));

     returnVar = XmTextGetSelectionPosition(localVar1,&localVar2,&localVar3);

     sprintf(conversionBuffer, wafeStrings[9], localVar2);

     Tcl_SetVar(wafeInterpreter,argv[2],conversionBuffer,0);

     sprintf(conversionBuffer, wafeStrings[9], localVar3);

     Tcl_SetVar(wafeInterpreter,argv[3],conversionBuffer,0);

     Tcl_SetResult(comInterpreter, wafeStrings[returnVar?1:0], TCL_STATIC);

     DBUG_RETURN (TCL_OK);
     }



#define WS_XmTextGetString cmds[66].name
/* 
 * (String) DString
 * XmTextGetString
 * 	in: XmTextWidget	# Text widget
 */

static int 
cmd_XmTextGetString(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     String returnVar;

     DBUG_ENTER(argv[0]);  

     if (argc != 2) 
	 DBUG_RETURN(wafeArgcError(argc,argv,wafeStrings[2],1));

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmTextWidgetClass)))
         DBUG_RETURN (wafeConvError(argc, argv, 1 ,NULL, wafeStrings[40]));

     returnVar = XmTextGetString(localVar1);

     Tcl_SetResult(comInterpreter, returnVar, XtFree);

     DBUG_RETURN (TCL_OK);
     }



#define WS_XmTextInsert cmds[67].name
/* 
 * void
 * XmTextInsert
 * 	in: XmTextWidget 	# Text widget
 * 	in: XmTextPosition	# character position
 * 	in: String              # text string to be inserted
 */

static int 
cmd_XmTextInsert(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     XmTextPosition localVar2;

     DBUG_ENTER(argv[0]);  

     if (argc != 4) 
	 DBUG_RETURN(wafeArgcError(argc,argv,wafeStrings[2],3));

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmTextWidgetClass)))
         DBUG_RETURN (wafeConvError(argc, argv, 1 ,NULL, wafeStrings[40]));

     if (!(sscanf(argv[2], wafeStrings[9], &localVar2)))
         DBUG_RETURN (wafeConvError(argc, argv, 2 ,NULL, XmRTextPosition));

    /* no need to assign  << localVar3 = argv[3] >>  */ 

     XmTextInsert(localVar1,localVar2,argv[3]);

     DBUG_RETURN (TCL_OK);
     }



#define WS_XmTextPaste cmds[68].name
/* 
 * Boolean
 * XmTextPaste
 * 	in: XmTextWidget 	# Text widget
 */

static int 
cmd_XmTextPaste(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     Boolean returnVar;

     DBUG_ENTER(argv[0]);  

     if (argc != 2) 
	 DBUG_RETURN(wafeArgcError(argc,argv,wafeStrings[2],1));

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmTextWidgetClass)))
         DBUG_RETURN (wafeConvError(argc, argv, 1 ,NULL, wafeStrings[40]));

     returnVar = XmTextPaste(localVar1);

     Tcl_SetResult(comInterpreter, wafeStrings[returnVar?1:0], TCL_STATIC);

     DBUG_RETURN (TCL_OK);
     }



#define WS_XmTextPosToXY cmds[69].name
/* 
 * Boolean
 * XmTextPosToXY
 * 	in: XmTextWidget 	# Text widget
 * 	in: XmTextPosition	# character position
 * 	out: Position		# x coord relative to top left
 * 	out: Position		# y coord relative to top left
 */

static int 
cmd_XmTextPosToXY(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     XmTextPosition localVar2;
     Position localVar3;
     Position localVar4;
     Boolean returnVar;
     char conversionBuffer[100];

     DBUG_ENTER(argv[0]);  

     if (argc != 5) 
	 DBUG_RETURN(wafeArgcError(argc,argv,wafeStrings[2],4));

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmTextWidgetClass)))
         DBUG_RETURN (wafeConvError(argc, argv, 1 ,NULL, wafeStrings[40]));

     if (!(sscanf(argv[2], wafeStrings[9], &localVar2)))
         DBUG_RETURN (wafeConvError(argc, argv, 2 ,NULL, XmRTextPosition));

     returnVar = XmTextPosToXY(localVar1,localVar2,&localVar3,&localVar4);

     sprintf(conversionBuffer, wafeStrings[8], localVar3);

     Tcl_SetVar(wafeInterpreter,argv[3],conversionBuffer,0);

     sprintf(conversionBuffer, wafeStrings[8], localVar4);

     Tcl_SetVar(wafeInterpreter,argv[4],conversionBuffer,0);

     Tcl_SetResult(comInterpreter, wafeStrings[returnVar?1:0], TCL_STATIC);

     DBUG_RETURN (TCL_OK);
     }



#define WS_XmTextRemove cmds[70].name
/* 
 * Boolean
 * XmTextRemove
 * 	in: XmTextWidget 	# Text widget
 */

static int 
cmd_XmTextRemove(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     Boolean returnVar;

     DBUG_ENTER(argv[0]);  

     if (argc != 2) 
	 DBUG_RETURN(wafeArgcError(argc,argv,wafeStrings[2],1));

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmTextWidgetClass)))
         DBUG_RETURN (wafeConvError(argc, argv, 1 ,NULL, wafeStrings[40]));

     returnVar = XmTextRemove(localVar1);

     Tcl_SetResult(comInterpreter, wafeStrings[returnVar?1:0], TCL_STATIC);

     DBUG_RETURN (TCL_OK);
     }



#define WS_XmTextReplace cmds[71].name
/* 
 * void
 * XmTextReplace
 * 	in: XmTextWidget 	# Text widget
 * 	in: XmTextPosition	# from character position
 * 	in: XmTextPosition	# to character position
 * 	in: String 		# insert string
 */

static int 
cmd_XmTextReplace(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     XmTextPosition localVar2;
     XmTextPosition localVar3;

     DBUG_ENTER(argv[0]);  

     if (argc != 5) 
	 DBUG_RETURN(wafeArgcError(argc,argv,wafeStrings[2],4));

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmTextWidgetClass)))
         DBUG_RETURN (wafeConvError(argc, argv, 1 ,NULL, wafeStrings[40]));

     if (!(sscanf(argv[2], wafeStrings[9], &localVar2)))
         DBUG_RETURN (wafeConvError(argc, argv, 2 ,NULL, XmRTextPosition));

     if (!(sscanf(argv[3], wafeStrings[9], &localVar3)))
         DBUG_RETURN (wafeConvError(argc, argv, 3 ,NULL, XmRTextPosition));

    /* no need to assign  << localVar4 = argv[4] >>  */ 

     XmTextReplace(localVar1,localVar2,localVar3,argv[4]);

     DBUG_RETURN (TCL_OK);
     }



#define WS_XmTextScroll cmds[72].name
/* 
 * void
 * XmTextScroll
 * 	in: XmTextWidget 	# Text widget
 * 	in: int			# number of lines to scroll
 */

static int 
cmd_XmTextScroll(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     int localVar2;

     DBUG_ENTER(argv[0]);  

     if (argc != 3) 
	 DBUG_RETURN(wafeArgcError(argc,argv,wafeStrings[2],2));

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmTextWidgetClass)))
         DBUG_RETURN (wafeConvError(argc, argv, 1 ,NULL, wafeStrings[40]));

     if (!(sscanf(argv[2], wafeStrings[7], &localVar2)))
         DBUG_RETURN (wafeConvError(argc, argv, 2 ,NULL, wafeStrings[14]));

     XmTextScroll(localVar1,localVar2);

     DBUG_RETURN (TCL_OK);
     }



#define WS_XmTextSetAddMode cmds[73].name
/* 
 * void
 * XmTextSetAddMode
 * 	in: XmTextWidget 	# Text widget
 * 	in: Boolean		# true | false
 */

static int 
cmd_XmTextSetAddMode(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     Boolean localVar2;

     DBUG_ENTER(argv[0]);  

     if (argc != 3) 
	 DBUG_RETURN(wafeArgcError(argc,argv,wafeStrings[2],2));

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmTextWidgetClass)))
         DBUG_RETURN (wafeConvError(argc, argv, 1 ,NULL, wafeStrings[40]));

     if (!(wafeGetBoolean(argv[2],&localVar2)))
         DBUG_RETURN (wafeConvError(argc, argv, 2 ,NULL, XtRBoolean));

     XmTextSetAddMode(localVar1,localVar2);

     DBUG_RETURN (TCL_OK);
     }



#define WS_XmTextSetHighlight cmds[74].name
/* 
 * void
 * XmTextSetHighlight
 * 	in: XmTextWidget 	# Text widget
 * 	in: XmTextPosition	# from character position
 * 	in: XmTextPosition	# to character position
 * 	in: XmHighlightMode	# HIGHLIGHT_NORMAL | HIGHLIGHT_SELECTED | HIGHLIGHT_SECONDARY_SELECTED
 */

static int 
cmd_XmTextSetHighlight(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     XmTextPosition localVar2;
     XmTextPosition localVar3;
     XmHighlightMode localVar4;

     DBUG_ENTER(argv[0]);  

     if (argc != 5) 
	 DBUG_RETURN(wafeArgcError(argc,argv,wafeStrings[2],4));

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmTextWidgetClass)))
         DBUG_RETURN (wafeConvError(argc, argv, 1 ,NULL, wafeStrings[40]));

     if (!(sscanf(argv[2], wafeStrings[9], &localVar2)))
         DBUG_RETURN (wafeConvError(argc, argv, 2 ,NULL, XmRTextPosition));

     if (!(sscanf(argv[3], wafeStrings[9], &localVar3)))
         DBUG_RETURN (wafeConvError(argc, argv, 3 ,NULL, XmRTextPosition));

     if (!strcmp(argv[4], wafeStrings[64])) 
         localVar4 = XmHIGHLIGHT_NORMAL;
     else
     if (!strcmp(argv[4], wafeStrings[63])) 
         localVar4 = XmHIGHLIGHT_SELECTED;
     else
     if (!strcmp(argv[4], wafeStrings[65])) 
         localVar4 = XmHIGHLIGHT_SECONDARY_SELECTED;
     else
         DBUG_RETURN(wafeConvError(argc,argv, 4,NULL, wafeStrings[35]));


     XmTextSetHighlight(localVar1,localVar2,localVar3,localVar4);

     DBUG_RETURN (TCL_OK);
     }



#define WS_XmTextSetSelection cmds[75].name
/* 
 * void
 * XmTextSetSelection
 * 	in: XmTextWidget 	# Text widget
 * 	in: XmTextPosition	# from character position
 * 	in: XmTextPosition	# to character position
 * 	const: time(NULL)
 */

static int 
cmd_XmTextSetSelection(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     XmTextPosition localVar2;
     XmTextPosition localVar3;

     DBUG_ENTER(argv[0]);  

     if (argc != 4) 
	 DBUG_RETURN(wafeArgcError(argc,argv,wafeStrings[2],3));

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmTextWidgetClass)))
         DBUG_RETURN (wafeConvError(argc, argv, 1 ,NULL, wafeStrings[40]));

     if (!(sscanf(argv[2], wafeStrings[9], &localVar2)))
         DBUG_RETURN (wafeConvError(argc, argv, 2 ,NULL, XmRTextPosition));

     if (!(sscanf(argv[3], wafeStrings[9], &localVar3)))
         DBUG_RETURN (wafeConvError(argc, argv, 3 ,NULL, XmRTextPosition));

     XmTextSetSelection(localVar1,localVar2,localVar3,time(NULL));

     DBUG_RETURN (TCL_OK);
     }



#define WS_XmTextShowPosition cmds[76].name
/* 
 * void
 * XmTextShowPosition
 * 	in: XmTextWidget 	# Text widget
 * 	in: XmTextPosition	# character position to display
 */

static int 
cmd_XmTextShowPosition(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     XmTextPosition localVar2;

     DBUG_ENTER(argv[0]);  

     if (argc != 3) 
	 DBUG_RETURN(wafeArgcError(argc,argv,wafeStrings[2],2));

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmTextWidgetClass)))
         DBUG_RETURN (wafeConvError(argc, argv, 1 ,NULL, wafeStrings[40]));

     if (!(sscanf(argv[2], wafeStrings[9], &localVar2)))
         DBUG_RETURN (wafeConvError(argc, argv, 2 ,NULL, XmRTextPosition));

     XmTextShowPosition(localVar1,localVar2);

     DBUG_RETURN (TCL_OK);
     }



#define WS_XmTextXYToPos cmds[77].name
/* 
 * void
 * XmTextXYToPos
 * 	in: XmTextWidget 	# Text widget
 * 	in: Position		# x coord relative to top left
 * 	in: Position		# y coord relative to top left
 */

static int 
cmd_XmTextXYToPos(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     Position localVar2;
     Position localVar3;

     DBUG_ENTER(argv[0]);  

     if (argc != 4) 
	 DBUG_RETURN(wafeArgcError(argc,argv,wafeStrings[2],3));

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmTextWidgetClass)))
         DBUG_RETURN (wafeConvError(argc, argv, 1 ,NULL, wafeStrings[40]));

     if (!(sscanf(argv[2], wafeStrings[8], &localVar2)))
         DBUG_RETURN (wafeConvError(argc, argv, 2 ,NULL, XtRPosition));

     if (!(sscanf(argv[3], wafeStrings[8], &localVar3)))
         DBUG_RETURN (wafeConvError(argc, argv, 3 ,NULL, XtRPosition));

     XmTextXYToPos(localVar1,localVar2,localVar3);

     DBUG_RETURN (TCL_OK);
     }



#define WS_XmToggleButton wccs[52].name
#define WS_XmToggleButtonGetState cmds[78].name
/* 
 * Boolean
 * XmToggleButtonGetState
 * 	in: XmToggleButtonWidget	# toggle button widget
 */

static int 
cmd_XmToggleButtonGetState(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     Boolean returnVar;

     DBUG_ENTER(argv[0]);  

     if (argc != 2) 
	 DBUG_RETURN(wafeArgcError(argc,argv,wafeStrings[2],1));

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmToggleButtonWidgetClass)))
         DBUG_RETURN (wafeConvError(argc, argv, 1 ,NULL, wafeStrings[42]));

     returnVar = XmToggleButtonGetState(localVar1);

     Tcl_SetResult(comInterpreter, wafeStrings[returnVar?1:0], TCL_STATIC);

     DBUG_RETURN (TCL_OK);
     }



#define WS_XmToggleButtonSetState cmds[79].name
/* 
 * void
 * XmToggleButtonSetState
 * 	in: XmToggleButtonWidget	# toggle button widget
 * 	in: Boolean			# state (bool)
 * 	in: Boolean             	# notify (bool)
 */

static int 
cmd_XmToggleButtonSetState(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     Boolean localVar2;
     Boolean localVar3;

     DBUG_ENTER(argv[0]);  

     if (argc != 4) 
	 DBUG_RETURN(wafeArgcError(argc,argv,wafeStrings[2],3));

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmToggleButtonWidgetClass)))
         DBUG_RETURN (wafeConvError(argc, argv, 1 ,NULL, wafeStrings[42]));

     if (!(wafeGetBoolean(argv[2],&localVar2)))
         DBUG_RETURN (wafeConvError(argc, argv, 2 ,NULL, XtRBoolean));

     if (!(wafeGetBoolean(argv[3],&localVar3)))
         DBUG_RETURN (wafeConvError(argc, argv, 3 ,NULL, XtRBoolean));

     XmToggleButtonSetState(localVar1,localVar2,localVar3);

     DBUG_RETURN (TCL_OK);
     }



#define WS_XmToggleButtonGadget wccs[53].name
#define WS_XmToggleButtonGadgetGetState cmds[80].name
/* 
 * Boolean
 * XmToggleButtonGadgetGetState
 * 	in: XmToggleButtonGadget	# toggle button gadget
 */

static int 
cmd_XmToggleButtonGadgetGetState(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     Boolean returnVar;

     DBUG_ENTER(argv[0]);  

     if (argc != 2) 
	 DBUG_RETURN(wafeArgcError(argc,argv,wafeStrings[2],1));

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmToggleButtonGadgetClass)))
         DBUG_RETURN (wafeConvError(argc, argv, 1 ,NULL, WS_XmToggleButtonGadget));

     returnVar = XmToggleButtonGadgetGetState(localVar1);

     Tcl_SetResult(comInterpreter, wafeStrings[returnVar?1:0], TCL_STATIC);

     DBUG_RETURN (TCL_OK);
     }



#define WS_XmToggleButtonGadgetSetState cmds[81].name
/* 
 * void
 * XmToggleButtonGadgetSetState
 * 	in: XmToggleButtonGadget	# toggle button gadget
 * 	in: Boolean			# state (bool)
 * 	in: Boolean             	# notify (bool)
 */

static int 
cmd_XmToggleButtonGadgetSetState(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     Boolean localVar2;
     Boolean localVar3;

     DBUG_ENTER(argv[0]);  

     if (argc != 4) 
	 DBUG_RETURN(wafeArgcError(argc,argv,wafeStrings[2],3));

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmToggleButtonGadgetClass)))
         DBUG_RETURN (wafeConvError(argc, argv, 1 ,NULL, WS_XmToggleButtonGadget));

     if (!(wafeGetBoolean(argv[2],&localVar2)))
         DBUG_RETURN (wafeConvError(argc, argv, 2 ,NULL, XtRBoolean));

     if (!(wafeGetBoolean(argv[3],&localVar3)))
         DBUG_RETURN (wafeConvError(argc, argv, 3 ,NULL, XtRBoolean));

     XmToggleButtonGadgetSetState(localVar1,localVar2,localVar3);

     DBUG_RETURN (TCL_OK);
     }



#define WS_XmUpdateDisplay cmds[82].name
/* 
 * void
 * XmUpdateDisplay
 * 	in: Widget			# widget to determine display
 */

static int 
cmd_XmUpdateDisplay(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;

     DBUG_ENTER(argv[0]);  

     if (argc != 2) 
	 DBUG_RETURN(wafeArgcError(argc,argv,wafeStrings[2],1));

     if (!(localVar1 = (Widget) name2Widget(argv[1])))
         DBUG_RETURN (wafeConvError(argc, argv, 1 ,NULL, XtRWidget));

     XmUpdateDisplay(localVar1);

     DBUG_RETURN (TCL_OK);
     }



#define WS_XmWarningDialog wccs[54].name
#define WS_XmWorkingDialog wccs[55].name
#include <Xm/Protocols.h>

#define name2AtomNdsp(s) wafeStringToAtom(localVar1,s)

#define WS_XmAddProtocol cmds[83].name
/* 
 * void
 * wafeAddProtocol vulgo XmAddProtocol
 * 	in: Widget			# widget associated with protocol
 * 	in: name2AtomNdsp(String)	# property atom 
 * 	in: name2AtomNdsp(String)	# protocol atom
 */

static int 
cmd_XmAddProtocol(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;

     DBUG_ENTER(argv[0]);  

     if (argc != 4) 
	 DBUG_RETURN(wafeArgcError(argc,argv,wafeStrings[2],3));

     if (!(localVar1 = (Widget) name2Widget(argv[1])))
         DBUG_RETURN (wafeConvError(argc, argv, 1 ,NULL, XtRWidget));

    /* no need to assign  << localVar2 = argv[2] >>  */ 

    /* no need to assign  << localVar3 = argv[3] >>  */ 

     wafeAddProtocol(localVar1,name2AtomNdsp(argv[2]),name2AtomNdsp(argv[3]));

     DBUG_RETURN (TCL_OK);
     }



#define WS_XmAddProtocolCallback cmds[84].name
/* 
 * void
 * wafeAddProtocolCallback vulgo XmAddProtocolCallback
 * 	in: Widget			# widget associated with protocol
 * 	in: name2AtomNdsp(String)	# property atom 
 * 	in: name2AtomNdsp(String)	# protocol atom 
 * 	in: String			# command to be executed
 */

static int 
cmd_XmAddProtocolCallback(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;

     DBUG_ENTER(argv[0]);  

     if (argc != 5) 
	 DBUG_RETURN(wafeArgcError(argc,argv,wafeStrings[2],4));

     if (!(localVar1 = (Widget) name2Widget(argv[1])))
         DBUG_RETURN (wafeConvError(argc, argv, 1 ,NULL, XtRWidget));

    /* no need to assign  << localVar2 = argv[2] >>  */ 

    /* no need to assign  << localVar3 = argv[3] >>  */ 

    /* no need to assign  << localVar4 = argv[4] >>  */ 

     wafeAddProtocolCallback(localVar1,name2AtomNdsp(argv[2]),name2AtomNdsp(argv[3]),argv[4]);

     DBUG_RETURN (TCL_OK);
     }



#define WS_XmActivateProtocol cmds[85].name
/* 
 * void
 * XmActivateProtocol
 * 	in: Widget			# widget associated with protocol
 * 	in: name2AtomNdsp(String)	# property atom 
 * 	in: name2AtomNdsp(String)	# protocol atom
 */

static int 
cmd_XmActivateProtocol(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;

     DBUG_ENTER(argv[0]);  

     if (argc != 4) 
	 DBUG_RETURN(wafeArgcError(argc,argv,wafeStrings[2],3));

     if (!(localVar1 = (Widget) name2Widget(argv[1])))
         DBUG_RETURN (wafeConvError(argc, argv, 1 ,NULL, XtRWidget));

    /* no need to assign  << localVar2 = argv[2] >>  */ 

    /* no need to assign  << localVar3 = argv[3] >>  */ 

     XmActivateProtocol(localVar1,name2AtomNdsp(argv[2]),name2AtomNdsp(argv[3]));

     DBUG_RETURN (TCL_OK);
     }



#define WS_XmDeactivateProtocol cmds[86].name
/* 
 * void
 * XmDeactivateProtocol
 * 	in: Widget			# widget associated with protocol
 * 	in: name2AtomNdsp(String)	# property atom 
 * 	in: name2AtomNdsp(String)	# protocol atom
 */

static int 
cmd_XmDeactivateProtocol(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;

     DBUG_ENTER(argv[0]);  

     if (argc != 4) 
	 DBUG_RETURN(wafeArgcError(argc,argv,wafeStrings[2],3));

     if (!(localVar1 = (Widget) name2Widget(argv[1])))
         DBUG_RETURN (wafeConvError(argc, argv, 1 ,NULL, XtRWidget));

    /* no need to assign  << localVar2 = argv[2] >>  */ 

    /* no need to assign  << localVar3 = argv[3] >>  */ 

     XmDeactivateProtocol(localVar1,name2AtomNdsp(argv[2]),name2AtomNdsp(argv[3]));

     DBUG_RETURN (TCL_OK);
     }



#define wafeTextSetSelectionArray(w,argc,array) XtVaSetValues(w, XmNselectionArray,array,XmNselectionArrayCount, argc)

#define WS_XmTextSetSelectionArray cmds[87].name
/* 
 * void
 * wafeTextSetSelectionArray vulgo XmTextSetSelectionArray
 * 	in: XmTextWidget		# motif text widget
 *         const: argc-2
 * 	in: [XmTextScanType]		# selection array
 */

static int 
cmd_XmTextSetSelectionArray(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     XmTextScanType * localVar2;

     DBUG_ENTER(argv[0]);  

     if (argc < 3) 
	 DBUG_RETURN(wafeArgcError(argc,argv,wafeStrings[31],2));

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmTextWidgetClass)))
         DBUG_RETURN (wafeConvError(argc, argv, 1 ,NULL, wafeStrings[40]));

     {    XmTextScanType *ptr;
          argv += 2;
          localVar2 = ptr =
             (XmTextScanType *)XtMalloc((argc-2)*sizeof(XmTextScanType));

          while (*argv)
             {
             if (!strcmp(*argv, wafeStrings[66])) 
                 *ptr = XmSELECT_POSITION;
             else
             if (!strcmp(*argv, wafeStrings[67])) 
                 *ptr = XmSELECT_WHITESPACE;
             else
             if (!strcmp(*argv, wafeStrings[68])) 
                 *ptr = XmSELECT_WORD;
             else
             if (!strcmp(*argv, wafeStrings[69])) 
                 *ptr = XmSELECT_LINE;
             else
             if (!strcmp(*argv, wafeStrings[70])) 
                 *ptr = XmSELECT_ALL;
             else
             if (!strcmp(*argv, wafeStrings[71])) 
                 *ptr = XmSELECT_PARAGRAPH;
             else
                 DBUG_RETURN(wafeConvError(argc,argv, 2,NULL, wafeStrings[39]));


          ptr ++; argv++;
          }
     }
     wafeTextSetSelectionArray(localVar1,argc-2,localVar2);
     wafeMMreplace(localVar1,NULL,WafePermStringToQuark("XmTextSetSelectionArray"),(char*)localVar2,XtFree);

     DBUG_RETURN (TCL_OK);
     }



#define WS_XmTextFieldSetSelectionArray cmds[88].name
/* 
 * void
 * wafeTextSetSelectionArray vulgo XmTextFieldSetSelectionArray
 * 	in: XmTextFieldWidget		# motif text field widget
 *         const: argc-2
 * 	in: [XmTextScanType]		# selection array
 */

static int 
cmd_XmTextFieldSetSelectionArray(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     XmTextScanType * localVar2;

     DBUG_ENTER(argv[0]);  

     if (argc < 3) 
	 DBUG_RETURN(wafeArgcError(argc,argv,wafeStrings[31],2));

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmTextFieldWidgetClass)))
         DBUG_RETURN (wafeConvError(argc, argv, 1 ,NULL, wafeStrings[38]));

     {    XmTextScanType *ptr;
          argv += 2;
          localVar2 = ptr =
             (XmTextScanType *)XtMalloc((argc-2)*sizeof(XmTextScanType));

          while (*argv)
             {
             if (!strcmp(*argv, wafeStrings[66])) 
                 *ptr = XmSELECT_POSITION;
             else
             if (!strcmp(*argv, wafeStrings[67])) 
                 *ptr = XmSELECT_WHITESPACE;
             else
             if (!strcmp(*argv, wafeStrings[68])) 
                 *ptr = XmSELECT_WORD;
             else
             if (!strcmp(*argv, wafeStrings[69])) 
                 *ptr = XmSELECT_LINE;
             else
             if (!strcmp(*argv, wafeStrings[70])) 
                 *ptr = XmSELECT_ALL;
             else
             if (!strcmp(*argv, wafeStrings[71])) 
                 *ptr = XmSELECT_PARAGRAPH;
             else
                 DBUG_RETURN(wafeConvError(argc,argv, 2,NULL, wafeStrings[39]));


          ptr ++; argv++;
          }
     }
     wafeTextSetSelectionArray(localVar1,argc-2,localVar2);
     wafeMMreplace(localVar1,NULL,WafePermStringToQuark("XmTextFieldSetSelectionArray"),(char*)localVar2,XtFree);

     DBUG_RETURN (TCL_OK);
     }



#define WS_XmModifyVerifyCBset cmds[89].name
/* 
 * TCL_RETURN_CODE
 * wafeModifyVerifyCBset vulgo XmModifyVerifyCBset
 *         in: Boolean     		# doit
 *         in: long        		# currInsert
 *         in: long        		# startPos
 *         in: long        		# endPos
 *         in: String        		# String
 */

static int 
cmd_XmModifyVerifyCBset(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Boolean localVar1;
     long localVar2;
     long localVar3;
     long localVar4;
     TCL_RETURN_CODE returnVar;

     DBUG_ENTER(argv[0]);  

     if (argc != 6) 
	 DBUG_RETURN(wafeArgcError(argc,argv,wafeStrings[2],5));

     if (!(wafeGetBoolean(argv[1],&localVar1)))
         DBUG_RETURN (wafeConvError(argc, argv, 1 ,NULL, XtRBoolean));

     if (!(sscanf(argv[2], wafeStrings[9], &localVar2)))
         DBUG_RETURN (wafeConvError(argc, argv, 2 ,NULL, wafeStrings[17]));

     if (!(sscanf(argv[3], wafeStrings[9], &localVar3)))
         DBUG_RETURN (wafeConvError(argc, argv, 3 ,NULL, wafeStrings[17]));

     if (!(sscanf(argv[4], wafeStrings[9], &localVar4)))
         DBUG_RETURN (wafeConvError(argc, argv, 4 ,NULL, wafeStrings[17]));

    /* no need to assign  << localVar5 = argv[5] >>  */ 

     returnVar = wafeModifyVerifyCBset(localVar1,localVar2,localVar3,localVar4,argv[5]);

     DBUG_RETURN (returnVar);
     }



#define WS_XmInstallImage cmds[90].name
/* 
 * Boolean
 * wafeInstallImage vulgo XmInstallImage
 * 	in: XtDisplay(Widget)           # widget to determine display
 * 	in: String                      # filename or data
 *         in: String                      # short name
 *    	const: False
 * 	const: NULL
 */

static int 
cmd_XmInstallImage(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     Boolean returnVar;

     DBUG_ENTER(argv[0]);  

     if (argc != 4) 
	 DBUG_RETURN(wafeArgcError(argc,argv,wafeStrings[2],3));

     if (!(localVar1 = (Widget) name2Widget(argv[1])))
         DBUG_RETURN (wafeConvError(argc, argv, 1 ,NULL, XtRWidget));

    /* no need to assign  << localVar2 = argv[2] >>  */ 

    /* no need to assign  << localVar3 = argv[3] >>  */ 

     returnVar = wafeInstallImage(XtDisplay(localVar1),argv[2],argv[3],False,NULL);

     Tcl_SetResult(comInterpreter, wafeStrings[returnVar?1:0], TCL_STATIC);

     DBUG_RETURN (TCL_OK);
     }



#define WS_XmGetString cmds[91].name
/* 
 * String (TCL_RETURN_CODE)
 * XmGetString
 * 	in: Widget		# widget
 * 	in: String		# resource name

 */

static int 
cmd_XmGetString(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     TCL_RETURN_CODE returnVar;

     DBUG_ENTER(argv[0]);  

     if (argc != 3) 
	 DBUG_RETURN(wafeArgcError(argc,argv,wafeStrings[2],2));

     if (!(localVar1 = (Widget) name2Widget(argv[1])))
         DBUG_RETURN (wafeConvError(argc, argv, 1 ,NULL, XtRWidget));

    /* no need to assign  << localVar2 = argv[2] >>  */ 

     returnVar = (TCL_RETURN_CODE) XmGetString(localVar1,argv[2]);

     DBUG_RETURN (returnVar);
     }



#endif  /* of ifdef MOTIF11 */

void
wafeInitialize_MOTIF11()
{
#ifdef MOTIF11
 wccs[0].wClass = xmArrowButtonWidgetClass; /* not a constant! */
 wccs[1].wClass = xmArrowButtonGadgetClass; /* not a constant! */
 wccs[2].wClass = xmBulletinBoardWidgetClass; /* not a constant! */
 wccs[3].wClass = xmBulletinBoardWidgetClass;
 wccs[4].wClass = xmCascadeButtonWidgetClass; /* not a constant! */
 wccs[5].wClass = xmCascadeButtonGadgetClass; /* not a constant! */
 wccs[6].wClass = xmCommandWidgetClass; /* not a constant! */
 wccs[7].wClass = xmDialogShellWidgetClass; /* not a constant! */
 wccs[8].wClass = xmDrawingAreaWidgetClass; /* not a constant! */
 wccs[9].wClass = xmDrawnButtonWidgetClass; /* not a constant! */
 wccs[10].wClass = xmMessageBoxWidgetClass;
 wccs[11].wClass = xmFileSelectionBoxWidgetClass; /* not a constant! */
 wccs[12].wClass = xmFileSelectionBoxWidgetClass;
 wccs[13].wClass = xmFormWidgetClass; /* not a constant! */
 wccs[14].wClass = xmFormWidgetClass;
 wccs[15].wClass = xmFrameWidgetClass; /* not a constant! */
 wccs[16].wClass = xmMessageBoxWidgetClass;
 wccs[17].wClass = xmLabelWidgetClass; /* not a constant! */
 wccs[18].wClass = xmLabelGadgetClass; /* not a constant! */
 wccs[19].wClass = xmListWidgetClass; /* not a constant! */
 wccs[20].wClass = xmMainWindowWidgetClass; /* not a constant! */
 wccs[21].wClass = xmRowColumnWidgetClass;
 wccs[22].wClass = xmMenuShellWidgetClass; /* not a constant! */
 wccs[23].wClass = xmMessageBoxWidgetClass; /* not a constant! */
 wccs[24].wClass = xmMessageBoxWidgetClass;
 wccs[25].wClass = xmRowColumnWidgetClass;
 wccs[26].wClass = xmPanedWindowWidgetClass; /* not a constant! */
 wccs[27].wClass = xmRowColumnWidgetClass;
 wccs[28].wClass = xmSelectionBoxWidgetClass;
 wccs[29].wClass = xmRowColumnWidgetClass;
 wccs[30].wClass = xmPushButtonWidgetClass; /* not a constant! */
 wccs[31].wClass = xmPushButtonGadgetClass; /* not a constant! */
 wccs[32].wClass = xmMessageBoxWidgetClass;
 wccs[33].wClass = xmRowColumnWidgetClass;
 wccs[34].wClass = xmRowColumnWidgetClass; /* not a constant! */
 wccs[35].wClass = xmScaleWidgetClass; /* not a constant! */
 wccs[36].wClass = xmScrollBarWidgetClass; /* not a constant! */
 wccs[37].wClass = xmListWidgetClass;
 wccs[38].wClass = xmTextWidgetClass;
 wccs[39].wClass = xmScrolledWindowWidgetClass; /* not a constant! */
 wccs[40].wClass = xmSelectionBoxWidgetClass; /* not a constant! */
 wccs[41].wClass = xmSelectionBoxWidgetClass;
 wccs[42].wClass = xmSeparatorWidgetClass; /* not a constant! */
 wccs[43].wClass = xmSeparatorGadgetClass; /* not a constant! */
 wccs[44].wClass = xmRowColumnWidgetClass;
 wccs[45].wClass = xmRowColumnWidgetClass;
 wccs[46].wClass = xmRowColumnWidgetClass;
 wccs[47].wClass = xmRowColumnWidgetClass;
 wccs[48].wClass = xmRowColumnWidgetClass;
 wccs[49].wClass = xmRowColumnWidgetClass;
 wccs[50].wClass = xmTextWidgetClass; /* not a constant! */
 wccs[51].wClass = xmTextFieldWidgetClass; /* not a constant! */
 wccs[52].wClass = xmToggleButtonWidgetClass; /* not a constant! */
 wccs[53].wClass = xmToggleButtonGadgetClass; /* not a constant! */
 wccs[54].wClass = xmMessageBoxWidgetClass;
 wccs[55].wClass = xmMessageBoxWidgetClass;
 XtSetTypeConverter(XtRString, XmRXmString,
	(XtTypeConverter)CvtStringToXmString, 
	NULL, 0, XtCacheNone, NULL);
 XtSetTypeConverter(XtRString, XmRXmStringTable,
	(XtTypeConverter)CvtStringToXmStrings, 
	NULL, 0, XtCacheNone, NULL);
 XtSetTypeConverter(XtRString, XmRWindow,
	(XtTypeConverter)CvtStringToWidget, 
	NULL, 0, XtCacheNone, NULL);
 XtSetTypeConverter(XtRString, XmRMenuWidget,
	(XtTypeConverter)CvtStringToWidget, 
	NULL, 0, XtCacheNone, NULL);
 XtSetTypeConverter(XmRXmString, XtRString,
	(XtTypeConverter)CvtXmStringToString, 
	NULL, 0, XtCacheNone, NULL);
 XtSetTypeConverter(XmRXmStringTable, XtRString,
	(XtTypeConverter)CvtXmStringTableToString, 
	NULL, 0, XtCacheNone, NULL);
 XtSetTypeConverter(XtRString, XmRTextPosition,
	(XtTypeConverter)CvtStringToLong, 
	NULL, 0, XtCacheNone, NULL);
 XtSetTypeConverter(XtRString, XmRProc,
	(XtTypeConverter)CvtStringToFileSearchProc, 
	NULL, 0, XtCacheNone, NULL);
 wafeMotifInit();
 qXmString = WafePermStringToQuark(XmRXmString);
 qWindow = WafePermStringToQuark(XmRWindow);
 qShort = WafePermStringToQuark(XmRShort);
 qMenuWidget = WafePermStringToQuark(XmRMenuWidget);
 qHorizontalDimension = WafePermStringToQuark(XmRHorizontalDimension);
 qVerticalDimension = WafePermStringToQuark(XmRVerticalDimension);
 qShellHorizDim = WafePermStringToQuark(XmRShellHorizDim);
 qShellVertDim = WafePermStringToQuark(XmRShellVertDim);
 qTextPosition = WafePermStringToQuark(XmRTextPosition);
 qVerticalPosition = WafePermStringToQuark(XmRVerticalPosition);
 qHorizontalPosition = WafePermStringToQuark(XmRHorizontalPosition);
 qVerticalInt = WafePermStringToQuark(XmRVerticalInt);
 qHorizontalInt = WafePermStringToQuark(XmRHorizontalInt);
 qPixmap = WafePermStringToQuark(XmRPixmap);
 qBackgroundPixmap = WafePermStringToQuark(XmRBackgroundPixmap);
 qGadgetPixmap = WafePermStringToQuark(XmRGadgetPixmap);
 qManBottomShadowPixmap = WafePermStringToQuark(XmRManBottomShadowPixmap);
 qManForegroundPixmap = WafePermStringToQuark(XmRManForegroundPixmap);
 qManHighlightPixmap = WafePermStringToQuark(XmRManHighlightPixmap);
 qManTopShadowPixmap = WafePermStringToQuark(XmRManTopShadowPixmap);
 qPrimBottomShadowPixmap = WafePermStringToQuark(XmRPrimBottomShadowPixmap);
 qPrimForegroundPixmap = WafePermStringToQuark(XmRPrimForegroundPixmap);
 qPrimHighlightPixmap = WafePermStringToQuark(XmRPrimHighlightPixmap);
 qPrimTopShadowPixmap = WafePermStringToQuark(XmRPrimTopShadowPixmap);
 qXmBackgroundPixmap = WafePermStringToQuark(XmRXmBackgroundPixmap);
 qsource = WafePermStringToQuark(XmNsource);
 qXmStringTable = WafePermStringToQuark(XmRXmStringTable);
 qitems = WafePermStringToQuark(XmNitems);
 qselectedItems = WafePermStringToQuark(XmNselectedItems);
 qfileSearchProc = WafePermStringToQuark(XmNfileSearchProc);
 qdirSearchProc = WafePermStringToQuark(XmNdirSearchProc);
 XtAddConverter (XmRString, XmRUnitType, XmCvtStringToUnitType, NULL, 0);
 wafeCreateTclCmds(pkgs,wccs,cmds);
#endif /* of ifdef MOTIF11 */
}
