.TH xwafemail 1
.SH NAME
.PP
xwafemail \- an x-based mail front end with faces 

.SH SYNOPSIS
.PP
\f3xwafemail\f1 [\f3-c \f2colormode\f1] 
[\f3-3\f1] 
[\f3-C\f1] 
[\f3-f \f2 name of mail folder\f1] 
[\f3-F\f1] 
[\f3-h\f1] 
[\f3-p\f1  \f2print command\f1] 
[\f3-r\f1] 
[\f3-s \f2 name of signature file\f1]
[\f3-u\f2 update interval\f1] 

.SH DESCRIPTION
.PP

\fIxwafemail\fP is an x-based mail front end which tries to display the
faces of the originator of an incoming mail. xwafemail is a
\fIwafe\fP application (see manual page wafeapp) written in Perl. In
short, xwafemail allows a user to read mail,
to reply to the author, to forward mail messages to other people,
to send mail, to save and to print mail messages.

.SH OPTIONS
.PP
In addition to the standard toolkit options such as
-display, -name, -geometry, -iconic, -xrm etc. (see manual page X)
xwafemail accepts  the following options:
.TP
\f3-c \f2colormode\f1
start xwafemail using the given color-mode (for details see manual page
wafeapp); color modes are for example \fImono\fP, \fIblueish\fP or \fIwheat-ish\fP.

.TP
\f3-3\f1
do not use 3 dimensional widgets. This option depends of the configuration 
in the system.waferc file (see manual page wafeapp).

.TP
\f3-C\f1
prefer files for the communication between front end and application
program. This option can reduce the memory consumption, but increases
disk-IO and might lead to locking problems.

.TP
\f3-f \f2name of mail folder\f1
use an alternate mail folder. Per default the mail folder given in the
environment variable \fIMAIL\fP, or  the file \fI"/usr/spool/mail/$USER"\fP
is used. For the naming conventions see section MAIL FOLDERS.

.TP
\f3-F\f1
start in fast mode. Per default, each subject line is displayed in a
command widget. In fast mode the subject lines are kept in a text widget.

.TP
\f3-h\f1
show a short usage message.

.TP
\f3-p \f2print command\f1
specify a non-default print command (for example: 'mp -a | lpr
-Pmyps') the quotes are NOT optional.

.TP
\f3-r\f1
start in read-only mode. In read -only mode the mailbox cannot be 
rewritten. However, it is still possible to read or send mail.

.TP
\f3-s \f2name of signature file\f1
use a non-default signature file. In the configuration of the
distribution the name of the signature file is $HOME/.elm/signature.
The signature file is appended to all outgoing mail messages. 
A stupid example: \fI-s $HOME/.login\fP.

.TP
\f3-u \f2update interval\f1
used to specify a non-default interval in which the mailbox is
checked. if a change is detected, the subject listing is updated. The
default update interval is 5 seconds.


.SH "LAYOUT and INTERACTION" 

.PP 
When xwafemail is started the user will see an X front end with
two main sections: these sections are (from top to bottom): the
\fIsubject\fP section and the \fImessage\fP section.  The top most
line of the application is an information line, where the user is
informed about the actions the program takes.

The \fIsubject\fP section shows the subject lines of the mailbox.
Each line summarizes the content of a single mail message (if the
mailbox is not empty). In the \fIdefault mode\fP each line starts wit a
symbol displaying the state of the message: en envelope symbol is used
to denote an unread message, a small hook is used to a read message
and a minus sign is for a deleted mail message. The symbol is followed
by the number of the mail message (the highest number is the most
recent mail, displayed on the top of the list), the date, the
originator, the number of lines of the message (between parentheses)
and the subject line. In \fIfast mode\fP (option -F) the symbols are
replaced by characters ("D" for delete message, "U" for unread
message). In \fIfast mode\fP search fields for subject grep 
and bodygrep are additionally available. These fields allow
to display matching messages only.

In either mode a mail message is read by pressing the left mouse
button (Btn1) on a subject line. In turn the message will be displayed
in the \fImessage\fP section, the from-, subject- and date-fields
will be displayed on top of the message section, on the right side a
face of the originator will be displayed if available (maximum size
65x65). In default mode cursor up or down in the subject listing 
may be used to read the next or previous message.


The \fImessage\fP section displays the current message. The bottom
line of the application contains several buttons. the \fIquit\fP
button terminates xwafemail AND updates the mailbox file (see also -f
option). \fIabort\fP is used to terminate without saving or to abort
writing of a mail message. \fImail\fP is used to compose a new mail
message, \fIreply\fP allows to send mail to the author of the current
message, \fIforward\fP is used to forward the current message via mail
to another user. Mail, reply and forward may be terminated by the
\fIsend\fP button or aborted by \fIabort\fP. The \fIheader\fP button
shows/hides the full header of a mail message, \fIdelete\fP,
\fIprint\fP (\fIsave\fP) can be used to delete, print or save the
current message. The \fIsend\fP button is only sensitive in send mode 
(after pushing \fImail\Pf, \fIreply\fP or \fIforward\fP).
Finally, the \fIConfig\fP button may be used to change certain settings
(such as print command) for a single session.

.SH MAIL FOLDERS
.PP
If the save button is pressed (or messages are selected with the
middle mouse button and the character "s" is typed in the subject
listing), a \fIsave window\fP pops up. If \fIcancel\fP is pressed with
the left mouse button, nothing is saved and the dialog window pops
down.  If nothing is typed in the dialog window and the return key is
pressed, the selected messages will be saved in the $HOME/Mail
directory and appended to a file with the name "incoming". In send
mode (if the buttons mail, reply or forward were pressed) the name
outgoing is used. If a name is specified in the save pop-up, and it
does not start "~", "/" or "|", the mail messages will be saved in the
$HOME/Mail/ directory under the given name.  If the specified name
starts with "~" or "/", the name will be interpreted as a full path
name. If the name starts with "|" the name will be interpreted as a
pipe. 

About the same rules apply also to the -f option (the pipe symbol will
not make sense). Sent messages are saved in folders named after the
user id of the recipient of the message in the  Mail directory. Note
that these folders may be read using the -f option. "xwafemail -f
neumann" will start xwafemail using the mail folder, in which the
outgoing messages for neumann are saved.

.SH FACES
.PP
If wafe has been compiled with the xpm library, and the perl variable 
$noXPM has not been set in the setup files (see manual page for wafeapp) 
\fIxwafemail\fP tries to display a picture of the originator of a mail above
the message text. The face has a maximum size of 65x65 pixels. First
xwafemail tries to load an xpm file from $WAFEMAIL/faces using the
login name of the originator (eg. $WAFEMAIL/faces/neumann.xpm). If
this file does not exist, it tries to load a bitmap file from the same
place (eg. $WAFEMAIL/faces/neumann.xbm). If neither of these files
are found, no picture is displayed.

.SH "ALIAS RESOLVING"
.PP
For resolving the addresses of outgoing mail messages a local alias file may
be used. The alias file has the form of the elm aliases and has the
form
.EX 0
neumann = Gustaf Neumann = neumann@wu-wien.ac.at 
nusser = Stefan Nusser = nusser@wu-wien.ac.at 
wafer = wafe development subgroup = neumann,nusser
.EE
Per default the file "$HOME/.elm/aliases.text" is used.

.SH "KEY BINDINGS"
.PP
\fIKey bindings in subject listing:\fP
.TP 13
<Btn1>
read message
.TP
<Btn2> 
select messages (only in fast mode)
.TP
<Key>Up
read previous message (only in normal mode)
.TP
<Key>Down
read next message  (only in normal mode)
.TP
<Key>Prior
previous page (only in normal mode)
.TP
<Key>Next
next page (only in normal mode)
.TP
<Key>d
delete message (or selected messages in fast mode)
.TP
<Key>s
save message (or selected messages in fast mode)
.TP

.PP
\fIKey bindings in message text:\fP
.TP 13
Ctrl<Key>f
use a fixed spaced font
.TP
Meta<Key>q
reflow text
.TP
Ctrl<Key>v
use a variable spaced font
.TP
Ctrl<Key>w
set read-only buffer writable (useful in combination with Ctrl<Key>q
to reflow text that does not fit in the current line with)

.PP
\fIKey bindings on buttons in the bottom button row:\fP
.TP 13
<Btn3> 
clicking <Btn3> on <mail>, <reply> or <forward> sends mail as  urgent


.SH "ENVIRONMENT VARIABLES"
.PP
.TP 13
WAFELIB
location of the wafe library (typically /usr/lib/X11/wafe)
.TP
HOME
login directory of the current user
.TP
HOST
fully qualified host name (including domain)
.TP
USER
login name of the current user
.TP
TMPDIR
directory for temporary files. If  not specified, /tmp is used

.SH "PERL VARIABLES"
.PP
Wafe (Perl-) Variables from $WAFELIB/system.waferc or $HOME/.waferc:
.TP 13
$boldFont
typically used for bold labels
.TP
$normalFont
typically used for labels or proportional text
.TP
$buttonFont
typically used as font for buttons
.TP
$textFont
fixed spaced text font
.TP
$buttonAtts
attributes used for buttons
.TP
$backGround
back ground color
.TP
$highLight
attributes for emphasized text portions (typically colors)
.TP
$roColors
attributes for non emphasized text (typically colors)
.TP
$infoColors
attributes of the info line (typically colors)
.TP
$menueAtts 
attributes of pull down menues (typically colors)
.TP
%textResources
default resources for text widgets
.TP
@textActions
default actions for text widgets
.TP
$mailIncludePrefix
prefix for included text-portions for reply or followups
.TP
$signatureFile
full path leading to the signature file
.TP
$printCommand
command used to print mail messages
.TP 
$elmAliases
full path leading to an alias file used to resolve addresses in
outgoing mails.
.TP
$noXPM
disable XPM pixmaps, no XPM faces will be displayed (for
broken X server of OS/2).
.TP
$defaultMailHost
default mail host, if no alias exists and no host address is given
.TP
$defaultMailEncoding
default encoding for sending mail default is Mime,
possible values are (TeX, Swe, Mime, None)
.SH FILES 
.PP
.EX 0
$HOME/Mail
$HOME/.elm/signature
$HOME/.elm/aliases.text
$WAFELIB/system.waferc
$HOME/.waferc
.EE
.SH "SEE ALSO"
.PP
wafe(n),
wafeapp(n),
X(1),
xwafemail(n),
xwafenews(n),
xwafeftp(n),
xwafeora(n),
xwafetel(n),
xdirtree(n),
xdirtree(n),
xprojektor(n),
xbm(n),
xwafemc(n),
xruptimes(n),
xnetstats(n),
xiostats(n),
xvmstats(n),
xwafeping(n),
xwafecf(n)

.SH COPYRIGHT
.PP
 Copyright (C) 1992 by Gustaf Neumann, Stefan Nusser
.EX 0
     Wirtschaftsuniversitaet Wien, 
     Abteilung fuer Wirtschaftsinformatik
     Augasse 2-6, 
     A-1090 Vienna, Austria
     neumann@wu-wien.ac.at, nusser@wu-wien.ac.at
.EE
Permission to use, copy, modify, and distribute this software and its
documentation for any purpose and without fee is hereby granted, provided
that the above copyright notice appears in all copies and that both that
copyright notice and this permission notice appear in all supporting
documentation.  This software is provided "as is" without expressed or
implied warranty.
.PP
.SH AUTHORS
.PP
Gustaf Neumann, Stefan Nusser
