/* Copyright (C) 1992 by Gustaf Neumann, Stefan Nusser

 *      Wirtschaftsuniversitaet Wien, 
 *      Abteilung fuer Wirtschaftsinformatik
 *      Augasse 2-6, 
 *      A-1090 Vienna, Austria
 *      neumann@wu-wien.ac.at, nusser@wu-wien.ac.at

 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided
 * that the above copyright notice appears in all copies and that both that
 * copyright notice and this permission notice appear in all supporting
 * documentation.  This software is provided "as is" without expressed or
 * implied warranty.

 * Creation: Mon May  2 23:29:33 EDT 1994 on syllog2.watson.ibm.com
 * Author: genc
 * Version: 0.95999999999999996


 */
#define MOTIF11_C
#include <wafe.h>
#ifdef MOTIF11

#include <X11/Shell.h>

/* 
 * ******* begin required file <motif.inc> *******
 */
/* make emcas happy -*-C-*-  make emacs happy */

#include <ctype.h>
#include <sys/time.h>
#include <Xm/AtomMgr.h>

#define MAX_STRING_SEGMENT 4096
#define MAX_FORMAT_LEN 50

static XmStringCharSet defaultCharSet;
static Widget currentDragContext;

/*
#define defaultCharSet XmSTRING_DEFAULT_CHARSET
*/

#define	Done(type, value) \
	{							\
	    if (toVal->addr != NULL) {				\
		if (toVal->size < sizeof(type)) {		\
		    toVal->size = sizeof(type);			\
		    return False;				\
		}						\
		*(type*)(toVal->addr) = (value);		\
	    }							\
	    else {						\
		static type static_val;				\
		static_val = (value);				\
		toVal->addr = (XtPointer)&static_val;		\
	    }							\
	    toVal->size = sizeof(type);				\
	    return True;					\
	}


/*
 * Initialize the default character Set variable!
 */

void
wafeMotifInit()
    {
    XmString          dummy;
    XmStringContext   strContext;
    char              *text;
    XmStringCharSet   tmpCharSet;
    XmStringDirection dummyDir;
    Boolean           dummySep;
    dummy = XmStringCreateSimple("dummy");

    if (!XmStringInitContext(&strContext, dummy))
	{
	fprintf(stderr, "Wafe(motif): Couldn't create string Context\n");
	exit(-1);
	}

    XmStringGetNextSegment(strContext, &text, &tmpCharSet,
			   &dummyDir, &dummySep);

    defaultCharSet = XtNewString(tmpCharSet);

    XtFree(text);
    XmStringFree(dummy);
    XmStringFreeContext(strContext);

/*
    fprintf(stderr, "Setting defaultCharSet to %s default <%s> (XmSTRING_DEFAULT_CHARSET)\n",
	    defaultCharSet, XmSTRING_DEFAULT_CHARSET);
*/
    /* wafeRegisterXpmTypeConverter(XmCPixmap, True);*/
    wafeRegisterXpmTypeConverter("XmBackgroundPixmap", True);
    }



/*
 * Utility function: Creates a new compound string segment, appends it
 * to an existing XmString. Does NOT create a segement if the string is empty!
 */

static XmString
compStringAppend(oldCompStr, text, charSet, dir, sep)
XmString           oldCompStr;
char              *text;
XmStringCharSet    charSet;
XmStringDirection  dir;
Boolean            sep;
    {
    XmString  addSeg, newString;

    if (*text == '\0' && sep)
	return(oldCompStr);

/*
    fprintf(stderr, "Generated segment with <%s>\n", text);
 */

    if (!oldCompStr)
	return(XmStringSegmentCreate(text, charSet, dir, sep));
    else
	{
	addSeg = XmStringSegmentCreate(text, charSet, dir, sep);
	newString = XmStringConcat(oldCompStr, addSeg);
	XmStringFree(addSeg);
	XmStringFree(oldCompStr);
	return(newString);
	}
    }

XmString
wafeCvtStringToXmString(inString)
char  *inString;
    {
    char               segBuf[MAX_STRING_SEGMENT];
    char               formatBuf[MAX_FORMAT_LEN];
    XmStringCharSet    charSet = XmSTRING_DEFAULT_CHARSET;
    XmStringDirection  dir = XmSTRING_DIRECTION_L_TO_R;
    XmString           result = NULL;
    char              *segPtr = segBuf;
    char              *ptr = inString;
    char              *top;

/*
    fprintf(stderr, "Converting string <%s>\n", inString);
*/
    top = ptr + strlen(inString);
    *segPtr = '\0';
    while (ptr < top)
	{
	switch (*ptr)
	    {
	    case '\n':
	    /* NewLine: Finish current segment */

	    *segPtr = '\0';
            result = compStringAppend(result, segBuf, charSet, dir, True);
	    segPtr = segBuf;
	    ptr++;
	    break;
	
	    case '^':
            /* Enter command mode */
	    ptr++;

	    if (ptr == top)
		{
		fprintf(stderr,
		    "Wafe(XmString Conversion): Cannot handle trailing '^'\n");
		return NULL;
		}

	    if (*ptr == '^')
		{
		/* Two ^ => leave command mode, insert one ^ */
		*segPtr++ = '^';
		ptr++;
		}
	    else
		if (!isalpha(*ptr))
		    {
                    /* ^ + whatever not alphabetic => ignore ^ */
		    *segPtr++ = *ptr++;
		    }
		else
		    {
		    char   *comPtr = formatBuf;
		
		    /* Terminate current segment */
		    *segPtr = '\0';
		    result = compStringAppend(result, segBuf,
					      charSet, dir, False);
		    segPtr = segBuf;
				
		    /* Extract command */
		    while ((isalnum(*ptr)
			    || (*ptr == '-')
			    || (*ptr == '_'))
			   && (ptr <= top))
			*comPtr++ = *ptr++;

		    *comPtr = '\0';
/*
		    fprintf(stderr, "Parsed command <%s>\n", formatBuf);
 */
		    if (!strcmp(formatBuf, "lr"))
			dir = XmSTRING_DIRECTION_L_TO_R;		
		    else
			if (!strcmp(formatBuf, "rl"))
			    dir = XmSTRING_DIRECTION_R_TO_L;
			else
			    charSet = XtNewString(formatBuf);

		    if (*ptr == ' ')
			ptr++;
		    }
	    break;
	    	
	    default:
	    *segPtr++ = *ptr++;
	    break;

	    } /* switch */	
	} /* while */

    *segPtr = '\0';
    result = compStringAppend(result, segBuf, charSet, dir, False);
    return result;
    }


XmStringTable
wafeCvtStringToXmStringTable(inString)
char * inString;
    {
    int argc;
    char ** argv;
    XmString *strTable, *t;
    int i;

    Tcl_SplitList(wafeInterpreter,inString, &argc,&argv);
    t = strTable = (XmString *)XtMalloc((argc+1)*sizeof(XmString));

    for ( i = 0; i < argc; i++, t++ )
	if (!(*t = wafeCvtStringToXmString(argv[i])))
	    {
	    wafeConvError("wafeCvtStringToXmStringTable","n",argv[i],"XmString");
	    return NULL;
	    }
    *t = NULL;

    return (XmStringTable) strTable;
    }


/* Queries a XmString Value and translates it to a valid input string */

char *
wafeCvtXmString2String(buffer,compStr)
char          * buffer;
XmString      compStr;
    {
    XmStringContext    strContext;
    char               *text;
    XmStringCharSet    charSet,
                       lastCharSet = defaultCharSet;
    XmStringDirection  dir,
                       lastDir = XmSTRING_DIRECTION_L_TO_R;
    Boolean            sep;
    Boolean            fontChange;
    char               *returnString, *ptr;

    DBUG_ENTER("wafeCvtXmString2String");

    if (!XmStringInitContext(&strContext, compStr))
	{
	fprintf(stderr, "Wafe(motif): Couldn't create string Context\n");
	return(NULL);
	}

    if (!buffer)
	{
	ptr = returnString = XtMalloc(XmStringLength(compStr)+100); /* hack  for now */
/*	fprintf(stderr, "buffer new allocated %p, size=%d\n",
		ptr,XmStringLength(compStr));
 */
	}
    else
	{
	fprintf(stderr, "using provided buffer %p\n", buffer);
	ptr = returnString = buffer;	
	}


    while (XmStringGetNextSegment(strContext, &text, &charSet, &dir, &sep))
	{
	char *textPtr = text;

	fontChange = strcmp(charSet, lastCharSet);

	/* This means: If there are no changes in charSet or direction,
	 * just make a newline but don't do it, if this is the first segment
	 */
	if (   (!fontChange)
	    && (dir == lastDir)
	    && (returnString != ptr))
	    *ptr++ = '\n';

	if (fontChange
#ifdef XmFONTLIST_DEFAULT_TAG
	    /* Motif 1.2 seems to want it that way ... */
	    && strcmp(charSet,XmFONTLIST_DEFAULT_TAG)
#endif
	    )
	    {
            *ptr++ = '^';
	    strcpy(ptr, charSet);
	    ptr+= strlen(charSet);
	    *ptr++ = ' ';
	    lastCharSet = charSet;
	    }

	if (dir != lastDir)
	    {
	    if (dir == XmSTRING_DIRECTION_L_TO_R)
		strcpy(ptr, "^lr ");
	    else
		strcpy(ptr, "^rl ");		
	    ptr+=4;
	    lastDir = dir;
	    }	

	while (*textPtr != '\0')
	    {
	    if (*textPtr == '^')
		{
		strcpy(ptr, "^^");
		ptr +=2;
		textPtr++;
		}
	    else
		*ptr++ = *textPtr++;
	    }
	}
    *ptr = '\0';
    XmStringFreeContext(strContext);
/*
    fprintf(stderr,"xmString2String returns <%s> size=%d\n",
	    returnString,strlen(returnString));
*/
    DBUG_RETURN(returnString);
    }

void
wafeEscapedXmString2String(buffer,compStr)
char          * buffer;
XmString      compStr;
    {
    char *p = wafeCvtXmString2String(NULL,compStr);
    wafeEscapedStrcpy(buffer,p);
    XtFree(p);
    }



char *
wafeCvtXmStringTable2String(count,strTable)
int           count;
XmStringTable strTable;
    {
    char    **temp, **cPtr;
    XmString  *ptr = strTable;
    char      *result;
    int        i;

    DBUG_ENTER("wafeCvtXmStringTable2String");

    temp = (char **)XtMalloc(count*sizeof(char *));
    for (ptr=strTable, cPtr=temp, i=count; i>0; ptr++, cPtr++, i--)
	{
	*cPtr = wafeCvtXmString2String(NULL,*ptr);
	}

    result = Tcl_Merge(count, temp);

    for (cPtr = temp, i=count; i>0; cPtr++, i--)
	XtFree(*cPtr);

    XtFree((char *)temp);
    DBUG_RETURN (result);
    }

/*
 * Two converter function wrappers for the *2String functions, which are
 * called by getValues
 */

Boolean
CvtXmStringToString(dpy, args, num_args, fromVal, toVal, converterData)
Display   *dpy;
XrmValue  *args;
Cardinal  *num_args;
XrmValue  *fromVal;
XrmValue  *toVal;
XtPointer *converterData;
    {
    static char *result;
    DBUG_ENTER("CvtXmStringToString");
    result = wafeCvtXmString2String(NULL,(XmString)(fromVal->addr));
    toVal->addr = result;
    toVal->size = 1; /* if nobody else uses this converter it shouldn't matter anyway */
    DBUG_RETURN(True);
    }


Boolean
CvtXmStringTableToString(dpy, args, num_args, fromVal, toVal, converter_data)
Display   *dpy;
XrmValue  *args;
Cardinal  *num_args;
XrmValue  *fromVal;
XrmValue  *toVal;
XtPointer *converter_data;
    {
    static char *result;
    DBUG_ENTER("CvtXmStringTableToString");
    result = wafeCvtXmStringTable2String(0,(XmStringTable)(fromVal->addr));

    toVal->addr = result;
    toVal->size = 1; /* it should not matter either */
    DBUG_RETURN(True);
    }


void
wafeFreeStringTable(table)
XmStringTable  table;
    {
    XmStringTable t = table;

    while (*t != NULL)
	XmStringFree(*t++);
    XtFree((char *) table);
    }	



Boolean
CvtStringToXmStrings(dpy, args, num_args, fromVal, toVal, converter_data)
Display   *dpy;
XrmValue  *args;
Cardinal  *num_args;
XrmValue  *fromVal;
XrmValue  *toVal;
XtPointer *converter_data;
    {
    int               argc, count;
    char            **argv;
    XmString         *ptr;
    static XmString  *result;

    DBUG_ENTER("CvtStringToXmStrings");

    if (Tcl_SplitList(wafeInterpreter,(char*)fromVal->addr, &argc, &argv)
	!= TCL_OK)
	{
	fprintf(stderr, "Wafe(XmStringTableConversion): %s\n",
		wafeInterpreter->result);
	return False;
	}


    result = (XmString *)XtMalloc(argc*sizeof(XmString));
    for(count = 0, ptr = result; count < argc; count++, ptr++)
	if ((*ptr = wafeCvtStringToXmString(argv[count],NULL,0)) == NULL)
	    {
	    XtDisplayStringConversionWarning(dpy, (char *)fromVal->addr,
					     "XmString");
	    XtFree((char *)result);
	    XtFree((char *)argv);
	    return False;
	    }
    XtFree((char *)argv);

    if (toVal->addr)
	{
	fprintf(stderr,"somebody else called CvtStringToXmStrings! size=%d\n",
		toVal->size);
	
	if (toVal->size < sizeof(XmString *))
	    {
	    toVal->size = sizeof(XmString *);
	    XtFree((char *)result);
	    DBUG_RETURN(False);
	    }

	toVal->size = sizeof(XmString *);
	*(XmString **)(toVal->addr) = result;
	DBUG_RETURN(True);
	}

	
    toVal->size = sizeof(XmString **);
    toVal->addr = (caddr_t)&result;

    wafeMMreplace(wafeCurrentAttribList, wafeCurrentAttrib,
	      (char *)result, wafeFreeStringTable);

    DBUG_RETURN(True);
    }


Boolean
CvtStringToXmString(dpy, args, num_args, fromVal, toVal,
                                converter_data)
Display   *dpy;
XrmValue  *args;
Cardinal  *num_args;
XrmValue  *fromVal;
XrmValue  *toVal;
XtPointer *converter_data;
    {
    static XmString  result;
    DBUG_ENTER("CvtStringToXmString");

/*    fprintf(stderr, "CvtStringToXmString: <%s> %p\n",
	    fromVal->addr, toVal->addr);
 */

    if ((result = wafeCvtStringToXmString((char *)fromVal->addr, NULL, 0)) == NULL)
	{
	XtDisplayStringConversionWarning(dpy, (char *)fromVal->addr,
					 "XmString");
	DBUG_RETURN(False);
	}

    if (toVal->addr)
	{
	if (toVal->size < sizeof(XmString))
	    {
	    toVal->size = sizeof(XmString);
	    XmStringFree(result);
	    DBUG_RETURN(False);
	    }

	toVal->size = sizeof(XmString);
	*(XmString *)(toVal->addr) = result;
	DBUG_RETURN(True);
	}

    toVal->size = sizeof(XmString *);
    toVal->addr = (XtPointer)result;

    wafeMMreplace(wafeCurrentAttribList, wafeCurrentAttrib,
	      (char *)result, (freeProc)XmStringFree);
    DBUG_RETURN(True);
    }


Boolean
CvtStringToLong(dpy, args, num_args, fromVal, toVal,
                                converter_data)
Display   *dpy;
XrmValue  *args;
Cardinal  *num_args;
XrmValue  *fromVal;
XrmValue  *toVal;
XtPointer *converter_data;
    {
    long result;

    if (sscanf((char *)fromVal->addr, "%ld", &result) == 1)
	{
	Done(long, result);
	}
    else
	return False;
    }


/* 
 * ******* end required file <motif.inc> *******
 */
/* 
 * Boolean
 * XmProcessTraversal
 * 	in: Widget		# Widget for which to traverse hierarchy
 * 	in: (int) XmTravDir	# direction in which to traverse widget hierarchy
 */

static int 
cmd_XmProcessTraversal(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     int localVar2;
     Boolean returnVar;
     char conversionBuffer[100];

     DBUG_ENTER("XmProcessTraversal");  

     if (argc != 3) 
	 {
	 wafeArgcError("XmProcessTraversal","",2,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 = (Widget) name2Widget(argv[1])))
          {
          wafeConvError("XmProcessTraversal","1",argv[1],"Widget");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!strcmp(argv[2], "TRAVERSE_CURRENT")) 
         localVar2 = XmTRAVERSE_CURRENT;
     else
     if (!strcmp(argv[2], "TRAVERSE_NEXT")) 
         localVar2 = XmTRAVERSE_NEXT;
     else
     if (!strcmp(argv[2], "TRAVERSE_PREV")) 
         localVar2 = XmTRAVERSE_PREV;
     else
     if (!strcmp(argv[2], "TRAVERSE_HOME")) 
         localVar2 = XmTRAVERSE_HOME;
     else
     if (!strcmp(argv[2], "TRAVERSE_NEXT_TAB_GROUP")) 
         localVar2 = XmTRAVERSE_NEXT_TAB_GROUP;
     else
     if (!strcmp(argv[2], "TRAVERSE_PREV_TAB_GROUP")) 
         localVar2 = XmTRAVERSE_PREV_TAB_GROUP;
     else
     if (!strcmp(argv[2], "TRAVERSE_UP")) 
         localVar2 = XmTRAVERSE_UP;
     else
     if (!strcmp(argv[2], "TRAVERSE_DOWN")) 
         localVar2 = XmTRAVERSE_DOWN;
     else
     if (!strcmp(argv[2], "TRAVERSE_LEFT")) 
         localVar2 = XmTRAVERSE_LEFT;
     else
     if (!strcmp(argv[2], "TRAVERSE_RIGHT")) 
         localVar2 = XmTRAVERSE_RIGHT;
     else
         {
         wafeConvError("XmProcessTraversal","2",argv[2],"XmTravDir");
         DBUG_RETURN (TCL_ERROR);
        }


     returnVar = XmProcessTraversal(localVar1,localVar2);

          if (returnVar == 0) 
          strcpy(conversionBuffer, "false");
     else
     if (returnVar == 1) 
          strcpy(conversionBuffer, "true");


     Tcl_SetResult(comInterpreter, conversionBuffer, TCL_VOLATILE);

     DBUG_RETURN (TCL_OK);
     }     


#include <Xm/ArrowB.h>
#include <Xm/ArrowBG.h>
#include <Xm/BulletinB.h>
#include <Xm/CascadeB.h>
#include <Xm/CascadeBG.h>
/* 
 * void 
 * XmCascadeButtonGadgetHighlight
 * 	in: XmCascadeButtonGadget   	# cascadeButtonGadget to be highlighted
 * 	in: Boolean          	    	# highlight (bool)
 */

static int 
cmd_XmCascadeButtonGadgetHighlight(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     Boolean localVar2;

     DBUG_ENTER("XmCascadeButtonGadgetHighlight");  

     if (argc != 3) 
	 {
	 wafeArgcError("XmCascadeButtonGadgetHighlight","",2,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmCascadeButtonGadgetClass,"XmCascadeButton")))
          {
          wafeConvError("XmCascadeButtonGadgetHighlight","1",argv[1],"XmCascadeButtonGadget");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!strcmp(argv[2], "false")) 
         localVar2 = 0;
     else
     if (!strcmp(argv[2], "true")) 
         localVar2 = 1;
     else
         {
         wafeConvError("XmCascadeButtonGadgetHighlight","2",argv[2],"Boolean");
         DBUG_RETURN (TCL_ERROR);
        }


     XmCascadeButtonGadgetHighlight(localVar1,localVar2);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void 
 * XmCascadeButtonHighlight
 * 	in: XmCascadeButtonGadget   	# widget to be highlighted
 * 	in: Boolean          	    	# highlight (bool)
 */

static int 
cmd_XmCascadeButtonHighlight(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     Boolean localVar2;

     DBUG_ENTER("XmCascadeButtonHighlight");  

     if (argc != 3) 
	 {
	 wafeArgcError("XmCascadeButtonHighlight","",2,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmCascadeButtonGadgetClass,"XmCascadeButton")))
          {
          wafeConvError("XmCascadeButtonHighlight","1",argv[1],"XmCascadeButtonGadget");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!strcmp(argv[2], "false")) 
         localVar2 = 0;
     else
     if (!strcmp(argv[2], "true")) 
         localVar2 = 1;
     else
         {
         wafeConvError("XmCascadeButtonHighlight","2",argv[2],"Boolean");
         DBUG_RETURN (TCL_ERROR);
        }


     XmCascadeButtonHighlight(localVar1,localVar2);

     DBUG_RETURN (TCL_OK);
     }     


#include <Xm/Command.h>
/* 
 * void
 * XmCommandAppendValue
 * 	in: XmCommandWidget          	# command widget 
 * 	in: XmString         		# command string
 */

static int 
cmd_XmCommandAppendValue(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     XmString localVar2;

     DBUG_ENTER("XmCommandAppendValue");  

     if (argc != 3) 
	 {
	 wafeArgcError("XmCommandAppendValue","",2,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmCommandWidgetClass,"XmCommand")))
          {
          wafeConvError("XmCommandAppendValue","1",argv[1],"XmCommandWidget");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(localVar2 = (XmString) wafeCvtStringToXmString(argv[2])))
          {
          wafeConvError("XmCommandAppendValue","2",argv[2],"XmString");
          DBUG_RETURN (TCL_ERROR);
          }

     XmCommandAppendValue(localVar1,localVar2);
     XmStringFree(localVar2);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XmCommandError
 * 	in: XmCommandWidget           	# command widget 
 * 	in: XmString         		# error message
 */

static int 
cmd_XmCommandError(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     XmString localVar2;

     DBUG_ENTER("XmCommandError");  

     if (argc != 3) 
	 {
	 wafeArgcError("XmCommandError","",2,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmCommandWidgetClass,"XmCommand")))
          {
          wafeConvError("XmCommandError","1",argv[1],"XmCommandWidget");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(localVar2 = (XmString) wafeCvtStringToXmString(argv[2])))
          {
          wafeConvError("XmCommandError","2",argv[2],"XmString");
          DBUG_RETURN (TCL_ERROR);
          }

     XmCommandError(localVar1,localVar2);
     XmStringFree(localVar2);

     DBUG_RETURN (TCL_OK);
     }     


#include <Xm/DialogS.h>
#include <Xm/DrawingA.h>
#include <Xm/DrawnB.h>
#include <Xm/FileSB.h>
/* 
 * WidgetID (WidgetID)
 * XmFileSelectionBoxGetChild
 * 	in: XmFileSelectionBoxWidget		# file selection box widget
 * 	in: (unsigned char)XmChild 		# child reference
 */

static int 
cmd_XmFileSelectionBoxGetChild(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     unsigned char localVar2;
     WidgetID returnVar;
     char conversionBuffer[100];

     DBUG_ENTER("XmFileSelectionBoxGetChild");  

     if (argc != 3) 
	 {
	 wafeArgcError("XmFileSelectionBoxGetChild","",2,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmFileSelectionBoxWidgetClass,"XmFileSelectionBox")))
          {
          wafeConvError("XmFileSelectionBoxGetChild","1",argv[1],"XmFileSelectionBoxWidget");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!strcmp(argv[2], "DIALOG_CANCEL_BUTTON")) 
         localVar2 = XmDIALOG_CANCEL_BUTTON;
     else
     if (!strcmp(argv[2], "DIALOG_DEFAULT_BUTTON")) 
         localVar2 = XmDIALOG_DEFAULT_BUTTON;
     else
     if (!strcmp(argv[2], "DIALOG_HELP_BUTTON")) 
         localVar2 = XmDIALOG_HELP_BUTTON;
     else
     if (!strcmp(argv[2], "DIALOG_OK_BUTTON")) 
         localVar2 = XmDIALOG_OK_BUTTON;
     else
     if (!strcmp(argv[2], "DIALOG_SEPARATOR")) 
         localVar2 = XmDIALOG_SEPARATOR;
     else
     if (!strcmp(argv[2], "DIALOG_SYMBOL_LABEL")) 
         localVar2 = XmDIALOG_SYMBOL_LABEL;
     else
     if (!strcmp(argv[2], "DIALOG_MESSAGE_LABEL")) 
         localVar2 = XmDIALOG_MESSAGE_LABEL;
     else
     if (!strcmp(argv[2], "DIALOG_APPLY_BUTTON")) 
         localVar2 = XmDIALOG_APPLY_BUTTON;
     else
     if (!strcmp(argv[2], "DIALOG_DIR_LIST")) 
         localVar2 = XmDIALOG_DIR_LIST;
     else
     if (!strcmp(argv[2], "DIALOG_DIR_LIST_LABEL")) 
         localVar2 = XmDIALOG_DIR_LIST_LABEL;
     else
     if (!strcmp(argv[2], "DIALOG_FILTER_LABEL")) 
         localVar2 = XmDIALOG_FILTER_LABEL;
     else
     if (!strcmp(argv[2], "DIALOG_FILTER_TEXT")) 
         localVar2 = XmDIALOG_FILTER_TEXT;
     else
     if (!strcmp(argv[2], "DIALOG_LIST")) 
         localVar2 = XmDIALOG_LIST;
     else
     if (!strcmp(argv[2], "DIALOG_LIST_LABEL")) 
         localVar2 = XmDIALOG_LIST_LABEL;
     else
     if (!strcmp(argv[2], "DIALOG_SELECTION_LABEL")) 
         localVar2 = XmDIALOG_SELECTION_LABEL;
     else
     if (!strcmp(argv[2], "DIALOG_TEXT")) 
         localVar2 = XmDIALOG_TEXT;
     else
     if (!strcmp(argv[2], "DIALOG_WORK_AREA")) 
         localVar2 = XmDIALOG_WORK_AREA;
     else
         {
         wafeConvError("XmFileSelectionBoxGetChild","2",argv[2],"XmChild");
         DBUG_RETURN (TCL_ERROR);
        }


     returnVar = (WidgetID) XmFileSelectionBoxGetChild(localVar1,localVar2);

     sprintf(conversionBuffer, "%ld", returnVar);
     Tcl_SetResult(comInterpreter, conversionBuffer, TCL_VOLATILE);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XmFileSelectionDoSearch
 * 	in: XmFileSelectionBoxWidget		# file selection box
 * 	in: XmString				# directory mask
 */

static int 
cmd_XmFileSelectionDoSearch(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     XmString localVar2;

     DBUG_ENTER("XmFileSelectionDoSearch");  

     if (argc != 3) 
	 {
	 wafeArgcError("XmFileSelectionDoSearch","",2,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmFileSelectionBoxWidgetClass,"XmFileSelectionBox")))
          {
          wafeConvError("XmFileSelectionDoSearch","1",argv[1],"XmFileSelectionBoxWidget");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(localVar2 = (XmString) wafeCvtStringToXmString(argv[2])))
          {
          wafeConvError("XmFileSelectionDoSearch","2",argv[2],"XmString");
          DBUG_RETURN (TCL_ERROR);
          }

     XmFileSelectionDoSearch(localVar1,localVar2);
     XmStringFree(localVar2);

     DBUG_RETURN (TCL_OK);
     }     


#include <Xm/Form.h>
#include <Xm/Frame.h>
#include <Xm/Label.h>
#include <Xm/LabelG.h>
#include <Xm/List.h>
/* 
 * void
 * XmListAddItem
 * 	in: XmListWidget	# List Widget
 * 	in: XmString		# Item to add
 * 	in: int			# Position
 */

static int 
cmd_XmListAddItem(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     XmString localVar2;
     int localVar3;

     DBUG_ENTER("XmListAddItem");  

     if (argc != 4) 
	 {
	 wafeArgcError("XmListAddItem","",3,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmListWidgetClass,"XmList")))
          {
          wafeConvError("XmListAddItem","1",argv[1],"XmListWidget");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(localVar2 = (XmString) wafeCvtStringToXmString(argv[2])))
          {
          wafeConvError("XmListAddItem","2",argv[2],"XmString");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(sscanf(argv[3], "%d", &localVar3)))
          {
          wafeConvError("XmListAddItem","3",argv[3],"int");
          DBUG_RETURN (TCL_ERROR);
          }

     XmListAddItem(localVar1,localVar2,localVar3);
     XmStringFree(localVar2);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XmListAddItems
 * 	in: XmListWidget	# List Widget
 * 	in: XmStringTable	# items
 * 	in: int			# number of items
 * 	in: int			# position
 */

static int 
cmd_XmListAddItems(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     XmStringTable localVar2;
     int localVar3;
     int localVar4;

     DBUG_ENTER("XmListAddItems");  

     if (argc != 5) 
	 {
	 wafeArgcError("XmListAddItems","",4,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmListWidgetClass,"XmList")))
          {
          wafeConvError("XmListAddItems","1",argv[1],"XmListWidget");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(localVar2 = (XmStringTable) wafeCvtStringToXmStringTable(argv[2])))
          {
          wafeConvError("XmListAddItems","2",argv[2],"XmStringTable");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(sscanf(argv[3], "%d", &localVar3)))
          {
          wafeConvError("XmListAddItems","3",argv[3],"int");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(sscanf(argv[4], "%d", &localVar4)))
          {
          wafeConvError("XmListAddItems","4",argv[4],"int");
          DBUG_RETURN (TCL_ERROR);
          }

     XmListAddItems(localVar1,localVar2,localVar3,localVar4);
     wafeFreeStringTable(localVar2);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XmListAddItemUnselected
 * 	in: XmListWidget	# List Widget
 * 	in: XmString		# Item to add
 * 	in: int			# Position
 */

static int 
cmd_XmListAddItemUnselected(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     XmString localVar2;
     int localVar3;

     DBUG_ENTER("XmListAddItemUnselected");  

     if (argc != 4) 
	 {
	 wafeArgcError("XmListAddItemUnselected","",3,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmListWidgetClass,"XmList")))
          {
          wafeConvError("XmListAddItemUnselected","1",argv[1],"XmListWidget");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(localVar2 = (XmString) wafeCvtStringToXmString(argv[2])))
          {
          wafeConvError("XmListAddItemUnselected","2",argv[2],"XmString");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(sscanf(argv[3], "%d", &localVar3)))
          {
          wafeConvError("XmListAddItemUnselected","3",argv[3],"int");
          DBUG_RETURN (TCL_ERROR);
          }

     XmListAddItemUnselected(localVar1,localVar2,localVar3);
     XmStringFree(localVar2);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XmListDeleteAllItems
 * 	in: XmListWidget	# List Widget
 */

static int 
cmd_XmListDeleteAllItems(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;

     DBUG_ENTER("XmListDeleteAllItems");  

     if (argc != 2) 
	 {
	 wafeArgcError("XmListDeleteAllItems","",1,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmListWidgetClass,"XmList")))
          {
          wafeConvError("XmListDeleteAllItems","1",argv[1],"XmListWidget");
          DBUG_RETURN (TCL_ERROR);
          }

     XmListDeleteAllItems(localVar1);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XmListDeleteItem
 * 	in: XmListWidget	# List Widget
 * 	in: XmString		# Item to delete
 */

static int 
cmd_XmListDeleteItem(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     XmString localVar2;

     DBUG_ENTER("XmListDeleteItem");  

     if (argc != 3) 
	 {
	 wafeArgcError("XmListDeleteItem","",2,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmListWidgetClass,"XmList")))
          {
          wafeConvError("XmListDeleteItem","1",argv[1],"XmListWidget");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(localVar2 = (XmString) wafeCvtStringToXmString(argv[2])))
          {
          wafeConvError("XmListDeleteItem","2",argv[2],"XmString");
          DBUG_RETURN (TCL_ERROR);
          }

     XmListDeleteItem(localVar1,localVar2);
     XmStringFree(localVar2);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XmListDeleteItems
 * 	in: XmListWidget	# List Widget
 * 	in: XmStringTable	# items
 * 	in: int			# number of items
 */

static int 
cmd_XmListDeleteItems(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     XmStringTable localVar2;
     int localVar3;

     DBUG_ENTER("XmListDeleteItems");  

     if (argc != 4) 
	 {
	 wafeArgcError("XmListDeleteItems","",3,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmListWidgetClass,"XmList")))
          {
          wafeConvError("XmListDeleteItems","1",argv[1],"XmListWidget");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(localVar2 = (XmStringTable) wafeCvtStringToXmStringTable(argv[2])))
          {
          wafeConvError("XmListDeleteItems","2",argv[2],"XmStringTable");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(sscanf(argv[3], "%d", &localVar3)))
          {
          wafeConvError("XmListDeleteItems","3",argv[3],"int");
          DBUG_RETURN (TCL_ERROR);
          }

     XmListDeleteItems(localVar1,localVar2,localVar3);
     wafeFreeStringTable(localVar2);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XmListDeleteItemsPos
 * 	in: XmListWidget	# List Widget	
 * 	in: int			# number of items
 * 	in: int			# position of first item to be deleted
 */

static int 
cmd_XmListDeleteItemsPos(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     int localVar2;
     int localVar3;

     DBUG_ENTER("XmListDeleteItemsPos");  

     if (argc != 4) 
	 {
	 wafeArgcError("XmListDeleteItemsPos","",3,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmListWidgetClass,"XmList")))
          {
          wafeConvError("XmListDeleteItemsPos","1",argv[1],"XmListWidget");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(sscanf(argv[2], "%d", &localVar2)))
          {
          wafeConvError("XmListDeleteItemsPos","2",argv[2],"int");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(sscanf(argv[3], "%d", &localVar3)))
          {
          wafeConvError("XmListDeleteItemsPos","3",argv[3],"int");
          DBUG_RETURN (TCL_ERROR);
          }

     XmListDeleteItemsPos(localVar1,localVar2,localVar3);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XmListDeletePos
 * 	in: XmListWidget	# List Widget	
 * 	in: int			# position of item
 */

static int 
cmd_XmListDeletePos(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     int localVar2;

     DBUG_ENTER("XmListDeletePos");  

     if (argc != 3) 
	 {
	 wafeArgcError("XmListDeletePos","",2,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmListWidgetClass,"XmList")))
          {
          wafeConvError("XmListDeletePos","1",argv[1],"XmListWidget");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(sscanf(argv[2], "%d", &localVar2)))
          {
          wafeConvError("XmListDeletePos","2",argv[2],"int");
          DBUG_RETURN (TCL_ERROR);
          }

     XmListDeletePos(localVar1,localVar2);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XmListDeselectAllItems
 * 	in: XmListWidget	# List Widget
 */

static int 
cmd_XmListDeselectAllItems(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;

     DBUG_ENTER("XmListDeselectAllItems");  

     if (argc != 2) 
	 {
	 wafeArgcError("XmListDeselectAllItems","",1,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmListWidgetClass,"XmList")))
          {
          wafeConvError("XmListDeselectAllItems","1",argv[1],"XmListWidget");
          DBUG_RETURN (TCL_ERROR);
          }

     XmListDeselectAllItems(localVar1);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XmListDeselectItem
 * 	in: XmListWidget	# List Widget	
 * 	in: XmString		# item
 */

static int 
cmd_XmListDeselectItem(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     XmString localVar2;

     DBUG_ENTER("XmListDeselectItem");  

     if (argc != 3) 
	 {
	 wafeArgcError("XmListDeselectItem","",2,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmListWidgetClass,"XmList")))
          {
          wafeConvError("XmListDeselectItem","1",argv[1],"XmListWidget");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(localVar2 = (XmString) wafeCvtStringToXmString(argv[2])))
          {
          wafeConvError("XmListDeselectItem","2",argv[2],"XmString");
          DBUG_RETURN (TCL_ERROR);
          }

     XmListDeselectItem(localVar1,localVar2);
     XmStringFree(localVar2);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XmListDeselectPos
 * 	in: XmListWidget	# List Widget	
 * 	in: int			# position of item
 */

static int 
cmd_XmListDeselectPos(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     int localVar2;

     DBUG_ENTER("XmListDeselectPos");  

     if (argc != 3) 
	 {
	 wafeArgcError("XmListDeselectPos","",2,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmListWidgetClass,"XmList")))
          {
          wafeConvError("XmListDeselectPos","1",argv[1],"XmListWidget");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(sscanf(argv[2], "%d", &localVar2)))
          {
          wafeConvError("XmListDeselectPos","2",argv[2],"int");
          DBUG_RETURN (TCL_ERROR);
          }

     XmListDeselectPos(localVar1,localVar2);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * Boolean                          
 * XmListGetMatchPos
 * 	in: XmListWidget	# List Widget   
 * 	in: XmString		# item
 * 	out: list(int*,int)	# list of positions
 */

static int 
cmd_XmListGetMatchPos(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     XmString localVar2;
     int* localVar3list;
     int localVar3count;
     Boolean returnVar;
     char conversionBuffer[100];

     DBUG_ENTER("XmListGetMatchPos");  

     if (argc != 4) 
	 {
	 wafeArgcError("XmListGetMatchPos","",3,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmListWidgetClass,"XmList")))
          {
          wafeConvError("XmListGetMatchPos","1",argv[1],"XmListWidget");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(localVar2 = (XmString) wafeCvtStringToXmString(argv[2])))
          {
          wafeConvError("XmListGetMatchPos","2",argv[2],"XmString");
          DBUG_RETURN (TCL_ERROR);
          }

     returnVar = XmListGetMatchPos(localVar1,localVar2,&localVar3list, &localVar3count);
     XmStringFree(localVar2);

     
     Tcl_SetVar(wafeInterpreter, argv[3], wafeCvtIntsToTcl(NULL,localVar3count,localVar3list), 0);

          if (returnVar == 0) 
          strcpy(conversionBuffer, "false");
     else
     if (returnVar == 1) 
          strcpy(conversionBuffer, "true");


     Tcl_SetResult(comInterpreter, conversionBuffer, TCL_VOLATILE);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * Boolean
 * XmListGetSelectedPos
 * 	in: XmListWidget	# List Widget
 * 	out: list(int*,int)     # list of highlighted items
 */

static int 
cmd_XmListGetSelectedPos(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     int* localVar2list;
     int localVar2count;
     Boolean returnVar;
     char conversionBuffer[100];

     DBUG_ENTER("XmListGetSelectedPos");  

     if (argc != 3) 
	 {
	 wafeArgcError("XmListGetSelectedPos","",2,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmListWidgetClass,"XmList")))
          {
          wafeConvError("XmListGetSelectedPos","1",argv[1],"XmListWidget");
          DBUG_RETURN (TCL_ERROR);
          }

     returnVar = XmListGetSelectedPos(localVar1,&localVar2list, &localVar2count);

     
     Tcl_SetVar(wafeInterpreter, argv[2], wafeCvtIntsToTcl(NULL,localVar2count,localVar2list), 0);

          if (returnVar == 0) 
          strcpy(conversionBuffer, "false");
     else
     if (returnVar == 1) 
          strcpy(conversionBuffer, "true");


     Tcl_SetResult(comInterpreter, conversionBuffer, TCL_VOLATILE);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * Boolean
 * XmListItemExists
 * 	in: XmListWidget	# List Widget
 * 	in: XmString		# Item
 */

static int 
cmd_XmListItemExists(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     XmString localVar2;
     Boolean returnVar;
     char conversionBuffer[100];

     DBUG_ENTER("XmListItemExists");  

     if (argc != 3) 
	 {
	 wafeArgcError("XmListItemExists","",2,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmListWidgetClass,"XmList")))
          {
          wafeConvError("XmListItemExists","1",argv[1],"XmListWidget");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(localVar2 = (XmString) wafeCvtStringToXmString(argv[2])))
          {
          wafeConvError("XmListItemExists","2",argv[2],"XmString");
          DBUG_RETURN (TCL_ERROR);
          }

     returnVar = XmListItemExists(localVar1,localVar2);
     XmStringFree(localVar2);

          if (returnVar == 0) 
          strcpy(conversionBuffer, "false");
     else
     if (returnVar == 1) 
          strcpy(conversionBuffer, "true");


     Tcl_SetResult(comInterpreter, conversionBuffer, TCL_VOLATILE);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * int
 * XmListItemPos
 * 	in: XmListWidget	# List Widget
 * 	in: XmString		# Item
 */

static int 
cmd_XmListItemPos(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     XmString localVar2;
     int returnVar;
     char conversionBuffer[100];

     DBUG_ENTER("XmListItemPos");  

     if (argc != 3) 
	 {
	 wafeArgcError("XmListItemPos","",2,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmListWidgetClass,"XmList")))
          {
          wafeConvError("XmListItemPos","1",argv[1],"XmListWidget");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(localVar2 = (XmString) wafeCvtStringToXmString(argv[2])))
          {
          wafeConvError("XmListItemPos","2",argv[2],"XmString");
          DBUG_RETURN (TCL_ERROR);
          }

     returnVar = XmListItemPos(localVar1,localVar2);
     XmStringFree(localVar2);

     sprintf(conversionBuffer, "%d", returnVar);
     Tcl_SetResult(comInterpreter, conversionBuffer, TCL_VOLATILE);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XmListReplaceItems
 * 	in: XmListWidget	# List Widget
 * 	in: XmStringTable	# Items to be replaced
 * 	in: int			# number of items to be replaced
 * 	in: XmStringTable	# new items
 */

static int 
cmd_XmListReplaceItems(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     XmStringTable localVar2;
     int localVar3;
     XmStringTable localVar4;

     DBUG_ENTER("XmListReplaceItems");  

     if (argc != 5) 
	 {
	 wafeArgcError("XmListReplaceItems","",4,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmListWidgetClass,"XmList")))
          {
          wafeConvError("XmListReplaceItems","1",argv[1],"XmListWidget");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(localVar2 = (XmStringTable) wafeCvtStringToXmStringTable(argv[2])))
          {
          wafeConvError("XmListReplaceItems","2",argv[2],"XmStringTable");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(sscanf(argv[3], "%d", &localVar3)))
          {
          wafeConvError("XmListReplaceItems","3",argv[3],"int");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(localVar4 = (XmStringTable) wafeCvtStringToXmStringTable(argv[4])))
          {
          wafeConvError("XmListReplaceItems","4",argv[4],"XmStringTable");
          DBUG_RETURN (TCL_ERROR);
          }

     XmListReplaceItems(localVar1,localVar2,localVar3,localVar4);
     wafeFreeStringTable(localVar2);
     wafeFreeStringTable(localVar4);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XmListReplaceItemsPos
 * 	in: XmListWidget	# List Widget
 * 	in: XmStringTable	# New items
 * 	in: int			# number of items to be replaced
 * 	in: int 		# first Pos of items to be replaced
 */

static int 
cmd_XmListReplaceItemsPos(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     XmStringTable localVar2;
     int localVar3;
     int localVar4;

     DBUG_ENTER("XmListReplaceItemsPos");  

     if (argc != 5) 
	 {
	 wafeArgcError("XmListReplaceItemsPos","",4,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmListWidgetClass,"XmList")))
          {
          wafeConvError("XmListReplaceItemsPos","1",argv[1],"XmListWidget");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(localVar2 = (XmStringTable) wafeCvtStringToXmStringTable(argv[2])))
          {
          wafeConvError("XmListReplaceItemsPos","2",argv[2],"XmStringTable");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(sscanf(argv[3], "%d", &localVar3)))
          {
          wafeConvError("XmListReplaceItemsPos","3",argv[3],"int");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(sscanf(argv[4], "%d", &localVar4)))
          {
          wafeConvError("XmListReplaceItemsPos","4",argv[4],"int");
          DBUG_RETURN (TCL_ERROR);
          }

     XmListReplaceItemsPos(localVar1,localVar2,localVar3,localVar4);
     wafeFreeStringTable(localVar2);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XmListSelectItem
 * 	in: XmListWidget	# List Widget
 * 	in: XmString		# item to highlight
 * 	in: Boolean		# Invoke callback yes/no
 */

static int 
cmd_XmListSelectItem(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     XmString localVar2;
     Boolean localVar3;

     DBUG_ENTER("XmListSelectItem");  

     if (argc != 4) 
	 {
	 wafeArgcError("XmListSelectItem","",3,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmListWidgetClass,"XmList")))
          {
          wafeConvError("XmListSelectItem","1",argv[1],"XmListWidget");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(localVar2 = (XmString) wafeCvtStringToXmString(argv[2])))
          {
          wafeConvError("XmListSelectItem","2",argv[2],"XmString");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!strcmp(argv[3], "false")) 
         localVar3 = 0;
     else
     if (!strcmp(argv[3], "true")) 
         localVar3 = 1;
     else
         {
         wafeConvError("XmListSelectItem","3",argv[3],"Boolean");
         DBUG_RETURN (TCL_ERROR);
        }


     XmListSelectItem(localVar1,localVar2,localVar3);
     XmStringFree(localVar2);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XmListSelectPos
 * 	in: XmListWidget	# List Widget
 * 	in: int			# Position of item 
 * 	in: Boolean		# Invoke callback yes/no
 */

static int 
cmd_XmListSelectPos(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     int localVar2;
     Boolean localVar3;

     DBUG_ENTER("XmListSelectPos");  

     if (argc != 4) 
	 {
	 wafeArgcError("XmListSelectPos","",3,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmListWidgetClass,"XmList")))
          {
          wafeConvError("XmListSelectPos","1",argv[1],"XmListWidget");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(sscanf(argv[2], "%d", &localVar2)))
          {
          wafeConvError("XmListSelectPos","2",argv[2],"int");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!strcmp(argv[3], "false")) 
         localVar3 = 0;
     else
     if (!strcmp(argv[3], "true")) 
         localVar3 = 1;
     else
         {
         wafeConvError("XmListSelectPos","3",argv[3],"Boolean");
         DBUG_RETURN (TCL_ERROR);
        }


     XmListSelectPos(localVar1,localVar2,localVar3);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XmListSetAddMode
 * 	in: XmListWidget 	# List Widget
 * 	in: Boolean		# Use Add Mode yes/no
 */

static int 
cmd_XmListSetAddMode(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     Boolean localVar2;

     DBUG_ENTER("XmListSetAddMode");  

     if (argc != 3) 
	 {
	 wafeArgcError("XmListSetAddMode","",2,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmListWidgetClass,"XmList")))
          {
          wafeConvError("XmListSetAddMode","1",argv[1],"XmListWidget");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!strcmp(argv[2], "false")) 
         localVar2 = 0;
     else
     if (!strcmp(argv[2], "true")) 
         localVar2 = 1;
     else
         {
         wafeConvError("XmListSetAddMode","2",argv[2],"Boolean");
         DBUG_RETURN (TCL_ERROR);
        }


     XmListSetAddMode(localVar1,localVar2);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XmListSetBottomItem	
 * 	in: XmListWidget 	# List Widget
 * 	in: XmString		# item to be displayed as last item
 */

static int 
cmd_XmListSetBottomItem(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     XmString localVar2;

     DBUG_ENTER("XmListSetBottomItem");  

     if (argc != 3) 
	 {
	 wafeArgcError("XmListSetBottomItem","",2,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmListWidgetClass,"XmList")))
          {
          wafeConvError("XmListSetBottomItem","1",argv[1],"XmListWidget");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(localVar2 = (XmString) wafeCvtStringToXmString(argv[2])))
          {
          wafeConvError("XmListSetBottomItem","2",argv[2],"XmString");
          DBUG_RETURN (TCL_ERROR);
          }

     XmListSetBottomItem(localVar1,localVar2);
     XmStringFree(localVar2);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XmListSetBottomPos
 * 	in: XmListWidget 	# List Widget
 * 	in: int			# item to be displayed as last item
 */

static int 
cmd_XmListSetBottomPos(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     int localVar2;

     DBUG_ENTER("XmListSetBottomPos");  

     if (argc != 3) 
	 {
	 wafeArgcError("XmListSetBottomPos","",2,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmListWidgetClass,"XmList")))
          {
          wafeConvError("XmListSetBottomPos","1",argv[1],"XmListWidget");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(sscanf(argv[2], "%d", &localVar2)))
          {
          wafeConvError("XmListSetBottomPos","2",argv[2],"int");
          DBUG_RETURN (TCL_ERROR);
          }

     XmListSetBottomPos(localVar1,localVar2);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XmListSetHorizPos
 * 	in: XmListWidget 	# List Widget
 * 	in: int			# horizontal Position
 */

static int 
cmd_XmListSetHorizPos(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     int localVar2;

     DBUG_ENTER("XmListSetHorizPos");  

     if (argc != 3) 
	 {
	 wafeArgcError("XmListSetHorizPos","",2,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmListWidgetClass,"XmList")))
          {
          wafeConvError("XmListSetHorizPos","1",argv[1],"XmListWidget");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(sscanf(argv[2], "%d", &localVar2)))
          {
          wafeConvError("XmListSetHorizPos","2",argv[2],"int");
          DBUG_RETURN (TCL_ERROR);
          }

     XmListSetHorizPos(localVar1,localVar2);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XmListSetItem
 * 	in: XmListWidget 	# List Widget
 * 	in: XmString		# item
 */

static int 
cmd_XmListSetItem(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     XmString localVar2;

     DBUG_ENTER("XmListSetItem");  

     if (argc != 3) 
	 {
	 wafeArgcError("XmListSetItem","",2,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmListWidgetClass,"XmList")))
          {
          wafeConvError("XmListSetItem","1",argv[1],"XmListWidget");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(localVar2 = (XmString) wafeCvtStringToXmString(argv[2])))
          {
          wafeConvError("XmListSetItem","2",argv[2],"XmString");
          DBUG_RETURN (TCL_ERROR);
          }

     XmListSetItem(localVar1,localVar2);
     XmStringFree(localVar2);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XmListSetPos
 * 	in: XmListWidget 	# List Widget
 * 	in: int			# Position
 */

static int 
cmd_XmListSetPos(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     int localVar2;

     DBUG_ENTER("XmListSetPos");  

     if (argc != 3) 
	 {
	 wafeArgcError("XmListSetPos","",2,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmListWidgetClass,"XmList")))
          {
          wafeConvError("XmListSetPos","1",argv[1],"XmListWidget");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(sscanf(argv[2], "%d", &localVar2)))
          {
          wafeConvError("XmListSetPos","2",argv[2],"int");
          DBUG_RETURN (TCL_ERROR);
          }

     XmListSetPos(localVar1,localVar2);

     DBUG_RETURN (TCL_OK);
     }     


#include <Xm/MainW.h>
/* 
 * void
 * XmMainWindowSetAreas
 * 	in: NULL | Widget	# main window widget
 * 	in: NULL | Widget	# menu bar widget
 * 	in: NULL | Widget	# command window widget
 * 	in: NULL | Widget	# horizontal scrollbar widget
 * 	in: NULL | Widget	# vertical scrollbar widget
 * 	in: NULL | Widget	# work region widget
 */

static int 
cmd_XmMainWindowSetAreas(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     Widget localVar2;
     Widget localVar3;
     Widget localVar4;
     Widget localVar5;
     Widget localVar6;

     DBUG_ENTER("XmMainWindowSetAreas");  

     if (argc != 7) 
	 {
	 wafeArgcError("XmMainWindowSetAreas","",6,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!strcmp(argv[1], "NULL")) 
         localVar1 = NULL;
     else
         if (!(localVar1 = (Widget) name2Widget(argv[1])))
          {
          wafeConvError("XmMainWindowSetAreas","1",argv[1],"Widget");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!strcmp(argv[2], "NULL")) 
         localVar2 = NULL;
     else
         if (!(localVar2 = (Widget) name2Widget(argv[2])))
          {
          wafeConvError("XmMainWindowSetAreas","2",argv[2],"Widget");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!strcmp(argv[3], "NULL")) 
         localVar3 = NULL;
     else
         if (!(localVar3 = (Widget) name2Widget(argv[3])))
          {
          wafeConvError("XmMainWindowSetAreas","3",argv[3],"Widget");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!strcmp(argv[4], "NULL")) 
         localVar4 = NULL;
     else
         if (!(localVar4 = (Widget) name2Widget(argv[4])))
          {
          wafeConvError("XmMainWindowSetAreas","4",argv[4],"Widget");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!strcmp(argv[5], "NULL")) 
         localVar5 = NULL;
     else
         if (!(localVar5 = (Widget) name2Widget(argv[5])))
          {
          wafeConvError("XmMainWindowSetAreas","5",argv[5],"Widget");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!strcmp(argv[6], "NULL")) 
         localVar6 = NULL;
     else
         if (!(localVar6 = (Widget) name2Widget(argv[6])))
          {
          wafeConvError("XmMainWindowSetAreas","6",argv[6],"Widget");
          DBUG_RETURN (TCL_ERROR);
          }

     XmMainWindowSetAreas(localVar1,localVar2,localVar3,localVar4,localVar5,localVar6);

     DBUG_RETURN (TCL_OK);
     }     


#include <Xm/MenuShell.h>
#include <Xm/MessageB.h>
/* 
 * WidgetID (WidgetID)
 * XmMessageBoxGetChild
 * 	in: XmMessageBoxWidget		# message box widget
 * 	in: (unsigned char)XmChild 	# child reference
 */

static int 
cmd_XmMessageBoxGetChild(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     unsigned char localVar2;
     WidgetID returnVar;
     char conversionBuffer[100];

     DBUG_ENTER("XmMessageBoxGetChild");  

     if (argc != 3) 
	 {
	 wafeArgcError("XmMessageBoxGetChild","",2,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmMessageBoxWidgetClass,"XmMessageBox")))
          {
          wafeConvError("XmMessageBoxGetChild","1",argv[1],"XmMessageBoxWidget");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!strcmp(argv[2], "DIALOG_CANCEL_BUTTON")) 
         localVar2 = XmDIALOG_CANCEL_BUTTON;
     else
     if (!strcmp(argv[2], "DIALOG_DEFAULT_BUTTON")) 
         localVar2 = XmDIALOG_DEFAULT_BUTTON;
     else
     if (!strcmp(argv[2], "DIALOG_HELP_BUTTON")) 
         localVar2 = XmDIALOG_HELP_BUTTON;
     else
     if (!strcmp(argv[2], "DIALOG_OK_BUTTON")) 
         localVar2 = XmDIALOG_OK_BUTTON;
     else
     if (!strcmp(argv[2], "DIALOG_SEPARATOR")) 
         localVar2 = XmDIALOG_SEPARATOR;
     else
     if (!strcmp(argv[2], "DIALOG_SYMBOL_LABEL")) 
         localVar2 = XmDIALOG_SYMBOL_LABEL;
     else
     if (!strcmp(argv[2], "DIALOG_MESSAGE_LABEL")) 
         localVar2 = XmDIALOG_MESSAGE_LABEL;
     else
     if (!strcmp(argv[2], "DIALOG_APPLY_BUTTON")) 
         localVar2 = XmDIALOG_APPLY_BUTTON;
     else
     if (!strcmp(argv[2], "DIALOG_DIR_LIST")) 
         localVar2 = XmDIALOG_DIR_LIST;
     else
     if (!strcmp(argv[2], "DIALOG_DIR_LIST_LABEL")) 
         localVar2 = XmDIALOG_DIR_LIST_LABEL;
     else
     if (!strcmp(argv[2], "DIALOG_FILTER_LABEL")) 
         localVar2 = XmDIALOG_FILTER_LABEL;
     else
     if (!strcmp(argv[2], "DIALOG_FILTER_TEXT")) 
         localVar2 = XmDIALOG_FILTER_TEXT;
     else
     if (!strcmp(argv[2], "DIALOG_LIST")) 
         localVar2 = XmDIALOG_LIST;
     else
     if (!strcmp(argv[2], "DIALOG_LIST_LABEL")) 
         localVar2 = XmDIALOG_LIST_LABEL;
     else
     if (!strcmp(argv[2], "DIALOG_SELECTION_LABEL")) 
         localVar2 = XmDIALOG_SELECTION_LABEL;
     else
     if (!strcmp(argv[2], "DIALOG_TEXT")) 
         localVar2 = XmDIALOG_TEXT;
     else
     if (!strcmp(argv[2], "DIALOG_WORK_AREA")) 
         localVar2 = XmDIALOG_WORK_AREA;
     else
         {
         wafeConvError("XmMessageBoxGetChild","2",argv[2],"XmChild");
         DBUG_RETURN (TCL_ERROR);
        }


     returnVar = (WidgetID) XmMessageBoxGetChild(localVar1,localVar2);

     sprintf(conversionBuffer, "%ld", returnVar);
     Tcl_SetResult(comInterpreter, conversionBuffer, TCL_VOLATILE);

     DBUG_RETURN (TCL_OK);
     }     


#include <Xm/PanedW.h>
#include <Xm/PushB.h>
#include <Xm/PushBG.h>
#include <Xm/RowColumn.h>
#include <Xm/Scale.h>
#include <Xm/ScrollBar.h>
/* 
 * void
 * XmScrollBarGetValues 
 * 	in: XmScrollBarWidget		# scrollbar widget
 * 	out: int	      		# value (slider position)
 *         out: int              		# slider size
 * 	out: int              		# increment (smallest movement)
 * 	out: int              		# page increment
 */

static int 
cmd_XmScrollBarGetValues(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     int localVar2;
     int localVar3;
     int localVar4;
     int localVar5;
     char conversionBuffer[100];

     DBUG_ENTER("XmScrollBarGetValues");  

     if (argc != 6) 
	 {
	 wafeArgcError("XmScrollBarGetValues","",5,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmScrollBarWidgetClass,"XmScrollBar")))
          {
          wafeConvError("XmScrollBarGetValues","1",argv[1],"XmScrollBarWidget");
          DBUG_RETURN (TCL_ERROR);
          }

     XmScrollBarGetValues(localVar1,&localVar2,&localVar3,&localVar4,&localVar5);

     sprintf(conversionBuffer, "%d", localVar2);
     Tcl_SetVar(wafeInterpreter, argv[2], conversionBuffer, 0);

     sprintf(conversionBuffer, "%d", localVar3);
     Tcl_SetVar(wafeInterpreter, argv[3], conversionBuffer, 0);

     sprintf(conversionBuffer, "%d", localVar4);
     Tcl_SetVar(wafeInterpreter, argv[4], conversionBuffer, 0);

     sprintf(conversionBuffer, "%d", localVar5);
     Tcl_SetVar(wafeInterpreter, argv[5], conversionBuffer, 0);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XmScrollBarSetValues 
 * 	in: XmScrollBarWidget 		# scrollbar widget
 * 	in: int	              		# value (slider position)
 *         in: int               		# slider size
 * 	in: int               		# increment (smallest movement)
 * 	in: int               		# page increment 
 * 	in: Boolean           		# notify
 */

static int 
cmd_XmScrollBarSetValues(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     int localVar2;
     int localVar3;
     int localVar4;
     int localVar5;
     Boolean localVar6;

     DBUG_ENTER("XmScrollBarSetValues");  

     if (argc != 7) 
	 {
	 wafeArgcError("XmScrollBarSetValues","",6,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmScrollBarWidgetClass,"XmScrollBar")))
          {
          wafeConvError("XmScrollBarSetValues","1",argv[1],"XmScrollBarWidget");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(sscanf(argv[2], "%d", &localVar2)))
          {
          wafeConvError("XmScrollBarSetValues","2",argv[2],"int");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(sscanf(argv[3], "%d", &localVar3)))
          {
          wafeConvError("XmScrollBarSetValues","3",argv[3],"int");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(sscanf(argv[4], "%d", &localVar4)))
          {
          wafeConvError("XmScrollBarSetValues","4",argv[4],"int");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(sscanf(argv[5], "%d", &localVar5)))
          {
          wafeConvError("XmScrollBarSetValues","5",argv[5],"int");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!strcmp(argv[6], "false")) 
         localVar6 = 0;
     else
     if (!strcmp(argv[6], "true")) 
         localVar6 = 1;
     else
         {
         wafeConvError("XmScrollBarSetValues","6",argv[6],"Boolean");
         DBUG_RETURN (TCL_ERROR);
        }


     XmScrollBarSetValues(localVar1,localVar2,localVar3,localVar4,localVar5,localVar6);

     DBUG_RETURN (TCL_OK);
     }     


#include <Xm/ScrolledW.h>
#include <Xm/SelectioB.h>
#include <Xm/Separator.h>
#include <Xm/SeparatoG.h>
#include <Xm/Text.h>
/* 
 * void
 * XmTextClearSelection
 * 	in: XmTextWidget 	# Text widget
 * 	const: time(NULL)
 */

static int 
cmd_XmTextClearSelection(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;

     DBUG_ENTER("XmTextClearSelection");  

     if (argc != 2) 
	 {
	 wafeArgcError("XmTextClearSelection","",1,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmTextWidgetClass,"XmText")))
          {
          wafeConvError("XmTextClearSelection","1",argv[1],"XmTextWidget");
          DBUG_RETURN (TCL_ERROR);
          }

     XmTextClearSelection(localVar1,time(NULL));

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XmTextCopy
 * 	in: XmTextWidget 	# Text widget
 * 	const: time(NULL)
 */

static int 
cmd_XmTextCopy(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;

     DBUG_ENTER("XmTextCopy");  

     if (argc != 2) 
	 {
	 wafeArgcError("XmTextCopy","",1,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmTextWidgetClass,"XmText")))
          {
          wafeConvError("XmTextCopy","1",argv[1],"XmTextWidget");
          DBUG_RETURN (TCL_ERROR);
          }

     XmTextCopy(localVar1,time(NULL));

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XmTextCut
 * 	in: XmTextWidget 	# Text widget
 * 	const: time(NULL)
 */

static int 
cmd_XmTextCut(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;

     DBUG_ENTER("XmTextCut");  

     if (argc != 2) 
	 {
	 wafeArgcError("XmTextCut","",1,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmTextWidgetClass,"XmText")))
          {
          wafeConvError("XmTextCut","1",argv[1],"XmTextWidget");
          DBUG_RETURN (TCL_ERROR);
          }

     XmTextCut(localVar1,time(NULL));

     DBUG_RETURN (TCL_OK);
     }     


#include <Xm/TextF.h>
/* 
 * void
 * XmTextFieldClearSelection
 * 	in: XmTextFieldWidget 	# Text field widget
 * 	const: time(NULL)
 */

static int 
cmd_XmTextFieldClearSelection(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;

     DBUG_ENTER("XmTextFieldClearSelection");  

     if (argc != 2) 
	 {
	 wafeArgcError("XmTextFieldClearSelection","",1,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmTextFieldWidgetClass,"XmTextField")))
          {
          wafeConvError("XmTextFieldClearSelection","1",argv[1],"XmTextFieldWidget");
          DBUG_RETURN (TCL_ERROR);
          }

     XmTextFieldClearSelection(localVar1,time(NULL));

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XmTextFieldCopy
 * 	in: XmTextFieldWidget 		# Text field widget
 * 	const: time(NULL)
 */

static int 
cmd_XmTextFieldCopy(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;

     DBUG_ENTER("XmTextFieldCopy");  

     if (argc != 2) 
	 {
	 wafeArgcError("XmTextFieldCopy","",1,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmTextFieldWidgetClass,"XmTextField")))
          {
          wafeConvError("XmTextFieldCopy","1",argv[1],"XmTextFieldWidget");
          DBUG_RETURN (TCL_ERROR);
          }

     XmTextFieldCopy(localVar1,time(NULL));

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XmTextFieldCut
 * 	in: XmTextFieldWidget 		# Text field widget
 * 	const: time(NULL)
 */

static int 
cmd_XmTextFieldCut(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;

     DBUG_ENTER("XmTextFieldCut");  

     if (argc != 2) 
	 {
	 wafeArgcError("XmTextFieldCut","",1,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmTextFieldWidgetClass,"XmTextField")))
          {
          wafeConvError("XmTextFieldCut","1",argv[1],"XmTextFieldWidget");
          DBUG_RETURN (TCL_ERROR);
          }

     XmTextFieldCut(localVar1,time(NULL));

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * int
 * XmTextFieldGetBaseline
 * 	in: XmTextFieldWidget 		# Text field widget
 */

static int 
cmd_XmTextFieldGetBaseline(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     int returnVar;
     char conversionBuffer[100];

     DBUG_ENTER("XmTextFieldGetBaseline");  

     if (argc != 2) 
	 {
	 wafeArgcError("XmTextFieldGetBaseline","",1,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmTextFieldWidgetClass,"XmTextField")))
          {
          wafeConvError("XmTextFieldGetBaseline","1",argv[1],"XmTextFieldWidget");
          DBUG_RETURN (TCL_ERROR);
          }

     returnVar = XmTextFieldGetBaseline(localVar1);

     sprintf(conversionBuffer, "%d", returnVar);
     Tcl_SetResult(comInterpreter, conversionBuffer, TCL_VOLATILE);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * XmTextPosition
 * XmTextFieldGetLastPosition
 * 	in: XmTextFieldWidget 		# Text field widget
 */

static int 
cmd_XmTextFieldGetLastPosition(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     XmTextPosition returnVar;
     char conversionBuffer[100];

     DBUG_ENTER("XmTextFieldGetLastPosition");  

     if (argc != 2) 
	 {
	 wafeArgcError("XmTextFieldGetLastPosition","",1,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmTextFieldWidgetClass,"XmTextField")))
          {
          wafeConvError("XmTextFieldGetLastPosition","1",argv[1],"XmTextFieldWidget");
          DBUG_RETURN (TCL_ERROR);
          }

     returnVar = XmTextFieldGetLastPosition(localVar1);

     sprintf(conversionBuffer, "%ld", returnVar);
     Tcl_SetResult(comInterpreter, conversionBuffer, TCL_VOLATILE);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * String
 * XmTextFieldGetSelection
 * 	in: XmTextFieldWidget 		# Text field widget
 * 	end: if (!returnVar) XtFree(returnVar);
 */

static int 
cmd_XmTextFieldGetSelection(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     String returnVar;

     DBUG_ENTER("XmTextFieldGetSelection");  

     if (argc != 2) 
	 {
	 wafeArgcError("XmTextFieldGetSelection","",1,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmTextFieldWidgetClass,"XmTextField")))
          {
          wafeConvError("XmTextFieldGetSelection","1",argv[1],"XmTextFieldWidget");
          DBUG_RETURN (TCL_ERROR);
          }

     returnVar = XmTextFieldGetSelection(localVar1);

     
     Tcl_SetResult(comInterpreter, returnVar, TCL_VOLATILE);

     if (!returnVar) XtFree(returnVar);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * Boolean
 * XmTextFieldGetSelectionPosition
 * 	in: XmTextFieldWidget 	# Text field widget
 * 	out: XmTextPosition	# left boundary
 * 	out: XmTextPosition     # right boundary
 */

static int 
cmd_XmTextFieldGetSelectionPosition(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     XmTextPosition localVar2;
     XmTextPosition localVar3;
     Boolean returnVar;
     char conversionBuffer[100];

     DBUG_ENTER("XmTextFieldGetSelectionPosition");  

     if (argc != 4) 
	 {
	 wafeArgcError("XmTextFieldGetSelectionPosition","",3,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmTextFieldWidgetClass,"XmTextField")))
          {
          wafeConvError("XmTextFieldGetSelectionPosition","1",argv[1],"XmTextFieldWidget");
          DBUG_RETURN (TCL_ERROR);
          }

     returnVar = XmTextFieldGetSelectionPosition(localVar1,&localVar2,&localVar3);

     sprintf(conversionBuffer, "%ld", localVar2);
     Tcl_SetVar(wafeInterpreter, argv[2], conversionBuffer, 0);

     sprintf(conversionBuffer, "%ld", localVar3);
     Tcl_SetVar(wafeInterpreter, argv[3], conversionBuffer, 0);

          if (returnVar == 0) 
          strcpy(conversionBuffer, "false");
     else
     if (returnVar == 1) 
          strcpy(conversionBuffer, "true");


     Tcl_SetResult(comInterpreter, conversionBuffer, TCL_VOLATILE);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XmTextFieldInsert
 * 	in: XmTextFieldWidget 	# Text field widget
 * 	in: XmTextPosition	# character position
 * 	in: String              # text string to be inserted
 */

static int 
cmd_XmTextFieldInsert(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     XmTextPosition localVar2;

     DBUG_ENTER("XmTextFieldInsert");  

     if (argc != 4) 
	 {
	 wafeArgcError("XmTextFieldInsert","",3,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmTextFieldWidgetClass,"XmTextField")))
          {
          wafeConvError("XmTextFieldInsert","1",argv[1],"XmTextFieldWidget");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(sscanf(argv[2], "%ld", &localVar2)))
          {
          wafeConvError("XmTextFieldInsert","2",argv[2],"XmTextPosition");
          DBUG_RETURN (TCL_ERROR);
          }

    /* no need to assign  << localVar3 = argv[3] >>  */ 

     XmTextFieldInsert(localVar1,localVar2,argv[3]);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XmTextFieldPaste
 * 	in: XmTextFieldWidget 	# Text field widget
 */

static int 
cmd_XmTextFieldPaste(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;

     DBUG_ENTER("XmTextFieldPaste");  

     if (argc != 2) 
	 {
	 wafeArgcError("XmTextFieldPaste","",1,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmTextFieldWidgetClass,"XmTextField")))
          {
          wafeConvError("XmTextFieldPaste","1",argv[1],"XmTextFieldWidget");
          DBUG_RETURN (TCL_ERROR);
          }

     XmTextFieldPaste(localVar1);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * Boolean
 * XmTextFieldPosToXY
 * 	in: XmTextFieldWidget 	# Text field widget
 * 	in: XmTextPosition	# character position
 * 	out: Position		# x coord relative to top left
 * 	out: Position		# y coord relative to top left
 */

static int 
cmd_XmTextFieldPosToXY(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     XmTextPosition localVar2;
     Position localVar3;
     Position localVar4;
     Boolean returnVar;
     char conversionBuffer[100];

     DBUG_ENTER("XmTextFieldPosToXY");  

     if (argc != 5) 
	 {
	 wafeArgcError("XmTextFieldPosToXY","",4,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmTextFieldWidgetClass,"XmTextField")))
          {
          wafeConvError("XmTextFieldPosToXY","1",argv[1],"XmTextFieldWidget");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(sscanf(argv[2], "%ld", &localVar2)))
          {
          wafeConvError("XmTextFieldPosToXY","2",argv[2],"XmTextPosition");
          DBUG_RETURN (TCL_ERROR);
          }

     returnVar = XmTextFieldPosToXY(localVar1,localVar2,&localVar3,&localVar4);

     sprintf(conversionBuffer, "%hd", localVar3);
     Tcl_SetVar(wafeInterpreter, argv[3], conversionBuffer, 0);

     sprintf(conversionBuffer, "%hd", localVar4);
     Tcl_SetVar(wafeInterpreter, argv[4], conversionBuffer, 0);

          if (returnVar == 0) 
          strcpy(conversionBuffer, "false");
     else
     if (returnVar == 1) 
          strcpy(conversionBuffer, "true");


     Tcl_SetResult(comInterpreter, conversionBuffer, TCL_VOLATILE);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * Boolean
 * XmTextFieldRemove
 * 	in: XmTextFieldWidget 	# Text field widget
 */

static int 
cmd_XmTextFieldRemove(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     Boolean returnVar;
     char conversionBuffer[100];

     DBUG_ENTER("XmTextFieldRemove");  

     if (argc != 2) 
	 {
	 wafeArgcError("XmTextFieldRemove","",1,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmTextFieldWidgetClass,"XmTextField")))
          {
          wafeConvError("XmTextFieldRemove","1",argv[1],"XmTextFieldWidget");
          DBUG_RETURN (TCL_ERROR);
          }

     returnVar = XmTextFieldRemove(localVar1);

          if (returnVar == 0) 
          strcpy(conversionBuffer, "false");
     else
     if (returnVar == 1) 
          strcpy(conversionBuffer, "true");


     Tcl_SetResult(comInterpreter, conversionBuffer, TCL_VOLATILE);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XmTextFieldReplace
 * 	in: XmTextFieldWidget 	# Text field widget
 * 	in: XmTextPosition	# from character position
 * 	in: XmTextPosition	# to character position
 * 	in: String 		# insert string
 */

static int 
cmd_XmTextFieldReplace(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     XmTextPosition localVar2;
     XmTextPosition localVar3;

     DBUG_ENTER("XmTextFieldReplace");  

     if (argc != 5) 
	 {
	 wafeArgcError("XmTextFieldReplace","",4,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmTextFieldWidgetClass,"XmTextField")))
          {
          wafeConvError("XmTextFieldReplace","1",argv[1],"XmTextFieldWidget");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(sscanf(argv[2], "%ld", &localVar2)))
          {
          wafeConvError("XmTextFieldReplace","2",argv[2],"XmTextPosition");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(sscanf(argv[3], "%ld", &localVar3)))
          {
          wafeConvError("XmTextFieldReplace","3",argv[3],"XmTextPosition");
          DBUG_RETURN (TCL_ERROR);
          }

    /* no need to assign  << localVar4 = argv[4] >>  */ 

     XmTextFieldReplace(localVar1,localVar2,localVar3,argv[4]);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XmTextFieldSetAddMode
 * 	in: XmTextFieldWidget 	# Text field widget
 * 	in: Boolean		# true | false
 */

static int 
cmd_XmTextFieldSetAddMode(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     Boolean localVar2;

     DBUG_ENTER("XmTextFieldSetAddMode");  

     if (argc != 3) 
	 {
	 wafeArgcError("XmTextFieldSetAddMode","",2,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmTextFieldWidgetClass,"XmTextField")))
          {
          wafeConvError("XmTextFieldSetAddMode","1",argv[1],"XmTextFieldWidget");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!strcmp(argv[2], "false")) 
         localVar2 = 0;
     else
     if (!strcmp(argv[2], "true")) 
         localVar2 = 1;
     else
         {
         wafeConvError("XmTextFieldSetAddMode","2",argv[2],"Boolean");
         DBUG_RETURN (TCL_ERROR);
        }


     XmTextFieldSetAddMode(localVar1,localVar2);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XmTextFieldSetHighlight
 * 	in: XmTextFieldWidget 	# Text field widget
 * 	in: XmTextPosition	# from character position
 * 	in: XmTextPosition	# to character position
 * 	in: XmHighlightMode	# NORMAL | SELECTED | SECONDARY_SELECTED
 */

static int 
cmd_XmTextFieldSetHighlight(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     XmTextPosition localVar2;
     XmTextPosition localVar3;
     XmHighlightMode localVar4;

     DBUG_ENTER("XmTextFieldSetHighlight");  

     if (argc != 5) 
	 {
	 wafeArgcError("XmTextFieldSetHighlight","",4,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmTextFieldWidgetClass,"XmTextField")))
          {
          wafeConvError("XmTextFieldSetHighlight","1",argv[1],"XmTextFieldWidget");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(sscanf(argv[2], "%ld", &localVar2)))
          {
          wafeConvError("XmTextFieldSetHighlight","2",argv[2],"XmTextPosition");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(sscanf(argv[3], "%ld", &localVar3)))
          {
          wafeConvError("XmTextFieldSetHighlight","3",argv[3],"XmTextPosition");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!strcmp(argv[4], "NORMAL")) 
         localVar4 = XmHIGHLIGHT_NORMAL;
     else
     if (!strcmp(argv[4], "SELECTED")) 
         localVar4 = XmHIGHLIGHT_SELECTED;
     else
     if (!strcmp(argv[4], "SECONDARY_SELECTED")) 
         localVar4 = XmHIGHLIGHT_SECONDARY_SELECTED;
     else
         {
         wafeConvError("XmTextFieldSetHighlight","4",argv[4],"XmHighlightMode");
         DBUG_RETURN (TCL_ERROR);
        }


     XmTextFieldSetHighlight(localVar1,localVar2,localVar3,localVar4);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XmTextFieldSetSelection
 * 	in: XmTextFieldWidget 	# Text field widget
 * 	in: XmTextPosition	# from character position
 * 	in: XmTextPosition	# to character position
 * 	const: time(NULL)
 */

static int 
cmd_XmTextFieldSetSelection(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     XmTextPosition localVar2;
     XmTextPosition localVar3;

     DBUG_ENTER("XmTextFieldSetSelection");  

     if (argc != 4) 
	 {
	 wafeArgcError("XmTextFieldSetSelection","",3,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmTextFieldWidgetClass,"XmTextField")))
          {
          wafeConvError("XmTextFieldSetSelection","1",argv[1],"XmTextFieldWidget");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(sscanf(argv[2], "%ld", &localVar2)))
          {
          wafeConvError("XmTextFieldSetSelection","2",argv[2],"XmTextPosition");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(sscanf(argv[3], "%ld", &localVar3)))
          {
          wafeConvError("XmTextFieldSetSelection","3",argv[3],"XmTextPosition");
          DBUG_RETURN (TCL_ERROR);
          }

     XmTextFieldSetSelection(localVar1,localVar2,localVar3,time(NULL));

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XmTextFieldShowPosition
 * 	in: XmTextFieldWidget 	# Text field widget
 * 	in: XmTextPosition	# character position to display
 */

static int 
cmd_XmTextFieldShowPosition(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     XmTextPosition localVar2;

     DBUG_ENTER("XmTextFieldShowPosition");  

     if (argc != 3) 
	 {
	 wafeArgcError("XmTextFieldShowPosition","",2,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmTextFieldWidgetClass,"XmTextField")))
          {
          wafeConvError("XmTextFieldShowPosition","1",argv[1],"XmTextFieldWidget");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(sscanf(argv[2], "%ld", &localVar2)))
          {
          wafeConvError("XmTextFieldShowPosition","2",argv[2],"XmTextPosition");
          DBUG_RETURN (TCL_ERROR);
          }

     XmTextFieldShowPosition(localVar1,localVar2);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XmTextFieldXYToPos
 * 	in: XmTextFieldWidget 	# Text field widget
 * 	in: Position		# x coord relative to top left
 * 	in: Position		# y coord relative to top left
 */

static int 
cmd_XmTextFieldXYToPos(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     Position localVar2;
     Position localVar3;

     DBUG_ENTER("XmTextFieldXYToPos");  

     if (argc != 4) 
	 {
	 wafeArgcError("XmTextFieldXYToPos","",3,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmTextFieldWidgetClass,"XmTextField")))
          {
          wafeConvError("XmTextFieldXYToPos","1",argv[1],"XmTextFieldWidget");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(sscanf(argv[2], "%hd", &localVar2)))
          {
          wafeConvError("XmTextFieldXYToPos","2",argv[2],"Position");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(sscanf(argv[3], "%hd", &localVar3)))
          {
          wafeConvError("XmTextFieldXYToPos","3",argv[3],"Position");
          DBUG_RETURN (TCL_ERROR);
          }

     XmTextFieldXYToPos(localVar1,localVar2,localVar3);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * int
 * XmTextGetBaseline
 * 	in: XmTextWidget 	# Text widget
 */

static int 
cmd_XmTextGetBaseline(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     int returnVar;
     char conversionBuffer[100];

     DBUG_ENTER("XmTextGetBaseline");  

     if (argc != 2) 
	 {
	 wafeArgcError("XmTextGetBaseline","",1,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmTextWidgetClass,"XmText")))
          {
          wafeConvError("XmTextGetBaseline","1",argv[1],"XmTextWidget");
          DBUG_RETURN (TCL_ERROR);
          }

     returnVar = XmTextGetBaseline(localVar1);

     sprintf(conversionBuffer, "%d", returnVar);
     Tcl_SetResult(comInterpreter, conversionBuffer, TCL_VOLATILE);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * XmTextPosition
 * XmTextGetLastPosition
 * 	in: XmTextWidget 	# Text widget
 */

static int 
cmd_XmTextGetLastPosition(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     XmTextPosition returnVar;
     char conversionBuffer[100];

     DBUG_ENTER("XmTextGetLastPosition");  

     if (argc != 2) 
	 {
	 wafeArgcError("XmTextGetLastPosition","",1,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmTextWidgetClass,"XmText")))
          {
          wafeConvError("XmTextGetLastPosition","1",argv[1],"XmTextWidget");
          DBUG_RETURN (TCL_ERROR);
          }

     returnVar = XmTextGetLastPosition(localVar1);

     sprintf(conversionBuffer, "%ld", returnVar);
     Tcl_SetResult(comInterpreter, conversionBuffer, TCL_VOLATILE);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * String
 * XmTextGetSelection
 * 	in: XmTextWidget 	# Text widget
 * 	end: if (!returnVar) XtFree(returnVar);
 */

static int 
cmd_XmTextGetSelection(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     String returnVar;

     DBUG_ENTER("XmTextGetSelection");  

     if (argc != 2) 
	 {
	 wafeArgcError("XmTextGetSelection","",1,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmTextWidgetClass,"XmText")))
          {
          wafeConvError("XmTextGetSelection","1",argv[1],"XmTextWidget");
          DBUG_RETURN (TCL_ERROR);
          }

     returnVar = XmTextGetSelection(localVar1);

     
     Tcl_SetResult(comInterpreter, returnVar, TCL_VOLATILE);

     if (!returnVar) XtFree(returnVar);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * Boolean
 * XmTextGetSelectionPosition
 * 	in: XmTextWidget 	# Text widget
 * 	out: XmTextPosition	# left boundary
 * 	out: XmTextPosition     # right boundary
 */

static int 
cmd_XmTextGetSelectionPosition(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     XmTextPosition localVar2;
     XmTextPosition localVar3;
     Boolean returnVar;
     char conversionBuffer[100];

     DBUG_ENTER("XmTextGetSelectionPosition");  

     if (argc != 4) 
	 {
	 wafeArgcError("XmTextGetSelectionPosition","",3,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmTextWidgetClass,"XmText")))
          {
          wafeConvError("XmTextGetSelectionPosition","1",argv[1],"XmTextWidget");
          DBUG_RETURN (TCL_ERROR);
          }

     returnVar = XmTextGetSelectionPosition(localVar1,&localVar2,&localVar3);

     sprintf(conversionBuffer, "%ld", localVar2);
     Tcl_SetVar(wafeInterpreter, argv[2], conversionBuffer, 0);

     sprintf(conversionBuffer, "%ld", localVar3);
     Tcl_SetVar(wafeInterpreter, argv[3], conversionBuffer, 0);

          if (returnVar == 0) 
          strcpy(conversionBuffer, "false");
     else
     if (returnVar == 1) 
          strcpy(conversionBuffer, "true");


     Tcl_SetResult(comInterpreter, conversionBuffer, TCL_VOLATILE);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XmTextInsert
 * 	in: XmTextWidget 	# Text widget
 * 	in: XmTextPosition	# character position
 * 	in: String              # text string to be inserted
 */

static int 
cmd_XmTextInsert(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     XmTextPosition localVar2;

     DBUG_ENTER("XmTextInsert");  

     if (argc != 4) 
	 {
	 wafeArgcError("XmTextInsert","",3,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmTextWidgetClass,"XmText")))
          {
          wafeConvError("XmTextInsert","1",argv[1],"XmTextWidget");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(sscanf(argv[2], "%ld", &localVar2)))
          {
          wafeConvError("XmTextInsert","2",argv[2],"XmTextPosition");
          DBUG_RETURN (TCL_ERROR);
          }

    /* no need to assign  << localVar3 = argv[3] >>  */ 

     XmTextInsert(localVar1,localVar2,argv[3]);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XmTextPaste
 * 	in: XmTextWidget 	# Text widget
 */

static int 
cmd_XmTextPaste(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;

     DBUG_ENTER("XmTextPaste");  

     if (argc != 2) 
	 {
	 wafeArgcError("XmTextPaste","",1,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmTextWidgetClass,"XmText")))
          {
          wafeConvError("XmTextPaste","1",argv[1],"XmTextWidget");
          DBUG_RETURN (TCL_ERROR);
          }

     XmTextPaste(localVar1);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * Boolean
 * XmTextPosToXY
 * 	in: XmTextWidget 	# Text widget
 * 	in: XmTextPosition	# character position
 * 	out: Position		# x coord relative to top left
 * 	out: Position		# y coord relative to top left
 */

static int 
cmd_XmTextPosToXY(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     XmTextPosition localVar2;
     Position localVar3;
     Position localVar4;
     Boolean returnVar;
     char conversionBuffer[100];

     DBUG_ENTER("XmTextPosToXY");  

     if (argc != 5) 
	 {
	 wafeArgcError("XmTextPosToXY","",4,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmTextWidgetClass,"XmText")))
          {
          wafeConvError("XmTextPosToXY","1",argv[1],"XmTextWidget");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(sscanf(argv[2], "%ld", &localVar2)))
          {
          wafeConvError("XmTextPosToXY","2",argv[2],"XmTextPosition");
          DBUG_RETURN (TCL_ERROR);
          }

     returnVar = XmTextPosToXY(localVar1,localVar2,&localVar3,&localVar4);

     sprintf(conversionBuffer, "%hd", localVar3);
     Tcl_SetVar(wafeInterpreter, argv[3], conversionBuffer, 0);

     sprintf(conversionBuffer, "%hd", localVar4);
     Tcl_SetVar(wafeInterpreter, argv[4], conversionBuffer, 0);

          if (returnVar == 0) 
          strcpy(conversionBuffer, "false");
     else
     if (returnVar == 1) 
          strcpy(conversionBuffer, "true");


     Tcl_SetResult(comInterpreter, conversionBuffer, TCL_VOLATILE);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * Boolean
 * XmTextRemove
 * 	in: XmTextWidget 	# Text widget
 */

static int 
cmd_XmTextRemove(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     Boolean returnVar;
     char conversionBuffer[100];

     DBUG_ENTER("XmTextRemove");  

     if (argc != 2) 
	 {
	 wafeArgcError("XmTextRemove","",1,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmTextWidgetClass,"XmText")))
          {
          wafeConvError("XmTextRemove","1",argv[1],"XmTextWidget");
          DBUG_RETURN (TCL_ERROR);
          }

     returnVar = XmTextRemove(localVar1);

          if (returnVar == 0) 
          strcpy(conversionBuffer, "false");
     else
     if (returnVar == 1) 
          strcpy(conversionBuffer, "true");


     Tcl_SetResult(comInterpreter, conversionBuffer, TCL_VOLATILE);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XmTextReplace
 * 	in: XmTextWidget 	# Text widget
 * 	in: XmTextPosition	# from character position
 * 	in: XmTextPosition	# to character position
 * 	in: String 		# insert string
 */

static int 
cmd_XmTextReplace(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     XmTextPosition localVar2;
     XmTextPosition localVar3;

     DBUG_ENTER("XmTextReplace");  

     if (argc != 5) 
	 {
	 wafeArgcError("XmTextReplace","",4,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmTextWidgetClass,"XmText")))
          {
          wafeConvError("XmTextReplace","1",argv[1],"XmTextWidget");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(sscanf(argv[2], "%ld", &localVar2)))
          {
          wafeConvError("XmTextReplace","2",argv[2],"XmTextPosition");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(sscanf(argv[3], "%ld", &localVar3)))
          {
          wafeConvError("XmTextReplace","3",argv[3],"XmTextPosition");
          DBUG_RETURN (TCL_ERROR);
          }

    /* no need to assign  << localVar4 = argv[4] >>  */ 

     XmTextReplace(localVar1,localVar2,localVar3,argv[4]);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XmTextScroll
 * 	in: XmTextWidget 	# Text widget
 * 	in: int			# number of lines to scroll
 */

static int 
cmd_XmTextScroll(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     int localVar2;

     DBUG_ENTER("XmTextScroll");  

     if (argc != 3) 
	 {
	 wafeArgcError("XmTextScroll","",2,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmTextWidgetClass,"XmText")))
          {
          wafeConvError("XmTextScroll","1",argv[1],"XmTextWidget");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(sscanf(argv[2], "%d", &localVar2)))
          {
          wafeConvError("XmTextScroll","2",argv[2],"int");
          DBUG_RETURN (TCL_ERROR);
          }

     XmTextScroll(localVar1,localVar2);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XmTextSetAddMode
 * 	in: XmTextWidget 	# Text widget
 * 	in: Boolean		# true | false
 */

static int 
cmd_XmTextSetAddMode(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     Boolean localVar2;

     DBUG_ENTER("XmTextSetAddMode");  

     if (argc != 3) 
	 {
	 wafeArgcError("XmTextSetAddMode","",2,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmTextWidgetClass,"XmText")))
          {
          wafeConvError("XmTextSetAddMode","1",argv[1],"XmTextWidget");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!strcmp(argv[2], "false")) 
         localVar2 = 0;
     else
     if (!strcmp(argv[2], "true")) 
         localVar2 = 1;
     else
         {
         wafeConvError("XmTextSetAddMode","2",argv[2],"Boolean");
         DBUG_RETURN (TCL_ERROR);
        }


     XmTextSetAddMode(localVar1,localVar2);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XmTextSetHighlight
 * 	in: XmTextWidget 	# Text widget
 * 	in: XmTextPosition	# from character position
 * 	in: XmTextPosition	# to character position
 * 	in: XmHighlightMode	# NORMAL | SELECTED | SECONDARY_SELECTED
 */

static int 
cmd_XmTextSetHighlight(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     XmTextPosition localVar2;
     XmTextPosition localVar3;
     XmHighlightMode localVar4;

     DBUG_ENTER("XmTextSetHighlight");  

     if (argc != 5) 
	 {
	 wafeArgcError("XmTextSetHighlight","",4,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmTextWidgetClass,"XmText")))
          {
          wafeConvError("XmTextSetHighlight","1",argv[1],"XmTextWidget");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(sscanf(argv[2], "%ld", &localVar2)))
          {
          wafeConvError("XmTextSetHighlight","2",argv[2],"XmTextPosition");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(sscanf(argv[3], "%ld", &localVar3)))
          {
          wafeConvError("XmTextSetHighlight","3",argv[3],"XmTextPosition");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!strcmp(argv[4], "NORMAL")) 
         localVar4 = XmHIGHLIGHT_NORMAL;
     else
     if (!strcmp(argv[4], "SELECTED")) 
         localVar4 = XmHIGHLIGHT_SELECTED;
     else
     if (!strcmp(argv[4], "SECONDARY_SELECTED")) 
         localVar4 = XmHIGHLIGHT_SECONDARY_SELECTED;
     else
         {
         wafeConvError("XmTextSetHighlight","4",argv[4],"XmHighlightMode");
         DBUG_RETURN (TCL_ERROR);
        }


     XmTextSetHighlight(localVar1,localVar2,localVar3,localVar4);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XmTextSetSelection
 * 	in: XmTextWidget 	# Text field widget
 * 	in: XmTextPosition	# from character position
 * 	in: XmTextPosition	# to character position
 * 	const: time(NULL)
 */

static int 
cmd_XmTextSetSelection(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     XmTextPosition localVar2;
     XmTextPosition localVar3;

     DBUG_ENTER("XmTextSetSelection");  

     if (argc != 4) 
	 {
	 wafeArgcError("XmTextSetSelection","",3,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmTextWidgetClass,"XmText")))
          {
          wafeConvError("XmTextSetSelection","1",argv[1],"XmTextWidget");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(sscanf(argv[2], "%ld", &localVar2)))
          {
          wafeConvError("XmTextSetSelection","2",argv[2],"XmTextPosition");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(sscanf(argv[3], "%ld", &localVar3)))
          {
          wafeConvError("XmTextSetSelection","3",argv[3],"XmTextPosition");
          DBUG_RETURN (TCL_ERROR);
          }

     XmTextSetSelection(localVar1,localVar2,localVar3,time(NULL));

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XmTextShowPosition
 * 	in: XmTextWidget 	# Text widget
 * 	in: XmTextPosition	# character position to display
 */

static int 
cmd_XmTextShowPosition(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     XmTextPosition localVar2;

     DBUG_ENTER("XmTextShowPosition");  

     if (argc != 3) 
	 {
	 wafeArgcError("XmTextShowPosition","",2,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmTextWidgetClass,"XmText")))
          {
          wafeConvError("XmTextShowPosition","1",argv[1],"XmTextWidget");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(sscanf(argv[2], "%ld", &localVar2)))
          {
          wafeConvError("XmTextShowPosition","2",argv[2],"XmTextPosition");
          DBUG_RETURN (TCL_ERROR);
          }

     XmTextShowPosition(localVar1,localVar2);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XmTextXYToPos
 * 	in: XmTextWidget 	# Text widget
 * 	in: Position		# x coord relative to top left
 * 	in: Position		# y coord relative to top left
 */

static int 
cmd_XmTextXYToPos(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     Position localVar2;
     Position localVar3;

     DBUG_ENTER("XmTextXYToPos");  

     if (argc != 4) 
	 {
	 wafeArgcError("XmTextXYToPos","",3,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmTextWidgetClass,"XmText")))
          {
          wafeConvError("XmTextXYToPos","1",argv[1],"XmTextWidget");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(sscanf(argv[2], "%hd", &localVar2)))
          {
          wafeConvError("XmTextXYToPos","2",argv[2],"Position");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(sscanf(argv[3], "%hd", &localVar3)))
          {
          wafeConvError("XmTextXYToPos","3",argv[3],"Position");
          DBUG_RETURN (TCL_ERROR);
          }

     XmTextXYToPos(localVar1,localVar2,localVar3);

     DBUG_RETURN (TCL_OK);
     }     


#include <Xm/ToggleB.h>
/* 
 * Boolean
 * XmToggleButtonGetState
 * 	in: XmToggleButtonWidget	# toggle button widget
 */

static int 
cmd_XmToggleButtonGetState(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     Boolean returnVar;
     char conversionBuffer[100];

     DBUG_ENTER("XmToggleButtonGetState");  

     if (argc != 2) 
	 {
	 wafeArgcError("XmToggleButtonGetState","",1,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmToggleButtonWidgetClass,"XmToggleButton")))
          {
          wafeConvError("XmToggleButtonGetState","1",argv[1],"XmToggleButtonWidget");
          DBUG_RETURN (TCL_ERROR);
          }

     returnVar = XmToggleButtonGetState(localVar1);

          if (returnVar == 0) 
          strcpy(conversionBuffer, "false");
     else
     if (returnVar == 1) 
          strcpy(conversionBuffer, "true");


     Tcl_SetResult(comInterpreter, conversionBuffer, TCL_VOLATILE);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XmToggleButtonSetState
 * 	in: XmToggleButtonWidget	# toggle button widget
 * 	in: Boolean			# state (bool)
 * 	in: Boolean             	# notify (bool)
 */

static int 
cmd_XmToggleButtonSetState(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     Boolean localVar2;
     Boolean localVar3;

     DBUG_ENTER("XmToggleButtonSetState");  

     if (argc != 4) 
	 {
	 wafeArgcError("XmToggleButtonSetState","",3,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmToggleButtonWidgetClass,"XmToggleButton")))
          {
          wafeConvError("XmToggleButtonSetState","1",argv[1],"XmToggleButtonWidget");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!strcmp(argv[2], "false")) 
         localVar2 = 0;
     else
     if (!strcmp(argv[2], "true")) 
         localVar2 = 1;
     else
         {
         wafeConvError("XmToggleButtonSetState","2",argv[2],"Boolean");
         DBUG_RETURN (TCL_ERROR);
        }


     if (!strcmp(argv[3], "false")) 
         localVar3 = 0;
     else
     if (!strcmp(argv[3], "true")) 
         localVar3 = 1;
     else
         {
         wafeConvError("XmToggleButtonSetState","3",argv[3],"Boolean");
         DBUG_RETURN (TCL_ERROR);
        }


     XmToggleButtonSetState(localVar1,localVar2,localVar3);

     DBUG_RETURN (TCL_OK);
     }     


#include <Xm/ToggleBG.h>
/* 
 * Boolean
 * XmToggleButtonGadgetGetState
 * 	in: XmToggleButtonGadget	# toggle button widget
 */

static int 
cmd_XmToggleButtonGadgetGetState(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     Boolean returnVar;
     char conversionBuffer[100];

     DBUG_ENTER("XmToggleButtonGadgetGetState");  

     if (argc != 2) 
	 {
	 wafeArgcError("XmToggleButtonGadgetGetState","",1,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmToggleButtonGadgetClass,"XmToggleButton")))
          {
          wafeConvError("XmToggleButtonGadgetGetState","1",argv[1],"XmToggleButtonGadget");
          DBUG_RETURN (TCL_ERROR);
          }

     returnVar = XmToggleButtonGadgetGetState(localVar1);

          if (returnVar == 0) 
          strcpy(conversionBuffer, "false");
     else
     if (returnVar == 1) 
          strcpy(conversionBuffer, "true");


     Tcl_SetResult(comInterpreter, conversionBuffer, TCL_VOLATILE);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XmToggleButtonGadgetSetState
 * 	in: XmToggleButtonGadget	# toggle button gadget
 * 	in: Boolean			# state (bool)
 * 	in: Boolean             	# notify (bool)
 */

static int 
cmd_XmToggleButtonGadgetSetState(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     Boolean localVar2;
     Boolean localVar3;

     DBUG_ENTER("XmToggleButtonGadgetSetState");  

     if (argc != 4) 
	 {
	 wafeArgcError("XmToggleButtonGadgetSetState","",3,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmToggleButtonGadgetClass,"XmToggleButton")))
          {
          wafeConvError("XmToggleButtonGadgetSetState","1",argv[1],"XmToggleButtonGadget");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!strcmp(argv[2], "false")) 
         localVar2 = 0;
     else
     if (!strcmp(argv[2], "true")) 
         localVar2 = 1;
     else
         {
         wafeConvError("XmToggleButtonGadgetSetState","2",argv[2],"Boolean");
         DBUG_RETURN (TCL_ERROR);
        }


     if (!strcmp(argv[3], "false")) 
         localVar3 = 0;
     else
     if (!strcmp(argv[3], "true")) 
         localVar3 = 1;
     else
         {
         wafeConvError("XmToggleButtonGadgetSetState","3",argv[3],"Boolean");
         DBUG_RETURN (TCL_ERROR);
        }


     XmToggleButtonGadgetSetState(localVar1,localVar2,localVar3);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XmAddTabGroup
 * 	in: Widget        		# widget to be added
 */

static int 
cmd_XmAddTabGroup(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;

     DBUG_ENTER("XmAddTabGroup");  

     if (argc != 2) 
	 {
	 wafeArgcError("XmAddTabGroup","",1,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 = (Widget) name2Widget(argv[1])))
          {
          wafeConvError("XmAddTabGroup","1",argv[1],"Widget");
          DBUG_RETURN (TCL_ERROR);
          }

     XmAddTabGroup(localVar1);

     DBUG_RETURN (TCL_OK);
     }     


#else
#endif

void
wafeInitialize_XmGen()
{
#ifdef MOTIF11
 wafeCreateWidgetCommand("XmArrowButton",xmArrowButtonWidgetClass,NULL,False);
 wafeCreateWidgetCommand("XmArrowButtonGadget",xmArrowButtonGadgetClass,NULL,False);
 wafeCreateWidgetCommand("XmBulletinBoard",xmBulletinBoardWidgetClass,NULL,False);
 wafeCreateWidgetCommand("XmBulletinBoardDialog",xmBulletinBoardWidgetClass,XmCreateBulletinBoardDialog,True);
 wafeCreateWidgetCommand("XmCascadeButton",xmCascadeButtonWidgetClass,NULL,False);
 wafeCreateWidgetCommand("XmCascadeButtonGadget",xmCascadeButtonGadgetClass,NULL,False);
 wafeCreateWidgetCommand("XmCommand",xmCommandWidgetClass,NULL,False);
 wafeCreateWidgetCommand("XmDialogShell",xmDialogShellWidgetClass,NULL,True);
 wafeCreateWidgetCommand("XmDrawingArea",xmDrawingAreaWidgetClass,NULL,False);
 wafeCreateWidgetCommand("XmDrawnButton",xmDrawnButtonWidgetClass,NULL,False);
 wafeCreateWidgetCommand("XmFileSelectionBox",xmFileSelectionBoxWidgetClass,NULL,False);
 wafeCreateWidgetCommand("XmFileSelectionDialog",xmFileSelectionBoxWidgetClass,XmCreateFileSelectionDialog,True);
 wafeCreateWidgetCommand("XmForm",xmFormWidgetClass,NULL,False);
 wafeCreateWidgetCommand("XmFormDialog",xmFormWidgetClass,XmCreateFormDialog,True);
 wafeCreateWidgetCommand("XmFrame",xmFrameWidgetClass,NULL,False);
 wafeCreateWidgetCommand("XmInformationDialog",xmMessageBoxWidgetClass,XmCreateInformationDialog,True);
 wafeCreateWidgetCommand("XmLabel",xmLabelWidgetClass,NULL,False);
 wafeCreateWidgetCommand("XmLabelGadget",xmLabelGadgetClass,NULL,False);
 wafeCreateWidgetCommand("XmList",xmListWidgetClass,NULL,False);
 wafeCreateWidgetCommand("XmMainWindow",xmMainWindowWidgetClass,NULL,False);
 wafeCreateWidgetCommand("XmMenuBar",xmRowColumnWidgetClass,XmCreateMenuBar,False);
 wafeCreateWidgetCommand("XmMenuShell",xmMenuShellWidgetClass,NULL,True);
 wafeCreateWidgetCommand("XmMessageBox",xmMessageBoxWidgetClass,NULL,False);
 wafeCreateWidgetCommand("XmMessageDialog",xmMessageBoxWidgetClass,XmCreateMessageDialog,True);
 wafeCreateWidgetCommand("XmOptionMenu",xmRowColumnWidgetClass,XmCreateOptionMenu,False);
 wafeCreateWidgetCommand("XmPanedWindow",xmPanedWindowWidgetClass,NULL,False);
 wafeCreateWidgetCommand("XmPopupMenu",xmRowColumnWidgetClass,XmCreatePopupMenu,False);
 wafeCreateWidgetCommand("XmPromptDialog",xmSelectionBoxWidgetClass,XmCreatePromptDialog,True);
 wafeCreateWidgetCommand("XmPulldownMenu",xmRowColumnWidgetClass,XmCreatePulldownMenu,False);
 wafeCreateWidgetCommand("XmPushButton",xmPushButtonWidgetClass,NULL,False);
 wafeCreateWidgetCommand("XmPushButtonGadget",xmPushButtonGadgetClass,NULL,False);
 wafeCreateWidgetCommand("XmQuestionDialog",xmMessageBoxWidgetClass,XmCreateQuestionDialog,True);
 wafeCreateWidgetCommand("XmRadioBox",xmRowColumnWidgetClass,XmCreateRadioBox,False);
 wafeCreateWidgetCommand("XmRowColumn",xmRowColumnWidgetClass,NULL,False);
 wafeCreateWidgetCommand("XmScale",xmScaleWidgetClass,NULL,False);
 wafeCreateWidgetCommand("XmScrollBar",xmScrollBarWidgetClass,NULL,False);
 wafeCreateWidgetCommand("XmScrolledList",xmListWidgetClass,XmCreateScrolledList,False);
 wafeCreateWidgetCommand("XmScrolledText",xmTextWidgetClass,XmCreateScrolledText,False);
 wafeCreateWidgetCommand("XmScrolledWindow",xmScrolledWindowWidgetClass,NULL,False);
 wafeCreateWidgetCommand("XmSelectionBox",xmSelectionBoxWidgetClass,NULL,False);
 wafeCreateWidgetCommand("XmSelectionDialog",xmSelectionBoxWidgetClass,XmCreateSelectionDialog,True);
 wafeCreateWidgetCommand("XmSeparator",xmSeparatorWidgetClass,NULL,False);
 wafeCreateWidgetCommand("XmSeparatorGadget",xmSeparatorGadgetClass,NULL,False);
 wafeCreateWidgetCommand("XmSimpleCheckBox",xmRowColumnWidgetClass,XmCreateSimpleCheckBox,False);
 wafeCreateWidgetCommand("XmSimpleMenuBar",xmRowColumnWidgetClass,XmCreateSimpleMenuBar,False);
 wafeCreateWidgetCommand("XmSimpleOptionMenu",xmRowColumnWidgetClass,XmCreateSimpleOptionMenu,False);
 wafeCreateWidgetCommand("XmSimplePopupMenu",xmRowColumnWidgetClass,XmCreateSimplePopupMenu,False);
 wafeCreateWidgetCommand("XmSimplePulldownMenu",xmRowColumnWidgetClass,XmCreateSimplePulldownMenu,False);
 wafeCreateWidgetCommand("XmSimpleRadioBox",xmRowColumnWidgetClass,XmCreateSimpleRadioBox,False);
 wafeCreateWidgetCommand("XmText",xmTextWidgetClass,NULL,False);
 wafeCreateWidgetCommand("XmTextField",xmTextFieldWidgetClass,NULL,False);
 wafeCreateWidgetCommand("XmToggleButton",xmToggleButtonWidgetClass,NULL,False);
 wafeCreateWidgetCommand("XmToggleButtonGadget",xmToggleButtonGadgetClass,NULL,False);
 wafeCreateWidgetCommand("XmWarningDialog",xmMessageBoxWidgetClass,XmCreateWarningDialog,True);
 wafeCreateWidgetCommand("XmWorkingDialog",xmMessageBoxWidgetClass,XmCreateWorkingDialog,True);
#ifdef MOTIF11
 strcat(wafePackages,"MOTIF11 ");
#endif
 XtSetTypeConverter(XtRString, "XmString",
	(XtTypeConverter)CvtStringToXmString, 
	NULL, 0, XtCacheNone, NULL);
 XtSetTypeConverter(XtRString, "XmStringTable",
	(XtTypeConverter)CvtStringToXmStrings, 
	NULL, 0, XtCacheNone, NULL);
 XtSetTypeConverter(XtRString, "Window",
	(XtTypeConverter)CvtStringToWidget, 
	NULL, 0, XtCacheNone, NULL);
 XtSetTypeConverter(XtRString, "MenuWidget",
	(XtTypeConverter)CvtStringToWidget, 
	NULL, 0, XtCacheNone, NULL);
 XtSetTypeConverter("XmString", XtRString,
	(XtTypeConverter)CvtXmStringToString, 
	NULL, 0, XtCacheNone, NULL);
 XtSetTypeConverter("XmStringTable", XtRString,
	(XtTypeConverter)CvtXmStringTableToString, 
	NULL, 0, XtCacheNone, NULL);
 XtSetTypeConverter(XtRString, "TextPosition",
	(XtTypeConverter)CvtStringToLong, 
	NULL, 0, XtCacheNone, NULL);
 wafeMotifInit();
 qXmString = WafePermStringToQuark("XmString");
 qXmStringTable = WafePermStringToQuark("XmStringTable");
 qWindow = WafePermStringToQuark("Window");
 qHorizontalDimension = WafePermStringToQuark("HorizontalDimension");
 qVerticalDimension = WafePermStringToQuark("VerticalDimension");
 qTextPosition = WafePermStringToQuark("TextPosition");
 qVerticalPosition = WafePermStringToQuark("VerticalPosition");
 qHorizontalPosition = WafePermStringToQuark("HorizontalPosition");
 qPrimForegroundPixmap = WafePermStringToQuark("PrimForegroundPixmap");
 XtAddConverter (XmRString, XmRUnitType, XmCvtStringToUnitType, NULL, 0);
 Tcl_CreateCommand(wafeInterpreter, "XmProcessTraversal", cmd_XmProcessTraversal, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XmCascadeButtonGadgetHighlight", cmd_XmCascadeButtonGadgetHighlight, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XmCascadeButtonHighlight", cmd_XmCascadeButtonHighlight, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XmCommandAppendValue", cmd_XmCommandAppendValue, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XmCommandError", cmd_XmCommandError, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XmFileSelectionBoxGetChild", cmd_XmFileSelectionBoxGetChild, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XmFileSelectionDoSearch", cmd_XmFileSelectionDoSearch, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XmListAddItem", cmd_XmListAddItem, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XmListAddItems", cmd_XmListAddItems, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XmListAddItemUnselected", cmd_XmListAddItemUnselected, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XmListDeleteAllItems", cmd_XmListDeleteAllItems, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XmListDeleteItem", cmd_XmListDeleteItem, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XmListDeleteItems", cmd_XmListDeleteItems, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XmListDeleteItemsPos", cmd_XmListDeleteItemsPos, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XmListDeletePos", cmd_XmListDeletePos, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XmListDeselectAllItems", cmd_XmListDeselectAllItems, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XmListDeselectItem", cmd_XmListDeselectItem, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XmListDeselectPos", cmd_XmListDeselectPos, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XmListGetMatchPos", cmd_XmListGetMatchPos, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XmListGetSelectedPos", cmd_XmListGetSelectedPos, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XmListItemExists", cmd_XmListItemExists, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XmListItemPos", cmd_XmListItemPos, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XmListReplaceItems", cmd_XmListReplaceItems, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XmListReplaceItemsPos", cmd_XmListReplaceItemsPos, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XmListSelectItem", cmd_XmListSelectItem, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XmListSelectPos", cmd_XmListSelectPos, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XmListSetAddMode", cmd_XmListSetAddMode, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XmListSetBottomItem", cmd_XmListSetBottomItem, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XmListSetBottomPos", cmd_XmListSetBottomPos, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XmListSetHorizPos", cmd_XmListSetHorizPos, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XmListSetItem", cmd_XmListSetItem, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XmListSetPos", cmd_XmListSetPos, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XmMainWindowSetAreas", cmd_XmMainWindowSetAreas, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XmMessageBoxGetChild", cmd_XmMessageBoxGetChild, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XmScrollBarGetValues", cmd_XmScrollBarGetValues, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XmScrollBarSetValues", cmd_XmScrollBarSetValues, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XmTextClearSelection", cmd_XmTextClearSelection, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XmTextCopy", cmd_XmTextCopy, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XmTextCut", cmd_XmTextCut, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XmTextFieldClearSelection", cmd_XmTextFieldClearSelection, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XmTextFieldCopy", cmd_XmTextFieldCopy, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XmTextFieldCut", cmd_XmTextFieldCut, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XmTextFieldGetBaseline", cmd_XmTextFieldGetBaseline, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XmTextFieldGetLastPosition", cmd_XmTextFieldGetLastPosition, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XmTextFieldGetSelection", cmd_XmTextFieldGetSelection, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XmTextFieldGetSelectionPosition", cmd_XmTextFieldGetSelectionPosition, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XmTextFieldInsert", cmd_XmTextFieldInsert, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XmTextFieldPaste", cmd_XmTextFieldPaste, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XmTextFieldPosToXY", cmd_XmTextFieldPosToXY, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XmTextFieldRemove", cmd_XmTextFieldRemove, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XmTextFieldReplace", cmd_XmTextFieldReplace, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XmTextFieldSetAddMode", cmd_XmTextFieldSetAddMode, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XmTextFieldSetHighlight", cmd_XmTextFieldSetHighlight, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XmTextFieldSetSelection", cmd_XmTextFieldSetSelection, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XmTextFieldShowPosition", cmd_XmTextFieldShowPosition, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XmTextFieldXYToPos", cmd_XmTextFieldXYToPos, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XmTextGetBaseline", cmd_XmTextGetBaseline, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XmTextGetLastPosition", cmd_XmTextGetLastPosition, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XmTextGetSelection", cmd_XmTextGetSelection, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XmTextGetSelectionPosition", cmd_XmTextGetSelectionPosition, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XmTextInsert", cmd_XmTextInsert, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XmTextPaste", cmd_XmTextPaste, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XmTextPosToXY", cmd_XmTextPosToXY, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XmTextRemove", cmd_XmTextRemove, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XmTextReplace", cmd_XmTextReplace, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XmTextScroll", cmd_XmTextScroll, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XmTextSetAddMode", cmd_XmTextSetAddMode, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XmTextSetHighlight", cmd_XmTextSetHighlight, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XmTextSetSelection", cmd_XmTextSetSelection, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XmTextShowPosition", cmd_XmTextShowPosition, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XmTextXYToPos", cmd_XmTextXYToPos, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XmToggleButtonGetState", cmd_XmToggleButtonGetState, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XmToggleButtonSetState", cmd_XmToggleButtonSetState, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XmToggleButtonGadgetGetState", cmd_XmToggleButtonGadgetGetState, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XmToggleButtonGadgetSetState", cmd_XmToggleButtonGadgetSetState, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XmAddTabGroup", cmd_XmAddTabGroup, NULL, NULL);

#else
#endif
}
