/* Copyright (C) 1992 by Gustaf Neumann, Stefan Nusser

 *      Wirtschaftsuniversitaet Wien, 
 *      Abteilung fuer Wirtschaftsinformatik
 *      Augasse 2-6, 
 *      A-1090 Vienna, Austria
 *      neumann@wu-wien.ac.at, nusser@wu-wien.ac.at

 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided
 * that the above copyright notice appears in all copies and that both that
 * copyright notice and this permission notice appear in all supporting
 * documentation.  This software is provided "as is" without expressed or
 * implied warranty.

 * Creation: Mon May  2 23:29:41 EDT 1994 on syllog2.watson.ibm.com
 * Author: genc
 * Version: 0.95999999999999996


 */
#define PLOTTER_C
#include <wafe.h>
#ifdef PLOTTER

#include <X11/At/Axis.h>
#include <X11/At/BarPlot.h>
#include <X11/At/LabelAxis.h>
#include <X11/At/LinePlot.h>
#include <X11/At/Plot.h>
#include <X11/At/Plotter.h>
#include <X11/At/TextPlot.h>
#include <X11/At/XYAxis.h>
#include <X11/At/XYLinePlot.h>
#define castXtPointer(x) (XtPointer)(x)

/* 
 * void
 * AtBarPlotAttachData
 *         in: AtBarPlotWidget		# bar plot widget
 * 	in: castXtPointer([float])	# floats
 * 	const: AtFloat
 * 	const: sizeof(float)
 * 	const: 1
 * 	const: argc-2
 */

static int 
cmd_AtBarPlotAttachData(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     float * localVar2;

     DBUG_ENTER("AtBarPlotAttachData");  

     if (argc < 3) 
	 {
	 wafeArgcError("AtBarPlotAttachData","at least ",2,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],atBarPlotWidgetClass,"AtBarPlot")))
          {
          wafeConvError("AtBarPlotAttachData","1",argv[1],"AtBarPlotWidget");
          DBUG_RETURN (TCL_ERROR);
          }

     {    float *ptr;
          argv += 2;
          localVar2 = ptr =
             (float *)XtMalloc((argc-2)*sizeof(float));

          while (*argv)
             {
             if (!(sscanf(*argv, "%f", &*ptr)))
                  {
                  wafeConvError("AtBarPlotAttachData","2",*argv,"float");
                  DBUG_RETURN (TCL_ERROR);
                  }

          ptr ++; argv++;
          }
     }
     AtBarPlotAttachData(localVar1,castXtPointer(localVar2),AtFloat,sizeof(float),1,argc-2);
     wafeMMreplace(wafeMMgetAttribList(localVar1,True),WafePermStringToQuark("AtBarPlotAttachData"),(char*)localVar2,XtFree);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * AtLabelAxisAttachData
 *         in: AtLabelAxisWidget		# label axis wiget
 * 	in: [char *]			# strings
 * 	const: sizeof(String)
 * 	const: 1
 * 	const: argc-2
 */

static int 
cmd_AtLabelAxisAttachData(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     char * * localVar2;

     DBUG_ENTER("AtLabelAxisAttachData");  

     if (argc < 3) 
	 {
	 wafeArgcError("AtLabelAxisAttachData","at least ",2,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],atLabelAxisWidgetClass,"AtLabelAxis")))
          {
          wafeConvError("AtLabelAxisAttachData","1",argv[1],"AtLabelAxisWidget");
          DBUG_RETURN (TCL_ERROR);
          }

     {    char * *ptr;
          argv += 2;
          localVar2 = ptr =
             (char * *)XtMalloc((argc-2)*sizeof(char *));

          while (*argv)
             {
             *ptr = XtNewString(*argv);
          ptr ++; argv++;
          }
     }
     AtLabelAxisAttachData(localVar1,localVar2,sizeof(String),1,argc-2);
     wafeMMreplace(wafeMMgetAttribList(localVar1,True),WafePermStringToQuark("AtLabelAxisAttachData"),(char*)localVar2,XtFree);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * AtLinePlotAttachData
 *         in: AtLinePlotWidget		# line plot widget
 * 	in: castXtPointer([float])	# floats
 * 	const: AtFloat
 * 	const: sizeof(float)
 * 	const: 1
 * 	const: argc-2
 */

static int 
cmd_AtLinePlotAttachData(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     float * localVar2;

     DBUG_ENTER("AtLinePlotAttachData");  

     if (argc < 3) 
	 {
	 wafeArgcError("AtLinePlotAttachData","at least ",2,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],atLinePlotWidgetClass,"AtLinePlot")))
          {
          wafeConvError("AtLinePlotAttachData","1",argv[1],"AtLinePlotWidget");
          DBUG_RETURN (TCL_ERROR);
          }

     {    float *ptr;
          argv += 2;
          localVar2 = ptr =
             (float *)XtMalloc((argc-2)*sizeof(float));

          while (*argv)
             {
             if (!(sscanf(*argv, "%f", &*ptr)))
                  {
                  wafeConvError("AtLinePlotAttachData","2",*argv,"float");
                  DBUG_RETURN (TCL_ERROR);
                  }

          ptr ++; argv++;
          }
     }
     AtLinePlotAttachData(localVar1,castXtPointer(localVar2),AtFloat,sizeof(float),1,argc-2);
     wafeMMreplace(wafeMMgetAttribList(localVar1,True),WafePermStringToQuark("AtLinePlotAttachData"),(char*)localVar2,XtFree);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * AtPlotterGeneratePostscript
 *         in: char *            		       # file name
 *         in: (AtPlotterWidget)AtPlotterWidget   # plotter widget
 * 	in: char *            		       # title
 * 	in: int               		       # bounding box: x1
 * 	in: int              		       # bounding box: y1
 * 	in: int               		       # bounding box: x2
 * 	in: int               		       # bounding box: y2
 * 	in: Boolean           		       # landscape
 */

static int 
cmd_AtPlotterGeneratePostscript(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar2;
     int localVar4;
     int localVar5;
     int localVar6;
     int localVar7;
     Boolean localVar8;

     DBUG_ENTER("AtPlotterGeneratePostscript");  

     if (argc != 9) 
	 {
	 wafeArgcError("AtPlotterGeneratePostscript","",8,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

    /* no need to assign  << localVar1 = argv[1] >>  */ 

     if (!(localVar2 =  name2WidgetOfClass(argv[2],atPlotterWidgetClass,"AtPlotter")))
          {
          wafeConvError("AtPlotterGeneratePostscript","2",argv[2],"AtPlotterWidget");
          DBUG_RETURN (TCL_ERROR);
          }

    /* no need to assign  << localVar3 = argv[3] >>  */ 

     if (!(sscanf(argv[4], "%d", &localVar4)))
          {
          wafeConvError("AtPlotterGeneratePostscript","4",argv[4],"int");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(sscanf(argv[5], "%d", &localVar5)))
          {
          wafeConvError("AtPlotterGeneratePostscript","5",argv[5],"int");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(sscanf(argv[6], "%d", &localVar6)))
          {
          wafeConvError("AtPlotterGeneratePostscript","6",argv[6],"int");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(sscanf(argv[7], "%d", &localVar7)))
          {
          wafeConvError("AtPlotterGeneratePostscript","7",argv[7],"int");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!strcmp(argv[8], "false")) 
         localVar8 = 0;
     else
     if (!strcmp(argv[8], "true")) 
         localVar8 = 1;
     else
         {
         wafeConvError("AtPlotterGeneratePostscript","8",argv[8],"Boolean");
         DBUG_RETURN (TCL_ERROR);
        }


     AtPlotterGeneratePostscript(argv[1],localVar2,argv[3],localVar4,localVar5,localVar6,localVar7,localVar8);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * ******* begin required file <AtHandCraft.inc> *******
 */
/* yes, it is really  -*-C-*-  */

static void
xyLinePlotAttachData(w,argc,argv)
Widget    w;
int       argc;
char    **argv;
     {
     int count;
     float *x,*xarray, *y,*yarray;

     x = xarray = (float *)XtMalloc(sizeof(float)*argc);
     y = yarray = (float *)XtMalloc(sizeof(float)*argc);

     for (count = 0; count < argc; count++,x++,y++)
         {
         if (!(sscanf(argv[count],"%f/%f",x,y)))
              {
              wafeConvError("xyLinePlotAttachData",
			    "in array", argv[count],"x/y");
              return;
              }
          }

     AtXYLinePlotAttachData(w,
			    (XtPointer)xarray, AtFloat, sizeof(float),
			    (XtPointer)yarray, AtFloat, sizeof(float),
			    1,argc);

     wafeMMreplace(wafeMMgetAttribList(w,True),
		   WafePermStringToQuark("LinePlotXData"),
		   (char*)xarray,XtFree);
     wafeMMreplace(wafeMMgetAttribList(w,True),
		   WafePermStringToQuark("LinePlotYData"),
		   (char*)yarray,XtFree);
     }     



/* 
 * ******* end required file <AtHandCraft.inc> *******
 */
/* 
 * void
 * xyLinePlotAttachData vulgo AtXYLinePlotAttachData
 *         in: AtXYLinePlotWidget		# xyLine plot widget
 * 	in: [args]			# pairs of floats (xfloat/yfloat)

 */

static int 
cmd_AtXYLinePlotAttachData(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;

     DBUG_ENTER("AtXYLinePlotAttachData");  

     if (argc < 3) 
	 {
	 wafeArgcError("AtXYLinePlotAttachData","at least ",2,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],atXYLinePlotWidgetClass,"AtXYLinePlot")))
          {
          wafeConvError("AtXYLinePlotAttachData","1",argv[1],"AtXYLinePlotWidget");
          DBUG_RETURN (TCL_ERROR);
          }

     argc -= 2;
     xyLinePlotAttachData(localVar1,argc,&argv[2]);

     DBUG_RETURN (TCL_OK);
     }     


#else
#endif

void
wafeInitialize_AtGen()
{
#ifdef PLOTTER
 wafeCreateWidgetCommand("AtAxis",atAxisWidgetClass,NULL,False);
 wafeCreateWidgetCommand("AtBarPlot",atBarPlotWidgetClass,NULL,False);
 wafeCreateWidgetCommand("AtLabelAxis",atLabelAxisWidgetClass,NULL,False);
 wafeCreateWidgetCommand("AtLinePlot",atLinePlotWidgetClass,NULL,False);
 wafeCreateWidgetCommand("AtPlotter",atPlotterWidgetClass,NULL,False);
 wafeCreateWidgetCommand("AtTextPlot",atTextPlotWidgetClass,NULL,False);
 wafeCreateWidgetCommand("AtXYAxis",atXYAxisWidgetClass,NULL,False);
 wafeCreateWidgetCommand("AtXYLinePlot",atXYLinePlotWidgetClass,NULL,False);
#ifdef PLOTTER
 strcat(wafePackages,"PLOTTER ");
#endif
 Tcl_CreateCommand(wafeInterpreter, "AtBarPlotAttachData", cmd_AtBarPlotAttachData, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "AtLabelAxisAttachData", cmd_AtLabelAxisAttachData, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "AtLinePlotAttachData", cmd_AtLinePlotAttachData, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "AtPlotterGeneratePostscript", cmd_AtPlotterGeneratePostscript, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "AtXYLinePlotAttachData", cmd_AtXYLinePlotAttachData, NULL, NULL);

#else
#endif
}
