#define RESOURCES_C
#include "wafe.h"

typedef struct _RESINFO
     {
     WidgetClass       wClass;
     QTypeList         resources;
     Cardinal          num;
     struct _RESINFO  *next;
     } RESINFO, *RESINFOPTR;

static RESINFOPTR  resourceList = NULL;
static RESINFOPTR  constraintList = NULL;

/*
 * The following function returns the address from the corresponding
 * attribute/type list.
 */

addResInfo *
getAddRes(
#if NeedFunctionPrototypes
     WidgetClass, Cardinal *
#endif
);

#ifdef ATHENA
#include <X11/Xaw/AsciiText.h>
#endif

/*****************************************************************************
 *  The following functions maintain the global lists of ResourceLists, 
 *  one for normal widgets and one for constraint resources. They look up the
 *  resources registered for a specified widget class and - if they are 
 *  queried for the first time - append the new resourceList. In each 
 *  appended resourceList, the string name of the ressource will be 
 *  substituted by a quark representation.
 *****************************************************************************/

static QTypeList
resList2QTypeList(rList, rNum, addResPtr, addNum)
XtResourceList  rList;
int   rNum;
addResInfo *addResPtr;
Cardinal   addNum;
    {
    int i;
    QTypeList  returnList, ptr;

    returnList = ptr = 
	(QTypeList) XtMalloc((rNum + addNum) * sizeof(QType) + 1);

    for (i = 0; i < rNum; i++)
	{
	ptr->qName = XrmStringToQuark(rList[i].resource_name);
	ptr->type =  XtNewString(rList[i].resource_type);
	ptr->qType = WafePermStringToQuark(ptr->type);
	ptr++;
	}

    for (i = 0; i < addNum; i++)
	{
	ptr->qName = XrmStringToQuark(addResPtr[i].resource_name);
	ptr->type =  addResPtr[i].resource_type;
	ptr->qType = WafePermStringToQuark(ptr->type);
	ptr++;
	}

    XtFree((char *)rList);

    return(returnList);
    }



Cardinal
getResOfClass(wClass, qList)
WidgetClass wClass;
QTypeList  *qList;
    {
    Cardinal  num;
    RESINFOPTR  ptr, lptr;
    XtResourceList resListPtr;
    addResInfo *addResPtr;
    Cardinal    addNum;
    Boolean     disposeAddResPtr = False;
    

    if (resourceList)  /* there exist already some entries */
	{
	for (lptr = resourceList; 
	     lptr != NULL; 
	     ptr = lptr, lptr = lptr->next) 
	    if (lptr->wClass == wClass)
		{
		*qList = lptr->resources;
		return(lptr->num);
		}
	ptr->next = (RESINFOPTR) XtMalloc(sizeof(RESINFO));
	ptr = ptr->next;
	}
    else
	ptr = resourceList = (RESINFOPTR) XtMalloc(sizeof(RESINFO));
        
    ptr->next = NULL;
    ptr->wClass = wClass;

    XtInitializeWidgetClass(wClass);  /* Just in case it is not yet done... */
    XtGetResourceList(wClass, &resListPtr, &num);



#ifdef ATHENA
    /* fetch ATHENA AsciiText's subpart resources here! */

    if (wClass == asciiTextWidgetClass)  /* check asciiText's subresources */
	{
	XtResourceList rList[2], rl;
	Cardinal       rNum[2];
	addResInfo    *ptr;
	int           i,j;
	
	XtInitializeWidgetClass(asciiSinkObjectClass);
	XtInitializeWidgetClass(asciiSrcObjectClass);

	XtGetResourceList(asciiSinkObjectClass, &rList[0], &rNum[0]);
	XtGetResourceList(asciiSrcObjectClass, &rList[1], &rNum[1]);

	addNum = rNum[0] + rNum[1];
	addResPtr = (addResInfo *)XtMalloc( (addNum+1)*sizeof(addResInfo));

	for(i=0, ptr=addResPtr; i<2; i++) 
	    for(j=0, rl=rList[i], j=rNum[i]; j>0; j--, rl++, ptr++)
		{
		ptr->resource_name = XtNewString(rl->resource_name);
		ptr->resource_type = XtNewString(rl->resource_type);
		}
        /* *addResPtr  would be wasted, since the values are copied */
	disposeAddResPtr = True;
	}
    else
	{
	addResPtr = Nil(addResInfo);
	addNum = 0;
	}

#else
    addResPtr = getAddRes(wClass, &addNum);
#endif
    *qList = 
	ptr->resources = 
	resList2QTypeList(resListPtr, num, addResPtr, addNum);

    if (disposeAddResPtr) 
	XtFree((char *) addResPtr);

    ptr->num = num + addNum;
    return(ptr->num);
    } 

Cardinal
getConOfClass(wClass, qList)
WidgetClass wClass;
QTypeList  *qList;
    {
    Cardinal  num;
    RESINFOPTR  ptr, lptr;
    XtResourceList conListPtr;

    if (constraintList)  /* there exist already some entries */
	{
	for (lptr = constraintList; lptr != NULL; ptr = lptr, lptr = lptr->next) 
	    if (lptr->wClass == wClass)
		{
		*qList = lptr->resources;
		return(lptr->num);
		}
	ptr->next = (RESINFOPTR) XtMalloc(sizeof(RESINFO));
	ptr = ptr->next;
	}
    else
	ptr = constraintList = (RESINFOPTR) XtMalloc(sizeof(RESINFO));
        
    ptr->next = NULL;
    ptr->wClass = wClass;

    XtGetConstraintResourceList(wClass, &conListPtr, &num);

    *qList = ptr->resources = resList2QTypeList(conListPtr, num, NULL,0);
    ptr->num = num;
    return(num);
    } 



/*****************************************************************************
 *  FUNCTION:  getQTypeOfAttribute 
 *                                  
 *  Arguments: Widgetclass, parent widget and Quark of attribute to be queried.
 *  Returns:   Type of the attribute as a Quark or NULL.                     
 *                                                                      
 *  Used by    getValues, convert 
 *
 * Vielleicht wre es besser, eine Struktur mit einem String und einem Quark
 * zu retournieren, um ein etwaiges Zurckumwandeln zu ersparen. 
 * Dringlichkeitsstufe: 0
 *****************************************************************************/

XrmQuark
getQTypeOfAttribute(wClass, parent, qAttribute)
WidgetClass     wClass;
Widget          parent;
XrmQuark        qAttribute;
    {
    QTypeList    resList;
    int          i, count;

 /* Check standard resources of this class */
    count = getResOfClass(wClass, &resList);  

/*
    for (i = 0; i < count; i++)
	if (qAttribute == resList[i].qName)
	    return(resList[i].qType);
 */        

    for (i = 0; i < count; i++, resList++)
	if (qAttribute == resList->qName)
	    return(resList->qType);
          
    if (XtIsConstraint(parent))    /* check Constraints if there are any... */
	{
	count = getConOfClass(XtClass(parent), &resList);

	for (i = 0; i < count; i++, resList++)
	    if (qAttribute == resList->qName)
		return(resList->qType);
	}
    else if (XtIsShell(parent)) 
	{
	count = getResOfClass(XtClass(parent), &resList);

	for (i = 0; i < count; i++, resList++)
	    if (qAttribute == resList->qName)
		return(resList->qType);
	}

    return((XrmQuark)NULL); 
    }

