/*
 * Copyright (C) 1992 by Gustaf Neumann, Stefan Nusser
 *
 *      Wirtschaftsuniversitaet Wien,
 *      Abteilung fuer Wirtschaftsinformatik
 *      Augasse 2-6,
 *      A-1090 Vienna, Austria
 *      neumann@wu-wien.ac.at, nusser@wu-wien.ac.at
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided
 * that the above copyright notice appears in all copies and that both that
 * copyright notice and this permission notice appear in all supporting
 * documentation.  This software is provided "as is" without expressed or
 * implied warranty.
 *
 * Date: Mon, Apr 13 1992
 * Author: Stefan Nusser
 * Version: 0.9
 */

/* 
 *            Code fuer List -  Widget
 *
 */


#define EDW_MAX_ITEM_LENGTH 200

int edwchanged = 0;

void
edwListChange(w, widgetName, nitems, longest, resize, argc, argv)
Widget     w;
String     widgetName;
int        nitems;
int        longest;
int        resize;
int           argc;
char        **argv;
     {
     int      index;
     short    i = 0;
     FILE    *fp;
     XedwList   **list, **count, **oldList;
     char     buffer [EDW_MAX_ITEM_LENGTH] ;         

     if (!strcmp(argv[0], "Arg"))
          {                      
          list = count = (XedwList **)XtMalloc(argc*sizeof(XedwList*)); 

          for (index = 1; index < argc; index+=2)
	      {
	      Pixmap icon = NULL;
	      list[i] = (XedwList*)XtMalloc(sizeof(XedwList));
              list[i]->string = XtNewString(argv[index]);
	      if (argv[index+1][0]) 
                  {
     		  XrmValue          input;
     	  	  XrmValue          output;
                  input.addr =   argv[index+1];
                  input.size =   strlen(input.addr)+1;
                  output.addr =  NULL;


                  if (CONVERTANDSTORE(w, "String", &input,"Pixmap", &output))
		      {
		      icon = (Pixmap) *(long *)output.addr;
		      /* fprintf(stderr,"i did convert, len=%d, val=%d\n",output.size,icon); */
		      }
		  else 
		      fprintf(stderr, "cound not convert <%s> to Pixmap\n",
			      argv[index+1]);
		  }
	      list[i]->icon = icon;
              i++;
	      }
	  
          list[i] = NULL;
	  }

     XtVaGetValues(w, XtNxedwList, &oldList, NULL);
     XedwListChange(w, list, nitems, longest, resize);

     if (edwchanged)   /* will NOT work for more than 1 edwlist item -gustaf */
	 {
	 i=0;
	 while (oldList[i])
	     {
	     XtFree(oldList[i]->string);
	     XtFree((char*)oldList[i]);
	     i++;
	     }

	 XtFree((char*)(oldList));
	 }

     edwchanged = 1;
     return;
     }
  
void
edwListCallbackProc(w, clientData, callData)
Widget     w;
XtPointer  clientData, callData;
     {
     char     command[MESSAGE_COMMAND_LENGTH];       
     char     buffer[INT_AS_STRING];  
     char    *input = (char *) clientData;
     char    *output = command;

     DBUG_ENTER("listCallbackProc");

     while (*input != '\0')
          {
          if (*input == '%')
               {
               input++;
               if (*input == 'w')
                    {
                    strcpy (output, XtName(w));
                    output += strlen(XtName(w));
                    }
               else
               if (*input == 's')
                    {
                    strcpy (output, ((XedwListReturnStruct *)callData)->string);
                    output += strlen(((XedwListReturnStruct *)callData)->string);
                    }
               else
               if (*input == 'i')
                    {
                    sprintf(buffer, "%d", 
                          ((XedwListReturnStruct *)callData)->xedwList_index);
                    strcpy(output, buffer);
                    output += strlen(buffer);                    
                    }
               else
		    {
                    *output = '%';
                    output++;
                    input--;
		    }
	       }
          else 
               {
               *output = *input;
               output++;
	       }
          input++;
	  }

     *output = '\0';
  
     DBUG_PRINT("list", (">%s<", command));
     (void) wafeEval(interpreter, command,"edwList");
     DBUG_VOID_RETURN;
     }


