/* it is -*- c -*- ! */


/* used by addTimeOut */

void
timerProc(command, junk)
XtPointer        command;
XtIntervalId     *junk;
    {
    DBUG_ENTER("timerProc");
    (void) wafeEval(interpreter, (char *)command, "timerProc");
    XtFree((char *)command);
    DBUG_VOID_RETURN;
    }




char *
cvtToString(clientData, quarkOfType, freeProcPtr)
XtPointer     clientData;
XrmQuark      quarkOfType;
freeProc      *freeProcPtr;
    {
    XrmValue   input,output;
    
    DBUG_PRINT("cvtToString", ("Converting to <%s>", 
			       XrmQuarkToString(quarkOfType)));

    input.addr  =  clientData;            /* ??? */
    input.size  =  sizeof(XtPointer);     /* ??? */
    output.addr =  NULL;

    IFCONVERTANDSTORE(topLevel, 
		      XrmQuarkToString(quarkOfType),input, 
		      "String", output)
	{
	*freeProcPtr = XtFree;
	return output.addr;
	}
    else
	return NULL;
    }



String
getValue(w, Qname, freeProcPtr)
Widget        w;
XrmQuark      Qname;
freeProc     *freeProcPtr;
    {
    char      *result;
    XrmQuark   Qtype;
    XtPointer  value;
    Arg        arg;

    DBUG_PRINT("getValue", ("widget is %p resource is <%s>",
			    w,XrmQuarkToString(Qname))); 

    if (!(Qtype = getQTypeOfAttribute(XtClass(w), ParentWidget(w), Qname)))
	{
	fprintf(stderr, "Wafe(getValues): Unknown Attribute %s\n",
		XrmQuarkToString(Qname));
	*freeProcPtr = TCL_STATIC;
	return NULL;
	}

    if (Qtype == qString)
	{
	String    valueString;
	*freeProcPtr = TCL_VOLATILE;
	XtVaGetValues(w, XrmQuarkToString(Qname), &valueString, NULL);
	return valueString;
	}

    /* this is the Default value for the following types 
     * assuming that dense code is better than one instruction more
     */ 
    *freeProcPtr = XtFree;
	
    if (Qtype == qInt) 
	{
	int valueInt;
	result = XtMalloc(INT_AS_STRING);
	XtVaGetValues(w, XrmQuarkToString(Qname), &valueInt, NULL);
	sprintf(result, "%d", (int)valueInt);
	return result;
	}

    if (Qtype == qPosition) 
	{
	Position    valuePosition;
	result = XtMalloc(INT_AS_STRING);
	XtVaGetValues(w, XrmQuarkToString(Qname), &valuePosition, NULL);
	sprintf(result, "%hd", valuePosition);
	return result;
        }
#ifdef MOTIF11
    if (Qtype == qTextPosition) 
	{
	XmTextPosition    valuePosition;
	result = XtMalloc(INT_AS_STRING);
	XtVaGetValues(w, XrmQuarkToString(Qname), &valuePosition, NULL);
	sprintf(result, "%ld", valuePosition);
	return result;
        }
#endif

    if (Qtype == qDimension
#ifdef MOTIF11
	|| Qtype == qVerticalDimension
	|| Qtype == qHorizontalDimension
#endif
	) 
	{
	Dimension    valueDimension;
	result = XtMalloc(INT_AS_STRING);
	XtVaGetValues(w, XrmQuarkToString(Qname), &valueDimension, NULL);
	sprintf(result, "%hu", valueDimension);
	return result;
        }

    if (Qtype == qCardinal)
	{
	Cardinal    valueCardinal;
	result = XtMalloc(INT_AS_STRING);
	XtVaGetValues(w, XrmQuarkToString(Qname), &valueCardinal, NULL);
	sprintf(result, "%u", valueCardinal);	
	return result;
	}

    if (Qtype == qBoolean)
	{
	Boolean    valueBoolean;
	*freeProcPtr = TCL_STATIC;
	XtVaGetValues(w, XrmQuarkToString(Qname), &valueBoolean, NULL);
	return valueBoolean ? "true" : "false";   
	}


    if (Qtype == qFloat) 
	{
	float    valueFloat;
	result = XtMalloc(FLOAT_AS_STRING);
	XtVaGetValues(w, XrmQuarkToString(Qname), &valueFloat, NULL);
	sprintf(result, "%f", valueFloat);
	return result;
	}

    if (Qtype == qDouble) 
	{
	double    valueDouble;
	result = XtMalloc(FLOAT_AS_STRING);
	XtVaGetValues(w, XrmQuarkToString(Qname), &valueDouble, NULL);
	sprintf(result, "%f", valueDouble);
	return result;
	}

    if (Qtype == qPixel) 
	{
	XColor  c;
	Display *dsp = XtDisplay(w);
	result = XtMalloc(8); /* "#RRGGBB" */
	XtVaGetValues(w, XrmQuarkToString(Qname), &(c.pixel), NULL);
	XQueryColor(dsp,DefaultColormap(dsp, DefaultScreen(dsp)),&c);
	sprintf(result, "#%02X%02X%02X", 
		(int)(c.red>>8), (int)(c.green>>8), (int)(c.blue>>8));
	return result;
	}

     /* Callbacks sind ... anders: die String-Information 
	kommt aus wafe's privatem Memory-Management und nicht 
	ber getValues!
      */
    if (Qtype == qCallback) 
	{
	MMattribListPtr ptr = *MMgetAttribList(w);
	
	*freeProcPtr = TCL_STATIC;
	result = "";
	while(ptr) 
	    {
	    if (ptr->attribute == Qname) 
		{
		result = ((char*)ptr->value) +
		    sizeof(XtCallbackList)*2 +
		    sizeof(XtCallbackRec[2]) +
		    sizeof(XrmQuark);
		break;
		}
	    ptr = ptr->next;
	    }
	return result;
	}

    if (Qtype == qWidget
#ifdef MOTIF11
	|| Qtype == qWindow
#endif
	)
	{
	Widget valueWidget;
	*freeProcPtr = TCL_STATIC;
	XtVaGetValues(w, XrmQuarkToString(Qname), &valueWidget, NULL);
	return widget2Name(valueWidget);
	}

    if (Qtype == qWidgetList) 
        {
	Widget  *children, *wPtr;
        int      numChildren;
        int      i, length=0;

        XtVaGetValues(w, XtNnumChildren, &numChildren,
                            XtNchildren,    &children,    NULL);
        for (i=0, wPtr=children; i<numChildren; i++, wPtr++)
	   {
	   length += strlen(XtName(*wPtr)) + 2;
	   }
	result = XtMalloc(length);
	*result = '\0';
        for (i=0, wPtr=children; i<numChildren; i++, wPtr++)
	    {
            strcat(result,XtName(*wPtr));
            strcat(result," ");
            }
	return result;
        }

    else 
	{
	  /*
	   * warning: cvtToString assumes, you can free the result 
	   * using XtFree
	   */
	XtSetArg(arg, XrmQuarkToString(Qname), &value);
	XtGetValues(w, &arg, (Cardinal)1);

	if (!(result = cvtToString(value, Qtype, freeProcPtr)))
	  {
	    fprintf(stderr, "Wafe(getValues): Couldn't convert value\n");
	    return NULL;
	  }
	return result;
      }
    }


int
getResourceList(w, resultPtr)
char    ***resultPtr; 
Widget   w;
    {
    int numTotal, count;
    char **result;
    int rNum = 0;
    int cNum = 0;
    QTypeList rList, cList;

    rNum = getResOfClass(XtClass(w), &rList);

    if (XtIsConstraint(ParentWidget(w)))   /* If parentWidget is constrain widget => fetch constraints */
	cNum =  getConOfClass(XtClass(ParentWidget(w)), &cList);

    numTotal = rNum + cNum;

    *resultPtr = result = (char **)XtMalloc(numTotal *sizeof(char *));       


    for ( count = 0; count < rNum; count++)
	*result++ = XrmQuarkToString(rList[count].qName);

    for ( count = 0; count < cNum; count++)
	*result++ = XrmQuarkToString(cList[count].qName);

    return(numTotal);
    }




