/* Copyright (C) 1992 by Gustaf Neumann, Stefan Nusser

 *      Wirtschaftsuniversitaet Wien, 
 *      Abteilung fuer Wirtschaftsinformatik
 *      Augasse 2-6, 
 *      A-1090 Vienna, Austria
 *      neumann@wu-wien.ac.at, nusser@wu-wien.ac.at

 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided
 * that the above copyright notice appears in all copies and that both that
 * copyright notice and this permission notice appear in all supporting
 * documentation.  This software is provided "as is" without expressed or
 * implied warranty.

 * Creation: Mon Oct 11 06:38:21 MET 1993 on dec1.wu-wien.ac.at
 * Author: genc
 * Version: 0.95999999999999996

 */
#ifdef ATHENAR5

#define ATHENAR5_C

#include "wafe.h"                             
#include <X11/Xaw/Panner.h>
#include <X11/Xaw/Porthole.h>
#include <X11/Xaw/Tree.h>
#include <X11/Xaw/Repeater.h>

extern void portholeCallbackProc();
extern void pannerCallbackProc();

#define talk(pa, po, ch) XtAddCallback(po, XtNreportCallback, portholeCallbackProc, (XtPointer) pa); XtAddCallback(pa, XtNreportCallback, pannerCallbackProc, (XtPointer) ch)

/* 
 * void
 * talk
 * 	in: PannerWidget	# panner
 * 	in: PortholeWidget	# porthole
 * 	in: Widget		# managed widget
 */

int 
com_talk(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     Widget localVar2;
     Widget localVar3;

     DBUG_ENTER("talk");  

     if (argc != 4) 
	 {
	 argcError("talk","",3,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],pannerWidgetClass,"Panner")))
          {
          convError("talk","1",argv[1],"PannerWidget");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(localVar2 =  name2WidgetOfClass(argv[2],portholeWidgetClass,"Porthole")))
          {
          convError("talk","2",argv[2],"PortholeWidget");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(localVar3 = (Widget) name2Widget(argv[3])))
          {
          convError("talk","3",argv[3],"Widget");
          DBUG_RETURN (TCL_ERROR);
          }

     talk(localVar1,localVar2,localVar3);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XawTreeForceLayout
 * 	in: TreeWidget		# tree Widget

 */

int 
com_treeForceLayout(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;

     DBUG_ENTER("treeForceLayout");  

     if (argc != 2) 
	 {
	 argcError("treeForceLayout","",1,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],treeWidgetClass,"Tree")))
          {
          convError("treeForceLayout","1",argv[1],"TreeWidget");
          DBUG_RETURN (TCL_ERROR);
          }

     XawTreeForceLayout(localVar1);

     DBUG_RETURN (TCL_OK);
     }     


#else
#include "wafe.h"
#endif

void
Initialize_XawR5Gen()
{
#ifdef ATHENAR5
 createWidgetCommand("panner",pannerWidgetClass,NULL,False);
 createWidgetCommand("porthole",portholeWidgetClass,NULL,False);
 createWidgetCommand("repeater",repeaterWidgetClass,NULL,False);
 createWidgetCommand("tree",treeWidgetClass,NULL,False);
#ifdef XAWR5
 strcat(wafePackages,"XAWR5 ");
#endif
 Tcl_CreateCommand(wafeInterpreter, "talk", com_talk, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "treeForceLayout", com_treeForceLayout, NULL, NULL);

#else
 createWidgetCommand("panner",NULL,NULL,False);
 createWidgetCommand("porthole",NULL,NULL,False);
 createWidgetCommand("repeater",NULL,NULL,False);
 createWidgetCommand("tree",NULL,NULL,False);
#endif
}
