/************************************<+>*************************************
 ****************************************************************************
 **
 **   File:        Graph.h
 **
 **   Project:     Motif -- OSF X User Environment Widget Set
 **
 **   Description: Public include file for the XmLabel class
 **
 **
 **   (c) Copyright 1989 by Hewlett-Packard Company
 ****************************************************************************
 *************************************<+>************************************/

#ifndef _XmGraph_h
#define _XmGraph_h

/* Class record constant */

externalref WidgetClass xmGraphWidgetClass;
typedef struct _XmGraphClassRec 		*XmGraphWidgetClass;
typedef struct _XmGraphRec      		*XmGraphWidget;


#include <Xm/Xm.h>

#ifndef XmIsGraph
#define XmIsGraph (w)	XtIsSubclass(w, xmGraphWidgetClass)
#endif


/******************* CONVENIENCE FUNCTIONS **********************/

/* creates and returns an instance of the graph widget */

#ifndef _NO_PROTO

extern Widget XmCreateGraph(Widget,String,ArgList,Cardinal);
extern Widget XmCreateManagedGraph (Widget,String,ArgList,Cardinal);
extern Widget XmCreateScrolledGraph(Widget,String,ArgList,Cardinal);

extern  void       XmGraphAddNode(Widget);
extern  void       XmGraphCenterAroundWidget(Widget, Widget);
extern  void       XmGraphDestroyAllArcs(Widget);
extern  void       XmGraphDestroyAllNodes(Widget);
extern  void       XmGraphDestroySelectedArcsOrNodes(Widget);
extern  void       XmGraphGetArcNodes(Widget, Widget, Widget *, Widget *);
extern  WidgetList XmGraphGetArcsBetweenNodes(Widget, Widget, Widget, int *);
extern  WidgetList XmGraphGetArcs(Widget, int *);
extern  void 	   XmGraphGetNodeArcs(Widget, Widget, 
				   WidgetList *, WidgetList *, int *, int *);
extern  WidgetList XmGraphGetNodes(Widget, int *);
extern  WidgetList XmGraphGetRoots(Widget, int *);
extern  WidgetList XmGraphGetSelectedArcs(Widget,int *);
extern  WidgetList XmGraphGetSelectedNodes(Widget,int *);
extern  Widget     XmGraphInputOverArc(Widget, int, int);
extern  void       XmGraphInsertRoots(Widget, WidgetList, int);
extern  Boolean    XmGraphIsPointInArc(Widget, int, int);
extern  Boolean    XmGraphIsSelectedArc(Widget, Widget);
extern  Boolean    XmGraphIsSelectedNode(Widget, Widget);
extern  void       XmGraphLayout(Widget);
extern  void 	   XmGraphMoveAll(Widget, int, int);
extern  Boolean    XmGraphMoveArc(Widget, Widget, Widget, Widget);
extern  Boolean    XmGraphMoveNode(Widget,Widget, Position, Position);
extern  int        XmGraphNumArcs(Widget);
extern  int        XmGraphNumNodes(Widget);
extern  int        XmGraphNumNodeArcs(Widget, Widget, int * , int *);
extern  int        XmGraphNumRoots(Widget);
extern  int        XmGraphNumSelectedArcs(Widget);
extern  int        XmGraphNumSelectedNodes(Widget);
extern  void       XmGraphRelaySubgraph(Widget, Widget);
extern  void       XmGraphRemoveArcBetweenNodes(Widget, Widget, Widget);
extern  void       XmGraphRemoveRoots(Widget, WidgetList, int);
extern  void       XmGraphSelectNode(Widget,Widget);
extern  void       XmGraphSelectNodes(Widget, WidgetList, int);
extern  void       XmGraphSelectArc(Widget, Widget);
extern  void       XmGraphSelectArcs(Widget, WidgetList, int);
extern  void       XmGraphUnselectArc(Widget,Widget);
extern  void       XmGraphUnselectArcs(Widget, WidgetList, int);
extern  void       XmGraphUnselectNode(Widget,Widget);
extern  void       XmGraphUnselectNodes(Widget,WidgetList, int);

#else    /* _NO_PROTO */

extern Widget XmCreateGraph();
extern Widget XmCreateManagedGraph ();
extern Widget XmCreateScrolledGraph();
extern Widget XmCreateArc ();
extern Widget XmCreateAttachedArc ();

extern  void    XmGraphGetArcNodes();
extern  void    XmGraphGetNodeArcs();
extern  Widget  XmGraphInputOverArc();
extern  void    XmGraphInsertRoots();
extern  Boolean XmGraphIsSelectedArc();
extern  Boolean XmGraphMoveArc();
extern  Boolean XmGraphMoveNode();
extern  void    XmGraphSelectNode();
extern  void    XmGraphSelectNodes();
extern  void    XmGraphSelectArc();
extern  void    XmGraphSelectArcs();

extern  void XmGraphCenterAroundWidget();
extern  void XmGraphDestroyAllArcs();
extern  void XmGraphDestroyAllNodes();
extern  void XmGraphDestroySelectedArcsOrNodes();
extern  WidgetList XmGraphGetArcsBetweenNodes();
extern  WidgetList XmGraphGetArcs();
extern  WidgetList XmGraphGetNodes();
extern  WidgetList XmGraphGetRoots();
extern  WidgetList XmGraphGetSelectedArcs();
extern  WidgetList XmGraphGetSelectedNodes();
extern  Boolean XmGraphIsPointInArc();
extern  Boolean XmGraphIsSelectedNode();
extern  int XmGraphNumArcs();
extern  int XmGraphNumNodes();
extern  int XmGraphNumNodeArcs();
extern  int XmGraphNumRoots();
extern  int XmGraphNumSelectedArcs();
extern  int XmGraphNumSelectedNodes();
extern  void XmGraphMoveAll();
extern  void XmGraphLayout();
extern  void XmGraphRelaySubgraph();
extern  void XmGraphRemoveArcBetweenNodes();
extern  void XmGraphRemoveRoots();
extern  void XmGraphUnselectArc();
extern  void XmGraphUnselectArcs();
extern  void XmGraphUnselectNode();
extern  void XmGraphUnselectNodes();
extern void XmGraphAddNode();
#endif /*_NO_PROTO */


#define XmNtwinsVisible     "twinsVisible"
#define XmCTwinsVisible     "TwinsVisible"

#define XmNarcDrawMode      "arcDrawMode"
#define XmCArcDrawMode      "ArcDrawMode"


#define XmNautoLayoutMode   "autoLayoutMode"
#define XmCAutoLayoutMode   "AutoLayoutMode"

#define XmNreLayout	    "reLayout"
#define XmCReLayout	    "ReLayout"

#define XmNreorient         "reorient"
#define XmCReorient         "Reorient"

#define XmNchildSpacing     "childSpacing"
#define XmCChildSpacing     "ChildSpacing" 

#define XmNsiblingSpacing   "siblingSpacing"
#define XmCSiblingSpacing   "SiblingSpacing" 

#define XmNsaveGraph       "saveGraph"
#define XmCSaveGraph       "SaveGraph"

#define XmNsaveFileName     "saveFileName"
#define XmCSaveFileName     "SaveFileName"

	/* these have class XmCCallback  */

#define XmNnewArcCallback           "newArcCallback"

#define XmNnewNodeCallback	    "newNodeCallback"
#define XmNallowMultipleSelections  "allowMultipleSelections"
#define  XmCAllowMultipleSelections "AllowMultipleSelections"

#define XmNnodeMovedCallback	    "nodeMovedCallback"

#define XmNarcMovedCallback	    "arcMovedCallback"

#define XmNselectNodeCallback	    "selectNodeCallback"

#define XmNselectArcCallback	    "selectArcCallback"

#define XmNdeselectCallback	    "deselectCallback"

#define XmNselectSubgraphCallback   "selectSubgraphCallback"

#define XmNdeleteNodeCallback	    "deleteNodeCallback"

#define XmNdeleteArcCallback	    "deleteArcCallback"

#define XmNdefaultNodeClass "defaultNodeClass"

#define XmCDefaultNodeClass "DefaultNodeClass"

#define XmNdefaultLabel     "defaultLabel"

#define XmRArcDrawMode      "ArcDrawMode"

#define XmRAutoLayoutType     "AutoLayoutType"

#define XmNinteractiveArcDirection     "interactiveArcDirection"

#define XmCInteractiveArcDirection     "InteractiveArcDirection"

#define XmNmovableNodes   "movableNodes"
#define XmCMovableNodes    "MovableNodes"

#define XmNshowCrossingArcs  "showCrossingArcs"
#define XmCShowCrossingArcs  "ShowCrossingArcs"

#define XmNptrCursor  "ptrCursor"
#define XmNmotionCursor  "motionCursor"
#define XmNindicateCursor  "indicateCursor"
#define XmNindicateChildCursor  "indicateChildCursor"
#define XmNindicateParentCursor "indicateParentCursor"

#define XmNinitializeDataCallback  "initializeDataCallback"
#define XmNfreeDataCallback  "freeDataCallback"

#define XmNlayoutProc  "layoutProc"
#define XmCLayoutProc  "LayoutProc"


/****************************************************
 * Callback reasons
 *****************************************************/

#define XmCR_NEW_ARC			41
#define XmCR_NEW_NODE                   42
#define XmCR_NODE_MOVED			43
#define XmCR_ARC_MOVED			44
#define XmCR_SUBGRAPH_MOVED		45
#define XmCR_ARC_EDITED			46
#define XmCR_SELECT_NODE		47
#define XmCR_SELECT_ARC			48
#define XmCR_SELECT_SUBGRAPH		49
#define XmCR_DELETE_NODE		50
#define XmCR_DELETE_ARC			51

#ifndef XmCR_SELECT
#define XmCR_SELECT			52
#endif

#define XmCR_RELEASE			53
#define XmCR_NODE_DOUBLE_CLICK		54
#define XmCR_ARC_DOUBLE_CLICK		55
#define XmCR_DOUBLE_CLICK		56
#define XmCR_DESELECT_ARC		57
#define XmCR_DESELECT_NODE		58
#define XmCR_DESELECT		        59
#define XmCR_NODES_MOVED		60
#define XmCR_SELECT_NODES		61
#define XmCR_SELECT_ARCS		62
#define XmCR_SELECT_ARCS_AND_NODES		63

#define XmPOSITION_FIXED                 0
#define XmPOSITION_RELATIVE              1

typedef struct {
    int            reason;
    XEvent        *event;
    Boolean        interactive;
    WidgetList     selected_widgets;
    int            num_selected_widgets;
    WidgetList     selected_arcs;
    int            num_selected_arcs;
    Widget         widget;
    Widget         old_to;    /* Used for move and edit arc callbacks */
    Widget         old_from;
    Widget         new_to;
    Widget         new_from;
    Boolean        doit;
} XmGraphCallbackStruct;

typedef enum  {XmNEVER, XmALWAYS, XmARCS_ONLY, XmNODES_ONLY, XmPARTIAL} autoLayoutType;

#endif /* _XmGraph_h */


/* DO NOT ADD ANYTHING AFTER THIS #endif */



