$PACKAGE = "HTML";

~handles 
	HTML

#include "wafe.h"
#include <errno.h>
#include <HTML.h>
#define hTMLWidgetClass htmlWidgetClass

~require
gifread.inc

~require
xpmread.inc

~require
htmlw.inc
	pseudoAttrib imageList freeImageData

~widgetClass
HTML
	include <HTML.h>
	createCmd crtHtmlWidget
	anchor t EscapedString: \
		((WbAnchorCallbackData *)callData)->text \
			# text
	anchor h EscapedString: \
		((WbAnchorCallbackData *)callData)->href \
			# hypertext reference
	anchor i int: \
		((WbAnchorCallbackData *)callData)->element_id \
			# element id
	submitForm h EscapedString: \
		((WbFormCallbackData *)callData)->href \
			# hypertext reference
	submitForm n stringTable: \
		((WbFormCallbackData *)callData)->attribute_count, \
		((WbFormCallbackData *)callData)->attribute_names \
			# attribute names
	submitForm v stringTable: \
		((WbFormCallbackData *)callData)->attribute_count, \
		((WbFormCallbackData *)callData)->attribute_values \
			# attribute values


# Convenience function to return the text of the HTML document as a plain
# ascii text string.
# This function allocates memory for the returned string, that it is up
# to the user to free.
# Extra option flags "pretty" text to be returned.

String
HTMLGetText
	in: HTMLWidget     # HTML Widget
	in: int            # Pretty Code 0-2

# * Convenience function to return the text of the HTML document as a single
# * white space separated string, with pointers to the various start and
# * end points of selections.
# * This function allocates memory for the returned string, that it is up
# * to the user to free.

String
HTMLGetTextAndSelection
	in: HTMLWidget    # HTML Widget
	out: String       # Selection starts
	out: String       # Selcetion ends
	out: String       # Insertion Points

# Convenience function to return the HREFs of all active anchors in
# the document. Function returns an array of strings and fills num_hrefs
# passed. If there are no HREFs NULL returned 

String 
hTMLGetHRefs vulgo HTMLGetHRefs
	in: HTMLWidget    # HTML Widget

# * Convenience function to return the element id of the element
# * nearest to the x,y coordinates passed in.
# * If there is no element there, return the first element in the
# * line we are on.  If there we are on no line, either return the
# * beginning, or the end of the document.

int
HTMLPositionToId
	in: HTMLWidget    # HTML Widget
	in: int           # x Coordinate
	in: int           # y Coordinate

# * Convenience function to return the position of the element
# * based on the element id passed in.
# * Function returns 1 on success and fills in x,y pixel values.
# * If there is no such element, x=0, y=0 and -1 is returned.

int 
HTMLIdToPosition
	in: HTMLWidget     # HTML Widget
	in: int	           # Element ID
	out: int           # x Coordinate
	out: int           # y Coordinate

# * Convenience function to return the position of the anchor
# * based on the anchor NAME passed.
# * Function returns 1 on success and fills in x,y pixel values.
# * If there is no such element, x=0, y=0 and -1 is returned.

int 
HTMLAnchorToPosition
	in: HTMLWidget     # HTML Widget
	in: String         # Anchor's name
	out: int           # x Coordinate
	out: int           # y Coordinate

# Clear the current selection

void
HTMLClearSelection
	in: HTMLWidget     # HTML Widget

# * Set the current selection based on the ElementRefs passed in.
# * Both refs must be valid.
# typedef struct ele_ref_rec 
#	{
#	int id; 
#	int pos;
#       } ElementRef;

void 
HTMLSetSelection
	in: HTMLWidget         # HTML Widget
	in: ElementRef         # start
	in: ElementRef	       # end


# * Convenience function to set the raw text into the widget.
# * Forces a reparse and a reformat.
# * If any pointer is passed in as NULL that text is unchanged,
# * if a pointer points to an empty string, that text is set to NULL;
# * Also pass an element ID to set the view area to that section of the new
# * text.  Finally pass an anchor NAME to set position of the new text
# * to that anchor.

void 
HTMLSetText	
	in: HTMLWidget         # HTML Widget
	in: String             # Text
	in: String	       # Header Text
	in: String	       # Footer Text
	in: int		       # element_id
	in: String	       # target_anchor
	const: NULL

# * Convenience function to search the text of the HTML document as a single
# * white space separated string. Linefeeds are converted into spaces.
# *
# * Takes a pattern, pointers to the start and end blocks to store the
# * start and end of the match into.  Start is also used as the location to
# * start the search from for incremental searching.  If start is an invalid
# * position (id = 0).  Default start is the beginning of the document for
# * forward searching, and the end of the document for backwards searching.
# * The backward and caseless parameters I hope are self-explanatory.
# *
# * returns 1 on success
# *      (and the start and end positions of the match).
# * returns -1 otherwise (and start and end are unchanged).

#define searchtext(w, s, instart, outstart, outend, back, sens) \
	HTMLSearchText(w, s, instart, outend, back, sens); \
	(*outstart).id = (*instart).id; (*outstart).pos = (*instart).pos; 


int 
searchtext vulgo HTMLSearchText
	in: HTMLWidget         # HTML Widget
	in: String             # Pattern
	in: ElementRef         # Input: Start
	out: ElementRef        # Result: Start
	out: ElementRef        # Result: End
	in: int		       # Backward ? (Should be Boolean ?)
	in: int		       # Case Sensitive ? (Should be Boolean ?)


# * Convenience function to position the element
# * based on the element id passed at the top of the viewing area.
# * A passed in id of 0 means goto the top.

void
HTMLGotoId
	in: HTMLWidget		# HTML Widget
	in: int 		# Element ID

# * Convenience function to return the element id of the anchor
# * based on the anchor NAME passed.
# * Function returns id on success.
# * If there is no such element, 0 is returned.

int
HTMLAnchorToId
	in: HTMLWidget		# HTML Widget
	in: String			# Anchor string

#
# experimental Wafe functions
#

Boolean
HTMLIdToElement
	in: HTMLWidget		# HTML Widget
	in: int	       		# Element ID
	out: HTMLElementRecord* # Element Record

void
HTMLsetElementBg
	in: HTMLWidget 		# HTML Widget
	in: int	       		# Element ID
	in: String              # backgroundColor

# * Convenience function to redraw all active anchors in the
# * document.
# * Can also pass a new predicate function to check visited
# * anchors.  If NULL passed for function, uses default predicate
# * function.

void 
HTMLRetestAnchors
	in: HTMLWidget		# HTML Widget
	const: NULL

