/* Copyright (C) 1992 by Gustaf Neumann, Stefan Nusser

 *      Wirtschaftsuniversitaet Wien, 
 *      Abteilung fuer Wirtschaftsinformatik
 *      Augasse 2-6, 
 *      A-1090 Vienna, Austria
 *      neumann@wu-wien.ac.at, nusser@wu-wien.ac.at

 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided
 * that the above copyright notice appears in all copies and that both that
 * copyright notice and this permission notice appear in all supporting
 * documentation.  This software is provided "as is" without expressed or
 * implied warranty.

 * Creation: Sun Jan 23 01:37:06 EST 1994 on syllog2.watson.ibm.com
 * Author: genc
 * Version: 0.95999999999999996

 */
#define XT

#ifdef XT

#define XT_C

#include "wafe.h"                             
#include <X11/Shell.h>
#include <X11/Xatom.h>

 XrmQuark qbusyWindow;
/* 
 * ******* begin required file <Xt.inc> *******
 */
/* das ist ein -*- C -*- Programm */
#include <X11/cursorfont.h>

#ifdef MOTIF11
#include <Xm/Xm.h>
#endif

extern Boolean ownSelection(
#if NeedFunctionPrototypes
     String, String, String
#endif
);

extern void action(
#if NeedFunctionPrototypes
     Widget, int, XtTranslations
#endif
);

extern void callback (
#if NeedFunctionPrototypes
     Widget, char *, XtCallbackProc, char *
#endif
);

extern Cardinal getResOfClass(
#if NeedFunctionPrototypes
     WidgetClass, QTypeList *
#endif
);

extern Cardinal getConOfClass(
#if NeedFunctionPrototypes
     WidgetClass, QTypeList *
#endif
);



static void
realizeWidgets()
    {
    WidgetListPtr ptr = wafeWidgetTrees;
    while(ptr) 
	{
	XtRealizeWidget(ptr->widget);
	ptr = ptr->next;
	}
    }

static void
callCallbacks(w, callback, argc,argv)
Widget   w;
String   callback;
int      argc;
char   **argv;
    {
    float   f;
    if (argc == 0)
	XtCallCallbacks(w, callback, NULL);
    else
	{
	if (!strcmp(argv[0], "float"))
	    {
	    sscanf(argv[1], "%f", &f);
	    XtCallCallbacks(w, callback, (XtPointer)&f);
	    }
	else
	    {
	    fprintf(stderr, "Wafe(callCallbacks): Wrong type: %s\n", argv[1]);
	    }
	}
    }


static void
callActionProc(w, eventType, action, argc, argv)
Widget         w;
String         eventType;
String         action;
int            argc;
char         **argv;
    {
    char          *token;
    XEvent         event;
    Display       *display;
    Window         win, root, child;
    int            x, y, xR, yR;
    unsigned int   state, button, keycode;

    display = XtDisplay(wafeTopLevel);
    win = XtWindow(w);

    if (!strcmp(eventType, ""))
	{
	event.type = 0;
	event.xany.display = display;
	event.xany.window = win;
	}
    else
	{
	token = strtok(eventType, " ");
	if (strcmp(token, "type"))
	    {
	    fprintf(stderr, 
		    "Wafe(callActionProc): Missing type, aborting\n");
	    return;
	    }

	XQueryPointer(display, win, &root, &child, &xR, &yR, &x, &y, &state);

	token = strtok(NULL, " ");
	if (!strcmp(token, "buttonEvent"))
	    {
	    token = strtok(NULL, " ");
	    if (!strcmp(token, "button"))
		{
		token = strtok(NULL, " ");
		if (!strcmp(token, "button1"))
		    button = Button1;
		else
                if (!strcmp(token, "button2"))
		    button = Button2;
                else
                if (!strcmp(token, "button3"))
		    button = Button3;
		else
                if (!strcmp(token, "button4"))
		    button = Button4;
		else
                if (!strcmp(token, "button5"))
		    button = Button5;
		else
		    {
		    fprintf(stderr, 
			    "Wafe(callActionProc): Unknown Button, %s\n", 
			    token);
		    return;
		    }
		}
	    else
		{
		fprintf(stderr, 
			"Wafe(callActionProc): This event field (%s) can't be specified", token);
		return;
		}

	    event.type = ButtonPress;
	    event.xbutton.display = display;
	    event.xbutton.window = win;
	    event.xbutton.root = root;
	    event.xbutton.subwindow = child;
	    event.xbutton.x = x;
	    event.xbutton.y = y;
	    event.xbutton.x_root = xR;
	    event.xbutton.y_root = yR;
	    event.xbutton.state = state;
	    event.xbutton.button = button;
	    }
	else if(!strcmp(token, "keyEvent"))
	    {
	    token = strtok(NULL, " ");
	    if (!strcmp(token, "key"))
		{                   
		token = strtok(NULL, " ");
		keycode = XKeysymToKeycode(display, XStringToKeysym(token));
		}
	    else
		{
		fprintf(stderr, "Wafe(callActionProc): This event field (%s) can't be specified", token);
		return;
		}

	    event.type = KeyPress;
	    event.xkey.display = display;
	    event.xkey.window = win;
	    event.xkey.root = root;
	    event.xkey.subwindow = child;
	    event.xkey.x = x;
	    event.xkey.y = y;
	    event.xkey.x_root = xR;
	    event.xkey.y_root = yR;
	    event.xkey.state = state;
	    event.xkey.keycode = keycode;
	    }
	else
	    {
	    fprintf(stderr, 
		    "Wafe(callActionProc): This event type can't be specified\n");
	    return;
	    }                    
	}

    XtCallActionProc(w, action, &event, argv, argc);
    return;
    }

/* used by addTimeOut */

static void
timerProc(command, junk)
XtPointer        command;
XtIntervalId     *junk;
    {
    DBUG_ENTER("timerProc");
    (void) wafeEval(wafeInterpreter, (char *)command, "timerProc");
    XtFree((char *)command);
    DBUG_VOID_RETURN;
    }


static char *
cvtToString(clientData, quarkOfType, freeProcPtr)
XtPointer     clientData;
XrmQuark      quarkOfType;
freeProc      *freeProcPtr;
    {
    XrmValue   input,output;
    
    DBUG_PRINT("cvtToString", ("Converting to <%s>", 
			       XrmQuarkToString(quarkOfType)));

    input.addr  =  clientData;            /* ??? */
    input.size  =  sizeof(XtPointer);     /* ??? */
    output.addr =  NULL;

    IFCONVERTANDSTORE(wafeTopLevel, 
		      XrmQuarkToString(quarkOfType),input, 
		      "String", output)
	{
	*freeProcPtr = XtFree;
	return output.addr;
	}
    else
	return NULL;
    }



static String
getValue(w, Qname, freeProcPtr)
Widget        w;
XrmQuark      Qname;
freeProc     *freeProcPtr;
    {
    char      *result;
    XrmQuark   Qtype;
    XtPointer  value;
    Arg        arg;

    DBUG_PRINT("getValue", ("widget is %p resource is <%s>",
			    w,XrmQuarkToString(Qname))); 

    if (!(Qtype = getQTypeOfAttribute(XtClass(w), ParentWidget(w), Qname)))
	{
	fprintf(stderr, "Wafe(getValues): Unknown Attribute %s\n",
		XrmQuarkToString(Qname));
	*freeProcPtr = TCL_STATIC;
	return NULL;
	}

    if (Qtype == qString)
	{
	String    valueString;
	*freeProcPtr = TCL_VOLATILE;
	XtVaGetValues(w, XrmQuarkToString(Qname), &valueString, NULL);
	return valueString;
	}

    /* this is the Default value for the following types 
     * assuming that dense code is better than one instruction more
     */ 
    *freeProcPtr = XtFree;
	
    if (Qtype == qInt) 
	{
	int valueInt;
	result = XtMalloc(INT_AS_STRING);
	XtVaGetValues(w, XrmQuarkToString(Qname), &valueInt, NULL);
	sprintf(result, "%d", (int)valueInt);
	return result;
	}

    if (Qtype == qPosition
#ifdef MOTIF11
	|| Qtype == qVerticalPosition
	|| Qtype == qHorizontalPosition
#endif
       )
	{
	Position    valuePosition;
	result = XtMalloc(INT_AS_STRING);
	XtVaGetValues(w, XrmQuarkToString(Qname), &valuePosition, NULL);
	sprintf(result, "%hd", valuePosition);
	return result;
        }
#ifdef MOTIF11
    if (Qtype == qTextPosition) 
	{
	XmTextPosition    valuePosition;
	result = XtMalloc(INT_AS_STRING);
	XtVaGetValues(w, XrmQuarkToString(Qname), &valuePosition, NULL);
	sprintf(result, "%ld", valuePosition);
	return result;
        }
#endif

    if (Qtype == qDimension
#ifdef MOTIF11
	|| Qtype == qVerticalDimension
	|| Qtype == qHorizontalDimension
#endif
	) 
	{
	Dimension    valueDimension;
	result = XtMalloc(INT_AS_STRING);
	XtVaGetValues(w, XrmQuarkToString(Qname), &valueDimension, NULL);
	sprintf(result, "%hu", valueDimension);
	return result;
        }

    if (Qtype == qCardinal)
	{
	Cardinal    valueCardinal;
	result = XtMalloc(INT_AS_STRING);
	XtVaGetValues(w, XrmQuarkToString(Qname), &valueCardinal, NULL);
	sprintf(result, "%u", valueCardinal);	
	return result;
	}

    if (Qtype == qBoolean)
	{
	Boolean    valueBoolean;
	*freeProcPtr = TCL_STATIC;
	XtVaGetValues(w, XrmQuarkToString(Qname), &valueBoolean, NULL);
	return valueBoolean ? "true" : "false";   
	}


    if (Qtype == qFloat) 
	{
	float    valueFloat;
	result = XtMalloc(FLOAT_AS_STRING);
	XtVaGetValues(w, XrmQuarkToString(Qname), &valueFloat, NULL);
	sprintf(result, "%f", valueFloat);
	return result;
	}

    if (Qtype == qDouble) 
	{
	double    valueDouble;
	result = XtMalloc(FLOAT_AS_STRING);
	XtVaGetValues(w, XrmQuarkToString(Qname), &valueDouble, NULL);
	sprintf(result, "%f", valueDouble);
	return result;
	}

    if (Qtype == qPixel) 
	{
	XColor  c;
	Display *dsp = XtDisplay(w);
	result = XtMalloc(8); /* "#RRGGBB" */
	XtVaGetValues(w, XrmQuarkToString(Qname), &(c.pixel), NULL);
	XQueryColor(dsp,DefaultColormap(dsp, DefaultScreen(dsp)),&c);
	sprintf(result, "#%02X%02X%02X", 
		(int)(c.red>>8), (int)(c.green>>8), (int)(c.blue>>8));
	return result;
	}

     /* Callbacks sind ... anders: die String-Information 
	kommt aus wafe's privatem Memory-Management und nicht 
	ber getValues!
      */
    if (Qtype == qCallback) 
	{
	MMattribListPtr ptr = *MMgetAttribList(w,True);
	
	*freeProcPtr = TCL_STATIC;
	result = "";
	while(ptr) 
	    {
	    if (ptr->attribute == Qname) 
		{
		result = ((char*)ptr->value) +
		    sizeof(XtCallbackList)*2 +
		    sizeof(XtCallbackRec[2]) +
		    sizeof(XrmQuark);
		break;
		}
	    ptr = ptr->next;
	    }
	return result;
	}

    if (Qtype == qWidget
#ifdef MOTIF11
	|| Qtype == qWindow
#endif
	)
	{
	Widget valueWidget;
	*freeProcPtr = TCL_STATIC;
	XtVaGetValues(w, XrmQuarkToString(Qname), &valueWidget, NULL);
	return widget2Name(valueWidget);
	}

    if (Qtype == qWidgetList) 
        {
	Widget  *children, *wPtr;
        int      numChildren;
        int      i, length=0;

        XtVaGetValues(w, XtNnumChildren, &numChildren,
                            XtNchildren,    &children,    NULL);
        for (i=0, wPtr=children; i<numChildren; i++, wPtr++)
	   {
	   length += strlen(XtName(*wPtr)) + 2;
	   }
	result = XtMalloc(length);
	*result = '\0';
        for (i=0, wPtr=children; i<numChildren; i++, wPtr++)
	    {
            strcat(result,XtName(*wPtr));
            strcat(result," ");
            }
	return result;
        }

    else 
	{
	  /*
	   * warning: cvtToString assumes, you can free the result 
	   * using XtFree
	   */
	XtSetArg(arg, XrmQuarkToString(Qname), &value);
	XtGetValues(w, &arg, (Cardinal)1);

	if (!(result = cvtToString(value, Qtype, freeProcPtr)))
	  {
	    fprintf(stderr, "Wafe(getValues): Couldn't convert value\n");
	    return NULL;
	  }
	return result;
      }
    }

static int
getResourceList(w, resultPtr)
char    ***resultPtr; 
Widget   w;
    {
    int numTotal, count;
    char **result;
    int rNum = 0;
    int cNum = 0;
    QTypeList rList, cList;

    rNum = getResOfClass(XtClass(w), &rList);

    if (XtIsConstraint(ParentWidget(w)))   /* If parentWidget is constrain widget => fetch constraints */
	cNum =  getConOfClass(XtClass(ParentWidget(w)), &cList);

    numTotal = rNum + cNum;

    *resultPtr = result = (char **)XtMalloc(numTotal *sizeof(char *));       

    for ( count = 0; count < rNum; count++)
	*result++ = XrmQuarkToString(rList[count].qName);

    for ( count = 0; count < cNum; count++)
	*result++ = XrmQuarkToString(cList[count].qName);

    return(numTotal);
    }



typedef struct _busyStruct
    {
    Window                busyWindow;
    Boolean               state;
    } busyStruct, *busyStructPtr;


static void
setBusy(w,sensitive)
Widget w;
Boolean sensitive;
    {
    unsigned long valuemask;
    XSetWindowAttributes attributes;
    MMattribListPtr *al = MMgetAttribList(w,True);
    busyStructPtr bs = (busyStructPtr) MMgetValue(al, qbusyWindow);
    
    if (sensitive)
	{
	if (!bs)
	    {
	    bs = (busyStructPtr) XtMalloc(sizeof(busyStruct));
	    MMreplace(al,qbusyWindow,(char*)bs,XtFree);
            bs->state = False;

	    /* Ignore device events while the busy cursor is displayed. */
	    valuemask = CWDontPropagate | CWCursor;
	    attributes.do_not_propagate_mask =  (KeyPressMask | KeyReleaseMask |
						 ButtonPressMask | ButtonReleaseMask | 
						 PointerMotionMask);
	    attributes.cursor = XCreateFontCursor(XtDisplay(w), XC_watch);

	  /* The window will be as big as the display screen, and clipped by
	   * its own parent window, so we never have to worry about resizing
	   */

	    bs->busyWindow = XCreateWindow(XtDisplay(w), XtWindow(w), 0, 0,
					   HeightOfScreen(XtScreen(w))*2, 
					   WidthOfScreen(XtScreen(w))*2, 
					   (unsigned int) 0, 0, InputOnly,
					   CopyFromParent, valuemask, 
					   &attributes);
	    }
	if (!bs->state) 
	     {
	     XMapRaised(XtDisplay(w), bs->busyWindow);
	     bs->state = True;
	     }
        }
    else
	{
	if (bs && bs->state)
	    {
	    XUnmapWindow(XtDisplay(w), bs->busyWindow);
	    bs->state = False;
	    }
	}
    }


String
waitForVariable(varName)
String varName;
    {
    String result = NULL;
    Tcl_UnsetVar(wafeInterpreter,varName,TCL_GLOBAL_ONLY);
    while (!(result = Tcl_GetVar(wafeInterpreter,varName,TCL_GLOBAL_ONLY)))
	XtAppProcessEvent(wafeAppContext, XtIMAll);

    return result;
    }

typedef struct {
    String  result;
  } ApplData, *ApplDataPtr;

static ApplData   applData;
static XtResource applResources[] = 
    {
	{
	NULL,                            /* resource_name   */
	NULL,                            /* resource_class  */
	XtRString,                       /* resource_type   */
	sizeof(String),                  /* resource_size   */
	XtOffset(ApplDataPtr, result),   /* resource_offset */
	XtRImmediate,                    /* default_type    */
	"",                              /* default_addr    */
	}
     };


String
getApplicationResource(w, name, class)
Widget w;
String name;
String class;
    {
    XtResource *res = (XtResource *)XtMalloc(sizeof(XtResource));
    memcpy(res,applResources,sizeof(XtResource));
       
    res->resource_name  = name;
    res->resource_class = class;
    XtVaGetApplicationResources(w, &applData, res,
				XtNumber(applResources), NULL);
    XtFree((char *) res);
    
    return applData.result;
    }



/* 
 * ******* end required file <Xt.inc> *******
 */
/* 
 * void
 * XtAppAddTimeOut 
 * 	const: wafeAppContext 
 * 	in: unsigned long		# time interval in ms
 * 	const: timerProc
 * 	in: XtNewString(String)		# tcl command
 */

int 
com_addTimeOut(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     unsigned long localVar1;

     DBUG_ENTER("addTimeOut");  

     if (argc != 3) 
	 {
	 argcError("addTimeOut","",2,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(sscanf(argv[1], "%lu", &localVar1)))
          {
          convError("addTimeOut","2",argv[1],"unsigned long");
          DBUG_RETURN (TCL_ERROR);
          }

    /* no need to assign  << localVar2 = argv[2] >>  */ 

     XtAppAddTimeOut(wafeAppContext,localVar1,timerProc,XtNewString(argv[2]));

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * action
 * 	in: Widget			# widget
 * 	in: (int)TranslationModifier	# override | augment | replace
 *         in: XtTranslations		# translatontable
 */

int 
com_action(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     int localVar2;
     XtTranslations localVar3;

     DBUG_ENTER("action");  

     if (argc != 4) 
	 {
	 argcError("action","",3,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 = (Widget) name2Widget(argv[1])))
          {
          convError("action","1",argv[1],"Widget");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!strcmp(argv[2], "override")) 
         localVar2 = 1;
     else
     if (!strcmp(argv[2], "augment")) 
         localVar2 = 2;
     else
     if (!strcmp(argv[2], "replace")) 
         localVar2 = 3;
     else
         {
         convError("action","2",argv[2],"TranslationModifier");
         DBUG_RETURN (TCL_ERROR);
        }


     if (!(localVar3 = (XtTranslations) XtParseTranslationTable(argv[3])))
          {
          convError("action","3",argv[3],"XtTranslations");
          DBUG_RETURN (TCL_ERROR);
          }

     action(localVar1,localVar2,localVar3);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XBell
 * 	in: XtDisplay(Widget)		# widget to determine display
 * 	in: int				# percent (-100 = off, 0 .. 100)
 */

int 
com_bell(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     int localVar2;

     DBUG_ENTER("bell");  

     if (argc != 3) 
	 {
	 argcError("bell","",2,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 = (Widget) name2Widget(argv[1])))
          {
          convError("bell","1",argv[1],"Widget");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(sscanf(argv[2], "%d", &localVar2)))
          {
          convError("bell","2",argv[2],"int");
          DBUG_RETURN (TCL_ERROR);
          }

     XBell(XtDisplay(localVar1),localVar2);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * callActionProc
 * 	in: Widget			# widget
 * 	in: String			# event type
 * 	in: String			# action
 * 	in: [args opt]			# args
 */

int 
com_callActionProc(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;

     DBUG_ENTER("callActionProc");  

     if (argc < 4) 
	 {
	 argcError("callActionProc","at least ",4,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 = (Widget) name2Widget(argv[1])))
          {
          convError("callActionProc","1",argv[1],"Widget");
          DBUG_RETURN (TCL_ERROR);
          }

    /* no need to assign  << localVar2 = argv[2] >>  */ 

    /* no need to assign  << localVar3 = argv[3] >>  */ 

     argc -= 4;
     callActionProc(localVar1,argv[2],argv[3],argc,&argv[4]);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * callCallbacks
 * 	in: Widget			# widget
 * 	in: String			# callback
 * 	in: [args opt]			# optional float and value
 */

int 
com_callCallbacks(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;

     DBUG_ENTER("callCallbacks");  

     if (argc < 3) 
	 {
	 argcError("callCallbacks","at least ",3,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 = (Widget) name2Widget(argv[1])))
          {
          convError("callCallbacks","1",argv[1],"Widget");
          DBUG_RETURN (TCL_ERROR);
          }

    /* no need to assign  << localVar2 = argv[2] >>  */ 

     argc -= 3;
     callCallbacks(localVar1,argv[2],argc,&argv[3]);

     DBUG_RETURN (TCL_OK);
     }     


extern positionCallbackProc();
extern positionCursorCallbackProc();

/* 
 * void
 * callback
 * 	in: Widget			# widget
 * 	in: String			# callback resource
 *         in: XtCallbackProc		# none | exclusive | nonexclusive | popdown | position | positionCursor
 *         in: XtNewString(String)		# string
 */

int 
com_callback(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     XtCallbackProc localVar3;

     DBUG_ENTER("callback");  

     if (argc != 5) 
	 {
	 argcError("callback","",4,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 = (Widget) name2Widget(argv[1])))
          {
          convError("callback","1",argv[1],"Widget");
          DBUG_RETURN (TCL_ERROR);
          }

    /* no need to assign  << localVar2 = argv[2] >>  */ 

     if (!strcmp(argv[3], "exec")) 
         localVar3 = (XtCallbackProc)execCallbackProc;
     else
     if (!strcmp(argv[3], "none")) 
         localVar3 = XtCallbackNone;
     else
     if (!strcmp(argv[3], "exclusive")) 
         localVar3 = XtCallbackExclusive;
     else
     if (!strcmp(argv[3], "nonexclusive")) 
         localVar3 = XtCallbackNonexclusive;
     else
     if (!strcmp(argv[3], "popdown")) 
         localVar3 = XtCallbackPopdown;
     else
     if (!strcmp(argv[3], "position")) 
         localVar3 = (XtCallbackProc)positionCallbackProc;
     else
     if (!strcmp(argv[3], "positionCursor")) 
         localVar3 = (XtCallbackProc)positionCursorCallbackProc;
     else
         {
         convError("callback","3",argv[3],"XtCallbackProc");
         DBUG_RETURN (TCL_ERROR);
        }


    /* no need to assign  << localVar4 = argv[4] >>  */ 

     callback(localVar1,argv[2],localVar3,XtNewString(argv[4]));

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XtDestroyWidget
 * 	callmultiple
 * 		in: MMfreeGarbage(Widget)	# widgets
 */

int 
com_destroyWidget(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     int count;

     DBUG_ENTER("destroyWidget");  

     if (argc < 2) 
	 {
	 argcError("destroyWidget","at least ",1,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     for (count = 1; count < argc; count++)
          {
         if (!(localVar1 = (Widget) name2Widget(argv[count])))
              {
              convError("destroyWidget","count",argv[count],"Widget");
              DBUG_RETURN (TCL_ERROR);
              }

         XtDestroyWidget(MMfreeGarbage(localVar1));
          }

     DBUG_RETURN (TCL_OK);
     }     


#include <X11/IntrinsicP.h>
#define getClass(widget) (XtClass(widget)->core_class.class_name)

/* 
 * String
 * getClass
 * 	in: Widget			# widget | None
 */

int 
com_getClass(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     String returnVar;

     DBUG_ENTER("getClass");  

     if (argc != 2) 
	 {
	 argcError("getClass","",1,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 = (Widget) name2Widget(argv[1])))
          {
          convError("getClass","1",argv[1],"Widget");
          DBUG_RETURN (TCL_ERROR);
          }

     returnVar = getClass(localVar1);

     
     Tcl_SetResult(comInterpreter, returnVar, TCL_VOLATILE);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * int
 * getResourceList
 * 	in: Widget			# widget
 * 	out: String *			# varname for output of reslist
 * 	end: XtFree((String)localVar2);
 */

int 
com_getResourceList(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     String * localVar2;
     int returnVar;
     char conversionBuffer[100];

     DBUG_ENTER("getResourceList");  

     if (argc != 3) 
	 {
	 argcError("getResourceList","",2,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 = (Widget) name2Widget(argv[1])))
          {
          convError("getResourceList","1",argv[1],"Widget");
          DBUG_RETURN (TCL_ERROR);
          }

     returnVar = getResourceList(localVar1,&localVar2);

     
     Tcl_SetVar(wafeInterpreter, argv[2], Tcl_Merge(returnVar,localVar2), 0);

     sprintf(conversionBuffer, "%d", returnVar);
     Tcl_SetResult(comInterpreter, conversionBuffer, TCL_VOLATILE);

     XtFree((String)localVar2);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * XrmQuark
 * getQTypeOfAttribute vulgo getTypeOfAttribute
 * 	in: XtClass(Widget)		# widget
 * 	const: ParentWidget(localVar1)
 * 	in: XrmStringToQuark(String)	# attribute
 */

int 
com_getTypeOfAttribute(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     XrmQuark returnVar;
     char conversionBuffer[100];

     DBUG_ENTER("getTypeOfAttribute");  

     if (argc != 3) 
	 {
	 argcError("getTypeOfAttribute","",2,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 = (Widget) name2Widget(argv[1])))
          {
          convError("getTypeOfAttribute","1",argv[1],"Widget");
          DBUG_RETURN (TCL_ERROR);
          }

    /* no need to assign  << localVar2 = argv[2] >>  */ 

     returnVar = getQTypeOfAttribute(XtClass(localVar1),ParentWidget(localVar1),XrmStringToQuark(argv[2]));

     
     Tcl_SetResult(comInterpreter, XrmQuarkToString(returnVar), TCL_VOLATILE);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * String
 * getValue
 * 	in: Widget			# widget
 * 	in: XrmQuark			# attribute
 * 	free: freeProc
 */

int 
com_getValue(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     XrmQuark localVar2;
     freeProc localVar3;
     String returnVar;

     DBUG_ENTER("getValue");  

     if (argc != 3) 
	 {
	 argcError("getValue","",2,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 = (Widget) name2Widget(argv[1])))
          {
          convError("getValue","1",argv[1],"Widget");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(localVar2 = (XrmQuark) XrmStringToQuark(argv[2])))
          {
          convError("getValue","2",argv[2],"XrmQuark");
          DBUG_RETURN (TCL_ERROR);
          }

     returnVar = getValue(localVar1,localVar2,&localVar3);

     
     Tcl_SetResult(comInterpreter, returnVar, localVar3);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * (int) GrabReturns
 * XtGrabPointer
 * 	in: Widget			# widget
 * 	in: Boolean			# true | false
 *         const: NoEventMask
 * 	in: (int) SyncAsync		# pointer mode (sync | async)
 * 	in: (int) SyncAsync             # keyboard mode (sync | async)
 * 	in: None | XtWindow(Widget)	# None | confine widget
 * 	const: None
 * 	const: CurrentTime
 */

int 
com_grabPointer(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     Boolean localVar2;
     int localVar3;
     int localVar4;
     Widget localVar5;
     int returnVar;
     char conversionBuffer[100];

     DBUG_ENTER("grabPointer");  

     if (argc != 6) 
	 {
	 argcError("grabPointer","",5,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 = (Widget) name2Widget(argv[1])))
          {
          convError("grabPointer","1",argv[1],"Widget");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!strcmp(argv[2], "true")) 
         localVar2 = 1;
     else
     if (!strcmp(argv[2], "false")) 
         localVar2 = 0;
     else
         {
         convError("grabPointer","2",argv[2],"Boolean");
         DBUG_RETURN (TCL_ERROR);
        }


     if (!strcmp(argv[3], "sync")) 
         localVar3 = GrabModeSync;
     else
     if (!strcmp(argv[3], "async")) 
         localVar3 = GrabModeAsync;
     else
         {
         convError("grabPointer","4",argv[3],"SyncAsync");
         DBUG_RETURN (TCL_ERROR);
        }


     if (!strcmp(argv[4], "sync")) 
         localVar4 = GrabModeSync;
     else
     if (!strcmp(argv[4], "async")) 
         localVar4 = GrabModeAsync;
     else
         {
         convError("grabPointer","5",argv[4],"SyncAsync");
         DBUG_RETURN (TCL_ERROR);
        }


     if (!strcmp(argv[5], "None")) 
         localVar5 = None;
     else
         if (!(localVar5 = (Widget) name2Widget(argv[5])))
          {
          convError("grabPointer","6",argv[5],"Widget");
          DBUG_RETURN (TCL_ERROR);
          }

     returnVar = XtGrabPointer(localVar1,localVar2,NoEventMask,localVar3,localVar4,XtWindow(localVar5),None,CurrentTime);

          if (returnVar == GrabSuccess) 
          strcpy(conversionBuffer, "success");
     else
     if (returnVar == AlreadyGrabbed) 
          strcpy(conversionBuffer, "alreadyGrabbed");
     else
     if (returnVar == GrabNotViewable) 
          strcpy(conversionBuffer, "notViewable");
     else
     if (returnVar == GrabFrozen) 
          strcpy(conversionBuffer, "frozen");


     Tcl_SetResult(comInterpreter, conversionBuffer, TCL_VOLATILE);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * (int) GrabReturns
 * XtGrabKeyboard
 * 	in: Widget			# widget
 * 	in: Boolean			# true | false
 * 	in: (int) SyncAsync		# pointer mode (sync | async)
 * 	in: (int) SyncAsync		# keyboard mode (sync | async)
 * 	const: CurrentTime
 */

int 
com_grabKeyboard(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     Boolean localVar2;
     int localVar3;
     int localVar4;
     int returnVar;
     char conversionBuffer[100];

     DBUG_ENTER("grabKeyboard");  

     if (argc != 5) 
	 {
	 argcError("grabKeyboard","",4,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 = (Widget) name2Widget(argv[1])))
          {
          convError("grabKeyboard","1",argv[1],"Widget");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!strcmp(argv[2], "true")) 
         localVar2 = 1;
     else
     if (!strcmp(argv[2], "false")) 
         localVar2 = 0;
     else
         {
         convError("grabKeyboard","2",argv[2],"Boolean");
         DBUG_RETURN (TCL_ERROR);
        }


     if (!strcmp(argv[3], "sync")) 
         localVar3 = GrabModeSync;
     else
     if (!strcmp(argv[3], "async")) 
         localVar3 = GrabModeAsync;
     else
         {
         convError("grabKeyboard","3",argv[3],"SyncAsync");
         DBUG_RETURN (TCL_ERROR);
        }


     if (!strcmp(argv[4], "sync")) 
         localVar4 = GrabModeSync;
     else
     if (!strcmp(argv[4], "async")) 
         localVar4 = GrabModeAsync;
     else
         {
         convError("grabKeyboard","4",argv[4],"SyncAsync");
         DBUG_RETURN (TCL_ERROR);
        }


     returnVar = XtGrabKeyboard(localVar1,localVar2,localVar3,localVar4,CurrentTime);

          if (returnVar == GrabSuccess) 
          strcpy(conversionBuffer, "success");
     else
     if (returnVar == AlreadyGrabbed) 
          strcpy(conversionBuffer, "alreadyGrabbed");
     else
     if (returnVar == GrabNotViewable) 
          strcpy(conversionBuffer, "notViewable");
     else
     if (returnVar == GrabFrozen) 
          strcpy(conversionBuffer, "frozen");


     Tcl_SetResult(comInterpreter, conversionBuffer, TCL_VOLATILE);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XtInstallAccelerators
 * 	in: Widget			# destination
 * 	in: Widget			# source
 */

int 
com_installAccelerators(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     Widget localVar2;

     DBUG_ENTER("installAccelerators");  

     if (argc != 3) 
	 {
	 argcError("installAccelerators","",2,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 = (Widget) name2Widget(argv[1])))
          {
          convError("installAccelerators","1",argv[1],"Widget");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(localVar2 = (Widget) name2Widget(argv[2])))
          {
          convError("installAccelerators","2",argv[2],"Widget");
          DBUG_RETURN (TCL_ERROR);
          }

     XtInstallAccelerators(localVar1,localVar2);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XtInstallAllAccelerators
 * 	in: Widget			# destination
 * 	in: Widget			# source
 */

int 
com_installAllAccelerators(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     Widget localVar2;

     DBUG_ENTER("installAllAccelerators");  

     if (argc != 3) 
	 {
	 argcError("installAllAccelerators","",2,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 = (Widget) name2Widget(argv[1])))
          {
          convError("installAllAccelerators","1",argv[1],"Widget");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(localVar2 = (Widget) name2Widget(argv[2])))
          {
          convError("installAllAccelerators","2",argv[2],"Widget");
          DBUG_RETURN (TCL_ERROR);
          }

     XtInstallAllAccelerators(localVar1,localVar2);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XtManageChildren vulgo manageChild
 * 	in: [Widget]		        # widgets
 * 	const: argc -1
 */

int 
com_manageChild(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget * localVar1;

     DBUG_ENTER("manageChild");  

     if (argc < 2) 
	 {
	 argcError("manageChild","at least ",1,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     {    Widget *ptr;
          argv += 1;
          localVar1 = ptr =
             (Widget *)XtMalloc((argc-1)*sizeof(Widget));

          while (*argv)
             {
             if (!(*ptr =  name2Widget(*argv)))
                  {
                  convError("manageChild","1",*argv,"Widget");
                  DBUG_RETURN (TCL_ERROR);
                  }

          ptr ++; argv++;
          }
     }
     XtManageChildren(localVar1,argc -1);
     XtFree((char *)localVar1);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XtMapWidget
 * 	callmultiple
 * 		in: Widget		# widgets
 */

int 
com_mapWidget(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     int count;

     DBUG_ENTER("mapWidget");  

     if (argc < 2) 
	 {
	 argcError("mapWidget","at least ",1,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     for (count = 1; count < argc; count++)
          {
         if (!(localVar1 = (Widget) name2Widget(argv[count])))
              {
              convError("mapWidget","count",argv[count],"Widget");
              DBUG_RETURN (TCL_ERROR);
              }

         XtMapWidget(localVar1);
          }

     DBUG_RETURN (TCL_OK);
     }     


#define mergeResources(localVar1,argc,argv) { XrmDatabase    dispDb, newDb = NULL; int            i; char         **v = argv; dispDb = XtDatabase(XtDisplay(localVar1)); for (i = 0; i < argc; i+=2)  XrmPutStringResource(&newDb, v[i], v[i+1]); XrmMergeDatabases(newDb, &dispDb);}

/* 
 * void 
 * mergeResources
 * 	in: Widget			# widget to determine display
 * 	in: [args avp] 			# resource value pairs
 */

int 
com_mergeResources(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     Boolean freeArgv = False;
     char **argvArg;

     DBUG_ENTER("mergeResources");  

     if (argc < 3) 
	 {
	 argcError("mergeResources","at least ",2,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 = (Widget) name2Widget(argv[1])))
          {
          convError("mergeResources","1",argv[1],"Widget");
          DBUG_RETURN (TCL_ERROR);
          }

     argc -= 2;
     argvArg = &argv[2];
     if (argc == 1)
        {
        if (mergeArguments(argv[2],"mergeResources",&argc,&argvArg))
           freeArgv = True;
        else 
           DBUG_RETURN (TCL_ERROR);
        }
     if (argc%2)
        {
        argcError("mergeResources","even number of arguments such as 2 or ",4,argc+1);
        if (freeArgv) XtFree((char*)argvArg);
        DBUG_RETURN (TCL_ERROR);
        }

     mergeResources(localVar1,argc,argvArg);
     if (freeArgv) XtFree((char *)argvArg);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XtPopdown
 *         in: ShellWidget			# shell widget
 */

int 
com_popdown(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;

     DBUG_ENTER("popdown");  

     if (argc != 2) 
	 {
	 argcError("popdown","",1,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],shellWidgetClass,"Shell")))
          {
          convError("popdown","1",argv[1],"ShellWidget");
          DBUG_RETURN (TCL_ERROR);
          }

     XtPopdown(localVar1);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XtPopup
 *         in: ShellWidget			# widget
 *         in: XtGrabKind			# none | nonexclusive | exclusive
 */

int 
com_popup(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     XtGrabKind localVar2;

     DBUG_ENTER("popup");  

     if (argc != 3) 
	 {
	 argcError("popup","",2,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],shellWidgetClass,"Shell")))
          {
          convError("popup","1",argv[1],"ShellWidget");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!strcmp(argv[2], "none")) 
         localVar2 = XtGrabNone;
     else
     if (!strcmp(argv[2], "nonexclusive")) 
         localVar2 = XtGrabNonexclusive;
     else
     if (!strcmp(argv[2], "exclusive")) 
         localVar2 = XtGrabExclusive;
     else
         {
         convError("popup","2",argv[2],"XtGrabKind");
         DBUG_RETURN (TCL_ERROR);
        }


     XtPopup(localVar1,localVar2);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XtPopupSpringLoaded
 *         in: ShellWidget			# shell widget
 */

int 
com_popupSpringLoaded(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;

     DBUG_ENTER("popupSpringLoaded");  

     if (argc != 2) 
	 {
	 argcError("popupSpringLoaded","",1,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],shellWidgetClass,"Shell")))
          {
          convError("popupSpringLoaded","1",argv[1],"ShellWidget");
          DBUG_RETURN (TCL_ERROR);
          }

     XtPopupSpringLoaded(localVar1);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * realizeWidgets vulgo realize
 */

int 
com_realize(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {

     DBUG_ENTER("realize");  

     if (argc != 1) 
	 {
	 argcError("realize","",0,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     realizeWidgets();

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XtRemoveAllCallbacks
 * 	in: Widget			# widget
 * 	in: String			# callback name
 */

int 
com_removeAllCallbacks(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;

     DBUG_ENTER("removeAllCallbacks");  

     if (argc != 3) 
	 {
	 argcError("removeAllCallbacks","",2,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 = (Widget) name2Widget(argv[1])))
          {
          convError("removeAllCallbacks","1",argv[1],"Widget");
          DBUG_RETURN (TCL_ERROR);
          }

    /* no need to assign  << localVar2 = argv[2] >>  */ 

     XtRemoveAllCallbacks(localVar1,argv[2]);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XtSetKeyboardFocus
 * 	in: Widget			# from widget tree
 * 	in: None|Widget			# to widget | None
 */

int 
com_setKeyboardFocus(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     Widget localVar2;

     DBUG_ENTER("setKeyboardFocus");  

     if (argc != 3) 
	 {
	 argcError("setKeyboardFocus","",2,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 = (Widget) name2Widget(argv[1])))
          {
          convError("setKeyboardFocus","1",argv[1],"Widget");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!strcmp(argv[2], "None")) 
         localVar2 = None;
     else
         if (!(localVar2 = (Widget) name2Widget(argv[2])))
          {
          convError("setKeyboardFocus","2",argv[2],"Widget");
          DBUG_RETURN (TCL_ERROR);
          }

     XtSetKeyboardFocus(localVar1,localVar2);

     DBUG_RETURN (TCL_OK);
     }     


#define setValues(w,argc,argv) {ArgList           args; int               numArgs; if (convert(ParentWidget(w), XtClass(w), argv, &argc, &args, &numArgs, w)) { XtSetValues(w, args, numArgs); wafeCurrentAttribList = NULL; XtFree((String)args); } }

/* 
 * void
 * setValues
 * 	in: Widget			# widget
 * 	in: [args avp]			# resource value pairs
 */

int 
com_setValues(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     Boolean freeArgv = False;
     char **argvArg;

     DBUG_ENTER("setValues");  

     if (argc < 3) 
	 {
	 argcError("setValues","at least ",2,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 = (Widget) name2Widget(argv[1])))
          {
          convError("setValues","1",argv[1],"Widget");
          DBUG_RETURN (TCL_ERROR);
          }

     argc -= 2;
     argvArg = &argv[2];
     if (argc == 1)
        {
        if (mergeArguments(argv[2],"setValues",&argc,&argvArg))
           freeArgv = True;
        else 
           DBUG_RETURN (TCL_ERROR);
        }
     if (argc%2)
        {
        argcError("setValues","even number of arguments such as 2 or ",4,argc+1);
        if (freeArgv) XtFree((char*)argvArg);
        DBUG_RETURN (TCL_ERROR);
        }

     setValues(localVar1,argc,argvArg);
     if (freeArgv) XtFree((char *)argvArg);

     DBUG_RETURN (TCL_OK);
     }     


#define ADDRESS_OF(w) &(w)

/* 
 * Boolean 
 * XSetWMProtocols
 * 	const: XtDisplay(localVar1)
 * 	in: XtWindow(ShellWidget)	# Shell Widget
 * 	in: ADDRESS_OF((Atom)WM_PROTOCOLS)	# WM_TAKE_FOCUS | WM_SAVE_YOURSELF | WM_DELETE_WINDOW
 * 	const: 1
 */

int 
com_setWMProtocols(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     Atom localVar2;
     Boolean returnVar;
     char conversionBuffer[100];

     DBUG_ENTER("setWMProtocols");  

     if (argc != 3) 
	 {
	 argcError("setWMProtocols","",2,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],shellWidgetClass,"Shell")))
          {
          convError("setWMProtocols","2",argv[1],"ShellWidget");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!strcmp(argv[2], "WM_TAKE_FOCUS")) 
         localVar2 = XInternAtom(XtDisplay(localVar1),"WM_TAKE_FOCUS",False);
     else
     if (!strcmp(argv[2], "WM_SAVE_YOURSELF")) 
         localVar2 = XInternAtom(XtDisplay(localVar1),"WM_SAVE_YOURSELF",False);
     else
     if (!strcmp(argv[2], "WM_DELETE_WINDOW")) 
         localVar2 = XInternAtom(XtDisplay(localVar1),"WM_DELETE_WINDOW",False);
     else
         {
         convError("setWMProtocols","3",argv[2],"WM_PROTOCOLS");
         DBUG_RETURN (TCL_ERROR);
        }


     returnVar = XSetWMProtocols(XtDisplay(localVar1),XtWindow(localVar1),ADDRESS_OF(localVar2),1);

          if (returnVar == 1) 
          strcpy(conversionBuffer, "true");
     else
     if (returnVar == 0) 
          strcpy(conversionBuffer, "false");


     Tcl_SetResult(comInterpreter, conversionBuffer, TCL_VOLATILE);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XtTranslateCoords
 * 	in: Widget			# widget
 * 	in: Position    		# widget x
 * 	in: Position    		# widget y
 * 	out: Position   		# variable name for root x
 * 	out: Position   		# variable name for root y
 */

int 
com_translateCoords(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     Position localVar2;
     Position localVar3;
     Position localVar4;
     Position localVar5;
     char conversionBuffer[100];

     DBUG_ENTER("translateCoords");  

     if (argc != 6) 
	 {
	 argcError("translateCoords","",5,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 = (Widget) name2Widget(argv[1])))
          {
          convError("translateCoords","1",argv[1],"Widget");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(sscanf(argv[2], "%hd", &localVar2)))
          {
          convError("translateCoords","2",argv[2],"Position");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(sscanf(argv[3], "%hd", &localVar3)))
          {
          convError("translateCoords","3",argv[3],"Position");
          DBUG_RETURN (TCL_ERROR);
          }

     XtTranslateCoords(localVar1,localVar2,localVar3,&localVar4,&localVar5);

     sprintf(conversionBuffer, "%hd", localVar4);
     Tcl_SetVar(wafeInterpreter, argv[4], conversionBuffer, 0);

     sprintf(conversionBuffer, "%hd", localVar5);
     Tcl_SetVar(wafeInterpreter, argv[5], conversionBuffer, 0);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XtUngrabPointer
 * 	in: Widget			# widget with active pointer grab
 * 	const: CurrentTime
 */

int 
com_ungrabPointer(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;

     DBUG_ENTER("ungrabPointer");  

     if (argc != 2) 
	 {
	 argcError("ungrabPointer","",1,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 = (Widget) name2Widget(argv[1])))
          {
          convError("ungrabPointer","1",argv[1],"Widget");
          DBUG_RETURN (TCL_ERROR);
          }

     XtUngrabPointer(localVar1,CurrentTime);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XtUngrabKeyboard
 * 	in: Widget			# widget with active keyboard grab
 * 	const: CurrentTime
 */

int 
com_ungrabKeyboard(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;

     DBUG_ENTER("ungrabKeyboard");  

     if (argc != 2) 
	 {
	 argcError("ungrabKeyboard","",1,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 = (Widget) name2Widget(argv[1])))
          {
          convError("ungrabKeyboard","1",argv[1],"Widget");
          DBUG_RETURN (TCL_ERROR);
          }

     XtUngrabKeyboard(localVar1,CurrentTime);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XtUnmanageChildren vulgo unmanageChild
 * 	in: [Widget]		# widgets
 * 	const: argc -1
 */

int 
com_unmanageChild(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget * localVar1;

     DBUG_ENTER("unmanageChild");  

     if (argc < 2) 
	 {
	 argcError("unmanageChild","at least ",1,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     {    Widget *ptr;
          argv += 1;
          localVar1 = ptr =
             (Widget *)XtMalloc((argc-1)*sizeof(Widget));

          while (*argv)
             {
             if (!(*ptr =  name2Widget(*argv)))
                  {
                  convError("unmanageChild","1",*argv,"Widget");
                  DBUG_RETURN (TCL_ERROR);
                  }

          ptr ++; argv++;
          }
     }
     XtUnmanageChildren(localVar1,argc -1);
     XtFree((char *)localVar1);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XtUnmapWidget
 * 	callmultiple
 * 		in: Widget		# widgets
 */

int 
com_unmapWidget(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     int count;

     DBUG_ENTER("unmapWidget");  

     if (argc < 2) 
	 {
	 argcError("unmapWidget","at least ",1,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     for (count = 1; count < argc; count++)
          {
         if (!(localVar1 = (Widget) name2Widget(argv[count])))
              {
              convError("unmapWidget","count",argv[count],"Widget");
              DBUG_RETURN (TCL_ERROR);
              }

         XtUnmapWidget(localVar1);
          }

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XtUnrealizeWidget
 * 	callmultiple
 * 		in: Widget		# widgets
 */

int 
com_unrealizeWidget(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     int count;

     DBUG_ENTER("unrealizeWidget");  

     if (argc < 2) 
	 {
	 argcError("unrealizeWidget","at least ",1,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     for (count = 1; count < argc; count++)
          {
         if (!(localVar1 = (Widget) name2Widget(argv[count])))
              {
              convError("unrealizeWidget","count",argv[count],"Widget");
              DBUG_RETURN (TCL_ERROR);
              }

         XtUnrealizeWidget(localVar1);
          }

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XtRealizeWidget
 * 	callmultiple
 * 		in: Widget		# widgets
 */

int 
com_realizeWidget(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     int count;

     DBUG_ENTER("realizeWidget");  

     if (argc < 2) 
	 {
	 argcError("realizeWidget","at least ",1,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     for (count = 1; count < argc; count++)
          {
         if (!(localVar1 = (Widget) name2Widget(argv[count])))
              {
              convError("realizeWidget","count",argv[count],"Widget");
              DBUG_RETURN (TCL_ERROR);
              }

         XtRealizeWidget(localVar1);
          }

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XtDisownSelection
 * 	const: wafeTopLevel
 * 	const: XA_PRIMARY
 * 	const: CurrentTime
 */

int 
com_disownSelection(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {

     DBUG_ENTER("disownSelection");  

     if (argc != 1) 
	 {
	 argcError("disownSelection","",0,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     XtDisownSelection(wafeTopLevel,XA_PRIMARY,CurrentTime);

     DBUG_RETURN (TCL_OK);
     }     


extern void getSelectionValueProc();

/* 
 * void
 * XtGetSelectionValue
 * 	const: wafeTopLevel
 * 	const: XA_PRIMARY
 * 	const: XA_STRING
 * 	const: getSelectionValueProc
 * 	in: XtNewString(String)		# Tcl command
 * 	const: CurrentTime
 */

int 
com_getSelectionValue(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {

     DBUG_ENTER("getSelectionValue");  

     if (argc != 2) 
	 {
	 argcError("getSelectionValue","",1,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

    /* no need to assign  << localVar1 = argv[1] >>  */ 

     XtGetSelectionValue(wafeTopLevel,XA_PRIMARY,XA_STRING,getSelectionValueProc,XtNewString(argv[1]),CurrentTime);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * Boolean
 * ownSelection
 * 	in: XtNewString(String) # string to be put into selection
 * 	in: NULL | String 	# NULL | loseSelection TCL-command
 * 	in: NULL | String 	# NULL | doneSelection TCL-command
 */

int 
com_ownSelection(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     String localVar2;
     String localVar3;
     Boolean returnVar;
     char conversionBuffer[100];

     DBUG_ENTER("ownSelection");  

     if (argc != 4) 
	 {
	 argcError("ownSelection","",3,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

    /* no need to assign  << localVar1 = argv[1] >>  */ 

     if (!strcmp(argv[2], "NULL")) 
         localVar2 = NULL;
     else
         localVar2 = argv[2];
     if (!strcmp(argv[3], "NULL")) 
         localVar3 = NULL;
     else
         localVar3 = argv[3];
     returnVar = ownSelection(XtNewString(argv[1]),localVar2,localVar3);

          if (returnVar == 1) 
          strcpy(conversionBuffer, "true");
     else
     if (returnVar == 0) 
          strcpy(conversionBuffer, "false");


     Tcl_SetResult(comInterpreter, conversionBuffer, TCL_VOLATILE);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * String
 * XFetchBytes
 * 	pre: { int bytes; XConvertSelection(XtDisplay(localVar1), XA_PRIMARY, XA_STRING, XA_CUT_BUFFER0, DefaultRootWindow(XtDisplay(localVar1)), CurrentTime); 
 * 	in: XtDisplay(Widget) 		# widget to determine display
 *         const:  &bytes
 * 	post: }
 * 	end: XtFree(returnVar);
 */

int 
com_fetchBytes(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     String returnVar;

     DBUG_ENTER("fetchBytes");  

     if (argc != 2) 
	 {
	 argcError("fetchBytes","",1,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 = (Widget) name2Widget(argv[1])))
          {
          convError("fetchBytes","1",argv[1],"Widget");
          DBUG_RETURN (TCL_ERROR);
          }

     { int bytes; XConvertSelection(XtDisplay(localVar1), XA_PRIMARY, XA_STRING, XA_CUT_BUFFER0, DefaultRootWindow(XtDisplay(localVar1)), CurrentTime);
     returnVar = XFetchBytes(XtDisplay(localVar1),&bytes);
     }

     
     Tcl_SetResult(comInterpreter, returnVar, TCL_VOLATILE);

     XtFree(returnVar);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XConvertSelection
 * 	in: XtDisplay(Widget)		# widget to determine display
 * 	const: XA_PRIMARY
 * 	const: XA_STRING
 * 	in: Atom			# target buffer number
 * 	const: DefaultRootWindow(XtDisplay(wafeTopLevel))
 * 	const: CurrentTime
 */

int 
com_convertSelection(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     Atom localVar2;

     DBUG_ENTER("convertSelection");  

     if (argc != 3) 
	 {
	 argcError("convertSelection","",2,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 = (Widget) name2Widget(argv[1])))
          {
          convError("convertSelection","1",argv[1],"Widget");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!strcmp(argv[2], "0")) 
         localVar2 = XA_CUT_BUFFER0;
     else
     if (!strcmp(argv[2], "1")) 
         localVar2 = XA_CUT_BUFFER1;
     else
     if (!strcmp(argv[2], "2")) 
         localVar2 = XA_CUT_BUFFER2;
     else
     if (!strcmp(argv[2], "3")) 
         localVar2 = XA_CUT_BUFFER3;
     else
     if (!strcmp(argv[2], "4")) 
         localVar2 = XA_CUT_BUFFER4;
     else
     if (!strcmp(argv[2], "5")) 
         localVar2 = XA_CUT_BUFFER5;
     else
     if (!strcmp(argv[2], "6")) 
         localVar2 = XA_CUT_BUFFER6;
     else
         {
         convError("convertSelection","4",argv[2],"Atom");
         DBUG_RETURN (TCL_ERROR);
        }


     XConvertSelection(XtDisplay(localVar1),XA_PRIMARY,XA_STRING,localVar2,DefaultRootWindow(XtDisplay(wafeTopLevel)),CurrentTime);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XStoreBuffer
 * 	in: XtDisplay(Widget)		# widget to determine display
 * 	in: String			# String
 * 	const: strlen(argv[2])
 * 	in: int				# buffer number (1-7)
 */

int 
com_storeBuffer(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     int localVar3;

     DBUG_ENTER("storeBuffer");  

     if (argc != 4) 
	 {
	 argcError("storeBuffer","",3,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 = (Widget) name2Widget(argv[1])))
          {
          convError("storeBuffer","1",argv[1],"Widget");
          DBUG_RETURN (TCL_ERROR);
          }

    /* no need to assign  << localVar2 = argv[2] >>  */ 

     if (!(sscanf(argv[3], "%d", &localVar3)))
          {
          convError("storeBuffer","4",argv[3],"int");
          DBUG_RETURN (TCL_ERROR);
          }

     XStoreBuffer(XtDisplay(localVar1),argv[2],strlen(argv[2]),localVar3);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * String
 * XFetchBuffer
 * 	in: XtDisplay(Widget)		# widget to determine display
 * 	const: &nbytes
 * 	in: int				# buffer number (1-7)
 * 	pre: {int nbytes;
 * 	post: }
 * 	end: XtFree(returnVar);
 */

int 
com_fetchBuffer(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     int localVar2;
     String returnVar;

     DBUG_ENTER("fetchBuffer");  

     if (argc != 3) 
	 {
	 argcError("fetchBuffer","",2,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 = (Widget) name2Widget(argv[1])))
          {
          convError("fetchBuffer","1",argv[1],"Widget");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(sscanf(argv[2], "%d", &localVar2)))
          {
          convError("fetchBuffer","3",argv[2],"int");
          DBUG_RETURN (TCL_ERROR);
          }

     {int nbytes;
     returnVar = XFetchBuffer(XtDisplay(localVar1),&nbytes,localVar2);
     }

     
     Tcl_SetResult(comInterpreter, returnVar, TCL_VOLATILE);

     XtFree(returnVar);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * ******* begin required file <xpm.inc> *******
 */
/* yes buddy, it is a -*- c -*- program! */

 /*
    * This file contains a new converter procedure and xpm support procedures:
    *
    *    A new StringToBitmap Converter, which is also able to convert
    *    Pixmaps (suffix .xpm). First it searches for a valid BitmapFile
    *    under the given filename; if the file format is invalid, it
    *    tries to interpret it as a pixmap file.
    */ 


#ifdef XPM
#include <xpm.h>
#include <X11/extensions/shape.h>
#endif
#include <X11/Xos.h>
#include <X11/Xmu/Xmu.h>

#ifdef XPM
 /* Create a linked list, which keeps track of all created pixmaps,
  * so that we can destroy Colorcells, if they are not longer needed.
  * Only the changePixmap command will use this feature, so pixmaps which
  * are set with setValues are still cached as usual!
  * Note that setting a pixmap with setValues therefore implies loosing these 
  * colorcells for the application's lifetime!
  */

typedef struct _PixmapInfo
     {
     Pixmap                pm;              /* Pixmap              */
     Widget                widget;          /* Widget              */
     XpmAttributes         *attribPtr;      /* Colorcells, etc     */
     char                 *pmName;          /* The filename..      */
     struct _PixmapInfo   *next;
     }  PIXMAPINFO, *PIXMAPINFOPTR;

PIXMAPINFOPTR  pixmapListHead = NULL;
#endif

/* Additional Args for the converter: 
 */

static XtConvertArgRec xpmConvertArgsPixmap[] = {
  {XtWidgetBaseOffset, (XtPointer) XtOffsetOf(WidgetRec, core.window), 
   sizeof(Window)},
  {XtImmediate, (XtPointer)True, sizeof(Boolean)}
};


static XtConvertArgRec xpmConvertArgsBitmap[] = {
  {XtWidgetBaseOffset, (XtPointer) XtOffsetOf(WidgetRec, core.window), 
   sizeof(Window)}
};
   

#ifdef XPM
void
changePixmap(w,resource,fname)
Widget     w;
String     resource;
String     fname;
    {
    Colormap        cmap;
    Pixmap          death, pixmap, mask;
    Screen         *screen;
    Display        *dpy;
    int             screenNum;
    int             returnVal;
    unsigned int    depth;
    XpmAttributes  *attribPtr;
    PIXMAPINFOPTR   pptr, cptr;
    
    dpy = XtDisplay(w);
    screen = DefaultScreenOfDisplay(dpy);
    screenNum = DefaultScreen(dpy);
    depth = DefaultDepth(dpy, DefaultScreen(dpy));

    /* Get pixmap adress and colormap of the pixmap, which will be destroyed  */
    
    XtVaGetValues(w, resource,     &death, 
		  XtNcolormap, &cmap, NULL);

  /* Search the list of pixmaps to find out wether the specified pixmap's 
      * resources are to be freed - which is the case when it was created by
      * this procedure.
      */

    if (pixmapListHead)
	{
	for (pptr = pixmapListHead; pptr != NULL; pptr = pptr->next)
	    {
	    if ((pptr->pm == death) && (pptr->widget == w))
		{
		if (!strcmp(pptr->pmName, fname))
		    {
		    DBUG_PRINT("pixmap",
			       ("You are about to set the same pixmap!"));
		    return;
		    }

		/* Set pixmap to "None" => destroying will be save */
		XtVaSetValues(w, resource, None, NULL);

		/* Take destroyed Pixmap from pixmaplist and deallocate memory */
		DBUG_PRINT("pixmap",
			   ("found pixmap %s of widget %s, %d colors freed", 
			    resource, XtName(w), pptr->attribPtr->npixels));

		XFreePixmap(XtDisplay(w), death);
		if (pptr->attribPtr->depth > 1) 
		    XFreeColors(XtDisplay(w), cmap, pptr->attribPtr->pixels, 
				pptr->attribPtr->npixels, 0);

		XpmFreeAttributes(pptr->attribPtr);

		DBUG_PRINT("pixmap", ("Managing the List"));
		if (pptr == pixmapListHead)
		    {
		    XtFree((char *)pixmapListHead);
		    pixmapListHead = NULL;
		    }
		else
		    {
		    for(cptr = pixmapListHead; 
			cptr->next != pptr; 
			cptr = cptr->next);
		    
		    if (pptr->next == NULL)     /* last Pixmap in list */
			cptr->next = NULL;
		    else                        /* not last Pixmap in list */
			cptr->next = pptr->next;

		    XtFree((char *)pptr);
		    }
		}
	    }
	}

    /* If the new pixmap's filename is None, => don't create new entry. */

    if (!strcmp(fname, "None"))
	{
	DBUG_PRINT("pixmap",
		   ("Setting %s %s to None", XtName(w), resource));
	XtVaSetValues(w, resource, None, NULL);
	return;
	}
    if (!strcmp(fname, "Unspecified"))
	{
	DBUG_PRINT("pixmap",
		   ("Setting %s %s to Unspecified", XtName(w), resource));
	XtVaSetValues(w, resource, XtUnspecifiedPixmap, NULL);
	return;
	}
    if (!strcmp(fname, "ParentRelative"))
	{
	DBUG_PRINT("pixmap",
		   ("Setting %s %s to ParentRelative", XtName(w), resource));
	XtVaSetValues(w, resource, ParentRelative, NULL);
	return;
	}

    /* Now convert the new Pixmap-File, create a new element of the list 
         * and fill it with information.
         */

    attribPtr = (XpmAttributes *)XtCalloc(sizeof(XpmAttributes), sizeof(char));
    attribPtr->valuemask = XpmReturnPixels | XpmDepth | XpmReturnInfos;
    attribPtr->depth = DefaultDepthOfScreen(DefaultScreenOfDisplay(XtDisplay(w)));
    /* fprintf(stderr, "Wafe(changePixmap): calling xpmreadfile\n");*/
    returnVal = XpmReadFileToPixmap(dpy, RootWindow(dpy, screenNum), 
				    fname, &pixmap, &mask, attribPtr); 
    /*fprintf(stderr, "Wafe(changePixmap): xpmreadfile returned %d\n",returnVal);*/

    if (returnVal == XpmSuccess)
	{
	if (!pixmapListHead)   /* First Pixmap */
	    {
	    cptr = 
		pixmapListHead = 
		    (PIXMAPINFOPTR)XtMalloc(sizeof(PIXMAPINFO));
	    pixmapListHead->next = NULL;
	    }
	else
	    {
	    for(cptr = pixmapListHead; cptr->next != NULL; cptr = cptr->next);
	    cptr->next = (PIXMAPINFOPTR)XtMalloc(sizeof(PIXMAPINFO));
	    cptr = cptr->next;
	    cptr->next = NULL;
	    }

	cptr->widget = w;
	cptr->pm = pixmap;
	cptr->pmName = XtNewString(fname);
	cptr->attribPtr = attribPtr;

	DBUG_PRINT("pixmap", 
		   ("%d colorcells are used for %s\n", 
		    cptr->attribPtr->npixels, cptr->pmName));
     
	XtVaSetValues(w, resource, pixmap, NULL);

/*   fprintf(stderr, "changePixmap's window is %p\n", XtWindow(w));*/
/* do we really want to shape the pixmap? */

	if XtWindow(w) 
	      XShapeCombineMask(XtDisplay(w), XtWindow(w), ShapeBounding,
		      0, 0, mask, ShapeSet);

	DBUG_PRINT("pixmap", ("Conversion OK, new Pixmap was set"));
	return;
	}
    else
	{
	fprintf(stderr, "Wafe(changePixmap): Couldn't convert\n");
	XpmFreeAttributes(attribPtr);
	return;
	}
    }     

void
setIconPixmap(w,fname)
Widget   w;
String   fname;
    {
    Window        iconWindow;
    Pixmap        pixmap, mask;
    int           iconWidth, iconHeight;
    XpmAttributes attrib;
    Window        root;
    Display      *dpy;
    Pixel         bpix;

    dpy = XtDisplay(w);
    root = RootWindow(dpy, DefaultScreen(dpy));
    bpix = XBlackPixelOfScreen(DefaultScreenOfDisplay(dpy));
    attrib.valuemask = XpmReturnInfos;

    if (XpmReadFileToPixmap(dpy, root, fname, &pixmap, &mask, &attrib) 
	!= XpmSuccess)
	{
	fprintf(stderr, "Wafe(setIconPixmap): couldn't convert %s to pixmap\n",
		fname);
	return;
	}
    
    iconWidth = attrib.width;
    iconHeight = attrib.height;
    iconWindow = XCreateSimpleWindow(dpy, root, 0, 0, 
				     iconWidth, iconHeight, 1, bpix, bpix);

    XSetWindowBackgroundPixmap(dpy, iconWindow, pixmap);
    XShapeCombineMask(dpy, iconWindow, ShapeBounding,
			  0, 0, mask, ShapeSet);
    
    XtVaSetValues(w, XtNiconWindow, iconWindow, NULL);
    return;
    }
#endif /* XPM */


#define done(address, type) \
        { (*toVal).size = sizeof(type); (*toVal).addr = (caddr_t) address; }
#define	newDone(type, value) \
	{							\
	    if (toVal->addr != NULL) {				\
		if (toVal->size < sizeof(type)) {		\
		    toVal->size = sizeof(type);			\
		    return False;				\
		}						\
		*(type*)(toVal->addr) = (value);		\
	    }							\
	    else {						\
		static type static_val;				\
		static_val = (value);				\
		toVal->addr = (XtPointer)&static_val;		\
	    }							\
	    toVal->size = sizeof(type);				\
	    return True;					\
	}
               

Boolean
CvtStringToPixmapOrBitmap(dpy, args, num_args, fromVal, toVal,
		   converter_data)
Display *dpy;
XrmValuePtr args;
Cardinal *num_args;
XrmValuePtr fromVal;
XrmValuePtr toVal;
XtPointer *converter_data;
    {
    static Pixmap    pixmap;               /* static for cvt magic */
    String           name;
    Screen          *screen;
    int              screenNum;
    String           fn = NULL;
    unsigned int     width, height;
    int              xhot, yhot;
    unsigned char   *data;
    int              returnValue;
    Boolean          toPixmap = *num_args>1;
#ifdef XPM
    Pixmap           mask;
    Window           coreWin;
    XpmAttributes    attrib;
#endif

    pixmap = (Pixmap) NULL;
    name   = (String) fromVal->addr;
/*
    fprintf(stderr,"i am converting <%s> to %s\n",   
	  name, toPixmap ? "Pixmap" : "Bitmap");
 */
    screen = DefaultScreenOfDisplay(dpy);
    screenNum = DefaultScreen(dpy);
    
    if (strcmp(name, "None") == 0) 
        {
        pixmap = None;
        newDone(Pixmap,pixmap);
        }

    if (strcmp(name, "ParentRelative") == 0 && toPixmap) 
        {
        pixmap = ParentRelative;
        newDone(Pixmap,pixmap);
        }

    if (strcmp(name, "Unspecified") == 0 && toPixmap) 
        {
        pixmap = XtUnspecifiedPixmap;
        newDone(Pixmap,pixmap);
        }

    /* try hard to locate bitmap or pixmap file:
       is it the name a sufficient path?
     */
    if (access(name, R_OK) == 0)
	fn = name;
    else
	{
	if (!(fn = XtResolvePathname(dpy, "bitmaps", name, "", 
			       wafeFileSearchPath, NULL, 0, NULL)))
	    {
	    XtStringConversionWarning(name, toPixmap ? "Pixmap" : "Bitmap");
	    fprintf(stderr, 
		    "Wafe(convert): Wafe's current FILESEARCHPATH is <%s>\n", 
		    wafeFileSearchPath);  
	    return False;
	    }
	}
    
    /* we have a valid filename fn */
    /* try to read file as bitmap file... */

	if (XmuReadBitmapDataFromFile(fn, &width, &height, &data,
				      &xhot, &yhot) == BitmapSuccess)
	    {
	    pixmap = XCreatePixmapFromBitmapData(dpy,
				 RootWindowOfScreen(screen),
				 (char *) data, width, height, 1, 0, 
				 toPixmap?DefaultDepth(dpy, DefaultScreen(dpy)):1);
            /* in 0.95 we had:   DefaultDepth(dpy, DefaultScreen(dpy)));*/

	    XFree((char *)data);

	    if (name != fn) XtFree(fn);
	    newDone(Pixmap,pixmap);
	    }

#ifdef XPM    
    attrib.valuemask = XpmReturnPixels | XpmDepth | XpmReturnInfos;
    attrib.depth = DefaultDepthOfScreen(DefaultScreenOfDisplay(dpy));

    if ((returnValue = XpmReadFileToPixmap(dpy,RootWindow(dpy,screenNum),
					   fn, &pixmap, &mask, &attrib))
	!= XpmSuccess)
	{
	fprintf(stderr, "Wafe(convertPixmap): XPM-Error-Code: %d\n", 
		returnValue);
#else
	fprintf(stderr, "Wafe(convertPixmap): No XPM configured!\n");
#endif
	XtStringConversionWarning(name, toPixmap ? "Pixmap" : "Bitmap");

	if (name != fn) XtFree(fn);
	return False;
#ifdef XPM
	}
    else 
	{
/*
	fprintf(stderr,"pixmap=%p, width=%d, height=%d, addr=%p\n",pixmap,
		attrib.width,attrib.height,toVal->addr);
*/
	coreWin = *((Window *) args[0].addr);
/*	fprintf(stderr, "The window is %p\n", coreWin); */
	
	/* if toVal->addr is set we assume that the value comes
           from a resource file, in which case we can't assume that
           the core fields of the widget are already initialized; 
           coreWin will be wrong; Wafe never sets toVal->addr */
	if (coreWin && !toVal->addr) 
	    XShapeCombineMask(dpy, coreWin, ShapeBounding,
			      0, 0, mask, ShapeSet);

	if (name != fn) XtFree(fn);
	newDone(Pixmap,pixmap);
	}
#endif /* XPM */
    }

/* to keep knowledge about xpmConvertArgsPixmap etc local ...
 */
void
xpmRegisterTypeConverter(resourceType, toPixmap)
char * resourceType;
Boolean toPixmap;
    { 
    if (toPixmap)
	XtSetTypeConverter(XtRString, 
			   resourceType, 
			   (XtTypeConverter)CvtStringToPixmapOrBitmap, 
			   xpmConvertArgsPixmap, 
			   2,
			   XtCacheByDisplay,
			   NULL);
    else
	XtSetTypeConverter(XtRString, 
			   resourceType, 
			   (XtTypeConverter)CvtStringToPixmapOrBitmap, 
			   xpmConvertArgsBitmap, 
			   1, 
			   XtCacheByDisplay, 
			   NULL);
    }


/* 
 * ******* end required file <xpm.inc> *******
 */
/* 
 * hint: XPM
 * void
 * setIconPixmap
 * 	in: ShellWidget			# Shell Widget (eg topLevel)
 * 	in: String			# pixmap file
 */
#ifdef XPM

int 
com_setIconPixmap(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;

     DBUG_ENTER("setIconPixmap");  

     if (argc != 3) 
	 {
	 argcError("setIconPixmap","",2,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],shellWidgetClass,"Shell")))
          {
          convError("setIconPixmap","1",argv[1],"ShellWidget");
          DBUG_RETURN (TCL_ERROR);
          }

    /* no need to assign  << localVar2 = argv[2] >>  */ 

     setIconPixmap(localVar1,argv[2]);

     DBUG_RETURN (TCL_OK);
     }     

#endif

/* 
 * hint: XPM
 * void
 * changePixmap
 * 	in: Widget			# widget
 * 	in: String			# resource
 * 	in: String			# pixmap file
 */
#ifdef XPM

int 
com_changePixmap(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;

     DBUG_ENTER("changePixmap");  

     if (argc != 4) 
	 {
	 argcError("changePixmap","",3,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 = (Widget) name2Widget(argv[1])))
          {
          convError("changePixmap","1",argv[1],"Widget");
          DBUG_RETURN (TCL_ERROR);
          }

    /* no need to assign  << localVar2 = argv[2] >>  */ 

    /* no need to assign  << localVar3 = argv[3] >>  */ 

     changePixmap(localVar1,argv[2],argv[3]);

     DBUG_RETURN (TCL_OK);
     }     

#endif

/* 
 * int (int)
 * name2WidgetId vulgo isWidget
 * 	in: String			# widget name
 */

int 
com_isWidget(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     int returnVar;
     char conversionBuffer[100];

     DBUG_ENTER("isWidget");  

     if (argc != 2) 
	 {
	 argcError("isWidget","",1,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

    /* no need to assign  << localVar1 = argv[1] >>  */ 

     returnVar = (int) name2WidgetId(argv[1]);

     sprintf(conversionBuffer, "%d", returnVar);
     Tcl_SetResult(comInterpreter, conversionBuffer, TCL_VOLATILE);

     DBUG_RETURN (TCL_OK);
     }     


#ifdef LAYOUT
#include "Layout.h"
#endif
/* 
 * int (int)
 * ParentWidget vulgo parent
 * 	in: Widget			# child widget
 */

int 
com_parent(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     int returnVar;
     char conversionBuffer[100];

     DBUG_ENTER("parent");  

     if (argc != 2) 
	 {
	 argcError("parent","",1,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 = (Widget) name2Widget(argv[1])))
          {
          convError("parent","1",argv[1],"Widget");
          DBUG_RETURN (TCL_ERROR);
          }

     returnVar = (int) ParentWidget(localVar1);

     sprintf(conversionBuffer, "%d", returnVar);
     Tcl_SetResult(comInterpreter, conversionBuffer, TCL_VOLATILE);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * int
 * WidthOfScreen
 * 	in: XtScreen(Widget)     	# widget to determine screen
 */

int 
com_widthOfScreen(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     int returnVar;
     char conversionBuffer[100];

     DBUG_ENTER("widthOfScreen");  

     if (argc != 2) 
	 {
	 argcError("widthOfScreen","",1,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 = (Widget) name2Widget(argv[1])))
          {
          convError("widthOfScreen","1",argv[1],"Widget");
          DBUG_RETURN (TCL_ERROR);
          }

     returnVar = WidthOfScreen(XtScreen(localVar1));

     sprintf(conversionBuffer, "%d", returnVar);
     Tcl_SetResult(comInterpreter, conversionBuffer, TCL_VOLATILE);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * int
 * HeightOfScreen
 * 	in: XtScreen(Widget)     	# widget to determine screen
 */

int 
com_heightOfScreen(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     int returnVar;
     char conversionBuffer[100];

     DBUG_ENTER("heightOfScreen");  

     if (argc != 2) 
	 {
	 argcError("heightOfScreen","",1,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 = (Widget) name2Widget(argv[1])))
          {
          convError("heightOfScreen","1",argv[1],"Widget");
          DBUG_RETURN (TCL_ERROR);
          }

     returnVar = HeightOfScreen(XtScreen(localVar1));

     sprintf(conversionBuffer, "%d", returnVar);
     Tcl_SetResult(comInterpreter, conversionBuffer, TCL_VOLATILE);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * char *
 * XtResolvePathname
 * 	in: XtDisplay(Widget)
 * 	in: NULL | String               # Type
 * 	in: NULL | String               # File
 * 	in: NULL | String               # Suffix
 * 	in: NULL | String               # Path
 * 	const: NULL                     # Substitutions
 * 	const: 0                        # Number of Substitutions
 * 	const: NULL                     # XtFilePredicate
 */

int 
com_resolvePathname(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     String localVar2;
     String localVar3;
     String localVar4;
     String localVar5;
     char * returnVar;

     DBUG_ENTER("resolvePathname");  

     if (argc != 6) 
	 {
	 argcError("resolvePathname","",5,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 = (Widget) name2Widget(argv[1])))
          {
          convError("resolvePathname","1",argv[1],"Widget");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!strcmp(argv[2], "NULL")) 
         localVar2 = NULL;
     else
         localVar2 = argv[2];
     if (!strcmp(argv[3], "NULL")) 
         localVar3 = NULL;
     else
         localVar3 = argv[3];
     if (!strcmp(argv[4], "NULL")) 
         localVar4 = NULL;
     else
         localVar4 = argv[4];
     if (!strcmp(argv[5], "NULL")) 
         localVar5 = NULL;
     else
         localVar5 = argv[5];
     returnVar = XtResolvePathname(XtDisplay(localVar1),localVar2,localVar3,localVar4,localVar5,NULL,0,NULL);

     
     Tcl_SetResult(comInterpreter, returnVar, TCL_VOLATILE);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XtSetSensitive 
 * 	in: Widget			# widget 
 * 	in: Boolean			# sensitive true | false
 */

int 
com_setSensitive(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     Boolean localVar2;

     DBUG_ENTER("setSensitive");  

     if (argc != 3) 
	 {
	 argcError("setSensitive","",2,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 = (Widget) name2Widget(argv[1])))
          {
          convError("setSensitive","1",argv[1],"Widget");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!strcmp(argv[2], "true")) 
         localVar2 = 1;
     else
     if (!strcmp(argv[2], "false")) 
         localVar2 = 0;
     else
         {
         convError("setSensitive","2",argv[2],"Boolean");
         DBUG_RETURN (TCL_ERROR);
        }


     XtSetSensitive(localVar1,localVar2);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * setBusy
 * 	in: Widget			# shell widget 
 * 	in: Boolean			# sensitive true | false
 */

int 
com_setBusy(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     Boolean localVar2;

     DBUG_ENTER("setBusy");  

     if (argc != 3) 
	 {
	 argcError("setBusy","",2,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 = (Widget) name2Widget(argv[1])))
          {
          convError("setBusy","1",argv[1],"Widget");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!strcmp(argv[2], "true")) 
         localVar2 = 1;
     else
     if (!strcmp(argv[2], "false")) 
         localVar2 = 0;
     else
         {
         convError("setBusy","2",argv[2],"Boolean");
         DBUG_RETURN (TCL_ERROR);
        }


     setBusy(localVar1,localVar2);

     DBUG_RETURN (TCL_OK);
     }     


#define textWidth(w,resource,string) XTextWidth(font, string, strlen(string))

/* 
 * int
 * textWidth
 * 	pre: {XFontStruct *font; XtVaGetValues(localVar1, argv[2], &font, NULL);
 * 	in: Widget			# Widget
 * 	in: String			# fontResource
 * 	in: String			# String
 *         post: }
 */

int 
com_textWidth(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     int returnVar;
     char conversionBuffer[100];

     DBUG_ENTER("textWidth");  

     if (argc != 4) 
	 {
	 argcError("textWidth","",3,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 = (Widget) name2Widget(argv[1])))
          {
          convError("textWidth","1",argv[1],"Widget");
          DBUG_RETURN (TCL_ERROR);
          }

    /* no need to assign  << localVar2 = argv[2] >>  */ 

    /* no need to assign  << localVar3 = argv[3] >>  */ 

     {XFontStruct *font; XtVaGetValues(localVar1, argv[2], &font, NULL);
     returnVar = textWidth(localVar1,argv[2],argv[3]);
     }

     sprintf(conversionBuffer, "%d", returnVar);
     Tcl_SetResult(comInterpreter, conversionBuffer, TCL_VOLATILE);

     DBUG_RETURN (TCL_OK);
     }     


#define fontHeight(w,resource) (font->max_bounds.ascent + font->max_bounds.descent)

/* 
 * int
 * fontHeight
 * 	pre: {XFontStruct *font; XtVaGetValues(localVar1, argv[2], &font, NULL);
 * 	in: Widget			# Widget
 * 	in: String			# fontResource
 *         post: }
 */

int 
com_fontHeight(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     int returnVar;
     char conversionBuffer[100];

     DBUG_ENTER("fontHeight");  

     if (argc != 3) 
	 {
	 argcError("fontHeight","",2,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 = (Widget) name2Widget(argv[1])))
          {
          convError("fontHeight","1",argv[1],"Widget");
          DBUG_RETURN (TCL_ERROR);
          }

    /* no need to assign  << localVar2 = argv[2] >>  */ 

     {XFontStruct *font; XtVaGetValues(localVar1, argv[2], &font, NULL);
     returnVar = fontHeight(localVar1,argv[2]);
     }

     sprintf(conversionBuffer, "%d", returnVar);
     Tcl_SetResult(comInterpreter, conversionBuffer, TCL_VOLATILE);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XRaiseWindow
 * 	in: XtDisplay(Widget)		# widget to be raised
 * 	const: XtWindow(localVar1)
 */

int 
com_raiseWindow(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;

     DBUG_ENTER("raiseWindow");  

     if (argc != 2) 
	 {
	 argcError("raiseWindow","",1,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 = (Widget) name2Widget(argv[1])))
          {
          convError("raiseWindow","1",argv[1],"Widget");
          DBUG_RETURN (TCL_ERROR);
          }

     XRaiseWindow(XtDisplay(localVar1),XtWindow(localVar1));

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XLowerWindow
 * 	in: XtDisplay(Widget)           # Widget to be lowered
 * 	const: XtWindow(localVar1)
 */

int 
com_lowerWindow(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;

     DBUG_ENTER("lowerWindow");  

     if (argc != 2) 
	 {
	 argcError("lowerWindow","",1,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 = (Widget) name2Widget(argv[1])))
          {
          convError("lowerWindow","1",argv[1],"Widget");
          DBUG_RETURN (TCL_ERROR);
          }

     XLowerWindow(XtDisplay(localVar1),XtWindow(localVar1));

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * String
 * waitForVariable
 * 	in: String			# variable Name
 */

int 
com_waitForVariable(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     String returnVar;

     DBUG_ENTER("waitForVariable");  

     if (argc != 2) 
	 {
	 argcError("waitForVariable","",1,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

    /* no need to assign  << localVar1 = argv[1] >>  */ 

     returnVar = waitForVariable(argv[1]);

     
     Tcl_SetResult(comInterpreter, returnVar, TCL_VOLATILE);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * String
 * getApplicationResource
 * 	in: Widget			# base widget 
 * 	in: String			# resource name
 * 	in: String			# resource class
 */

int 
com_getApplicationResource(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     String returnVar;

     DBUG_ENTER("getApplicationResource");  

     if (argc != 4) 
	 {
	 argcError("getApplicationResource","",3,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 = (Widget) name2Widget(argv[1])))
          {
          convError("getApplicationResource","1",argv[1],"Widget");
          DBUG_RETURN (TCL_ERROR);
          }

    /* no need to assign  << localVar2 = argv[2] >>  */ 

    /* no need to assign  << localVar3 = argv[3] >>  */ 

     returnVar = getApplicationResource(localVar1,argv[2],argv[3]);

     
     Tcl_SetResult(comInterpreter, returnVar, TCL_VOLATILE);

     DBUG_RETURN (TCL_OK);
     }     


#define popupChildren(w) widgetListToList((w)->core.num_popups,(w)->core.popup_list)

/* 
 * String
 * popupChildren
 * 	in: Widget
 */

int 
com_popupChildren(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     String returnVar;

     DBUG_ENTER("popupChildren");  

     if (argc != 2) 
	 {
	 argcError("popupChildren","",1,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 = (Widget) name2Widget(argv[1])))
          {
          convError("popupChildren","1",argv[1],"Widget");
          DBUG_RETURN (TCL_ERROR);
          }

     returnVar = popupChildren(localVar1);

     
     Tcl_SetResult(comInterpreter, returnVar, TCL_VOLATILE);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XFlush
 * 	in: XtDisplay(Widget)		# Widget to determine display
 */

int 
com_flush(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;

     DBUG_ENTER("flush");  

     if (argc != 2) 
	 {
	 argcError("flush","",1,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 = (Widget) name2Widget(argv[1])))
          {
          convError("flush","1",argv[1],"Widget");
          DBUG_RETURN (TCL_ERROR);
          }

     XFlush(XtDisplay(localVar1));

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XSync
 * 	in: XtDisplay(Widget)		# Widget to determine display
 * 	in: Boolean			# Discard (Boolean)
 */

int 
com_sync(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     Boolean localVar2;

     DBUG_ENTER("sync");  

     if (argc != 3) 
	 {
	 argcError("sync","",2,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 = (Widget) name2Widget(argv[1])))
          {
          convError("sync","1",argv[1],"Widget");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!strcmp(argv[2], "true")) 
         localVar2 = 1;
     else
     if (!strcmp(argv[2], "false")) 
         localVar2 = 0;
     else
         {
         convError("sync","2",argv[2],"Boolean");
         DBUG_RETURN (TCL_ERROR);
        }


     XSync(XtDisplay(localVar1),localVar2);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * Widget
 * name2WidgetId vulgo widgetName
 * 	in: String			# widget name 

 */

int 
com_widgetName(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget returnVar;
     char conversionBuffer[100];

     DBUG_ENTER("widgetName");  

     if (argc != 2) 
	 {
	 argcError("widgetName","",1,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

    /* no need to assign  << localVar1 = argv[1] >>  */ 

     returnVar = name2WidgetId(argv[1]);

     
     Tcl_SetResult(comInterpreter, widget2Name(returnVar), TCL_VOLATILE);

     DBUG_RETURN (TCL_OK);
     }     


#else
#include "wafe.h"
#endif

void
Initialize_XtGen()
{
#ifdef XT
 createWidgetCommand("ApplicationShell",applicationShellWidgetClass,XtAppCreateShell,False);
 createWidgetCommand("OverrideShell",overrideShellWidgetClass,XtCreatePopupShell,True);
 createWidgetCommand("TopLevelShell",topLevelShellWidgetClass,XtCreatePopupShell,True);
 createWidgetCommand("TransientShell",transientShellWidgetClass,XtCreatePopupShell,True);
#ifdef LAYOUT
 createWidgetCommand("Layout",layoutWidgetClass,NULL,False);
#endif
#ifdef XPM
 strcat(wafePackages,"XPM ");
#endif
#ifdef LAYOUT
 strcat(wafePackages,"LAYOUT ");
#endif
 qbusyWindow = WafePermStringToQuark("busyWindow");
 qString = WafePermStringToQuark("String");
 qCallback = WafePermStringToQuark("Callback");
 qPointer = WafePermStringToQuark("Pointer");
 qInt = WafePermStringToQuark("Int");
 qDimension = WafePermStringToQuark("Dimension");
 qCardinal = WafePermStringToQuark("Cardinal");
 qPosition = WafePermStringToQuark("Position");
 qFloat = WafePermStringToQuark("Float");
 qDouble = WafePermStringToQuark("Double");
 qPixel = WafePermStringToQuark("Pixel");
 qBoolean = WafePermStringToQuark("Boolean");
 qWidgetList = WafePermStringToQuark("WidgetList");
 qWidget = WafePermStringToQuark("Widget");
 XtSetTypeConverter(XtRString, XtRWidget,
	(XtTypeConverter)CvtStringToWidget, 
	NULL, 0, XtCacheNone, NULL);
 XtSetTypeConverter(XtRString, XtRCallback,
	(XtTypeConverter)CvtStringToCallback, 
	NULL, 0, XtCacheNone, NULL);
 XtSetTypeConverter(XtRString, XtRPointer,
	(XtTypeConverter)CvtStringToPointer, 
	NULL, 0, XtCacheNone, NULL);
 XtSetTypeConverter(XtRString, XtRWidgetList,
	(XtTypeConverter)CvtStringToWidgetList, 
	NULL, 0, XtCacheNone, NULL);
#ifndef PRER5
 XtSetTypeConverter(XtRString, XtRCardinal,
	(XtTypeConverter)XtCvtStringToInt, 
	NULL, 0, XtCacheNone, NULL);
#endif
 Tcl_CreateCommand(wafeInterpreter, "addTimeOut", com_addTimeOut, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "action", com_action, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "bell", com_bell, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "callActionProc", com_callActionProc, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "callCallbacks", com_callCallbacks, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "callback", com_callback, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "destroyWidget", com_destroyWidget, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "getClass", com_getClass, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "getResourceList", com_getResourceList, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "getTypeOfAttribute", com_getTypeOfAttribute, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "getValue", com_getValue, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "grabPointer", com_grabPointer, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "grabKeyboard", com_grabKeyboard, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "installAccelerators", com_installAccelerators, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "installAllAccelerators", com_installAllAccelerators, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "manageChild", com_manageChild, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "mapWidget", com_mapWidget, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "mergeResources", com_mergeResources, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "popdown", com_popdown, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "popup", com_popup, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "popupSpringLoaded", com_popupSpringLoaded, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "realize", com_realize, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "removeAllCallbacks", com_removeAllCallbacks, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "setKeyboardFocus", com_setKeyboardFocus, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "setValues", com_setValues, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "setWMProtocols", com_setWMProtocols, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "translateCoords", com_translateCoords, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "ungrabPointer", com_ungrabPointer, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "ungrabKeyboard", com_ungrabKeyboard, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "unmanageChild", com_unmanageChild, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "unmapWidget", com_unmapWidget, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "unrealizeWidget", com_unrealizeWidget, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "realizeWidget", com_realizeWidget, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "disownSelection", com_disownSelection, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "getSelectionValue", com_getSelectionValue, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "ownSelection", com_ownSelection, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "fetchBytes", com_fetchBytes, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "convertSelection", com_convertSelection, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "storeBuffer", com_storeBuffer, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "fetchBuffer", com_fetchBuffer, NULL, NULL);
 /* alias */  Tcl_CreateCommand(wafeInterpreter,"sV",com_setValues, NULL,NULL);
 /* alias */  Tcl_CreateCommand(wafeInterpreter,"gV",com_getValue, NULL,NULL);
 xpmRegisterTypeConverter(XtRBitmap, False);
 xpmRegisterTypeConverter(XtRPixmap, True);
#ifdef XPM
 Tcl_CreateCommand(wafeInterpreter, "setIconPixmap", com_setIconPixmap, NULL, NULL);
#endif
#ifdef XPM
 Tcl_CreateCommand(wafeInterpreter, "changePixmap", com_changePixmap, NULL, NULL);
#endif
 Tcl_CreateCommand(wafeInterpreter, "isWidget", com_isWidget, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "parent", com_parent, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "widthOfScreen", com_widthOfScreen, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "heightOfScreen", com_heightOfScreen, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "resolvePathname", com_resolvePathname, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "setSensitive", com_setSensitive, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "setBusy", com_setBusy, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "textWidth", com_textWidth, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "fontHeight", com_fontHeight, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "raiseWindow", com_raiseWindow, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "lowerWindow", com_lowerWindow, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "waitForVariable", com_waitForVariable, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "getApplicationResource", com_getApplicationResource, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "popupChildren", com_popupChildren, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "flush", com_flush, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "sync", com_sync, NULL, NULL);
 /* alias */  Tcl_CreateCommand(wafeInterpreter,"widgetId",com_isWidget, NULL,NULL);
 Tcl_CreateCommand(wafeInterpreter, "widgetName", com_widgetName, NULL, NULL);

#else
#endif
}
