$PACKAGE = "ATHENA"; $PREFIX = "Xaw";

~handles
	ATHENA
	XAW3D

#include "wafe.h"

~require
athena.inc
	quark callback
	quark jumpProc
	quark scrollProc

~widgetClass 
Text
	include <X11/Xaw/AsciiText.h>

Boolean
XawAsciiSave
	in: XawTextGetSource(AsciiTextWidget)	# ascii text wiget

int 
XawAsciiSaveAsFile
        in: XawTextGetSource(AsciiTextWidget)	# ascii text wiget
        in: String			        # file name

Boolean
XawAsciiSourceChanged 
	in: XawTextGetSource(AsciiTextWidget)	# ascii text wiget

void
XawAsciiSourceFreeString
	in: XawTextGetSource(AsciiTextWidget)	# ascii text wiget

~widgetClass 
Box
	include <X11/Xaw/Box.h>

~widgetClass 
Clock
	include <X11/Xaw/Clock.h>

~widgetClass 
Command
	include <X11/Xaw/Command.h>

~widgetClass 
Dialog
	include <X11/Xaw/Dialog.h>

String
XawDialogGetValueString
	in: DialogWidget		# dialog widget

~widgetClass 
Form
	include <X11/Xaw/Form.h>

void
XawFormDoLayout
	in: FormWidget			# form widget
	in: Boolean			# boolean

~widgetClass 
Grip
	include <X11/Xaw/Grip.h>

~widgetClass 
Label
	include <X11/Xaw/Label.h>

~widgetClass 
List
	include <X11/Xaw/List.h>
	createCmd listCreate
	callback i int: ((XawListReturnStruct *)callData)->list_index \
		# index
	callback s EscapedString: ((XawListReturnStruct *)callData)->string  \
		# selection

~bcAlias
list llist

void
listAppend vulgo XawListAppend
	in: ListWidget			# list widget
	in: [args]			# items 

void
listChange vulgo XawListChange
	in: ListWidget			# list widget
	const: argv[1]
	in: int				# number of items
	in: int				# longest
	in: int				# resize
	in: [args]			# Arg items | File filename

void
XawListHighlight
	in: ListWidget			# list widget
	in: int				# item number

XawListReturnStruct *
XawListShowCurrent
	in: ListWidget			# list widget


void
XawListUnhighlight
	in: ListWidget			# list widget

~widgetClass 
Logo
	include <X11/Xaw/Logo.h>

~widgetClass 
Mailbox
	include <X11/Xaw/Mailbox.h>

~widgetClass 
MenuButton
	include <X11/Xaw/MenuButton.h>

~widgetClass 
Paned
	include <X11/Xaw/Paned.h>

void
XawPanedAllowResize
	in: PanedWidget			# paned widget
	in: Boolean			# boolean

void
XawPanedGetMinMax
	in: PanedWidget			# paned widget
	out: int			# min
	out: int			# max

int
XawPanedGetNumSub
	in: PanedWidget			# paned widget

void
XawPanedSetMinMax
	in: PanedWidget			# paned widget
	in: int				# min
	in: int				# max

void 
XawPanedSetRefigureMode
	in: PanedWidget			# paned widget
	in: Boolean			# boolean

~widgetClass 
Scrollbar
	include <X11/Xaw/Scrollbar.h>
	createCmd scrollbarCreate
	scrollProc p int: (int)callData		# position of thumb (in pixel)
	jumpProc p float: *(float *)callData	# floating position (0.0-1.0)

void
XawScrollbarSetThumb
	in: ScrollbarWidget		# scrollbar widget
	in: float			# top
	in: float			# shown

~alias
	scSet XawStripChartSet

~widgetClass 
SimpleMenu
	include <X11/Xaw/SimpleMenu.h>
	createCmd XtCreatePopupShell
	createsShell

void 
XawSimpleMenuClearActiveEntry
	in: SimpleMenuWidget		# widget

Widget
XawSimpleMenuGetActiveEntry
	in:SimpleMenuWidget		# widget

~objectClass 
Sme
	include <X11/Xaw/Sme.h>

~objectClass 
SmeBSB
	include <X11/Xaw/SmeBSB.h>

~objectClass 
SmeLine
	include <X11/Xaw/SmeLine.h>

~widgetClass 
StripChart
	include <X11/Xaw/StripChart.h>
	createCmd stripChartCreate

void
stripChartSet vulgo XawStripChartSet
	in: StripChartWidget		# strip chart widget
	in: double			# value

void
XawTextDisableRedisplay
	in: AsciiTextWidget		# ascii text wiget

void
XawTextDisplay
	in: AsciiTextWidget		# ascii text wiget

void
XawTextDisplayCaret
	in: AsciiTextWidget		# ascii text wiget
	in: Boolean			# boolean

void
XawTextEnableRedisplay
	in: AsciiTextWidget		# ascii text wiget

XawTextPosition
XawTextGetInsertionPoint
	in: AsciiTextWidget		# ascii text wiget

void 
XawTextGetSelectionPos
        in: AsciiTextWidget 		# ascii text wiget
        out: XawTextPosition		# varname for from position
        out: XawTextPosition 		# varname for to position

void
XawTextInvalidate
	in: AsciiTextWidget		# ascii text wiget
	in: XawTextPosition		# from postion
	in: XawTextPosition		# to postion

XawTextPosition
XawTextSearch
	in: AsciiTextWidget		# ascii text wiget
	in: XawTextScanDirection	# scan direction
	in: XawTextBlock		# text block

void
XawTextSetInsertionPoint
	in: AsciiTextWidget		# ascii text wiget
	in: XawTextPosition		# position

void 
XawTextSetSelection
        in: AsciiTextWidget 		# ascii text wiget
        in: XawTextPosition		# from position
        in: XawTextPosition 		# to position

void
XawTextSetSelectionArray
	in: AsciiTextWidget		# ascii text wiget
	in: [XawTextSelectType]		# selction array


int
XawTextSinkMaxHeight
	in: (Widget)TextSink 		# ascii text wiget
	in: int				# height

int
XawTextSinkMaxLines
	in: (Widget)TextSink		# ascii text wiget
	in: Dimension			# height

void
XawTextSinkSetTabs
	in: (Widget)TextSink		# ascii text wiget
	const: argc-2
	in: [int]			# tabs

XawTextPosition
XawTextSourceRead 
	in: (Widget)TextSource		# ascii text wiget
	in: XawTextPosition		# position
	out: XawTextBlock		# varname for text block
	in: int				# length

XawTextPosition
XawTextSourceScan
	in: (Widget)TextSource		# ascii text wiget
	in: XawTextPosition		# position
	in: XawTextScanType		# scan type
	in: XawTextScanDirection	# scan direction
	in: int				# count
	in: Boolean			# include (boolean)

XawTextPosition
XawTextTopPosition
	in: AsciiTextWidget		# ascii text wiget

(int) ReplaceVal 
XawTextReplace
        in: AsciiTextWidget		# ascii text wiget
        in: XawTextPosition 		# from position
        in: XawTextPosition 		# to position
        in: XawTextBlock		# text block

void 
XawTextUnsetSelection
        in: AsciiTextWidget 		# ascii text wiget

~widgetClass 
Toggle
	include <X11/Xaw/Toggle.h>

void
XawToggleChangeRadioGroup
	in: ToggleWidget		# toggle widget
	in: NULL | ToggleWidget		# NULL | toggle widget

String
XawToggleGetCurrent
	in: ToggleWidget		# toggle widget

void
XawToggleSetCurrent
	in: ToggleWidget		# toggle widget
	in: String			# radio data

#define toggleSetRadioData(w, string) \
	XtVaSetValues(w, XtNradioData, string, NULL)

void
toggleSetRadioData vulgo XawToggleSetRadioData
	in: ToggleWidget		# toggle widget
        in: XtNewString(String)		# radio data

void
XawToggleUnsetCurrent
	in: ToggleWidget		# toggle widget

~widgetClass 
Viewport
	include <X11/Xaw/Viewport.h>

hint: R5|XAW3D
void
XawViewportSetCoordinates
	in: ViewportWidget		# viewport Widget
	in: Position			# x position
	in: Position			# y position

hint: R5|XAW3D
void
XawViewportSetLocation
	in: ViewportWidget		# viewport Widget
	in: double			# xoffset 
	in: double			# yoffset

