#
# missing: names, ids, parent = 0 for topLevel? resourceNames
#

# getValue, gV         get value of an attribute
# setValues, sV        set value of an attribute
# getTypeOfAttribute   get type of an attribute
# 
# getClass             get class of a given widget
# getResourceList      get resource list of a given widget
# isWidget             test whether widget exists
# parent               return parent widget


proc widget {request {widget topLevel}} {
  switch $request {
    exists        { return [isWidget $widget] }
    id            { return [widgetId $widget] }
    name          { return [widgetName $widget] }
    parent        { return [parent $widget]  }
    resourceNames { getResourceList $widget res; return $res }
    class         { return [getClass $widget] }
    children      { 
      if {[string match {} [getTypeOfAttribute $widget children]]} {
	return {} 
      } else {
	return [gV $widget children] 
      }
    }
    popupChildren { return [popupChildren $widget] }
    allChildren   { return [concat [popupChildren $widget] \
			           [widget children $widget]] }
    path          {
      set path {}
      set p [parent $widget]
      while {$p != $widget} {
	set path [linsert $path 0 [widgetName $widget]]
	set widget $p
	set p [parent $p]
      }
      return [join [linsert $path 0 *] .]
    }
    default   { return -code error  \
      "bad option '$request': should be allChildren, children, class, exists, id, name, parent, path, popupChildren or resourceList" 
    }
  }
} 
