/* make emcas happy -*-C-*-  make emacs happy */

#include <ctype.h>
#include <Xm/AtomMgr.h>

#include <Xm/DragDrop.h>

extern XmString stringToXmString(
#if NeedFunctionPrototypes
    char *
#endif
);

extern char * xmString2String(
#if NeedFunctionPrototypes
    char *, XmString
#endif
);

static Widget currentDragContext;

#define	Done(type, value) \
	{							\
	    if (toVal->addr != NULL) {				\
		if (toVal->size < sizeof(type)) {		\
		    toVal->size = sizeof(type);			\
		    return False;				\
		}						\
		*(type*)(toVal->addr) = (value);		\
	    }							\
	    else {						\
		static type static_val;				\
		static_val = (value);				\
		toVal->addr = (XtPointer)&static_val;		\
	    }							\
	    toVal->size = sizeof(type);				\
	    return True;					\
	}

void
callbackProc(w, clientData, callData)
Widget w;
XtPointer clientData;
XtPointer callData;
    {
    XmAnyCallbackStruct *cbs = (XmAnyCallbackStruct *)callData;
    if (cbs->reason == XmCR_DROP_MESSAGE)
	{
	XmDropProcCallbackStruct *drop_cbs =
	    (XmDropProcCallbackStruct *)callData;
	char *cmd;
	/*fprintf(stderr,"dropProc: getting attriblist of <%s>\n",XtName(w));*/
	cmd = (char *)MMgetValue(MMgetAttribList(w,True), qdropProc);
	/*fprintf(stderr,"in callbackProc, dropProc, widget = %p <%s> cmd=<%s>\n",
		w,XtName(w),cmd+sizeof(XrmQuark));
         */
	execCallbackProc(drop_cbs->dragContext, (XtPointer)cmd, callData);
	}
    }


Boolean
convertSelectionIncrProc(w, selection, target, type, value, length, format,
			 max_length, client_data, request_id)
Widget        w;
Atom          *selection;
Atom          *target;
Atom          *type;
XtPointer     *value;
unsigned long *length;
int           *format;
unsigned long *max_length;
XtPointer     client_data;
XtRequestId   *request_id;
    {
    Boolean result;
    if (XtClass(w) == xmDragContextClass)
	{
	Display *dpy       = XtDisplay(w);
	Atom COMPOUND_TEXT = XmInternAtom(dpy, "COMPOUND_TEXT", False);
	Atom DELETE        = XmInternAtom(dpy, "DELETE", False);
	Atom TARGETS       = XmInternAtom(dpy, "TARGETS", False);
	char **cd, *cmd, *targetName = NULL;
	
	if (! *selection == XmInternAtom(dpy, "_MOTIF_DROP", False))
	    return False;  /* it looks as if this was not for us! */

	/* if there is a command for the convert procedure registered,
	   call it and provide the target as callData; this is necessary
	   for the DELETE target in DROP_MOVE command
	 */
	if ((cmd = (char *)MMgetValue(MMgetAttribList(w,True), qconvertProc)))
	    {
	    targetName = XGetAtomName(dpy,*target);
	    execCallbackProc(w, (XtPointer)cmd, targetName);
	    }
	    
	if (*target == COMPOUND_TEXT)
	    {
	    XmString t;

	    /* we pass the text via the clientData resource */
	    XtVaGetValues(w, XmNclientData, &cd, NULL);
	    
	    if (!cd || !*cd )
		{
		fprintf(stderr,"Wafe(%s): invalid clientData\n","convertSelectionIncrProc");
		if (targetName) XFree(targetName);
		return False;
		}

	    t = stringToXmString(*cd);
	    /* it is wierd that the returned compound text is of type
               char* since - as it looks to me - CT can have inbedded
               nulls, which will cause truncations on strlen etc 
             */
	    *type = *target;
	    *value = (XtPointer)XmCvtXmStringToCT(t);
	    *length = (unsigned long)(strlen(*value)+1);

	    XmStringFree(t);
	    *format = 8;
	    result = True;
	    }
	else 
	if (*target == DELETE)
	    {
	    if (!cmd) 
		fprintf(stderr,"Wafe(%s): no convertProc registered for a DROP_MOVE operation\n",
			"convertSelectionIncrProc");

	    *type = XmInternAtom(dpy, "NULL", False);
	    *value = NULL;
	    *length = 0;
	    *format = 8;
	    result = True;
	    }
	else 
        if (*target == TARGETS)  /* This target is required by ICCC */
	    {
	    int target_count = 0;
	    Atom *targs = (Atom *)XtMalloc((unsigned) (6 * sizeof(Atom)));
	    *value = (XtPointer) targs;

	    /* if targets are added, increase the constant in malloc! */
	    *targs++ = COMPOUND_TEXT;
	    target_count++;
	    *targs++ = DELETE;
	    target_count++;
	    *targs++ = TARGETS;
	    target_count++;
	    *targs++ = XmInternAtom(dpy, "MULTIPLE", False);
	    target_count++;  /* supported in the Intrinsics */
	    *targs++ = XmInternAtom(dpy, "TIMESTAMP", False);
	    target_count++; /* supported in the Intrinsics */
	    
	    *type = XA_ATOM;
	    *length = (target_count * sizeof(Atom)) >> 2;
	    *format = 32;
            }
	else
	    {
	    if (!targetName) targetName = XGetAtomName(dpy,*target);
	    fprintf(stderr,"Wafe(%s): unknown target %s\n",
		    "convertSelectionIncrProc",targetName);
	    result = False;
	    }

	if (targetName) XFree(targetName);
	}
    return result;
    }

void
selectionCallbackProc (w, closure, selection, type, value, length, format)
Widget          w;
XtPointer       closure;
Atom*           selection;
Atom*           type;
XtPointer       value;
unsigned long*  length;
int*            format;
    {
    if (XtClass(w) == xmDropTransferObjectClass)
	{
	dropTransferCallbackStruct dtCbs;
	Atom COMPOUND_TEXT, TEXT, FILE_NAME, A_NULL;
	XmDropTransferEntryRec *dropTransferEntries;
	char *cmd;
	Display *dpy;

	if (!currentDragContext)
	    return;   /* to avoid surprises... */
	
	dpy = XtDisplay(currentDragContext);
	if (! *selection == XmInternAtom(dpy, "_MOTIF_DROP", False))
	    return;   /* to avoid surprises... */

	if (!(cmd = (char *)MMgetValue(MMgetAttribList(w,True), qtransferProc)))
	    {
	    fprintf(stderr,"Wafe(%s): no transferProc registered\n","selectionCallbackProc");
	    return;
	    }

	XtVaGetValues(w, XmNdropTransfers,&dropTransferEntries, NULL);
	
	COMPOUND_TEXT = XInternAtom(dpy,"COMPOUND_TEXT", False);
	TEXT          = XInternAtom(dpy,"TEXT", False);
	FILE_NAME     = XInternAtom(dpy,"FILE_NAME", False);
	A_NULL        = XInternAtom(dpy,"NULL", False);
	dtCbs.dest    = (String)dropTransferEntries->client_data;

	if (*type == COMPOUND_TEXT)
	    {
	    XmString t = XmCvtCTToXmString(value);
	    dtCbs.value = xmString2String(NULL,t);
/*
	    fprintf(stderr,"+ in callbackProc, transferProc, widget = %p <%s> cmd=<%s>, <%s> <%s>\n",
		    w,XtName(w),cmd+sizeof(XrmQuark),dtCbs.value,value);
 */
	    execCallbackProc(w, (XtPointer)cmd, &dtCbs);
	    XtFree(dtCbs.value);
	    XmStringFree(t);
	    }
	else 
	if ((*type == XA_STRING) || (*type == TEXT) || (*type == FILE_NAME))
	    {
	    dtCbs.value = XtMalloc(*length + 1);
	    memcpy(dtCbs.value, value, *length);
	    *((char*)(dtCbs.value) + *length) = '\0';
 	    }
	else
	if (*type == XT_CONVERT_FAIL)
	    {
	    fprintf(stderr,"Wafe(%s): conversion failed\n","selectionCallbackProc");
	    }
	else 
	if (*type != A_NULL && (*type != 0))
	    {
	    char *p;
            p = XGetAtomName(dpy,*type);
	    fprintf(stderr,"Wafe(%s): unknown type %s\n","selectionCallbackProc",p);
	    if (p) XFree(p);
	    }
	}
    }


Boolean
CvtStringToCallbackProc(dpy, args, num_args, fromVal, toVal,
		    converter_data)
Display *dpy;
XrmValue *args;
Cardinal *num_args;
XrmValue *fromVal;
XrmValue *toVal;
XtPointer *converter_data;
    {
    char *charp = XtMalloc(strlen(fromVal->addr)+1+sizeof(XrmQuark));

    *(XrmQuark *)charp = wafeCurrentAttrib;
    strcpy((char *)charp + sizeof(XrmQuark), (char *)fromVal->addr);

    MMreplace(wafeCurrentAttribList, wafeCurrentAttrib,
	      (char *)charp, XtFree);
    Done(XtCallbackProc, &callbackProc);
    }


Boolean
CvtStringToDragOperations(dpy, args, num_args, fromVal, toVal, converter_data)
Display *dpy;
XrmValue *args;
Cardinal *num_args;
XrmValue *fromVal;
XrmValue *toVal;
XtPointer *converter_data;
    {
    unsigned char result = '\0';
    char *p=strtok(fromVal->addr,"|");
    do
	{
	if (!strcmp("DROP_COPY",p))
	    result |= XmDROP_COPY;
	else 
	if (!strcmp("DROP_MOVE",p))
	    result |= XmDROP_MOVE;
	else 
	if (!strcmp("DROP_LINK",p))
	    result |= XmDROP_LINK;
	else 
	if (!strcmp("DROP_NOOP",p))
	    result = XmDROP_NOOP;
	else
	    return False;
	}
    while ((p = strtok(NULL,"|")));
    Done(unsigned char, result);
    }

Boolean
CvtStringToTransferStatus(dpy, args, num_args, fromVal, toVal, converter_data)
Display *dpy;
XrmValue *args;
Cardinal *num_args;
XrmValue *fromVal;
XrmValue *toVal;
XtPointer *converter_data;
    {
    unsigned char result = '\0';
    char *p = fromVal->addr;

    if (!strcmp("TRANSFER_SUCCESS",p))
	result = XmTRANSFER_SUCCESS;
    else 
    if (!strcmp("TRANSFER_FAILURE",p))
	result = XmTRANSFER_FAILURE;
    else
	return False;

    Done(unsigned char, result);
    }


Boolean
CvtStringToConvertSelectionIncrProc(dpy, args, num_args, fromVal, toVal,
		    converter_data)
Display *dpy;
XrmValue *args;
Cardinal *num_args;
XrmValue *fromVal;
XrmValue *toVal;
XtPointer *converter_data;
    {
    char *charp = XtMalloc(strlen(fromVal->addr)+1+sizeof(XrmQuark));

    *(XrmQuark *)charp = wafeCurrentAttrib;
    strcpy((char *)charp + sizeof(XrmQuark), (char *)fromVal->addr);

    MMreplace(wafeCurrentAttribList, wafeCurrentAttrib,
	      (char *)charp, XtFree);
    return True;
    }


Boolean
CvtStringToSelectionCallbackProc(dpy, args, num_args, fromVal, toVal,
		    converter_data)
Display *dpy;
XrmValue *args;
Cardinal *num_args;
XrmValue *fromVal;
XrmValue *toVal;
XtPointer *converter_data;
    {
    char *charp = XtMalloc(strlen(fromVal->addr)+1+sizeof(XrmQuark));

    *(XrmQuark *)charp = wafeCurrentAttrib;
    strcpy((char *)charp + sizeof(XrmQuark), (char *)fromVal->addr);

    MMreplace(wafeCurrentAttribList, wafeCurrentAttrib,
	      (char *)charp, XtFree);
    Done(XtCallbackProc, &selectionCallbackProc);
    }

XmDropTransferEntryRec *
string2transferEntryRec(string,dpy)
char * string;
Display *dpy;
    {
    char **argv, **p, **innerArgv;
    int argc, count, n;
    XmDropTransferEntryRec *entries, *dropRecs;
	
    if (Tcl_SplitList(wafeInterpreter, string, &argc, &argv) == TCL_ERROR)
	{
	fprintf(stderr,"Wafe(%s): %s\n","CvtToDropTransfer",wafeInterpreter->result);
	return False;
	}
    count = argc;

    dropRecs = entries = (XmDropTransferEntryRec*)XtMalloc(sizeof(XmDropTransferEntryRec)*count);
    for (p = argv; count>0; count--,p++)
	{
	if (Tcl_SplitList(wafeInterpreter, *p, &n, &innerArgv) == TCL_ERROR)
	    {
	    fprintf(stderr,"Wafe(%s): %s\n","CvtToDropTransferArg",
		    wafeInterpreter->result);
	    XtFree((char *)argv);
	    return NULL;
	    }
	if (n != 2)
	    {
	    fprintf(stderr,"Wafe(%s): %s\n","CvtToDropTransferArg",
		    "DropTransferRec should have two elements!");
	    XtFree((char *)argv);
	    return NULL;
	    }
	entries->target = XInternAtom(dpy, innerArgv[0], False);
	entries->client_data = cvtName2Widget(innerArgv[1],True,NULL,NULL);
	entries++;
	XtFree((char *)innerArgv);
	}
    XtFree((char *)argv);
    return dropRecs;
    }


Boolean
CvtStringToDropTransfers(dpy, args, num_args, fromVal, toVal,
		    converter_data)
Display *dpy;
XrmValue *args;
Cardinal *num_args;
XrmValue *fromVal;
XrmValue *toVal;
XtPointer *converter_data;
    {
    XmDropTransferEntryRec *dropRecs;
    if (!(dropRecs = string2transferEntryRec(fromVal->addr,dpy)))
	return False;
    
    MMreplace(wafeCurrentAttribList, wafeCurrentAttrib,
	      (char *)dropRecs, XtFree);
    Done(XmDropTransferEntryRec*, dropRecs);
    }



void
CBfreeAttribs(w, client_data, call_data)
Widget w;
caddr_t client_data;
caddr_t call_data;
    {
    (void)MMfreeGarbage(w);
    }

