/* das ist ein -*- C -*- Programm */

/* this definition is from tclInt.h 
 * the first FOUR entries match EXACT the Interp struct from 
 * tclInt.h; we can't include tclInt.h, since it conflicts with
 * Xt' Arg structure.
 */
typedef struct Interp {
    /*
     * Note:  the first three fields must match exactly the fields in
     * a Tcl_Interp struct (see tcl.h).  If you change one, be sure to
     * change the other.
     */

    char *result;               /* Points to result returned by last
                                 * command. */
    Tcl_FreeProc *freeProc;     /* Zero means result is statically allocated.
                                 * If non-zero, gives address of procedure
                                 * to invoke to free the result.  Must be
                                 * freed by Tcl_Eval before executing next
                                 * command. */
    int errorLine;              /* When TCL_ERROR is returned, this gives
                                 * the line number within the command where
                                 * the error occurred (1 means first line). */
    Tcl_HashTable commandTable; /* Contains all of the commands currently
                                 * registered in this interpreter.  Indexed
                                 * by strings; values have type (Command *). */
    } Interp;

int
alias(newCmd,oldCmd)
char *newCmd;
char *oldCmd;
    {
    XtPointer cmdPtr;
    Interp *iPtr = (Interp *) wafeInterpreter;
    Tcl_HashEntry *hPtr;
    int new;    

    if ((hPtr = Tcl_FindHashEntry(&iPtr->commandTable, newCmd)) != NULL)
	{
	fprintf(stderr,
		"Wafe(alias): can't alias to '%s': command already exists\n",
		newCmd);
        /* Tcl_AppendResult(wafeInterpreter, "can't alias to \"", newCmd,
                "\": command already exists", (char *) NULL); */
        return 0;
	}
    
    if ((hPtr = Tcl_FindHashEntry(&iPtr->commandTable, oldCmd)) == NULL)
	{
	fprintf(stderr,
		"Wafe(alias): can't alias '%s': command doesn't exist\n",
		oldCmd);
        /* Tcl_AppendResult(wafeInterpreter, "can't alias \"", oldCmd,
                "\":  command doesn't exist", (char *) NULL); */
        return 0;
	}

    cmdPtr = (XtPointer) Tcl_GetHashValue(hPtr);
    hPtr = Tcl_CreateHashEntry(&iPtr->commandTable, newCmd, &new);
    Tcl_SetHashValue(hPtr, cmdPtr);
    return 1;
}
