$PACKAGE = "MOTIF11";

~handles 
	MOTIF11

#include "wafe.h"
#include <Xm/Xm.h>
#include <X11/Shell.h>

# conv "VerticalDimension"  XtRString       None CvtDimensionToString    None

~require
motif.inc
	conv XtRString "XmString"      None CvtStringToXmString  XmStringFree
	conv XtRString "XmStringTable" None CvtStringToXmStrings freeStringTable
	conv XtRString "Window"        None CvtStringToWidget    None
	conv XtRString "MenuWidget"    None CvtStringToWidget    None
	conv "XmString" XtRString      None CvtXmStringToString  None
	conv "XmStringTable" XtRString None CvtXmStringTableToString  None
	conv XtRString "TextPosition"  None CvtStringToLong      None
	init  wafeMotifInit();
	quark XmString
	quark XmStringTable
	quark Window
	quark HorizontalDimension
	quark VerticalDimension
	quark TextPosition
	quark VerticalPosition
	quark HorizontalPosition
	quark PrimForegroundPixmap
	init XtAddConverter (XmRString, XmRUnitType, XmCvtStringToUnitType, NULL, 0);

# ******* Input Focus Functions ******

Boolean
XmProcessTraversal
	in: Widget		# Widget for which to traverse hierarchy
	in: (int) XmTravDir	# direction in which to traverse widget hierarchy

# ********

~widgetClass
XmArrowButton
	include <Xm/ArrowB.h>
	activateCallback c int: \
		((XmArrowButtonCallbackStruct *)callData)->click_count # click count


~gadgetClass
XmArrowButtonGadget
	include <Xm/ArrowBG.h>
	activateCallback c int: \
		((XmArrowButtonCallbackStruct *)callData)->click_count # click count


~widgetClass
XmBulletinBoard
	include <Xm/BulletinB.h>

~pseudoWidgetClass
XmBulletinBoardDialog
	className XmBulletinBoard
	createCmd XmCreateBulletinBoardDialog
	createsShell

~widgetClass
XmCascadeButton
	include <Xm/CascadeB.h>

~gadgetClass
XmCascadeButtonGadget
	include <Xm/CascadeBG.h>

void 
XmCascadeButtonGadgetHighlight
	in: XmCascadeButtonGadget   	# cascadeButtonGadget to be highlighted
	in: Boolean          	    	# highlight (bool)

void 
XmCascadeButtonHighlight
	in: XmCascadeButtonGadget   	# widget to be highlighted
	in: Boolean          	    	# highlight (bool)

~widgetClass
XmCommand
	include <Xm/Command.h>
	commandChanged|commandEntered s EscapedXmString: \
		((XmCommandCallbackStruct *)callData)->value # command string

void
XmCommandAppendValue
	in: XmCommandWidget          	# command widget 
	in: XmString         		# command string

void
XmCommandError
	in: XmCommandWidget           	# command widget 
	in: XmString         		# error message

~widgetClass
XmDialogShell
	include <Xm/DialogS.h>
	createsShell

~widgetClass
XmDrawingArea
        include <Xm/DrawingA.h>
	expose|input|resize w Window: \
		(void*)((XmDrawingAreaCallbackStruct *)callData)->window # window


~widgetClass
XmDrawnButton
        include <Xm/DrawnB.h>
	activate c int: \
		((XmDrawnButtonCallbackStruct *)callData)->click_count 	# click count
	expose|resize w Window: \
		(void*)((XmDrawnButtonCallbackStruct *)callData)->window # window



~widgetClass
XmFileSelectionBox
	include <Xm/FileSB.h>
	okCallback|noMatchCallback|applyCallback d EscapedXmString: \
		((XmFileSelectionBoxCallbackStruct *)callData)->dir \
			# base directory
	okCallback|noMatchCallback|applyCallback p EscapedXmString: \
		((XmFileSelectionBoxCallbackStruct *)callData)->pattern \
			# search pattern
	okCallback|noMatchCallback|applyCallback m EscapedXmString: \
		((XmFileSelectionBoxCallbackStruct *)callData)->mask \
			# value of dirMask
	okCallback|noMatchCallback|applyCallback s EscapedXmString: \
		((XmFileSelectionBoxCallbackStruct *)callData)->value \
			# value of dirSpec


Widget
XmFileSelectionBoxGetChild
	in: XmFileSelectionBoxWidget		# file selection box widget
	in: (unsigned char)XmChild 		# child reference

~pseudoWidgetClass
XmFileSelectionDialog
	className XmFileSelectionBox
	createCmd XmCreateFileSelectionDialog
	createsShell

void
XmFileSelectionDoSearch
	in: XmFileSelectionBoxWidget		# file selection box
	in: XmString				# directory mask

~widgetClass
XmForm
	include <Xm/Form.h>

~pseudoWidgetClass 
XmFormDialog
	className XmForm
	createCmd XmCreateFormDialog
	createsShell

~widgetClass
XmFrame
        include <Xm/Frame.h>

~pseudoWidgetClass
XmInformationDialog
	className XmMessageBox
	createCmd XmCreateInformationDialog
	createsShell

~widgetClass 
XmLabel
	include <Xm/Label.h>

~gadgetClass 
XmLabelGadget
	include <Xm/LabelG.h>

# *******  XmList Widget Class und programmatic Interface *******

~widgetClass
XmList
	include <Xm/List.h>
	browseSelection|defaultAction|singleSelection s EscapedXmString: \
		((XmListCallbackStruct *)callData)->item \
			# selected item
	browseSelection|defaultAction|singleSelection p int: \
		((XmListCallbackStruct *)callData)->item_position \
			# item position
	extendedSelection|multipleSelection S XmStringTable: \
		((XmListCallbackStruct *)callData)->selected_item_count, \
		((XmListCallbackStruct *)callData)->selected_items \
			# selected items
	extendedSelection|multipleSelection P intArray: \
		((XmListCallbackStruct *)callData)->selected_item_count, \
		((XmListCallbackStruct *)callData)->selected_item_positions \
			# selected item positions
	browseSelection|defaultAction|extendedSelection|multipleSelection|singleSelection t int: \
		((XmListCallbackStruct *)callData)->selection_type \
			# selection type

void
XmListAddItem
	in: XmListWidget	# List Widget
	in: XmString		# Item to add
	in: int			# Position

void
XmListAddItems
	in: XmListWidget	# List Widget
	in: XmStringTable	# items
	in: int			# number of items
	in: int			# position

void
XmListAddItemUnselected
	in: XmListWidget	# List Widget
	in: XmString		# Item to add
	in: int			# Position

void
XmListDeleteAllItems
	in: XmListWidget	# List Widget

void
XmListDeleteItem
	in: XmListWidget	# List Widget
	in: XmString		# Item to delete

void
XmListDeleteItems
	in: XmListWidget	# List Widget
	in: XmStringTable	# items
	in: int			# number of items

void
XmListDeleteItemsPos
	in: XmListWidget	# List Widget	
	in: int			# number of items
	in: int			# position of first item to be deleted

void
XmListDeletePos
	in: XmListWidget	# List Widget	
	in: int			# position of item

void
XmListDeselectAllItems
	in: XmListWidget	# List Widget	

void
XmListDeselectItem
	in: XmListWidget	# List Widget	
	in: XmString		# item

void
XmListDeselectPos
	in: XmListWidget	# List Widget	
	in: int			# position of item

Boolean                          
XmListGetMatchPos
	in: XmListWidget	# List Widget   
	in: XmString		# item
	out: list(int*,int)	# list of positions  

Boolean
XmListGetSelectedPos
	in: XmListWidget	# List Widget
	out: list(int*,int)     # list of highlighted items

Boolean
XmListItemExists
	in: XmListWidget	# List Widget
	in: XmString		# Item

int
XmListItemPos
	in: XmListWidget	# List Widget
	in: XmString		# Item

void
XmListReplaceItems
	in: XmListWidget	# List Widget
	in: XmStringTable	# Items to be replaced
	in: int			# number of items to be replaced
	in: XmStringTable	# new items

void
XmListReplaceItemsPos
	in: XmListWidget	# List Widget
	in: XmStringTable	# New items
	in: int			# number of items to be replaced
	in: int 		# first Pos of items to be replaced

void
XmListSelectItem
	in: XmListWidget	# List Widget
	in: XmString		# item to highlight
	in: Boolean		# Invoke callback yes/no

void
XmListSelectPos
	in: XmListWidget	# List Widget
	in: int			# Position of item 
	in: Boolean		# Invoke callback yes/no

void
XmListSetAddMode
	in: XmListWidget 	# List Widget
	in: Boolean		# Use Add Mode yes/no

void
XmListSetBottomItem	
	in: XmListWidget 	# List Widget
	in: XmString		# item to be displayed as last item

void
XmListSetBottomPos
	in: XmListWidget 	# List Widget
	in: int			# item to be displayed as last item

void
XmListSetHorizPos
	in: XmListWidget 	# List Widget
	in: int			# horizontal Position

void
XmListSetItem
	in: XmListWidget 	# List Widget
	in: XmString		# item

void
XmListSetPos
	in: XmListWidget 	# List Widget
	in: int			# Position

# ****** Main Window Class ******

~widgetClass 
XmMainWindow
	include <Xm/MainW.h>

void
XmMainWindowSetAreas
	in: NULL | Widget	# main window widget
	in: NULL | Widget	# menu bar widget
	in: NULL | Widget	# command window widget
	in: NULL | Widget	# horizontal scrollbar widget
	in: NULL | Widget	# vertical scrollbar widget
	in: NULL | Widget	# work region widget

~pseudoWidgetClass 
XmMenuBar
	className XmRowColumn
	createCmd XmCreateMenuBar

~widgetClass
XmMenuShell
        include <Xm/MenuShell.h>
	createsShell

~widgetClass 
XmMessageBox
	include <Xm/MessageB.h>

Widget
XmMessageBoxGetChild
	in: XmMessageBoxWidget		# message box widget
	in: (unsigned char)XmChild 	# child reference

~pseudoWidgetClass 
XmMessageDialog
	className XmMessageBox
	createCmd XmCreateMessageDialog
	createsShell

~pseudoWidgetClass
XmOptionMenu
	className XmRowColumn
	createCmd XmCreateOptionMenu

~widgetClass
XmPanedWindow
        include <Xm/PanedW.h>

~pseudoWidgetClass 
XmPopupMenu
	className XmRowColumn
	createCmd XmCreatePopupMenu

~pseudoWidgetClass
XmPromptDialog
	className XmSelectionBox
	createCmd XmCreatePromptDialog
	createsShell

~pseudoWidgetClass 
XmPulldownMenu
	className XmRowColumn
	createCmd XmCreatePulldownMenu

~widgetClass
XmPushButton
	include <Xm/PushB.h>
	activate c int: \
		((XmPushButtonCallbackStruct*)callData)->click_count \
			# click count

~gadgetClass
XmPushButtonGadget
	include <Xm/PushBG.h>
	activateCallback c int: \
		((XmPushButtonCallbackStruct*)callData)->click_count \
			# click count

~pseudoWidgetClass
XmQuestionDialog
	className XmMessageBox
	createCmd XmCreateQuestionDialog
	createsShell

~pseudoWidgetClass 
XmRadioBox
	className XmRowColumn
	createCmd XmCreateRadioBox

~widgetClass 
XmRowColumn
	include <Xm/RowColumn.h>

~widgetClass
XmScale
        include <Xm/Scale.h>
	drag|valueChanged v int: \
		((XmScaleCallbackStruct *)callData)->value # value



~widgetClass
XmScrollBar
        include <Xm/ScrollBar.h>
        toBottom|toTop p int: \
                ((XmScrollBarCallbackStruct *)callData)->pixel # pixel
        decrement|drag|increment|pageDecrement|pageIncrement|toBottom|toTop|valueChanged v int: \
                ((XmScrollBarCallbackStruct *)callData)->value # value

void
XmScrollBarGetValues 
	in: XmScrollBarWidget		# scrollbar widget
	out: int	      		# value (slider position)
        out: int              		# slider size
	out: int              		# increment (smallest movement)
	out: int              		# page increment 

void
XmScrollBarSetValues 
	in: XmScrollBarWidget 		# scrollbar widget
	in: int	              		# value (slider position)
        in: int               		# slider size
	in: int               		# increment (smallest movement)
	in: int               		# page increment 
	in: Boolean           		# notify


~pseudoWidgetClass
XmScrolledList
	className XmList
	createCmd XmCreateScrolledList

~pseudoWidgetClass 
XmScrolledText
	className XmText
	createCmd XmCreateScrolledText

~widgetClass
XmScrolledWindow
        include <Xm/ScrolledW.h>

~widgetClass
XmSelectionBox
        include <Xm/SelectioB.h>
	apply|noMatch|ok s EscapedXmString: \
		((XmSelectionBoxCallbackStruct *)callData)->value # value


~pseudoWidgetClass
XmSelectionDialog
	className XmSelectionBox
	createCmd XmCreateSelectionDialog
	createsShell

~widgetClass 
XmSeparator
	include <Xm/Separator.h>

~gadgetClass 
XmSeparatorGadget
	include <Xm/SeparatoG.h>

~pseudoWidgetClass
XmSimpleCheckBox
	className XmRowColumn
	createCmd XmCreateSimpleCheckBox

~pseudoWidgetClass
XmSimpleMenuBar
	className XmRowColumn
        createCmd XmCreateSimpleMenuBar

~pseudoWidgetClass
XmSimpleOptionMenu
        className XmRowColumn
        createCmd XmCreateSimpleOptionMenu

~pseudoWidgetClass
XmSimplePopupMenu
        className XmRowColumn
        createCmd XmCreateSimplePopupMenu

~pseudoWidgetClass
XmSimplePulldownMenu
        className XmRowColumn
        createCmd XmCreateSimplePulldownMenu

~pseudoWidgetClass
XmSimpleRadioBox
        className XmRowColumn
        createCmd XmCreateSimpleRadioBox

~widgetClass 
XmText
	include <Xm/Text.h>
	addRes pendingDelete Boolean
	addRes selectionArray Pointer
	addRes selectionArrayCount Int
	addRes selectThreshold Int
	addRes blinkRate Int
	addRes columns Short
	addRes cursorPositionVisible Boolean
	addRes fontList FontList
	addRes rows Short
	addRes resizeHeight Boolean
	addRes resizeWidth Boolean
	addRes wordWrap Boolean
	addRes scrollHorizontal Boolean
	addRes scrollLeftSide Boolean
	addRes scrollTopSide Boolean
	addRes scrollVertical Boolean
        losingFocus|modifyVerify|motionVerify i XmTextPosition: \
                ((XmTextVerifyCallbackStruct *)callData)->currInsert \
			# position of insert cursor
        losingFocus|modifyVerify|motionVerify n XmTextPosition: \
                ((XmTextVerifyCallbackStruct *)callData)->newInsert \
			# new position of insert cursor
        losingFocus|modifyVerify f XmTextPosition: \
                ((XmTextVerifyCallbackStruct *)callData)->startPos \
			# startPos (from)
        losingFocus|modifyVerify t XmTextPosition: \
                ((XmTextVerifyCallbackStruct *)callData)-> endPos \
			# endPos (to)
        modifyVerify s EscapedString: \
                ((XmTextVerifyCallbackStruct *)callData)->text->ptr \
			# text

void
XmTextClearSelection
	in: XmTextWidget 	# Text widget
	const: time(NULL)

void
XmTextCopy
	in: XmTextWidget 	# Text widget
	const: time(NULL)

void
XmTextCut
	in: XmTextWidget 	# Text widget
	const: time(NULL)

~widgetClass 
XmTextField
	include <Xm/TextF.h>

void
XmTextFieldClearSelection
	in: XmTextFieldWidget 	# Text field widget
	const: time(NULL)

void
XmTextFieldCopy
	in: XmTextFieldWidget 		# Text field widget
	const: time(NULL)

void
XmTextFieldCut
	in: XmTextFieldWidget 		# Text field widget
	const: time(NULL)

int
XmTextFieldGetBaseline
	in: XmTextFieldWidget 		# Text field widget

XmTextPosition
XmTextFieldGetLastPosition
	in: XmTextFieldWidget 		# Text field widget

String
XmTextFieldGetSelection
	in: XmTextFieldWidget 		# Text field widget
	end: if (!returnVar) XtFree(returnVar);

Boolean
XmTextFieldGetSelectionPosition
	in: XmTextFieldWidget 	# Text field widget
	out: XmTextPosition	# left boundary
	out: XmTextPosition     # right boundary

void
XmTextFieldInsert
	in: XmTextFieldWidget 	# Text field widget
	in: XmTextPosition	# character position
	in: String              # text string to be inserted

void
XmTextFieldPaste
	in: XmTextFieldWidget 	# Text field widget

Boolean
XmTextFieldPosToXY
	in: XmTextFieldWidget 	# Text field widget
	in: XmTextPosition	# character position
	out: Position		# x coord relative to top left
	out: Position		# y coord relative to top left

Boolean
XmTextFieldRemove
	in: XmTextFieldWidget 	# Text field widget

void
XmTextFieldReplace
	in: XmTextFieldWidget 	# Text field widget
	in: XmTextPosition	# from character position
	in: XmTextPosition	# to character position
	in: String 		# insert string

void
XmTextFieldSetAddMode
	in: XmTextFieldWidget 	# Text field widget
	in: Boolean		# true | false

void
XmTextFieldSetHighlight
	in: XmTextFieldWidget 	# Text field widget
	in: XmTextPosition	# from character position
	in: XmTextPosition	# to character position
	in: XmHighlightMode	# NORMAL | SELECTED | SECONDARY_SELECTED

void
XmTextFieldSetSelection
	in: XmTextFieldWidget 	# Text field widget
	in: XmTextPosition	# from character position
	in: XmTextPosition	# to character position
	const: time(NULL)

void
XmTextFieldShowPosition
	in: XmTextFieldWidget 	# Text field widget
	in: XmTextPosition	# character position to display

void
XmTextFieldXYToPos
	in: XmTextFieldWidget 	# Text field widget
	in: Position		# x coord relative to top left
	in: Position		# y coord relative to top left

int
XmTextGetBaseline
	in: XmTextWidget 	# Text widget

XmTextPosition
XmTextGetLastPosition
	in: XmTextWidget 	# Text widget

String
XmTextGetSelection
	in: XmTextWidget 	# Text widget
	end: if (!returnVar) XtFree(returnVar);

Boolean
XmTextGetSelectionPosition
	in: XmTextWidget 	# Text widget
	out: XmTextPosition	# left boundary
	out: XmTextPosition     # right boundary

void
XmTextInsert
	in: XmTextWidget 	# Text widget
	in: XmTextPosition	# character position
	in: String              # text string to be inserted

void
XmTextPaste
	in: XmTextWidget 	# Text widget

Boolean
XmTextPosToXY
	in: XmTextWidget 	# Text widget
	in: XmTextPosition	# character position
	out: Position		# x coord relative to top left
	out: Position		# y coord relative to top left

Boolean
XmTextRemove
	in: XmTextWidget 	# Text widget

void
XmTextReplace
	in: XmTextWidget 	# Text widget
	in: XmTextPosition	# from character position
	in: XmTextPosition	# to character position
	in: String 		# insert string

void
XmTextScroll
	in: XmTextWidget 	# Text widget
	in: int			# number of lines to scroll

void
XmTextSetAddMode
	in: XmTextWidget 	# Text widget
	in: Boolean		# true | false

void
XmTextSetHighlight
	in: XmTextWidget 	# Text widget
	in: XmTextPosition	# from character position
	in: XmTextPosition	# to character position
	in: XmHighlightMode	# NORMAL | SELECTED | SECONDARY_SELECTED

void
XmTextSetSelection
	in: XmTextWidget 	# Text field widget
	in: XmTextPosition	# from character position
	in: XmTextPosition	# to character position
	const: time(NULL)

void
XmTextShowPosition
	in: XmTextWidget 	# Text widget
	in: XmTextPosition	# character position to display

void
XmTextXYToPos
	in: XmTextWidget 	# Text widget
	in: Position		# x coord relative to top left
	in: Position		# y coord relative to top left



~widgetClass 
XmToggleButton
	include <Xm/ToggleB.h>
	valueChangedCallback s int: \
		((XmToggleButtonCallbackStruct *)callData)->set # state

Boolean
XmToggleButtonGetState
	in: XmToggleButtonWidget	# toggle button widget

void
XmToggleButtonSetState
	in: XmToggleButtonWidget	# toggle button widget
	in: Boolean			# state (bool)
	in: Boolean             	# notify (bool)

~gadgetClass 
XmToggleButtonGadget
	include <Xm/ToggleBG.h>
	valueChangedCallback s int: \
		((XmToggleButtonCallbackStruct *)callData)->set # state

Boolean
XmToggleButtonGadgetGetState
	in: XmToggleButtonGadget	# toggle button widget

void
XmToggleButtonGadgetSetState
	in: XmToggleButtonGadget	# toggle button gadget
	in: Boolean			# state (bool)
	in: Boolean             	# notify (bool)

#### Misc Widget Functions ####

void
XmAddTabGroup
	in: Widget        		# widget to be added

~pseudoWidgetClass
XmWarningDialog
        className XmMessageBox
        createCmd XmCreateWarningDialog
	createsShell

~pseudoWidgetClass
XmWorkingDialog
        className XmMessageBox
        createCmd XmCreateWorkingDialog
	createsShell

