/* Copyright (C) 1992 by Gustaf Neumann, Stefan Nusser

 *      Wirtschaftsuniversitaet Wien, 
 *      Abteilung fuer Wirtschaftsinformatik
 *      Augasse 2-6, 
 *      A-1090 Vienna, Austria
 *      neumann@wu-wien.ac.at, nusser@wu-wien.ac.at

 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided
 * that the above copyright notice appears in all copies and that both that
 * copyright notice and this permission notice appear in all supporting
 * documentation.  This software is provided "as is" without expressed or
 * implied warranty.

 * Creation: Sun Jan 23 03:51:12 EST 1994 on syllog2.watson.ibm.com
 * Author: genc
 * Version: 0.95999999999999996

 */
#ifdef MOTIF12

#define MOTIF12_C

#include "wafe.h"
#include <Xm/Xm.h>
#include <X11/Shell.h>

/* 
 * ******* begin required file <motif12.inc> *******
 */
/* make emcas happy -*-C-*-  make emacs happy */

#include <ctype.h>
#include <Xm/AtomMgr.h>

#include <Xm/DragDrop.h>

extern XmString stringToXmString(
#if NeedFunctionPrototypes
    char *
#endif
);

extern char * xmString2String(
#if NeedFunctionPrototypes
    char *, XmString
#endif
);

static Widget currentDragContext;

#define	Done(type, value) \
	{							\
	    if (toVal->addr != NULL) {				\
		if (toVal->size < sizeof(type)) {		\
		    toVal->size = sizeof(type);			\
		    return False;				\
		}						\
		*(type*)(toVal->addr) = (value);		\
	    }							\
	    else {						\
		static type static_val;				\
		static_val = (value);				\
		toVal->addr = (XtPointer)&static_val;		\
	    }							\
	    toVal->size = sizeof(type);				\
	    return True;					\
	}

void
callbackProc(w, clientData, callData)
Widget w;
XtPointer clientData;
XtPointer callData;
    {
    XmAnyCallbackStruct *cbs = (XmAnyCallbackStruct *)callData;
    if (cbs->reason == XmCR_DROP_MESSAGE)
	{
	XmDropProcCallbackStruct *drop_cbs =
	    (XmDropProcCallbackStruct *)callData;
	char *cmd;
	/*fprintf(stderr,"dropProc: getting attriblist of <%s>\n",XtName(w));*/
	cmd = (char *)MMgetValue(MMgetAttribList(w,True), qdropProc);
	/*fprintf(stderr,"in callbackProc, dropProc, widget = %p <%s> cmd=<%s>\n",
		w,XtName(w),cmd+sizeof(XrmQuark));
         */
	execCallbackProc(drop_cbs->dragContext, (XtPointer)cmd, callData);
	}
    }


Boolean
convertSelectionIncrProc(w, selection, target, type, value, length, format,
			 max_length, client_data, request_id)
Widget        w;
Atom          *selection;
Atom          *target;
Atom          *type;
XtPointer     *value;
unsigned long *length;
int           *format;
unsigned long *max_length;
XtPointer     client_data;
XtRequestId   *request_id;
    {
    Boolean result;
    if (XtClass(w) == xmDragContextClass)
	{
	Display *dpy       = XtDisplay(w);
	Atom COMPOUND_TEXT = XmInternAtom(dpy, "COMPOUND_TEXT", False);
	Atom DELETE        = XmInternAtom(dpy, "DELETE", False);
	Atom TARGETS       = XmInternAtom(dpy, "TARGETS", False);
	char **cd, *cmd, *targetName = NULL;
	
	if (! *selection == XmInternAtom(dpy, "_MOTIF_DROP", False))
	    return False;  /* it looks as if this was not for us! */

	/* if there is a command for the convert procedure registered,
	   call it and provide the target as callData; this is necessary
	   for the DELETE target in DROP_MOVE command
	 */
	if ((cmd = (char *)MMgetValue(MMgetAttribList(w,True), qconvertProc)))
	    {
	    targetName = XGetAtomName(dpy,*target);
	    execCallbackProc(w, (XtPointer)cmd, targetName);
	    }
	    
	if (*target == COMPOUND_TEXT)
	    {
	    XmString t;

	    /* we pass the text via the clientData resource */
	    XtVaGetValues(w, XmNclientData, &cd, NULL);
	    
	    if (!cd || !*cd )
		{
		fprintf(stderr,"Wafe(%s): invalid clientData\n","convertSelectionIncrProc");
		if (targetName) XFree(targetName);
		return False;
		}

	    t = stringToXmString(*cd);
	    /* it is wierd that the returned compound text is of type
               char* since - as it looks to me - CT can have inbedded
               nulls, which will cause truncations on strlen etc 
             */
	    *type = *target;
	    *value = (XtPointer)XmCvtXmStringToCT(t);
	    *length = (unsigned long)(strlen(*value)+1);

	    XmStringFree(t);
	    *format = 8;
	    result = True;
	    }
	else 
	if (*target == DELETE)
	    {
	    if (!cmd) 
		fprintf(stderr,"Wafe(%s): no convertProc registered for a DROP_MOVE operation\n",
			"convertSelectionIncrProc");

	    *type = XmInternAtom(dpy, "NULL", False);
	    *value = NULL;
	    *length = 0;
	    *format = 8;
	    result = True;
	    }
	else 
        if (*target == TARGETS)  /* This target is required by ICCC */
	    {
	    int target_count = 0;
	    Atom *targs = (Atom *)XtMalloc((unsigned) (6 * sizeof(Atom)));
	    *value = (XtPointer) targs;

	    /* if targets are added, increase the constant in malloc! */
	    *targs++ = COMPOUND_TEXT;
	    target_count++;
	    *targs++ = DELETE;
	    target_count++;
	    *targs++ = TARGETS;
	    target_count++;
	    *targs++ = XmInternAtom(dpy, "MULTIPLE", False);
	    target_count++;  /* supported in the Intrinsics */
	    *targs++ = XmInternAtom(dpy, "TIMESTAMP", False);
	    target_count++; /* supported in the Intrinsics */
	    
	    *type = XA_ATOM;
	    *length = (target_count * sizeof(Atom)) >> 2;
	    *format = 32;
            }
	else
	    {
	    if (!targetName) targetName = XGetAtomName(dpy,*target);
	    fprintf(stderr,"Wafe(%s): unknown target %s\n",
		    "convertSelectionIncrProc",targetName);
	    result = False;
	    }

	if (targetName) XFree(targetName);
	}
    return result;
    }

void
selectionCallbackProc (w, closure, selection, type, value, length, format)
Widget          w;
XtPointer       closure;
Atom*           selection;
Atom*           type;
XtPointer       value;
unsigned long*  length;
int*            format;
    {
    if (XtClass(w) == xmDropTransferObjectClass)
	{
	dropTransferCallbackStruct dtCbs;
	Atom COMPOUND_TEXT, TEXT, FILE_NAME, A_NULL;
	XmDropTransferEntryRec *dropTransferEntries;
	char *cmd;
	Display *dpy;

	if (!currentDragContext)
	    return;   /* to avoid surprises... */
	
	dpy = XtDisplay(currentDragContext);
	if (! *selection == XmInternAtom(dpy, "_MOTIF_DROP", False))
	    return;   /* to avoid surprises... */

	if (!(cmd = (char *)MMgetValue(MMgetAttribList(w,True), qtransferProc)))
	    {
	    fprintf(stderr,"Wafe(%s): no transferProc registered\n","selectionCallbackProc");
	    return;
	    }

	XtVaGetValues(w, XmNdropTransfers,&dropTransferEntries, NULL);
	
	COMPOUND_TEXT = XInternAtom(dpy,"COMPOUND_TEXT", False);
	TEXT          = XInternAtom(dpy,"TEXT", False);
	FILE_NAME     = XInternAtom(dpy,"FILE_NAME", False);
	A_NULL        = XInternAtom(dpy,"NULL", False);
	dtCbs.dest    = (String)dropTransferEntries->client_data;

	if (*type == COMPOUND_TEXT)
	    {
	    XmString t = XmCvtCTToXmString(value);
	    dtCbs.value = xmString2String(NULL,t);
/*
	    fprintf(stderr,"+ in callbackProc, transferProc, widget = %p <%s> cmd=<%s>, <%s> <%s>\n",
		    w,XtName(w),cmd+sizeof(XrmQuark),dtCbs.value,value);
 */
	    execCallbackProc(w, (XtPointer)cmd, &dtCbs);
	    XtFree(dtCbs.value);
	    XmStringFree(t);
	    }
	else 
	if ((*type == XA_STRING) || (*type == TEXT) || (*type == FILE_NAME))
	    {
	    dtCbs.value = XtMalloc(*length + 1);
	    memcpy(dtCbs.value, value, *length);
	    *((char*)(dtCbs.value) + *length) = '\0';
 	    }
	else
	if (*type == XT_CONVERT_FAIL)
	    {
	    fprintf(stderr,"Wafe(%s): conversion failed\n","selectionCallbackProc");
	    }
	else 
	if (*type != A_NULL && (*type != 0))
	    {
	    char *p;
            p = XGetAtomName(dpy,*type);
	    fprintf(stderr,"Wafe(%s): unknown type %s\n","selectionCallbackProc",p);
	    if (p) XFree(p);
	    }
	}
    }


Boolean
CvtStringToCallbackProc(dpy, args, num_args, fromVal, toVal,
		    converter_data)
Display *dpy;
XrmValue *args;
Cardinal *num_args;
XrmValue *fromVal;
XrmValue *toVal;
XtPointer *converter_data;
    {
    char *charp = XtMalloc(strlen(fromVal->addr)+1+sizeof(XrmQuark));

    *(XrmQuark *)charp = wafeCurrentAttrib;
    strcpy((char *)charp + sizeof(XrmQuark), (char *)fromVal->addr);

    MMreplace(wafeCurrentAttribList, wafeCurrentAttrib,
	      (char *)charp, XtFree);
    Done(XtCallbackProc, &callbackProc);
    }


Boolean
CvtStringToDragOperations(dpy, args, num_args, fromVal, toVal, converter_data)
Display *dpy;
XrmValue *args;
Cardinal *num_args;
XrmValue *fromVal;
XrmValue *toVal;
XtPointer *converter_data;
    {
    unsigned char result = '\0';
    char *p=strtok(fromVal->addr,"|");
    do
	{
	if (!strcmp("DROP_COPY",p))
	    result |= XmDROP_COPY;
	else 
	if (!strcmp("DROP_MOVE",p))
	    result |= XmDROP_MOVE;
	else 
	if (!strcmp("DROP_LINK",p))
	    result |= XmDROP_LINK;
	else 
	if (!strcmp("DROP_NOOP",p))
	    result = XmDROP_NOOP;
	else
	    return False;
	}
    while ((p = strtok(NULL,"|")));
    Done(unsigned char, result);
    }

Boolean
CvtStringToTransferStatus(dpy, args, num_args, fromVal, toVal, converter_data)
Display *dpy;
XrmValue *args;
Cardinal *num_args;
XrmValue *fromVal;
XrmValue *toVal;
XtPointer *converter_data;
    {
    unsigned char result = '\0';
    char *p = fromVal->addr;

    if (!strcmp("TRANSFER_SUCCESS",p))
	result = XmTRANSFER_SUCCESS;
    else 
    if (!strcmp("TRANSFER_FAILURE",p))
	result = XmTRANSFER_FAILURE;
    else
	return False;

    Done(unsigned char, result);
    }


Boolean
CvtStringToConvertSelectionIncrProc(dpy, args, num_args, fromVal, toVal,
		    converter_data)
Display *dpy;
XrmValue *args;
Cardinal *num_args;
XrmValue *fromVal;
XrmValue *toVal;
XtPointer *converter_data;
    {
    char *charp = XtMalloc(strlen(fromVal->addr)+1+sizeof(XrmQuark));

    *(XrmQuark *)charp = wafeCurrentAttrib;
    strcpy((char *)charp + sizeof(XrmQuark), (char *)fromVal->addr);

    MMreplace(wafeCurrentAttribList, wafeCurrentAttrib,
	      (char *)charp, XtFree);
    return True;
    }


Boolean
CvtStringToSelectionCallbackProc(dpy, args, num_args, fromVal, toVal,
		    converter_data)
Display *dpy;
XrmValue *args;
Cardinal *num_args;
XrmValue *fromVal;
XrmValue *toVal;
XtPointer *converter_data;
    {
    char *charp = XtMalloc(strlen(fromVal->addr)+1+sizeof(XrmQuark));

    *(XrmQuark *)charp = wafeCurrentAttrib;
    strcpy((char *)charp + sizeof(XrmQuark), (char *)fromVal->addr);

    MMreplace(wafeCurrentAttribList, wafeCurrentAttrib,
	      (char *)charp, XtFree);
    Done(XtCallbackProc, &selectionCallbackProc);
    }

XmDropTransferEntryRec *
string2transferEntryRec(string,dpy)
char * string;
Display *dpy;
    {
    char **argv, **p, **innerArgv;
    int argc, count, n;
    XmDropTransferEntryRec *entries, *dropRecs;
	
    if (Tcl_SplitList(wafeInterpreter, string, &argc, &argv) == TCL_ERROR)
	{
	fprintf(stderr,"Wafe(%s): %s\n","CvtToDropTransfer",wafeInterpreter->result);
	return False;
	}
    count = argc;

    dropRecs = entries = (XmDropTransferEntryRec*)XtMalloc(sizeof(XmDropTransferEntryRec)*count);
    for (p = argv; count>0; count--,p++)
	{
	if (Tcl_SplitList(wafeInterpreter, *p, &n, &innerArgv) == TCL_ERROR)
	    {
	    fprintf(stderr,"Wafe(%s): %s\n","CvtToDropTransferArg",
		    wafeInterpreter->result);
	    XtFree((char *)argv);
	    return NULL;
	    }
	if (n != 2)
	    {
	    fprintf(stderr,"Wafe(%s): %s\n","CvtToDropTransferArg",
		    "DropTransferRec should have two elements!");
	    XtFree((char *)argv);
	    return NULL;
	    }
	entries->target = XInternAtom(dpy, innerArgv[0], False);
	entries->client_data = cvtName2Widget(innerArgv[1],True,NULL,NULL);
	entries++;
	XtFree((char *)innerArgv);
	}
    XtFree((char *)argv);
    return dropRecs;
    }


Boolean
CvtStringToDropTransfers(dpy, args, num_args, fromVal, toVal,
		    converter_data)
Display *dpy;
XrmValue *args;
Cardinal *num_args;
XrmValue *fromVal;
XrmValue *toVal;
XtPointer *converter_data;
    {
    XmDropTransferEntryRec *dropRecs;
    if (!(dropRecs = string2transferEntryRec(fromVal->addr,dpy)))
	return False;
    
    MMreplace(wafeCurrentAttribList, wafeCurrentAttrib,
	      (char *)dropRecs, XtFree);
    Done(XmDropTransferEntryRec*, dropRecs);
    }



void
CBfreeAttribs(w, client_data, call_data)
Widget w;
caddr_t client_data;
caddr_t call_data;
    {
    (void)MMfreeGarbage(w);
    }


/* 
 * ******* end required file <motif12.inc> *******
 */
#include <Xm/DragDrop.h>

#include <Xm/DragDrop.h>
#define convertSpecialResources(command,w,class,argc,argv) {ArgList           args; int               numArgs; XtInitializeWidgetClass(class); if (convert(ParentWidget(w), class, argv, &argc, &args, &numArgs, w)) { command(w, args, numArgs); wafeCurrentAttribList = NULL; XtFree((String)args); } }

/* 
 * void
 * convertSpecialResources vulgo XmDropSiteRegister 
 * 	const: XmDropSiteRegister
 * 	in: Widget		# Widget to be registered
 * 	const: xmDropSiteManagerObjectClass
 * 	in: [args avp]          # drop site resources
 */

int 
com_XmDropSiteRegister(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     Boolean freeArgv = False;
     char **argvArg;

     DBUG_ENTER("XmDropSiteRegister");  

     if (argc < 3) 
	 {
	 argcError("XmDropSiteRegister","at least ",2,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 = (Widget) name2Widget(argv[1])))
          {
          convError("XmDropSiteRegister","2",argv[1],"Widget");
          DBUG_RETURN (TCL_ERROR);
          }

     argc -= 2;
     argvArg = &argv[2];
     if (argc == 1)
        {
        if (mergeArguments(argv[2],"XmDropSiteRegister",&argc,&argvArg))
           freeArgv = True;
        else 
           DBUG_RETURN (TCL_ERROR);
        }
     if (argc%2)
        {
        argcError("XmDropSiteRegister","even number of arguments such as 2 or ",4,argc+1);
        if (freeArgv) XtFree((char*)argvArg);
        DBUG_RETURN (TCL_ERROR);
        }

     convertSpecialResources(XmDropSiteRegister,localVar1,xmDropSiteManagerObjectClass,argc,argvArg);
     if (freeArgv) XtFree((char *)argvArg);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * convertSpecialResources vulgo XmDropSiteUpdate
 * 	const: XmDropSiteUpdate
 * 	in: Widget		# Drop site to be modified
 * 	const: xmDropSiteManagerObjectClass
 * 	in: [args avp]          # drop site resources
 */

int 
com_XmDropSiteUpdate(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     Boolean freeArgv = False;
     char **argvArg;

     DBUG_ENTER("XmDropSiteUpdate");  

     if (argc < 3) 
	 {
	 argcError("XmDropSiteUpdate","at least ",2,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 = (Widget) name2Widget(argv[1])))
          {
          convError("XmDropSiteUpdate","2",argv[1],"Widget");
          DBUG_RETURN (TCL_ERROR);
          }

     argc -= 2;
     argvArg = &argv[2];
     if (argc == 1)
        {
        if (mergeArguments(argv[2],"XmDropSiteUpdate",&argc,&argvArg))
           freeArgv = True;
        else 
           DBUG_RETURN (TCL_ERROR);
        }
     if (argc%2)
        {
        argcError("XmDropSiteUpdate","even number of arguments such as 2 or ",4,argc+1);
        if (freeArgv) XtFree((char*)argvArg);
        DBUG_RETURN (TCL_ERROR);
        }

     convertSpecialResources(XmDropSiteUpdate,localVar1,xmDropSiteManagerObjectClass,argc,argvArg);
     if (freeArgv) XtFree((char *)argvArg);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XmDropSiteUnregister
 * 	in: Widget		# Widget to be unregistered
 */

int 
com_XmDropSiteUnregister(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;

     DBUG_ENTER("XmDropSiteUnregister");  

     if (argc != 2) 
	 {
	 argcError("XmDropSiteUnregister","",1,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 = (Widget) name2Widget(argv[1])))
          {
          convError("XmDropSiteUnregister","1",argv[1],"Widget");
          DBUG_RETURN (TCL_ERROR);
          }

     XmDropSiteUnregister(localVar1);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XmDropSiteStartUpdate
 * 	in: Widget		# Widget to identify shell with multiple drop sites
 */

int 
com_XmDropSiteStartUpdate(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;

     DBUG_ENTER("XmDropSiteStartUpdate");  

     if (argc != 2) 
	 {
	 argcError("XmDropSiteStartUpdate","",1,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 = (Widget) name2Widget(argv[1])))
          {
          convError("XmDropSiteStartUpdate","1",argv[1],"Widget");
          DBUG_RETURN (TCL_ERROR);
          }

     XmDropSiteStartUpdate(localVar1);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XmDropSiteEndUpdate
 * 	in: Widget		# Widget to identify shell with multiple drop sites
 */

int 
com_XmDropSiteEndUpdate(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;

     DBUG_ENTER("XmDropSiteEndUpdate");  

     if (argc != 2) 
	 {
	 argcError("XmDropSiteEndUpdate","",1,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 = (Widget) name2Widget(argv[1])))
          {
          convError("XmDropSiteEndUpdate","1",argv[1],"Widget");
          DBUG_RETURN (TCL_ERROR);
          }

     XmDropSiteEndUpdate(localVar1);

     DBUG_RETURN (TCL_OK);
     }     


#define createDnDWidget4(c,w,x,y) c(w,args,numArgs)
#define createDnDWidget5(c,w,e,x,y) c(w,e,args,numArgs)

/* 
 * WidgetID (WidgetID)
 * createDnDWidget4 vulgo XmDropTransferStart
 *         pre: { ArgList args; int numArgs; currentDragContext = localVar1; convert(localVar1,xmDropTransferObjectClass,argvArg,&argc,&args,&numArgs, NULL);
 *         const: XmDropTransferStart
 * 	in: Widget		# Drag Context
 * 	in: [args avp]          # Drop Transfer Resources
 *         post: MMsetAttribList((Widget)returnVar); wafeCurrentAttribList = NULL; XtAddCallback((Widget)returnVar,XtNdestroyCallback,CBfreeAttribs,NULL); XtFree((char*)args); }
 */

int 
com_XmDropTransferStart(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     Boolean freeArgv = False;
     char **argvArg;
     WidgetID returnVar;
     char conversionBuffer[100];

     DBUG_ENTER("XmDropTransferStart");  

     if (argc < 3) 
	 {
	 argcError("XmDropTransferStart","at least ",2,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 = (Widget) name2Widget(argv[1])))
          {
          convError("XmDropTransferStart","2",argv[1],"Widget");
          DBUG_RETURN (TCL_ERROR);
          }

     argc -= 2;
     argvArg = &argv[2];
     if (argc == 1)
        {
        if (mergeArguments(argv[2],"XmDropTransferStart",&argc,&argvArg))
           freeArgv = True;
        else 
           DBUG_RETURN (TCL_ERROR);
        }
     if (argc%2)
        {
        argcError("XmDropTransferStart","even number of arguments such as 2 or ",4,argc+1);
        if (freeArgv) XtFree((char*)argvArg);
        DBUG_RETURN (TCL_ERROR);
        }

     { ArgList args; int numArgs; currentDragContext = localVar1; convert(localVar1,xmDropTransferObjectClass,argvArg,&argc,&args,&numArgs, NULL);
     returnVar = (WidgetID) createDnDWidget4(XmDropTransferStart,localVar1,argc,argvArg);
     MMsetAttribList((Widget)returnVar); wafeCurrentAttribList = NULL; XtAddCallback((Widget)returnVar,XtNdestroyCallback,CBfreeAttribs,NULL); XtFree((char*)args); }
     if (freeArgv) XtFree((char *)argvArg);

     sprintf(conversionBuffer, "%ld", returnVar);
     Tcl_SetResult(comInterpreter, conversionBuffer, TCL_VOLATILE);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * WidgetID (WidgetID)
 * createDnDWidget5 vulgo XmDragStart
 *         pre: { ArgList args; int numArgs; convert(localVar1,xmDragContextClass,argvArg,&argc,&args,&numArgs, NULL);
 *         const: XmDragStart
 * 	in: Widget		# Widget (source for drag and drop)
 * 	const: wafeCurrentEvent
 * 	in: [args avp]          # Drag Context Resources
 *         post: MMsetAttribList((Widget)returnVar); wafeCurrentAttribList = NULL; XtAddCallback((Widget)returnVar,XtNdestroyCallback,CBfreeAttribs,NULL); XtVaSetValues((Widget)returnVar,XmNconvertProc,convertSelectionIncrProc); XtFree((char*)args); }
 */

int 
com_XmDragStart(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     Boolean freeArgv = False;
     char **argvArg;
     WidgetID returnVar;
     char conversionBuffer[100];

     DBUG_ENTER("XmDragStart");  

     if (argc < 3) 
	 {
	 argcError("XmDragStart","at least ",2,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 = (Widget) name2Widget(argv[1])))
          {
          convError("XmDragStart","2",argv[1],"Widget");
          DBUG_RETURN (TCL_ERROR);
          }

     argc -= 2;
     argvArg = &argv[2];
     if (argc == 1)
        {
        if (mergeArguments(argv[2],"XmDragStart",&argc,&argvArg))
           freeArgv = True;
        else 
           DBUG_RETURN (TCL_ERROR);
        }
     if (argc%2)
        {
        argcError("XmDragStart","even number of arguments such as 2 or ",4,argc+1);
        if (freeArgv) XtFree((char*)argvArg);
        DBUG_RETURN (TCL_ERROR);
        }

     { ArgList args; int numArgs; convert(localVar1,xmDragContextClass,argvArg,&argc,&args,&numArgs, NULL);
     returnVar = (WidgetID) createDnDWidget5(XmDragStart,localVar1,wafeCurrentEvent,argc,argvArg);
     MMsetAttribList((Widget)returnVar); wafeCurrentAttribList = NULL; XtAddCallback((Widget)returnVar,XtNdestroyCallback,CBfreeAttribs,NULL); XtVaSetValues((Widget)returnVar,XmNconvertProc,convertSelectionIncrProc); XtFree((char*)args); }
     if (freeArgv) XtFree((char *)argvArg);

     sprintf(conversionBuffer, "%ld", returnVar);
     Tcl_SetResult(comInterpreter, conversionBuffer, TCL_VOLATILE);

     DBUG_RETURN (TCL_OK);
     }     


#else
#include "wafe.h"
#endif

void
Initialize_Xm12Gen()
{
#ifdef MOTIF12
 createWidgetCommand("XmDropSiteManager",xmDropSiteManagerObjectClass,NULL,False);
 createWidgetCommand("XmDragContext",xmDragContextWidgetClass,NULL,False);
 createWidgetCommand("XmDropTransfer",xmDropTransferObjectClass,NULL,False);
#ifdef MOTIF12
 strcat(wafePackages,"MOTIF12 ");
#endif
 XtSetTypeConverter(XtRString, "DropTransfers",
	(XtTypeConverter)CvtStringToDropTransfers, 
	NULL, 0, XtCacheNone, NULL);
 XtSetTypeConverter(XtRString, "CallbackProc",
	(XtTypeConverter)CvtStringToCallbackProc, 
	NULL, 0, XtCacheNone, NULL);
 XtSetTypeConverter(XtRString, "SelectionCallbackProc",
	(XtTypeConverter)CvtStringToSelectionCallbackProc, 
	NULL, 0, XtCacheNone, NULL);
 XtSetTypeConverter(XtRString, "ConvertSelectionIncrProc",
	(XtTypeConverter)CvtStringToConvertSelectionIncrProc, 
	NULL, 0, XtCacheNone, NULL);
 XtSetTypeConverter(XtRString, "DragOperations",
	(XtTypeConverter)CvtStringToDragOperations, 
	NULL, 0, XtCacheNone, NULL);
 XtSetTypeConverter(XtRString, "DropSiteOperations",
	(XtTypeConverter)CvtStringToDragOperations, 
	NULL, 0, XtCacheNone, NULL);
 XtSetTypeConverter(XtRString, "TransferStatus",
	(XtTypeConverter)CvtStringToTransferStatus, 
	NULL, 0, XtCacheNone, NULL);
 qdragProc = WafePermStringToQuark("dragProc");
 qdropProc = WafePermStringToQuark("dropProc");
 qtransferProc = WafePermStringToQuark("transferProc");
 qconvertProc = WafePermStringToQuark("convertProc");
 qclientData = WafePermStringToQuark("clientData");
 Tcl_CreateCommand(wafeInterpreter, "XmDropSiteRegister", com_XmDropSiteRegister, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XmDropSiteUpdate", com_XmDropSiteUpdate, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XmDropSiteUnregister", com_XmDropSiteUnregister, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XmDropSiteStartUpdate", com_XmDropSiteStartUpdate, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XmDropSiteEndUpdate", com_XmDropSiteEndUpdate, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XmDropTransferStart", com_XmDropTransferStart, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XmDragStart", com_XmDragStart, NULL, NULL);

#else
#endif
}
